#modname "This Ain't Sombre's Warhammer Version 0.73"
#description "Important: Only enable either Sombre Warhammer Current Version or one Sombre Warhammer Static Version at a time. If you're playing a multiplayer game I STRONGLY recommend using the Static version, or you risk the game breaking if I update the mod.

Adds a selection of 24 Warhammer nations to the Middle Age. 23 either entirely created or extensively updated for Dominions 6 by Sombre and 1 nation created by Sasooli. The nations added here and their titles ingame are:
Beastmen (Beastlands)
Bretonnia (Bretonnia)
Chaos Dwarfs (Zharr-Naggrund)
Dark Elves (Naggarond)
Dwarfs (Karaz-a-Karak)
Khorne (Khorne)
Kislev (Kislev)
The Empire (Altdorf)
The Empire (Nuln)
The Empire (Middenheim)
Greenskins (Black Crag)
Greenskins (Bone Nose Tribe)
High Elves (Ulthuan)
Lizardmen (Itza)
Norsca (Norsca)
Nurgle (Nurgle)
Ogre Kingdoms (Goldtooth Tribe)
Skaven (Skavenblight)
Slaanesh (Slaanesh)
Tilea (Tilea)
Tomb Kings (Nehekhara)
Undead (Nagashizzar)
Vampires (Vampiria)
Wood Elves (Athel Loren)

Additional credit for borrowed sprites from Sturm, Executor, Llamabest, Burnsaber, Deathjester, Mormacil.

Compatibility: This mod uses a wide range of monster, site, weapon, armour, montag, nametype, nation etc IDs. Consequently it is very unlikely to be compatible with other mods which add substantive content. No effort has been made to avoid IDs used by other mods. It is guaranteed to be compatible with LA Warka and of course with the Sombre Warhammer Poptype mod."

#icon "logo.tga"

#version 0.73

---- known bugs

--quadruped - this seems to somehow break head protection given by barding, this will hopefully be fixed
--mounted immortals do not respawn properly
--mounted troops with forest shape have issues being 'used up' for recruitment discounts
--onlymnr doesn't work for battle spells
--beam style breath weapons don't seem to work correctly on mounts, e.g. sun dragon moon dragon

-- need to clean up weapons that are no longer used - mostly things with nostr tag

-- middenheim could use a bit more work, ferocity, holding territory, so on
-- chaos factions could maybe get H1 on their exalts and H2 on their lords? This would need a bunch of events to do.

-- possibly equalise combat speeds of chaos warriors? This would involve making the shield ones faster AP

-- grand communions for lizardmen? Slann only probably. Could also be for dark elves, wood elves, high elves, light mages

-- add virtues as misc items to Bretonnia - these can be things earned via xp and attached to the appropriate commander in an additional misc slot, cursed etc
-- these are covered in the army book, complete with shields bearing the relevant images

-- skaven will get a favour system. Each faction will have a variable that increments when you do a thing they like and can decay naturally.
-- If the variable is positive you may get a couple of rewards per faction which use up some points and give you something
-- If the variable is below -10 (checked by adding 10, checking if variable is still negative, then subtracting 10) then you may get a punishment
-- possible factions: Skryre, Pestilens, Grey Seers, Moulder, Eshin, Mors, Rictus, Skab
-- possible positive actions: Build lab/temple/fort, hire the faction commander, assassination order, dedicate fort to them, take capital, spread plague (if implemented for pestilens), spread dominion, spy on stuff


-- event message character limit is 1400


----- Changelog


-- version 1.1



------------ SUBMOD UPDATES ------------



-- POPTYPE -- Poptypes no longer add recruitables, these are now always available foreign recruitment (to fix longstanding bug around forts)



---------- NEW CONTENT ------------

-- BEASTMEN -- Ghorros Warhoof added as national hero, with new Black Centigor bodyguard troop

-- KHORNE -- Arbaal the Undefeated added as national hero on great flesh hound mount

-- KISLEV -- Ulrika the vampire added as national hero

-- NORSCA -- A blood summon spell for each basic Chaos Daemon (Bloodletter, Daemonette, Blue Horror, Plaguebearer)

-- NULN -- Magnus the Pious added as national hero

-- TZEENTCH -- Vilitch the Curseling added as national hero

-- TZEENTCH -- The nameless Changeling added as national hero

-- TZEENTCH -- Melekh the Changer added as national hero

-- VAMPIRES -- Neferata the Lahmian Progenitor added as national hero

-- WOOD ELVES -- Drycha the Briarmaven of Woe added as national hero





------------ CHANGES ------------

-- ALL -- Various basic recruitment options added to each nation as foreign recruitment, so you can always use national troops and commanders
-- ALL -- When a lord is promoting to a daemon prince they are less likely to fail if your prophet
-- ALL -- Chaos plate armour and chaos helm resource cost increased somewhat
-- BEASTMEN -- Khazrak's arrival event now grants some bestigor
-- BEASTMEN -- Bestigor given the bodyguard tag to help protect vs assassins (more of an issue since you have no forts)
-- DWARFS -- Thorek's air path reduced 2->1
-- DWARFS -- Bugman and his rangers got snow move
-- CHAOS DWARFS -- Bull Centaur gold cost increased 65 -> 70 (a slight nerf for a rather scary sacred on a more minor power nation)
-- CHAOS DWARFS -- Hobgoblins made slightly stronger (str value) across the board
-- DARK ELVES -- Rakarth's whip ID fixed
-- KHORNE -- Forsaken Warrior and Forsaken Marauder berserk values increased
-- LIZARDMEN -- One who fathomed the depths earth and air paths reduced 3->2
-- LIZARDMEN -- One who fired the earth had earth path reduced 4->3
-- LIZARDMEN -- One who guided the spheres had earth and glamour paths slightly increased
-- LIZARDMEN -- Third generation slann fire path decreased by 1
-- NORSCA -- Reavers downgraded to bone helmet instead of magical skullface armour
-- NURGLE -- Kugath's swallow attack no longer aoe1, can be dodged
-- OGRES -- Mawgut's swallow attack no longer aoe1, can be dodged, no longer mindless, gains berserk
-- SLAANESH -- Chaos Troll resource cost increased somewhat
-- TOMB KINGS -- Tomb Scorpion pincer now untyped damage
-- TOMB KINGS -- Necropolis Knights recruitable 2 per month, any fort with temple and lab and dom6+
-- TOMB KINGS -- Knights of the Necropolis spell moved from 5 for 2 -> to 7 for 3
-- TZEENTCH -- Multihero preview site fixed
-- TZEENTCH -- Added header that was missing from some gate events
-- TZEENTCH -- Blade of Blue Fire named correctly
-- TZEENTCH -- Chosen Warrior gold cost +10
-- TZEENTCH -- Chances of getting a spawn from commander promotions increased from 15->20% (Tzeentch loves spawn)
-- TZEENTCH -- Acolyte gold cost increased by 10
-- TZEENTCH -- Contact herald gem cost reduced to 27
-- TZEENTCH -- Some event messages lacked useful headers, fixed
-- TZEENTCH -- Some summons made easier to cast in terms of path requirements
-- TZEENTCH -- Steeds of chosen knights get +1 MR, true sight
-- TZEENTCH -- Forsaken Marauder mapmove equalised with marauders (10->12 effectively)
-- TZEENTCH -- Screamer hp increased by 5
-- TZEENTCH -- Screamer gets +1 att and str and +5 shock res
-- TZEENTCH -- Labs outside dominion no longer sacrificed if you have unlocked all 8 gates (you don't need secrets any more)
-- TZEENTCH -- Number of daemons generated by later gates slightly increased
-- TZEENTCH -- Flamers use less fatigue per ranged attack
-- TZEENTCH -- Sorcerer lords now inspiring researcher 1, gold cost slightly increased
-- TZEENTCH -- Acolytes are now sacred, gold cost increased, no longer have W in random (partly to help research efficiency, partly to help blood hunting, partly to encourage mage bless)

-- version 1.08

------------ SUBMOD UPDATES ------------
-- STARTING FORCE BOOSTER -- There was a bad monster ID here causing a crash to desktop for games involving Naggarond, this is now fixed

------------ NEW CONTENT ------------
-- BEASTLANDS -- Added two types of giant as forest recruits

------------ CHANGES ------------
-- DWARFS -- Message about collapsing a lost reserve will no longer happen if the cap site is fully upgraded, however the site will be removed (since upgrade fully complete)
-- BRETONNIA -- Mages get increased mr (they have actual magic res in whfb)
-- HIGH ELVES -- High mage leadership fixed
-- NULN -- Steam Tank prot slightly reduced, fire and cold res 5 removed, steam aoe attack damage reduced, gold cost increased by 5, resource cost slightly increased
-- NULN -- Steam Tank's jet of steam weapon fixed (mostly used to repel)
-- NURGLE -- Truncated event message fixed
-- SLAANESH -- Styrkaar's unmounted sprite fixed
-- SLAANESH -- Chaos warriors were turning into nurgle chaos warriors when promoted, fixed. Also fixed bug where they would all be shield and sword warriors, not glaives
-- TOMB KINGS -- Skeletal mounts have poor amphibian


-- version 1.07

------------ NEW CONTENT ------------
-- BEASTLANDS -- Malagor the Dark Omen added as a hero
-- NORSCA -- Warrior of Chaos Undivided added to the special second cap site
-- NORSCA -- On foot Sword of Chaos Warrior added to the special second cap site
-- NORSCA -- Crom the Conqueror added as a hero
-- NURGLE -- New hero Ku'gath Plaguefather, along with Pestilent Nurgling troop
-- NURGLE -- New unique plague of Bursting Boils, triggered and spread by Ku'gath
-- SLAANESH -- Sigvald the Magnificent added as hero, with Mirror Guard as bodyguards
-- VAMPIRIA -- Varghulf troop added to strigoi, carstein caps


------------ CHANGES ------------
-- ALL -- Promotions based on xp tweaked, many made to require slightly more xp than before (usually 10% more)
-- ALL -- Cleaned up and improved more event messages aimed at providing useful info to the player
-- ALL -- Some more standardisation of elemental resistance values
-- ALL -- Added some more logic to try and avoid any heroes turning up more than once
-- BEASTLANDS -- Should no longer be possible to get and lose a weapon pile in a prov in the same turn
-- BEASTLANDS -- Khazrak now has tight rein
-- BLACK CRAG -- Summon Cave Squigs now scales with nature level
-- BLACK CRAG -- Black Orc Big Boss loses Tight Rein (it was a bit warping having easy access to it, and the Warboss still has it)
-- CHAOS -- Chaos spawn given snow move
-- CHAOS DWARFS -- Enslavement fixed so it can trigger on a province chaos dwarfs have previously owned but since lost
-- DARK ELVES -- Hellstrider patrolbonus removed for rider, Seeker patrolbonus reduced for rider
-- DWARFS -- Runesmith Apprentice gold cost slightly increased to slightly reduce dwarf rp/g efficiency
-- EMPIRE -- Some issues with the mounts of generals fixed
-- KHORNE -- Promotion event messages made clearer, blood slave rewards increased somewhat
-- KHORNE -- Max Ages increased on Chaos Warriors and their leaders
-- KISLEV -- Druzhinnik now recruitable outside forts, so they can lead ungol cav around
-- LIZARDMEN -- Skink Skirmishers got poisoned javelin
-- NORSCA -- Max Ages increased on Chosen, Jarl, King
-- NORSCA -- Max sailing size for kings increased
-- NURGLE -- largest chaos spawn no longer mindless (it causes issues with squads the turn of transformation)
-- NURGLE -- Plague event messages further improved for Nurgle and enemies, for clarity
-- NURGLE -- Plague spawning events tightened up a bit to avoid multiple of the same being triggered on the same or subsequent turns
-- NURGLE -- One spawn was missing an axe attack
-- NURGLE -- Max Ages increased on Chaos Warriors and their leaders
-- SLAANESH -- Max Ages increased on Chaos Warriors and their leaders
-- SLAANESH -- Hellstrider patrolbonus removed for rider, Seeker patrolbonus reduced for rider
-- VAMPIRIA -- Vargheist invuln and combat speed increased slightly, strength decreased slightly, given berserk 2, unsurroundable 1, gold cost raised 40 -> 45


-- version 1.06

------------ SUBMOD UPDATES ------------
-- POPTYPE -- Added a nightgoblin cave poptype for Black Crag
-- PRETENDERS -- Added the first version of the AI Pregenerated Pretenders submod


------------ NEW CONTENT ------------
-- KHORNE -- Added Chaos Troll of Khorne
-- TILEA -- Added Ruglud's Armoured Orcs as a Regiment of Renown


------------ CHANGES ------------
-- ALL -- Poison, shock, cold, fire resistances aligned with dominions 6 increment by 5 style. Some things with low poison res lost it entirely
-- ALL -- Troll combat speed decreased from 18 -> 16, prot increased by 1
-- DARK ELVES -- doomfire warlock's steed got correct strength
-- EMPIRE -- Ludwig lost extra hoof
-- GREENSKINS -- Custom headers given to promotion event messages
-- GREENSKINS -- Nightgoblin Fanatics appear slightly more often
-- GREENSKINS -- Fixed issues with Skarsnik IDs
-- GREENSKINS -- Basic Orc Boys and Savage Orc Boys can now promote into Biguns, losing all XP in the process
-- KHORNE -- slaughterpriests got 2 misc slots, but Khorne can no longer forge sanguine dousing rods
-- KISLEV -- Jade Wizards now available from any forest fort as well as cap
-- KISLEV -- Ice Wizard Lord changed from W3A1E1 to W3A1 100% EA, so they can get A2
-- KISLEV -- Bear Trainers are Bear Handlers, any fort, cheaper, spawn only 1 bear in combat, do not produce bears
-- KISLEV -- Every Temple automatically generates 1 war bear per month (simpler, easier for AI, territory based)
-- KISLEV -- Ungol Crone random increased 3->5%
-- KISLEV -- Tsarist officer slightly cheaper, now only requires 1 CP
-- LIZARDMEN -- Kroxigor recruitment limited to 6 per month
-- LIZARDMEN -- Nakai the Wanderer given swimming
-- NORSCA -- Custom headers given to longship raiding messages
-- NURGLE -- Nurgling Swarm can't be cast underwater
-- SKAVEN -- Pestilens troops and commanders with robes upgraded to leather cuirass
-- TILEA -- Lorenzo Lupo attack sprite fixed
-- UNDEAD -- ghouls now have enc 2
-- UNDEAD -- Corpse eating improved slightly, but max hp gain caps added
-- VAMPIRIA -- Crypt Horror gold cost increased 40->45, mor +1
-- WOOD ELVES -- Snow move granted to treemen, branchwraiths



-- version 1.05
------------ NEW CONTENT ------------
-- DWARFS -- Added Grombrindal the White Dwarf as hero to celebrate 500 issues of White Dwarf magazine
-- GREENSKINS -- Added Snotlings as recruitable troop for both
-- GREENSKINS -- Added Skarsnik as hero for Black Crag
-- GREENSKINS -- Added nightgoblin warrior as part of the nightgoblin montag for black crag
-- GREENSKINS -- Added Common Troll as a fort recruitable for both
-- NAGASHIZZAR -- Added Shade Scout commander, recruitable at any lab
-- NURGLE -- Added Feytor the Tainted One as a national hero

------------ CHANGES ------------
-- CHAOS DWARFS -- Astragoth's max age increased
-- CHAOS DWARFS -- Enslavement messages given custom headers
-- CHAOS DWARFS -- Enslavement events now grant blood slaves in addition to other rewards
-- DARK ELVES -- Black Dragon's gas breath weapon replaced with acid Dragon Bile
-- DARK ELVES -- Enslavement messages given custom headers
-- DARK ELVES -- Enslavement events now grant blood slaves in addition to other rewards
-- DARK ELVES -- Pleasure Cult events given custom headers
-- DWARFS -- Thorgrim's axe now one handed, since he's mounted
-- DWARFS -- Kragg the Grim no longer suffering old age
-- DWARFS -- Quality chain hauberk prot increased by 1
-- EMPIRE -- Wolf Kin gold cost reduced from 18 -> 16
-- EMPIRE -- Messages related to knightly orders improved in clarity, given custom headers
-- EMPIRE -- rpcosts of elite infantry reduced
-- EMPIRE -- Grandmaster of White Wolf's hammer now 1h
-- EMPIRE -- Knight of Morr gold cost increased 45 -> 50
-- EMPIRE -- Middenheim got new holy spell Ulric's Fury
-- EMPIRE -- Steam tank cannon can be used in melee half the time
-- GREENSKINS -- Spider summmons were 0 gems, should have been 10
-- HIGH ELVES -- Anointed of Asuryan lost fear, cost slightly reduced, twist fate made clear in description (the fear awe combo was simply proving too good)
-- KHORNE -- Chosen Knight costs 2 holy points, gold cost slightly reduced
-- KISLEV -- Frost effect on Tsar's shard blade fixed
-- KISLEV -- Collared war bears given gold upkeep (based on 20 gold cost)
-- KISLEV -- War bear and bear of kislev mr reduced somewhat
-- KISLEV -- Bear Trainer gold cost raised 220 -> 240
-- NURGLE -- Chosen Knight cots 2 holy points, gold cost slightly reduced
-- NURGLE -- Plagues which have been destroyed can respawn, but only if they have been gone from the world for as long as they ever existed (e.g. if plague completely destroyed after 10 turns, it can restart 10 turns later)
-- SLAANESH -- Custom headers given to promotion events
-- UNDEAD -- Wight Kings can now do formations
-- UNDEAD -- Mounts of commanders which were mindless made morale 30 to avoid mindless mount retreat bug (e.g. arkhan, carstein vampires, wight kings)
-- WOOD ELVES -- Priest of the balance no longer turns into glade captain when returning from a forest




-- version 1.04
-- ALL -- Promotions to Daemon Prince are a bit more robust in avoiding giving +2 holy to a prophet
-- ALL -- Unsurroundable values applied to daemon princes, greater daemons, as appropriate
-- ALL -- Events granting unique heroes given a custom header
-- ALL -- Many events which are not unexpected should now not claim to be
-- ALL -- Commanders with sailing also given swimming, to represent sailing across rivers
-- ALL -- Various troops with a theme of sailing or nautical work given swimming to represent sailing across rivers
-- CHAOS DWARFS -- Infernal troops (x3) and commander (x1) can now only be recruited in forts outside the chaos dwarf capital
-- EMPIRE -- Imperial Dwarf troop added as recruitable for Middenheim in mountain forts
-- EMPIRE -- Hochland Jager added as recruitable for middenheim in forest forts
-- EMPIRE -- Huntsmen and Huntsmasters no longer recruitable outside of forests
-- GREENSKINS -- Squig Prodda damage increased by 2
-- GREENSKINS -- Loonboss name fixed
-- GREENSKINS -- Nightgoblin Fanatics changed in a few ways, hopefully made more interesting
-- HIGH ELVES -- Rangers got swimming
-- HIGH ELVES -- Sword Masters got unsurroundable 1 representing their extremely good footwork against multiple enemies
-- HIGH ELVES -- White Lion cloak reduced in prot by 1 (matching up with hide shield value)
-- HIGH ELVES -- Anointed of Asuryan awe reduced from 2 -> 1 (commensurate with cost changes)
-- KHORNE -- Promotion events no longer claim to be unexpected
-- KHORNE -- Juggernauts get magical barding, slightly higher invuln, but now become weaker outside their dominion
-- KISLEV -- War Bear head prot fixed (caused by dom6 quadruped bug)
-- LIZARDMEN -- Slann no longer have headbutt attacks
-- LIZARDMEN -- Basic Saurus give small ceremonial plate and crest plate armour to improve their prot somewhat, armour of some sacred spawnings changed a bit
-- LIZARDMEN -- Proper ceremonial plate and bone helmet prot increased slightly
-- NURGLE -- Leather barding added to toads with saddles
-- NURGLE -- Plaguebearer was accidentally recruitable
-- NURGLE -- Messages related to plagues now have either custom headers, or do not claim to be unexpected, which should help parse them
-- OGRE KINGDOMS -- Jhared the red can cast sabretusk summon
-- TILEA -- Contract acceptances for regiments of renown given a custom header
-- TOMB KINGS -- Tomb Scorpion pincers fixed, added to preview site



-- version 1.03
-- ALL -- some instances of iceprot (armor) switched for icenatprot (natural protection) as appropiate
-- DWARFS -- Throne Bearers can no longer wear barding and stay and fight if they lose their 'rider'
-- CHAOS DWARFS -- Sorcerer's palanquin Bearers can no longer wear barding and stay and fight if they lose their 'rider'
-- GREENSKINS -- Orc Boar Chariot lost recuperation on mount
-- KHORNE -- Recruitable marauder displays helm correctly
-- NAGASHIZZAR -- CArrion natural prot increased a bit
-- NAGASHIZZAR -- Mummies now get ceremonial plates armour, nat prot reduced very slightly
-- TOMB KINGS -- Necrolith Colossi and Hierotitan get fear 5
-- TOMB KINGS -- Warsphinx Rider made quite a bit tougher
-- TOMB KINGS -- Fixed Necroserpent's missing weapons
-- TOMB KINGS -- Carrion natural prot increased a bit
-- TOMB KINGS -- Low and mid tier liche priests got corpse stitcher 1
-- UNDEAD -- further banshee's wail fix
-- UNDEAD -- Necromancer corpse stitched reduced 2 -> 1
-- VAMPIRES -- Necrarchs now also get some corpse stitcher
-- VAMPIRES -- Necrarch sanctum site fixed




-- version 1.02
-- ALL -- Mobile Archer applied to relevant troops and commanders
-- BEASTMEN -- Further fixes to avoid continuous beastwood site spawning
-- BRETONNIA -- Destrier combat speed increased by 1
-- CHAOS DWARFS -- Steppe Wolves get leather barding
-- CHAOS DWARFS -- slight hp increase for immortal guard
-- DARK ELVES -- Steed of Slaanesh gets +1 def
-- DARK ELVES -- Hellstrider gold cost increased to 50
-- DWARFS -- Rune of Grugni now casts soldiers of steel not legions of steel
-- DWARFS -- Made the special mechanics start of game message a bit clearer
-- EMPIRE -- War horse combat speed reduced slightly
-- GREENSKINS -- Grimgor's rising form and waaghboss form have tight rein
-- GREENSKINS -- Spitting Spider and Giant Spider summons both now 10 gems
-- HIGH ELVES -- Moon and Sun Dragon IDs tweaked so riders can never 'use up' a summoned dragon to replace their mount
-- HIGH ELVES -- Airshield on Shadow Warriors reduced from 50 -> 30
-- KHORNE -- Juggernauts get recuperation
-- KHORNE -- Added spell summon flesh hound pack
-- KHORNE -- Disciple of Brass and Speaker of Brass gold costs reduced
-- KHORNE -- Ragesmith guaranteed B1, cost unchanged
-- KISLEV -- Breath of Ursun now a copy of dragon frost, not drake frost
-- NAGASHIZZAR -- Hexwraiths spiritform and recruitment limited (same as vamps)
-- NAGASHIZZAR -- Wall Defenders now archers not warriors
-- NORSCA -- Chosen gold cost increased 50 -> 55
-- NURGLE -- Rot Fly now flies, has recuperation inside dominion
-- NURGLE -- Added spell Summon Plague Drone Flight
-- NURGLE -- Added spell Summon Gaggle of Beasts
-- NURGLE -- Plague Toads now have recuperation
-- NURGLE -- Sorcerer and Sorcerer Lord got guaranteed B1 and gold costs raised somewhat
-- NURGLE -- Daemonflies weapon +2 att, so it's better at repel, even better than the skaven fly swarm
-- NURGLE -- Great Unclean one gains daemonflies weapon, slightly increased prot and invuln
-- NURGLE -- Daemon Prince loses E1
-- NURGLE -- Various rotted blubbery things got blunt res, some also got pierceres, as they lack functioning organs
-- SKAVEN -- Packmaster, Skweel, and Mutator got +1 beastmaster, -1 inspirational
-- SLAANESH -- Mount of Slaanesh now has awe, increased hp
-- SLAANESH -- Added spell summon skitter of fiends
-- SLAANESH -- Fiend of Slaanesh gets +1 def, unsurroundable 1
-- SLAANESH -- Steed of Slaanesh gets +1 def
-- SLAANESH -- Hellstrider gold cost increased to 50
-- SLAANESH -- All the horsies get their head armour
-- SLAANESH -- Sorcerer and Sorcerer Lord got an added 100% death fire random to help cast interesting glamour crosspath spells. Gold costs very slightly raised
-- SLAANESH -- Daemon Prince blood magic reduced from B2 -> B1
-- TOMB KINGS -- Sepulchral Stalker wasteland recruitment limited to 2 per month
-- UNDEAD -- Hexwraith and Cairn Wraith rpcosts increased
-- VAMPIRES -- Bloodlines should no longer be removed when put under siege, instead will be removed 1 turn after fort is stormed by enemy



-- version 1.01
-- ALL -- Missing sprites fixed
-- ALL -- Nations with heat or cold preference 1 now get heat or cold limit +1
-- EMPIRE -- Gold lion knight and grandmaster had bug with mounts messing various things up
-- GREENSKINS -- Squig Prodda was still 2 handed
-- GREENSKINS -- Goblin Wolf Chariot gold cost increased


-- version 1.0
-- ALL -- Changed some explainer events to have headers other than 'an unexpected event' when the game supports this next version
-- ALL -- Fixes to events (silent and reported) that gave gold or gems - none of them care about fort or lab tracing any more, so work as intended
-- ALL -- Fixes to avoid heroes turning up more than once when people are using the current version file in singleplayer
-- ALL -- Dragons as mounts now generally can't wear barding, since it was providing onerous prot stacking
-- ALL -- Ghosts and wraiths and spirits now have spiritform trait
-- BEASTMEN -- Fixed multiple beastwoods spawning in a single province, put in events to remove multiples from existing games
-- BRETONNIA -- Grail Lord riding Hippogriff no longer has fear
-- BRETONNIA -- Questing events should no longer make the mount disappear
-- BRETONNIA -- Shepherdess gold cost significantly reduced
-- DARK ELVES -- Slight cost reductions on sorceress line of mages
-- DARK ELVES -- Cold Ones now size 5
-- DARK ELVES -- Added basic cytharai priest as h1
-- EMPIRE -- New mounted system implemented for all 3 empire factions
-- EMPIRE -- New knightly order chapterhouse system implemented for all 3 empire factions
-- EMPIRE -- Tributes can now only be purchased once, after which they become unavailable
-- EMPIRE -- Added new Bombard War Wagon to Nuln
-- EMPIRE -- Added new Repeater War Wagon to Nuln
-- EMPIRE -- Some middenheimers given slight hp buffs to represent northeastern toughness
-- EMPIRE -- Middenheim gets double the number of spearmen in forted province PD
-- EMPIRE -- Increased range of repeater crossbow
-- EMPIRE -- Renamed the Sacred Scythes to the Silver Scythes because people kept asking me why they aren't sacred
-- EMPIRE -- Witch Hunter gold cost decreased by 20
-- GREENSKINS -- Grom's waaagh form chariot fixed
-- GREENSKINS -- Orc chariot fixed again
-- GREENSKINS -- Nightgoblin archer prec fixed
-- GREENSKINS -- For Black Crag: Nightgoblin Great Shaman now recruitable in cap or in any forted cave or mountain
-- GREENSKINS -- For Bone Nose: Forest Goblin Great shaman now recruitable in cap or in any forted forest
-- GREENSKINS -- All Great Shamans got their reinvigoration increased from 1 -> 2
-- GREENSKINS -- Squig strength and morale increased
-- GREENSKINS -- Squig Prodda no longer 2 handed
-- GREESNKINS -- Added Nightgoblin Loonboss to Black Crag as cheap H1 priest leader
-- HIGH ELVES -- Some cavalry got +1 str
-- HIGH ELVES -- Seaguard and Eagle Claws can no longer be recruited coastally without a fort
-- HIGH ELVES -- Eagle Claw bolts per volley reduced from 4 -> 3
-- HIGH ELVES -- Anointed of Asuryan no longer research, gold cost hugely reduced
-- HIGH ELVES -- Captain commander added as a basic recruitable, replaces noble in PD and fort defenders
-- HIGH ELVES -- Cadai Priest added as a basic H1 recruitable
-- HIGH ELVES -- Summon Great Eagles cost reduced
-- HIGH ELVES -- Spells to summon prince on griffon and on eagle reduced in cost and great eagle mount given some light barding
-- KISLEV -- War Wagon mount head prot fixed
-- KISLEV -- Chekist changed to Tsarist Officer. The Chekist (soviet secret police) reference GW made was a bit distasteful
-- LIZARDMEN -- Some skink commanders got prot boosted slightly
-- LIZARDMEN -- Cold Ones now size 5
-- LIZARDMEN -- Some slight natural protection increases across the board
-- LIZARDMEN -- Ripperdactyl got its AP bite back
-- NAGASHIZZAR -- Morghast Harbinger no longer recruitable, only summmonable, cost decreased frm 20 to 18 death gems
-- NAGASHIZZAR -- Morghast Archai no longer recruitable, only summmonable
-- NAGASHIZZAR -- Morghast limited to 2 recruitable per month
-- NAGASHIZZAR -- Arkhan the black loses trample
-- NAGASHIZZAR -- Death cultist multihero was supposed to be liche of the council
-- NURGLE -- Mutant warhound no longer has 'crystal fist'
-- NURGLE -- Typo in initial zombie plague message fixed
-- UNDEAD -- Tomb Banshee's wail now cannot hit friendlies, so she won't rout herself
-- UNDEAD -- Cairn Wraith troop hp lowered from 18 to 15, scythe damage decreased
-- UNDEAD -- Cairn and Hex Wraiths now limited recruitment to 3 per month, no more making armies solely of these
-- VAMPIRES -- Nightmare steeds def slightly increased
-- VAMPIRES -- Von Carstein Lords now automatically regain mount if lost
-- WOOD ELVES -- Added a basic priest of the balance H1
-- WOOD ELVES -- Summon Great Eagles cost reduced



-- version 0.61
-- ALL -- Various monsters that copy wolves and other animals given a transformation 0 tag so they don't turn up as transformation results
-- BEASTMEN -- Wargors slightly cheaper, slightly less leadership
-- BEASTMEN -- Weapon piles last on average a bit longer
-- BEASTMEN -- Improved province defence in forests in positive domain
-- BEASTMEN -- Improved province defence over 20 PD somewhat
-- DWARFS -- Can start in caves now
-- EMPIRE -- Grey Wizards now glamour mages primarily, not air
-- HIGH ELVES -- Harathoi mage gold cost reduced by 10
-- KHORNE -- Marauder Horseman steed armour fixed
-- KISLEV -- Grey Wizards now glamour mages primarily, not air
-- GREENSKINS -- Goblin Warboss chariot now has leather barding
-- GREENSKINS -- Orc Chariot fixed
-- GREENSKINS -- Squig Hopper gold cost fixed
-- GREENSKINS -- Wolf chariot montag issues fixed
-- GREENSKINS -- Nightgoblin Shaman gold cost reduced by 20%
-- NORSCA -- Norscan Kings should no longer get elevated H magic
-- NURGLE -- Forsaken Warrior weapon fixed
-- NURGLE -- Beast of nurgle gets correct attack value on venomous claw
-- SLAANESH -- Chosen Knight's steed has recuperation
-- TILEA -- Grey Wizards now glamour mages primarily, not air


-- version 0.6
-- ALL -- Some assassins restricted in terms of assassination battle maps (e.g. waystalker assassinations always outside)
-- ALL -- more fixes to missing weapons on heroes
-- ALL -- Many battle spells altered slightly because restricting them to specific mages doesn't work
-- BRETONNIA -- Fixed duke of brionne's aoe fear weapon
-- CHAOS DWARFS -- Issues with stonecursed and stonewracked sorcerers not getting their mounts have been fixed
-- DWARFS -- Priestess of valaya now spellsinger
-- GREENSKINS -- New mounted system implemented
-- GREENSKINS -- Normal orc warbosses now have magic one handed choppas
-- GREENSKINS -- Stone Trolls now mountain recruits, not cave recruits
-- KHORNE -- Fixed mount for Marauder Light Horseman
-- LIZARDMEN -- Tehenhauin now heretic (4), as he was intended to be
-- LIZARDMEN -- Flood of Serpents spell fixed
-- NAGASHIZZAR -- Fixed mount for Wight King
-- SKAVEN -- Packmasters no longer recruitable in any unforted cave
-- WOOD ELVES -- Wildwood rangers now get correct helmet (second try fixing this!)


-- version 0.5
-- ALL -- fixed some more troops erroneously copying a ctsian due to ID shifts
-- ALL -- construction level 12 items moved to 11 so they're still unforgeable but avoid issues with items not spawning correctly
-- ALL -- fixed some issues with coastal recruitment
-- DARK ELVES -- Summmons of Slaaneshi Daemons no longer require astral, some require blood 2
-- DARK ELVES -- Gave Rakarth high poison res to avoid his dragon killing him accidentally
-- DWARFS -- Miner and Prospector mapmove reduced
-- HIGH ELVES -- New mounted system implemented
-- KISLEV -- Tight Rein added to bear trainer
-- NAGASHIZZAR -- New Mounted system implemented
-- NURGLE -- Was increasing drain rather than increasing death
-- NULN -- Moot militia recruitable in farms outside forts too now
-- SKAVEN -- Tight Rein added to appropriate commanders
-- SKAVEN -- New Mounted system implemented
-- SKAVEN -- Added Chant of Nurglitch, a low level poison res spell that doesn't use a gem
-- SKAVEN -- Added Pox Rat troop and spell to summon it in conjuration
-- SLAANESH -- Spells properly set to blood/glamour not blood/astral
-- VAMPIRIA -- Added recruitment specific graphic for corpse giant
-- VAMPIRIA -- Hexwraith hoof now magic
-- WOOD ELVES -- Mounted troops now permanently in forest shape to work around a Dom6 bug (which will hopefully be a temporary situation)
-- WOOD ELVES -- Because there is a bug with mounted immortals, Sisters of the Thorn are (for now) cheaper and not immortal


-- REMEMBER - always declare shields after all other armour to avoid the weird shield prot bug



-- Conceptual tier list, in terms of overall power intended for each nation

-- A Tier, the factions emphasised to be the most powerful or threatening in the lore
---- Khorne
---- Slaanesh
---- Nurgle
---- Undead (Nagashizzar)
---- High Elves (Ulthuan)
---- Lizardmen (Itza)


-- B Tier, the bulk of nations
---- The Empire (Altdorf)
---- The Empire (Nuln)
---- The Empire (Middenheim)
---- Bretonnia
---- Dark Elves (Naggarond)
---- Dwarfs (Karaz-a-Karak)
---- Greenskins (Black Crag)
---- Greenskins (Bone Nose Tribe)
---- Ogre Kingdoms (Goldtooth Tribe)
---- Skaven (Skavenblight)
---- Vampires (Vampiria)
---- Wood Elves (Athel Loren)
---- Tomb Kings (Nehekhara)


-- C Tier, minor or less powerful factions in the lore
---- Kislev
---- Beastmen (Beastlands)
---- Chaos Dwarfs (Zharr-Naggrund)
---- Norsca
---- Tilea




-- random notes
-- give middenheim something to make up for their lost kislev stuff?
-- malekith riding black dragon
-- carstein lord riding zombie dragon
-- glade lord on forest dragon + spell to summon

-- add a special event for death hags where they hold a murder night and kill some population and cause unrest (but maybe you get some witch elves and get some positive domain)

-- tilean AI is now sometimes recruiting merc contracts, but not very often. Can I make it recruit them more? Increased resource cost maybe?



-- WOOD ELVES


-- it turns out that if you give a troop stealth in forest and not stealth in their plainshape, then they destealth and have a battle, as you'd expect.
-- but the same isn't true of a commander. Their battle is delayed by a turn, although they still get stuck in the hostile land and can't leave

-- so its best to just have better stealth in forests, rather than stealth vs no stealth


------ possible spite ideas


-- Spite effects

--Forest Spite: -- Tank thug
-- Vine Shield
-- Barkskin
-- Regeneration

--Porcupine Spite: -- Tank thug
-- Spines
-- Stoneskin

--Dream Spite: -- Assassin
-- Ethereal
-- Sleepy weapon
-- Assassin?

--Wind Spite: -- Raider
-- Flying

--Fire spite: -- High damage thug
-- Flaming weapon
-- Heat?
-- FR

--Leaden spite: -- Mage stopper
-- High MR
-- High resistances
-- Slightly increased HP?

--Leech Spite: -- Thug
-- Life Drain? Or even Soul Vortex?

--Whispering Spite: -- Thug
-- Fear
-- Small insanity

--Venom Spite: -- Assassin
-- Paralyze and poison damage

--Swift Spite:
-- High mapmove
-- Quickness in battle



-------- stuff to add

---- heroes
-- scarloc the wanderer
-- naestra and arahan
-- coeddil
-- durthu
-- drycha
-- skaw the falconer


---- commanders
-- highweaver on unicorn

-------------------------------------------------------------------------
-- Weapons
-------------------------------------------------------------------------


---- Giant Stomp

#newweapon 1168
#copyweapon 532 -- tail sweep, for the def negates tag
#name "Giant Stomp"
#dmg 0
#att 0
#def -1
#len -1
#rcost 0
#bonus
#aoe 1
#blunt
#sizeresist
#end


---- Vinelash

#newweapon 1169
#name "Vinelash"
#slash
#dmg -8
#flail
#len 3 -- +1 from size
#sound 9
#nratt 3
#bonus
#secondaryeffect 1150 -- entangling roots (mr resists)
#end


---- Unicorn Horn

#newweapon 1167
#copyweapon 614 -- tusk
#name "Unicorn Horn"
#charge
#att 0
#def 0
#dmg 2
#len 1
#magic
#pierce
#bonus
#end

---- Great Hunting Spear

#newweapon 1166
#copyweapon 120 -- enchanted spear
#name "Great Hunting Spear"
#len 4 -- +1
#dmg 12 -- +5
#def 1 -- -1
#end


---- Skaryn the eye thief

#newweapon 1165
#copyweapon 230 -- owl that attacks people for the titan of wisdom
#name "Skaryn the Eye Thief"
#dmg 8
#slash
#pierce
#secondaryeffect 333 -- eyeloss
#armorpiercing
#end


-- Magic hoof (used by great stag)

#newweapon 1161
#copyweapon 55 -- hoof
#name "Hoof"
#magic
#end

-- Stag's antlers

#newweapon 1162
#copyweapon 634 -- antlers with str bonus
#name "Antlers"
#magic
#charge
#pierce -- as well as slash
#end


-- Asrai Spear

#newweapon 1140
#copyweapon 1 -- spear
#name "Asrai Spear"
#dmg 5 -- +2
#att 1 -- +1
#end

-- Asrai Long Bow

#newweapon 1141
#copyweapon 24 -- long bow
#name "Asrai Long Bow"
#dmg 11 -- +2
#att 1 -- +1
#halfstr
#end

-- Asrai Long Bow (forest)

#newweapon 1170
#copyweapon 24 -- long bow
#name "Asrai Long Bow"
#dmg 11 -- +2
#att 1 -- +1
#halfstr
#friendlyimmune
#end

-- Asrai Lance

#newweapon 1142
#copyweapon 357 -- light lance
#name "Asrai Lance"
#dmg 5 -- +2
#att 1 -- +1
#end

-- Asrai Composite Bow

#newweapon 1143
#copyweapon 264 -- composite bow
#name "Asrai Composite Bow"
#dmg 10 -- +2
#halfstr
#end

-- Asrai Composite Bow (forest)

#newweapon 1205
#copyweapon 264 -- composite bow
#name "Asrai Composite Bow"
#dmg 10 -- +2
#halfstr
#friendlyimmune
#end

-- Sapling Whip

#newweapon 1146
#name "Sapling Whip"
#dmg 2
#att 0
#def 0
#len 3
#nratt 1
#slash
#sound 9 -- whip
#flail
#secondaryeffect 50 -- weak poison
#bonus
#end

-- Frost Spike

#newweapon 1147
#copyweapon 69 -- icicle fist
#name "Frost Spike"
#secondaryeffect 1148 -- Spiteful Frost
#end

-- Spiteful Frost

#newweapon 1148
#copyweapon 222 -- cold
#name "Spiteful Frost"
#dmg 8 -- -4
#end

-- Oaken Fist

#newweapon 1149
#copyweapon 92 -- fist
#name "Oaken Fist"
#dmg 3
#att 0
#def 0
#bonus -- because things that use it tend to not have hands
#end

-- Entangling Roots

#newweapon 1150
#copyweapon 137 -- entangle
#name "Entangling Roots"
#mrnegates
#bonus
#end

-- Lance of Isha

#newweapon 1151
#copyweapon 357 -- light lance
#name "Lance of Isha"
#dmg 4 -- +1
#att 1 -- +1
#secondaryeffect 50 -- weak poison
#end

-- Blackbriar Javelin

#newweapon 1152
#copyweapon 21 -- javelin
#name "Blackbriar Javelin"
#ammo 3 -- +1
#dmg 1 -- -1
#att 0 -- +2
#secondaryeffect 51 -- strong poison
#end

-- Lance of Spite

#newweapon 1154
#copyweapon 357 -- light lance
#name "Lance of Spite"
#dmg 6 -- +3
#att 2 -- +2
#def 1 -- +1
#magic
#rcost 3
#end

-- Spiritbane Glaive

#newweapon 1155
#copyweapon 11 -- great sword
#name "Spiritbane Glaive"
#dmg 8 -- -1
#def 1 -- -1
#secondaryeffect 1156 -- spiritbane
#rcost 7 -- +2
#end

-- Spiritbane

#newweapon 1156
#name "Spiritbane"
#dmg 4
#nostr
#magic
#dt_magic -- x2 vs magic beings
#armorpiercing
#bonus
#internal
#end


-- Waywatcher Long Bow

#newweapon 1157
#copyweapon 24 -- long bow
#name "Waywatcher Long Bow"
#dmg 7
#att 2 -- +2
#armorpiercing
#halfstr
#end


-- Waywatcher Long Bow (forests)

#newweapon 1206
#copyweapon 24 -- long bow
#name "Waywatcher Long Bow"
#dmg 7
#att 2 -- +2
#armorpiercing
#halfstr
#friendlyimmune
#end


-- Spite Infused Bow

#newweapon 1158
#copyweapon 24 -- long bow
#name "Spite Infused Bow"
#dmg 11 -- +2
#att 2 -- +2
#armorpiercing
#magic
#nratt 2
#ammo 24
#flyspr 10148 -- long green particle trail things
#secondaryeffect 1150 -- entangling roots
#friendlyimmune
#halfstr
#end


-- Hawk's Talon

#newweapon 1207
#copyweapon 24 -- long bow
#name "Hawk's Talon"
#dmg 12 -- +3
#att 4
#armorpiercing
#magic
#nratt 6
#ammo 24
#flyspr 10148 -- long green particle trail things
#secondaryeffect 1150 -- entangling roots
#friendlyimmune
#halfstr
#bonus -- no hands needed
#end


-- Spear of Kurnous

#newweapon 1208
#copyweapon 643 -- bronze spear
#name "Spear of Kurnous"
#dmg 5
#armorpiercing
#att 2
#def 1
#magic
#charge
#bonus -- no hands needed
#end


-- Bite, magical

#newweapon 1209
#copyweapon 20 -- bite
#name "Bite"
#magic
#end


-- Soporific Breath

#newweapon 1230
#copyweapon 535 -- dragon gas
#name "Soporific Breath"
--aoe 4 -- 2 worse than regular dragon gas
--dmg -5 -- 2 worse than regular dragon gas
#secondaryeffectalways 1231 -- soporific fumes
#end

-- soporific fumes

#newweapon 1231
#name "Soporific Fumes"
#inanimateimmune
#dt_stun
#dmg 0
#armornegating
#hardmrneg
#magic
#bonus
#end



-------------------------------------------------------------------------
-- Armour
-------------------------------------------------------------------------


-------------------------------------------------------------------------
-- Recruitables
-------------------------------------------------------------------------

-----Template Wood Elf -- compared with high elf

#newmonster 14130
#spr1 "Warhammer_Wood_Elves/Glade_Guard.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Guard2.tga"
#name "Template Wood Elf"
#descr "Wood Elf Template."
#hp 8
#prot 0
#size 3
#str 9
#enc 3
#att 12
#def 12
#prec 12
#mr 12
#mor 12
#rcost 1
#rpcost 10
#ap 14
#mapmove 16
#startage 130
#maxage 2000
#nametype 200 -- male wood elf
#forestsurvival
#snow
#end


----- Glade Guard (archer)

#newmonster 14131
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Guard.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Guard2.tga"
#name "Glade Guard"
#descr "In time of need, every Wood Elf can answer the call to defend their realm, for all are trained in the art of the Long Bow as soon as they are old enough to hold one. After all to the Asrai archery is not just a tool of battle but one of many hunter's skills necessary for survival. When an Elf comes of age he or she will be formally inducted into the Glade Guard of their household and given responsibility for patrolling a section of the realm. When a threat is identified by a patrol it does not take long before they are faced with a suitable sized force of Glade Guard who stand ready to pincushion the interloper with arrows. Glade Guard form the core of almost every force fielded by Athel Loren and are famed for the storms of arrows they can rain down on the enemy line. While graceful and capable swordsmen, Glade Guard are lightly armoured and typically prefer to leave melee combat to the Eternal Guard or troupes of Wardancers.

[Gain glamour, +1 precision, +1 morale, and +1 patrolbonus in forests. Asrai Long Bow will not harm friendlies in forests]"
#gcost 14
#armor 10 -- leather hauberk
#armor 120 -- leather cap
#weapon 1141 -- asrai long bow
#weapon 6 -- Short Sword
#forestshape 14132
#end

----- Glade Guard (archer) -- forest shape

#newmonster 14132
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Guard.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Guard2.tga"
#name "Glade Guard"
#descr "In time of need, every Wood Elf can answer the call to defend their realm, for all are trained in the art of the Long Bow as soon as they are old enough to hold one. After all to the Asrai archery is not just a tool of battle but one of many hunter's skills necessary for survival. When an Elf comes of age he or she will be formally inducted into the Glade Guard of their household and given responsibility for patrolling a section of the realm. When a threat is identified by a patrol it does not take long before they are faced with a suitable sized force of Glade Guard who stand ready to pincushion the interloper with arrows. Glade Guard form the core of almost every force fielded by Athel Loren and are famed for the storms of arrows they can rain down on the enemy line. While graceful and capable swordsmen, Glade Guard are lightly armoured and typically prefer to leave melee combat to the Eternal Guard or troupes of Wardancers.

[Lose glamour, 1 precision, 1 morale, and 1 patrolbonus outside forests. Asrai Long Bow will harm friendlies outside forests]"
#gcost 14
#armor 10 -- leather hauberk
#armor 120 -- leather cap
#weapon 1170 -- asrai long bow
#weapon 6 -- Short Sword
#glamour -- glamour
#plainshape 14131
#mor 13 -- +1
#prec 13 -- +1
#patrolbonus 1 -- +1
#end

----- Deepwood Scout

#newmonster 14133
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Deepwood_Scout.tga"
#spr2 "Warhammer_Wood_Elves/Deepwood_Scout2.tga"
#name "Deepwood Scout"
#descr "Deepwood Scouts hold the responsibility of patrolling areas of the forest deemed too dangerous for Glade Guard to enter, as well as venturing out into enemy territory to neutralise threats before they can reach the realms of the Asrai. Beyond the forest they are fine scouts and raiders, but their true abilities lie in their stealth and craft in navigating the darkest places of ancient woods, evading the keen senses of malicious spirits and territorial beasts. Deepwood Scouts are masters of misdirection, ambush, skirmishing, and tracking whose hidden work is just as vital to the safety of their people as the massed forces of Glade Guard.

[Gain glamour, +15 stealth, +1 precision, +1 morale, and +1 patrolbonus in forests. Asrai Long Bow will not harm friendlies in forests]"
#gcost 15
#armor 5 -- leather cuirass
#armor 121 -- leather hood
#weapon 1141 -- asrai long bow
#weapon 9 -- dagger
#forestshape 14134
#prec 13 -- +1
#patrolbonus 1
#supplybonus 2
#stealthy 10
#skirmisher 1
#rpcost 12 -- +2
#noleader
#skirmisher 1
#end

----- Deepwood Scout -- forest shape

#newmonster 14134
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Deepwood_Scout.tga"
#spr2 "Warhammer_Wood_Elves/Deepwood_Scout2.tga"
#name "Deepwood Scout"
#descr "Deepwood Scouts hold the responsibility of patrolling areas of the forest deemed too dangerous for Glade Guard to enter, as well as venturing out into enemy territory to neutralise threats before they can reach the realms of the Asrai. Beyond the forest they are fine scouts and raiders, but their true abilities lie in their stealth and craft in navigating the darkest places of ancient woods, evading the keen senses of malicious spirits and territorial beasts. Deepwood Scouts are masters of misdirection, ambush, skirmishing, and tracking whose hidden work is just as vital to the safety of their people as the massed forces of Glade Guard.

[Lose glamour, 15 stealth, 1 precision, 1 morale, and 1 patrolbonus outside forests. Asrai Long Bow will harm friendlies outside forests]"
#gcost 15
#armor 5 -- leather cuirass
#armor 121 -- leather hood
#weapon 1170 -- asrai long bow
#weapon 9 -- dagger
#glamour -- glamour
#plainshape 14133
#mor 13 -- +1
#prec 14 -- +1
#skirmisher 1
#rpcost 12 -- +2
#patrolbonus 2 -- +1
#supplybonus 2
#stealthy 10
#noleader
#skirmisher 1
#end


----- Eternal Guard

#newmonster 14135
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Eternal_Guard.tga"
#spr2 "Warhammer_Wood_Elves/Eternal_Guard2.tga"
#name "Eternal Guard"
#descr "The Eternal Guard are elite Wood Elf infantry tasked with the defence of the most important and holy sites of their people. Membership can only be gained through skill and deeds in battle and while many elves seek this position of honour, relatively few are accepted. They make use of a phalanx formation not unlike those employed by their High Elf cousins on Ulthuan, protected by a wall of large shields as their superbly crafted spears dart out to wound and kill with frightening speed. The Eternal Guard's duties are most important during the winter months when the allied spirits of Athel Loren are at their lowest ebb and the spiteful creatres of the Wildwood are at their most bitter and resentful, for at this time the safety of the ancient forest realm falls almost entirely on their shoulders. Each member bears the sign of eternity on their shield and knows they cannot falter and must endure, just as Athel Loren must endure. When the most powerful nobles of the Asrai households travel they are often accompanied by watchful Eternal Guard as a sign of their status and a guarantee of their safety.

[Gain glamour, +1 hp, +1 strength, and +1 morale in forests]"
#gcost 18
#armor 7 -- scale mail cuirass
#armor 162 -- crested helm
#armor 3 -- kite shield
#weapon 1140 -- asrai spear
#forestshape 14136
#rpcost 20 -- +10
#coldres 5
#bodyguard 1
#formationfighter 2 -- phalanx
#att 13
#def 13
#hp 10 -- tougher
#str 10 -- stronger
#mor 15 -- +3
#end

----- Eternal Guard -- forest shape

#newmonster 14136
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Eternal_Guard.tga"
#spr2 "Warhammer_Wood_Elves/Eternal_Guard2.tga"
#name "Eternal Guard"
#descr "The Eternal Guard are elite Wood Elf infantry tasked with the defence of the most important and holy sites of their people. Membership can only be gained through skill and deeds in battle and while many elves seek this position of honour, relatively few are accepted. They make use of a phalanx formation not unlike those employed by their High Elf cousins on Ulthuan, protected by a wall of large shields as their superbly crafted spears dart out to wound and kill with frightening speed. The Eternal Guard's duties are most important during the winter months when the allied spirits of Athel Loren are at their lowest ebb and the spiteful creatres of the Wildwood are at their most bitter and resentful, for at this time the safety of the ancient forest realm falls almost entirely on their shoulders. Each member bears the sign of eternity on their shield and knows they cannot falter and must endure, just as Athel Loren must endure. When the most powerful nobles of the Asrai households travel they are often accompanied by watchful Eternal Guard as a sign of their status and a guarantee of their safety.

[Lose glamour, 1 hp, 1 strength, and 1 morale outside forests]"
#gcost 18
#armor 7 -- scale mail cuirass
#armor 162 -- crested helm
#armor 3 -- kite shield
#weapon 1140 -- asrai spear
#glamour -- glamour
#plainshape 14135
#rpcost 20 -- +10
#coldres 5
#bodyguard 1
#formationfighter 2 -- phalanx
#att 13
#def 13
#hp 11 -- +1
#str 11 -- +1
#mor 16 -- +1
#end

------Elven Steed (glade rider)

#newmonster 14383
#copystats 3513 -- basic riding horse
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Wood_Elves/Glade_Rider_Mount.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Rider_Mount2.tga"
#name "Elven Steed"
#descr "The Elven Steeds of Athel Loren are amongst the finest in the world. While these intelligent, noble creatures are descended from the same stock as those in Ulthuan, the Wood Elves have ceased to treat these horses as chattel and instead created a close bond of mutual benefit between Elf and Steed.

[Gain glamour, +1 morale in forests.]"
#size 5
#hp 20
#gcost 20
#weapon 55 -- Hoof
#rcost 1
#rpcost 16 -- war horse +1
#att 10 -- 1 less than dark steed
#def 11 -- I4, WS3
#ap 30 -- 2 faster than dark steed
#mapmove 28 --- 2 faster than dark steed
#maxage 40 -- same as fay horse
#mr 10 -- double that of riding horse
#smartmount 50 -- 50% chance of it trying to go home
#mor 11 -- same as destrier
#enc 2 -- same as destrier
#armor 251 -- leather barding - prot 5
#snow
#forestsurvival
#forestshape 14384
#end


------Elven Steed (glade rider - forestshape)

#newmonster 14384
#copystats 3513 -- basic riding horse
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Wood_Elves/Glade_Rider_Mount.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Rider_Mount2.tga"
#name "Elven Steed"
#descr "The Elven Steeds of Athel Loren are amongst the finest in the world. While these intelligent, noble creatures are descended from the same stock as those in Ulthuan, the Wood Elves have ceased to treat these horses as chattel and instead created a close bond of mutual benefit between Elf and Steed.

[Lose glamour, 1 morale outside forests.]
[Non-forest shape temporarily disabled due to Dominions 6 bug with mounted terrain shapes]"
#size 5
#hp 20
#gcost 20
#weapon 55 -- Hoof
#rcost 1
#rpcost 16 -- war horse +1
#att 10 -- 1 less than dark steed
#def 11 -- I4, WS3
#ap 30 -- 2 faster than dark steed
#mapmove 28 --- 2 faster than dark steed
#maxage 40 -- same as fay horse
#mr 10 -- double that of riding horse
#smartmount 50 -- 50% chance of it trying to go home
#mor 12
#enc 2 -- same as destrier
#armor 251 -- leather barding - prot 5
#glamour
#snow
#forestsurvival
--plainshape 14383
#end


-- Glade Rider (new mounted)

#newmonster 14139
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Rider.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Rider2.tga"
#name "Glade Rider"
#descr "The Glade Riders of Athel Loren are amongst the finest horse-warriors in the world, their Elven Steeds and sharp reflexes allowing them to perform feats of horsemanship that border on the supernatural. While their mounts are descended from the same stock as those used by their cousins in Ulthuan, the Wood Elves have ceased to treat these horses as chattel and instead created a close bond of mutual benefit between Elf and Steed. Glade Riders fight in a similar style to the Glade Guard, preferring to finish their foe with volleys of missile fire rather than engage in melee for although their well crafted lances do allow them to deal decisive charges, they are quite lightly armoured.

[Gain glamour, +1 precision, +1 morale, and +1 patrolbonus in forests. Asrai Composite Bow will not harm friendlies in forests]"
#weapon 1142 -- asrai lance
#weapon 1143 -- composite bow
#armor 15 -- full leather armour
#armor 119 -- reinforced leather cap
#gcost 15 -- (35)
#patrolbonus 1
#skilledrider 2
#mobilearcher 1
#mountmnr 14383 -- elven steed
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Rider_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Rider_Unmounted2.tga"
--forestshape 14140
#end


-- Glade Rider (forest shape)

#newmonster 14140
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Rider.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Rider2.tga"
#name "Glade Rider"
#descr "The Glade Riders of Athel Loren are amongst the finest horse-warriors in the world, their Elven Steeds and sharp reflexes allowing them to perform feats of horsemanship that border on the supernatural. While their mounts are descended from the same stock as those used by their cousins in Ulthuan, the Wood Elves have ceased to treat these horses as chattel and instead created a close bond of mutual benefit between Elf and Steed. Glade Riders fight in a similar style to the Glade Guard, preferring to finish their foe with volleys of missile fire rather than engage in melee for although their well crafted lances do allow them to deal decisive charges, they are quite lightly armoured.

[Lose glamour, 1 precision, 1 morale, and 1 patrolbonus outside forests. Asrai Composite Bow will harm friendlies outside forests]
[Non-forest shape temporarily disabled due to Dominions 6 bug with mounted terrain shapes]"
#weapon 1142 -- asrai lance
#weapon 1205 -- composite bow
#armor 15 -- full leather armour
#armor 119 -- reinforced leather cap
#gcost 15 -- (35)
#glamour -- glamour
--plainshape 14139
#mor 13 -- +1
#prec 13 -- +1
#patrolbonus 2 -- +1
#skilledrider 2
#mobilearcher 1
#mountmnr 14384 -- elven steed forestshape
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Rider_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Rider_Unmounted2.tga"
#end


-- Steed of Kurnous

#newmonster 14387
#copystats 3513 -- basic riding horse
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Wood_Elves/Wild_Rider_Mount.tga"
#spr2 "Warhammer_Wood_Elves/Wild_Rider_Mount2.tga"
#name "Steed of Kurnous"
#descr "The Riders that form the Wild Hunt of Orion go into battle atop Steeds of Kurnous, magical deerlike beasts that are said to be the hunt itself given form and share the ferocious temperament of their riders.

[Gain glamour, recuperation, +2 invulnerability, +1 morale, +2 hp, +1 strength in forests.]"
-- stats compared with elven steed
#size 5
#hp 22 -- +2
#str 15 -- +2 over a horse
#gcost 25 -- +5
#weapon 1162 -- magic antlers with charge bonus etc
#weapon 1161 -- magic hoof
#rcost 1
#rpcost 18 -- +2
#att 11 -- +1
#def 12 -- +1
#ap 30 --
#mapmove 28 ---
#maxage 80 -- double
#mr 14 -- +4
#bravemount 100 -- 100% chance it fights on
#mor 13 -- +2
#enc 2 --
#invuln 8
#snow
#forestsurvival
#forestshape 14388
#magicbeing -- added
#berserk 2 -- added
#springpower 50 - same as red guard
#holy
#end

-- Steed of Kurnous (forest shape)

#newmonster 14388
#copystats 3513 -- basic riding horse
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Wood_Elves/Wild_Rider_Mount.tga"
#spr2 "Warhammer_Wood_Elves/Wild_Rider_Mount2.tga"
#name "Steed of Kurnous"
#descr "The Riders that form the Wild Hunt of Orion go into battle atop Steeds of Kurnous, magical deerlike beasts that are said to be the hunt itself given form and share the ferocious temperament of their riders.

[Loses glamour, recuperation, 2 invulnerability, 1 morale, 2 hp, 1 strength outside forests.]
[Non-forest shape temporarily disabled due to Dominions 6 bug with mounted terrain shapes]" 
-- stats compared with non forest shape
#size 5
#hp 24 -- +2
#str 16 -- +1
#gcost 25 -- 
#weapon 1162 -- magic antlers with charge bonus etc
#weapon 1161 -- magic hoof
#rcost 1
#rpcost 18 -- 
#att 11 -- 
#def 12 -- 
#ap 30 --
#mapmove 28 ---
#maxage 80 -- 
#mr 14 -- 
#bravemount 100 -- 100% chance it fights on
#mor 14 -- +1
#enc 2 --
#invuln 10 -- +2
#snow
#forestsurvival
--plainshape 14387
#magicbeing --
#berserk 2 --
#glamour -- added
#springpower 50 - same as red guard
#holy
#heal
#end


-- Wild Rider (new mounted)

#newmonster 14141
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Wild_Rider.tga"
#spr2 "Warhammer_Wood_Elves/Wild_Rider2.tga"
#name "Wild Rider"
#descr "The Wild Riders of Kurnous are Orion's personal guard, each as aggressive and impulsive as he. While they were once Elves they are now fey and dangerous creatures, permanently part of the Wild Hunt having taken the position and surrendered their former mortal life in honour of Orion and Kurnous. It is their sacred duty to protect the King's Glade where Orion lies in his death-sleep during the winter, though much like their master they are at their strongest during the spring season and are at their weakest point in the months leading up to winter. These members of the Wild Hunt are easily recognised for their eyes blaze with power and their skin and hair is green and crackles with energy as their bloodlust builds. They ride into battle atop Steeds of Kurnous, magical deerlike beasts that are said to be the hunt itself given form and share the ferocious temperament of their riders. Wild Riders wear little armour save their horned masks, relying on their devasating charge and heedless aggression to see them through combat, though they are also supernaturally durable and resistant to hostile magic. Should a Rider lose their Steed they will be restored immediately after battle.

[Automatically regains mount if lost, but this is currently bugged]
[Gain glamour, recuperation, +1 morale, +1 strength, +2 hp, +2 invulnerability, +1 patrolbonus in forests]"
#hp 12
#weapon 1142 -- asrai lance
#armor 10 -- leather hauberk
#armor 162 -- crested helmet
#gcost 35 -- (60)
#rpcost 20
#patrolbonus 1
#berserk 3 -- standard strong berserk
#att 14
#def 13
#str 12 -- very strong for an elf
#mor 16
#mr 14 -- protected against magic (ward save 6+)
#invulnerable 6
#magicbeing
#forestshape 14142
#springpower 50 - same as red guard
#holy
#skilledrider 3
#mountmnr 14387 -- steed of kurnous
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Rider_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Rider_Unmounted2.tga"
#regainmount 1
#end


-- Wild Rider (forest shape) (new mounted)

#newmonster 14142
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Wild_Rider.tga"
#spr2 "Warhammer_Wood_Elves/Wild_Rider2.tga"
#name "Wild Rider"
#descr "The Wild Riders of Kurnous are Orion's personal guard, each as aggressive and impulsive as he. While they were once Elves they are now fey and dangerous creatures, permanently part of the Wild Hunt having taken the position and surrendered their former mortal life in honour of Orion and Kurnous. It is their sacred duty to protect the King's Glade where Orion lies in his death-sleep during the winter, though much like their master they are at their strongest during the spring season and are at their weakest point in the months leading up to winter. These members of the Wild Hunt are easily recognised for their eyes blaze with power and their skin and hair is green and crackles with energy as their bloodlust builds. They ride into battle atop Steeds of Kurnous, magical deerlike beasts that are said to be the hunt itself given form and share the ferocious temperament of their riders. Wild Riders wear little armour save their horned masks, relying on their devasating charge and heedless aggression to see them through combat, though they are also supernaturally durable and resistant to hostile magic. Should a Rider lose their Steed they will be restored immediately after battle.

[Automatically regains mount if lost, but this is currently bugged]
[Lose glamour, recuperation, 1 morale, 1 strength, 2 invulnerability, and 1 patrolbonus outside forests]
[Non-forest shape temporarily disabled due to Dominions 6 bug with mounted terrain shapes]"
#hp 12
#weapon 1142 -- asrai lance
#armor 10 -- leather hauberk
#armor 162 -- crested helmet
#gcost 35
#rpcost 20
#patrolbonus 2 -- +1
#berserk 3
#att 14
#def 13
#str 13 -- +1
#mor 17 -- +1
#mr 14
#invulnerable 8 -- +2
#magicbeing
--plainshape 14141
#springpower 50 - same as red guard
#holy
#glamour
#heal
#skilledrider 3
#mountmnr 14388 -- steed of kurnous forest shape
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Rider_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Rider_Unmounted2.tga"
#regainmount 1
#end


-- Dryad (autumn)

#newmonster 14143
#spr1 "Warhammer_Wood_Elves/Dryad_Autumn.tga"
#spr2 "Warhammer_Wood_Elves/Dryad_Autumn2.tga"
#name "Dryad"
#descr "Dryads are merciless spirits dedicated to the defence of Athel Loren that have taken up aspects of war to punish those who would threaten their realm. They appear as creatures of twisted wood and plant matter with baleful glowing eyes that release a keening screech as they descend on their prey to rend it asunder. Though they are fey, magical spirits their choice of corporeal form leaves them rather vulnerable to fire, though their wooden bodies are quite resistant to damage, especially when they are at their full strength in forested lands. The exact physical form a Dryad takes changes as the seasons do; in spring they are lithe and lash with long tendrils, in summer their bark hardens and they strike great bludgeoning blows, in autumn they tear at the foe with their claws, while in winter they become more brittle but ever more spiteful and pierce the enemy on sharp spines.

[Form depends on the season. Currently in Autumn form. Autumn form is the default when recruiting, no matter the season]
[Gain glamour, recuperation, +1 morale, +1 strength, +1 magic resistance, +1 hp, +1 protection in forests, lose gold upkeep]"
#size 3
#enc 1
#prot 7 -- same as vine man
#hp 15 -- tough
#weapon 29 -- claw
#weapon 29 -- claw
#gcost 15
#rpcost 12
#rcost 1
#mapmove 18 -- same as a satyr
#ap 14 -- same as a satyr/wood elf
#att 12 -- +1 for hatred
#def 11
#str 13 -- they are s3 but I need to push this because they have only claws to attack with
#mor 14
#mr 12
#fireres -5
#poisonres 15 -- same as vine man
#bluntres -- this is thematic and makes them more durable, vine men also have it
#pierceres -- this is thematic and makes them more durable, vine men also have it
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 600
#maxage 4000
#forestshape 14144
#springshape 14145
#summershape 14149
#wintershape 14147
#domrec 1
#end


-- Dryad (autumn - forest shape)

#newmonster 14144
#spr1 "Warhammer_Wood_Elves/Dryad_Autumn.tga"
#spr2 "Warhammer_Wood_Elves/Dryad_Autumn2.tga"
#name "Dryad"
#descr "Dryads are merciless spirits dedicated to the defence of Athel Loren that have taken up aspects of war to punish those who would threaten their realm. They appear as creatures of twisted wood and plant matter with baleful glowing eyes that release a keening screech as they descend on their prey to rend it asunder. Though they are fey, magical spirits their choice of corporeal form leaves them rather vulnerable to fire, though their wooden bodies are quite resistant to damage, especially when they are at their full strength in forested lands. The exact physical form a Dryad takes changes as the seasons do; in spring they are lithe and lash with long tendrils, in summer their bark hardens and they strike great bludgeoning blows, in autumn they tear at the foe with their claws, while in winter they become more brittle but ever more spiteful and pierce the enemy on sharp spines.

[Form depends on the season. Currently in Autumn form. Autumn form is the default when recruiting, no matter the season]
[Lose glamour, recuperation, 1 morale, 1 strength, 1 magic resistance, 1 hp, 1 protection and gain gold upkeep outside forests]"
#size 3
#enc 1
#prot 8 -- +1
#hp 16 -- +1
#weapon 29 -- claw
#weapon 29 -- claw
#gcost 15
#rpcost 12
#rcost 1
#mapmove 18 -- same as a satyr
#ap 14 -- same as a satyr/wood elf
#att 12
#def 11
#str 14 -- +1
#mor 15 -- +1
#mr 13 -- +1
#fireres -5
#poisonres 15
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 600
#maxage 4000
#heal -- can heal themselves easily
#plainshape 14143
#glamour
#addupkeep -999
#springshape 14146
#summershape 14150
#wintershape 14148
#domrec 1
#end


-- Dryad (spring)

#newmonster 14145
#spr1 "Warhammer_Wood_Elves/Dryad_Spring.tga"
#spr2 "Warhammer_Wood_Elves/Dryad_Spring2.tga"
#name "Dryad"
#descr "Dryads are merciless spirits dedicated to the defence of Athel Loren that have taken up aspects of war to punish those who would threaten their realm. They appear as creatures of twisted wood and plant matter with baleful glowing eyes that release a keening screech as they descend on their prey to rend it asunder. Though they are fey, magical spirits their choice of corporeal form leaves them rather vulnerable to fire, though their wooden bodies are quite resistant to damage, especially when they are at their full strength in forested lands. The exact physical form a Dryad takes changes as the seasons do; in spring they are lithe and lash with long tendrils, in summer their bark hardens and they strike great bludgeoning blows, in autumn they tear at the foe with their claws, while in winter they become more brittle but ever more spiteful and pierce the enemy on sharp spines.

[Form depends on the season. Currently in Spring form]
[Gain glamour, recuperation, +1 morale, +1 strength, +1 magic resistance, +1 hp, +1 protection in forests, lose gold upkeep]"
#size 3
#enc 1
#prot 6 -- -1
#hp 14 -- -1
#weapon 1146 -- poison whip
#weapon 29 -- claw
#gcost 15
#rpcost 12
#rcost 1
#mapmove 18
#ap 14
#att 12
#def 11
#str 13
#mor 14
#mr 12
#fireres -5
#poisonres 20 -- +5 for spring
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 600
#maxage 4000
#forestshape 14146
#summershape 14149
#autumnshape 14143
#wintershape 14147
#regeneration 10 -- in spring form they regenerate
#domrec 1
#end


-- Dryad (spring - forest shape)

#newmonster 14146
#spr1 "Warhammer_Wood_Elves/Dryad_Spring.tga"
#spr2 "Warhammer_Wood_Elves/Dryad_Spring2.tga"
#name "Dryad"
#descr "Dryads are merciless spirits dedicated to the defence of Athel Loren that have taken up aspects of war to punish those who would threaten their realm. They appear as creatures of twisted wood and plant matter with baleful glowing eyes that release a keening screech as they descend on their prey to rend it asunder. Though they are fey, magical spirits their choice of corporeal form leaves them rather vulnerable to fire, though their wooden bodies are quite resistant to damage, especially when they are at their full strength in forested lands. The exact physical form a Dryad takes changes as the seasons do; in spring they are lithe and lash with long tendrils, in summer their bark hardens and they strike great bludgeoning blows, in autumn they tear at the foe with their claws, while in winter they become more brittle but ever more spiteful and pierce the enemy on sharp spines.

[Form depends on the season. Currently in Spring form]
[Lose glamour, recuperation, 1 morale, 1 strength, 1 magic resistance, 1 hp, 1 protection and gain gold upkeep outside forests]"
#size 3
#enc 1
#prot 7 -- +1
#hp 15 -- +1
#weapon 1146 -- poison whip
#weapon 29 -- claw
#gcost 15
#rpcost 12
#rcost 1
#mapmove 18
#ap 14
#att 12
#def 11
#str 14 -- +1
#mor 15 -- +1
#mr 13 -- +1
#fireres -5
#poisonres 20 -- spring
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 600
#maxage 4000
#heal -- can heal themselves easily
#plainshape 14145
#glamour
#addupkeep -999
#summershape 14150
#autumnshape 14144
#wintershape 14148
#regeneration 10 -- in spring form they regenerate
#domrec 1
#end


-- Dryad (winter)

#newmonster 14147
#spr1 "Warhammer_Wood_Elves/Dryad_Winter.tga"
#spr2 "Warhammer_Wood_Elves/Dryad_Winter2.tga"
#name "Dryad"
#descr "Dryads are merciless spirits dedicated to the defence of Athel Loren that have taken up aspects of war to punish those who would threaten their realm. They appear as creatures of twisted wood and plant matter with baleful glowing eyes that release a keening screech as they descend on their prey to rend it asunder. Though they are fey, magical spirits their choice of corporeal form leaves them rather vulnerable to fire, though their wooden bodies are quite resistant to damage, especially when they are at their full strength in forested lands. The exact physical form a Dryad takes changes as the seasons do; in spring they are lithe and lash with long tendrils, in summer their bark hardens and they strike great bludgeoning blows, in autumn they tear at the foe with their claws, while in winter they become more brittle but ever more spiteful and pierce the enemy with spines of frost hardened wood.

[Form depends on the season. Currently in Winter form]
[Gain glamour, recuperation, +1 morale, +1 strength, +1 magic resistance, +1 hp, +1 protection in forests, lose gold upkeep]"
#size 3
#enc 1
#prot 5 -- 2 lower
#hp 13 -- 2 less
#weapon 1147 -- frost spike
#weapon 1147 -- frost spike
#gcost 15
#rpcost 12
#rcost 1
#mapmove 18 -- same as a satyr
#ap 14 -- same as a satyr/wood elf
#att 12 -- +1 for hatred
#def 11
#str 12
#mor 15 -- increased for winter
#mr 12
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
--bluntres -- they lose this because winter
#pierceres -- this is thematic and makes them more durable, vine men also have it
#magicbeing
#forestsurvival
#snow
#spiritsight
#plant
#neednoteat
#startage 600
#maxage 4000
#forestshape 14148
#springshape 14145
#summershape 14149
#autumnshape 14143
#domrec 1
#end


-- Dryad (winter - forest shape)

#newmonster 14148
#spr1 "Warhammer_Wood_Elves/Dryad_Winter.tga"
#spr2 "Warhammer_Wood_Elves/Dryad_Winter2.tga"
#name "Dryad"
#descr "Dryads are merciless spirits dedicated to the defence of Athel Loren that have taken up aspects of war to punish those who would threaten their realm. They appear as creatures of twisted wood and plant matter with baleful glowing eyes that release a keening screech as they descend on their prey to rend it asunder. Though they are fey, magical spirits their choice of corporeal form leaves them rather vulnerable to fire, though their wooden bodies are quite resistant to damage, especially when they are at their full strength in forested lands. The exact physical form a Dryad takes changes as the seasons do; in spring they are lithe and lash with long tendrils, in summer their bark hardens and they strike great bludgeoning blows, in autumn they tear at the foe with their claws, while in winter they become more brittle but ever more spiteful and pierce the enemy with spines of frost hardened wood.

[Form depends on the season. Currently in Winter form]
[Lose glamour, recuperation, 1 morale, 1 strength, 1 magic resistance, 1 hp, 1 protection and gain gold upkeep outside forests]"
#size 3
#enc 1
#prot 6 -- +1
#hp 14 -- +1
#weapon 1147 -- frost spike
#weapon 1147 -- frost spike
#gcost 15
#rpcost 12
#rcost 1
#mapmove 18 -- same as a satyr
#ap 14 -- same as a satyr/wood elf
#att 12
#def 11
#str 13 -- +1
#mor 16 -- +1
#mr 13 -- +1
#fireres -5
#poisonres 15
#coldres 5
--bluntres -- winter
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#snow
#neednoteat
#startage 600
#maxage 4000
#heal -- can heal themselves easily
#plainshape 14147
#glamour
#addupkeep -999
#springshape 14146
#summershape 14150
#autumnshape 14144
#domrec 1
#end


-- Dryad (summer)

#newmonster 14149
#spr1 "Warhammer_Wood_Elves/Dryad_Summer.tga"
#spr2 "Warhammer_Wood_Elves/Dryad_Summer2.tga"
#name "Dryad"
#descr "Dryads are merciless spirits dedicated to the defence of Athel Loren that have taken up aspects of war to punish those who would threaten their realm. They appear as creatures of twisted wood and plant matter with baleful glowing eyes that release a keening screech as they descend on their prey to rend it asunder. Though they are fey, magical spirits their choice of corporeal form leaves them rather vulnerable to fire, though their wooden bodies are quite resistant to damage, especially when they are at their full strength in forested lands. The exact physical form a Dryad takes changes as the seasons do; in spring they are lithe and lash with long tendrils, in summer their bark hardens and they strike great bludgeoning blows, in autumn they tear at the foe with their claws, while in winter they become more brittle but ever more spiteful and pierce the enemy with spines of frost hardened wood.

[Form depends on the season. Currently in Summer form]
[Gain glamour, recuperation, +1 morale, +1 strength, +1 magic resistance, +1 hp, +1 protection in forests, lose gold upkeep]"
#size 3
#enc 1
#prot 9 -- +2 for summer
#hp 17 -- +2 for summer
#weapon 1149 -- oaken fist
#weapon 1149 -- oaken fist
#gcost 15
#rpcost 12
#rcost 1
#mapmove 18 -- same as a satyr
#ap 14 -- same as a satyr/wood elf
#att 12 -- +1 for hatred
#def 11
#str 15 -- +2 in summer
#mor 14
#mr 12
#fireres -5
#poisonres 15 -- same as vine man
#bluntres -- this is thematic and makes them more durable, vine men also have it
#pierceres -- this is thematic and makes them more durable, vine men also have it
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 600
#maxage 4000
#forestshape 14150
#springshape 14145
#autumnshape 14143
#wintershape 14147
#domrec 1
#end


-- Dryad (summer - forest shape)

#newmonster 14150
#spr1 "Warhammer_Wood_Elves/Dryad_Summer.tga"
#spr2 "Warhammer_Wood_Elves/Dryad_Summer2.tga"
#name "Dryad"
#descr "Dryads are merciless spirits dedicated to the defence of Athel Loren that have taken up aspects of war to punish those who would threaten their realm. They appear as creatures of twisted wood and plant matter with baleful glowing eyes that release a keening screech as they descend on their prey to rend it asunder. Though they are fey, magical spirits their choice of corporeal form leaves them rather vulnerable to fire, though their wooden bodies are quite resistant to damage, especially when they are at their full strength in forested lands. The exact physical form a Dryad takes changes as the seasons do; in spring they are lithe and lash with long tendrils, in summer their bark hardens and they strike great bludgeoning blows, in autumn they tear at the foe with their claws, while in winter they become more brittle but ever more spiteful and pierce the enemy with spines of frost hardened wood.

[Form depends on the season. Currently in Summer form]
[Lose glamour, recuperation, 1 morale, 1 strength, 1 magic resistance, 1 hp, 1 protection and gain gold upkeep outside forests]"
#size 3
#enc 1
#prot 10 -- +1
#hp 18 -- +1
#weapon 1149 -- oaken fist
#weapon 1149 -- oaken fist
#gcost 15
#rpcost 12
#rcost 1
#mapmove 18 -- same as a satyr
#ap 14 -- same as a satyr/wood elf
#att 12
#def 11
#str 16 -- +1
#mor 15 -- +1
#mr 13 -- +1
#fireres -5
#poisonres 15
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 600
#maxage 4000
#heal -- can heal themselves easily
#plainshape 14149
#glamour
#addupkeep -999
#springshape 14146
#autumnshape 14144
#wintershape 14148
#domrec 1
#end


-- Treekin

#newmonster 14173
#spr1 "Warhammer_Wood_Elves/Treekin.tga"
#spr2 "Warhammer_Wood_Elves/Treekin2.tga"
#name "Tree Kin"
#descr "Tree Kin are hunks of deadwood animated into a hulking, twisted form somewhere between elf and ogre. They do not fight with finesse but with gnarbled clubbing fists that batter apart armour and pummel flesh and tearing claws of jagged and splintering wood that rend and tear. Tree Kin are truly implacable for they feel nothing at all, save a compulsion to destroy the enemies of Athel Loren. When Asrai warriors perish their souls typically abandon their identity and become one with the Weave of the forest, but there are a few that cannot abandon their formers lives and though they quickly lose their memories and personality, they retain a drive to protect that which they loved in life. To Tree Kin the world is a strange place, hidden beyond a shroud of confusion and shattered fragments of memories they cannot even recognise as their own, and unlike forest spirits like Dryads they feel no spite, nor do they have the deep relationship with the forest held by the superficially similar Treemen; instead they are compelled to wordlessly serve Athel Loren as lumbering enforcers of her will. Often Tree Kin will stand guard for decades or even centuries in long abandoned glades, but in times of war they can reliably be called forth to do battle and join the great Asrai hosts in defence of their homeland.

[Gain glamour, recuperation, +2 strength, +1 magic resistance, +4 hp, +2 protection in forests, lose gold upkeep. Requires Dominion 4+ and a temple to recruit]
[Recruitment limited to 3 per month]"
#size 5
#enc 1
#prot 13 -- they have a 4+ save which is pretty amazing
#hp 40 -- big, 3 wounds
#weapon 1149 -- oaken fist
#weapon 29 -- claw
#gcost 50
#rpcost 24
#rcost 1
#mapmove 18 -- same as a satyr
#ap 14 -- same as a satyr/wood elf
#att 11
#def 10
#str 17 -- they are s4 but I need to push this because of their weapons
#mor 30 -- near mindless
#mr 12
#fireres -5 -- dead wood
#poisonres 15 -- same as vine man
#coldres 5
#pierceres -- this is thematic and makes them more durable, vine men also have it
#magicbeing
#forestsurvival
#snow
#spiritsight
#plant
#neednoteat
#startage 600
#maxage 4000
#forestshape 14174
#domrec 4
#reclimit 3
#reqtemple
#end


-- Treekin (forest shape)

#newmonster 14174
#spr1 "Warhammer_Wood_Elves/Treekin.tga"
#spr2 "Warhammer_Wood_Elves/Treekin2.tga"
#name "Tree Kin"
#descr "Tree Kin are hunks of deadwood animated into a hulking, twisted form somewhere between elf and ogre. They do not fight with finesse but with gnarbled clubbing fists that batter apart armour and pummel flesh and tearing claws of jagged and splintering wood that rend and tear. Tree Kin are truly implacable for they feel nothing at all, save a compulsion to destroy the enemies of Athel Loren. When Asrai warriors perish their souls typically abandon their identity and become one with the Weave of the forest, but there are a few that cannot abandon their formers lives and though they quickly lose their memories and personality, they retain a drive to protect that which they loved in life. To Tree Kin the world is a strange place, hidden beyond a shroud of confusion and shattered fragments of memories they cannot even recognise as their own, and unlike forest spirits like Dryads they feel no spite, nor do they have the deep relationship with the forest held by the superficially similar Treemen; instead they are compelled to wordlessly serve Athel Loren as lumbering enforcers of her will. Often Tree Kin will stand guard for decades or even centuries in long abandoned glades, but in times of war they can reliably be called forth to do battle and join the great Asrai hosts in defence of their homeland.

[Lose glamour, recuperation, 2 strength, 1 magic resistance, 4 hp, 2 protection outside forests, gain gold upkeep. Requires Dominion 4+ and a temple to recruit]
[Recruitment limited to 3 per month]"
#size 5
#enc 1
#prot 15 -- +2
#hp 44 -- +4
#weapon 1149 -- oaken fist
#weapon 29 -- claw
#gcost 50
#addupkeep -50
#rpcost 24
#rcost 1
#mapmove 18 -- same as a satyr
#ap 14 -- same as a satyr/wood elf
#att 11
#def 10
#str 19 -- +2
#mor 30 -- near mindless
#mr 13 -- +1
#fireres -5 -- dead wood
#poisonres 15 -- same as vine man
#coldres 5
#pierceres -- this is thematic and makes them more durable, vine men also have it
#magicbeing
#forestsurvival
#snow
#spiritsight
#plant
#neednoteat
#startage 600
#maxage 4000
#plainshape 14173
#domrec 4
#reclimit 3
#glamour
#heal
#reqtemple
#end

-- Steed of Isha (new mounted)

#newmonster 14389
#copystats 3513 -- basic riding horse
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Wood_Elves/Thorn_Sister_Mount.tga"
#spr2 "Warhammer_Wood_Elves/Thorn_Sister_Mount2.tga"
#name "Steed of Isha"
#descr "The magical Steeds of Isha are deerlike creatures with glowing antlers who are said to be able to see and change their own fate, allowing them to prance through missile fire and dodge attacks in melee.

[Gain glamour, recuperation, +2 invulnerability, +1 morale, +2 hp, +1 strength in forests.]"
#size 5
#hp 18
#str 15 -- +2 over a horse
#gcost 25
#weapon 1162 -- magic antlers with charge bonus etc
#weapon 1161 -- magic hoof
#rcost 1
#rpcost 18 -- +2
#att 10
#def 13 --
#ap 30 --
#mapmove 28 ---
#maxage 80 -- double
#mr 15
#bravemount 100 -- 100% chance it fights on
#mor 12
#enc 2 --
#invuln 8
#snow
#forestsurvival
#forestshape 14390
#magicbeing -- added
#holy
#airshield 50
#end


-- Steed of Isha (forest shape) (new mounted)

#newmonster 14390
#copystats 3513 -- basic riding horse
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Wood_Elves/Thorn_Sister_Mount.tga"
#spr2 "Warhammer_Wood_Elves/Thorn_Sister_Mount2.tga"
#name "Steed of Isha"
#descr "The magical Steeds of Isha are deerlike creatures with glowing antlers who are said to be able to see and change their own fate, allowing them to prance through missile fire and dodge attacks in melee.

[Loses glamour, recuperation, 2 invulnerability, 1 morale, 2 hp, 1 strength outside forests.]
[Non-forest shape temporarily disabled due to Dominions 6 bug with mounted terrain shapes]" 
-- stats compared with non forest shape
#size 5
#hp 20 -- +2
#str 14 -- +1
#gcost 25 -- 
#weapon 1162 -- magic antlers with charge bonus etc
#weapon 1161 -- magic hoof
#rcost 1
#rpcost 18 -- 
#att 10 -- 
#def 13 -- 
#ap 30 --
#mapmove 28 ---
#maxage 80 -- 
#mr 15
#bravemount 100 -- 100% chance it fights on
#mor 13
#enc 2 --
#invuln 10 -- +2
#snow
#forestsurvival
--plainshape 14389
#magicbeing --
#glamour -- added
#holy
#heal
#airshield 50
#end


-- Sister of the Thorn

#newmonster 14151
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Thorn_Sister.tga"
#spr2 "Warhammer_Wood_Elves/Thorn_Sister2.tga"
#name "Sister of the Thorn"
#descr "The Sisters of the Thorn are servants of the goddess Isha and thus handmaidens of Ariel, that much is known to all Wood Elves, though their origin and exact organisation is shrouded in mystery. Some say that they were once a coven of Dark Elf sorceresses turned to the service of Athel Loren, others say they are Asrai maidens possessed by the spirits of Dryads; all agree that they are to be feared and loved in equal measure. While the Sisters are stalwart defenders of the Wood Elf realm and people and their aid can be relied upon, it is known that aid always comes at some price to be paid at a future date. As servants of Isha the Sisters ride atop magical Steeds of Isha of great agility, deerlike creatures with glowing antlers who are said to be able to see and change their own fate, allowing them to prance through missile fire and dodge attacks in melee. The Sisters of the Thorn make extensive use of the poisons produced by many plants across Athel Loren on both their lances and infamous Blackbriar javelins. Such is their connection with the forest and magical power that they can command roots and vines to entangle their foes at the moment before they deliver their lance charge. Should a Sister fall in battle it is said her spirit will return to the heart of Athel Loren and in some secret glade fall under the care of Isha until she springs forth to serve once more in the renewing season of Spring. If a Sister ever loses her steed another will find her, for Isha can see the future and will always provide for her servants.

[Automatically regains mount if lost, but this is currently bugged]
[Gain glamour, recuperation, entangling weapon, +1 morale, and +1 hp in forests]
[Not currently immortal due to a bug with mounted immortals]"
#weapon 1151 -- lance of Isha
#weapon 1152 -- blackbriar javelin
#armor 10 -- leather hauberk
#armor 162 -- crested helmet
#def 13 -- fateweaving stuff
--gcost 50
#gcost 25
#rpcost 20
#mor 13 -- +1 over normal wood elf
#mr 15 -- protected against magic (ward save 4+)
#forestshape 14152
--immortal
--springimmortal
#holy
#airshield 50
#female
#regainmount 1
#skilledrider 3
#mobilearcher 1
#mountmnr 14389 -- steed of isha
#unmountedspr1 "Warhammer_Wood_Elves/Thorn_Sister_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Thorn_Sister_Unmounted2.tga"
#end


-- Sister of the Thorn (forest shape)

#newmonster 14152
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Thorn_Sister.tga"
#spr2 "Warhammer_Wood_Elves/Thorn_Sister2.tga"
#name "Sister of the Thorn"
#descr "The Sisters of the Thorn are servants of the goddess Isha and thus handmaidens of Ariel, that much is known to all Wood Elves, though their origin and exact organisation is shrouded in mystery. Some say that they were once a coven of Dark Elf sorceresses turned to the service of Athel Loren, others say they are Asrai maidens possessed by the spirits of Dryads; all agree that they are to be feared and loved in equal measure. While the Sisters are stalwart defenders of the Wood Elf realm and people and their aid can be relied upon, it is known that aid always comes at some price to be paid at a future date. As servants of Isha the Sisters ride atop magical Steeds of Isha of great agility, deerlike creatures with glowing antlers who are said to be able to see and change their own fate, allowing them to prance through missile fire and dodge attacks in melee. The Sisters of the Thorn make extensive use of the poisons produced by many plants across Athel Loren on both their lances and infamous Blackbriar javelins. Such is their connection with the forest and magical power that they can command roots and vines to entangle their foes at the moment before they deliver their lance charge. Should a Sister fall in battle it is said her spirit will return to the heart of Athel Loren and in some secret glade fall under the care of Isha until she springs forth to serve once more in the renewing season of Spring. If a Sister ever loses her steed another will find her, for Isha can see the future and will always provide for her servants.

[Automatically regains mount if lost, but this is currently bugged]
[Lose glamour, recuperation, entangling weapon, 1 morale, and 1 hp outside forests]
[Non-forest shape temporarily disabled due to Dominions 6 bug with mounted terrain shapes]
[Not currently immortal due to a bug with mounted immortals]"
#weapon 1150 -- entangling roots
#weapon 1151 -- lance of Isha
#weapon 1152 -- blackbriar javelin
#armor 10 -- leather hauberk
#armor 162 -- crested helmet
#hp 10 -- +1
#def 13
--gcost 50
#gcost 25
#rpcost 20
#mor 14 -- +1
#mr 15
--plainshape 14151
--immortal
--springimmortal
#holy
#airshield 50
#heal
#glamour
#female
#regainmount 1
#skilledrider 3
#mobilearcher 1
#mountmnr 14390 -- steed of isha
#unmountedspr1 "Warhammer_Wood_Elves/Thorn_Sister_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Thorn_Sister_Unmounted2.tga"
#end


----- Wildwood Ranger

#newmonster 14155
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Wildwood_Ranger.tga"
#spr2 "Warhammer_Wood_Elves/Wildwood_Ranger2.tga"
#name "Wildwood Ranger"
#descr "Athel Loren is not a safe place, even for the Elves. Even now, thousands of years on from the first Great Council, there are those forest spirits who resent the Elves' presence, and visit upon them whatever cruelties are in their power. Banished to the sinister south-eastern corner of Athel Loren known as the Wildwood, these dark spirits rail against the waystone fence that confines them and dream darkly of revenge on those who have occupied their home. The task of guarding the border between this shadowy prison and the rest of Athel Loren falls to the Wildwood Rangers. Theirs is an existence thoroughly at odds with the gaiety and splendour known by other Wood Elves, for just as the creatures of the Wildwood do not rest, nor can those who have sworn to keep them trammelled. The waystone fence is ever under attack, and it suffers disruption more often than any care to contemplate. Any breach, however small, brings with it the risk of carnage as the dark spirits slip loose from their bonds and wreak all manner of havoc in the forest beyond. The Rangers converge on such breaches within moments of their formation, holding back the tide of dark spirits long enough for Spellweavers to make the waystone barriers whole once again. Thus must the Rangers be ever-vigilant, so that their kinsfolk need not live in fear. Wildwood Rangers are armed and armoured in a fashion that sets them apart from other Asrai, with great two handed cleaving glaives and much heavier armour than is typical, for they specialise in destroying hardy foes able to unleash an onslaught of strikes. In times of conflict detachments of the Rangers are given leave from their watch duty to put their unique skills to use against the foes of Athel Loren across the wider world.

[Gain glamour, +1 hp, +1 strength, +1 morale, and +2 patrolbonus in forests]"
#gcost 18
#armor 12 -- scale mail hauberk
#armor 20 -- iron cap
#weapon 1155 -- spiritbane glaive
#forestshape 14156
#rpcost 18
#att 13
#hp 10 -- tougher
#str 10 -- stronger
#mor 15
#mr 13 -- specialists in fighting magical crap
#spiritsight
#end


----- Wildwood Ranger (forest)

#newmonster 14156
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Wildwood_Ranger.tga"
#spr2 "Warhammer_Wood_Elves/Wildwood_Ranger2.tga"
#name "Wildwood Ranger"
#descr "Athel Loren is not a safe place, even for the Elves. Even now, thousands of years on from the first Great Council, there are those forest spirits who resent the Elves' presence, and visit upon them whatever cruelties are in their power. Banished to the sinister south-eastern corner of Athel Loren known as the Wildwood, these dark spirits rail against the waystone fence that confines them and dream darkly of revenge on those who have occupied their home. The task of guarding the border between this shadowy prison and the rest of Athel Loren falls to the Wildwood Rangers. Theirs is an existence thoroughly at odds with the gaiety and splendour known by other Wood Elves, for just as the creatures of the Wildwood do not rest, nor can those who have sworn to keep them trammelled. The waystone fence is ever under attack, and it suffers disruption more often than any care to contemplate. Any breach, however small, brings with it the risk of carnage as the dark spirits slip loose from their bonds and wreak all manner of havoc in the forest beyond. The Rangers converge on such breaches within moments of their formation, holding back the tide of dark spirits long enough for Spellweavers to make the waystone barriers whole once again. Thus must the Rangers be ever-vigilant, so that their kinsfolk need not live in fear. Wildwood Rangers are armed and armoured in a fashion that sets them apart from other Asrai, with great two handed cleaving glaives and much heavier armour than is typical, for they specialise in destroying hardy foes able to unleash an onslaught of strikes. In times of conflict detachments of the Rangers are given leave from their watch duty to put their unique skills to use against the foes of Athel Loren across the wider world.

[Lose glamour, 1 hp, 1 strength, 1 morale, and 2 patrolbonus outside forests]"
#gcost 18
#armor 12 -- scale mail hauberk
#armor 20 -- iron cap
#weapon 1155 -- spiritbane glaive
#plainshape 14155
#rpcost 18
#patrolbonus 2 -- +1
#att 13
#hp 11 -- +1
#str 11 -- +1
#mor 16 -- +1
#mr 13
#glamour
#spiritsight
#end


----- Waywatcher

#newmonster 14161
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Waywatcher.tga"
#spr2 "Warhammer_Wood_Elves/Waywatcher2.tga"
#name "Waywatcher"
#descr "Waywatchers and silent sentinels, the guardians of the paths leading into Athel Loren. They are masters of concealment, tracking, and hunting. Waywatchers almost always spent their youth as a member of the Deepwood Scouts but there is no formal system of promotion by which they join the ranks of the Waywatchers, rather some Elves simply become more at home in the forest than they do in the society of the Asrai and choose to embark on a decades long pilgrimage to learn the ways of the wilds. Many do not return from this sojourn, but those that do have achieved a harmony with Athel Loren that goes far beyond what one of their kind could typically experience. Waywatchers are superb archers, capable of placing arrows in the weak points of enemy armour with terrifying accuracy. They wear bracers carved from the bone of some unfamiliar creature and inscribed with strange symbols, use this same bone to reinforce their hoods and protect their senses, and cover themselves in foliage to better conceal their movements until the moment is right to strike.

[Gain glamour, +1 hp, +1 strength, +1 morale, +1 precision, and +2 patrolbonus in forests. Waywatcher Long Bow will not harm friendlies in forests]
[Recruitment limited to 5 per month]"
#gcost 30
#armor 15 -- full leather armour
#armor 150 -- bone helmet
#weapon 9 -- dagger
#weapon 9 -- dagger
#weapon 1157 -- Waywatcher Long Bow
#forestshape 14162
#rpcost 30 -- same as glade rider
#hp 10 -- tougher
#str 10 -- stronger
#prec 14 -- extremely good shots
#mountainsurvival
#stealthy 60 -- same as a spy
#mor 14
#patrolbonus 2
#supplybonus 3
#skirmisher 1
#reclimit 5
#end


----- Waywatcher (forest)

#newmonster 14162
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Waywatcher.tga"
#spr2 "Warhammer_Wood_Elves/Waywatcher2.tga"
#name "Waywatcher"
#descr "Waywatchers and silent sentinels, the guardians of the paths leading into Athel Loren. They are masters of concealment, tracking, and hunting. Waywatchers almost always spent their youth as a member of the Deepwood Scouts but there is no formal system of promotion by which they join the ranks of the Waywatchers, rather some Elves simply become more at home in the forest than they do in the society of the Asrai and choose to embark on a decades long pilgrimage to learn the ways of the wilds. Many do not return from this sojourn, but those that do have achieved a harmony with Athel Loren that goes far beyond what one of their kind could typically experience. Waywatchers are superb archers, capable of placing arrows in the weak points of enemy armour with terrifying accuracy. They wear bracers carved from the bone of some unfamiliar creature and inscribed with strange symbols, use this same bone to reinforce their hoods and protect their senses, and cover themselves in foliage to better conceal their movements until the moment is right to strike.

[Lose glamour, 1 hp, 1 strength, 1 morale, 1 precision, and 2 patrolbonus outside forests.  Waywatcher Long Bow will harm friendlies outside forests]
[Recruitment limited to 5 per month]"
#gcost 30
#armor 15 -- full leather armour
#armor 150 -- bone helmet
#weapon 9 -- dagger
#weapon 9 -- dagger
#weapon 1206 -- Waywatcher Long Bow
#plainshape 14161
#rpcost 24
#hp 11 -- +1
#str 11 -- +1
#prec 15 -- +1
#mountainsurvival
#stealthy 60
#mor 15 -- +1
#patrolbonus 4 -- +2
#supplybonus 3
#glamour
#skirmisher 1
#reclimit 5
#end


----- Wardancer

#newmonster 14159
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Wardancer.tga"
#spr2 "Warhammer_Wood_Elves/Wardancer2.tga"
#name "Wardancer"
#descr "Wardancers are the warrior-servants and worshippers of the Eleven trickster god Loec, who perform the vital service of leading their kind in music, story telling, and intricate dances that tell the chronicle of their people. Even so Wardancers are often regarded as wild and unpredictable, for they serve no Elven Court and are apart even from the spirits of the forest. To a Wardancer even other Elves appear to move slowly and clumsily, for the followers of Loec are in a constant state of dance, each movement or expression flowing perfectly into the next. Even in battle Wardancers continue to dance, unconsciously dodging blows, striking at weak points, and fighting in harmony with their allies. Though Wardancers wear no armour they are protected by magical tattoos representing all manner of creatures, activated in battle by the presence of one of their mysterious leaders, the Shadowdancers. They are known to style and dye their hair in striking shapes and colours and nearly always fight with a pair of deadly blades that they whirl about them with such skill that they are able to strike incoming arrows from the air.

[Gain glamour, +1 hp, +1 strength, and +1 morale in forests. Tattoos can be activated by a battle start spell cast automatically by a Shadowdancer]"
#gcost 25
#weapon 746 -- scimitar
#weapon 746 -- scimitar
#rpcost 20 -- +10
#att 14
#def 15 -- +1 for special dances
#mor 14
#ambidextrous 4
#airshield 30
#beartattoo 1 -- +1 strength per point
#horsetattoo 1 -- +1 def and +2 speed per point
#wolftattoo 1 -- +1 attack skill per point
#boartattoo 1 -- invuln increase?
#snaketattoo 1 -- magic res +1 per point
#forestshape 14160
#skirmisher 1
#end


----- Wardancer (forestshape)

#newmonster 14160
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Wardancer.tga"
#spr2 "Warhammer_Wood_Elves/Wardancer2.tga"
#name "Wardancer"
#descr "Wardancers are the warrior-servants and worshippers of the Eleven trickster god Loec, who perform the vital service of leading their kind in music, story telling, and intricate dances that tell the chronicle of their people. Even so Wardancers are often regarded as wild and unpredictable, for they serve no Elven Court and are apart even from the spirits of the forest. To a Wardancer even other Elves appear to move slowly and clumsily, for the followers of Loec are in a constant state of dance, each movement or expression flowing perfectly into the next. Even in battle Wardancers continue to dance, unconsciously dodging blows, striking at weak points, and fighting in harmony with their allies. Though Wardancers wear no armour they are protected by magical tattoos representing all manner of creatures, activated in battle by the presence of one of their mysterious leaders, the Shadowdancers. They are known to style and dye their hair in striking shapes and colours and nearly always fight with a pair of deadly blades that they whirl about them with such skill that they are able to strike incoming arrows from the air.

[Lose glamour, 1 hp, 1 strength, and 1 morale outside forests. Tattoos can be activated by a battle start spell cast automatically by a Shadowdancer]"
#gcost 25
#weapon 746 -- scimitar
#weapon 746 -- scimitar
#rpcost 20 -- +10
#att 14
#def 15 -- +1 for special dances
#hp 10 -- +1
#str 10 -- +1
#mor 15 -- +1
#ambidextrous 4
#airshield 30
#beartattoo 1 -- +1 strength per point
#horsetattoo 1 -- +1 def and +2 speed per point
#wolftattoo 1 -- +1 attack skill per point
#boartattoo 1 -- invuln increase?
#snaketattoo 1 -- magic res +1 per point
#glamour
#plainshape 14159
#skirmisher 1
#end


----- War Hawk Rider

#newmonster 14178
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Warhawk_Rider.tga"
#spr2 "Warhammer_Wood_Elves/Warhawk_Rider2.tga"
#name "Warhawk Rider"
#descr "A great many hawks and shrikes of great size inhabit the canopy of Athel Loren, especially in the regions where the great forest meets the Grey Mountains. These creatures can boast wingspans of fifteen or sixteen feet and are fierce, cunning predators with highly territorial natures, as all the inhabitants of Athel Loren tend to be. Though most Asrai live in the glades in the centre and west of Athel Loren, there are still many who call the eastern regions bordering the Grey Mountains their home and these elves have over the centuries formed a firm bond with these great avians. Warhawk Riders are yong elves who have reared a hawk or shrike from a hatchling, maturing with it and learning to fight in harmony. They are such expert riders that they are able to loose their arrows with great accuracy even as their mount twists and swoops through the air, their elevation and the superb eyesight of their mounts allowing them even more precision in reaching their target. Warhawk Riders wear very little armour and although they are armed with lances and their mounts boast deadly beaks and talons they should not be expected to fare well in prolonged melee. Should the rider be slain the Warhawk will fight on until the end of the battle.

[Gain glamour, +1 precision, +1 morale, and +1 patrolbonus in forests. Asrai Composite Bow will not harm friendlies in forests]
[Recruitment limited to 5 per month]"
#weapon 1142 -- asrai lance
#weapon 1143 -- composite bow
#armor 5 -- leather cuirass
#armor 120 -- leather cap
#hp 9 -- +1
#def 13 -- +1
#gcost 40
#patrolbonus 1
#forestshape 14179
#forestsurvival
#mountainsurvival
#prec 14 -- super good archers
#reclimit 5
#skirmisher 1
#skilledrider 3
#mobilearcher 1
#mountmnr 14177 -- warhawk riderless
#unmountedspr1 "Warhammer_Wood_Elves/Warhawk_Rider_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Warhawk_Rider_Unmounted2.tga"
#end


----- War Hawk Rider (forest)

#newmonster 14179
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Warhawk_Rider.tga"
#spr2 "Warhammer_Wood_Elves/Warhawk_Rider2.tga"
#name "Warhawk Rider"
#descr "A great many hawks and shrikes of great size inhabit the canopy of Athel Loren, especially in the regions where the great forest meets the Grey Mountains. These creatures can boast wingspans of fifteen or sixteen feet and are fierce, cunning predators with highly territorial natures, as all the inhabitants of Athel Loren tend to be. Though most Asrai live in the glades in the centre and west of Athel Loren, there are still many who call the eastern regions bordering the Grey Mountains their home and these elves have over the centuries formed a firm bond with these great avians. Warhawk Riders are yong elves who have reared a hawk or shrike from a hatchling, maturing with it and learning to fight in harmony. They are such expert riders that they are able to loose their arrows with great accuracy even as their mount twists and swoops through the air, their elevation and the superb eyesight of their mounts allowing them even more precision in reaching their target. Warhawk Riders wear very little armour and although they are armed with lances and their mounts boast deadly beaks and talons they should not be expected to fare well in prolonged melee. Should the rider be slain the Warhawk will fight on until the end of the battle.

[Lose glamour, 1 precision, 1 morale, and 1 patrolbonus outside of forests. Asrai Composite Bow will harm friendlies outside forests]
[Recruitment limited to 5 per month]
[Non-forest shape temporarily disabled due to Dominions 6 bug with mounted terrain shapes]"
#weapon 1142 -- asrai lance
#weapon 1205 -- composite bow
#armor 5 -- leather cuirass
#armor 120 -- leather cap
#hp 9 -- +1
#def 13 -- +1
#gcost 20
#mor 13
#patrolbonus 2
--plainshape 14178
#forestsurvival
#mountainsurvival
#prec 15 -- super good archers
#glamour
#reclimit 5
#skirmisher 1
#skilledrider 3
#mobilearcher 1
#mountmnr 14177 -- warhawk riderless
#unmountedspr1 "Warhammer_Wood_Elves/Warhawk_Rider_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Warhawk_Rider_Unmounted2.tga"
#end


----- War Hawk

#newmonster 14177
#spr1 "Warhammer_Wood_Elves/Warhawk.tga"
#spr2 "Warhammer_Wood_Elves/Warhawk2.tga"
#name "Warhawk"
#descr "A great many hawks and shrikes of great size inhabit the canopy of Athel Loren, especially in the regions where the great forest meets the Grey Mountains. These creatures can boast wingspans of fifteen or sixteen feet and are fierce, cunning predators with highly territorial natures, as all the inhabitants of Athel Loren tend to be. Though most Asrai live in the glades in the centre and west of Athel Loren, there are still many who call the eastern regions bordering the Grey Mountains their home and these elves have over the centuries formed a firm bond with these great avians. This Warhawk has lost his bonded rider and once the battle is over will return to the wilds."
--stats compared with great eagle
#gcost 25
#rpcost 16
#weapon 408 -- Talons
#weapon 404 -- Beak
#forestsurvival
#mountainsurvival
#prot 5 -- -2
#att 11 -- -1
#def 13
#size 6
#hp 25 -- -27
#str 14 -- -4
#mor 12 -- -6
#enc 3 -- same
#mr 9 -- better than most animals
#flying
#animal
#ap 8 -- same
#prec 13 -- -1
#mapmove 34 -- -4
#maxage 2000 -- has to be the same as the elves
#poorleader
#skirmisher 1
#bravemount 100
#end


---- Great Stag (no saddle)

#newmonster 14180
#spr1 "Warhammer_Wood_Elves/Great_Stag.tga"
#spr2 "Warhammer_Wood_Elves/Great_Stag2.tga"
#name "Great Stag"
#descr "No animal in Athel Loren is more treasured than the Great Stag, a noble and intelligent beast which the Asrai revere as representing the true soul of the forest. Whatever the truth of their nature, it is undeniable that the Great Stags are magical creatures and of a higher cast than the capricious Unicorns. They are typically only seen at portentous times, known to offer themselves are war steeds to Asrai of particular virtue or those destined to do great deeds in defence of the forest, though of late they have revealed themselves in far greater numbers than ever before. Great Stags are sacred to the Asrai.

[Gain glamour, recuperation, +1 att, +1 def, and +2 morale in forests]"
#gcost 0
#weapon 1162 -- magic antlers with charge bonus etc
#weapon 1161 -- magic hoof
#forestsurvival
#prot 7
#att 12 -- WS5
#def 12 -- WS5
#size 8 -- huge
#hp 50 -- T4 W3 and big. Great boar of carnutes is 55
#str 21 -- same as great boar of carnutes
#mor 13
#enc 2 -- same
#mr 14 -- great boar of carnutes
#animal
#magicbeing
#holy
#ap 24 -- M9 in warhammer, so a fast horse
#prec 11
#mapmove 22 -- great boar
#maxage 2000 -- has to be the same as the elves
#forestshape 14181
#maxage 5000
#quadruped
#end



---- Great Stag (no saddle) - forestshape

#newmonster 14181
#spr1 "Warhammer_Wood_Elves/Great_Stag.tga"
#spr2 "Warhammer_Wood_Elves/Great_Stag2.tga"
#name "Great Stag"
#descr "No animal in Athel Loren is more treasured than the Great Stag, a noble and intelligent beast which the Asrai revere as representing the true soul of the forest. Whatever the truth of their nature, it is undeniable that the Great Stags are magical creatures and of a higher cast than the capricious Unicorns. They are typically only seen at portentous times, known to offer themselves are war steeds to Asrai of particular virtue or those destined to do great deeds in defence of the forest, though of late they have revealed themselves in far greater numbers than ever before. Great Stags are sacred to the Asrai.

[Lose glamour, recuperation, 1 att, 1 def, and 2 morale outside of forests]"
#gcost 0
#weapon 1162 -- magic antlers with charge bonus etc
#weapon 1161 -- magic hoof
#forestsurvival
#prot 7
#att 13
#def 13
#size 8 -- huge
#hp 50 -- T4 W3 and big. Great boar of carnutes is 55
#str 21 -- same as great boar of carnutes
#mor 15
#enc 2 -- same
#mr 14 -- great boar of carnutes
#animal
#magicbeing
#holy
#ap 24 -- M9 in warhammer, so a fast horse
#prec 11
#mapmove 22 -- great boar
#maxage 2000 -- has to be the same as the elves
#plainshape 14180
#maxage 5000
#quadruped
#glamour
#heal
#end





---- Unicorn of Athel Loren

#newmonster 14190
#spr1 "Warhammer_Wood_Elves/Unicorn.tga"
#spr2 "Warhammer_Wood_Elves/Unicorn2.tga"
#name "Unicorn of Athel Loren"
#descr "The Unicorns of Athel Loren are the most famed of their kind and for good reason, for they are more powerful and fearsome than their cousins on Ulthuan or other distant forests. Innately magical creatures, they are not the noble beasts immortalised in song by Bretonnian bards, but instead selfish and arrogant in the extreme, harbouring no notions of kinship with mortals nor forest spirits. Unicorn ivory is highly prized and Unicorns are quite aware of their allure, so they delight in allowing themselves to be seen and pursued by would be hunters, only to be lured into a pack of vengeful forest Spites, deadly Waywatchers, or simply the territory of some ferocious predator. Should they find themselves in combat they are quite capable, for they are supernaturally swift and able to deal terrible damage with their magical horn and powerful hooves. Unicorns are resistant to and capable of consuming magical power and those who inhabit Athel Loren have had considerable exposure to Dark Magic, heightening their vindictive temperaments and lending them an aura of terrifying malice when they are encountered in a forest.

[Gain glamour, fear 5, +1 att, +1 def, and +2 morale in forests]"
#size 5 -- horse
#hp 34 -- +2 over ulthuan version
#prot 4 -- +1
#att 13
#def 13
#str 16 -- +1 over ulthuan version
#prec 10
#enc 2
#mapmove 30 -- incredibly swift
#ap 32 -- Ultra fast
#mr 15 -- magic res 2, magical, elfy, horn
#mor 13 -- proud, LD8, big, but selfish, -1 over ulthuan one
#weapon 1167 -- Horn
#weapon 55 -- Hoof, str added
#gcost 0
#rpcost 0
#rcost 0
#maxage 3000
#forestsurvival
#magicbeing
#animal
#heal
#forestshape 14191
#end


---- Unicorn of Athel Loren

#newmonster 14191
#spr1 "Warhammer_Wood_Elves/Unicorn.tga"
#spr2 "Warhammer_Wood_Elves/Unicorn2.tga"
#name "Unicorn of Athel Loren"
#descr "The Unicorns of Athel Loren are the most famed of their kind and for good reason, for they are more powerful and fearsome than their cousins on Ulthuan or other distant forests. Innately magical creatures, they are not the noble beasts immortalised in song by Bretonnian bards, but instead selfish and arrogant in the extreme, harbouring no notions of kinship with mortals nor forest spirits. Unicorn ivory is highly prized and Unicorns are quite aware of their allure, so they delight in allowing themselves to be seen and pursued by would be hunters, only to be lured into a pack of vengeful forest Spites, deadly Waywatchers, or simply the territory of some ferocious predator. Should they find themselves in combat they are quite capable, for they are supernaturally swift and able to deal terrible damage with their magical horn and powerful hooves. Unicorns are resistant to and capable of consuming magical power and those who inhabit Athel Loren have had considerable exposure to Dark Magic, heightening their vindictive temperaments and lending them an aura of terrifying malice when they are encountered in a forest.

[Lose glamour, fear 5, 1 att, 1 def, and 2 morale outside forests]"
#size 5 -- horse
#hp 34 -- +2 over ulthuan version
#prot 4 -- +1
#att 14
#def 14
#str 16 -- +1 over ulthuan version
#prec 10
#enc 2
#mapmove 30 -- incredibly swift
#ap 32 -- Ultra fast
#mr 15 -- magic res 2, magical, elfy, horn
#mor 15
#weapon 1167 -- Horn
#weapon 55 -- Hoof, str added
#gcost 0
#rpcost 0
#rcost 0
#maxage 3000
#forestsurvival
#magicbeing
#animal
#heal
#glamour
#plainshape 14190
#fear 5
#end




------------------------------------------------------------------------
-- Commanders
-------------------------------------------------------------------------


----- War Hawk Captain

#newmonster 14186
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Warhawk_Captain.tga"
#spr2 "Warhammer_Wood_Elves/Warhawk_Captain2.tga"
#name "Warhawk Captain"
#descr "Amongst the flights of Warhawk Riders that protect Athel Loren and strike out to punish her enemies all positions are equal, for they are a true brotherhood, but they elect those amongst them with the greatest talent for tactical leadership to act as their Captains. Amongst their own kind they are known as Windriders and it is said they can hear the whispers of the wind itself informing them of enemy movements and the perfect moment to launch strikes or hang back and pepper the foe with arrows. These captains have identical equipment to their troops, save for a more elaborate helm to mark them out. Should the rider be slain the Warhawk will fight on until the end of the battle.

[Gain glamour, +1 precision, +1 morale, and +1 patrolbonus in forests. Asrai Composite Bow will not harm friendlies in forests]"
#weapon 1142 -- asrai lance
#weapon 1143 -- composite bow
#armor 5 -- leather cuirass
#armor 119 -- reinforced leather cap
#def 13 -- +1
#gcost 75
#rpcost 1
#patrolbonus 1
#forestshape 14187
#forestsurvival
#mountainsurvival
#prec 14 -- super good archers
--
#okleader
#mr 13 -- tier 1
#hp 12 -- tier 1
#skilledrider 4
#mobilearcher 1
#mountmnr 14177 -- warhawk riderless
#unmountedspr1 "Warhammer_Wood_Elves/Warhawk_Captain_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Warhawk_Captain_Unmounted2.tga"
#end



----- War Hawk Captain (forest)

#newmonster 14187
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Warhawk_Captain.tga"
#spr2 "Warhammer_Wood_Elves/Warhawk_Captain2.tga"
#name "Warhawk Captain"
#descr "Amongst the flights of Warhawk Riders that protect Athel Loren and strike out to punish her enemies all positions are equal, for they are a true brotherhood, but they elect those amongst them with the greatest talent for tactical leadership to act as their Captains. Amongst their own kind they are known as Windriders and it is said they can hear the whispers of the wind itself informing them of enemy movements and the perfect moment to launch strikes or hang back and pepper the foe with arrows. These captains have identical equipment to their troops, save for a more elaborate helm to mark them out. Should the rider be slain the Warhawk will fight on until the end of the battle.

[Lose glamour, 1 precision, 1 morale, and 1 patrolbonus outside of forests. Asrai Composite Bow will harm friendlies outside forests]"
#weapon 1142 -- asrai lance
#weapon 1205 -- composite bow
#armor 5 -- leather cuirass
#armor 119 -- reinforced leather cap
#def 13 -- +1
#gcost 75
#rpcost 1
#mor 13
#patrolbonus 2
#plainshape 14186
#forestsurvival
#mountainsurvival
#prec 15 -- super good archers
#glamour
--
#okleader
#mr 13 -- tier 1
#hp 12 -- tier 1
#skilledrider 4
#mobilearcher 1
#mountmnr 14177 -- warhawk riderless
#unmountedspr1 "Warhammer_Wood_Elves/Warhawk_Captain_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Warhawk_Captain_Unmounted2.tga"
#end



-- Glade Lord on Great Stag (new mounted)

#newmonster 14182
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Lord_Stag.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Lord_Stag2.tga"
#name "Glade Lord Stagrider"
#descr "The Wood Elves of Athel Loren have long been ruled over by an aristocratic class known as the Highborn, whose status and power is in proportion to their responsbility to defend and maintain the lands in which their followers dwell. The greatest Highborn are known as the Lords and Ladies and their power is near absolute. When one of the Lords takes to battle with his host of loyal Glade Guard, Kinbands, and Eternal Guard he is known as a Glade Lord, a warrior and leader to be greatly feared and admired. Glade Lords are powerful and influential enough within Athel Loren that they are even known to command small contingents of forest spirits such as Dryads and Treekin and can count on Spites, tiny and vicious spirits, to grant power to their lances. The most virtuous Glade Lords, those destined to defend their home against the greatest threats, ride into battle atop a sacred Great Stag of Athel Loren. No animal in Athel Loren is more treasured than the Great Stag, a noble and intelligent beast which the Asrai revere as representing the true soul of the forest. Should the Glade Lord fall in battle the Great Stag will fight on for a time before returning to the innermost glades of Athel Loren.

[Gain glamour, recuperation, +1 precision, +1 morale, +1 strength, +2 hp, and +1 unsurroundable in forests. Asrai Long Bow will not harm friendlies in forests]"
#hp 20 -- elf, W3
#att 15
#def 15
#prec 15
#str 10
#prec 16
#mr 16 -- tier 3 leader, elf, +1 for great stag
#mor 15 -- LD10
#armor 12 -- scale mail hauberk
#armor 118 -- half helmet
#armor 3 -- kite shield
#weapon 1141 -- asrai long bow
#weapon 1154 -- lance of spite
#gcost 0
#expertleader
#poormagicleader
--
#rpcost 2
#forestshape 14183
#holy
#skilledrider 3
#mobilearcher 1
#mountmnr 14184 -- great stag
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Lord_Unmounted2.tga"
#end


-- Glade Lord on Great Stag (forest) (new mounted)

#newmonster 14183
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Lord_Stag.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Lord_Stag2.tga"
#name "Glade Lord Stagrider"
#descr "The Wood Elves of Athel Loren have long been ruled over by an aristocratic class known as the Highborn, whose status and power is in proportion to their responsbility to defend and maintain the lands in which their followers dwell. The greatest Highborn are known as the Lords and Ladies and their power is near absolute. When one of the Lords takes to battle with his host of loyal Glade Guard, Kinbands, and Eternal Guard he is known as a Glade Lord, a warrior and leader to be greatly feared and admired. Glade Lords are powerful and influential enough within Athel Loren that they are even known to command small contingents of forest spirits such as Dryads and Treekin and can count on Spites, tiny and vicious spirits, to grant power to their lances. The most virtuous Glade Lords, those destined to defend their home against the greatest threats, ride into battle atop a sacred Great Stag of Athel Loren. No animal in Athel Loren is more treasured than the Great Stag, a noble and intelligent beast which the Asrai revere as representing the true soul of the forest. Should the Glade Lord fall in battle the Great Stag will fight on for a time before returning to the innermost glades of Athel Loren.

[Lose glamour, recuperation, 1 precision, 1 morale, 1 strength, 2 hp, and 1 unsurroundable outside forests. Asrai Long Bow will harm friendlies outside forests]"
#hp 22
#att 15
#def 15
#prec 16 -- +1
#str 11 -- +1
#prec 16
#mr 16
#mor 16 -- +1
#armor 12 -- scale mail hauberk
#armor 118 -- half helmet
#armor 3 -- kite shield
#weapon 1170 -- asrai long bow
#weapon 1154 -- lance of spite
#gcost 0
#expertleader
#poormagicleader
--
#rpcost 2
#plainshape 14182
#glamour -- glamour
#holy
#heal
#skilledrider 3
#mobilearcher 1
#mountmnr 14185 -- great stag (forest)
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Lord_Unmounted2.tga"
#end


---- Great Stag (saddle)

#newmonster 14184
#spr1 "Warhammer_Wood_Elves/Great_Stag_Saddle.tga"
#spr2 "Warhammer_Wood_Elves/Great_Stag_Saddle2.tga"
#name "Great Stag"
#descr "No animal in Athel Loren is more treasured than the Great Stag, a noble and intelligent beast which the Asrai revere as representing the true soul of the forest. Whatever the truth of their nature, it is undeniable that the Great Stags are magical creatures and of a higher cast than the capricious Unicorns. They are typically only seen at portentous times, known to offer themselves are war steeds to Asrai of particular virtue or those destined to do great deeds in defence of the forest, though of late they have revealed themselves in far greater numbers than ever before. Great Stags are sacred to the Asrai.

[Will vanish at end of battle]"
#gcost 0
#weapon 1162 -- magic antlers with charge bonus etc
#weapon 1161 -- magic hoof
#forestsurvival
#snow
#prot 6 -- T4, big
#att 12 -- WS5
#def 12 -- WS5
#size 8 -- huge
#hp 50 -- T4 W3 and big. Great boar of carnutes is 55
#str 21 -- same as great boar of carnutes
#mor 13
#enc 2 -- same
#mr 14 -- great boar of carnutes
#animal
#magicbeing
#holy
#ap 24 -- M9 in warhammer, so a fast horse
#prec 11
#mapmove 22 -- great boar
#maxage 2000 -- has to be the same as the elves
#forestshape 14185
#maxage 5000
--quadruped
#bravemount 100
#armor 251 -- leather barding - prot 5
#end



---- Great Stag (saddle) - forestshape

#newmonster 14185
#spr1 "Warhammer_Wood_Elves/Great_Stag_Saddle.tga"
#spr2 "Warhammer_Wood_Elves/Great_Stag_Saddle2.tga"
#name "Great Stag"
#descr "No animal in Athel Loren is more treasured than the Great Stag, a noble and intelligent beast which the Asrai revere as representing the true soul of the forest. Whatever the truth of their nature, it is undeniable that the Great Stags are magical creatures and of a higher cast than the capricious Unicorns. They are typically only seen at portentous times, known to offer themselves are war steeds to Asrai of particular virtue or those destined to do great deeds in defence of the forest, though of late they have revealed themselves in far greater numbers than ever before. Great Stags are sacred to the Asrai.

[Lose glamour, recuperation, 1 att, 1 def, and 2 morale outside of forests]"
#gcost 0
#weapon 1162 -- magic antlers with charge bonus etc
#weapon 1161 -- magic hoof
#forestsurvival
#snow
#prot 6 -- T4, big
#att 13
#def 13
#size 8 -- huge
#hp 50 -- T4 W3 and big. Great boar of carnutes is 55
#str 21 -- same as great boar of carnutes
#mor 15
#enc 2 -- same
#mr 14 -- great boar of carnutes
#animal
#magicbeing
#holy
#ap 24 -- M9 in warhammer, so a fast horse
#prec 11
#mapmove 22 -- great boar
#maxage 2000 -- has to be the same as the elves
#plainshape 14184
#maxage 5000
--quadruped
#glamour
#heal
#bravemount 100
#armor 251 -- leather barding - prot 5
#end



----- Deepwood Scout (commander)

#newmonster 14175
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Deepwood_Scout.tga"
#spr2 "Warhammer_Wood_Elves/Deepwood_Scout2.tga"
#name "Deepwood Scout"
#descr "Deepwood Scouts hold the responsibility of patrolling areas of the forest deemed too dangerous for Glade Guard to enter, as well as venturing out into enemy territory to neutralise threats before they can reach the realms of the Asrai. Beyond the forest they are fine scouts and raiders, but their true abilities lie in their stealth and craft in navigating the darkest places of ancient woods, evading the keen senses of malicious spirits and territorial beasts. Deepwood Scouts are masters of misdirection, ambush, skirmishing, and tracking whose hidden work is just as vital to the safety of their people as the massed forces of Glade Guard.

[Gain glamour, +15 stealth, +1 precision, +1 morale, and +1 patrolbonus in forests. Asrai Long Bow will not harm friendlies in forests]"
#gcost 35
#armor 5 -- leather cuirass
#armor 121 -- leather hood
#weapon 1141 -- asrai long bow
#weapon 9 -- dagger
#forestshape 14176
#prec 13 -- +1
#patrolbonus 1
#stealthy 10
#rpcost 1
#noleader
#end

----- Deepwood Scout -- forest shape (commander)

#newmonster 14176
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Deepwood_Scout.tga"
#spr2 "Warhammer_Wood_Elves/Deepwood_Scout2.tga"
#name "Deepwood Scout"
#descr "Deepwood Scouts hold the responsibility of patrolling areas of the forest deemed too dangerous for Glade Guard to enter, as well as venturing out into enemy territory to neutralise threats before they can reach the realms of the Asrai. Beyond the forest they are fine scouts and raiders, but their true abilities lie in their stealth and craft in navigating the darkest places of ancient woods, evading the keen senses of malicious spirits and territorial beasts. Deepwood Scouts are masters of misdirection, ambush, skirmishing, and tracking whose hidden work is just as vital to the safety of their people as the massed forces of Glade Guard.

[Lose glamour, 15 stealth, 1 precision, 1 morale, and 1 patrolbonus outside forests. Asrai Long Bow will harm friendlies outside forests]"
#gcost 35
#armor 5 -- leather cuirass
#armor 121 -- leather hood
#weapon 1170 -- asrai long bow
#weapon 9 -- dagger
#glamour -- glamour
#plainshape 14175
#mor 13 -- +1
#prec 14 -- +1
#rpcost 1
#patrolbonus 2 -- +1
#noleader
#stealthy 10
#end




----- Priest of the Balance

#newmonster 14578
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Priest_Balance.tga"
#spr2 "Warhammer_Wood_Elves/Priest_Balance2.tga"
#name "Priest of the Balance"
#descr "The deities of the Elven peoples are divided into two groups, the Cadai, Gods of the Heavens, and the Cytharai, the Gods of the Underworld. All Elves understand that observances must be made to all of these deities, but vary greatly in terms of which are worshipped directly and given the greatest prominence. While the High Elves of Ulthuan focus on the Cadai and the Dark Elves of Naggaroth favour the Cytharai, the Wood Elves of Athel Loren worship both equally and stress the importance of balance between light and shadow, Heavens and Underworld. Priests of the Balance are those rare Wood Elves who have chosen to dedicate their life to maintaining this balance of worship and ensuring that their brethren do not make the same mistakes as their cousins, nor do they turn away from their deities to worship the forest itself. This is often a very difficult task that puts them at odds with the spirits of the forest, the noble houses of the Asrai, and even their immortal rulers Orion and Ariel, who are themselves manifestations of Kurnous and Isha, deities who expect the loyalty and obedience of the Wood Elves at all times.

[Gain glamour, +1 precision, +1 morale, +1 magic resistance in forests.]"
#mr 14
#mor 11
#weapon 7 -- staff
#armor 158 -- robes
#gcost 70
#rcost 1
#magicskill 9 1 -- holy
#startage 300
#maxage 2000
#holy
#poorleader
#rpcost 1
#forestshape 14579
#end


----- Priest of the Balance (forest)

#newmonster 14579
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Priest_Balance.tga"
#spr2 "Warhammer_Wood_Elves/Priest_Balance2.tga"
#name "Priest of the Balance"
#descr "The deities of the Elven peoples are divided into two groups, the Cadai, Gods of the Heavens, and the Cytharai, the Gods of the Underworld. All Elves understand that observances must be made to all of these deities, but vary greatly in terms of which are worshipped directly and given the greatest prominence. While the High Elves of Ulthuan focus on the Cadai and the Dark Elves of Naggaroth favour the Cytharai, the Wood Elves of Athel Loren worship both equally and stress the importance of balance between light and shadow, Heavens and Underworld. Priests of the Balance are those rare Wood Elves who have chosen to dedicate their life to maintaining this balance of worship and ensuring that their brethren do not make the same mistakes as their cousins, nor do they turn away from their deities to worship the forest itself. This is often a very difficult task that puts them at odds with the spirits of the forest, the noble houses of the Asrai, and even their immortal rulers Orion and Ariel, who are themselves manifestations of Kurnous and Isha, deities who expect the loyalty and obedience of the Wood Elves at all times.

[Lose glamour, 1 precision, 1 morale, 1 magic resistance outside forests.]"
#mr 15
#mor 12
#weapon 7 -- staff
#armor 158 -- robes
#gcost 70
#rcost 1
#magicskill 9 1 -- holy
#startage 300
#maxage 2000
#holy
#poorleader
#rpcost 1
#plainshape 14578
#glamour
#prec 13
#end


----- Glade Captain

#newmonster 14137
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Captain.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Captain2.tga"
#name "Glade Captain"
#descr "The Wood Elves of Athel Loren have long been ruled over by an aristocratic class known as the Highborn, whose status and power is in proportion to their responsbility to defend and maintain the lands in which their followers dwell. The greatest Highborn are known as the Lords and Ladies and their power is near absolute, but the majority of the class is made up of lesser nobles who compete for status and respect. Unlike their cousins the High Elves of Ulthuan or Dark Elves of Naggaroth, the nobility of the Asrai are better able to set aside their ambitions for the greater good of Athel Loren and their rivalries are typically expressed through friendly competition and hunts rather than damaging courtly intrigue. Many lesser nobles become Glade Captains, commanders of small contingents of troops and responsible for the first line defence of their realm and the occasional raid beyond. While they are almost all Highborn, Glade Captains keep their position through merit rather than birthright and are very well versed in tactical leadership, though only Glade Lords are permitted to lead truly large forces. As they typically lead Glade Guard they are armed in a similar manner and favour the Long Bow as their primary weapon, though they wear heavier armour.

[Gain glamour, +1 precision, +1 morale, +1 strength, and +1 unsurroundable in forests. Asrai Long Bow will not harm friendlies in forests]"
#armor 7 -- scale mail cuirass
#armor 119 -- reinforced leather cap
#weapon 1141 -- asrai long bow
#weapon 746 -- scimitar
#hp 14 -- W2, T3, elf
#att 13 -- WS4 I5, elf, but champion
#def 13 -- WS4 I4, elf, but champion
#str 10 -- str 3, elf, but champion
#prec 13
#mr 13 -- tier 1, elf
#mor 13 -- LD8 elf
#gcost 85
#rcost 1
#rpcost 1
#goodleader
#command -40 -- so 60 left
--
#forestshape 14138
#poormagicleader
#magiccommand -5
#end


----- Glade Captain (forest)

#newmonster 14138
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Captain.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Captain2.tga"
#name "Glade Captain"
#descr "The Wood Elves of Athel Loren have long been ruled over by an aristocratic class known as the Highborn, whose status and power is in proportion to their responsbility to defend and maintain the lands in which their followers dwell. The greatest Highborn are known as the Lords and Ladies and their power is near absolute, but the majority of the class is made up of lesser nobles who compete for status and respect. Unlike their cousins the High Elves of Ulthuan or Dark Elves of Naggaroth, the nobility of the Asrai are better able to set aside their ambitions for the greater good of Athel Loren and their rivalries are typically expressed through friendly competition and hunts rather than damaging courtly intrigue. Many lesser nobles become Glade Captains, commanders of small contingents of troops and responsible for the first line defence of their realm and the occasional raid beyond. While they are almost all Highborn, Glade Captains keep their position through merit rather than birthright and are very well versed in tactical leadership, though only Glade Lords are permitted to lead truly large forces. As they typically lead Glade Guard they are armed in a similar manner and favour the Long Bow as their primary weapon, though they wear heavier armour.

[Lose glamour, 1 precision, 1 morale, 1 strength, and 1 unsurroundable outside forests. Asrai Long Bow will harm friendlies outside forests]"
#armor 7 -- scale mail cuirass
#armor 119 -- reinforced leather cap
#weapon 1170 -- asrai long bow
#weapon 746 -- scimitar
#hp 14
#att 13
#def 13
#str 11 -- +1
#prec 14 -- +1
#mr 13 -- tier 1, elf
#mor 14 -- +1
#gcost 85
#rcost 1
#rpcost 1
#goodleader
#command -40
--
#plainshape 14137
#glamour
#poormagicleader
#magiccommand -5
#end


------Elven Steed (glade lord)

#newmonster 14385
#copystats 14383 -- elven steed (glade rider)
#spr1 "Warhammer_Wood_Elves/Glade_Lord_Mount.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Lord_Mount2.tga"
#name "Elven Steed"
#descr "The Elven Steeds of Athel Loren are amongst the finest in the world. While these intelligent, noble creatures are descended from the same stock as those in Ulthuan, the Wood Elves have ceased to treat these horses as chattel and instead created a close bond of mutual benefit between Elf and Steed.

[Gain glamour, +1 morale in forests.]"
#forestshape 14386
#end


------Elven Steed (glade lord forest shape)

#newmonster 14386
#copystats 14384 -- elven steed (glade rider)
#spr1 "Warhammer_Wood_Elves/Glade_Lord_Mount.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Lord_Mount2.tga"
#name "Elven Steed"
#descr "The Elven Steeds of Athel Loren are amongst the finest in the world. While these intelligent, noble creatures are descended from the same stock as those in Ulthuan, the Wood Elves have ceased to treat these horses as chattel and instead created a close bond of mutual benefit between Elf and Steed.

[Lose glamour, +1 morale outside forests.]"
#plainshape 14385
#end


-- Glade Lord (new mounted)

#newmonster 14153
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Lord.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Lord2.tga"
#name "Glade Lord"
#descr "The Wood Elves of Athel Loren have long been ruled over by an aristocratic class known as the Highborn, whose status and power is in proportion to their responsbility to defend and maintain the lands in which their followers dwell. The greatest Highborn are known as the Lords and Ladies and their power is near absolute. When one of the Lords takes to battle with his host of loyal Glade Guard, Kinbands, and Eternal Guard he is known as a Glade Lord, a warrior and leader to be greatly feared and admired. Glade Lords are powerful and influential enough within Athel Loren that they are even known to command small contingents of forest spirits such as Dryads and Treekin and can count on Spites, tiny and vicious spirits, to grant power to their lances. Glade Lords fight from horseback, riding the finest Elven Steeds with practiced ease, and are capable of firing even the large Asrai Long Bow from this position, though they typically prefer to engage in melee combat where they can indulge their more primal instincts.

[Gain glamour, +1 precision, +1 morale, +1 strength, +2 hp, and +1 unsurroundable in forests. Asrai Long Bow will not harm friendlies in forests]"
#hp 20 -- elf, W3
#att 15
#def 15
#prec 15
#str 10
#prec 16
#mr 15 -- tier 3 leader, elf
#mor 15 -- LD10
#armor 12 -- scale mail hauberk
#armor 118 -- half helmet
#armor 3 -- kite shield
#weapon 1141 -- asrai long bow
#weapon 1154 -- lance of spite
#gcost 150
#expertleader
#poormagicleader
--
#rpcost 2
#gcost 130 -- (15)
#skilledrider 3
#mobilearcher 1
#mountmnr 14385 -- elven steed
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Lord_Unmounted2.tga"
#forestshape 14154
#end


-- Glade Lord (forest - new mounted)

#newmonster 14154
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Glade_Lord.tga"
#spr2 "Warhammer_Wood_Elves/Glade_Lord2.tga"
#name "Glade Lord"
#descr "The Wood Elves of Athel Loren have long been ruled over by an aristocratic class known as the Highborn, whose status and power is in proportion to their responsbility to defend and maintain the lands in which their followers dwell. The greatest Highborn are known as the Lords and Ladies and their power is near absolute. When one of the Lords takes to battle with his host of loyal Glade Guard, Kinbands, and Eternal Guard he is known as a Glade Lord, a warrior and leader to be greatly feared and admired. Glade Lords are powerful and influential enough within Athel Loren that they are even known to command small contingents of forest spirits such as Dryads and Treekin and can count on Spites, tiny and vicious spirits, to grant power to their lances. Glade Lords fight from horseback, riding the finest Elven Steeds with practiced ease, and are capable of firing even the large Asrai Long Bow from this position, though they typically prefer to engage in melee combat where they can indulge their more primal instincts.

[Lose glamour, 1 precision, 1 morale, 1 strength, 2 hp, and 1 unsurroundable outside forests. Asrai Long Bow will harm friendlies outside forests]"
#hp 22 -- +2
#att 15
#def 15
#prec 16 -- +1
#str 11 -- +1
#prec 16
#mr 15
#mor 16 -- +1
#armor 12 -- scale mail hauberk
#armor 118 -- half helmet
#armor 3 -- kite shield
#weapon 1170 -- asrai long bow
#weapon 1154 -- lance of spite
#expertleader
#poormagicleader
--
#rpcost 2
#gcost 130 -- (15)
#skilledrider 3
#mobilearcher 1
#mountmnr 14386 -- elven steed
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Lord_Unmounted2.tga"
#plainshape 14153
#glamour -- glamour
#end



-- Treeman (Recruit)

#newmonster 14197
#spr1 "Warhammer_Wood_Elves/Treeman_Recruit.tga"
#name "Treeman"
#descr "The most powerful of Athel Loren's spirits entwine their essence with that of a living tree, moulding it to their will. This is a not a decision made lightly, for the bond is permanent and by tethering themselves to a physical form these great spirits risk much, including the previously alien concept of death. Treemen are revered by the Asrai and other inhabitants of the forest alike and these great sentinels of Athel Loren are typically home to a great many lesser spirits that will lend them strength should they be threatened. For their part the Treemen cherish the lives of lesser creatures and boast a warmth of character totally unlike that of the spiteful Dryads. They can be counted amongst the mightiest of Athel Loren's denizens, able to wield magic of nature and earth and possessing incredible physical prowess and resilience. Treemen do not fight with grace but instead rely on sheer ferocity and their great strength to smash threats to their forest realm or tear them apart with whipping tendrils as strong as steel.

[Gain glamour, recuperation, +3 strength, +1 magic resistance, +10 hp, +2 protection, and +1 unsurroundable in forests, lose gold upkeep]
[This commander uses a smaller sprite on the recruitment screen for ease of use]"
#size 10
#enc 1
#prot 13
#hp 80
#weapon 1169 -- vinelash
#weapon 1149 -- oaken fist
#weapon 1168 -- giant stomp
#gcost 460
#rpcost 4
#rcost 1
#mapmove 22
#ap 18
#att 13
#def 12
#str 22
#mor 18
#mr 17
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 4500
#maxage 9000
#firstshape 14192
#magicskill 6 2 -- N2
#magicskill 3 1 -- E1
#magicskill 9 2 -- H2
#holy
--
#goodmagicleader
#poorleader
#fear 5
#itemslots 17571840 -- 2 misc plus crown
#end




-- Treeman

#newmonster 14192
#spr1 "Warhammer_Wood_Elves/Treeman.tga"
#spr2 "Warhammer_Wood_Elves/Treeman2.tga"
#name "Treeman"
#descr "The most powerful of Athel Loren's spirits entwine their essence with that of a living tree, moulding it to their will. This is a not a decision made lightly, for the bond is permanent and by tethering themselves to a physical form these great spirits risk much, including the previously alien concept of death. Treemen are revered by the Asrai and other inhabitants of the forest alike and these great sentinels of Athel Loren are typically home to a great many lesser spirits that will lend them strength should they be threatened. For their part the Treemen cherish the lives of lesser creatures and boast a warmth of character totally unlike that of the spiteful Dryads. They can be counted amongst the mightiest of Athel Loren's denizens, able to wield magic of nature and earth and possessing incredible physical prowess and resilience. Treemen do not fight with grace but instead rely on sheer ferocity and their great strength to smash threats to their forest realm or tear them apart with whipping tendrils as strong as steel.

[Gain glamour, recuperation, +3 strength, +1 magic resistance, +10 hp, +2 protection, and +1 unsurroundable in forests, lose gold upkeep]"
#size 10
#enc 1
#prot 13
#hp 80
#weapon 1169 -- vinelash
#weapon 1149 -- oaken fist
#weapon 1168 -- giant stomp
#gcost 460
#rpcost 4
#rcost 1
#mapmove 22
#ap 18
#att 13
#def 12
#str 22
#mor 18
#mr 17
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 4500
#maxage 9000
#forestshape 14193
#magicskill 6 2 -- N2
#magicskill 3 1 -- E1
#magicskill 9 2 -- H2
#holy
--
#goodmagicleader
#poorleader
#fear 5
#itemslots 17571840 -- 2 misc plus crown
#latehero 10 -- won't appear as multihero before turn 10
#end


-- Treeman (forest shape)

#newmonster 14193
#spr1 "Warhammer_Wood_Elves/Treeman.tga"
#spr2 "Warhammer_Wood_Elves/Treeman2.tga"
#name "Treeman"
#descr "The most powerful of Athel Loren's spirits entwine their essence with that of a living tree, moulding it to their will. This is a not a decision made lightly, for the bond is permanent and by tethering themselves to a physical form these great spirits risk much, including the previously alien concept of death. Treemen are revered by the Asrai and other inhabitants of the forest alike and these great sentinels of Athel Loren are typically home to a great many lesser spirits that will lend them strength should they be threatened. For their part the Treemen cherish the lives of lesser creatures and boast a warmth of character totally unlike that of the spiteful Dryads. They can be counted amongst the mightiest of Athel Loren's denizens, able to wield magic of nature and earth and possessing incredible physical prowess and resilience. Treemen do not fight with grace but instead rely on sheer ferocity and their great strength to smash threats to their forest realm or tear them apart with whipping tendrils as strong as steel.

[Lose glamour, recuperation, 3 strength, 1 magic resistance, 10 hp, 2 protection, and 1 unsurroundable outside forests, gain gold upkeep]"
#size 10
#enc 1
#prot 15
#hp 90
#weapon 1169 -- vinelash
#weapon 1149 -- oaken fist
#weapon 1168 -- giant stomp
#gcost 0
#rpcost 4
#rcost 1
#mapmove 22
#ap 18
#att 13
#def 12
#str 25
#mor 18
#mr 18
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 4500
#maxage 9000
#plainshape 14192
#magicskill 6 2 -- N2
#magicskill 3 1 -- E1
#magicskill 9 2 -- H2
#holy
--
#goodmagicleader
#poorleader
#fear 5
#glamour
#heal
#itemslots 17571840 -- 2 misc plus crown
#end


-- Treeman Ancient (recruitment graphic)

#newmonster 14196
#spr1 "Warhammer_Wood_Elves/Treeman_Ancient_Recruit.tga"
#name "Treeman Ancient"
#descr "The oldest, wisest, and most revered generation of Treemen are known as the Ancients, and only Orion, Ariel, and the two remaining Elder Treemen stand above them in the hierarchy of Athel Loren. Ancients are prone to slumber in a dormant state for decades at a time and even when at their most energetic are not nearly so active as their younger fellows, though their magical knowledge and power is considerable and they still boast impressive physical might and resilience. It is only in recent years that many Ancients have awoken and begun to act at the same time, surely signalling that an era of great import has dawned for Athel Loren. While Treemen do not make use of weapons and instead rely on their crushing fists or lashing vines, Ancients typically carry a great staff of enchanted birch and have been known to use other magical items as the moment requires.

[Gain glamour, recuperation, +3 strength, +1 magic resistance, +15 hp, +2 protection in forests, lose gold upkeep] 
[This commander uses a smaller sprite on the recruitment screen for ease of use]"
#size 10
#enc 2
#prot 12 -- less prot
#hp 85 -- slightly bigger
#weapon 238 -- magic staff
#weapon 1168 -- giant stomp
#gcost 630
#rpcost 6
#rcost 1
#mapmove 16 -- significantly slower
#ap 14
#att 10
#def 10
#str 20
#mor 18
#mr 18
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 7000
#maxage 9000
#firstshape 14194
#magicskill 6 3 -- N3
#magicskill 3 2 -- E2
#magicskill 2 1 -- W2
#magicskill 9 3 -- H3
#holy
#goodmagicleader
#okleader
#fear 5
#itemslots 17571846 -- 2 misc plus crown, plus 2 hands
#end


-- Treeman Ancient

#newmonster 14194
#spr1 "Warhammer_Wood_Elves/Treeman_Ancient.tga"
#spr2 "Warhammer_Wood_Elves/Treeman_Ancient2.tga"
#name "Treeman Ancient"
#descr "The oldest, wisest, and most revered generation of Treemen are known as the Ancients, and only Orion, Ariel, and the two remaining Elder Treemen stand above them in the hierarchy of Athel Loren. Ancients are prone to slumber in a dormant state for decades at a time and even when at their most energetic are not nearly so active as their younger fellows, though their magical knowledge and power is considerable and they still boast impressive physical might and resilience. It is only in recent years that many Ancients have awoken and begun to act at the same time, surely signalling that an era of great import has dawned for Athel Loren. While Treemen do not make use of weapons and instead rely on their crushing fists or lashing vines, Ancients typically carry a great staff of enchanted birch and have been known to use other magical items as the moment requires.

[Gain glamour, recuperation, +3 strength, +1 magic resistance, +15 hp, +2 protection in forests, lose gold upkeep]"
#size 10
#enc 2
#prot 12 -- less prot
#hp 85 -- slightly bigger
#weapon 238 -- magic staff
#weapon 1168 -- giant stomp
#gcost 630
#rpcost 6
#rcost 1
#mapmove 16 -- significantly slower
#ap 14
#att 10
#def 10
#str 20
#mor 18
#mr 18
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 7000
#maxage 9000
#forestshape 14195
#magicskill 6 3 -- N3
#magicskill 3 2 -- E2
#magicskill 2 1 -- W2
#magicskill 9 3 -- H3
#holy
#goodmagicleader
#okleader
#fear 5
#itemslots 17571846 -- 2 misc plus crown, plus 2 hands
#end

-- Treeman Ancient (forest shape)

#newmonster 14195
#spr1 "Warhammer_Wood_Elves/Treeman_Ancient.tga"
#spr2 "Warhammer_Wood_Elves/Treeman_Ancient2.tga"
#name "Treeman Ancient"
#descr "The oldest, wisest, and most revered generation of Treemen are known as the Ancients, and only Orion, Ariel, and the two remaining Elder Treemen stand above them in the hierarchy of Athel Loren. Ancients are prone to slumber in a dormant state for decades at a time and even when at their most energetic are not nearly so active as their younger fellows, though their magical knowledge and power is considerable and they still boast impressive physical might and resilience. It is only in recent years that many Ancients have awoken and begun to act at the same time, surely signalling that an era of great import has dawned for Athel Loren. While Treemen do not make use of weapons and instead rely on their crushing fists or lashing vines, Ancients typically carry a great staff of enchanted birch and have been known to use other magical items as the moment requires.

[Lose glamour, recuperation, 3 strength, 1 magic resistance, 15 hp, and 2 protection outside forests, gain gold upkeep]"
#size 10
#enc 2
#prot 14
#hp 100
#weapon 238 -- magic staff
#weapon 1168 -- giant stomp
#gcost 0
#rpcost 4
#rcost 1
#mapmove 22
#ap 18
#att 10
#def 10
#str 23
#mor 18
#mr 19
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 7000
#maxage 9000
#plainshape 14194
#magicskill 6 3 -- N3
#magicskill 3 2 -- E2
#magicskill 2 1 -- W2
#magicskill 9 3 -- H3
#holy
#goodmagicleader
#okleader
#fear 5
#glamour
#heal
#itemslots 17571846 -- 2 misc plus crown, plus 2 hands
#end


-- Dryad Branchwraith

#newmonster 14165
#spr1 "Warhammer_Wood_Elves/Branchwraith.tga"
#spr2 "Warhammer_Wood_Elves/Branchwraith2.tga"
#name "Dryad Branchwraith"
#descr "Branchwraiths are the oldest and deadliest of the Dryads, beings that have served as the handmaidens of the Ancients of Athel Loren since the forest was young. Their dedication to the Ancients and Treemen borders on the fanatical and they greatly resent the coming of the Elves, who they see as usurpers and trespassers they are barely able to tolerate. Adanhu, oldest and wisest of the Treemen, was the first to welcome the Elves to Athel Loren and though they have passed from this world their legacy is continued by Durthu, mightiest protector of the forest. The Branchwraiths would never go against the will of the Ancients and so they fight alongside the Elves, though the Asrai know they can never fully trust the malevolent forest spirits. Branchwraiths do not change with the seasons as their lesser siblings do, instead maintaining a spiteful form year round, their energy and hatred radiating out from gnarled and twisted wood.

[Gain glamour, recuperation, +1 morale, +1 strength, +1 magic resistance, +3 hp, +1 protection, and +1 unsurroundable in forests. Requires friendly Dominion in the province to recruit]"
#size 3
#enc 1
#prot 9
#hp 25
#weapon 29 -- claw
#weapon 29 -- claw
#gcost 200
#rpcost 2
#rcost 1
#mapmove 18 -- same as a satyr
#ap 14 -- same as a satyr/wood elf
#att 14 -- +1 for hatred
#def 13
#str 15
#mor 15
#mr 15
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 2500
#maxage 4000
#forestshape 14166
#domrec 1
#magicskill 6 2 -- N2
#custommagic 20480 100 -- DG
#holy
--
#female
#okmagicleader
#poorleader
#end


-- Dryad Branchwraith

#newmonster 14166
#spr1 "Warhammer_Wood_Elves/Branchwraith.tga"
#spr2 "Warhammer_Wood_Elves/Branchwraith2.tga"
#name "Dryad Branchwraith"
#descr "Branchwraiths are the oldest and deadliest of the Dryads, beings that have served as the handmaidens of the Ancients of Athel Loren since the forest was young. Their dedication to the Ancients and Treemen borders on the fanatical and they greatly resent the coming of the Elves, who they see as usurpers and trespassers they are barely able to tolerate. Adanhu, oldest and wisest of the Treemen, was the first to welcome the Elves to Athel Loren and though they have passed from this world their legacy is continued by Durthu, mightiest protector of the forest. The Branchwraiths would never go against the will of the Ancients and so they fight alongside the Elves, though the Asrai know they can never fully trust the malevolent forest spirits. Branchwraiths do not change with the seasons as their lesser siblings do, instead maintaining a spiteful form year round, their energy and hatred radiating out from gnarled and twisted wood.

[Lose glamour, recuperation, 1 morale, 1 strength, 1 magic resistance, 3 hp, 1 protection, and 1 unsurroundable outside forests. Requires friendly Dominion in the province to recruit]"
#size 3
#enc 1
#prot 10 -- +1
#hp 28 -- +3
#weapon 29 -- claw
#weapon 29 -- claw
#gcost 200
#rpcost 2
#rcost 1
#mapmove 18
#ap 14
#att 14
#def 13
#str 16 -- +1
#mor 16 -- +1
#mr 16 -- +1
#fireres -5
#poisonres 15
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 2500
#maxage 4000
#plainshape 14165
#domrec 1
#magicskill 6 2 -- N2
#custommagic 20480 100 -- DG
#holy
#heal
#glamour
--
#female
#okmagicleader
#poorleader
#end

----- Shadowdancer of Loec

#newmonster 14157
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Shadowdancer.tga"
#spr2 "Warhammer_Wood_Elves/Shadowdancer2.tga"
#name "Shadowdancer of Loec"
#descr "Shadowdancers are the spiritual and martial leaders of the sects of Wood Elves known as Wardancers. Devoted servants of the trickster god Loec, the Shadowdancers bear the responsibility of carrying the oral history of their people and are expected to be able to tell every tale that makes of the chronicle of the children of Athel Loren, as well as perform the complex dances which draw those outside the Wardancer troupe into true rememberance of the past. The burden of such a vast and nuanced corpus is such that Shadowdancers are known to have entirely given up their own personality and even identity, wearing a gilded wooden mask of Loec at all times. They are known to be even more skilled in combat than the Wardancers that follow them and have mastered a fighting style involving the use of two long Asrai spears, a combination that should be unwieldy but in their hands creates a near perfect fusion of offence and defence. As master storytellers and performers of Loec's rites Shadowdancers have some talent in the magic of shadow and illusion but perhaps their greatest power is their ability to call the blessings of Loec down on their troupe, activating their tattoos to enchance their abilities and protect them from harm.

[Gain glamour, +2 hp, +1 morale, +1 strength, and +1 unsurroundable in forests. Automatically casts Awaken Tattoos on battle start]"
#armor 187 -- magical wooden mask
#weapon 1140 -- asrai spear
#weapon 1140 -- asrai spear
#hp 14 -- W2, T3, elf
#att 16
#def 17
#str 11 -- str 4, elf
#prec 13
#mr 16 -- tier 2, elf, mage
#mor 16
#gcost 180
#rcost 1
#rpcost 2 -- mage
#goodleader
#command -70 -- only allowed very few troops
--
#magicskill 1 1 -- A1
#magicskill 5 1 -- D1
#magicskill 7 1 -- G1
#ambidextrous 6
#airshield 40
#beartattoo 1 -- +1 strength per point
#horsetattoo 1 -- +1 def and +2 speed per point
#wolftattoo 1 -- +1 attack skill per point
#boartattoo 1 -- invuln increase?
#snaketattoo 1 -- magic res +1 per point
#forestshape 14158
#onebattlespell "awaken tattoos"
#end


----- Shadowdancer of Loec

#newmonster 14158
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Shadowdancer.tga"
#spr2 "Warhammer_Wood_Elves/Shadowdancer2.tga"
#name "Shadowdancer of Loec"
#descr "Shadowdancers are the spiritual and martial leaders of the sects of Wood Elves known as Wardancers. Devoted servants of the trickster god Loec, the Shadowdancers bear the responsibility of carrying the oral history of their people and are expected to be able to tell every tale that makes of the chronicle of the children of Athel Loren, as well as perform the complex dances which draw those outside the Wardancer troupe into true rememberance of the past. The burden of such a vast and nuanced corpus is such that Shadowdancers are known to have entirely given up their own personality and even identity, wearing a gilded wooden mask of Loec at all times. They are known to be even more skilled in combat than the Wardancers that follow them and have mastered a fighting style involving the use of two long Asrai spears, a combination that should be unwieldy but in their hands creates a near perfect fusion of offence and defence. As master storytellers and performers of Loec's rites Shadowdancers have some talent in the magic of shadow and illusion but perhaps their greatest power is their ability to call the blessings of Loec down on their troupe, activating their tattoos to enchance their abilities and protect them from harm.

[Loses glamour, 2 hp, 1 morale, 1 strength, and 1 unsurroundable outside forests. Automatically casts Awaken Tattoos on battle start]"
#armor 187 -- magical wooden mask
#weapon 1140 -- asrai spear
#weapon 1140 -- asrai spear
#hp 16 -- +2
#att 16
#def 17
#str 12 -- +1
#prec 13
#mr 16 -- tier 2, elf, mage
#mor 17 -- +1
#gcost 180
#rcost 1
#rpcost 2 -- mage
#goodleader
#command -70 -- only allowed very few troops
--
#magicskill 1 1 -- A1
#magicskill 5 1 -- D1
#magicskill 7 1 -- G1
#ambidextrous 6
#airshield 40
#beartattoo 1 -- +1 strength per point
#horsetattoo 1 -- +1 def and +2 speed per point
#wolftattoo 1 -- +1 attack skill per point
#boartattoo 1 -- invuln increase?
#snaketattoo 1 -- magic res +1 per point
#plainshape 14157
#glamour
#onebattlespell "awaken Tattoos"
#end


----- Waystalker

#newmonster 14167
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Waystalker.tga"
#spr2 "Warhammer_Wood_Elves/Waystalker2.tga"
#name "Waystalker"
#descr "Waystalkers are elite amongst the elite, former Waywatchers who have become attuned with the forest on an even deeper level and sharpened their skills to the point they can perform feats of archery, tracking, and ambush that can only be described as supernatural. While all Wood Elves seek harmony with their home forest of Athel Loren, Waystalkers are truly part of the forest, deadly predators feared even by lesser forest spirits for bringing swift judgement. Waystalkers are nearly impossible to locate if in a forest and capable of isolating and assassinating enemy commanders, often taking some part of their body to place on a warning totem to others who would trespass against Athel Loren and her children. Like the Waywatchers under their command Waystalkers camouflage themselves with foliage, but they also protect themselves with elaborate armour fashioned from the bones of some unfamiliar creature and inscribed with strange symbols. Waystalkers are known to dominate Spites, vicious minor forest spirits, through sheer willpower and force them to inhabit and enhance their bows, transforming them into magical weapons of destruction. 

[Gain glamour, +2 hp, +1 strength, +1 morale, +1 precision, +5 patrolbonus, and the assassin ability in forests. Spite Infused Bows will never harm friendlies]"
#gcost 220
#armor 149 -- bone cuirass
#armor 150 -- bone helmet
#weapon 6 -- short sword
#weapon 9 -- dagger
#weapon 1158 -- Spite infused Bow
#forestshape 14168
#rpcost 2
#hp 15
#str 11
#prec 16
#att 14
#def 14
#mountainsurvival
#stealthy 70 -- spy +10
#mor 15
#patrolbonus 10
#supplybonus 10
--
#mr 14 -- tier 2
#goodleader
#command -55 -- 25 left
#beastmaster 1
#end


----- Waystalker (forest)

#newmonster 14168
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Waystalker.tga"
#spr2 "Warhammer_Wood_Elves/Waystalker2.tga"
#name "Waystalker"
#descr "Waystalkers are elite amongst the elite, former Waywatchers who have become attuned with the forest on an even deeper level and sharpened their skills to the point they can perform feats of archery, tracking, and ambush that can only be described as supernatural. While all Wood Elves seek harmony with their home forest of Athel Loren, Waystalkers are truly part of the forest, deadly predators feared even by lesser forest spirits for bringing swift judgement. Waystalkers are nearly impossible to locate if in a forest and capable of isolating and assassinating enemy commanders, often taking some part of their body to place on a warning totem to others who would trespass against Athel Loren and her children. Like the Waywatchers under their command Waystalkers camouflage themselves with foliage, but they also protect themselves with elaborate armour fashioned from the bones of some unfamiliar creature and inscribed with strange symbols. Waystalkers are known to dominate Spites, vicious minor forest spirits, through sheer willpower and force them to inhabit and enhance their bows, transforming them into magical weapons of destruction. 

[Lose glamour, 2 hp, 1 strength, 1 morale, 1 precision, 5 patrolbonus, and the assassin ability outside forests. Spite Infused Bows will never harm friendlies]"
#gcost 220
#armor 149 -- bone cuirass
#armor 150 -- bone helmet
#weapon 6 -- short sword
#weapon 9 -- dagger
#weapon 1158 -- Spite infused Bow
#plainshape 14167
#rpcost 2
#hp 17
#str 12
#prec 17
#att 14
#def 14
#mountainsurvival
#stealthy 70 -- spy +10
#mor 16
#patrolbonus 15
#supplybonus 10
--
#mr 14 -- tier 2
#goodleader
#command -55 -- 25 left
#glamour
#assassin
#assencloc 3 -- outdoors locations only
#patience 3
#beastmaster 1
#end


----- Spellsinger

#newmonster 14163
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Spellsinger.tga"
#spr2 "Warhammer_Wood_Elves/Spellsinger2.tga"
#name "Spellsinger"
#descr "As with all elves, the Asrai have a natural aptitude for magic, but their approach to its use differs greatly from both the rigidly schooled Mages of Ulthuan or the reckless Sorceresses of Naggaroth. While the High Elves reject the risks associated with Dark Magic and the Dark Elves embrace its promise of unfettered power, the Spellsingers of the Wood Elves instead seek to find a point of balance centered on their unique relationship with their forest home. By communing with the sprawling joint intelligence of Athel Loren and strengthening their bond with it, they are able to cast spells of nature, earth, air, and water without straying into the rigidity of High Magic or sadistic danger of Dark Magic. Their relationship with the forest manifests in a constant flow of energy which leaves them looking almost like Fey beings themselves, floating above the ground with their hair glowing and waving in the unseen Winds of Magic. Spellsingers are the most common magic users amongst the Asrai and perform most of the duties beneath the more powerful Spellweavers. Spellsingers are able to lend their voice to a chorus, a communion which can lend the power to an individual voice to weave more potent spells, but the forest does not permit them to lead them.

[Gain glamour, +1 precision, +1 morale, and +1 magic resistance in forests]"
#gcost 15
#weapon 9 -- dagger
#mr 16
#gcost 320
#rcost 1
#rpcost 2
#poorleader
#poormagicleader
#forestshape 14164
#holy
#magicskill 9 1 -- H1
#magicskill 6 1 -- N1
#custommagic 26368 100 -- AWENG
#custommagic 25088 100 -- WNG
#custommagic 17664 100 -- AEG
#spellsinger
#female
#float
#end


----- Spellsinger (Forest)

#newmonster 14164
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Spellsinger.tga"
#spr2 "Warhammer_Wood_Elves/Spellsinger2.tga"
#name "Spellsinger"
#descr "As with all elves, the Asrai have a natural aptitude for magic, but their approach to its use differs greatly from both the rigidly schooled Mages of Ulthuan or the reckless Sorceresses of Naggaroth. While the High Elves reject the risks associated with Dark Magic and the Dark Elves embrace its promise of unfettered power, the Spellsingers of the Wood Elves instead seek to find a point of balance centered on their unique relationship with their forest home. By communing with the sprawling joint intelligence of Athel Loren and strengthening their bond with it, they are able to cast spells of nature, earth, air, and water without straying into the rigidity of High Magic or sadistic danger of Dark Magic. Their relationship with the forest manifests in a constant flow of energy which leaves them looking almost like Fey beings themselves, floating above the ground with their hair glowing and waving in the unseen Winds of Magic. Spellsingers are the most common magic users amongst the Asrai and perform most of the duties beneath the more powerful Spellweavers. Spellsingers are able to lend their voice to a chorus, a communion which can lend the power to an individual voice to weave more potent spells, but the forest does not permit them to lead them.

[Lose glamour, 1 precision, 1 morale, and 1 magic resistance outside forests]"
#weapon 9 -- dagger
#mr 17 -- +1
#gcost 320
#rcost 1
#rpcost 2
#prec 13 -- +1
#mor 13 -- +1
#poorleader
#poormagicleader
#plainshape 14163
#holy
#magicskill 9 1
#magicskill 6 1 -- N1
#custommagic 26368 100 -- AWENG
#custommagic 25088 100 -- WNG
#custommagic 17664 100 -- AEG
#spellsinger
#female
#float
#glamour
#end


------ Highweaver


#newmonster 14171
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Highweaver.tga"
#spr2 "Warhammer_Wood_Elves/Highweaver2.tga"
#name "Highweaver"
#descr "As with all elves, the Asrai have a natural aptitude for magic, but their approach to its use differs greatly from both the rigidly schooled Mages of Ulthuan or the reckless Sorceresses of Naggaroth. While the High Elves reject the risks associated with Dark Magic and the Dark Elves embrace its promise of unfettered power, the Spellsingers of the Wood Elves instead seek to find a point of balance centered on their unique relationship with their forest home. The most powerful Spellsingers are known as Spellweavers and invariably have specialised in the use of either Dark or High magic, leading the Spellsingers in chorus to construct elaborate magical songs. Traditionally the Spellsingers maintain a balance of Highweavers and Darkweavers an encourage them to act in pairs, as each is able to complement or reign in their opposite as the situation demands. Highweavers make use of High Magic, though they reject its tendency to scour and destroy its counterpart, preferring instead to utilise it in a more subtle manner.

[Gain glamour, +1 precision, +1 morale, and +1 magic resistance in forests]"
#weapon 7 -- quarterstaff
#mr 17
#gcost 490
#rcost 1
#rpcost 4
#poorleader
#poormagicleader
#forestshape 14172
#holy
#magicskill 9 2 -- +1
#magicskill 6 2 -- +1
#magicskill 4 2 -- S2
#custommagic 26368 100 -- AWENG
#custommagic 25088 100 -- WNG
#custommagic 17664 100 -- AEG
#spellsinger
#female
#float
#end


----- Highweaver

#newmonster 14172
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Highweaver.tga"
#spr2 "Warhammer_Wood_Elves/Highweaver2.tga"
#name "Highweaver"
#descr "As with all elves, the Asrai have a natural aptitude for magic, but their approach to its use differs greatly from both the rigidly schooled Mages of Ulthuan or the reckless Sorceresses of Naggaroth. While the High Elves reject the risks associated with Dark Magic and the Dark Elves embrace its promise of unfettered power, the Spellsingers of the Wood Elves instead seek to find a point of balance centered on their unique relationship with their forest home. The most powerful Spellsingers are known as Spellweavers and invariably have specialised in the use of either Dark or High magic, leading the Spellsingers in chorus to construct elaborate magical songs. Traditionally the Spellsingers maintain a balance of Highweavers and Darkweavers an encourage them to act in pairs, as each is able to complement or reign in their opposite as the situation demands. Highweavers make use of High Magic, though they reject its tendency to scour and destroy its counterpart, preferring instead to utilise it in a more subtle manner.

[Lose glamour, 1 precision, 1 morale, and 1 magic resistance outside forests]"
#weapon 7 -- quarterstaff
#mr 18
#gcost 490
#rcost 1
#rpcost 4
#prec 13 -- +1
#mor 13 -- +1
#poorleader
#poormagicleader
#plainshape 14171
#holy
#magicskill 9 2 -- +1
#magicskill 6 2 -- +1
#magicskill 4 2 -- S2
#custommagic 26368 100 -- AWENG
#custommagic 25088 100 -- WNG
#custommagic 17664 100 -- AEG
#spellsinger
#female
#float
#glamour
#end

----- Darkweaver

#newmonster 14169
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Darkweaver.tga"
#spr2 "Warhammer_Wood_Elves/Darkweaver2.tga"
#name "Darkweaver"
#descr "As with all elves, the Asrai have a natural aptitude for magic, but their approach to its use differs greatly from both the rigidly schooled Mages of Ulthuan or the reckless Sorceresses of Naggaroth. While the High Elves reject the risks associated with Dark Magic and the Dark Elves embrace its promise of unfettered power, the Spellsingers of the Wood Elves instead seek to find a point of balance centered on their unique relationship with their forest home. The most powerful Spellsingers are known as Spellweavers and invariably have specialised in the use of either Dark or High magic, leading the Spellsingers in chorus to construct elaborate magical songs. Traditionally the Spellsingers maintain a balance of Highweavers and Darkweavers an encourage them to act in pairs, as each is able to complement or reign in their opposite as the situation demands. Darkweavers make use of Dark Magic but reject its most destructive and unnatural aspects, though they are no less powerful for this.

[Gain glamour, +1 precision, +1 morale, and +1 magic resistance in forests]"
#weapon 7 -- quarterstaff
#mr 17
#gcost 490
#rcost 1
#rpcost 4
#poorleader
#poormagicleader
#forestshape 14170
#holy
#magicskill 9 2 -- +1
#magicskill 6 2 -- +1
#magicskill 5 2 -- D2
#custommagic 26368 100 -- AWENG
#custommagic 25088 100 -- WNG
#custommagic 17664 100 -- AEG
#spellsinger
#female
#float
#end


----- Darkweaver (in forest)

#newmonster 14170
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Darkweaver.tga"
#spr2 "Warhammer_Wood_Elves/Darkweaver2.tga"
#name "Darkweaver"
#descr "As with all elves, the Asrai have a natural aptitude for magic, but their approach to its use differs greatly from both the rigidly schooled Mages of Ulthuan or the reckless Sorceresses of Naggaroth. While the High Elves reject the risks associated with Dark Magic and the Dark Elves embrace its promise of unfettered power, the Spellsingers of the Wood Elves instead seek to find a point of balance centered on their unique relationship with their forest home. The most powerful Spellsingers are known as Spellweavers and invariably have specialised in the use of either Dark or High magic, leading the Spellsingers in chorus to construct elaborate magical songs. Traditionally the Spellsingers maintain a balance of Highweavers and Darkweavers an encourage them to act in pairs, as each is able to complement or reign in their opposite as the situation demands. Darkweavers make use of Dark Magic but reject its most destructive and unnatural aspects, though they are no less powerful for this.

[Lose glamour, 1 precision, 1 morale, and 1 magic resistance outside forests]"
#weapon 7 -- quarterstaff
#mr 18
#gcost 490
#rcost 1
#rpcost 4
#prec 13 -- +1
#mor 13 -- +1
#poorleader
#poormagicleader
#plainshape 14169
#holy
#magicskill 9 2 -- +1
#magicskill 6 2 -- +1
#magicskill 5 2 -- D2
#custommagic 26368 100 -- AWENG
#custommagic 25088 100 -- WNG
#custommagic 17664 100 -- AEG
#spellsinger
#female
#float
#glamour
#end



------------ HEROES


----- Glade Lord on a Great Eagle multihero

#newmonster 14198
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Great_Eagle_Lord.tga"
#spr2 "Warhammer_Wood_Elves/Great_Eagle_Lord2.tga"
#name "Glade Lord Eaglerider"
#descr "The Wood Elves of Athel Loren have long been ruled over by an aristocratic class known as the Highborn, whose status and power is in proportion to their responsbility to defend and maintain the lands in which their followers dwell. The greatest Highborn are known as the Lords and Ladies and their power is near absolute. When one of the Lords takes to battle with his host of loyal Glade Guard, Kinbands, and Eternal Guard he is known as a Glade Lord, a warrior and leader to be greatly feared and admired. Glade Lords are powerful and influential enough within Athel Loren that they are even known to command small contingents of forest spirits such as Dryads and Treekin and can count on Spites, tiny and vicious spirits, to grant power to their lances. Some Glade Lords have forged bonds of friendship and alliance with the Great Eagles of the Grey Mountains and fly into battle on the back of one of these noble creatures. Great Eagles are more intelligent and noble in character than the Warhawks of the lower slopes but possess a great hatred of the evils that beset Athel Loren and are a deadly presence on the battlefield. Should the Glade Lord fall in battle the Great Eagle will fight to avenge him before returning to the mountains at the end of the battle.

[Gain glamour, recuperation, +1 precision, +1 morale, +1 strength, +2 hp, and +1 unsurroundable in forests. Asrai Long Bow will not harm friendlies in forests]"
#nametype 172 -- Elven names
#hp 20
#att 15
#def 15
#str 10
#prec 16
#mr 16 -- tier 3 leader, elf, +1 for great eagle
#mor 15
#armor 12 -- scale mail hauberk
#armor 118 -- half helmet
#armor 3 -- kite shield
#weapon 1141 -- asrai long bow
#weapon 1154 -- lance of spite
#gcost 0 -- hero
#rpcost 0
#rcost 0
#mountainsurvival
#forestsurvival
#expertleader
#poormagicleader
--
#latehero 6 -- can't appear before turn 6
#forestshape 14310
#skilledrider 3
#mobilearcher 1
#mountmnr 14311 -- great eagle
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Lord_Unmounted2.tga"
#end


----- Glade Lord on a Great Eagle multihero (forest shape)

#newmonster 14310
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Great_Eagle_Lord.tga"
#spr2 "Warhammer_Wood_Elves/Great_Eagle_Lord2.tga"
#name "Glade Lord Eaglerider"
#descr "The Wood Elves of Athel Loren have long been ruled over by an aristocratic class known as the Highborn, whose status and power is in proportion to their responsbility to defend and maintain the lands in which their followers dwell. The greatest Highborn are known as the Lords and Ladies and their power is near absolute. When one of the Lords takes to battle with his host of loyal Glade Guard, Kinbands, and Eternal Guard he is known as a Glade Lord, a warrior and leader to be greatly feared and admired. Glade Lords are powerful and influential enough within Athel Loren that they are even known to command small contingents of forest spirits such as Dryads and Treekin and can count on Spites, tiny and vicious spirits, to grant power to their lances. Some Glade Lords have forged bonds of friendship and alliance with the Great Eagles of the Grey Mountains and fly into battle on the back of one of these noble creatures. Great Eagles are more intelligent and noble in character than the Warhawks of the lower slopes but possess a great hatred of the evils that beset Athel Loren and are a deadly presence on the battlefield. Should the Glade Lord fall in battle the Great Eagle will fight to avenge him before returning to the mountains at the end of the battle.

[Lose glamour, recuperation, 1 precision, 1 morale, 1 strength, 2 hp, and 1 unsurroundable outside forests. Asrai Long Bow can harm friendlies outside forests]"
#nametype 172 -- Elven names
#hp 22
#att 15
#def 15
#str 11 -- +1
#prec 17 -- +1
#mr 16 -- tier 3 leader, elf, +1 for great eagle
#mor 16 -- +1
#armor 12 -- scale mail hauberk
#armor 118 -- half helmet
#armor 3 -- kite shield
#weapon 1170 -- asrai long bow
#weapon 1154 -- lance of spite
#gcost 0 -- hero
#rpcost 0
#rcost 0
#mountainsurvival
#forestsurvival
#expertleader
#poormagicleader
--
#heal
#glamour
#latehero 6 -- can't appear before turn 6
#plainshape 14198
#skilledrider 3
#mobilearcher 1
#mountmnr 14311 -- great eagle
#unmountedspr1 "Warhammer_Wood_Elves/Glade_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Wood_Elves/Glade_Lord_Unmounted2.tga"
#end


-- Great Eagle of Athel Loren

#newmonster 14311
#copystats 1381 -- Base game great eagle
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Wood_Elves/Great_Eagle.tga"
#spr2 "Warhammer_Wood_Elves/Great_Eagle2.tga"
#name "Great Eagle of Athel Loren"
#descr "Elvenkind has a long and close history with the Great Eagles of the world and in times past a formal alliance was struck between the Great Eagles of Ulthuan and her people. The Elves of Athel Loren hold no such treaty but have established close relations with the Great Eagles that inhabit the bordering Grey Mountains and share their hatred of evil intruders to either realm and so can often be found cooperating in battle. Great Eagles are similar to the Warhawks that nest on the lower slopes but are far larger, more intelligent, and of a nobler character. On rare occasion a Glade Lord will form such a bond with a Great Eagle that the two forevermore fight as a pair, the Great Eagle carrying the Asrai warrior to battle on its back. In battle Great Eagles are not so durable as other flying beasts like Griffons or Dragons, but are incredibly swift and capable of striking the rear ranks of an enemy force with great precision and to devastating effect.

[Great Eagles are not true forest dwellers and do not have a forest form]"
#size 8
#hp 42 -- W3T4, huge
#att 13 -- WS5I4
#def 12 -- WS5I4
#str 18 -- STR 4, huge, natural weapons
#prec 14 -- same as vanilla one
#enc 3
#mapmove 40
#ap 15 -- same as elves
#mr 13 -- animals, but magical, special, 1 less than vanilla one
#mor 15 -- proud, LD8, big monster, 3 less than vanilla
#weapon 408 -- Talons -- borrowed from HE
#weapon 404 -- Beak -- borrowed from HE
#gcost 0
#rpcost 0
#rcost 0
#maxage 3000
#flying
#mountainsurvival
#forestsurvival
#animal
#bird
#siegebonus 10
#patrolbonus 10
#bravemount 100
#end


-- Forest Dragon (outside of forest)

#newmonster 13734
#spr1 "Warhammer_Wood_Elves/Dragon_Forest.tga"
#spr2 "Warhammer_Wood_Elves/Dragon_Forest2.tga"
#name "Forest Dragon"
#descr "In the deepest recesses of the Chasm Glades there dwell a subspecies of Dragons, most ancient of creatures, that have adapted to life in Athel Loren. While across the rest of the world save Ulthuan the Dragon population has greatly dwindled, the great forest of Athel Loren offered them shelter and abundance which allowed them to thrive, though in exchange the forest changed them to better act as extensions of its power. Forest Dragons are as intelligent and noble as any of their kind but are somewhat more feral and predatory, respecting only that which has earned the respect of Athel Loren itself. While they do not slumber so deeply as their cousins in Ulthuan the Forest Dragons still spend much of their time at rest, enjoying dreams of distant lands and strange lore fuelled by tales and songs performed for them by the Asrai in a mutually beneficial relationship. From time to time a Forest Dragon will form a bond with a particular Glade Lord and the two will fight as one in battle, the Forest Dragon proving the greatest mount of all. Forest Dragons long ago lost their ability to breathe fire and instead can unleash a stream of soporific and poisonous gas. As some of the mightiest servants of the forest these Dragons are sacred to all the children of Athel Loren.

[Gain glamour, recuperation, +1 precision, +1 morale, +2 strength, +1 prot, +1 magic resistance, and +2 fear in forests]"
#size 9
#prot 18 -- -1
#hp 100 -- -6
#att 15
#def 14
#str 23 -- -1
#prec 14 -- -1
#enc 3
#mapmove 30
#ap 16
#mr 18 -- -1
#mor 19 -- -1
#weapon 1230 -- soporific breath
#weapon 20 -- bite
#weapon 33 -- claws
#weapon 532 -- tail sweep
#gcost 0
#rpcost 0
#rcost 0
#maxage 20000
#flying
#mountainsurvival
#forestsurvival
#darkvision 50
#fear 7 -- -2
#bird
#cleanshape
--nametype ??
#holy
#shockres 5
#fireres 10
#poisonres 20
#coldres 5
--illusion
--heal
#forestshape 13735
#end


-- Forest Dragon (in forest)

#newmonster 13735
#spr1 "Warhammer_Wood_Elves/Dragon_Forest.tga"
#spr2 "Warhammer_Wood_Elves/Dragon_Forest2.tga"
#name "Forest Dragon"
#descr "In the deepest recesses of the Chasm Glades there dwell a subspecies of Dragons, most ancient of creatures, that have adapted to life in Athel Loren. While across the rest of the world save Ulthuan the Dragon population has greatly dwindled, the great forest of Athel Loren offered them shelter and abundance which allowed them to thrive, though in exchange the forest changed them to better act as extensions of its power. Forest Dragons are as intelligent and noble as any of their kind but are somewhat more feral and predatory, respecting only that which has earned the respect of Athel Loren itself. While they do not slumber so deeply as their cousins in Ulthuan the Forest Dragons still spend much of their time at rest, enjoying dreams of distant lands and strange lore fuelled by tales and songs performed for them by the Asrai in a mutually beneficial relationship. From time to time a Forest Dragon will form a bond with a particular Glade Lord and the two will fight as one in battle, the Forest Dragon proving the greatest mount of all. Forest Dragons long ago lost their ability to breathe fire and instead can unleash a stream of soporific and poisonous gas. As some of the mightiest servants of the forest these Dragons are sacred to all the children of Athel Loren.

[Lose glamour, recuperation, 1 precision, 1 morale, 2 strength, 1 prot, 1 magic resistance, and 2 fear outside forests]"
#size 9 -- stats compared with normal shape
#prot 19 -- +1
#hp 100
#att 15
#def 14
#str 25 -- +2
#prec 15 -- +1
#enc 3
#mapmove 30
#ap 16
#mr 19 -- +1
#mor 19
#weapon 1230 -- soporific breath
#weapon 20 -- bite
#weapon 33 -- claws
#weapon 532 -- tail sweep
#gcost 0
#rpcost 0
#rcost 0
#maxage 20000
#flying
#mountainsurvival
#forestsurvival
#darkvision 50
#fear 9 -- +2
#bird
#cleanshape
#holy
#shockres 5
#fireres 10
#poisonres 20
#coldres 5
#glamour
#heal
#plainshape 13734
#end



-- Araloth

#newmonster 14188
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Hero_Araloth.tga"
#spr2 "Warhammer_Wood_Elves/Hero_Araloth2.tga"
#name "Lord of Talsyn"
#descr "Araloth is the Champion of the Mage Queen, Consort of the Goddess Lileath, and Lord of Talsyn, known to his fellow Asrai as Araloth the Bold for his feats of implacable bravery and honour in war. This was not always the case though, indeed Araloth was once a rather selfish and reluctant figure, who avoided battle in defence of his realm and preferred to spend his time hunting and enjoying his ancestral wealth. This all changed one fateful hunt when Araloth was separated from his band and stumbled across a glade where he saw a maiden of enchanting beauty menaced by a four armed Daemon of Slaanesh. All at once Araloth's reluctance and fear dissolved and he hurled himself into battle with the creature, facing certain death were it not for the intervention of his hawk Skaryn, who suddenly swept down and blinded the Daemon, allowing Araloth to strike a fatal blow. The maiden revealed herself to be the Goddess Lileath and spoke to Araloth of his destiny as her consort; from that day forth he was the greatest of the Glade Lords, a figure of towering bravery and selflessness rewarded by Ariel herself and honoured with Orion's respect. The Lord of Talsyn still bears the protection of his Goddess and fights in battle with a large enchanted hunting spear, accompanied by his faithful companion Skaryn, now known to all as the Eye Thief.

[Gain glamour, +1 precision, +1 strength, +4 hp, +1 att, and +1 def in forests]"
#hp 24 -- elf, hero
#size 3
#att 16
#def 16
#prec 17
#str 11
#mr 18 -- tier 4 leader, protection of Lileath
#invulnerable 12 -- lileath's protection
#mor 30 -- special
#enc 3
#armor 113 -- golden helmet
#armor 196 -- golden scale mail
#weapon 1165 -- Skaryn the eye thief
#weapon 1166 -- Great Hunting Spear
#gcost 0
#rcost 6
#expertleader
#inspirational 1
#poormagicleader
--
#rpcost 2
#forestshape 14189
#fixedname "Araloth"
#end


-- Araloth (forest shape)

#newmonster 14189
#copystats 14130
#spr1 "Warhammer_Wood_Elves/Hero_Araloth.tga"
#spr2 "Warhammer_Wood_Elves/Hero_Araloth2.tga"
#name "Lord of Talsyn"
#descr "Araloth is the Champion of the Mage Queen, Consort of the Goddess Lileath, and Lord of Talsyn, known to his fellow Asrai as Araloth the Bold for his feats of implacable bravery and honour in war. This was not always the case though, indeed Araloth was once a rather selfish and reluctant figure, who avoided battle in defence of his realm and preferred to spend his time hunting and enjoying his ancestral wealth. This all changed one fateful hunt when Araloth was separated from his band and stumbled across a glade where he saw a maiden of enchanting beauty menaced by a four armed Daemon of Slaanesh. All at once Araloth's reluctance and fear dissolved and he hurled himself into battle with the creature, facing certain death were it not for the intervention of his hawk Skaryn, who suddenly swept down and blinded the Daemon, allowing Araloth to strike a fatal blow. The maiden revealed herself to be the Goddess Lileath and spoke to Araloth of his destiny as her consort; from that day forth he was the greatest of the Glade Lords, a figure of towering bravery and selflessness rewarded by Ariel herself and honoured with Orion's respect. The Lord of Talsyn still bears the protection of his Goddess and fights in battle with a large enchanted hunting spear, accompanied by his faithful companion Skaryn, now known to all as the Eye Thief.

[Lose glamour, 1 precision, 1 strength, 4 hp, 1 att, and 1 def outside forests]"
#hp 28 -- elf, hero
#size 3
#att 17
#def 17
#prec 18
#str 12
#mr 18 -- tier 4 leader, protection of Lileath
#invulnerable 12 -- lileath's protection
#mor 30 -- special
#enc 3
#armor 113 -- golden helmet
#armor 196 -- golden scale mail
#weapon 1165 -- Skaryn the eye thief
#weapon 1166 -- Great Hunting Spear
#gcost 0
#rcost 6
#expertleader
#inspirational 1
#poormagicleader
--
#rpcost 2
#plainshape 14188
#glamour
#fixedname "Araloth"
#end


-- Drycha

#newmonster 14840
#spr1 "Warhammer_Wood_Elves/Hero_Drycha.tga"
#spr2 "Warhammer_Wood_Elves/Hero_Drycha2.tga"
#name "Briarmaven of Woe"
#descr "Drycha, known the the Wood Elves as the Briarmaven of Woe, is one of oldest Dryads and once held court amongst the glorious roots of Addaivoch, one of the greatest and most important trees of Athel Loren, though now a site forever tainted by the blood of the dread Morghur. Some say Drycha lost her mind when this corruption occurred, but in truth she was a capricious and malevolent spirit long before. Drycha is clear in her hatred of the Asrai and of the accord between the ancient forest and these mortal elves, even going so far as lead forces of Dryads in murder sprees during times when the alliance was already strained, though with the coming of a new age of strife there is hope common cause can be found in defence of the forest. Drycha has recently been seen communing with the dread Treeman Ancient Coeddil who is perhaps her only match in mistrust of the elves and her powers of dark and spiteful magic have increased considerably.

[Gain glamour, recuperation, reinvigoration 2, +1 morale, +2 strength, +2 magic resistance, +6 hp, +2 protection, and +1 unsurroundable in forests.]"
#size 3
#enc 1
#prot 10
#hp 35
#weapon 29 -- claw
#weapon 29 -- claw
#gcost 0
#rpcost 2
#rcost 1
#mapmove 18
#ap 14
#att 15
#def 14
#str 16
#mor 16
#mr 16
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 5500
#maxage 9000
#forestshape 14841
#magicskill 6 2 -- N2
#magicskill 7 1 -- G1
#magicskill 5 3 -- D3
#magicskill 8 1 -- H1
#holy
#combatcaster
#female
#okmagicleader
#poorleader
#fixedname "Drycha"
#end



-- Drycha (forest shape)

#newmonster 14841
#spr1 "Warhammer_Wood_Elves/Hero_Drycha.tga"
#spr2 "Warhammer_Wood_Elves/Hero_Drycha2.tga"
#name "Briarmaven of Woe"
#descr "Drycha, known the the Wood Elves as the Briarmaven of Woe, is one of oldest Dryads and once held court amongst the glorious roots of Addaivoch, one of the greatest and most important trees of Athel Loren, though now a site forever tainted by the blood of the dread Morghur. Some say Drycha lost her mind when this corruption occurred, but in truth she was a capricious and malevolent spirit long before. Drycha is clear in her hatred of the Asrai and of the accord between the ancient forest and these mortal elves, even going so far as lead forces of Dryads in murder sprees during times when the alliance was already strained, though with the coming of a new age of strife there is hope common cause can be found in defence of the forest. Drycha has recently been seen communing with the dread Treeman Ancient Coeddil who is perhaps her only match in mistrust of the elves and her powers of dark and spiteful magic have increased considerably.

[Lose glamour, recuperation, reinvigoration 2, 1 morale, 2 strength, 2 magic resistance, 6 hp, 2 protection, and 1 unsurroundable outside forests.]"
#size 3
#enc 1
#prot 12
#hp 41
#weapon 29 -- claw
#weapon 29 -- claw
#gcost 0
#rpcost 2
#rcost 1
#mapmove 18
#ap 14
#att 15
#def 14
#str 16
#mor 17
#mr 18
#fireres -5
#poisonres 15 -- same as vine man
#coldres 5
#snow
#bluntres
#pierceres
#magicbeing
#forestsurvival
#spiritsight
#plant
#neednoteat
#startage 5500
#maxage 9000
#plainshape 14840
#magicskill 6 2 -- N2
#magicskill 7 1 -- G1
#magicskill 5 3 -- D3
#magicskill 8 1 -- H1
#holy
#combatcaster
#female
#okmagicleader
#poorleader
#fixedname "Drycha"
#glamour
#reinvigoration 2
#heal 2
#end

----- Orion

#newmonster 14312
#spr1 "Warhammer_Wood_Elves/Hero_Orion.tga"
#spr2 "Warhammer_Wood_Elves/Hero_Orion2.tga"
#name "King in the Woods"
#descr "Orion is the king of Athel Loren, an immortal being whose existence is irrevocably tied to the seasons. Thus does he willingly pass into his own funeral pyre each Midwinter, only to be reborn into thunderous life on the first day of spring. Orion is the material personnification of the Elven god Kurnous the Hunter and the consort of Ariel who is herself the avatar of Isha the goddess of magic and growth. When Orion awakens at full strength in spring he leads the Wild Hunt, a great surge of Asrai activity in defending their realm and destroying those who would threaten it, with some elves entirely succumbing to their primal instincts to hunt. In battle Orion is always accompanied by a pair of magical Hounds of Kurnous which leap forward to tear the enemy limb from limb and is armed with his great bow known as Hawk's Talon, the legendary Spear of Kurnous, and the Horn of the Wild Hunt, while being protected by the immaterial mantle known as the Cloak of Isha. These fabled armaments make Orion deadly indeed, but his own form is also truly mighty, marrying the raw physicality and unrelenting savagery of a great beast with the grace and skill of an elven lord. Orion is fated to die and be reborn each year and no matter whether he is struck down in battle or willingly destroys himself in his own funernal pyre come Midwinter, he will always return on the first day of the coming spring.

[Gain glamour, rejuvenation, +2 precision, +2 berserk, +2 fear, +2 strength, +10 patrol bonus, and +1 unsurroundable in forests]
[Summons 2 sacred Hounds of Kurnous and casts Divine Blessing on battle start]
[Orion will always die, no matter what, after the first turn of the winter season, so plan accordingly]"
#weapon 1208 -- spear of Kurnous
#weapon 1207 -- Hawk's Talon bow
#weapon 831 -- magic hoof
#size 7
#enc 2
#hp 60 -- W5, T5, big
#prot 9
#forestsurvival
#att 16 -- WS8, always strikes first
#def 16 --
#str 20 -- str 6, big
#prec 17 -- super accurate
#mr 18
#mor 30 -- pretender level
#ap 20
#mapmove 24
--
#gcost 0
#rcost 1
#rpcost 1
#expertleader
#goodmagicleader
#forestshape 14313
#fear 5
#berserk 3
#magicbeing
#invulnerable 15
#siegebonus 30 -- from the horn
#patrolbonus 20 -- the ultimate hunter
#regeneration 10 -- from the cloak of Isha
#itemslots 17702912 -- crown, feet, 2 misc
#batstartsum2 14314 -- hound of Kurnous
#immortal
#springimmortal -- reforms in spring
#springpower 30
#maxage 9000
#startage 3000
#holy
#spreaddom 1
#fixedname "Orion"
#onebattlespell "Divine Blessing"
#end


----- Orion (forestshape)

#newmonster 14313
#spr1 "Warhammer_Wood_Elves/Hero_Orion.tga"
#spr2 "Warhammer_Wood_Elves/Hero_Orion2.tga"
#name "King in the Woods"
#descr "Orion is the king of Athel Loren, an immortal being whose existence is irrevocably tied to the seasons. Thus does he willingly pass into his own funeral pyre each Midwinter, only to be reborn into thunderous life on the first day of spring. Orion is the material personnification of the Elven god Kurnous the Hunter and the consort of Ariel who is herself the avatar of Isha the goddess of magic and growth. When Orion awakens at full strength in spring he leads the Wild Hunt, a great surge of Asrai activity in defending their realm and destroying those who would threaten it, with some elves entirely succumbing to their primal instincts to hunt. In battle Orion is always accompanied by a pair of magical Hounds of Kurnous which leap forward to tear the enemy limb from limb and is armed with his great bow known as Hawk's Talon, the legendary Spear of Kurnous, and the Horn of the Wild Hunt, while being protected by the immaterial mantle known as the Cloak of Isha. These fabled armaments make Orion deadly indeed, but his own form is also truly mighty, marrying the raw physicality and unrelenting savagery of a great beast with the grace and skill of an elven lord. Orion is fated to die and be reborn each year and no matter whether he is struck down in battle or willingly destroys himself in his own funernal pyre come Midwinter, he will always return on the first day of the coming spring.

[Lose glamour, rejuvenation, 2 precision, 2 berserk, 2 strength, and 1 unsurroundable outside forests]
[Summons 2 sacred Hounds of Kurnous and casts Divine Blessing on battle start]
[Orion will always die, no matter what, after the first turn of the winter season, so plan accordingly]"
#weapon 1208 -- spear of Kurnous
#weapon 1207 -- Hawk's Talon bow
#weapon 831 -- magic hoof
#size 7
#enc 2
#hp 60 -- W5, T5, big
#prot 9
#forestsurvival
#att 16 -- WS8, always strikes first
#def 16 --
#str 22
#prec 19
#mr 18
#mor 30 -- pretender level
#ap 20
#mapmove 24
--
#gcost 0
#rcost 1
#rpcost 1
#expertleader
#goodmagicleader
#plainshape 14312
#fear 7
#berserk 5
#magicbeing
#invulnerable 15
#siegebonus 30 -- from the horn
#patrolbonus 30 -- the ultimate hunter
#regeneration 10 -- from the cloak of Isha
#itemslots 17702912 -- crown, feet, 2 misc
#batstartsum2 14314 -- hound of Kurnous
#immortal
#springimmortal -- reforms in spring
#springpower 30
#maxage 9000
#startage 3000
#heal
#glamour
#holy
#spreaddom 1
#fixedname "Orion"
#onebattlespell "Divine Blessing"
#end


----- Ariel

#newmonster 13773
#spr1 "Warhammer_Wood_Elves/Hero_Ariel.tga"
#spr2 "Warhammer_Wood_Elves/Hero_Ariel2.tga"
#name "Queen in the Woods"
#descr "Ariel is the mage-queen of Athel Loren and ruler of the Asrai, alongside her constantly reborn consort King Orion. She is one of the most powerful users of magic in the world, being an immortal demi-goddess and the Avatar of the Elven goddess of magic, Isha. In centuries past Ariel suffered the loss of her sister and fell into a spiral of despair and vengeful rage, upsetting the balance of Athel Loren and embracing the use of Dark Magic, but this age of retribution and suffering was brought to an end by the noble sacrifice of the greatest Treeman Elder, Adanhu, who absorbed all the darkness from Ariel's form. Since that time Ariel has not used Dark Magic and has once more become an exemplar of nobility, compassion, and wisdom, though she is still quick to destroy any who would threaten Athel Loren. Ariel has tremendous power over nature and the elements as well as a deep understanding of High Magic. In battle she is a terrifying and awesome presence but prefers to make use of her magical talents to win the day, avoiding close-quarters combat where possible. As a divine Avatar Ariel is able to draw on the power of Athel Loren and the Oak of Ages at all times and is no less powerful outside of her beloved forests.

[Casts Divine Blessing and creates two temporary nature gems on battle start]"
#weapon 1099 -- magic staff bonus
#armor 230 -- magic robes
#size 8
#hp 50
#prot 0
#forestsurvival
#att 13
#def 13
#str 14
#prec 17
#enc 2
#mr 19
#mor 30 -- pretender level
#ap 20
#mapmove 30
#gcost 0
#rcost 1
#rpcost 1
#expertleader
#goodmagicleader
#shockres 10
#fireres 5
#coldres 10
#poisonres 15
#fear 5
#awe 3
#heal
#glamour
#ethereal
#tmpnaturegems 2
#autohealer 2
#female
#magicbeing
#invulnerable 10
#flying
#float
#itemslots 17702912 -- crown, feet, 2 misc, bow
#maxage 20000
#startage 10000
#holy
#spreaddom 1
#fixedname "Ariel"
#onebattlespell "Divine Blessing"
#magicskill 9 3 -- H3
#magicskill 6 4 -- N4
#magicskill 1 3 -- A3
#magicskill 2 2 -- W2
#magicskill 3 1 -- E1
#magicskill 4 2 -- S2
#magicskill 7 2 -- G2
#unique
#end



---- Hound of Kurnous

#newmonster 14314
#spr1 "Warhammer_Wood_Elves/Hound.tga"
#spr2 "Warhammer_Wood_Elves/Hound2.tga"
#name "Hound of Kurnous"
#descr "As the Avatar of Kurnous and master of the Wild Hunt, Orion is always flanked by a pair of magical Hounds of Kurnous. These great baying hounds are embodiments of Kurnous' instinct to track his prey and tear at it in the most bestial manner and they will eagerly bound ahead of Orion when they catch the scent of the enemy. The hounds are capable of entering a bloodthirsty frenzy just like Orion and are surprisingly powerful in combat."
#size 4 -- horse sized pretty much
#hp 20
#prot 6
#invulnerable 10
#att 12
#def 11
#str 15
#prec 12
#enc 1
#mapmove 26
#ap 26
#mr 14
#mor 30
#weapon 1209 -- bite, magical
#gcost 0
#rpcost 0
#rcost 0
#maxage 3000
#forestsurvival
#magicbeing
#animal
#heal
#quadruped
#regeneration 10
#springpower 20
#holy
#end







----------------- SPELLS

--copy of man's communion slave spell, call Join Chorus

#newspell
#copyspell "chorus slave"
#name "Join Chorus"
#descr "Spellsingers are capable of joining groups of like minded mages working in concert and merging their voices and wills, subsuming themselves to the group and communing with the world. Such a group is known as a Chorus and those who take the position of leader will be able to draw on its power to greatly enhance their magical power. Spellsingers are not permitted to lead a Chorus, for they lack the training to maintain a proper balance and channel the power through the use of powerful High or Dark magic."
#details "Identical in effect to the Man national spell Chorus Slave - effectively an alternate way of casting Communion Slave, which is forbidden to the Wood Elf nation. The fatigue that comes from casting spells will be distributed among all chorus members and the chorus master will also be able to cast more powerful spells than she could alone. While in communal chorus, all spells that only affect the caster will also affect all the chorus members. A chorus with two slaves will grant all masters one extra level in all their paths, four slaves will grant two levels, eight slaves will grant three levels, and so on. Only spell singers can cast this spell."
#notfornation 47
#notfornation 83
#restricted 151
#path 0 6 -- N
#pathlevel 0 1 -- N1
#end



--copy of man's communion master spell, at S2, called High Chorus, only castable by spellsinger things

#newspell
#copyspell "chorus master"
#name "High Chorus"
#descr "With this chant the Highweaver takes a lead position amongst of a Chorus of Spellsingers, such that their power might be guided through the Weaver's High Magic to cast powerful spells."
#details "Identical in effect to the Man national spell Chorus Master - effectively an alternate way of casting Communion Master (a spell forbidden to the Wood Elf nation). The fatigue that comes from casting spells will be distributed among all chorus members and the chorus master will also be able to cast more powerful spells than she could alone. While in communal chorus, all spells that only affect the caster will also affect all the chorus members. A chorus with two slaves will grant all masters one extra level in all their paths, four slaves will grant two levels, eight slaves will grant three levels, and so on."
#notfornation 47
#notfornation 83
#path 0 4
#pathlevel 0 2 -- S2
#restricted 151
#end


--copy of man's communion master spell, at D2, called Dark Chorus, only castable by spellsinger things

#newspell
#copyspell "chorus master"
#name "Dark Chorus"
#descr "With this chant the Darkweaver takes a lead position amongst of a Chorus of Spellsingers, such that their power might be bent through the Weaver's Dark Magic to cast powerful spells."
#details "Identical to the Man national spell Chorus Master - effectively an alternate way of casting Communion Master (a spell forbidden to the Wood Elf nation). The fatigue that comes from casting spells will be distributed among all chorus members and the chorus master will also be able to cast more powerful spells than she could alone. While in communal chorus, all spells that only affect the caster will also affect all the chorus members. A chorus with two slaves will grant all masters one extra level in all their paths, four slaves will grant two levels, eight slaves will grant three levels, and so on."
#notfornation 47
#notfornation 83
#path 0 5
#pathlevel 0 2 -- D2
#restricted 151
#end


---- this stops the wood elves and dwarfs having communion slave and master

#selectspell "Communion Slave"
#notfornation 151
#notfornation 159
#end

#selectspell "Communion Master"
#notfornation 151
#notfornation 159
#end


-- Succor of Athel Loren

#newspell
#copyspell "Eagle Eyes"
#name "Succor of Athel Loren"
#descr "The mage calls upon the spirits of Athel Loren to look favourably on them and grant them a portion of their energy, reinvigorating them for the duration of the battle."
#details "This is half the reinvigoration granted by Summon Earthpower, 2 rather than 4. If you cast Summon Earthpower the 4 will override the 2."
#effect 23 -- type 2 buff
#damage 68719476736 -- reinvigoration
#school 4 -- enchantment
#fatiguecost 15 -- +10
#restricted 151 -- wood elves
#end



-- Worldroot Sojourn

#newspell
#copyspell "teleport"
#name "Worldroot Sojourn"
#descr "Tapping into the system of Worldroots that connects all forests across the land, the mage travels to a distant forested province. Time functions differently in the Worldroots and the journey will appear instantaneous to any observers."
#details "Identical to the Teleport spell but with different paths and can only be cast in a forest and target a forest."
#path 0 6 -- nature
#pathlevel 0 3 -- N3
#onlygeosrc 128 -- forest
#onlygeodst 128 -- forest
#school 4 -- enchantment
#restricted 151 -- wood elves
#end


-- Worldroot Journey

#newspell
#copyspell "astral travel"
#name "Worldroot Journey"
#descr "Tapping into the system of Worldroots that connects all forests across the land, the mage opens a path through which they may travel with their followers to a distant forested province. Time functions differently in the Worldroots and the journey will appear instantaneous to any observers."
#details "Identical to the Astral Travel spell but with different paths and a lower cost but can only be cast in a forest and target a forest."
#path 0 6 -- nature
#pathlevel 0 4 -- N4
#onlygeosrc 128 -- forest
#onlygeodst 128 -- forest
#school 4 -- enchantment
#researchlevel 6 -- -3
#fatiguecost 1500 -- -10
#restricted 151 -- wood elves
#end



------ SUMMON SPELLS


--- Lords of Two Worlds

#newspell
#copyspell "Awaken Sleeper" -- checked
#name "Lords of Two Worlds"
#descr "With this ritual a Glade Lord of great renown and a Great Stag of Athel Loren are forever bonded. No animal in Athel Loren is more treasured than the Great Stag, a noble and intelligent beast which the Asrai revere as representing the true soul of the forest. Whatever the truth of their nature, it is undeniable that the Great Stags are magical creatures and of a higher cast than the capricious Unicorns. They are typically only seen at portentous times, known to offer themselves are war steeds to Asrai of particular virtue or those destined to do great deeds in defence of the forest, though of late they have revealed themselves in far greater numbers than ever before. Great Stags are sacred to the Asrai."
#details "Summons a sacred Glade Lord on Great Stag commander."
#researchlevel 5
#restricted 151
#path 0 6 -- nature
#pathlevel 0 3
#damage 14182 -- glade lord on great stag
#fatiguecost 1400
#end


--- Summon Unicorns of Athel Loren

#newspell
#copyspell "Summon Leogryphs" -- checked
#name "Summon Unicorns of Athel Loren"
#descr "With this ritual the mage calls and binds a small number of Unicorns from the depths of Athel Loren. The Unicorns of Athel Loren are the most famed of their kind and for good reason, for they are more powerful and fearsome than their cousins on Ulthuan or other distant forests. Innately magical creatures, they are not the noble beasts immortalised in song by Bretonnian bards, but instead selfish and arrogant in the extreme, harbouring no notions of kinship with mortals nor forest spirits. Unicorn ivory is highly prized and Unicorns are quite aware of their allure, so they delight in allowing themselves to be seen and pursued by would be hunters, only to be lured into a pack of vengeful forest Spites, deadly Waywatchers, or simply the territory of some ferocious predator. Should they find themselves in combat they are quite capable, for they are supernaturally swift and able to deal terrible damage with their magical horn and powerful hooves. Unicorns are resistant to and capable of consuming magical power and those who inhabit Athel Loren have had considerable exposure to Dark Magic, heightening their vindictive temperaments and lending them an aura of terrifying malice when they are encountered in a forest."
#details "Summons Unicorn troops."
#researchlevel 3
#restricted 151
#path 0 6 -- nature
#pathlevel 0 2
#nreff 1002 -- 4+ 1 per level
#damage 14190
#fatiguecost 700
#end



--- Summon Great Eagles of Athel Loren

#newspell
#copyspell "Summon Great Eagles" -- checked
#name "Summon Great Eagles of Athel Loren"
#descr "Elvenkind has a long and close history with the Great Eagles of the world and in times past a formal alliance was struck between the Great Eagles of Ulthuan and her people. The Elves of Athel Loren hold no such treaty but have established close relations with the Great Eagles that inhabit the bordering Grey Mountains and share their hatred of evil intruders to either realm and so can often be found cooperating in battle. Great Eagles are similar to the Warhawks that nest on the lower slopes but are far larger, more intelligent, and of a nobler character. In battle Great Eagles are not so durable as other flying beasts like Griffons or Dragons, but are incredibly swift and capable of striking the rear ranks of an enemy force with great precision and to devastating effect."
#details "Summons Great Eagle troops."
#researchlevel 4
#restricted 151
#path 0 1 -- air
#pathlevel 0 2
#nreff 1002 -- 3+ 1 per level
#damage 14311
#fatiguecost 700 -- +1 over the high elf version because they're less allied
#end




--- Lords of Two Worlds

#newspell
#copyspell "Awaken Sleeper" -- checked
#name "Princes of Forest and Peak"
#descr "With this ritual a Glade Lord of great renown and a Great Eagle of the Grey Mountains are forever bonded, the Asrai Warrior flying into battle on the back of his noble ally. Elvenkind has a long and close history with the Great Eagles of the world and in times past a formal alliance was struck between the Great Eagles of Ulthuan and her people. The Elves of Athel Loren hold no such treaty but have established close relations with the Great Eagles that inhabit the bordering Grey Mountains and share their hatred of evil intruders to either realm and so can often be found cooperating in battle. Great Eagles are similar to the Warhawks that nest on the lower slopes but are far larger, more intelligent, and of a nobler character. In battle Great Eagles are not so durable as other flying beasts like Griffons or Dragons, but are incredibly swift and capable of striking the rear ranks of an enemy force with great precision and to devastating effect."
#details "Summons a Glade Lord on Great Eagle commander."
#researchlevel 5
#restricted 151
#path 0 1 -- air
#pathlevel 0 3
#damage 14198 -- glade lord on great eagle
#fatiguecost 1500 -- +1 over high elf version because they're less close
#end



--- Summon Great Stag

#newspell
#copyspell "Summon Leogryphs" -- checked
#name "Summon Great Stag"
#descr "With this ritual the mage calls and binds a Great Stag of Athel Loren. No animal in Athel Loren is more treasured than the Great Stag, a noble and intelligent beast which the Asrai revere as representing the true soul of the forest. Whatever the truth of their nature, it is undeniable that the Great Stags are magical creatures and of a higher cast than the capricious Unicorns. They are typically only seen at portentous times, known to offer themselves are war steeds to Asrai of particular virtue or those destined to do great deeds in defence of the forest, though of late they have revealed themselves in far greater numbers than ever before."
#details "Summons a single sacred Great Stag troop."
#researchlevel 4
#restricted 151
#path 0 6 -- nature
#pathlevel 0 3
#nreff 1
#damage 14180
#fatiguecost 400
#end


--- Contact Treeman

#newspell
#copyspell "Awaken Sleeper" -- checked
#name "Contact Treeman"
#descr "With this ritual the caster calls one of the greatest and most powerful forest spirits come to the aid of Athel Loren in the form of a Treeman. Treemen are revered by the Asrai and other inhabitants of the forest alike and these great sentinels of Athel Loren are typically home to a great many lesser spirits that will lend them strength should they be threatened. For their part the Treemen cherish the lives of lesser creatures and boast a warmth of character totally unlike that of the spiteful Dryads. They can be counted amongst the mightiest of Athel Loren's denizens, able to wield magic of nature and earth and possessing incredible physical prowess and resilience. Treemen do not fight with grace but instead rely on sheer ferocity and their great strength to smash threats to their forest realm or tear them apart with whipping tendrils as strong as steel."
#details "Summons a sacred Treeman commander. Note this commander is the same as the capital recruitable and so will have a gold upkeep."
#researchlevel 5
#onlygeosrc 128 -- forest
#restricted 151
#path 0 6 -- nature
#pathlevel 0 3
#damage 14192 -- treeman
#fatiguecost 3500
#end


--- Contact Forest Dragon

#newspell
#copyspell "Awaken Sleeper" -- checked
#name "Contact Forest Dragon"
#descr "With this ritual the caster contacts one of the mighty Forest Dragons of Athel Loren to act in defence of the wooded realm. While across the rest of the world save Ulthuan the Dragon population has greatly dwindled, the great forest of Athel Loren offered them shelter and abundance which allowed them to thrive, though in exchange the forest changed them to better act as extensions of its power. Forest Dragons are as intelligent and noble as any of their kind but are somewhat more feral and predatory, respecting only that which has earned the respect of Athel Loren itself. While they do not slumber so deeply as their cousins in Ulthuan the Forest Dragons still spend much of their time at rest, enjoying dreams of distant lands and strange lore fuelled by tales and songs performed for them by the Asrai in a mutually beneficial relationship. From time to time a Forest Dragon will form a bond with a particular Glade Lord and the two will fight as one in battle, the Forest Dragon proving the greatest mount of all. Forest Dragons long ago lost their ability to breathe fire and instead can unleash a stream of soporific and poisonous gas. As some of the mightiest servants of the forest these Dragons are sacred to all the children of Athel Loren."
#details "Summons a sacred Forest Dragon commander."
#researchlevel 6
#onlygeosrc 128 -- forest
#restricted 151
#path 0 6 -- nature
#pathlevel 0 4
#damage 13734 -- Forest dragon non-forest shape
#fatiguecost 3400
#end



--- Awaken Treeman Ancient

#newspell
#copyspell "Awaken Sleeper" -- checked
#name "Awaken Ancient of Athel Loren"
#descr "With this ritual the caster awakens one of the oldest, wisest, and most powerful of the forest spirits in the world, rousing a Treeman Ancient from their dreaming slumber to unleash fury upon the enemies of Athel Loren. "
#details "Summons a sacred Treeman Ancient commander. Note this commander is the same as the capital recruitable and so will have a gold upkeep. This ritual can only be cast in a forest."
#researchlevel 6
#onlygeosrc 128 -- forest
#restricted 151
#path 0 6 -- nature
#pathlevel 0 4
#damage 14194 -- treeman ancient
#fatiguecost 4500
#end


--- Awaken Ariel

#newspell
#copyspell "Awaken Sleeper" -- checked
#name "Rouse the Queen in the Woods"
#descr "By performing a highly secretive ritual in the Ancient Glade surrounding the Oak of Ages, the caster rouses Queen Ariel, ruler of Athel Loren, from her slumber in the Oak of Ages. As the Avatar of Isha, the elven goddess of magic, Ariel is an extremely powerful magic user and a deadly force on the battlefield, though she is not much of a melee combatant."
#details "Summons the unique commander Ariel the Queen in the Woods. This ritual may only be cast in the Wood Elf capital where the Ancient Glade site is present."
#researchlevel 8
#restricted 151
#path 0 6 -- nature
#pathlevel 0 5
#damage 13773 -- Ariel
#fatiguecost 7000
#onlyatsite "Ancient Glade"
#end




----------------- NAMETYPES

-- Wood elf

#selectnametype 200
#addname "Aymon"
#addname "Galaeron"
#addname "Naertho"
#addname "Elauthin"
#addname "Ettrian"
#addname "Laeroth"
#addname "Aias"
#addname "Lathlaeril"
#addname "Ascal"
#addname "Giullis"
#addname "Iefyr"
#addname "Kolvar"
#addname "Elashor"
#addname "Ornthalas"
#addname "Gorred"
#addname "Almar"
#addname "Durothil"
#addname "Hatharal"
#addname "Illithor"
#addname "Faeranduil"
#addname "Goren"
#addname "Nelaeryn"
#addname "Hagduin"
#addname "Orym"
#addname "Ardryll"
#addname "Arlen"
#addname "Fhaornik"
#addname "Ailmon"
#addname "Halamar"
#addname "Ailen"
#addname "Lukalyn"
#addname "Keacaryn"
#addname "Grexidor"
#addname "Mormys"
#addname "Hermoira"
#addname "Magfina"
#addname "Yinpeiros"
#addname "Sardithas"
#addname "Keaven"
#addname "Mirahice"
#addname "Glynkian"
#addname "Xilydark"
#addname "Grecyne"
#addname "Elazorwyn"
#addname "Olaydark"
#addname "Engwyn"
#addname "Torwynn"
#addname "Olarel"
#addname "Lorajyre"
#addname "Heilar"
#addname "Daebella"
#addname "Quijyre"
#addname "Ravaralei"
#addname "Thefina"
#addname "Uriyarus"
#addname "Genyarus"
#addname "Shaceran"
#addname "Farrona"
#addname "Aeneiros"
#addname "Fenjor"
#addname "Valdalas"
#addname "Clensai"
#addname "Basteleb"
#addname "Bralindir"
#addname "Girddhel"
#addname "Bereephor"
#addname "Montrm"
#addname "Aenhroth"
#addname "Monond"
#addname "Sildor"
#addname "Urunhelorn"
#addname "Anruthaur"
#addname "Elbendal"
#addname "Hunhaur"
#addname "Coal"
#addname "Galnir"
#addname "Daealorn"
#addname "Galtfin"
#addname "Gunthil"
#addname "Fauegor"
#addname "Valth"
#addname "Britlorn"
#addname "Norasai"
#addname "Tarelras"
#addname "Allrthir"
#addname "Cleomlallor"
#addname "Ulwhir"
#addname "Anrurien"
#addname "Hinonor"
#addname "Agarindor"
#addname "Filorolros"
#addname "Berethil"
#addname "Angelor"
#addname "Barading"
#addname "Anorronor"
#addname "Brolgor"
#addname "Ururannir"
#addname "Alveelas"
#addname "Basrin"
#addname "Ungragor"
#addname "Sagehollow"
#addname "Fernrun"
#addname "Dornlake"
#addname "Forestwind"
#addname "Ivyblossom"
#addname "Skyprowl"
#addname "Balfstone"
#addname "Applebrook"
#addname "Applesky"
#addname "Fernwind"
#addname "Sagescrub"
#addname "Springsky"
#addname "Applerock"
#addname "Seedshade"
#addname "Oakwind"
#addname "Seedblossom"
#addname "Duskstone"
#addname "Oakenwood"
#addname "Sagewing"
#addname "Lichengrass"
#addname "Barkbrook"
#addname "Springdale"
#addname "Pinelock"
#addname "Bladehollow"
#addname "Sageblossom"
#addname "Blueblossom"
#addname "Softmire"
#addname "Forestmire"
#addname "Oakwood"
#addname "Arlath"
#addname "Belrathion"
#addname "Altharion"
#addname "Campion"
#addname "Terramire"
#addname "Applehollow"
#addname "Softvale"
#addname "Hawkfletch"
#addname "Birchblade"
#addname "Talsymir"
#addname "Arloth"
#addname "Vendrys"
#addname "Silvarys"
#addname "Torlath"
#addname "Timberheart"
#addname "Gladeheart"
#addname "Frostbranch"
#addname "Bitterleaf"
#addname "Thornblade"
#addname "Thornheart"
#end




------------ SITES


------ Glade of Shadow

#newsite 2087
#name "Glade of Shadow"
#path 5
#level 0
#rarity 5
#gems 5 1
#homecom 14169 -- darkweaver
#end


------ Glade of Light

#newsite 2088
#name "Glade of Light"
#path 4
#level 0
#rarity 5
#gems 4 1
--homemon 14151 -- sister of the thorn
#homemon 14152 -- sister of the thorn (forest shape)
#homecom 14171 -- highweaver
#end


------ Ancient Glade

#newsite 2111
#name "Ancient Glade"
#path 6
#level 0
#rarity 5
#gems 6 2
#gems 7 1
#homecom 14197 -- treeman
#homecom 14196 -- treeman ancient
--homemon 14141 -- wild rider
#homemon 14142 -- wild rider (forest shape)
#end




--------- PREVIEW SITES

--- Summons

#newsite 2115
#name "Wood Elf Summons and Other"
#path 6 -- nature
#level 0
#rarity 5
#homecom 13773 -- Ariel
#homecom 13734 -- forest dragon
#homecom 14192 -- treeman
#homecom 14194 -- treeman ancient
#homecom 14182 -- glade lord on great stag
#homecom 14198 -- glade lord on great eagle
#homemon 14180 -- great stag
#homemon 14311 -- great eagle
#homemon 14190 -- unicorn
#homemon 14177 -- warhawk riderless
#homemon 14314 -- hound of kurnous
#end


--- Luck based Multiheroes

#newsite 2116
#name "Wood Elf Luck Based Multiheroes"
#path 4 -- astral looking thing
#level 0
#rarity 5
#homecom 14192 -- treeman
#homecom 14182 -- glade lord on great stag
#homecom 14198 -- glade lord on great eagle
#homecom 14171 -- highweaver
#homecom 14169 -- darkweaver
#end


--- Luck-independent Heroes

#newsite 2117
#name "Wood Elf Luck-independent Heroes"
#path 1 -- air
#level 0
#rarity 5
#homecom 14312 -- Orion
#homecom 14188 -- Araloth
#homecom 14840 -- Drycha
#end


--- Dryad Shapes

#newsite 2118
#name "Dryad Seasonal Shapes"
#path 6 -- nature
#level 0
#rarity 5
#homemon 14145 -- spring
#homemon 14149 -- summer
#homemon 14143 -- autumn
#homemon 14147 -- winter
#end



-------------- EVENTS


#newevent
#msg "Athel Loren special mechanics explainer:

The King in the Woods. In the second turn of spring in year 1 (so on turn 13 of the game) you will receive an event that gives you Orion, a very powerful military commander and single combatant. In the second month of each winter you will get an event that kills Orion if he is still alive, or perhaps he will die in battle before then, but either way he is a spring immortal so will return on the first month of the following spring.

Forest Home. Most of your commanders and troops gain bonuses when in a forest province. Use this to your advantage! In particular you will notice they get glamour (prevents enemy from seeing you on the strategic map and gives a defensive bonus in combat) when in a forest. Additionally it is cheaper for you to build labs and temples in a forest but more expensive outside.

Bramble Forts. Wood Elves are poor builders of forts (they are more expensive and limited to just pallisades) unless you order a fort built in a forest province. An order to build a fort in a forest will give you a bramble fort the very next month."
#req_owncapital 1
#req_pregame 1 -- only happens before the first turn of the game
#req_fornation 151
#nation 151
#req_unique 1
#rarity 5
#header 2
#end



-- Get a free bramble fort when you try to build a fort in a forest province

#newevent
#msg "Bramble fort grown in ##landname##.

You started construction of a fort in a forest province as the Wood Elves, so you get a free bramble fort."
#req_targorder 20 -- build fort
#nation 151 -- wood elves
#rarity 5
#req_forest 1 -- forest prov
#req_pop0ok -- can fire in provinces with low pop
#req_land 1 -- must be land
#req_fornation 151
#req_fort 0 -- no fort here
#fort 10 -- bramble fort get
#header 2
#end


------ HERO EVENTS

---- SPAWN HERO Araloth

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Araloth the Bold, Lord of Talsyn, Consort of the Goddess Lileath, Champion of the Mage Queen has joined your cause, bringing with him a small band of Eternal Guard."
#req_owncapital 1
#req_fornation 151
#nation 151
#com 14188 -- Araloth
#req_nomnr 14188
#rarity 5
#req_rare 3 -- 3% chance, since he's the only hero currently
#4d3units 14135 -- Eternal Guard
#req_turn 6 -- not super early
#req_varzero 200 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 200 -- increments the event variable to 1, which stops this event ever firing again
#header 2
#end


---- SPAWN HERO Drycha

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Drycha the Briarmaven of Woe, herald of Coeddil has joined your cause, bringing with her a personal guard of Dryads."
#req_owncapital 1
#req_fornation 151
#nation 151
#com 14840 -- drycha
#req_nomnr 14840
#rarity 5
#req_rare 3 -- 3% chance
#4d3units 14143 -- dryad
#req_turn 8 -- not super early
#req_varzero 301 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 301 -- increments the event variable to 1, which stops this event ever firing again
#header 2
#end


---- SPAWN HERO Orion

#newevent
#msg "The King in the Woods emerges!

On the first day of spring Orion, the Avatar of Kurnous and the King in the Woods, emerged to great joy from the people of Athel Loren. Long had Orion been divided in soul, but with the coming of this unprecedented era he is once more whole. Having gathered his strength for a full month he is ready to lead the Wild Hunt in defence of Athel Loren and to seek out and destroy those who have trespassed against his realm. Should Orion be felled he will rise once more on the first day of spring, and if he lives to see Midwinter will gladly sacrifice himself on the funeral pyre to be restored once more."
#req_owncapital 1
#req_fornation 151
#nation 151
#req_unique 1 -- orion is spring immortal, so this only needs to happen once
#rarity 5
#req_rare 100 -- you always get orion
#req_season 0 -- spring
#com 14312 -- Orion
#req_turn 4 -- not year 1 spring
#header 2
#end


---- kill orion a lot

#newevent
#msg "Orion returns to the funeral Pyre.

With the arrival of Midwinter, Orion willingly turns to the funeral pyre that his sacrifice will maintain the balance of Athel Loren and allow for his triumphant return on the first day of spring."
#req_fornation 151
#nation 151
#rarity 5
#req_rare 100 -- always dies
#req_season 4 -- winter, so mid winter basically
#req_indepok 1
#req_pop0ok
#req_targforeignok
#req_monster 14312
#req_targmnr 14312
#killtarg
#header 2
#end

---- kill orion a lot (forest shape)

#newevent
#msg "Orion returns to the funeral Pyre.

With the arrival of Midwinter, Orion willingly turns to the funeral pyre that his sacrifice will maintain the balance of Athel Loren and allow for his triumphant return in Spring."
#req_fornation 151
#nation 151
#rarity 5
#req_rare 100 -- always dies
#req_season 4 -- winter, so mid winter basically
#req_indepok 1
#req_pop0ok
#req_targforeignok
#req_monster 14313
#req_targmnr 14313
#killtarg
#header 2
#end



------------------------------------------------------------------------
-- Nation
-------------------------------------------------------------------------


#selectnation 151
#name "Athel Loren"
#epithet "Forest of the Asrai"
#brief "The Asrai, or Wood Elves as some call them, are an offshoot of the Elven people of Ulthuan who long ago split from the Elven empire which once spanned the world to shelter in the ancient forest of Athel Loren. Over time they struck a truce and then an alliance with the wild forest spirits and now live in harmony with the World Tree under the leadership of their two divine rulers Orion and Ariel. The Asrai reject both the sneering cruelty of the Dark Elves and the arrogant pride of the High Elves, instead striking a balance of grace and fury with which they protect their mystical home."
#descr "The Asrai, or Wood Elves as some call them, are an offshoot of the Elven people of Ulthuan who long ago split from the Elven empire which once spanned the world to shelter in the ancient forest of Athel Loren. Over time they struck a truce and then an alliance with the wild forest spirits and now live in harmony with the World Tree under the leadership of their two divine rulers Orion and Ariel. The Asrai reject both the sneering cruelty of the Dark Elves and the arrogant pride of the High Elves, instead striking a balance of grace and fury with which they protect their mystical home. Now a time of great change has come upon the world and the Oak of Ages once more spreads life into its many worldroots, calling for the Asrai and forest spirits to liberate the wild lands of the world from the tyranny of the squabbling mortal empires."
#summary "Race: Graceful elves and forest spirits.
Military: Superb archers, skilled infantry, sacred cavalary, and spiteful forest spirits. All troops gain bonuses in forest provinces.
Magic: Strong nature, earth, water, air, glamour, and specialised astral and death casters. Spellsingers can form Chorus communions.
Priests: Average.
Mechanics: Labs and temples are cheaper in forests and more expensive outside. If you order a fort built in a forest you immediately get a Bramble Fort."
#era 2
#color .0 .6 .0 -- Rich green
#flag "Warhammer_Wood_Elves/Wood_Elf_Flag.tga"
#templepic 10 -- foresty temple
#moremagic 1 -- magic +1
#moregrowth 2 -- growth +2

---- Pretenders

#addgod 138 -- gorgon
#addgod 158 -- oracle
#addgod 245 -- master enchanter
#addgod 266 -- green dragon
#addgod 270 -- arch druid
#addgod 485 -- great enchantress
#addgod 606 -- great mother
#addgod 657 -- monolith
#addgod 779 -- rams headed serpent
#addgod 812 -- lord of the wild
#addgod 978 -- great black bull
#addgod 979 -- great white bull
#addgod 1342 -- titaness of rivers
#addgod 1343 -- titaness of love
#addgod 1370 -- volla of forest
#addgod 1378 -- lord of the forest
#addgod 1905 -- great sorceress
#addgod 2234 -- irminsul
#addgod 2239 -- asynja
#addgod 2437 -- annunaki of growth
#addgod 2448 -- idol of beasts
#addgod 2450 -- horned one
#addgod 2784 -- thrice horned boar
#addgod 2785 -- solar eagle
#addgod 3082 -- matrona of the healing spring
#addgod 3203 -- titaness of the hunt
#addgod 3208 -- titaness of the spring
#addgod 3209 -- titaness of growth
#addgod 3641 -- earth dragon
#addgod 3710 -- air dragon


#startsite "Glade of Light"
#startsite "Glade of Shadow"
#startsite "Ancient Glade"

#futuresite 2115
#futuresite 2116
#futuresite 2117
#futuresite 2118

#idealcold 0
#likesterr 128 -- likes to start in a forest

#fortera 0 -- palisades only
#homefort 3 -- this is a castle, standard for middle era
#fortcost 20 -- extra 120 per fort

#labcost 750 -- +150
#templecost 750 -- +150

#foresttemplecost 400 -- -200
#forestlabcost 500 -- -100


-- Troops

#addrecunit 14131 -- Glade Guard
#addrecunit 14133 -- Deepwood Scout
#addrecunit 14155 -- Wildwood Ranger
#addrecunit 14135 -- Eternal Guard
#addrecunit 14159 -- wardancer
#addrecunit 14161 -- waywatcher
--addrecunit 14139 -- Glade Rider
#addrecunit 14140 -- Glade Rider (forest shape)
--addrecunit 14178 -- warhawk rider
#addrecunit 14179 -- warhawk rider (forest shape)
#forestrec 14143 -- dryad
#forestfortrec 14143 -- dryad
#forestrec 14173 -- treekin
#forestfortrec 14173 -- treekin

-- Commanders

--addreccom 13773 -- ariel
#addreccom 14175 -- Deepwood Scout
#addreccom 14137 -- glade captain
#addreccom 14186 -- Warhawk Captain
#addreccom 14153 -- glade lord
--addreccom 14182 -- glade lord on great stag
#addreccom 14578 -- priest of the balance
#addreccom 14157 -- shadowdancer
#addreccom 14167 -- waystalker
#forestcom 14165 -- branchwraith
#forestfortcom 14165 -- branchwraith
#forestcom 14175 -- Deepwood Scout
#addreccom 14163 -- spellsinger
#addreccom 14171 -- highweaver
#addreccom 14169 -- darkweaver
--addreccom 14188 -- Araloth
--addreccom 14198 -- glade lord on great eagle
--addreccom 13734 -- forest dragon


#startcom 14137 -- glade captain
#startunittype1 14131 -- glade guard archer
#startunitnbrs1 10
#startunittype2 14140 -- Glade Rider (forest shape)
#startunitnbrs2 10
#startscout 14175 -- deepwood scout


#multihero4 14192 -- treeman
#multihero1 14182 -- glade lord on great stag
#multihero2 14169 -- darkweaver
#multihero3 14171 -- highweaver
#multihero5 14198 -- glade lord on great eagle


---------- DEFENCES

#wallcom 14137 -- glade captain
#wallunit 14131 -- Glade Guard
#wallmult 10 -- normal

#guardcom 14137 -- glade captain
#guardunit 14131 -- Glade Guard
#guardmult 10

#defcom1 14137 -- glade captain
#defcom2 14165 -- branchwraith

#defunit1 14131 -- Glade Guard
#defmult1 20
#defunit1b 14143 -- dryad
#defmult1b 10

#defunit2 14140 -- Glade Rider (forest shape)
#defmult2 10


#end






-- Khorne


----------- ITEMS

---- sanguine dousing rod

#selectitem 393 -- SDR
#notfornation 170 -- khorne
#end

---- Mark of Rage

#selectitem 941
#name "Mark of Rage"
#descr "This marks a boundless rage, a gift from Khorne that will cause this commander to enter a berserk state as soon as they enter combat."
#spr "Warhammer_Khorne/Item_Rage.tga"
#constlevel 11
#type 8 -- misc
#bers
#nofind
#cursed
#end

---- Skarbrand's Rage

#selectitem 942
#name "Curse of Rage"
#descr "Skarbrand's curse of madness emanates from the towering Bloodthirster in waves of hatred and bloodlust that will eventually drive every living creature into a berserker frenzy.

[Every round autocasts a MR resists berserk effect that hits half the battlefield]"
#spr "Warhammer_Khorne/Item_Skar.tga"
#constlevel 11
#type 8 -- misc
#autospell "Wave of Rage"
#autospellrepeat 1
#bers
#nofind
#cursed
#end

---- Mark of Blood

#selectitem 1000
#name "Mark of Blood"
#descr "This marks an affinity for blood, a gift from Khorne that will cause nearby enemies to bleed and nearby allies to be invigorated."
#spr "Warhammer_Khorne/Item_Blood.tga"
#constlevel 11
#type 8 -- misc
#autospell "Bloodbath"
#autospellrepeat 1
#nofind
#cursed
#end


-------- Weapons

-- Brass Axe

#newweapon 1909
#copyweapon 675 -- bronze axe
#name "Brass Axe"
#magic
#end

-- Ripping Blade

#newweapon 1200
#copyweapon 750 -- bronze falchion
#name "Ripping Blade"
#att 1
#def 1
#magic
#end

-- Brass Axe

#newweapon 1201
#copyweapon 675 -- bronze axe
#name "Tearing Axe"
#att 2
#def 1
#len 1
#magic
#end

-- Burning Brass Axe (bloodthirster, daemon prince)

#newweapon 1212
#copyweapon 675 -- bronze axe
#name "Burning Brass Axe"
#att 2
#def 1
#len 2
#magic
#dmg 9
#nratt 2
#secondaryeffect 221 -- fire 12 dmg
#end


-- Flaming Skull Flail (daemon prince)

#newweapon 1213
#copyweapon 12 -- mace
#name "Flaming Skull Flail"
#att 2
#def 0
#len 2
#magic
#flail
#dmg 8
#secondaryeffectalways 171 -- small area fire
#end



-- Spiked Whiplash

#newweapon 1179
#name "Spiked Whiplash"
#flail
#bonus
#dmg 3
#len 2 -- long enough I reckon
#slash
#pierce
#end


-- Hellblade

#newweapon 1198
#copyweapon 11 -- great sword
#name "Hellblade"
#magic
#dt_weapondrain -- partial life drain
#end

-- Slayer Sword

#newweapon 1203
#copyweapon 472 -- flame sword
#name "Slayer Sword"
#att 2 -- -1
#dmg 10 -- -2
#armorpiercing
#dt_weapondrain -- partial life drain
#secondaryeffect 221 -- fire
#end

-- Claw, magic

#newweapon 1199
#copyweapon 236 -- claw
#magic
#end

-- Brass Forgehammer

#newweapon 1214
#copyweapon 14 -- maul
#name "Brass Forgehammer"
#att 1
#def 0
#magic
#secondaryeffectalways 216 -- fire 8 dmg
#rcost 15
#end

-- Slaughteraxe

#newweapon 1215
#copyweapon 18 -- battleaxe
#name "Slaughteraxe"
#att 1
#def 0
#magic
#dt_weapondrain -- partial life drain
#end

-- Hellwhip

#newweapon 1216
#name "Hellwhip"
#dmg 0
#att 1
#def 0
#len 5
#nratt 2
#slash
#sound 9 -- whip
#secondaryeffectalways 171 -- small area fire
#magic
#end


-- Carnage (skarbrands sword)

#newweapon 1223
#copyweapon 80 -- fire brand
#name "Carnage"
#len 2
#nratt 1
#bonus
#end


-- Destroyer Axe

#newweapon 1299
#copyweapon 75 -- enchanted sword
#name "Destroyer Axe"
#att 2
#def 1
#dmg 11
#nratt 2
#secondaryeffect 384 -- minor drain
#end


------- ARMOR

---- Brass mask

#newarmor 306
#copyarmor 118 -- full helmet of ulm
#name "Brass Mask"
#prot 14
#rcost 3
#end


---- Plate barding but it's magical, for juggernauts

#newarmor 323
#copyarmor 254 -- plate barding
#name "Daemonic Plate Barding"
#prot 17
#magicarmor
#end


-------- Monsters

---- Marauder Template

#newmonster 16200
#spr1 "Warhammer_Khorne/Marauder_Axe.tga"
#spr2 "Warhammer_Khorne/Marauder_Axe2.tga"
#name "Marauder"
#descr "descr."
#hp 12 --- big tough guys
#size 3 --- normal
#prot 2
#mor 12
#mr 11 --- +1 for khorne
#enc 3 --- normal
#str 13 -- +1 for khorne
#att 12 --- WS4 I4
#def 11 --- WS4 I4
#prec 10
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 12
#rpcost 7 -- normal -2 because of turmoil incentives
#rcost 2
#ambidextrous 2
#fireres 5
#snow
#wastesurvival
#pillagebonus 1
#nametype 131 -- EA Ulm male
#ressize 2
#end


---- Warrior Template

#newmonster 16199
#spr1 "Warhammer_Khorne/Warrior_Shield.tga"
#spr2 "Warhammer_Khorne/Warrior_Shield2.tga"
#name "Chaos Warrior"
#descr "descr."
#hp 15 --- chaos warrior base hp
#size 3 --- normal
#prot 2 -- T4
#mor 14 -- 14 base for chaos warrior
#mr 13 --- 12 base for chaos warrior, +1 for Khorne
#enc 2 --- -1
#str 14 -- +1 and another because Khorne
#att 14 --- WS5, 2 attacks, +1 for being Khorne
#def 11 --- WS5
#prec 10
#mapmove 18 -- tireless marchers
#ap 14 --- +2 over human
#gcost 30
#rpcost 16
#rcost 8 -- khorne warriors +7 over slaanesh
#ambidextrous 2
#fireres 5
#snow
#wastesurvival
#neednoteat
#nametype 298 -- Khorne warrior names
#startage 60
#maxage 300
#end


--------- Recruits


---- Recruitable Chaos Warhound

#newmonster 16201
#spr1 "Warhammer_Khorne/War_Hound.tga"
#spr2 "Warhammer_Khorne/War_Hound2.tga"
#name "Chaos Warhound"
#descr "Marauder tribes make extensive use of large hounds to track and hunt beasts, warn them of dangers, or run down tired and fleeing foes. The largest and most ferocious of these are taken into battle to be unleashed on the enemy lines, a snarling wave of muscle, tooth, and claw. Chaos Warhounds often sport mutations and those that have been touched by the influence of Chaos tend to be even more dangerous, making them prized possessions for Marauder Chieftains.

[When recruited you may get a mutated Chaos Hound with some advantages over the basic version]
[Recruitment limited to 10 per month]"
#cleararmor
#clearweapons
#gcost 7
#hp 12
#size 3
#prot 4 -- tough!
#mor 10 -- aggresive
#mr 8
#enc 2
#str 13
#att 12
#def 11
#prec 7
#mapmove 22 -- same as wolf
#ap 20
#rpcost 2 -- same as war dog of Ulm
#rcost 1
#weapon 20 -- normal bite
#forestsurvival
#wastesurvival
#snow
#animal
#undisciplined
#reclimit 10 -- mainly to stop the ai going crazy building them
#fireres 5
#firstshape -1041 -- hound montag
#siegebonus -1
#end


---- Basic Chaos Warhound

#newmonster 16213
#spr1 "Warhammer_Khorne/War_Hound.tga"
#spr2 "Warhammer_Khorne/War_Hound2.tga"
#name "Chaos Warhound"
#descr "Marauder tribes make extensive use of large hounds to track and hunt beasts, warn them of dangers, or run down tired and fleeing foes. The largest and most ferocious of these are taken into battle to be unleashed on the enemy lines, a snarling wave of muscle, tooth, and claw. Chaos Warhounds often sport mutations and those that have been touched by the influence of Chaos tend to be even more dangerous, making them prized possessions for Marauder Chieftains.

[When recruited you may get a mutated Chaos Hound with some advantages over the basic version]
[Recruitment limited to 10 per month]"
#cleararmor
#clearweapons
#gcost 7
#hp 12
#size 3
#prot 4 -- tough!
#mor 10 -- aggresive
#mr 8
#enc 2
#str 13
#att 12
#def 11
#prec 7
#mapmove 22 -- same as wolf
#ap 20
#rpcost 2 -- same as war dog of Ulm
#rcost 1
#weapon 20 -- normal bite
#forestsurvival
#wastesurvival
#snow
#animal
#undisciplined
#reclimit 10 -- mainly to stop the ai going crazy building them
#fireres 5
#montag 1041 -- hound montag
#montagweight 6 -- so 6/9 dogs will be non mutated
#siegebonus -1
#end


---- Sail and poison Chaos Warhound

#newmonster 16211
#spr1 "Warhammer_Khorne/War_Hound_Sail.tga"
#spr2 "Warhammer_Khorne/War_Hound_Sail2.tga"
#name "Chaos Mutant Warhound"
#descr "Marauder tribes make extensive use of large hounds to track and hunt beasts, warn them of dangers, or run down tired and fleeing foes. The largest and most ferocious of these are taken into battle to be unleashed on the enemy lines, a snarling wave of muscle, tooth, and claw. Chaos Warhounds often sport mutations and those that have been touched by the influence of Chaos tend to be even more dangerous, making them prized possessions for Marauder Chieftains.

[When recruited you may get a mutated Chaos Hound with some advantages over the basic version]"
#cleararmor
#clearweapons
#gcost 7
#hp 14 -- +2
#size 3
#prot 5 -- +1
#mor 13 -- +3
#mr 11 -- +3 sail
#enc 2
#str 14 -- +1
#att 12
#def 11
#prec 5 -- -2
#mapmove 22
#ap 20
#rpcost 2
#rcost 1
#weapon 223 -- venomous bite
#fireres 7 -- sail
#forestsurvival
#wastesurvival
#snow
#animal
#undisciplined
#montag 1041 -- hound montag
#siegebonus -1
#end


---- Spiked tail Chaos Warhound

#newmonster 16212
#spr1 "Warhammer_Khorne/War_Hound_Tail.tga"
#spr2 "Warhammer_Khorne/War_Hound_Tail2.tga"
#name "Chaos Mutant Warhound"
#descr "Marauder tribes make extensive use of large hounds to track and hunt beasts, warn them of dangers, or run down tired and fleeing foes. The largest and most ferocious of these are taken into battle to be unleashed on the enemy lines, a snarling wave of muscle, tooth, and claw. Chaos Warhounds often sport mutations and those that have been touched by the influence of Chaos tend to be even more dangerous, making them prized possessions for Marauder Chieftains.

[When recruited you may get a mutated Chaos Hound with some advantages over the basic version]"
#cleararmor
#clearweapons
#gcost 7
#hp 14 -- +2
#size 3
#prot 5 -- +1
#mor 12 -- +2
#mr 9 -- +1
#enc 2
#str 13
#att 12
#def 12 -- +1
#prec 7
#mapmove 22
#ap 20
#rpcost 2
#rcost 1
#weapon 20 -- normal bite
#weapon 1179 -- spiked whiplash
#forestsurvival
#wastesurvival
#snow
#animal
#undisciplined
#fireres 5
#montag 1041 -- hound montag
#siegebonus -1
#end



---- Recruitable Marauder

#newmonster 16204
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Axe.tga"
#spr2 "Warhammer_Khorne/Marauder_Axe2.tga"
#name "Marauder"
#descr "The tribes of humans who flock to join the banner of Chaos incursions are collectively known as Marauders and though they hail from many distinct cultures they all recognise and worship the Ruinous Powers. Typically Khorne is depicted as a ferocious Hound with burning eyes whose snarling bark drives men to violence, rage, and the pursuit of greater glory and so the tribal warriors who follow the Blood God are known as the Marauders of the Hound. Marauders are to the warriors of other human realms as great wolves are to dogs; they are hardened by lives of struggle and violence and devoted to battle with no thought of retiring in comfort or returning home to farm or ply a trade. Marauders are physically larger and stronger than typical humans and some bear mutations brought about by proximity to the Chaos Wastes or the briefest flickers of attention from Khorne's baleful stare.

[When recruited you will either get a marauder with axe and shield, broad sword and shield, axe and throwing axes, or occasionally a Forsaken Marauder]"
#weapon 17 -- axe
#armor 21 -- full helmet
#armor 11 -- ring mail hauberk
#armor 2 -- shield
#firstshape -1042 -- marauders
#end


---- Forsaken Marauder

#newmonster 16233
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Forsaken_Marauder.tga"
#spr2 "Warhammer_Khorne/Forsaken_Marauder2.tga"
#name "Forsaken Marauder"
#descr "While only Warriors, Sorcerers, and Champions of Chaos can truly hope to draw the eye of one of the Ruinous Powers, all manner of other men and beasts are subject to the warping taint of Chaos through proximity alone. Many of the men and women of the countless Marauder tribes are born with mutations, reminders of the constant presence of their Gods. These mutants are not ostracised or culled as they might be in the weak realms of civilised men but are instead treated with respect and honour. Those with the extreme mutations typically do not survive to adulthood but some join the marauders and unleash the blessing of their altered form upon the foe in a frenzied headlong rush. They are known as the Forsaken amongst the ranks of the Warriors, but to the Marauders they are a venerated elite that demonstrate the favour of the Gods."
#weapon 17 -- axe
#weapon 29 -- claw
#armor 11 -- ring mail hauberk
#hp 14 --- +2
#prot 2
#mor 14 -- +2
#mr 12 --- +1
#str 14 -- +1
#berserk 2 -- +1 because Khorne
#ap 14 -- +2
#prec 9 -- -1
#montag 1042 -- marauders
#end


---- Marauder Hunter

#newmonster 16203
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Hunter.tga"
#spr2 "Warhammer_Khorne/Marauder_Hunter2.tga"
#name "Marauder Hunter"
#descr "Not all of the Marauders who accompany Chaos raiding parties are strictly warriors, dedicated to slaughter and battle. Some are hunters who serve a vital function to their tribe in bringing down the beasts that roam the lands around the Chaos Wastes for food, trophies, or simply to ensure the safety of their people. These hunters accompany raiding parties to help provide supplies and to lend their impressive skill with javelins to the host. They are still Marauders are still capable fighters in melee, though they lack some of the fearsome resolve of their companions."
#prec 11 -- +1 for ranged focus
#weapon 1 -- spear
#weapon 1085 -- javelin bundle (x4 javs)
#armor 119 -- reinforced leather cap
#armor 6 -- ring mail cuirass
#supplybonus 1 -- they are hunters after all
#mor 11 -- -1
#end

---- Marauder (axe and shield)

#newmonster 16207
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Axe.tga"
#spr2 "Warhammer_Khorne/Marauder_Axe2.tga"
#name "Marauder"
#descr "The tribes of humans who flock to join the banner of Chaos incursions are collectively known as Marauders and though they hail from many distinct cultures they all recognise and worship the Ruinous Powers. Typically Khorne is depicted as a ferocious Hound with burning eyes whose snarling bark drives men to violence, rage, and the pursuit of greater glory and so the tribal warriors who follow the Blood God are known as the Marauders of the Hound. Marauders are to the warriors of other human realms as great wolves are to dogs; they are hardened by lives of struggle and violence and devoted to battle with no thought of retiring in comfort or returning home to farm or ply a trade. Marauders are physically larger and stronger than typical humans and some bear mutations brought about by proximity to the Chaos Wastes or the briefest flickers of attention from Khorne's baleful stare."
#weapon 17 -- axe
#armor 21 -- full helmet
#armor 11 -- ring mail hauberk
#armor 2 -- shield
#montag 1042 -- marauders
#montagweight 2
#end

---- Marauder (sword)

#newmonster 16208
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Sword.tga"
#spr2 "Warhammer_Khorne/Marauder_Sword2.tga"
#name "Marauder"
#descr "The tribes of humans who flock to join the banner of Chaos incursions are collectively known as Marauders and though they hail from many distinct cultures they all recognise and worship the Ruinous Powers. Typically Khorne is depicted as a ferocious Hound with burning eyes whose snarling bark drives men to violence, rage, and the pursuit of greater glory and so the tribal warriors who follow the Blood God are known as the Marauders of the Hound. Marauders are to the warriors of other human realms as great wolves are to dogs; they are hardened by lives of struggle and violence and devoted to battle with no thought of retiring in comfort or returning home to farm or ply a trade. Marauders are physically larger and stronger than typical humans and some bear mutations brought about by proximity to the Chaos Wastes or the briefest flickers of attention from Khorne's baleful stare."
#weapon 8 -- broad sword
#armor 119 -- reinforced leather cap
#armor 12 -- scale mail hauberk
#armor 2 -- shield
#montag 1042 -- marauders
#montagweight 2
#end

---- Marauder (throwing axes)

#newmonster 16209
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Axes.tga"
#spr2 "Warhammer_Khorne/Marauder_Axes2.tga"
#name "Marauder"
#descr "The tribes of humans who flock to join the banner of Chaos incursions are collectively known as Marauders and though they hail from many distinct cultures they all recognise and worship the Ruinous Powers. Typically Khorne is depicted as a ferocious Hound with burning eyes whose snarling bark drives men to violence, rage, and the pursuit of greater glory and so the tribal warriors who follow the Blood God are known as the Marauders of the Hound. Marauders are to the warriors of other human realms as great wolves are to dogs; they are hardened by lives of struggle and violence and devoted to battle with no thought of retiring in comfort or returning home to farm or ply a trade. Marauders are physically larger and stronger than typical humans and some bear mutations brought about by proximity to the Chaos Wastes or the briefest flickers of attention from Khorne's baleful stare."
#weapon 253 -- hatchet
#weapon 253 -- hatchet
#weapon 260 -- throwing axe
#armor 118 -- half helmet
#armor 11 -- ring mail hauberk
#montag 1042 -- marauders
#montagweight 2
#ambidextrous 2
#end

---- Berserker

#newmonster 16210
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Berserker.tga"
#spr2 "Warhammer_Khorne/Marauder_Berserker2.tga"
#name "Marauder Berserker"
#descr "Berserkers are elite infantry within the ranks of the Marauder tribes whose job is to shatter the enemy line or dispatch the strongest foes. Like all Marauders, they are unrelenting combatants who habitually take what their own lands cannot provide from lesser men, but are set apart by their heedless embrace of death in battle and ability to enter a frenzied killing trance. Berserkers favour the use of an axe in each hand and train extensively to build their physical strength to a level similar to that of the mighty Chaos Warriors. The Berserkers of the tribes that worship Khorne in his guise as the Hound are particularly unrelenting and brutal warriors."
#hp 14 --- +2
#prot 2
#mor 13 -- +1
#mr 11 --- +1
#str 13 -- +1
#gcost 18
#rpcost 12 --- +5
#rcost 3 -- +1
#weapon 17 -- axe
#weapon 17 -- axe
#armor 21 -- full helmet
#armor 11 -- ring mail hauberk
#berserk 4 -- +1 over other berserkers
#end


-----Marauder Horse (light jav horseman)

#newmonster 14391
#copystats 3574 -- armored steppe horse
#spr1 "Warhammer_Khorne/Marauder_Horseman_Jav_Mount.tga"
#spr2 "Warhammer_Khorne/Marauder_Horseman_Jav_Mount2.tga"
#name "Marauder Horse"
#descr "The horses ridden by Chaos Marauders are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos. Unlike most horses there is a chance they will continue to fight even if their rider is slain, such is their aggressive nature."
#gcost 10
#prot 4 -- +1 for hardiness
#armor 251 -- light leather barding
#armor 20 -- iron cap
#snow
#fireres 5
#mor 10 -- +1
#mr 7 -- +2
#hp 22 -- +2
#bravemount 25
#att 11 -- +1
#wastesurvival
#end


---- Marauder Horseman

#newmonster 16234
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Horseman_Jav.tga"
#spr2 "Warhammer_Khorne/Marauder_Horseman_Jav2.tga"
#name "Marauder Light Horseman"
#descr "Marauder Horsemen are the outriders and scouts of Chaos Warhosts and smaller Marauder raids alike, ranging ahead to harass, pillage, and demoralise the enemy. Like all Marauders they are hardened fighters who place little value on the lives of those beyond their tribe and they have gained a fearsome reputation amongst the civilised realms of men as harbingers of terrible suffering and destruction. The steeds they ride are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos and paired with their skilled riders, many of whom have lived in the saddle virtually their entire lives, they make excellent light cavalry. Light Horsemen in the tribes that worship Khorne in the guise of the Hound refuse to use shields but wear heavier armour than usual."
#weapon 357 -- light lance
#weapon 21 -- javelin
#armor 119 -- reinforced leather cap
#armor 11 -- ring mail hauberk
#gcost 15 -- (25)
#pillagebonus 2
#skilledrider 2
#mobilearcher 1
#mountmnr 14391
#unmountedspr1 "Warhammer_Khorne/Marauder_Horseman_Jav_Unmounted.tga"
#unmountedspr2 "Warhammer_Khorne/Marauder_Horseman_Jav_Unmounted2.tga"
#end

-----Marauder Horse (axes)

#newmonster 14392
#copystats 14391 -- marauder horse
#spr1 "Warhammer_Khorne/Marauder_Horseman_Axe_Mount.tga"
#spr2 "Warhammer_Khorne/Marauder_Horseman_Axe_Mount2.tga"
#name "Marauder Horse"
#descr "The horses ridden by Chaos Marauders are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos. Unlike most horses there is a chance they will continue to fight even if their rider is slain, such is their aggressive nature."
#end


---- Marauder Horseman (axe, throwing axes)

#newmonster 16235
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Horseman_Axe.tga"
#spr2 "Warhammer_Khorne/Marauder_Horseman_Axe2.tga"
#name "Marauder Horseman"
#descr "Marauder Horsemen are the outriders and scouts of Chaos Warhosts and smaller Marauder raids alike, ranging ahead to harass, pillage, and demoralise the enemy. Like all Marauders they are hardened fighters who place little value on the lives of those beyond their tribe and they have gained a fearsome reputation amongst the civilised realms of men as harbingers of terrible suffering and destruction. The steeds they ride are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos and paired with their skilled riders, many of whom have lived in the saddle virtually their entire lives, they make excellent light cavalry. Horsemen in the tribes that worship Khorne in the guise of the Hound are well armed with axe, shield, and heavy throwing axes that they skillfully hurl before charging into the fray."
#weapon 17 -- axe
#weapon 260 -- throwing axe
#armor 118 -- half helmet
#armor 11 -- ring mail hauberk
#armor 2 -- shield
#gcost 15 -- (25)
#pillagebonus 2
#skilledrider 2
#mobilearcher 1
#mountmnr 14392
#unmountedspr1 "Warhammer_Khorne/Marauder_Horseman_Jav_Unmounted.tga"
#unmountedspr2 "Warhammer_Khorne/Marauder_Horseman_Jav_Unmounted2.tga"
#end


---- Warrior of Khorne (recruitment)

#newmonster 13997
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Warrior_Shield.tga"
#spr2 "Warhammer_Khorne/Warrior_Shield2.tga"
#name "Chaos Warrior"
#descr "Chaos Warriors are fighters of near unmatched prowess, possessing superhuman strength and durability combined with skills honed in countless battles and arms and armour forged in infernal fire. When a man joins the marauders and pledges his soul to Chaos he chooses a lifetime of bloody struggle with the promise of earthly reward, yet those who embark on the path of the Chaos Warrior cast aside such pursuits to seek greater truths and perhaps the chance of true immortality as near tireless killing machines. Warriors dedicated to Khorne are known for their brutality and offensive prowess in battle and are perhaps the most dangerous of all their kind. While in combat they are a strange mix of cold discipline and boiling rage, but their professionalism and dedication to martial matters are unquestionable, for Khorne has none of the indulgent traits or Slaanesh or Nurgle. Those Warriors who acheive great deeds in battle will attract the attention of Khorne and may become Chosen in the eyes of the Blood God, though Khorne is an exacting master and may also find them lacking and curse them to become Forsaken or even Chaos Spawn.

[When recruited you will either get a Warrior with axe and shield or with a battleaxe]
[When this unit is promoted it will lose all XP and transform into either a Chosen, a Forsaken, or a Chaos Spawn]"
#weapon 17 -- axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#xpshape 45
#firstshape -1039
#end



---- Warrior of Khorne (axe and shield)

#newmonster 16205
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Warrior_Shield.tga"
#spr2 "Warhammer_Khorne/Warrior_Shield2.tga"
#name "Chaos Warrior"
#descr "Chaos Warriors are fighters of near unmatched prowess, possessing superhuman strength and durability combined with skills honed in countless battles and arms and armour forged in infernal fire. When a man joins the marauders and pledges his soul to Chaos he chooses a lifetime of bloody struggle with the promise of earthly reward, yet those who embark on the path of the Chaos Warrior cast aside such pursuits to seek greater truths and perhaps the chance of true immortality as near tireless killing machines. Warriors dedicated to Khorne are known for their brutality and offensive prowess in battle and are perhaps the most dangerous of all their kind. While in combat they are a strange mix of cold discipline and boiling rage, but their professionalism and dedication to martial matters are unquestionable, for Khorne has none of the indulgent traits or Slaanesh or Nurgle. Those Warriors who acheive great deeds in battle will attract the attention of Khorne and may become Chosen in the eyes of the Blood God, though Khorne is an exacting master and may also find them lacking and curse them to become Forsaken or even Chaos Spawn.

[When this unit is promoted it will lose all XP and transform into either a Chosen, a Forsaken, or a Chaos Spawn]"
#weapon 17 -- axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#xpshape 45
#montag 1039
#xpshapeloss 100
#xpshapemon -1040 -- chosen or forsaken or spawn
#end


---- Chosen of Khorne

#newmonster 16217
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Chosen_Warrior.tga"
#spr2 "Warhammer_Khorne/Chosen_Warrior2.tga"
#name "Chosen Warrior"
#descr "There are those amognst the ranks of the Chaos Warriors who bear the clear favour of Khorne and have been elevated as the Chosen of the Blood God and granted even greater physical prowess and skill. The Chosen are savage and terrible to behold, their armoured festooned with gleaming Daemonic brass and skull trophies taken from particularly satisfying kills, their howling fury fully unleashed as they butcher ranks of foes in exultation of their master. While the Warriors of Khorne temper their rage with discipline even in battle, the Chosen are true berserkers who give their lives wholly to the expression of rage and bloodlust. It is said that the Chosen of Khorne will fight on despite horrendous wounds and in the face of impossible odds, for even should their sheer fury falter somehow, they would never willingly dishonour Khorne by taking a backward step. The Chosen have reached the end of their path, never destined to rise toward the ultimate goal of Daemonhood, but their souls will surely receive lavish attention from Khorne in death just as they have in life. The Chosen are sacred to the followers of the Blood God.

[Requires friendly Dominion strength of 4 in the province to recruit]"
#weapon 17 -- axe
#weapon 17 -- axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#mor 15 -- +1
#mr 14 -- +1
#str 14 -- +1
#att 15 --- +1
#def 13 --- +1
#gcost 60
#holy
#montag 1040 -- chosen and forsaken and spawn
#montagweight 20
#domrec 4
#berserk 2
#rcost 12 -- because axes are very cheap
#startage 80
#maxage 400
#rpcost 20
#end


---- Forsaken Warrior of Khorne

#newmonster 16218
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Warrior_Forsaken.tga"
#spr2 "Warhammer_Khorne/Warrior_Forsaken2.tga"
#name "Forsaken Warrior"
#descr "The Ruinous Powers are as fickle as they are implacable and even the iron-willed Khorne is prone to lash out in rage should a servant fail to meet their standards. In striving to prove themselves and draw the attention of the Blood God the Chaos Warriors of Khorne are always at risk of falling short in the eyes of their patron and failing to join the ranks of the Chosen, instead becoming either Forsaken or turned into a Chaos Spawn. The Forsaken are those unfortunates who have been changed by the brutal grip of Khorne and thrown aside, no longer proud Chaos Warriors but berserk mutants eager to find death in battle, for unlike Chaos Spawn they are entirely aware of their own fallen condition. Forsaken are not the disciplined and well armoured heavy infantry or cavalry they once were, instead they are whirling, malformed shock troops typically thrown to the frontlines to inflict as much damage as possible before they are cut down. To the Chaos Warriors they are a reminder of the risks of their path and the price of failure, but to the massed Marauders they are considered equals of the Warriors who simply bear the blessings of the Blood God in a different fashion."
#weapon 17 -- axe
#weapon 29 -- claw
#armor 9 -- plate cuirass
#hp 17 --- +2
#mor 16 -- +2
#att 12 -- -2
#def 10 -- -2
#str 12 -- -1
#gcost 20
#ambidextrous 2
#fireres 5
#snow
#wastesurvival
#neednoteat
#berserk 3 -- +2 over normal because Khorne
#montag 1040 -- chosen and forsaken and spawn
#montagweight 10
#end


---- Forsaken Warrior of Khorne

#newmonster 16240
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Warrior_Forsaken.tga"
#spr2 "Warhammer_Khorne/Warrior_Forsaken2.tga"
#name "Forsaken Warrior"
#descr "The Ruinous Powers are as fickle as they are implacable and even the iron-willed Khorne is prone to lash out in rage should a servant fail to meet their standards. In striving to prove themselves and draw the attention of the Blood God the Chaos Warriors of Khorne are always at risk of falling short in the eyes of their patron and failing to join the ranks of the Chosen, instead becoming either Forsaken or turned into a Chaos Spawn. The Forsaken are those unfortunates who have been changed by the brutal grip of Khorne and thrown aside, no longer proud Chaos Warriors but berserk mutants eager to find death in battle, for unlike Chaos Spawn they are entirely aware of their own fallen condition. Forsaken are not the disciplined and well armoured heavy infantry or cavalry they once were, instead they are whirling, malformed shock troops typically thrown to the frontlines to inflict as much damage as possible before they are cut down. To the Chaos Warriors they are a reminder of the risks of their path and the price of failure, but to the massed Marauders they are considered equals of the Warriors who simply bear the blessings of the Blood God in a different fashion."
#weapon 17 -- axe
#weapon 29 -- claw
#armor 9 -- plate cuirass
#hp 17 --- +2
#mor 16 -- +2
#att 12 -- -2
#def 10 -- -2
#str 12 -- -1
#gcost 20
#ambidextrous 2
#fireres 5
#snow
#wastesurvival
#neednoteat
#berserk 3 -- +2 over normal because Khorne
#montag 1044 -- chosen knight, forsaken, spawns
#montagweight 10
#firstshape 16218 -- because then they have the same id for selecting
#end


---- Warrior of Khorne (battleaxe)

#newmonster 16225
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Warrior_Battleaxe.tga"
#spr2 "Warhammer_Khorne/Warrior_Battleaxe2.tga"
#name "Chaos Warrior"
#descr "Chaos Warriors are fighters of near unmatched prowess, possessing superhuman strength and durability combined with skills honed in countless battles and arms and armour forged in infernal fire. When a man joins the marauders and pledges his soul to Chaos he chooses a lifetime of bloody struggle with the promise of earthly reward, yet those who embark on the path of the Chaos Warrior cast aside such pursuits to seek greater truths and perhaps the chance of true immortality as near tireless killing machines. Warriors dedicated to Khorne are known for their brutality and offensive prowess in battle and are perhaps the most dangerous of all their kind. While in combat they are a strange mix of cold discipline and boiling rage, but their professionalism and dedication to martial matters are unquestionable, for Khorne has none of the indulgent traits or Slaanesh or Nurgle. Those Warriors who acheive great deeds in battle will attract the attention of Khorne and may become Chosen in the eyes of the Blood God, though Khorne is an exacting master and may also find them lacking and curse them to become Forsaken or even Chaos Spawn.

[When this unit is promoted it will lose all XP and transform into either a Chosen, a Forsaken, or a Chaos Spawn]"
#weapon 18 -- battleaxe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#xpshape 45
#montag 1039
#xpshapeloss 100
#xpshapemon -1040 -- chosen or forsaken or spawn
#end


-----Chaos Steed (knight)

#newmonster 14394
#copystats 3897 -- destrier from marignon
#spr1 "Warhammer_Khorne/Knight_Mount.tga"
#spr2 "Warhammer_Khorne/Knight_Mount2.tga"
#name "Chaos Steed"
#descr "Chaos Steeds are to the warhorses of the realms of men what Chaos Warriors are to their soldiers; these beasts are larger, stronger, and more vicious than any normal horse. Unlike most horses there is a good chance they will continue to fight even if their rider is slain, such is their aggressive nature."
#gcost 25
#prot 5 -- +1 for hardiness
#armor 254 -- plate barding
#snow
#fireres 5
#mor 12 -- +1
#mr 9 -- +4
#hp 25 -- +5
#bravemount 50
#att 11 -- +1
#str 16 -- +1
#att 12 -- +1
#def 11 -- +1
#maxage 50 -- +30
#ap 25 -- +2
#mapmove 22 -- +2
#wastesurvival
#end


---- Knight of Khorne

#newmonster 16214
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Knight.tga"
#spr2 "Warhammer_Khorne/Knight2.tga"
#name "Chaos Knight"
#descr "Chaos Knights have a fearsome reputation as heralds of doom across the Old World, for the pairing of a mighty Chaos Warrior with a towering Chaos Steed makes for near unstoppable heavy cavalry. Chaos Steeds are to the warhorses of the realms of men what Chaos Warriors are to their soldiers; these beasts are larger, stronger, and more vicious than any normal horse. Chaos Knights are famously arrogant and tend to stay away from the rest of the warhost, considering even Chaos Warriors beneath them, though they are as eager to answer the call to do battle for the glory of their God as any follower of Khorne. Just like Warriors, the Knights have embarked on a path towards a fate as either a Chosen of Khorne, a Forsaken stripped of their steed and status, or a foul Chaos Spawn.

[When this unit is promoted it will lose all XP and transform into either a Chosen Knight, a Forsaken, or a Chaos Spawn]"
#weapon 4 -- lance
#weapon 17 -- axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#xpshape 55 -- +10 over normal because the chosen knight is so good
#xpshapeloss 100
#xpshapemon -1044 -- chosen knight or forsaken or spawn montag
#gcost 55 -- (80)
#skilledrider 2
#mountmnr 14394
#unmountedspr1 "Warhammer_Khorne/Knight_Unmounted.tga"
#unmountedspr2 "Warhammer_Khorne/Knight_Unmounted2.tga"
#end



---- Chosen Knight of Khorne

#newmonster 16239
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Chosen_Knight.tga"
#spr2 "Warhammer_Khorne/Chosen_Knight2.tga"
#name "Chosen Knight"
#descr "As with Warriors, Chaos Knights strive to gain the favour of their patron God and become Chosen, the pinnacle of the Path of the Warrior. The Chosen Knights of Khorne, in particular, are perhaps the most deadly heavy cavalry in existence, for they ride not mighty Chaos Steeds but instead near unstoppable Daemonic mounts known as Juggernauts. These mounts are hellish beasts clad in daemonic brass and iron and are capable of crushing, tearing, and obliterating almost anything in their path. Should the rider be slain the Juggernaut will fight on for the rest of the battle before returning to the Realm of Khorne. Being Chosen of Khorne they are sacred to the followers of the Blood God.

[Requires friendly Dominion strength of 6+ in the province to recruit]"
#weapon 4 -- lance
#weapon 17 -- axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#prot 3 -- +1
#hp 17 --- +2
#rpcost 34
#mor 15 -- +1
#mr 15 -- +2
#str 14 -- +1
#att 15 --- +1
#def 13 --- +1
#berserk 2
#gcost 125
#holy
#montag 1044 -- forsaken, chosen knight, spawns
#montagweight 20
#domrec 6
#skilledrider 2
#mountmnr 16232 -- juggernaut
#unmountedspr1 "Warhammer_Khorne/Chosen_Knight_Unmounted.tga"
#unmountedspr2 "Warhammer_Khorne/Chosen_Knight_Unmounted2.tga"
#holycost 2
#startage 80
#maxage 400
#end


---- Juggernaut (one used by chaos chosen knight)

#newmonster 16232
#spr1 "Warhammer_Khorne/Daemon_Juggernaut.tga"
#spr2 "Warhammer_Khorne/Daemon_Juggernaut2.tga"
#name "Juggernaut of Khorne"
#descr "Juggernauts of Khorne are hellish beasts clad in daemonic brass and iron that resemble some hybrid of bull, rhinocerous, and hound. Their headlong charges are notoriously difficult to stop and many elite regiments have been broken by a handful of these Daemons crashing into their lines. They are rarely encountered alone, instead being the preferred steeds of Chosen Knights, Chaos Lords, and Bloodletter Daemons. As with all Daemons of Chaos these hellish creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Should this Juggernaut lose its rider it will return to the Realm of Khorne once the battle is concluded."
#ap 20
#mapmove 18
#hp 32
#prot 7 -- I pushed their invuln up above this
#size 6 -- bigger than horse
#str 20 --
#enc 3 -- daemon
#att 12 -- WS5 I2
#def 10 -- WS5 I2
#prec 8
#mr 13 -- khorne daemon
#armor 323 -- magic plate barding
#mor 30
#gcost 0
#rcost 16 -- big metal boi
#rpcost 24
#weapon 334 -- magical gore from the horned helm
#weapon 725 -- brass hoof
#startage 20
#maxage 10000
#poisonres 10
#fireres 7 -- juggernaut
#demon
#animal
#neednoteat
#darkvision 100
--quadruped
#snow
#bravemount 100
#berserk 2
#undisciplined
#trample
#holy
#wastesurvival
#heal --- recuperation ability
#notdomshape 13844
#end



---- Juggernaut (one used by chaos chosen knight - out of dominion)

#newmonster 13844
#spr1 "Warhammer_Khorne/Daemon_Juggernaut.tga"
#spr2 "Warhammer_Khorne/Daemon_Juggernaut2.tga"
#name "Juggernaut of Khorne"
#descr "Juggernauts of Khorne are hellish beasts clad in daemonic brass and iron that resemble some hybrid of bull, rhinocerous, and hound. Their headlong charges are notoriously difficult to stop and many elite regiments have been broken by a handful of these Daemons crashing into their lines. They are rarely encountered alone, instead being the preferred steeds of Chosen Knights, Chaos Lords, and Bloodletter Daemons. As with all Daemons of Chaos these hellish creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Should this Juggernaut lose its rider it will return to the Realm of Khorne once the battle is concluded.

[This Juggernaut is outside of friendly Dominion and has reduced stats]"
#ap 20
#mapmove 18
#hp 28 -- -4
#prot 6
#size 6 -- bigger than horse
#str 18 -- -2
#enc 4 -- +1
#att 11 -- -1
#def 9 -- -1
#prec 7 -- -1
#mr 12 -- -1
#armor 323 -- magic plate barding
#mor 30
#gcost 0
#rcost 16 -- big metal boi
#rpcost 24
#weapon 334 -- magical gore from the horned helm
#weapon 725 -- brass hoof
#startage 20
#maxage 10000
#poisonres 10
#fireres 7 -- juggernaut
#demon
#animal
#neednoteat
#darkvision 100
--quadruped
#snow
#bravemount 100
#berserk 1 -- -1
#undisciplined
#trample
#holy
#wastesurvival
--heal --- lost outside dom
#domshape 16232
#end





---- Bloodletter

#newmonster 16255
#spr1 "Warhammer_Khorne/Daemon_Bloodletter.tga"
#spr2 "Warhammer_Khorne/Daemon_Bloodletter2.tga"
#name "Bloodletter"
#descr "Bloodletters are the most numerous of Khorne's servants. It is said that they are formed from the essence of mortal warriors who Khorne held in esteem for skill and savagery and their will is as implacable and bloodthirsty as that of their master. Unlike other lesser Daemons Bloodletters organise themselves in a disciplined military manner, forming regiments to march to battle and fighting under gore-soaked banners listing the names of those they have slain. They wear no armour and carry only a great Hellblade, a Daemonic weapon with the power to draw the life of its victims into the Bloodletter as they carve a bloody swathe through enemy ranks. Bloodletters are swift and skilled combatants that function as an elite and hard hitting light infantry in the armies of Khorne and are known for taking the skulls of those they slay to add to their master's legendary Throne of Skulls. As with all Daemons of Chaos these hellish creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#ap 14 -- fast
#mapmove 20 -- tireless, marchers
#hp 13 -- 1 more than daemonette
#prot 12 -- T3, but scaly skin
#size 3
#str 15 -- S4, daemon, +2 over daemonette
#enc 1 -- daemon
#att 13 -- WS5 I5, daemon
#def 12 -- only I4
#prec 11
#mr 15 -- Daemon of Khorne
#mor 30
#gcost 0
#rcost 1
#weapon 1198 -- Hellblade
#startage 20
#maxage 10000
#poisonres 10
#berserk 2
#demon
#neednoteat
#nametype 299 -- Khorne daemon
#notdomshape 16256
#heal --- recuperation ability
#fireres 5
#snow
#end


---- Bloodletter (outside of dominion)

#newmonster 16256
#spr1 "Warhammer_Khorne/Daemon_Bloodletter.tga"
#spr2 "Warhammer_Khorne/Daemon_Bloodletter2.tga"
#name "Bloodletter"
#descr "Bloodletters are the most numerous of Khorne's servants. It is said that they are formed from the essence of mortal warriors who Khorne held in esteem for skill and savagery and their will is as implacable and bloodthirsty as that of their master. Unlike other lesser Daemons Bloodletters organise themselves in a disciplined military manner, forming regiments to march to battle and fighting under gore-soaked banners listing the names of those they have slain. They wear no armour and carry only a great Hellblade, a Daemonic weapon with the power to draw the life of its victims into the Bloodletter as they carve a bloody swathe through enemy ranks. Bloodletters are swift and skilled combatants that function as an elite and hard hitting light infantry in the armies of Khorne and are known for taking the skulls of those they slay to add to their master's legendary Throne of Skulls. As with all Daemons of Chaos these hellish creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God.

[This Bloodletter is outside of friendly Dominion and has reduced stats]"
#ap 14 -- fast
#mapmove 20 -- tireless, marchers
#hp 11 -- -2
#prot 9
#size 3
#str 14 -- -1
#enc 3 -- +2
#att 12 -- -1
#def 11 -- -1
#prec 10 -- -1
#mr 14 -- -1
#mor 30
#gcost 0
#rcost 1
#weapon 1198 -- Hellblade
#startage 20
#maxage 10000
#poisonres 10
#berserk 1
#demon
#neednoteat
#nametype 299 -- khorne daemon
#domshape 16255
#fireres 5
#snow
#end


---- Juggernaut (one used by bloodcrusher, so same as others but not sacred)

#newmonster 14395
#spr1 "Warhammer_Khorne/Daemon_Juggernaut.tga"
#spr2 "Warhammer_Khorne/Daemon_Juggernaut2.tga"
#name "Juggernaut of Khorne"
#descr "Juggernauts of Khorne are hellish beasts clad in daemonic brass and iron that resemble some hybrid of bull, rhinocerous, and hound. Their headlong charges are notoriously difficult to stop and many elite regiments have been broken by a handful of these Daemons crashing into their lines. They are rarely encountered alone, instead being the preferred steeds of Chosen Knights, Chaos Lords, and Bloodletter Daemons. As with all Daemons of Chaos these hellish creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Should this Juggernaut lose its rider it will return to the Realm of Khorne once the battle is concluded."
#ap 20
#mapmove 18
#hp 32
#prot 7
#size 6 -- bigger than horse
#str 20 --
#enc 3 -- daemon
#att 12 -- WS5 I2
#def 10 -- WS5 I2
#prec 8
#mr 13 -- khorne daemon
#armor 323 -- magic plate barding
#mor 30
#gcost 0
#rcost 16 -- big metal boi
#rpcost 24
#weapon 334 -- magical gore from the horned helm
#weapon 725 -- brass hoof
#startage 20
#maxage 10000
#poisonres 10
#fireres 7 -- juggernaut
#demon
#animal
#neednoteat
#darkvision 100
--quadruped
#snow
#bravemount 100
#berserk 2
#undisciplined
#trample
#wastesurvival
#heal --- recuperation ability
#notdomshape 14586
#end


---- Juggernaut (one used by bloodcrusher - out of dominion)

#newmonster 14586
#spr1 "Warhammer_Khorne/Daemon_Juggernaut.tga"
#spr2 "Warhammer_Khorne/Daemon_Juggernaut2.tga"
#name "Juggernaut of Khorne"
#descr "Juggernauts of Khorne are hellish beasts clad in daemonic brass and iron that resemble some hybrid of bull, rhinocerous, and hound. Their headlong charges are notoriously difficult to stop and many elite regiments have been broken by a handful of these Daemons crashing into their lines. They are rarely encountered alone, instead being the preferred steeds of Chosen Knights, Chaos Lords, and Bloodletter Daemons. As with all Daemons of Chaos these hellish creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Should this Juggernaut lose its rider it will return to the Realm of Khorne once the battle is concluded.

[This Juggernaut is outside of friendly Dominion and has reduced stats]"
#ap 20
#mapmove 18
#hp 28 -- -4
#prot 6
#size 6 -- bigger than horse
#str 18 -- -2
#enc 4 -- +1
#att 11 -- -1
#def 9 -- -1
#prec 7 -- -1
#mr 12 -- -1
#armor 323 -- magic plate barding
#mor 30
#gcost 0
#rcost 16 -- big metal boi
#rpcost 24
#weapon 334 -- magical gore from the horned helm
#weapon 725 -- brass hoof
#startage 20
#maxage 10000
#poisonres 10
#animal
#fireres 7 -- juggernaut
#demon
#neednoteat
#darkvision 100
--quadruped
#snow
#bravemount 100
#berserk 1 -- -1
#trample
#undisciplined
#wastesurvival
--heal --- lost outside dom
#domshape 14395
#end



---- Bloodcrusher of Khorne

#newmonster 16257
#copystats 16255 -- bloodletter in dominion
#spr1 "Warhammer_Khorne/Daemon_Bloodcrusher.tga"
#spr2 "Warhammer_Khorne/Daemon_Bloodcrusher2.tga"
#name "Bloodcrusher"
#descr "Only the most favoured of Khorne's Bloodletters earn the right to join the ranks of the Bloodcrushers, regiments of Bloodletters that ride into battle atop Daemonic Juggernauts. These mounts are hellish beasts clad in daemonic brass and iron and are capable of crushing, tearing, and obliterating almost anything in their path. Bloodcrushers are in some ways similar to Chosen Knights and though the riders are far less armoured their Hellblade arguably makes up for this fact. The combination of Bloodletter and Juggernaut is a truly fearsome one and Bloodcrushers are greatly feared by Khorne's enemies, particularly so because of their penchant for seeking out and destroying the most elite opposition to bring glory to their master and break the spirit of the foe. Should the Bloodletter be slain the Juggernaut will fight on for the rest of the battle before returning to the Realm of Khorne. As with all Daemons of Chaos these monstrous cavalry are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Should the Juggernaut be slain and the Bloodcrusher survive, the Daemon will immediately be granted another mount to serve them.

[Automatically regains mount if lost, but this is currently bugged]"
#notdomshape 16258
#remount 1
#skilledrider 1
#mountmnr 14395
#unmountedspr1 "Warhammer_Khorne/Daemon_Bloodletter.tga"
#unmountedspr2 "Warhammer_Khorne/Daemon_Bloodletter2.tga"
#end


---- Bloodcrusher (outside of dominion)

#newmonster 16258
#copystats 16256 -- blood letter out of dominion
#spr1 "Warhammer_Khorne/Daemon_Bloodcrusher.tga"
#spr2 "Warhammer_Khorne/Daemon_Bloodcrusher2.tga"
#name "Bloodcrusher"
#descr "Only the most favoured of Khorne's Bloodletters earn the right to join the ranks of the Bloodcrushers, regiments of Bloodletters that ride into battle atop Daemonic Juggernauts. These mounts are hellish beasts clad in daemonic brass and iron and are capable of crushing, tearing, and obliterating almost anything in their path. Bloodcrushers are in some ways similar to Chosen Knights and though the riders are far less armoured their Hellblade arguably makes up for this fact. The combination of Bloodletter and Juggernaut is a truly fearsome one and Bloodcrushers are greatly feared by Khorne's enemies, particularly so because of their penchant for seeking out and destroying the most elite opposition to bring glory to their master and break the spirit of the foe. Should the Bloodletter be slain the Juggernaut will fight on for the rest of the battle before returning to the Realm of Khorne. As with all Daemons of Chaos these monstrous cavalry are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Should the Juggernaut be slain and the Bloodcrusher survive, the Daemon will immediately be granted another mount to serve them.

[Automatically regains mount if lost, but this is currently bugged]
[This Bloodcrusher is outside of friendly Dominion and has reduced stats]"
#domshape 16257
#remount 1
#skilledrider 1
#mountmnr 14586 -- jugger outside dominion
#unmountedspr1 "Warhammer_Khorne/Daemon_Bloodletter.tga"
#unmountedspr2 "Warhammer_Khorne/Daemon_Bloodletter2.tga"
#end


---- Chaos Ogre -- identical to slaanesh one currently, except with two axes

#newmonster 16216
#spr1 "Warhammer_Khorne/Chaos_Ogre.tga"
#spr2 "Warhammer_Khorne/Chaos_Ogre2.tga"
#name "Chaos Ogre"
#descr "Ogres are large humanoid creatures known for their gluttony, strength, and love of violence. While they are typically quite resistant to both the warping taint of Chaos and the tempting whispers of the Dark Prince, they are naturally drawn to promises of excess and violence and so can often be found in the forces of Khorne. Even fairly small Marauder forces can occasionally find themselves benefitting from the presence of a handful of Ogres because these creatures are natural opportunists and recognise that in a smaller force they can bully their way to getting a larger share of the loot. Chaos Ogres have, despite their natural resistances, been changed by their exposure to Chaos and the attentions of the Ruinous Powers and are even stronger and more ferocious fighters than their former fellows in the Ogre Kingdoms. In Khorne's armies they are often put to use as brute labor during a siege."
#hp 30
#size 5
#prot 5
#mor 12 -- +1
#mr 12 -- +1
#enc 3
#str 16 -- +1
#att 11 -- +1
#def 10 -- +1
#prec 8
#mapmove 18
#ap 16
#weapon 17 -- axe
#weapon 17 -- axe
#armor 118 -- half helmet
#armor 9 -- plate cuirass
#siegebonus 5
#gcost 35
#rpcost 13
#rcost 1
#maxage 60
#mountainsurvival
#wastesurvival
#snow -- added
#fireres 5
#appetite 3 -- one more severe
#ambidextrous 2
#pillagebonus 2
#darkvision 25
--ressize 2 -- khorne doesn't get this, while slaanesh does
#end


---- Chaos Troll

#newmonster 14652
#spr1 "Warhammer_Khorne/Khorne_Chaos_Troll.tga"
#spr2 "Warhammer_Khorne/Khorne_Chaos_Troll2.tga"
#name "Chaos Troll"
#descr "Trollflesh is somewhat succeptible to the warping influence of Chaos but their natural ability to regenerate wages a constant battle with any mutation leading to the appearance of Chaos Trolls varying wildly and changing near constantly. Chaos Trolls are typically smarter, more aggressive, and more coordinated than the Trolls that find themselves goaded into battle by Greenskins but are still fundamentally brutish and prone to do whatever they please in a given moment; nonetheless Chaos warbands will entice them with a share of the loot and use them in battle. They are immensely strong and tough creatures famed for their regenerative prowess and are capable of vomiting a torrent of acidic bile on their opponents. Trolls influenced by Khorne are particularly feared because they are known to wear scraps of armour and are particularly aggressive.

[Recruitment limited to 2 per month]"
#hp 37
#size 5
#prot 9
#mor 11 -- +1
#mr 13 -- -1
#enc 3
#str 18
#att 12 -- +2
#def 9 -- +1
#prec 4
#mapmove 16
#ap 16
#gcost 55 -- increased price because of armour, att boost
#rpcost 16
#rcost 1
#armor 384 -- makeshift armour, similar to ring mail cuirass
#weapon 1094 -- troll vomit
#weapon 17 -- axe
#weapon 17 -- axe
#weapon 20 -- bite
#berserk 1
#mountainsurvival
#wastesurvival
#snow
#darkvision 50
#heal --- recuperation ability
#regeneration 15 -- half again as good as normal
#acidres -5
#undisciplined
#reclimit 2
#appetite 2
#startage 100
#maxage 5000
#ambidextrous 4
#end


---- Fleshhound

#newmonster 16265
#spr1 "Warhammer_Khorne/Daemon_Fleshhound.tga"
#spr2 "Warhammer_Khorne/Daemon_Fleshhound2.tga"
#name "Flesh Hound"
#descr "Flesh Hounds are rapacious wolf-like Daemons, both reptilian and savagely canine in aspect. They are Khorne's trackers and hunters, lithe yet powerful, able to dart aside from a swordsman's strike and deliver a crushing bite in a single fluid movement. Khorne treats his Hounds with rare indulgence and lavishes them with generous gifts, including the brass collars which grant them considerable magic resistance. Flesh Hounds are agents of Khorne's vengeance and known for tracking down those who raise their master's ire relentlessly across any terrain. In battle Flesh Hounds are typically unleashed to strike against vulnerable flanks or run down hated missile troops, delivering Khorne's judgement for their cowardice. As with all Daemons of Chaos these loping terrors are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Flesh Hounds clearly bear the favour of Khorne and as such are sacred to the followers of the Blood God."
#ap 26 -- fast
#mapmove 28 -- same as a shade beast, tireless, fast
#hp 20
#prot 10
#size 4
#str 15 -- S4 daemon
#enc 1 -- daemon
#att 13
#def 12
#prec 12
#mr 17
#mor 30
#gcost 0
#rcost 1
#weapon 1209 -- bite, magical
#weapon 1199 -- claw, magical
#berserk 2
#startage 44
#maxage 10000
#poisonres 10
#fireres 5
#shockres 5
#demon
#animal
#neednoteat
#spiritsight
#nametype 299 -- khorne daemon
#patrolbonus 5 -- sort of standard really good patrol bonus
#notdomshape 16266 -- not dominion hound
#heal --- recuperation ability
#fireres 5
#snow
#swimming
#mountainsurvival
#forestsurvival
#wastesurvival
#swampsurvival
#holy
#end


---- Flesh Hound (out of dominion)

#newmonster 16266
#spr1 "Warhammer_Khorne/Daemon_Fleshhound.tga"
#spr2 "Warhammer_Khorne/Daemon_Fleshhound2.tga"
#name "Flesh Hound"
#descr "Flesh Hounds are rapacious wolf-like Daemons, both reptilian and savagely canine in aspect. They are Khorne's trackers and hunters, lithe yet powerful, able to dart aside from a swordsman's strike and deliver a crushing bite in a single fluid movement. Khorne treats his Hounds with rare indulgence and lavishes them with generous gifts, including the brass collars which grant them considerable magic resistance. Flesh Hounds are agents of Khorne's vengeance and known for tracking down those who raise their master's ire relentlessly across any terrain. In battle Flesh Hounds are typically unleashed to strike against vulnerable flanks or run down hated missile troops, delivering Khorne's judgement for their cowardice. As with all Daemons of Chaos these loping terrors are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Flesh Hounds clearly bear the favour of Khorne and as such are sacred to the followers of the Blood God.

[This Flesh Hound is outside of friendly Dominion and has reduced stats]"
#ap 26 -- fast
#mapmove 28 -- same as a shade beast, tireless, fast
#hp 16 -- -4
#prot 8
#size 4
#str 13 -- -2
#enc 3 -- +2
#att 12 -- -1
#def 11 -- -1
#prec 10 -- -2
#mr 16 -- -1
#mor 30
#gcost 0
#rcost 1
#weapon 1209 -- bite, magical
#weapon 1199 -- claw, magical
#berserk 1
#startage 44
#maxage 10000
#poisonres 10
#fireres 7
#shockres 5
#demon
#animal
#neednoteat
#spiritsight
#nametype 299 -- khorne daemon
#patrolbonus 5 -- sort of standard really good patrol bonus
#domshape 16265 -- dominion hound
#heal --- recuperation ability
#snow
#swimming
#mountainsurvival
#forestsurvival
#wastesurvival
#swampsurvival
#holy
#end



---------- SPAWNS


-- Size 3, cleaver

#newmonster 16219
#spr1 "Warhammer_Khorne/Spawn_3_Cleaver.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Cleaver2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 29
#size 5
#prot 9 -- +2
#mor 30
#mr 13 -- fine
#enc 1
#str 17
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 10 -- falchion as cleaver
#weapon 236 -- claw
#weapon 20 -- bite
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1040 -- chosen, forsaken, spawns
#fireres 5
#snow
#end

-- Size 3, hound sail

#newmonster 16244
#spr1 "Warhammer_Khorne/Spawn_3_Hound.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Hound2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 33
#size 5
#prot 8
#mor 30
#mr 14
#enc 1
#str 17
#att 11
#def 9
#prec 9
#mapmove 18
#ap 16
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 695 -- belch flames
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1040 -- chosen, forsaken, spawns
#snow
#fireres 7
#end

-- Size 3, thin axe

#newmonster 16247
#spr1 "Warhammer_Khorne/Spawn_3_Thin_Axe.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Thin_Axe2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 26
#size 5
#prot 8
#mor 30
#mr 14
#enc 1
#str 16
#att 12
#def 9
#prec 9
#mapmove 18
#ap 16
#gcost 0
#weapon 1909 -- brass axe
#weapon 236 -- claw
#weapon 236 -- claw
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1040 -- chosen, forsaken, spawns
#fireres 5
#snow
#end


-- Size 3, bone glaives

#newmonster 16271
#spr1 "Warhammer_Khorne/Spawn_3_Bone_Glaives.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Bone_Glaives2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 28
#size 5
#prot 8
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1132 -- bone blade
#weapon 1132 -- bone blade
#weapon 1132 -- bone blade
#armor 21 -- full helmet
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1040 -- chosen, forsaken, spawns
#fireres 5
#snow
#end


-- Size 3, horns claws

#newmonster 16274
#spr1 "Warhammer_Khorne/Spawn_3_Horns_Claws.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Horns_Claws2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 10
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 331 -- gore
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1040 -- chosen, forsaken, spawns
#fireres 5
#snow
#end


-- Size 3, axe

#newmonster 16277
#spr1 "Warhammer_Khorne/Spawn_3_Axe.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Axe2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 10
#mor 30
#mr 15
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1909 -- brass axe
#weapon 20 -- bite
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1040 -- chosen, forsaken, spawns
#fireres 5
#snow
#eyes 1
#end


-- Size 3, tentacle

#newmonster 16280
#spr1 "Warhammer_Khorne/Spawn_3_Tentacle.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Tentacle2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 9
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1179 -- spiked whiplash
#weapon 236 -- claw
#weapon 20 -- bite
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1040 -- chosen, forsaken, spawns
#fireres 5
#snow
#eyes 1
#end


-- Size 4, tentacles

#newmonster 16283
#spr1 "Warhammer_Khorne/Spawn_4_Tentacles.tga"
#spr2 "Warhammer_Khorne/Spawn_4_Tentacles2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 55
#size 6
#prot 12
#mor 30
#mr 15
#enc 1
#str 21
#att 11
#def 8
#prec 8
#eyes 1
#mapmove 18
#ap 16
#gcost 0
#weapon 1179 -- spiked whiplash
#weapon 1179 -- spiked whiplash
#weapon 1179 -- spiked whiplash
#weapon 236 -- claw
#weapon 20 -- bite
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1040 -- chosen, forsaken, spawns
#fear 5
#fireres 5
#snow
#end


-- Size 4, horns, claws

#newmonster 16286
#spr1 "Warhammer_Khorne/Spawn_4_Horns_Claws.tga"
#spr2 "Warhammer_Khorne/Spawn_4_Horns_Claws2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 55
#size 6
#prot 13
#mor 30
#mr 15
#enc 1
#str 22
#att 10
#def 8
#prec 8
#eyes 1
#mapmove 18
#ap 16
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 331 -- gore
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1040 -- chosen, forsaken, spawns
#fear 5
#fireres 5
#snow
#end


-- Size 5, tail, bone

#newmonster 16289
#spr1 "Warhammer_Khorne/Spawn_5_Quad.tga"
#spr2 "Warhammer_Khorne/Spawn_5_Quad2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 67
#size 8
#prot 13
#mor 30
#mr 15
#enc 1
#str 23
#att 11
#def 9
#prec 8
#mapmove 20
#ap 20
#gcost 0
#weapon 33 -- claws x2
#weapon 236 -- claw
#weapon 1179 -- spiked whiplash
#weapon 331 -- gore
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 2
#montag 1040 -- chosen, forsaken, spawns
#fear 5
#fireres 5
#snow
#end






---- SPAWNS IN THE KNIGHT POOL

-- Size 3, cleaver

#newmonster 16242
#spr1 "Warhammer_Khorne/Spawn_3_Cleaver.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Cleaver2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 29
#size 5
#prot 9 -- +2
#mor 30
#mr 13 -- fine
#enc 1
#str 17
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 10 -- falchion as cleaver
#weapon 236 -- claw
#weapon 20 -- bite
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1044 -- forsaken, chosen knight, spawns
#fireres 5
#snow
#firstshape 16219
#end


-- Size 3, hound sail

#newmonster 16245
#spr1 "Warhammer_Khorne/Spawn_3_Hound.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Hound2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 33
#size 5
#prot 8
#mor 30
#mr 14
#enc 1
#str 17
#att 11
#def 9
#prec 9
#mapmove 18
#ap 16
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 695 -- belch flames
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1044 -- forsaken, chosen knight, spawns
#fireres 7
#snow
#firstshape 16244
#end


-- Size 3, thin axe

#newmonster 16248
#spr1 "Warhammer_Khorne/Spawn_3_Thin_Axe.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Thin_Axe2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 26
#size 5
#prot 8
#mor 30
#mr 14
#enc 1
#str 16
#att 12
#def 9
#prec 9
#mapmove 18
#ap 16
#gcost 0
#weapon 1909 -- brass axe
#weapon 236 -- claw
#weapon 236 -- claw
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1044 -- forsaken, chosen knight, spawns
#fireres 5
#snow
#firstshape 16247
#end


-- Size 3, bone glaives

#newmonster 16272
#spr1 "Warhammer_Khorne/Spawn_3_Bone_Glaives.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Bone_Glaives2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 28
#size 5
#prot 8
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1132 -- bone blade
#weapon 1132 -- bone blade
#weapon 1132 -- bone blade
#armor 21 -- full helmet
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1044 -- forsaken, chosen knight, spawns
#fireres 5
#snow
#firstshape 16271
#end


-- Size 3, horns claws

#newmonster 16275
#spr1 "Warhammer_Khorne/Spawn_3_Horns_Claws.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Horns_Claws2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 10
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 331 -- gore
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1044 -- forsaken, chosen knight, spawns
#fireres 5
#snow
#firstshape 16274
#end


-- Size 3, axe

#newmonster 16278
#spr1 "Warhammer_Khorne/Spawn_3_Axe.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Axe2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 10
#mor 30
#mr 15
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1909 -- brass axe
#weapon 20 -- bite
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1044 -- forsaken, chosen knight, spawns
#fireres 5
#snow
#eyes 1
#firstshape 16277
#end


-- Size 3, tentacle

#newmonster 16281
#spr1 "Warhammer_Khorne/Spawn_3_Tentacle.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Tentacle2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 9
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1179 -- spiked whiplash
#weapon 236 -- claw
#weapon 20 -- bite
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1044 -- forsaken, chosen knight, spawns
#fireres 5
#snow
#eyes 1
#firstshape 16280
#end


-- Size 4, tentacles

#newmonster 16284
#spr1 "Warhammer_Khorne/Spawn_4_Tentacles.tga"
#spr2 "Warhammer_Khorne/Spawn_4_Tentacles2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 55
#size 6
#prot 12
#mor 30
#mr 15
#enc 1
#str 21
#att 11
#def 8
#prec 8
#eyes 1
#mapmove 18
#ap 16
#gcost 0
#weapon 1179 -- spiked whiplash
#weapon 1179 -- spiked whiplash
#weapon 1179 -- spiked whiplash
#weapon 236 -- claw
#weapon 20 -- bite
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1044 -- forsaken, chosen knight, spawns
#fear 5
#fireres 5
#snow
#firstshape 16283
#end


-- Size 4, horns, claws

#newmonster 16287
#spr1 "Warhammer_Khorne/Spawn_4_Horns_Claws.tga"
#spr2 "Warhammer_Khorne/Spawn_4_Horns_Claws2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 55
#size 6
#prot 13
#mor 30
#mr 15
#enc 1
#str 22
#att 10
#def 8
#prec 8
#eyes 1
#mapmove 18
#ap 16
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 331 -- gore
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1044 -- forsaken, chosen knight, spawns
#fear 5
#fireres 5
#snow
#firstshape 16286
#end


-- Size 5, tail, bone

#newmonster 16290
#spr1 "Warhammer_Khorne/Spawn_5_Quad.tga"
#spr2 "Warhammer_Khorne/Spawn_5_Quad2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 67
#size 8
#prot 13
#mor 30
#mr 15
#enc 1
#str 23
#att 11
#def 9
#prec 8
#mapmove 20
#ap 20
#gcost 0
#weapon 33 -- claws x2
#weapon 236 -- claw
#weapon 1179 -- spiked whiplash
#weapon 331 -- gore
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 2
#montag 1044 -- forsaken, chosen knight, spawns
#fear 5
#fireres 5
#snow
#firstshape 16289
#end




---- SPAWNS THAT COMMANDERS CAN TURN INTO

-- Size 3

#newmonster 16309
#spr1 "Warhammer_Khorne/Spawn_3_Cleaver.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Cleaver2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 29
#size 5
#prot 9 -- +2
#mor 30
#mr 13 -- fine
#enc 1
#str 17
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 10 -- falchion as cleaver
#weapon 236 -- claw
#weapon 20 -- bite
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1043 -- commander spawns
#firstshape 16219
#coldres 5
#snow
#end

-- Size 3, hound sail

#newmonster 16246
#spr1 "Warhammer_Khorne/Spawn_3_Hound.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Hound2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 33
#size 5
#prot 8
#mor 30
#mr 14
#enc 1
#str 17
#att 11
#def 9
#prec 9
#mapmove 18
#ap 16
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 695 -- belch flames
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1043
#fireres 7
#snow
#firstshape 16244
#end

-- Size 3, thin axe

#newmonster 16249
#spr1 "Warhammer_Khorne/Spawn_3_Thin_Axe.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Thin_Axe2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 26
#size 5
#prot 8
#mor 30
#mr 14
#enc 1
#str 16
#att 12
#def 9
#prec 9
#mapmove 18
#ap 16
#gcost 0
#weapon 1909 -- brass axe
#weapon 236 -- claw
#weapon 236 -- claw
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1043 -- commander spawns
#fireres 5
#snow
#firstshape 16247
#end

-- Size 3, bone glaives

#newmonster 16273
#spr1 "Warhammer_Khorne/Spawn_3_Bone_Glaives.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Bone_Glaives2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 28
#size 5
#prot 8
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1132 -- bone blade
#weapon 1132 -- bone blade
#weapon 1132 -- bone blade
#armor 21 -- full helmet
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1043 -- commander spawns
#fireres 5
#snow
#firstshape 16271
#end

-- Size 3, horns claws

#newmonster 16276
#spr1 "Warhammer_Khorne/Spawn_3_Horns_Claws.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Horns_Claws2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 10
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 331 -- gore
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1043 -- commander spawns
#fireres 5
#snow
#firstshape 16274
#end


-- Size 3, axe

#newmonster 16279
#spr1 "Warhammer_Khorne/Spawn_3_Axe.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Axe2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 10
#mor 30
#mr 15
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1909 -- brass axe
#weapon 20 -- bite
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1043 -- commander spawns
#fireres 5
#snow
#eyes 1
#firstshape 16277
#end

-- Size 3, tentacle

#newmonster 16282
#spr1 "Warhammer_Khorne/Spawn_3_Tentacle.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Tentacle2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 9
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1179 -- spiked whiplash
#weapon 236 -- claw
#weapon 20 -- bite
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1043 -- commander spawns
#fireres 5
#snow
#eyes 1
#firstshape 16280
#end

-- Size 4, tentacles

#newmonster 16285
#spr1 "Warhammer_Khorne/Spawn_4_Tentacles.tga"
#spr2 "Warhammer_Khorne/Spawn_4_Tentacles2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 55
#size 6
#prot 12
#mor 30
#mr 15
#enc 1
#str 21
#att 11
#def 8
#prec 8
#eyes 1
#mapmove 18
#ap 16
#gcost 0
#weapon 1179 -- spiked whiplash
#weapon 1179 -- spiked whiplash
#weapon 1179 -- spiked whiplash
#weapon 236 -- claw
#weapon 20 -- bite
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1043 -- commander spawns
#fear 5
#fireres 5
#snow
#firstshape 16283
#montagweight 4
#end

-- Size 4, horns, claws

#newmonster 16288
#spr1 "Warhammer_Khorne/Spawn_4_Horns_Claws.tga"
#spr2 "Warhammer_Khorne/Spawn_4_Horns_Claws2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 55
#size 6
#prot 13
#mor 30
#mr 15
#enc 1
#str 22
#att 10
#def 8
#prec 8
#eyes 1
#mapmove 18
#ap 16
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 331 -- gore
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1043 -- commander spawns
#montagweight 4
#fear 5
#fireres 5
#snow
#firstshape 16286
#end

-- Size 5, tail, bone

#newmonster 16291
#spr1 "Warhammer_Khorne/Spawn_5_Quad.tga"
#spr2 "Warhammer_Khorne/Spawn_5_Quad2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 67
#size 8
#prot 13
#mor 30
#mr 15
#enc 1
#str 23
#att 11
#def 9
#prec 8
#mapmove 20
#ap 20
#gcost 0
#weapon 33 -- claws x2
#weapon 236 -- claw
#weapon 1179 -- spiked whiplash
#weapon 331 -- gore
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 2
#montag 1043 -- commander spawns
#montagweight 4
#fear 5
#fireres 5
#snow
#firstshape 16289
#end





---- Generic Summon Spawns


-- Size 3, cleaver

#newmonster 16292
#spr1 "Warhammer_Khorne/Spawn_3_Cleaver.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Cleaver2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 29
#size 5
#prot 9 -- +2
#mor 30
#mr 13 -- fine
#enc 1
#str 17
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 10 -- falchion as cleaver
#weapon 236 -- claw
#weapon 20 -- bite
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1047 -- generic spawns
#fireres 5
#snow
#end

-- Size 3, hound sail

#newmonster 16293
#spr1 "Warhammer_Khorne/Spawn_3_Hound.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Hound2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 33
#size 5
#prot 8
#mor 30
#mr 14
#enc 1
#str 17
#att 11
#def 9
#prec 9
#mapmove 18
#ap 16
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 695 -- belch flames
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1047 -- generic spawns
#snow
#fireres 7
#end

-- Size 3, thin axe

#newmonster 16294
#spr1 "Warhammer_Khorne/Spawn_3_Thin_Axe.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Thin_Axe2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 26
#size 5
#prot 8
#mor 30
#mr 14
#enc 1
#str 16
#att 12
#def 9
#prec 9
#mapmove 18
#ap 16
#gcost 0
#weapon 1909 -- brass axe
#weapon 236 -- claw
#weapon 236 -- claw
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1047 -- generic spawns
#fireres 5
#snow
#end


-- Size 3, bone glaives

#newmonster 16295
#spr1 "Warhammer_Khorne/Spawn_3_Bone_Glaives.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Bone_Glaives2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 28
#size 5
#prot 8
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1132 -- bone blade
#weapon 1132 -- bone blade
#weapon 1132 -- bone blade
#armor 21 -- full helmet
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1047 -- generic spawns
#fireres 5
#snow
#end


-- Size 3, horns claws

#newmonster 16296
#spr1 "Warhammer_Khorne/Spawn_3_Horns_Claws.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Horns_Claws2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 10
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 331 -- gore
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1047 -- generic spawns
#fireres 5
#snow
#end


-- Size 3, axe

#newmonster 16297
#spr1 "Warhammer_Khorne/Spawn_3_Axe.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Axe2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 10
#mor 30
#mr 15
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1909 -- brass axe
#weapon 20 -- bite
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1047 -- generic spawns
#fireres 5
#snow
#eyes 1
#end


-- Size 3, tentacle

#newmonster 16298
#spr1 "Warhammer_Khorne/Spawn_3_Tentacle.tga"
#spr2 "Warhammer_Khorne/Spawn_3_Tentacle2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 34
#size 5
#prot 9
#mor 30
#mr 13
#enc 1
#str 18
#att 11
#def 9
#prec 9
#mapmove 16
#ap 14
#gcost 0
#weapon 1179 -- spiked whiplash
#weapon 236 -- claw
#weapon 20 -- bite
#ambidextrous 3
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1047 -- generic spawns
#fireres 5
#snow
#eyes 1
#end


-- Size 4, tentacles

#newmonster 16299
#spr1 "Warhammer_Khorne/Spawn_4_Tentacles.tga"
#spr2 "Warhammer_Khorne/Spawn_4_Tentacles2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 55
#size 6
#prot 12
#mor 30
#mr 15
#enc 1
#str 21
#att 11
#def 8
#prec 8
#eyes 1
#mapmove 18
#ap 16
#gcost 0
#weapon 1179 -- spiked whiplash
#weapon 1179 -- spiked whiplash
#weapon 1179 -- spiked whiplash
#weapon 236 -- claw
#weapon 20 -- bite
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1047 -- generic spawns
#fear 5
#fireres 5
#snow
#end


-- Size 4, horns, claws

#newmonster 16300
#spr1 "Warhammer_Khorne/Spawn_4_Horns_Claws.tga"
#spr2 "Warhammer_Khorne/Spawn_4_Horns_Claws2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 55
#size 6
#prot 13
#mor 30
#mr 15
#enc 1
#str 22
#att 10
#def 8
#prec 8
#eyes 1
#mapmove 18
#ap 16
#gcost 0
#weapon 236 -- claw
#weapon 236 -- claw
#weapon 331 -- gore
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#montag 1047 -- generic spawns
#fear 5
#fireres 5
#snow
#end


-- Size 5, tail, bone

#newmonster 16301
#spr1 "Warhammer_Khorne/Spawn_5_Quad.tga"
#spr2 "Warhammer_Khorne/Spawn_5_Quad2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Khorne sometimes retain the ability to carry weapons and are known for their spined appendages, great strength, and heedless aggression."
#hp 67
#size 8
#prot 13
#mor 30
#mr 15
#enc 1
#str 23
#att 11
#def 9
#prec 8
#mapmove 20
#ap 20
#gcost 0
#weapon 33 -- claws x2
#weapon 236 -- claw
#weapon 1179 -- spiked whiplash
#weapon 331 -- gore
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 2
#montag 1047 -- generic spawns
#fear 5
#fireres 5
#snow
#end




------------ COMMANDERS

---- Herald of Khorne

#newmonster 16260
#spr1 "Warhammer_Khorne/Daemon_Herald.tga"
#spr2 "Warhammer_Khorne/Daemon_Herald2.tga"
#name "Herald of Khorne"
#descr "Foremost amongst the ranks of the Bloodletters are the Heralds of Khorne. These serve not only as the commanders of the regiments of Bloodletters that make up much of Khorne's vast army but as takers of skulls that can duel and kill the greatest champions of those who stand against the Blood God. Much like the mortal Slaughterpriests the Heralds of Khorne are able to extend Khorne's blessings to his most favoured servants and see to the erection of temples honouring the Lord of Skulls. While the rank and file Bloodletter takes delight in wearing no encumbering armour and proving its sheer skill in battle, Heralds are far more disciplined and cold in their rage and seek only to carry out Khorne's wishes, so wear Daemonic plate. Khorne has a great hatred for those who would cower behind walls of stone rather than do battle and as such his Heralds have an innate understanding of how to break into besieged fortifications. As with all Daemons of Chaos these emissaries of wrath and conquest are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#ap 14 -- fast
#mapmove 20 -- tireless
#hp 25 -- +3 over herald of slaanesh
#prot 14
#size 3
#str 17 -- +2 over bloodletter
#enc 1 -- daemon
#att 15 -- +2
#def 14
#prec 11
#mr 17 -- +2
#mor 30
#gcost 0
#rcost 1
#weapon 1198 -- Hellblade
#armor 312 -- Chaos Plate Cuirass
#armor 305 -- chaos headplate
#berserk 2
#startitem 1000 -- mark of blood
#startage 200
#maxage 10000
#poisonres 10
#adeptsacr 2
#demon
#neednoteat
#ambidextrous 2
--
#goodundeadleader
#goodleader
#command -40 -- so 40 left
#nametype 299 -- Khorne daemon
#heal --- recuperation ability
#holy
#magicskill 9 2
#fireres 7 -- hell forged
#snow
#notdomshape 16261 -- out of dominion
#siegebonus 20
#combatcaster
#end


---- Herald of Khorne (outside of dom)

#newmonster 16261
#spr1 "Warhammer_Khorne/Daemon_Herald.tga"
#spr2 "Warhammer_Khorne/Daemon_Herald2.tga"
#name "Herald of Khorne"
#descr "Foremost amongst the ranks of the Bloodletters are the Heralds of Khorne. These serve not only as the commanders of the regiments of Bloodletters that make up much of Khorne's vast army but as takers of skulls that can duel and kill the greatest champions of those who stand against the Blood God. Much like the mortal Slaughterpriests the Heralds of Khorne are able to extend Khorne's blessings to his most favoured servants and see to the erection of temples honouring the Lord of Skulls. While the rank and file Bloodletter takes delight in wearing no encumbering armour and proving its sheer skill in battle, Heralds are far more disciplined and cold in their rage and seek only to carry out Khorne's wishes, so wear Daemonic plate. Khorne has a great hatred for those who would cower behind walls of stone rather than do battle and as such his Heralds have an innate understanding of how to break into besieged fortifications. As with all Daemons of Chaos these emissaries of wrath and conquest are highly resistant to physical attacks but grow weaker outside the Dominion of their God.

[This Herald of Khorne is outside of friendly Dominion and has reduced stats]"
#ap 14 -- fast
#mapmove 20 -- tireless
#hp 21 -- -4
#prot 11
#size 3
#str 15 -- -2
#enc 2 -- +1
#att 14 -- -1
#def 13 -- -1
#prec 10 -- -1
#mr 15 -- -2
#mor 30
#gcost 0
#rcost 1
#weapon 1198 -- Hellblade
#armor 312 -- Chaos Plate Cuirass
#armor 305 -- chaos headplate
#berserk 2
#startitem 1000 -- mark of blood
#startage 200
#maxage 10000
#poisonres 10
#adeptsacr 2
#demon
#neednoteat
#ambidextrous 2
--
#goodundeadleader
#goodleader
#command -40 -- so 40 left
#nametype 299 -- Khorne daemon
--heal --- recuperation ability lost outside dom
#holy
#magicskill 9 2
#fireres 7 -- hell forged
#adeptsacr 2
#snow
#domshape 16260 -- in dominion
#siegebonus 10 -- -10
#combatcaster
#end



---- Aspiring Champion

#newmonster 16223
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Aspiring_Champion.tga"
#spr2 "Warhammer_Khorne/Aspiring_Champion2.tga"
#name "Aspiring Champion"
#descr "Even amongst the elite Chaos Warriors there are those who stand out as having the potential for a greater destiny still, not on the Path of the Warrior but of the Champion. Just as Warriors seek the favour of one of the Ruinous Powers that they might join the rankgs of the Chosen, Aspiring Champions seek to become Exalted Heroes, Chaos Lords, perhaps even reach the zenith of Daemonic Princehood. These Champions are leaders of small bands of Warriors who travel seeking challenges worthy of their great skills and push on to commit greater and greater deeds in the name of their God. Though every Champion believes themselves destined for greatness and so eagerly attempts to draw the eye of their God it is the fate of some to be found wanting in such an event and turned into a foul Chaos Spawn. Champions of Khorne fight with paired weapons in an offensive whirlwind of destruction and are known for entering a state of frenzied bloodlust in battle.

[When this Champion is promoted it will transform to a form which will then be further transformed by an event, either becoming an Exalted Hero (and losing all its XP) or being turned into a Chaos Spawn]"
#hp 25
#mor 15 -- +1
#mr 15 -- +2 for tier 2
#str 14 -- +1
#att 15 -- +1
#def 13 -- +1
#prec 12 -- +2
#gcost 105
#rpcost 1
#goodleader
#command -80 -- so 20
#ambidextrous 3 -- +1
--
#weapon 17 -- axe
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#poorundeadleader
#xpshape 45
#berserk 2
#end


---- Aspiring Champion (ready for event)

#newmonster 16224
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Aspiring_Champion_Judgement.tga"
#spr2 "Warhammer_Khorne/Aspiring_Champion_Judgement2.tga"
#name "Aspiring Champion"
#descr "Even amongst the elite Chaos Warriors there are those who stand out as having the potential for a greater destiny still, not on the Path of the Warrior but of the Champion. Just as Warriors seek the favour of one of the Ruinous Powers that they might join the rankgs of the Chosen, Aspiring Champions seek to become Exalted Heroes, Chaos Lords, perhaps even reach the zenith of Daemonic Princehood. These Champions are leaders of small bands of Warriors who travel seeking challenges worthy of their great skills and push on to commit greater and greater deeds in the name of their God. Though every Champion believes themselves destined for greatness and so eagerly attempts to draw the eye of their God it is the fate of some to be found wanting in such an event and turned into a foul Chaos Spawn. Champions of Khorne fight with paired weapons in an offensive whirlwind of destruction and are known for entering a state of frenzied bloodlust in battle.

[This Champion is awaiting the event that will transform them to either an Exalted Hero (and losing all its XP) or a Chaos Spawn]"
#hp 25
#mor 15 -- +1
#mr 15 -- +2 for tier 2
#str 14 -- +1
#att 15 -- +1
#def 13 -- +1
#prec 12 -- +2
#gcost 105
#rpcost 1
#goodleader
#command -80 -- so 20
#ambidextrous 3 -- +1
--
#weapon 17 -- axe
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#poorundeadleader
#berserk 2
#end



---- Exalted Hero

#newmonster 16237
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Exalted_Hero.tga"
#spr2 "Warhammer_Khorne/Exalted_Hero2.tga"
#name "Exalted Hero"
#descr "Exalted Heroes stand as paragons on the Path of the Warrior and the Champion, for they are everything that every Chaos Warrior and Aspiring Champion strives to be. The Exalted are monstrously powerful combatants capable of commanding forces of the mightiest warriors in the world, blessed many times over by their patron God and with an iron will to pursue their ambitions and become immortal. They are to the Aspiring Champions as the Chosen are to the Warriors, but unlike the Chosen they do not accept they have reached the zenith of their journey, for the prize of becoming a Chaos Lord and eventually a Daemon Prince still lies ahead of them and the risk of being reduced to a gibbering Chaos Spawn is one they gladly accept. Exalted Heroes of Khorne are berserker warriors of towering rage and violence that live for battle, having set aside all other concerns in an effort to draw Khorne's favour and attain the title of Chaos Lord. They wield an axe of Daemonic brass and a blade which snarls and tears at the foe as it bites into their flesh. Khorne has a great hatred for those who would cower behind walls of stone rather than do battle and as such his Exalted have an innate understanding of how to break into besieged fortifications.

[Requires friendly Dominion strength of 7 in the province to recruit]
[When this Exalted Hero is promoted it will transform to a form which will then be further transformed by an event, either becoming a Chaos Lord (and losing all its XP) or being turned into a Chaos Spawn]"
#hp 35
#mor 16 -- +1 over aspiring champion
#mr 16 -- +1
#str 15 -- +1
#att 16 -- +1
#def 14 -- +1
#prec 13 -- +1
#gcost 220
#rpcost 2
#goodleader
#ambidextrous 3
--
#weapon 1200 -- ripping blade
#weapon 1909 -- brass axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#holy
#size 4
#okundeadleader
#domrec 7
#heal
#berserk 3
#siegebonus 10
#xpshape 55
#startage 80
#maxage 400
#end


---- Exalted Hero (awaiting event)

#newmonster 16238
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Exalted_Hero_Judgement.tga"
#spr2 "Warhammer_Khorne/Exalted_Hero_Judgement2.tga"
#name "Exalted Hero"
#descr "Exalted Heroes stand as paragons on the Path of the Warrior and the Champion, for they are everything that every Chaos Warrior and Aspiring Champion strives to be. The Exalted are monstrously powerful combatants capable of commanding forces of the mightiest warriors in the world, blessed many times over by their patron God and with an iron will to pursue their ambitions and become immortal. They are to the Aspiring Champions as the Chosen are to the Warriors, but unlike the Chosen they do not accept they have reached the zenith of their journey, for the prize of becoming a Chaos Lord and eventually a Daemon Prince still lies ahead of them and the risk of being reduced to a gibbering Chaos Spawn is one they gladly accept. Exalted Heroes of Khorne are berserker warriors of towering rage and violence that live for battle, having set aside all other concerns in an effort to draw Khorne's favour and attain the title of Chaos Lord. They wield an axe of Daemonic brass and a blade which snarls and tears at the foe as it bites into their flesh. Khorne has a great hatred for those who would cower behind walls of stone rather than do battle and as such his Exalted have an innate understanding of how to break into besieged fortifications.

[This Exalted Hero is awaiting the event that will transform them to either a Chaos Lord (and losing all its XP) or a Chaos Spawn]"
#hp 35
#mor 16 -- +1 over aspiring champion
#mr 16 -- +1
#str 15 -- +1
#att 16 -- +1
#def 14 -- +1
#prec 13 -- +1
#gcost 220
#rpcost 2
#goodleader
#ambidextrous 3
--
#weapon 1200 -- ripping blade
#weapon 1909 -- brass axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#holy
#size 4
#okundeadleader
#domrec 7
#heal
#berserk 3
#siegebonus 10
#startage 80
#maxage 400
#end


---- Chaos Lord (new mounted)

#newmonster 16267
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Chaos_Lord.tga"
#spr2 "Warhammer_Khorne/Chaos_Lord2.tga"
#name "Chaos Lord"
#descr "At the zenith of the mortal forces of the Ruinous Powers stand the Chaos Lords, champions and paragons of their patron God whose mere command can see tribes annihilated, cities sacked, and nations brought to the brink of disaster. Only the mightiest and most favoured Exalted Hero will survive to become a Chaos Lord, having overcome their enemies, their rivals, attempted punishments by the Ruinous Powers they have chosen not to follow, and even the capricious whims of their own God. Chaos Lords are extremely skilled combatants and physically far beyond the potential of mortal men in addition to being experienced and innately talented commanders. They are granted Daemonic mounts to carry them into battle and emphasize their status; in the case of Khorne a roaring, snorting, crushingly powerful beast of brass and iron called a Juggernaut. Should the Chaos Lord be slain, this mount will fight on before returning to the Chaos Realm of Khorne. Aside from continuing to butcher worthy foes and spill blood for the Blood God, all that remains for this Chaos Lord is to prove themselves so fully that they are elevated to immortality in the form of a Daemon Prince. Khorne has a great hatred for those who would cower behind walls of stone rather than do battle and as such his Lords have an innate understanding of how to break into besieged fortifications.

[When this Chaos Lord is promoted it will transform to a form which will then be further transformed by an event, either finally becoming a Daemon Prince (and losing all its XP) or being turned into a Chaos Spawn]"
--stats compared with exalted hero
#hp 45 -- +10
#mor 18 -- +2
#mr 18 -- +2
#str 16 -- +1
#att 17 -- +1
#def 15 -- +1
#prec 14 -- +1
#gcost 290
#rpcost 2
#expertleader
#ambidextrous 3
--
#weapon 1201 -- Tearing Axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#berserk 3
#holy
#size 4
#goodundeadleader
#darkvision 100
#heal
#siegebonus 20
#xpshape 70
#skilledrider 3
#mountmnr 16269 -- golden juggernaut
#unmountedspr1 "Warhammer_Khorne/Chaos_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Khorne/Chaos_Lord_Unmounted2.tga"
#startage 100
#maxage 500
#end


---- Chaos Lord (awaiting event) (new mounted)

#newmonster 16268
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Chaos_Lord_Judgement.tga"
#spr2 "Warhammer_Khorne/Chaos_Lord_Judgement2.tga"
#name "Chaos Lord"
#descr "At the zenith of the mortal forces of the Ruinous Powers stand the Chaos Lords, champions and paragons of their patron God whose mere command can see tribes annihilated, cities sacked, and nations brought to the brink of disaster. Only the mightiest and most favoured Exalted Hero will survive to become a Chaos Lord, having overcome their enemies, their rivals, attempted punishments by the Ruinous Powers they have chosen not to follow, and even the capricious whims of their own God. Chaos Lords are extremely skilled combatants and physically far beyond the potential of mortal men in addition to being experienced and innately talented commanders. They are granted Daemonic mounts to carry them into battle and emphasize their status; in the case of Khorne a roaring, snorting, crushingly powerful beast of brass and iron called a Juggernaut. Should the Chaos Lord be slain, this mount will fight on before returning to the Chaos Realm of Khorne. Aside from continuing to butcher worthy foes and spill blood for the Blood God, all that remains for this Chaos Lord is to prove themselves so fully that they are elevated to immortality in the form of a Daemon Prince.  Khorne has a great hatred for those who would cower behind walls of stone rather than do battle and as such his Lords have an innate understanding of how to break into besieged fortifications.

[This Chaos Lord is awaiting the event that will transform them to either a Daemon Prince (and losing all its XP) or a Chaos Spawn]"
--stats compared with exalted hero
#hp 45 -- +10
#mor 18 -- +2
#mr 18 -- +2
#str 16 -- +1
#att 17 -- +1
#def 15 -- +1
#prec 14 -- +1
#gcost 290
#rcost 1
#rpcost 2
#expertleader
#ambidextrous 3
--
#weapon 1201 -- Tearing Axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#berserk 3
#holy
#size 4
#goodundeadleader
#darkvision 100
#heal
#siegebonus 20
#skilledrider 3
#mountmnr 16269 -- golden juggernaut
#unmountedspr1 "Warhammer_Khorne/Chaos_Lord_Unmounted_Judgement.tga"
#unmountedspr2 "Warhammer_Khorne/Chaos_Lord_Unmounted_Judgement2.tga"
#startage 100
#maxage 500
#end


---- Juggernaut (gold one used by chaos lords)

#newmonster 16269
#copystats 16232 -- juggernaut of the chosen knight
#spr1 "Warhammer_Khorne/Daemon_Juggernaut_Gold.tga"
#spr2 "Warhammer_Khorne/Daemon_Juggernaut_Gold2.tga"
#holy
#notdomshape 14587
#end


---- Juggernaut (gold one used by chaos lords)

#newmonster 14587
#copystats 13844 -- juggernaut of the chosen knight
#spr1 "Warhammer_Khorne/Daemon_Juggernaut_Gold.tga"
#spr2 "Warhammer_Khorne/Daemon_Juggernaut_Gold2.tga"
#holy
#domshape 16269
#end



---- Daemon Prince of Khorne

#newmonster 16270
#spr1 "Warhammer_Khorne/Daemon_Prince.tga"
#spr2 "Warhammer_Khorne/Daemon_Prince2.tga"
#name "Daemon Prince"
#descr "Daemon Princes were once mortals, Chaos Lords that so pleased their patron God that the ultimate prize of immortality was bestowed upon them, along with a new form embodying the essence of the Chaos God that elevated them. Unlike Daemons, even Greater Daemons, a part of the Daemon Prince is forever its own, distinct from the sprawling energy of the God that granted it such power, for the Ruinous Powers enjoy seeing the schemes and ambitions of their most favoured followers play out across eternity. Daemon Princes of Khorne tend to hold a roughly humanoid shape, though typically with lower limbs more reminiscent than those of a Bloodletter or Bloodthrister, and greatly increased size as well as other alterations pleasing to the Blood God. Unlike the Daemon Princes of the other Ruinous Powers those of Khorne do not use magic at all, instead relying on their great physical strength and incredible martial prowess, as well as Daemonic weapons and armour gifted to them by Khorne. As representatives of Khorne's power and symbols of the rewards that can be gained in the service of the Blood God, Daemon Princes have priestly authority. While they are Daemons in form their past in the mortal world grants Daemon Princes the benefit of not becoming weaker outside the Dominion of their God, though like Greater Daemons they can still only reform their bodies if slain in this Dominion."
--stats compared with Slaaneshi Daemon Prince
#hp 60 -- +5
#size 8
#prot 17
#mor 30
#mr 19 -- +1
#enc 1
#str 23 -- +3
#att 17 -- +1
#def 15 -- -1
#prec 13
#mapmove 22 -- +4
#ap 20 -- +4
#gcost 0
#weapon 1213 -- flaming skull flail
#weapon 1212 -- burning brass axe (two attacks)
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#berserk 4
#startitem 1000 -- mark of blood
--
#neednoteat
#poisonres 10
#fireres 10
#shockres 5
#coldres 5
#diseaseres 100
#demon
#magicskill 9 3 -- H3
#holy
#expertleader
#expertundeadleader
#fear 5
#wastesurvival
#snow
#ambidextrous 4
#domimmortal
#adeptsacr 3
#reformtime 3 -- takes 6 months to reform
#maxage 9999
#startage 6666
#nametype 298 -- khorne warrior names
#heal --- recuperation ability
#combatcaster
#end


---- Daemon Prince of Khorne (with -1 holy)

#newmonster 14127
#spr1 "Warhammer_Khorne/Daemon_Prince.tga"
#spr2 "Warhammer_Khorne/Daemon_Prince2.tga"
#name "Daemon Prince"
#descr "Daemon Princes were once mortals, Chaos Lords that so pleased their patron God that the ultimate prize of immortality was bestowed upon them, along with a new form embodying the essence of the Chaos God that elevated them. Unlike Daemons, even Greater Daemons, a part of the Daemon Prince is forever its own, distinct from the sprawling energy of the God that granted it such power, for the Ruinous Powers enjoy seeing the schemes and ambitions of their most favoured followers play out across eternity. Daemon Princes of Khorne tend to hold a roughly humanoid shape, though typically with lower limbs more reminiscent than those of a Bloodletter or Bloodthrister, and greatly increased size as well as other alterations pleasing to the Blood God. Unlike the Daemon Princes of the other Ruinous Powers those of Khorne do not use magic at all, instead relying on their great physical strength and incredible martial prowess, as well as Daemonic weapons and armour gifted to them by Khorne. As representatives of Khorne's power and symbols of the rewards that can be gained in the service of the Blood God, Daemon Princes have priestly authority. While they are Daemons in form their past in the mortal world grants Daemon Princes the benefit of not becoming weaker outside the Dominion of their God, though like Greater Daemons they can still only reform their bodies if slain in this Dominion."
--stats compared with Slaaneshi Daemon Prince
#hp 60 -- +5
#size 8
#prot 17
#mor 30
#mr 19 -- +1
#enc 1
#str 23 -- +3
#att 17 -- +1
#def 15 -- -1
#prec 13
#mapmove 22 -- +4
#ap 20 -- +4
#gcost 0
#weapon 1213 -- flaming skull flail
#weapon 1212 -- burning brass axe (two attacks)
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#berserk 4
#startitem 1000 -- mark of blood
--
#neednoteat
#poisonres 10
#fireres 10
#shockres 5
#coldres 5
#diseaseres 100
#demon
#magicskill 9 3 -- H3
#magicboost 9 -1 -- -1 to holy
#holy
#expertleader
#expertundeadleader
#fear 5
#wastesurvival
#snow
#ambidextrous 4
#adeptsacr 3
#domimmortal
#reformtime 3 -- takes 6 months to reform
#maxage 9999
#startage 6666
#nametype 298 -- khorne warrior names
#heal --- recuperation ability
#combatcaster
#end


---- Marauder Shaman

#newmonster 16243
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Shaman.tga"
#spr2 "Warhammer_Khorne/Marauder_Shaman2.tga"
#name "Marauder Shaman"
#descr "Most Marauder tribes will have one or two Shamans whose duty is to offer counsel to the Chieftain, interpret auguries to ensure successful raids, and lead the tribe in offering the proper observances to their patron God. Shamans tend to have only a little magical talent and rather than harnessing energy provided by the Ruinous Powers, they tap into the magic of their surroundings in the manner of hedge mages, witches, and other lesser mages. Shamans thus practice a different branch of magic from Sorcerers focused on veneration of the dead, the wilds, and the bitter cold of the polar lands. Shamans of Marauder tribes dedicated to Khorne in the guise of the Hound have a lower status than those of other tribes as Khorne is highly distrustful of magic users and carry a spear rather than a staff, for they are more willing warriors than others of their kind. They use magic of the wilds, frost, bone, and rock. Occasionally Khorne will deign to give a shaman knowledge of blood.

[Recruitment does not require a lab]"
#gcost 125
#rpcost 2
#rcost 1
#holy
#magicskill 6 1 -- N1
#custommagic 38400 100 -- WEDB
#holy
#mr 15
#att 11
#def 11
--
#poorleader
#weapon 1 -- spear
#armor 44 -- furs
#armor 120 -- leather cap
#researchbonus -3
#noreqlab
#end


---- Marauder Chieftain

#newmonster 16259
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Chieftain.tga"
#spr2 "Warhammer_Khorne/Marauder_Chieftain2.tga"
#name "Marauder Chieftain"
#descr "While the largest Marauder warhosts are inevitably commanded by an Exalted Hero or Chaos Lord, the smaller tribes that make up the vast majority of human life in the lands surrounding the Chaos Wastes are ruled over by Chieftains. They are typically fierce and crafty warriors with years of experience raiding and doing battle, perhaps even having taken part in a full blown Chaos invasion during their lifetime. Although Marauders hold sheer martial prowess in considerable esteem it is unusual for a young Marauder, no matter how gifted, to ascend to the position of Chieftain, as they will typically embark of the Path of the Warrior or the Path of the Champion, assuming they don't fall in battle trying to prove themselves. Rather Marauder Chieftains are picked out by their Shamans and by former Chiefs to take the position, selected on the basis that they clearly have some favour from the Ruinous Powers, but have not attracted the potentially lethal full attention of their Patron God. The Marauder tribes are well known for their raids by sea and Marauder Chieftains can command fleets of cramped but efficient longboats to bear Marauders and Warriors to battle, though they aren't nearly large enough to transport cavalry."
#gcost 60
#hp 20
#str 14 -- +1 for khorne
#prot 3
#att 12
#def 12
#mor 13
#weapon 17 -- axe
#armor 21 -- full helmet
#armor 9 -- plate cuirass
#armor 2 -- shield
#rpcost 1
#rcost 1
#mr 12 --- +1 for khorne
#prec 11
#okleader
#command 20
--
#pillagebonus 5
#sailing 999 4
#swimming
#beastmaster 2
#taxcollector
#end


-----Marauder Horse (horsemaster)

#newmonster 14393
#copystats 14391 -- marauder horse
#spr1 "Warhammer_Khorne/Marauder_Horsemaster_Mount.tga"
#spr2 "Warhammer_Khorne/Marauder_Horsemaster_Mount2.tga"
#name "Marauder Horse"
#descr "The horses ridden by Chaos Marauders are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos. Unlike most horses there is a chance they will continue to fight even if their rider is slain, such is their aggressive nature."
#end


---- Marauder Horsemaster

#newmonster 16304
#copystats 16200 -- marauder template
#spr1 "Warhammer_Khorne/Marauder_Horsemaster.tga"
#spr2 "Warhammer_Khorne/Marauder_Horsemaster2.tga"
#name "Marauder Horsemaster"
#descr "While the largest Marauder warhosts are inevitably commanded by an Exalted Hero or Chaos Lord, the smaller tribes that make up the vast majority of human life in the lands surrounding the Chaos Wastes are ruled over by Chieftains. They are typically fierce and crafty warriors with years of experience raiding and doing battle, perhaps even having taken part in a full blown Chaos invasion during their lifetime. Although Marauders hold sheer martial prowess in considerable esteem it is unusual for a young Marauder, no matter how gifted, to ascend to the position of Chieftain, as they will typically embark of the Path of the Warrior or the Path of the Champion, assuming they don't fall in battle trying to prove themselves. Rather Marauder Chieftains are picked out by their Shamans and by former Chiefs to take the position, selected on the basis that they clearly have some favour from the Ruinous Powers, but have not attracted the potentially lethal full attention of their Patron God. Those Chieftains that rule over the primarily eastern Marauder tribes whose raiders are largely mounted go to battle on fine steeds and are known as Horsemasters. They are as versed in raiding tactics as any other Chieftain but tend to lead smaller groups and cannot call on fleets of longships to transport their raiders."
#weapon 357 -- light lance
#armor 21 -- full helmet
#armor 9 -- plate cuirass
#armor 2 -- shield
#gcost 50 -- (60)
#hp 20
#str 14 -- +1 for khorne
#prot 3
#att 12
#def 12
#mor 13
#rpcost 1
#mr 12 -- +1 for khorne
#prec 11
#okleader
--
#pillagebonus 5
#beastmaster 2
#taxcollector
#skilledrider 3
#mobilearcher 1
#mountmnr 14393
#unmountedspr1 "Warhammer_Khorne/Marauder_Horsemaster_Unmounted.tga"
#unmountedspr2 "Warhammer_Khorne/Marauder_Horsemaster_Unmounted2.tga"
#end


---- Disciple of Brass

#newmonster 16227
#spr1 "Warhammer_Khorne/Brass_Disciple.tga"
#spr2 "Warhammer_Khorne/Brass_Disciple2.tga"
#name "Disciple of Brass"
#descr "Even so called scholars of the Ruinous Powers are prone to mistake their natures as singular or unchangeable, believing Khorne is a create of slaughter, Slaanesh depravity, Nurgle decay, and Tzeentch sorcery. But in truth each of the Chaos Gods contains multitudes of aspects that contrast, compete, compliment, clash, and contradict each other in a constant impossible whirl of meaning. So it is that Khorne is the God of raging berserkers, keen tacticians, and honourable duelists all, but Khorne has aspect beyonds these too; the Blood God also favours smiths, the heat of the forge, and the discipline of the ascetic. The Disciples of Brass worship this last aspect of Khorne, a discipline and purity of form they see in Khorne's proclivity for gleaming brass. Though they train their bodies extensively the Disciples are not strictly warriors and though they are magically talented their use of the magic of Brass, of fire and earth and metal, could never be considered sorcery. They are monks of a kind, recruiting from members of the Marauder tribes who dream of an endless unspoiled realm of brass that lies within, and though they are not sacred to the followers of Khorne, they are treated with a wary respect. Being ascetics, they have less need for gold."
#gcost 130
#rpcost 2
#rcost 1
#magicskill 0 1 -- F1
#magicskill 3 1 -- E1
#combatcaster
#str 13
#enc 3 -- normal
#hp 14
#mor 14
#mr 15
#att 11
#def 11
#prec 10
#addupkeep -65
#poorleader
#command -5
#weapon 238 -- magic staff
#armor 306 -- brass mask
#fireres 7
#researchbonus -1
#snow
#maxage 100
#end


---- Speaker of Brass

#newmonster 16228
#spr1 "Warhammer_Khorne/Brass_Speaker.tga"
#spr2 "Warhammer_Khorne/Brass_Speaker2.tga"
#name "Speaker of Brass"
#descr "The Speakers of Brass are the leaders of the Disciples, those who have attained an understanding of the pure realm of brass which eludes most of their kind. They put out their own eyes so the mortal world does not distract them from their inner vision and place a collar of solid brass over the sockets. The Speakers carry daemonic brass icons of Khorne and have more magical power than the Disciples, but insist on wearing heavy armour further enchanted to weigh them down and test their resolve. As with the Disciples they are truly neither sorcerers nor priests and are neither reviled nor considered sacred by other followers of the Blood God. Being ascetics, they have less need for gold."
#gcost 280
#rpcost 2
#rcost 1
#magicskill 0 2 -- F2
#magicskill 3 2 -- E2
#combatcaster
#str 13
#enc 6 -- increased
#hp 14
#mor 14
#mr 15
#att 11
#def 11
#prec 6
#blind
#eyes 0
#addupkeep -140
#poorleader
#command -5
#weapon 238 -- magic staff
#armor 312 -- chaos plate cuirass
#fireres 7
#snow
#maxage 150
#end


---- Ragesmith

#newmonster 16229
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Ragesmith.tga"
#spr2 "Warhammer_Khorne/Ragesmith2.tga"
#name "Ragesmith"
#descr "From time to time a Chaos Warriors of Khorne will succumb to a building and uncontrollable rage that drives them to attack even their fellows in a frenzied state, earning the punishment of being chained to one of the great Brass Anvils gifted to the tribes of the Hound by Khorne. Most who are chained in such a way die, thrashing and screaming until the very last, howling their endless rage at the sky, but a small handful manage to somehow control their bloodlust through strength of will. Those who survive this ordeal are selected by Khorne to be trained as Ragesmiths, the tireless smiths of daemonic arms and armour that worship Khorne's aspect as the lord of the fiery forge. Ragesmiths are truly gifted in the creation of magical items, letting Khorne's infinite knowledge of tools of slaughter and war flow through them and their great depth of rage guide their hammer on the Brass Anvil they were once bound to. Should a Ragesmith enter battle they will be unable to contain their rage and will immediately enter a berserk frenzy, hurling themselves into the enemy lines. Ragesmiths are recognised to be favoured by Khorne and are sacred to the followers of the Blood God."
#hp 17
#str 14
#gcost 340
#rpcost 2
#magicskill 0 1 -- F1
#magicskill 3 1 -- E1
#magicskill 5 1 -- D1
#magicskill 8 1 -- B1
#custommagic 38016 100 -- 100% DBEF
#bonusspells 1
#holy
#poorleader
#weapon 1214 -- brass forgehammer
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#researchbonus -6
#snow
#fireres 5
#mastersmith 1
#resources 15
#fixforgebonus 1
#berserk 3
#douse -2
--
#startitem 941 -- mark of rage
#older -20
#maxage 400
#end


---- Slaughterpriest

#newmonster 16230
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Slaughterpriest.tga"
#spr2 "Warhammer_Khorne/Slaughterpriest2.tga"
#name "Slaughterpriest"
#descr "Not all who receive Khorne's favour are destined to tread the path of the Champion, some are instead marked out to act as gore-soaked priests of the Blood God's will. Slaughterpriests are granted visions of violence and death from their God and know their purpose is to rouse his followers into acts of great conquest, slaughter, and exultation. These demagogues are known to drink the blood of the enemy spilled in battle and it is said that every drop that passes their lips is added to the great moat of blood surrounding Khorne's citadel of brass. Whether or not this is true, the consumption of this blood marks great physical changes in the Slaughterpriests, who tower over even hulking Chaos Warriors and whose muscle and bone have grown great and hard like stone and corded steel. Slaughterpriests are capable of performing incantations to deliver Khorne's gifts in battle and are known to perform blood rituals and make blood sacrifices in the short times they spend away from the direct pursuit of war."
#hp 35
#str 16
#gcost 260
#prot 6
#rpcost 2
#magicskill 9 2 -- H2
#magicskill 8 1 -- B1
#custommagic 32768  25 -- 25% chance of being B2
#size 4
#att 15
#def 13
#mor 15
#mr 16
#holy
#okleader
#inspirational 1
#weapon 1215 -- slaughteraxe
#armor 311 -- chaos helm
#armor 312 -- chaos plate cuirass
#researchbonus -6
--
#snow
#fireres 5
#berserk 3
#heal
#adeptsacr 1
#douse -1
#maxage 200
#startage 50
#combatcaster
#itemslots 991238 -- normal, no bow
#startitem 1000 -- mark of blood
#startage 60
#maxage 300
#end


---- Bloodthirster (in dominion)

#newmonster 16250
#spr1 "Warhammer_Khorne/Daemon_Bloodthirster.tga"
#spr2 "Warhammer_Khorne/Daemon_Bloodthirster2.tga"
#name "Bloodthirster"
#descr "The Greater Daemons of Khorne are known as Bloodthirsters and they are, save perhaps the mightiest ancient Dragons, the most deadly combatants known to the mortal realms. Each Bloodthirster combines the mind of a master general, supernatural skill beyond the greatest champion, a towering and tireless physical form, and an implacable will to commit savagery and destruction in the name of the Blood God. Even in the Realms of Chaos the Bloodthirsters are feared, for in direct combat they are more than capable of slaying the Greater Daemons of the other Ruinous Powers, in some cases destroying the forms of many of these mighty foes. Each is armed with a great burning axe to strike down single targets and a fiery whip with which to destroy ranks of massed enemies. Such is the sheer will of a Bloothirster that it can distort reality through its presence, expanding the Dominion of its god. As with all Daemons they are more powerful within the Dominion of their God and, as Greater Daemons, they are capable of reforming their body should they be slain in this Dominion.

[Autocasts Bloodletting at battle start]"
--stats compare with keeper of secrets
#hp 76 -- +10
#size 9
#prot 20
#mor 30
#mr 20 -- they have the magic resist 2 rule
#enc 1
#str 22 -- +2
#att 17 -- +1
#def 17
#prec 14 -- +1
#mapmove 28 -- +4
#ap 20 -- -2
#gcost 0
#flying
#weapon 1212 -- burning brass axe (two attacks)
#weapon 1216 -- hellwhip (two attacks)
#weapon 334 -- magical gore from the horned helm
#startitem 1000 -- Mark of blood
#neednoteat
#poisonres 10 -- +10
#diseaseres 100 -- +100
#demon
#magicskill 8 4
#magicskill 9 2 -- H2
#douse -4
#holy
#expertleader
#siegebonus 40
#itemslots 17768454 -- crown only on head, but otherwise full slots, no bow
#wastesurvival
#fear 8 -- +1
--
#expertundeadleader
#holy
#snow
#ambidextrous 10
#domimmortal
#reformtime 3 -- takes 6 months to reform
#notdomshape 16251 -- the weakened form
#maxage 9999
#startage 6666
#nametype 299
#heal --- recuperation ability
#combatcaster
#fireres 10
#coldres 5
#shockres 5
#berserk 4
#stormimmune
#spreaddom 1
#onebattlespell 1411 
#end


---- Bloodthirster (out of dominion)

#newmonster 16251
#spr1 "Warhammer_Khorne/Daemon_Bloodthirster.tga"
#spr2 "Warhammer_Khorne/Daemon_Bloodthirster2.tga"
#name "Bloodthirster"
#descr "The Greater Daemons of Khorne are known as Bloodthirsters and they are, save perhaps the mightiest ancient Dragons, the most deadly combatants known to the mortal realms. Each Bloodthirster combines the mind of a master general, supernatural skill beyond the greatest champion, a towering and tireless physical form, and an implacable will to commit savagery and destruction in the name of the Blood God. Even in the Realms of Chaos the Bloodthirsters are feared, for in direct combat they are more than capable of slaying the Greater Daemons of the other Ruinous Powers, in some cases destroying the forms of many of these mighty foes. Each is armed with a great burning axe to strike down single targets and a fiery whip with which to destroy ranks of massed enemies. Such is the sheer will of a Bloothirster that it can distort reality through its presence, expanding the Dominion of its god. As with all Daemons they are more powerful within the Dominion of their God and, as Greater Daemons, they are capable of reforming their body should they be slain in this Dominion.

[This Bloodthirster is outside of friendly Dominion and has reduced stats and loses a holy level. Autocasts Bloodletting at battle start]"
--stats compared with in dominion version
#hp 64 -- -12
#size 9
#prot 17
#mor 30
#mr 18 -- -2
#enc 1
#str 20 -- -2
#att 16 -- -1
#def 16 -- -1
#prec 13 -- -1
#mapmove 28 -- +4
#ap 20 -- -2
#gcost 0
#flying
#weapon 1212 -- burning brass axe (two attacks)
#weapon 1216 -- hellwhip (two attacks)
#weapon 334 -- magical gore from the horned helm
#startitem 1000 -- Mark of blood
#neednoteat
#poisonres 10
#diseaseres 100
#demon
#douse -3
#magicskill 8 4
#magicskill 9 2
#magicboost 8 -2
#magicboost 9 -1
#holy
#expertleader
#siegebonus 40
#fear 5 -- -3
--
#itemslots 17768454 -- crown only on head, but otherwise full slots, no bow
#wastesurvival
#expertundeadleader
#holy
#snow
#ambidextrous 10
#domimmortal
#reformtime 3 -- takes 6 months to reform
#domshape 16250 -- the stronger form
#maxage 9999
#startage 6666
#nametype 299
#heal --- recuperation ability
#combatcaster
#fireres 10
#coldres 5
#shockres 5
#berserk 4
#stormimmune
#spreaddom 1
#onebattlespell 1411
#end


---------- HEROES



---- Skulltaker

#newmonster 16253
#spr1 "Warhammer_Khorne/Hero_Skulltaker.tga"
#spr2 "Warhammer_Khorne/Hero_Skulltaker2.tga"
#name "Slayer of Kings"
#descr "Skulltaker is the greatest of Khorne's Bloodletters, standing in the favour of the Blood God above any Herald and rivalling the status of the greatest Daemon Princes. Skulltaker is famed for approaching the mightiest strongholds of the other Ruinous Powers deep within the Realms of Chaos and issuing a challenge to single combat to the greatest of the enemy champions. Skulltaker's name is no mere boast, for in addition to the supernatural ability to draw any foe into ritual single combat, the Slayer of Kings is able to tear the head from a worthy challenger and scour it with flames before adding the skull to his master's Throne of Skulls. While other servants of Khorne are frenzied warriors who drink deeply of rage, Skulltaker is an exacting and implacable hunter, often remaining distant and shadowed until the opportunity arises to offer his irresistible challenge. In his hand he wields the great Daemonic blade known as the Slayer Sword, said to have been crafted from a shard of Khorne's wrath. Like a Greater Daemon Skulltaker is highly resistant to physical attacks and immortal within the Dominion of Khorne, but grows weaker outside his master's Realm.

[Skulltaker is only an assassin when within friendly Dominion. This represents him issuing a supernaturally compelling challenge to a foe]"
#ap 14 -- stats compared with herald
#mapmove 20 -- tireless
#hp 35 -- +10
#prot 14
#size 4
#str 18 -- +1
#enc 1 -- daemon
#att 16 -- +1
#def 15 -- +1
#prec 12 -- +1
#mr 18 -- +1
#mor 30
#gcost 0
#rcost 1
#weapon 1203 -- Slayer Sword
#weapon 229 -- flame strike
#armor 312 -- Chaos Plate Cuirass
#armor 305 -- chaos headplate
#startage 999
#maxage 10000
#poisonres 10
#demon
#neednoteat
#ambidextrous 2
--
#goodundeadleader
#goodleader
#command -40 -- so 40 left
#nametype 299 -- Khorne daemon
#heal --- recuperation ability
#holy
#magicskill 9 2
#coldres 5
#fireres 10 -- +5
#snow
#notdomshape 16254 -- out of dominion
#stealthy 0
#assassin
#assencloc 3 -- outdoors locations only
#patience 10
#scalewalls
#combatcaster
#itemslots 991238 -- normal, no bow
#wastesurvival
#fixedname "Skulltaker"
#domimmortal
#reformtime 3 -- takes 6 months to reform
#end


---- Skulltaker(outside of dom)

#newmonster 16254
#spr1 "Warhammer_Khorne/Hero_Skulltaker.tga"
#spr2 "Warhammer_Khorne/Hero_Skulltaker2.tga"
#name "Slayer of Kings"
#descr "Skulltaker is the greatest of Khorne's Bloodletters, standing in the favour of the Blood God above any Herald and rivalling the status of the greatest Daemon Princes. Skulltaker is famed for approaching the mightiest strongholds of the other Ruinous Powers deep within the Realms of Chaos and issuing a challenge to single combat to the greatest of the enemy champions. Skulltaker's name is no mere boast, for in addition to the supernatural ability to draw any foe into ritual single combat, the Slayer of Kings is able to tear the head from a worthy challenger and scour it with flames before adding the skull to his master's Throne of Skulls. While other servants of Khorne are frenzied warriors who drink deeply of rage, Skulltaker is an exacting and implacable hunter, often remaining distant and shadowed until the opportunity arises to offer his irresistible challenge. In his hand he wields the great Daemonic blade known as the Slayer Sword, said to have been crafted from a shard of Khorne's wrath. Like a Greater Daemon Skulltaker is highly resistant to physical attacks and immortal within the Dominion of Khorne, but grows weaker outside his master's Realm.

[Skulltaker is only an assassin when within friendly Dominion. This represents him issuing a supernaturally compelling challenge to a foe]"
#ap 14 -- stats compared with in dominion version
#mapmove 20 -- tireless
#hp 30 -- -5
#prot 12
#size 4
#str 17 -- -1
#enc 1 -- daemon
#att 15 -- -1
#def 14 -- -1
#prec 11 -- -1
#mr 17 -- -1
#mor 30
#gcost 0
#rcost 1
#weapon 1203 -- Slayer Sword
#weapon 229 -- flame strike
#armor 312 -- Chaos Plate Cuirass
#armor 305 -- chaos headplate
#startage 999
#maxage 10000
#poisonres 10
#demon
#neednoteat
#ambidextrous 2
--
#goodundeadleader
#goodleader
#command -40 -- so 40 left
#nametype 299 -- Khorne daemon
#heal --- recuperation ability
#holy
#magicskill 9 2
#coldres 5
#fireres 10 -- +5
#snow
#domshape 16253 -- in dominion
#combatcaster
#itemslots 991238 -- normal, no bow
#wastesurvival
#fixedname "Skulltaker"
#end




---- Skarbrand

#newmonster 16252
#spr1 "Warhammer_Khorne/Hero_Skarbrand.tga"
#spr2 "Warhammer_Khorne/Hero_Skarbrand2.tga"
#name "Exiled One"
#descr "Skarbrand was once the mightiest and most favoured of Khorne's Bloodthirsters and the highest general amongst the Greater Daemons of the Blood God. It was Skarbrand who smashed the first palace of the youngest God Slaanesh, Skarbrand who slew the feared Lord of Change known as Tleth'krr, and Skarbrand who led the Eight Hosts of Murder to defeat the combined forces of all three rival Ruinous Powers. So did Skarbrand sit high in Khorne's esteem, and so did Skarbrand's pride grow until he foolishly tried to challenge the Blood God, suddenly striking his master with all his might. Khorne's great brass armour was barely scratched by the blow, but his rage was terrible to behold. Skarbrand was cast from the highest tower of the Brass Citadel and cursed with the total destruction of his once great mind and boundless ambition, instead becoming an unthinking avatar of rage doomed to gather skulls for Khorne in permanent exile. Skarbrand exists in a constant state of berserker rage and his very presence on the battlefield causes others to enter a similar state, as his madness and rage spreads. Skarbrand long ago discarded his whip in favour of a searing blade known as Carnage and in battle enters such a towering rage that he does not fly, instead charging headlong forward, wings forgotten. As a true exile Skarbrand is unlike other Bloodthirsters and does not grow weaker outside the Dominion of his master, nor will he be able to reform if slain in battle. Though Skarbrand is forever banished from Khorne's favour, his failed coup and subsequent rage is a stark reminder of the Blood God's power and he is both considered sacred and spreads the Dominion of the followers of Khorne."
--stats compared with bloodthirster
#hp 82 -- +6
#size 9
#prot 20
#mor 30
#mr 21 -- +1
#enc 1
#str 24 -- +2
#att 18 -- +1
#def 18 -- +1
#prec 14 -- +1
#mapmove 28 -- +4
#ap 28 -- need this to be high because of the armour and his self berserking
#gcost 0
#flying
#weapon 1223 -- carnage (a fire brand basically)
#weapon 1212 -- burning brass axe (two attacks)
#weapon 334 -- magical gore from the horned helm
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#neednoteat
#poisonres 10 -- +10
#diseaseres 100 -- +100
#demon
#holy
#fear 10 -- +2
--
#itemslots 991238 -- normal, no bow
#wastesurvival
#noleader
#siegebonus 60
#holy
#spreaddom 1
#snow
#ambidextrous 10
#maxage 9999
#startage 6666
#fixedname "Skarbrand"
#heal --- recuperation ability
#fireres 15
#coldres 5
#shockres 5
#startitem 942
#berserk 5
#stormimmune
#onebattlespell 1411
#end


-- Scylla Anfringrimm

#newmonster 16302
#spr1 "Warhammer_Khorne/Hero_Scylla.tga"
#spr2 "Warhammer_Khorne/Hero_Scylla2.tga"
#name "Bloodbeast"
#descr "Scylla Anfingrimm, known also as the Bloodbeast, was once a mighty Chaos Lord of Khorne, perhaps the greatest of his time. In his former life, he was nigh-invincible and unmatched in battle, having slain some of the fiercest beasts and armies in service to his God and raided the coastlines from frozen Norsca to exotic Ind. No other had so quickly climbed the ranks of the Blood God's esteem and many amongst his tribe, the vicious warriors of the Ironpelt, had boldly claimed that it would not be long until their ruler was visited by Khorne with the greatest gift of Daemonhood. In a sense, they were right. It was when Scyla had single-handedly slaughtered the bestial Gorgers of Undermountain, only the latest in a long litany of mighty and unimaginably violent deeds, that he was granted his final boon. But so passionate was Scylla for the gifts of the Blood God that this mutation, in addition to the multitudes he already possessed, proved too much for his mortal form and his transformation into a Chaos Spawn was complete. Khorne did not abandon Scylla, for the mortal had pleased the Blood God greatly, and so Scylla's mind was not entirely destroyed by the transformation and he was given a new, stable form of great physical might. Scylla became a giant, raging weapon of Khorne's will with strength and size beyond that of even the Daemon Princes. The Bloodbeast is so clearly blessed by Khorne that he spreads the dominion of his God as he rampages across the mortal realms."
#hp 113
#size 9
#prot 20
#mor 30
#mr 18
#enc 2
#str 27
#att 12
#def 10
#prec 8
#mapmove 22
#ap 18
#gcost 0
#digest 10
#weapon 33 -- claws x2
#weapon 609 -- grab and swallow
#weapon 1168 -- Giant Stomp
#weapon 631 -- serpent tail
#holy
#spreaddom 1
#noleader
#siegebonus 40
#startage 700
#maxage 5000
#fear 8
#coldres 5
#shockres 5
#fireres 10
#heal
#poisonres 10
#fixedname "Scylla Anfingrimm"
#berserk 4
#itemslots 17768448 -- two misc, one foot, body, crown only head slot
#diseaseres 100 -- +100
#snow
#startitem 941 -- mark of rage
#end


---- Arbaal the undefeated

#newmonster 14837
#copystats 16199 -- warrior template
#spr1 "Warhammer_Khorne/Hero_Arbaal.tga"
#spr2 "Warhammer_Khorne/Hero_Arbaal2.tga"
#name "Undefeated"
#descr "Arbaal the Undefeated, also known as the Destroyer of Khorne, is an ancient and powerful Chaos Lord who first ventured into the Realm of Khorne hundreds of years ago seeking a worthy foe. When Arbaal returned he brought with him two gifts from his God, a great Flesh Hound as a mount and the infamous Destroyer Axe of Khorne which grants him tireless energy to devote to violence. Arbaal has never known defeat in single combat and in battle is a whirling force of destruction, slaughtering lesser foes that dare stand in his way and butchering even mighty champions in mere moments. That said, Arbaal is no mere thug, his mind is as tactical and sharp as that of any other Chaos Lord and he has led many great Chaos warhosts to victory."
--stats compared with chaos lord
#hp 50 -- +5
#mor 18
#mr 18
#str 17 -- +1
#att 17
#def 16 -- +1
#prec 14
#gcost 0
#rpcost 2
#expertleader
#ambidextrous 3
#weapon 1299 -- Destroyer Axe
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#holy
#size 4
#goodundeadleader
#darkvision 100
#heal
#siegebonus 35
#skilledrider 4 -- +1
#mountmnr 14838 -- great flesh hound
#unmountedspr1 "Warhammer_Khorne/Hero_Arbaal_Unmounted.tga"
#unmountedspr2 "Warhammer_Khorne/Hero_Arbaal_Unmounted2.tga"
#startage 800
#maxage 1500
#fixedname "Arbaal"
#reinvigoration 3
#end


---- Great Fleshhound

#newmonster 14838
#spr1 "Warhammer_Khorne/Hero_Arbaal_Mount.tga"
#spr2 "Warhammer_Khorne/Hero_Arbaal_Mount2.tga"
#name "Great Flesh Hound"
#descr "Flesh Hounds are rapacious wolf-like Daemons, both reptilian and savagely canine in aspect. They are Khorne's trackers and hunters, lithe yet powerful, able to dart aside from a swordsman's strike and deliver a crushing bite in a single fluid movement. Khorne treats his Hounds with rare indulgence and lavishes them with generous gifts, including the brass collars which grant them considerable magic resistance. Flesh Hounds are agents of Khorne's vengeance and known for tracking down those who raise their master's ire relentlessly across any terrain. Arbaal rides into battle atop a Flesh Hound of unusual size and prowess which is able to maintain its power outside the Dominion of its God."
--- stats compared with in dominion flesh hound
#ap 26
#mapmove 28
#hp 37 -- +17
#prot 11 -- +2
#size 5 -- +1
#str 18 -- +3
#enc 1
#att 14 -- +1
#def 13 -- +1
#prec 12
#mr 18 -- +1
#mor 30
#gcost 0
#rcost 1
#weapon 1209 -- bite, magical
#weapon 1199 -- claw, magical
#startage 44
#maxage 10000
#poisonres 10
#fireres 5
#shockres 5
#demon
#neednoteat
#spiritsight
#nametype 299 -- khorne daemon
#patrolbonus 5 -- sort of standard really good patrol bonus
#heal --- recuperation ability
#coldres 5
#snow
#swimming
#animal
#mountainsurvival
#forestsurvival
#wastesurvival
#swampsurvival
#holy
#end



----------SITES


------ Tower of Brass

#newsite 2186
#name "Tower of Brass"
#path 0 -- fire
#level 0
#rarity 5
#gems 0 3 -- 3 fire
#gems 3 3 -- 3 earth
#res 80 -- 80 resources
#homecom 16237 -- Exalted Hero
#homecom 16228 -- Speaker of Brass
#homecom 16229 -- Ragesmith
#homemon 16217 -- Chosen
#homemon 16239 -- Chosen Knight
#end


-----------FUTURESITES

#newsite 2187
#name "Khorne Summons and Other"
#path 8 -- blood
#level 0
#rarity 5
#homemon 16255 -- Bloodletter
#homemon 16257 -- Bloodcrusher
#homemon 16232 -- juggernaut
#homemon 16265 -- Flesh Hound
#homecom 16260 -- herald of khorne
#homecom 16270 -- daemon prince
#homecom 16250 -- bloodthirster
#end

#newsite 2188
#name "Khorne Commander Promotions"
#path 0 -- fire
#level 0
#rarity 5
#homecom 16223 -- Aspiring Champion
#homecom 16237 -- Exalted Hero
#homecom 16267 -- Chaos Lord
#homecom 16270 -- daemon prince
#end

#newsite 2189
#name "Khorne Troop Promotions"
#path 5 -- death
#level 0
#rarity 5
#homemon 16205 -- Warrior
#homemon 16225 -- Warrior
#homemon 16217 -- Chosen
#homemon 16214 -- Knight
#homemon 16239 -- Chosen Knight
#homemon 16218 -- Forsaken Warrior
#end

#newsite 2190
#name "Khorne Spawn"
#path 8 -- blood
#level 0
#rarity 5
#homemon 16219
#homemon 16244
#homemon 16247
#homemon 16271
#homemon 16274
#homemon 16277
#homemon 16280
#homemon 16283
#homemon 16286
#homemon 16289
#end

#newsite 2191
#name "Khorne Multiheroes"
#path 4 -- astral
#level 0
#rarity 5
#homecom 16267 -- Chaos Lord
#homecom 16260 -- herald of khorne
#end

#newsite 2192
#name "Khorne Luck-independent Heroes"
#path 9 -- holy
#level 0
#rarity 5
#homecom 16302 -- scylla anfingrimm
#homecom 16252 -- skarbrand
#homecom 16253 -- skulltaker
#homecom 14837 -- arbaal the undefeated
#end

--Khorne site that indicates whether the province was conquered this turn

#newsite 2000
#name "Khorne"
#path 9 -- holy, to help it hide
#level 9 -- to make it found less often
#rarity 5
#end

-------- SPELLS

----- Bloodfrenzy (the AOE portion of the Bloodbath autospell)

#newspell
#name "Bloodfrenzy"
#desc "Khorne's warriors are invigorated at the scent of fresh blood."
#effect 8
#damage 8
#restricted 170
#researchlevel 4
#school -1 -- can't be researched
#path 0 8
#pathlevel 0 1
#aoe 8
#range 1
#prec 0
#spec 550109312
#explspr 10123 -- red puffs
#sound 0 -- no sound?
#end

----- Bloodbath (an autospell for Khorne's priests)

#newspell
#name "Bloodbath"
#descr "Khorne's priests relish any blood spilled in battle."
#effect 11
#damage 8192
#restricted 170
#researchlevel 4
#school -1 -- can't be researched
#path 0 8
#pathlevel 0 1
#fatiguecost 10
#range 1
#prec 100
#spec 537415808
#explspr 10123 -- red puffs
#sound 0 -- no sound?
#nextspell "Bloodfrenzy"
#end

---- Wave of Rage

#newspell
#copyspell "Touch of Madness" -- checked
#name "Wave of Rage"
#descr "Skarbrand's hit everyone berserk spell."
#restricted 170
#researchlevel 4
#school -1 -- can't be researched
#path 0 8
#pathlevel 0 1
#fatiguecost 10
#range 10
#aoe 663 -- 50% of whole battlefield
#spec 135168 -- everyone, mr negates, mindless immune
#explspr 10123 -- red puffs
#sound 0 -- no sound?
#end

----- Skulls for the Throne of Skulls -- holy spell, gives giant strength, smaller aoe

#newspell
#copyspell "Gift of Giant Strength"
#name "Skulls for the Throne of Skulls"
#descr "Raising a bloody weapon to the skies, the servant of the Blood God exhorts the warriors of Khorne to prove themselves worthy of Khorne's gifts and enhances their strength considerably."
#details "Identical to Gift of Giant Strength other than paths, -5 range, larger static aoe."
#restricted 170
#researchlevel 4 -- 1 higher than GoGS, 1 lower than GSW
#path 0 9 -- holy
#pathlevel 0 2
#school 6
#range 10 -- -5 from SoG
#aoe 8 -- rather than 3+, 8 is the sacred number for khorne
#explspr 10003 -- red droplet stuff
#end


----- Blood for the Blood God

#newspell
#copyspell "Touch of Madness" -- checked
#name "Blood for the Blood God"
#descr "With a howl of rage the servant of the Blood God stokes the fury of a group of Khorne's followers, driving them into a berserker frenzy."
#details "Identical to Touch of Madness other than paths, -10 range, +3 aoe, +10 fatigue."
#restricted 170
#path 0 9 -- holy
#pathlevel 0 2
#school 6
#range 10
#aoe 4
#explspr 10123 -- red puffs
#fatiguecost 40
#end


---- Brass Warriors

#newspell
#copyspell "Ironskin" -- checked
#name "Skin of Brass"
#descr "The caster channels the energy of the daemonic brass of Khorne to coat the hide of some of Khorne's warriors."
#details "Identical to Ironskin other than paths, +10 fatigue."
#restricted 170
#path 0 3 -- earth
#path 1 0 -- fire
#pathlevel 0 1
#pathlevel 1 1
#fatiguecost 50
#end


---- Create Spawn

#newspell
#name "Create Chaos Spawn of Khorne"
#descr "Chaos Spawn are typically the result of one on the Path of the Champion displeasing or simply failing to sufficiently impress or amuse their patron God, but there are other ways by which they can be birthed from a magical laboratory to plague the world of mortals. This ritual creates a single Chaos Spawn, the form of which can vary greatly. Though they are truly creatures of Chaos they are not Daemons."
#path 0 8 -- blood
#pathlevel 0 1
#school 6 -- blood
#fatiguecost 300 -- 3 blood slaves
#damage -1047 -- generic spawn montag
#nreff 1
#effect 10001
#researchlevel 1
#restricted 170
#end


---- Summon Bloodletter

#newspell
#name "Summon Bloodletter"
#descr "This ritual calls forth a single Bloodletter from the Realm of Khorne. Bloodletters are the most numerous of Khorne's servants and the least, but still formidable warriors armed with life draining Hellblades. Like all Daemons they are considerably weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 9 -- holy
#pathlevel 0 1
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 200 -- 2 blood slaves
#damage 16255 -- bloodletter
#nreff 1
#effect 10001
#researchlevel 2
#restricted 170
#end


---- Summon Bloodletter Squad

#newspell
#name "Summon Bloodletter Squad"
#descr "This ritual calls forth a squad of vicious Bloodletters from the Realm of Khorne. Bloodletters are the most numerous of Khorne's servants and the least, but still formidable warriors armed with life draining Hellblades. Like all Daemons they are considerably weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 9 -- holy
#pathlevel 0 1
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 3200 -- 32 blood slaves
#damage 16255 -- bloodletter
#nreff 17
#effect 10001
#researchlevel 4
#restricted 170
#end


---- Summon Bloodcrusher of Khorne

#newspell
#name "Summon Bloodcrusher of Khorne"
#descr "This ritual calls forth a single Bloodcrusher from the Realm of Khorne. Only the most favoured of Khorne's Bloodletters earn the right to join the ranks of the Bloodcrushers, regiments of Bloodletters that ride into battle atop Daemonic Juggernauts. Bloodcrushers are in some ways similar to Chosen Knights and though the riders are far less armoured their Hellblade arguably makes up for this fact. As with all Daemons of Chaos these monstrous cavalry are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 9 -- holy
#pathlevel 0 2
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 700 -- 7 blood slaves
#damage 16257 -- bloodcrusher
#nreff 1
#effect 10001
#researchlevel 3
#restricted 170
#end


---- Summon Flesh Hounds of Khorne

#newspell
#name "Summon Flesh Hounds of Khorne"
#descr "This ritual calls forth a pair of hunting Flesh Hounds of Khorne, the sacred pets of the Blood God. Flesh Hounds are relentless hunters with collars that protect them from hostile magic, typically sent by Khorne to tear apart more vulnerable foes."
#path 0 8 -- blood
#path 1 9 -- holy
#pathlevel 0 1
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 1100 -- 11 blood slaves
#damage 16265 -- Flesh Hound
#nreff 3
#effect 10001
#researchlevel 4
#restricted 170
#end


---- Summon Flesh Hound Pack

#newspell
#name "Summon Pack of Flesh Hounds"
#descr "This ritual calls forth a pack of hunting Flesh Hounds of Khorne, the sacred pets of the Blood God. Flesh Hounds are relentless hunters with collars that protect them from hostile magic, typically sent by Khorne to tear apart more vulnerable foes."
#path 0 8 -- blood
#path 1 9 -- holy
#pathlevel 0 2
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 5200 -- 52 blood slaves
#damage 16265 -- Flesh Hound
#nreff 17
#effect 10001
#researchlevel 5
#restricted 170
#end


---- Summon Bloodcrushers of Khorne

#newspell
#name "Summon Crash of Bloodcrushers"
#descr "This ritual calls forth a crash of Bloodcrushers from the Realm of Khorne. Only the most favoured of Khorne's Bloodletters earn the right to join the ranks of the Bloodcrushers, regiments of Bloodletters that ride into battle atop Daemonic Juggernauts. Bloodcrushers are in some ways similar to Chosen Knights and though the riders are far less armoured their Hellblade arguably makes up for this fact. As with all Daemons of Chaos these monstrous cavalry are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 9 -- holy
#pathlevel 0 2
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 4200 -- 42 bloodslaves
#damage 16257 -- bloodcrusher
#nreff 7
#effect 10001
#researchlevel 6
#restricted 170
#end


---- Contact Herald of Khorne

#newspell
#name "Contact Herald of Khorne"
#descr "This ritual contacts one the Heralds of Khorne, favoured commanders within the armies of the Blood God. These serve not only as the commanders of the regiments of Bloodletters that make up much of Khorne's vast army but as takers of skulls that can duel and kill the greatest champions of those who stand against the Blood God. Much like the mortal Slaughterpriests the Heralds of Khorne are able to extend Khorne's blessings to his most favoured servants and see to the erection of temples honouring the Lord of Skulls. While the rank and file Bloodletter takes delight in wearing no encumbering armour and proving its sheer skill in battle, Heralds are far more disciplined and cold in their rage and seek only to carry out Khorne's wishes, so wear Daemonic plate. Khorne has a great hatred for those who would cower behind walls of stone rather than do battle and as such his Heralds have an innate understanding of how to break into besieged fortifications. As with all Daemons of Chaos these emissaries of wrath and conquest are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 9 -- holy
#pathlevel 0 1
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 1800 -- 18 blood slaves
#damage 16260 -- Herald of Khorne
#nreff 1
#effect 10021 -- summon commander
#researchlevel 4
#restricted 170
#end


---- Contact Daemon Prince

#newspell
#name "Contact Daemon Prince of Khorne"
#descr "This ritual contacts a Daemon Prince, a former Chaos Lord who has achieved the ultimate goal of immortality at the hand of their patron God. Daemon Princes of Khorne tend to hold a roughly humanoid shape, though typically with lower limbs more reminiscent than those of a Bloodletter or Bloodthrister, and greatly increased size as well as other alterations pleasing to the Blood God. Unlike the Daemon Princes of the other Ruinous Powers those of Khorne do not use magic at all, instead relying on their great physical strength and incredible martial prowess, as well as Daemonic weapons and armour gifted to them by Khorne. As representatives of Khorne's power and symbols of the rewards that can be gained in the service of the Blood God, Daemon Princes have priestly authority. While they are Daemons in form their past in the mortal world grants Daemon Princes the benefit of not becoming weaker outside the Dominion of their God, though like Greater Daemons they can still only reform their bodies if slain in this Dominion."
#path 0 8 -- blood
#path 1 9 -- holy
#pathlevel 0 3
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 9000 -- 90 blood slaves -- cheaper than magical versions
#damage 16270 -- daemon prince
#nreff 1
#effect 10021 -- summon commander
#researchlevel 5
#restricted 170
#end


---- Contact Bloodthirster

#newspell
#name "Contact Bloodthirster"
#descr "This ritual contacts a Bloodthirster, a Greater Daemon of Khorne. Each Bloodthirster combines the mind of a master general, supernatural skill beyond the greatest champion, a towering and tireless physical form, and an implacable will to commit savagery and destruction in the name of the Blood God. Even in the Realms of Chaos the Bloodthirsters are feared, for in direct combat they are more than capable of slaying the Greater Daemons of the other Ruinous Powers, in some cases destroying the forms of many of these mighty foes. Khorne has a deep contempt for sorcery and Bloodthirsters use no magic save their daemonic armaments, though they are of Khorne's essence and may act as powerful priests in the Blood God's cause. Each is armed with a great burning axe to strike down single targets and a fiery whip with which to destroy ranks of massed enemies. As with all Daemons they are more powerful within the Dominion of their God and, as Greater Daemons, they are capable of reforming their body should they be slain in this Dominion."
#path 0 8 -- blood
#path 1 9 -- holy
#pathlevel 0 3
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 12700 -- 127 blood slaves
#damage 16250 -- bloodthirster
#nreff 1
#effect 10021 -- summon commander
#researchlevel 6
#restricted 170
#end


------- NATION

#selectnation 170
#name "Khorne"
#epithet "Blood for the Blood God"
#bloodnation
#sacrificedom
#color 0.6 0.1 0.1 -- red
#era 2
#brief "Khorne is one of the four Ruinous Powers, the Gods of Chaos that draw strength from the darkest mortal emotions and drives. Khorne is known as the Blood God and Lord of Skulls, for their domain is violence, battle, rage, glory, and murder. The followers of Khorne are many and varied, but all seek reward from their patron God."
#descr "Khorne is one of the four Ruinous Powers, the Gods of Chaos that draw strength from the darkest mortal emotions and drives. Khorne is known as the Blood God and Lord of Skulls, for their domain is violence, battle, rage, glory, and murder. Each of the Ruinous Powers seeks dominion over the realms of mortals and advantage over their siblings, for to them all life is but a game. Greatest in number of the followers of Slaanesh are the Marauders, hardened human warriors from the tribes that surround the Chaos Wastes and are sometimes joined by Ogres or Trolls drawn by the prospect of great reward. Above the Marauders in status are the Chaos Warriors, elite fighters blessed with martial prowess and physical strength, and the Chosen Warriors who show Khorne's direct favour. Commanding the followers of Khorne are Champions, Exalted Heroes, and Chaos Lords, each of which seeks to some day ascend to immortality in the form of a Daemon Prince, though most on this path will die in battle or fail to meet Khorne's standards and be twisted into a Chaos Spawn. Finally the Daemons of Khorne are the most direct and horrifying servants of the Blood God, for they are the essence of Khorne given form and unleashed upon the world."
#summary "Race: Hardened humans with partial fire resistance, beasts of Chaos.
Military: Exceptional heavy infantry and cavalry, medium infantry, few ranged weapons. Some troops and commanders can earn promotion, or damnation
Magic: Weak. Some blood, earth, fire, and death
Priests: Average. May perform blood sacrifice. Daemons weaken outside your dominion
Mechanics: Conquering territory with enemy candles grants bloodslaves. Weak blood searching. Cannot forge Dowsing Rod"
#flag "Warhammer_Khorne/Khorne_Flag.tga"
#startsite "Tower of Brass"
#templepic 0
#fortera 2 -- normal for MA
#idealcold -2
#defsloth -1
#defdrain 2
#defchaos 2
#moreorder -2 -- so the minimum is 2, you can go to 3 for extra points, you get no extra points from 4 or 5
#moremagic -2
#moreheat 1
#moreprod 1
#fireblessbonus 1
#bloodblessbonus 1
#disbless "Heroism"

#futuresite 2187
#futuresite 2188
#futuresite 2189
#futuresite 2190
#futuresite 2191
#futuresite 2192

----------TROOPS

#addrecunit 16201 -- Chaos Warhound (recruitable montag)
#addrecunit 16204 -- Marauder (recruitable montag)
#addrecunit 16203 -- Marauder Hunter (javelins, spear)
#addrecunit 16210 -- Berserker (two axes)

#addrecunit 16234 -- Marauder Horseman (javelin)
#addrecunit 16235 -- Marauder Horseman (axe and throwing axes)

#addrecunit 13997 -- Warrior of Khorne (recruitment)
#addrecunit 16214 -- Knight of Khorne
--addrecunit 16217 -- Chosen of Khorne
--addrecunit 16239 -- Chosen Knight of Khorne

#addrecunit 16216 -- Chaos Ogre
#addrecunit 14652 -- chaos troll
--addrecunit 16255 -- bloodletter
--addrecunit 16257 -- bloodcrusher
--addrecunit 16265 -- Flesh Hound

#addforeignunit 16204 -- Marauder (recruitable montag)
#addforeignunit 16203 -- Marauder Hunter (javelins, spear)
#addforeignunit 16234 -- Marauder Horseman (axe, throwing axes)


----------LEADERS


#addreccom 16259 -- Marauder chieftain
#addreccom 16304 -- Marauder Horsemaster
#addreccom 16223 -- Aspiring Champion
--addreccom 16237 -- Exalted Hero -- cap only
#addreccom 16243 -- Marauder Shaman
--addreccom 16228 -- Speaker of Brass -- cap only
#addreccom 16227 -- Disciple of Brass
#addreccom 16230 -- Slaughterpriest
--addreccom 16260 -- herald of khorne
--addreccom 14252 -- keeper of secrets
--addreccom ???? -- exalted bloodthirster
--addreccom 16302 -- scylla anfingrimm
--addreccom 16253 -- skulltaker
--addreccom 16268 -- chaos lord judgement

#addforeigncom 16259 -- Marauder chieftain
#addforeigncom 16304 -- Marauder Horsemaster


-----------GODS (reviewed)

#addgod 120 -- moloch
#addgod 180 -- demilich
#addgod 216 -- red dragon
#addgod 246 -- freak lord
#addgod 265 -- blue dragon
#addgod 266 -- green dragon
#addgod 269 -- wyrm
#addgod 383 -- prince of death
#addgod 388 -- neter of chaos
#addgod 486 -- great warlock
#addgod 500 -- skratti
#addgod 604 -- teotl of the night
#addgod 607 -- baphomet
#addgod 655 -- scorpion king
#addgod 656 -- fountain of blood
#addgod 657 -- monolith
#addgod 957 -- lord of the desert sun
#addgod 978 -- great black bull
#addgod 1096 -- destroyer of worlds
#addgod 1229 -- son of fenrer
#addgod 1230 -- titan of the forge
#addgod 1340 -- tiwaz of war
#addgod 1341 -- devi of darkness
#addgod 1345 -- celestial general
#addgod 1379 -- keeper of the bridge
#addgod 1428 -- bakemono kunshu
#addgod 1899 -- fomorian god king
#addgod 2082 -- son of the fallen
#addgod 2203 -- oni kunshu
#addgod 2315 -- melqart
#addgod 2442 -- teotl of war
#addgod 2447 -- idol of men
#addgod 2448 -- idol of beasts
#addgod 2461 -- statue of the blood mother
#addgod 2462 -- golden idol
#addgod 2463 -- statue of war
#addgod 2465 -- statue of war
#addgod 2553 -- ahura of the oath
#addgod 2608 -- azi
#addgod 2610 -- angra mainyu
#addgod 2611 -- gannag menog
#addgod 2627 -- daeva of wrath
#addgod 2783 -- drakon
#addgod 2788 -- man eater
#addgod 2795 -- dog of underworld
#addgod 2796 -- hound of hades
#addgod 3081 -- dui of war
#addgod 3088 -- dharmapala of the underworld
#addgod 3121 -- eldest cyclops
#addgod 3368 -- bronze colossus
#addgod 3416 -- great archon
#addgod 3641 -- earth dragon


-----------HEROES

#multihero1 16267 -- Chaos Lord
#multihero2 16260 -- herald of khorne
#multihero3 16228 -- Speaker of Brass

-----------PROVINCE DEFENSE

#defcom1 16259 -- Marauder chieftain
#defcom2 16243 -- Marauder Shaman

#defunit1 16207 -- marauder axe shield
#defunit1b 16203 -- marauder hunter
#defunit2 -1042 -- marauder montag
#defunit2b -1041 -- hound montag
#defmult1 12
#defmult1b 8
#defmult2 10
#defmult2b 15

#wallcom 16203 -- Marauder Hunter (javelins, spear)
#wallunit 16203 -- Marauder Hunter (javelins, spear)
#wallmult 8 -- vanheim gets 6 worse things

#guardcom 16259 -- Marauder chieftain
#guardunit 16207 -- marauder axe and shield
#guardmult 8
#guardunit 16213 -- hound
#guardmult 6


#startcom 16259 -- Marauder chieftain
#startunittype1 16207 -- axe and shield marauders
#startunitnbrs1 20
#startunittype2 16203 -- Marauder Hunter (javelins, spear)
#startunitnbrs2 10
#startscout 16223 -- Aspiring Champion
#end



---------- NAMES

-- Khorne Warrior names

#selectnametype 298
#addname "Voron Charnelmonger"
#addname "Krask Charnelhound"
#addname "Thorm Charneltearer"
#addname "Brak Charnelsplitter"
#addname "Skol Charnelreaper"
#addname "Angrim Charnel"
#addname "Borlat Charneldog"
#addname "Chor Charnelfist"
#addname "Damak Charnelskull"
#addname "Ekron Charnelfangs"
#addname "Frag Charnelkill"
#addname "Gorman Charnelbringer"
#addname "Holk Charnelgod"
#addname "Iago Charnelspawn"
#addname "Jerlo Charnelflesh"
#addname "Krask Charnelcutter"
#addname "Larg Charnellord"
#addname "Maul Charnelspike"
#addname "Nostom Charnelaxe"
#addname "Orlack Gorepounder"
#addname "Prug Gorecrusher"
#addname "Qybur Gorefeaster"
#addname "Rom Goreslick"
#addname "Skol Gorespray"
#addname "Thorm Goremonger"
#addname "Urlat Gorehound"
#addname "Vythe Goretearer"
#addname "Warram Goresplitter"
#addname "Xan Gorereaper"
#addname "Yor Gore"
#addname "Zhab Goredog"
#addname "Argath Gorefist"
#addname "Blut Strangleskull"
#addname "Creed Stranglefangs"
#addname "Dosk Stranglekill"
#addname "Eon Stranglebringer"
#addname "Feorth Stranglegod"
#addname "Grisel Stranglespawn"
#addname "Howl Strangleflesh"
#addname "Imthor Stranglecutter"
#addname "Jarl Stranglelord"
#addname "Kezzig Stranglespike"
#addname "Larno Strangleaxe"
#addname "Mung Crushpounder"
#addname "Narlan Crushcrusher"
#addname "Orskath Crushfeaster"
#addname "Pragg Crushslick"
#addname "Ramtar Crushspray"
#addname "Slash Crushmonger"
#addname "Thrag Crushhound"
#addname "Zolt Crushtearer"
#addname "Voron Organsplitter"
#addname "Krask Organreaper"
#addname "Thorm Organ"
#addname "Brak Organdog"
#addname "Skol Organfist"
#addname "Angrim Organskull"
#addname "Borlat Organfangs"
#addname "Chor Organkill"
#addname "Damak Organbringer"
#addname "Ekron Organgod"
#addname "Frag Organspawn"
#addname "Gorman Organflesh"
#addname "Holk Organcutter"
#addname "Iago Organlord"
#addname "Jerlo Organspike"
#addname "Krask Organaxe"
#addname "Larg Organpounder"
#addname "Maul Organcrusher"
#addname "Nostom Organfeaster"
#addname "Orlack Organslick"
#addname "Prug Organspray"
#addname "Qybur Organmonger"
#addname "Rom Throathound"
#addname "Skol Throattearer"
#addname "Thorm Throatsplitter"
#addname "Urlat Throatreaper"
#addname "Vythe Throat"
#addname "Warram Throatdog"
#addname "Xan Throatfist"
#addname "Yor Throatskull"
#addname "Zhab Throatfangs"
#addname "Argath Throatkill"
#addname "Blut Throatbringer"
#addname "Creed Throatgod"
#addname "Dosk Skullspawn"
#addname "Eon Skullflesh"
#addname "Feorth Skullcutter"
#addname "Grisel Skulllord"
#addname "Howl Skullspike"
#addname "Imthor Skullaxe"
#addname "Jarl Skullpounder"
#addname "Kezzig Skullcrusher"
#addname "Larno Skullfeaster"
#addname "Mung Skullslick"
#addname "Narlan Skullspray"
#addname "Orskath Skullmonger"
#addname "Pragg Skullhound"
#addname "Ramtar Skulltearer"
#addname "Slash Skullsplitter"
#addname "Thrag Skullreaper"
#addname "Zolt Skull"
#addname "Voron Skulldog"
#addname "Krask Deathfist"
#addname "Thorm Deathskull"
#addname "Brak Deathfangs"
#addname "Skol Deathkill"
#addname "Angrim Deathbringer"
#addname "Borlat Deathgod"
#addname "Chor Deathspawn"
#addname "Damak Deathflesh"
#addname "Ekron Deathcutter"
#addname "Frag Deathlord"
#addname "Gorman Deathspike"
#addname "Holk Deathaxe"
#addname "Iago Deathpounder"
#addname "Jerlo Deathcrusher"
#addname "Krask Deathfeaster"
#addname "Larg Deathslick"
#addname "Maul Slaughterspray"
#addname "Nostom Slaughtermonger"
#addname "Orlack Slaughterhound"
#addname "Prug Slaughtertearer"
#addname "Qybur Slaughtersplitter"
#addname "Rom Slaughterreaper"
#addname "Skol Slaughter"
#addname "Thorm Slaughterdog"
#addname "Urlat Slaughterfist"
#addname "Vythe Slaughterskull"
#addname "Warram Slaughterfangs"
#addname "Xan Slaughterkill"
#addname "Yor Slaughterbringer"
#addname "Zhab Slaughtergod"
#addname "Argath Slaughterspawn"
#addname "Blut Slaughterflesh"
#addname "Creed Slaughtercutter"
#addname "Dosk Bladelord"
#addname "Eon Bladespike"
#addname "Feorth Bladeaxe"
#addname "Grisel Bladepounder"
#addname "Howl Bladecrusher"
#addname "Imthor Bladefeaster"
#addname "Jarl Bladeslick"
#addname "Kezzig Bladespray"
#addname "Larno Blademonger"
#addname "Mung Bladehound"
#addname "Narlan Bladetearer"
#addname "Orskath Bladesplitter"
#addname "Pragg Bladereaper"
#addname "Ramtar Sword"
#addname "Slash Sworddog"
#addname "Thrag Swordfist"
#addname "Zolt Swordskull"
#addname "Voron Swordfangs"
#addname "Krask Swordkill"
#addname "Thorm Swordbringer"
#addname "Brak Sword"
#addname "Skol Swordspawn"
#addname "Angrim Swordflesh"
#addname "Borlat Swordcutter"
#addname "Chor Swordlord"
#addname "Damak Swordspike"
#addname "Ekron Spearaxe"
#addname "Frag Spearpounder"
#addname "Gorman Spearcrusher"
#addname "Holk Spearfeaster"
#addname "Iago Spearslick"
#addname "Jerlo Spearspray"
#addname "Krask Spearmonger"
#addname "Larg Spearhound"
#addname "Maul Weapontearer"
#addname "Nostom Weaponsplitter"
#addname "Orlack Weaponreaper"
#addname "Prug Weapon"
#addname "Qybur Weapondog"
#addname "Rom Weaponfist"
#addname "Skol Weapon"
#addname "Thorm Weaponfangs"
#addname "Urlat Heartkill"
#addname "Vythe Heartbringer"
#addname "Warram Heartgod"
#addname "Xan Heartspawn"
#addname "Yor Heart"
#addname "Zhab Heartcutter"
#addname "Argath Heartlord"
#addname "Blut Heartspike"
#addname "Creed Heartaxe"
#addname "Dosk Heartpounder"
#addname "Eon Thrashcrusher"
#addname "Feorth Thrashfeaster"
#addname "Grisel Thrashslick"
#addname "Howl Thrashspray"
#addname "Imthor Thrashmonger"
#addname "Jarl Thrashhound"
#addname "Kezzig Thrashtearer"
#addname "Larno Thrashsplitter"
#addname "Mung Thrashreaper"
#addname "Narlan Thrash"
#addname "Orskath Thrashdog"
#addname "Pragg Thrash"
#addname "Ramtar Thrashskull"
#addname "Slash Thrash"
#addname "Thrag Brasskill"
#addname "Zolt Brassbringer"
#addname "Voron Brassgod"
#addname "Krask Brassspawn"
#addname "Thorm Brassflesh"
#addname "Brak Brasscutter"
#addname "Skol Brasslord"
#addname "Angrim Brassspike"
#addname "Borlat Brassaxe"
#addname "Chor Brass"
#addname "Damak Brasscrusher"
#addname "Ekron Brassfeaster"
#addname "Frag Brassslick"
#addname "Gorman Brassspray"
#addname "Holk Brassmonger"
#addname "Iago Brasshound"
#addname "Jerlo Brasstearer"
#addname "Krask Brasssplitter"
#addname "Larg Brassreaper"
#addname "Maul Brass"
#addname "Nostom Brassdog"
#addname "Orlack Brassfist"
#addname "Prug Brassskull"
#addname "Qybur Brassfangs"
#addname "Rom Brass"
#addname "Skol Brassbringer"
#addname "Thorm Brassgod"
#addname "Urlat Visceraspawn"
#addname "Vythe Visceraflesh"
#addname "Warram Visceracutter"
#addname "Xan Visceralord"
#addname "Yor Visceraspike"
#addname "Zhab Visceraaxe"
#addname "Argath Viscerapounder"
#addname "Blut Visceracrusher"
#addname "Creed Viscera"
#addname "Dosk Visceraslick"
#addname "Eon Visceraspray"
#addname "Feorth Visceramonger"
#addname "Grisel Viscerahound"
#addname "Howl Spinetearer"
#addname "Imthor Spinesplitter"
#addname "Jarl Spinereaper"
#addname "Kezzig Spine"
#addname "Larno Spinedog"
#addname "Mung Spinefist"
#addname "Narlan Spineskull"
#addname "Orskath Gutfangs"
#addname "Pragg Gutkill"
#addname "Ramtar Gutbringer"
#addname "Slash Gutgod"
#addname "Thrag Gutspawn"
#addname "Zolt Gutflesh"
#addname "Voron Sinewcutter"
#addname "Krask Sinewlord"
#addname "Thorm Sinewspike"
#addname "Brak Sinewaxe"
#addname "Skol Sinewpounder"
#addname "Angrim Sinewcrusher"
#addname "Borlat Sinewfeaster"
#addname "Chor Sinewslick"
#addname "Damak Sinewspray"
#addname "Ekron Sinewmonger"
#addname "Frag Rage"
#addname "Gorman Ragetearer"
#addname "Holk Ragesplitter"
#addname "Iago Ragereaper"
#addname "Jerlo Rage"
#addname "Krask Ragedog"
#addname "Larg Ragefist"
#addname "Maul Rageskull"
#addname "Nostom Ragefangs"
#addname "Orlack Ragekill"
#addname "Prug Ragebringer"
#addname "Qybur Ragegod"
#addname "Rom Ragespawn"
#addname "Skol Rageflesh"
#addname "Thorm Ragecutter"
#addname "Urlat Ragelord"
#addname "Vythe Hatespike"
#addname "Warram Hateaxe"
#addname "Xan Hate"
#addname "Yor Hatecrusher"
#addname "Zhab Hatefeaster"
#addname "Argath Hateslick"
#addname "Blut Hatespray"
#addname "Creed Hatemonger"
#addname "Dosk Hatehound"
#addname "Eon Hatetearer"
#addname "Feorth Hatesplitter"
#addname "Grisel Hatereaper"
#addname "Howl Hate"
#addname "Imthor Hatedog"
#addname "Jarl Hatefist"
#addname "Kezzig Hateskull"
#addname "Larno Hatefangs"
#addname "Mung Hatekill"
#addname "Narlan Frenzy"
#addname "Orskath Frenzygod"
#addname "Pragg Frenzyspawn"
#addname "Ramtar Frenzyflesh"
#addname "Slash Frenzy"
#addname "Thrag Frenzylord"
#addname "Zolt Frenzyspike"
#addname "Voron Frenzyaxe"
#addname "Krask Frenzypounder"
#addname "Thorm Frenzycrusher"
#addname "Brak Frenzyfeaster"
#addname "Skol Frenzyslick"
#addname "Angrim Frenzyspray"
#addname "Borlat Frenzymonger"
#addname "Chor Frenzyhound"
#addname "Damak Frenzytearer"
#addname "Ekron Frenzysplitter"
#addname "Frag Frenzyreaper"
#addname "Gorman Wrath"
#addname "Holk Wrath"
#addname "Iago Wrathfist"
#addname "Jerlo Wrathskull"
#addname "Krask Wrathfangs"
#addname "Larg Wrathkill"
#addname "Maul Wrathbringer"
#addname "Nostom Wrathgod"
#addname "Orlack Wrathspawn"
#addname "Prug Wrathflesh"
#addname "Qybur Wrathcutter"
#addname "Rom Wrathlord"
#addname "Skol Wrathspike"
#addname "Thorm Wrathaxe"
#addname "Urlat Wrathpounder"
#addname "Vythe Wrathcrusher"
#addname "Warram Wrathfeaster"
#addname "Xan Wrathslick"
#addname "Yor Wrath"
#addname "Zhab Wrathmonger"
#addname "Argath Wrathhound"
#addname "Blut Wrathtearer"
#addname "Creed Wrathsplitter"
#addname "Dosk Wrathreaper"
#addname "Eon Wrath"
#addname "Feorth Wrathdog"
#addname "Grisel Wrathfist"
#addname "Howl Wrathskull"
#addname "Imthor Wrathfangs"
#addname "Jarl Wrathkill"
#addname "Kezzig Wrathbringer"
#addname "Larno Wrathgod"
#addname "Mung Wrath"
#addname "Narlan Wrathflesh"
#addname "Orskath Wrathcutter"
#addname "Pragg Wrathlord"
#addname "Ramtar Screamspike"
#addname "Slash Screamaxe"
#addname "Thrag Screampounder"
#addname "Zolt Screamcrusher"
#addname "Voron Scream"
#addname "Krask Screamslick"
#addname "Thorm Screamspray"
#addname "Brak Screammonger"
#addname "Skol Screamhound"
#addname "Angrim Screamtearer"
#addname "Borlat Screamsplitter"
#addname "Chor Howlreaper"
#addname "Damak Howl"
#addname "Ekron Howldog"
#addname "Frag Howlfist"
#addname "Gorman Howlskull"
#addname "Holk Howlfangs"
#addname "Iago Howlkill"
#addname "Jerlo Howlbringer"
#addname "Krask Howlgod"
#addname "Larg Howlspawn"
#addname "Maul Howlflesh"
#addname "Nostom Howlcutter"
#addname "Orlack Howllord"
#addname "Prug Howlspike"
#addname "Qybur Howl"
#addname "Rom Thunderpounder"
#addname "Skol Thundercrusher"
#addname "Thorm Thunderfeaster"
#addname "Urlat Thunderslick"
#addname "Vythe Thunderspray"
#addname "Warram Thundermonger"
#addname "Xan Thunderhound"
#addname "Yor Thundertearer"
#addname "Zhab Thundersplitter"
#addname "Argath Thunderreaper"
#addname "Blut Spray"
#addname "Creed Spraydog"
#addname "Dosk Sprayfist"
#addname "Eon Sprayskull"
#addname "Feorth Sprayfangs"
#addname "Grisel Spraykill"
#addname "Howl Spraybringer"
#addname "Imthor Spraygod"
#addname "Jarl Raidspawn"
#addname "Kezzig Raidflesh"
#addname "Larno Raidcutter"
#addname "Mung Raidlord"
#addname "Narlan Raidspike"
#addname "Orskath Raidaxe"
#addname "Pragg Raidpounder"
#addname "Ramtar Raidcrusher"
#addname "Slash Raidfeaster"
#addname "Thrag Raidslick"
#addname "Zolt Raidspray"
#end




-- Khorne Daemon Names

#selectnametype 299
#addname "Hellscream"
#addname "Helldog"
#addname "Hellfist"
#addname "Hellskull"
#addname "Hellfangs"
#addname "Hellkill"
#addname "Hellbringer"
#addname "Hellgod"
#addname "Hellspawn"
#addname "Hellflesh"
#addname "Hellcutter"
#addname "Helllord"
#addname "Hellspike"
#addname "Hellaxe"
#addname "Hellpounder"
#addname "Hellcrusher"
#addname "Hellfeaster"
#addname "Hellslick"
#addname "Hellspray"
#addname "Wrathscream"
#addname "Wrathdog"
#addname "Wrathfist"
#addname "Wrathskull"
#addname "Wrathfangs"
#addname "Wrathkill"
#addname "Wrathbringer"
#addname "Wrathclaw"
#addname "Wrathspawn"
#addname "Wrathflesh"
#addname "Wrathcutter"
#addname "Wrathlord"
#addname "Wrathspike"
#addname "Wrathaxe"
#addname "Wrathpounder"
#addname "Wrathcrusher"
#addname "Wrathfeaster"
#addname "Wrathslick"
#addname "Wrathspray"
#addname "Wrathhound"
#addname "Wrathmurder"
#addname "Wrathslaughter"
#addname "Wrathhack"
#addname "Wrathhacker"
#addname "Wrathscreamer"
#addname "Wrathtearer"
#addname "Wrathsplitter"
#addname "Wrathslasher"
#addname "Wrathbutcher"
#addname "Wrathtaker"
#addname "Wrathblood"
#addname "Wrathbellower"
#addname "Wrathhammer"
#addname "Wrathtalon"
#addname "Wrathblade"
#addname "Wrathhorn"
#addname "Gorescream"
#addname "Goredog"
#addname "Gorefist"
#addname "Goreskull"
#addname "Gorefangs"
#addname "Gorekill"
#addname "Gorebringer"
#addname "Goreclaw"
#addname "Gorespawn"
#addname "Goreflesh"
#addname "Gorecutter"
#addname "Gorelord"
#addname "Gorespike"
#addname "Goreaxe"
#addname "Gorepounder"
#addname "Gorecrusher"
#addname "Gorefeaster"
#addname "Goreslick"
#addname "Gorespray"
#addname "Gorehound"
#addname "Goremurder"
#addname "Goreslaughter"
#addname "Gorehack"
#addname "Gorehacker"
#addname "Gorescreamer"
#addname "Goretearer"
#addname "Goresplitter"
#addname "Goreslasher"
#addname "Gorebutcher"
#addname "Goretaker"
#addname "Goreblood"
#addname "Gorebellower"
#addname "Gorehammer"
#addname "Goretalon"
#addname "Goreblade"
#addname "Gorehorn"
#addname "Ichorscream"
#addname "Ichordog"
#addname "Ichorfist"
#addname "Ichorskull"
#addname "Ichorfangs"
#addname "Ichorkill"
#addname "Ichorbringer"
#addname "Ichorclaw"
#addname "Ichorspawn"
#addname "Ichorflesh"
#addname "Ichorcutter"
#addname "Ichorlord"
#addname "Ichorspike"
#addname "Ichoraxe"
#addname "Ichorpounder"
#addname "Ichorcrusher"
#addname "Ichorfeaster"
#addname "Ichorslick"
#addname "Ichorspray"
#addname "Ichorhound"
#addname "Ichormurder"
#addname "Ichorslaughter"
#addname "Ichorhack"
#addname "Ichorhacker"
#addname "Ichorscreamer"
#addname "Ichortearer"
#addname "Ichorsplitter"
#addname "Ichorslasher"
#addname "Ichorbutcher"
#addname "Ichortaker"
#addname "Ichorblood"
#addname "Ichorbellower"
#addname "Ichorhammer"
#addname "Ichortalon"
#addname "Ichorblade"
#addname "Ichorhorn"
#addname "Slaughterscream"
#addname "Slaughterdog"
#addname "Slaughterfist"
#addname "Slaughterskull"
#addname "Slaughterfangs"
#addname "Slaughterkill"
#addname "Slaughterbringer"
#addname "Slaughterclaw"
#addname "Slaughterspawn"
#addname "Slaughterflesh"
#addname "Slaughtercutter"
#addname "Slaughterlord"
#addname "Slaughterspike"
#addname "Slaughteraxe"
#addname "Slaughterpounder"
#addname "Slaughtercrusher"
#addname "Slaughterfeaster"
#addname "Slaughterslick"
#addname "Slaughterspray"
#addname "Slaughterhound"
#addname "Slaughtermurder"
#addname "Slaughterslaughter"
#addname "Slaughterhack"
#addname "Slaughterhacker"
#addname "Slaughterscreamer"
#addname "Slaughtertearer"
#addname "Slaughtersplitter"
#addname "Rageslasher"
#addname "Ragebutcher"
#addname "Ragetaker"
#addname "Rageblood"
#addname "Ragebellower"
#addname "Ragehammer"
#addname "Ragetalon"
#addname "Rageblade"
#addname "Ragehorn"
#addname "Ragescream"
#addname "Ragedog"
#addname "Ragefist"
#addname "Rageskull"
#addname "Ragefangs"
#addname "Ragekill"
#addname "Ragebringer"
#addname "Rageclaw"
#addname "Ragespawn"
#addname "Rageflesh"
#addname "Ragecutter"
#addname "Ragelord"
#addname "Ragespike"
#addname "Rageaxe"
#addname "Ragepounder"
#addname "Ragecrusher"
#addname "Ragefeaster"
#addname "Rageslick"
#addname "Ragespray"
#addname "Ragehound"
#addname "Howlmurder"
#addname "Howlslaughter"
#addname "Howlhack"
#addname "Howlhacker"
#addname "Howlscreamer"
#addname "Howltearer"
#addname "Howlsplitter"
#addname "Howlslasher"
#addname "Howlbutcher"
#addname "Howltaker"
#addname "Howlblood"
#addname "Howlbellower"
#addname "Howlhammer"
#addname "Howltalon"
#addname "Howlblade"
#addname "Howlhorn"
#addname "Howlscream"
#addname "Howldog"
#addname "Howlfist"
#addname "Howlskull"
#addname "Howlfangs"
#addname "Howlkill"
#addname "Howlbringer"
#addname "Frenzyclaw"
#addname "Frenzyspawn"
#addname "Frenzyflesh"
#addname "Frenzycutter"
#addname "Frenzylord"
#addname "Frenzyspike"
#addname "Frenzyaxe"
#addname "Frenzypounder"
#addname "Frenzycrusher"
#addname "Frenzyfeaster"
#addname "Frenzyslick"
#addname "Frenzyspray"
#addname "Frenzyhound"
#addname "Frenzymurder"
#addname "Frenzyslaughter"
#addname "Frenzyhack"
#addname "Frenzyhacker"
#addname "Frenzyscreamer"
#addname "Frenzytearer"
#addname "Frenzysplitter"
#addname "Frenzyslasher"
#addname "Frenzybutcher"
#addname "Frenzytaker"
#addname "Frenzyblood"
#addname "Frenzybellower"
#addname "Frenzyhammer"
#addname "Frenzytalon"
#addname "Frenzyblade"
#addname "Frenzyhorn"
#addname "Frenzyscream"
#addname "Frenzydog"
#addname "Frenzyfist"
#addname "Skullskull"
#addname "Skullfangs"
#addname "Skullkill"
#addname "Skullbringer"
#addname "Skullclaw"
#addname "Skullspawn"
#addname "Skullflesh"
#addname "Skullcutter"
#addname "Skulllord"
#addname "Skullspike"
#addname "Skullaxe"
#addname "Skullpounder"
#addname "Skullcrusher"
#addname "Skullfeaster"
#addname "Skullslick"
#addname "Skullspray"
#addname "Skullhound"
#addname "Skullmurder"
#addname "Skullslaughter"
#addname "Butcherhack"
#addname "Butcherhacker"
#addname "Butcherscreamer"
#addname "Butchertearer"
#addname "Butchersplitter"
#addname "Butcherslasher"
#addname "Butcherbutcher"
#addname "Butchertaker"
#addname "Butcherblood"
#addname "Butcherbellower"
#addname "Butcherhammer"
#addname "Butchertalon"
#addname "Butcherblade"
#addname "Butcherhorn"
#addname "Mawscream"
#addname "Mawdog"
#addname "Mawfist"
#addname "Mawskull"
#addname "Mawfangs"
#addname "Mawkill"
#addname "Mawbringer"
#addname "Mawclaw"
#addname "Mawspawn"
#addname "Mawflesh"
#addname "Mawcutter"
#addname "Mawlord"
#addname "Mawspike"
#addname "Redaxe"
#addname "Redpounder"
#addname "Redcrusher"
#addname "Redfeaster"
#addname "Redslick"
#addname "Redspray"
#addname "Redhound"
#addname "Redmurder"
#addname "Redslaughter"
#addname "Redhack"
#addname "Redhacker"
#addname "Redscreamer"
#addname "Redtearer"
#addname "Redsplitter"
#addname "Redslasher"
#addname "Redbutcher"
#addname "Redtaker"
#addname "Redblood"
#addname "Redbellower"
#addname "Spinehammer"
#addname "Spinetalon"
#addname "Spineblade"
#addname "Spinehorn"
#addname "Spinescream"
#addname "Spinedog"
#addname "Spinefist"
#addname "Spineskull"
#addname "Spinefangs"
#addname "Spinekill"
#addname "Bladebringer"
#addname "Bladeclaw"
#addname "Bladespawn"
#addname "Bladeflesh"
#addname "Bladecutter"
#addname "Bladelord"
#addname "Bladespike"
#addname "Bladeaxe"
#addname "Bladepounder"
#addname "Bladecrusher"
#addname "Bladefeaster"
#addname "Bladeslick"
#addname "Bladespray"
#addname "Bladehound"
#addname "Angermurder"
#addname "Angerslaughter"
#addname "Angerhack"
#addname "Angerhacker"
#addname "Angerscreamer"
#addname "Angertearer"
#addname "Angersplitter"
#addname "Angerslasher"
#addname "Angerbutcher"
#addname "Angertaker"
#addname "Angerblood"
#addname "Angerbellower"
#addname "Angerhammer"
#addname "Angertalon"
#addname "Angerblade"
#addname "Angerhorn"
#addname "Scarblood"
#addname "Scarbellower"
#addname "Scarhammer"
#addname "Scartalon"
#addname "Scarblade"
#addname "Scarhorn"
#addname "Scarscream"
#addname "Scardog"
#addname "Scarfist"
#addname "Scarskull"
#addname "Scarfangs"
#addname "Scarkill"
#addname "Scarbringer"
#addname "Scarclaw"
#addname "Scarspawn"
#addname "Scarflesh"
#addname "Scarcutter"
#addname "Scarlord"
#addname "Scarspike"
#addname "Scaraxe"
#addname "Scarpounder"
#addname "Scarcrusher"
#addname "Scarfeaster"
#addname "Scarslick"
#addname "Scarspray"
#addname "Scarhound"
#addname "Scarmurder"
#addname "Scarslaughter"
#addname "Scarhack"
#addname "Organhacker"
#addname "Organscreamer"
#addname "Organtearer"
#addname "Organsplitter"
#addname "Organslasher"
#addname "Organbutcher"
#addname "Organtaker"
#addname "Organblood"
#addname "Organbellower"
#addname "Organhammer"
#addname "Organtalon"
#addname "Organblade"
#addname "Organhorn"
#addname "Organblood"
#addname "Organbellower"
#addname "Organhammer"
#addname "Organtalon"
#addname "Organblade"
#addname "Organhorn"
#addname "Organscream"
#addname "Organdog"
#addname "Organfist"
#addname "Organskull"
#addname "Organfangs"
#addname "Organkill"
#addname "Organbringer"
#addname "Bloodclaw"
#addname "Bloodspawn"
#addname "Bloodflesh"
#addname "Bloodcutter"
#addname "Bloodlord"
#addname "Bloodspike"
#addname "Bloodaxe"
#addname "Bloodpounder"
#addname "Bloodcrusher"
#addname "Bloodfeaster"
#addname "Bloodslick"
#addname "Bloodspray"
#addname "Bloodhound"
#addname "Bloodmurder"
#addname "Bloodslaughter"
#addname "Bloodhack"
#addname "Bloodhacker"
#addname "Bloodscreamer"
#addname "Bloodtearer"
#addname "Bloodsplitter"
#addname "Bloodslasher"
#addname "Bloodbutcher"
#addname "Bloodtaker"
#addname "Bloodmangler"
#addname "Bloodbellower"
#addname "Bloodhammer"
#addname "Bloodtalon"
#addname "Bloodblade"
#addname "Bloodhorn"
#end



---------------- EVENTS --------------------


---------------- WELCOME TO KHORNE -----------------

#newevent
#msg "Khorne special mechanics explainer:

Path of the Warrior. Your Chaos Warriors and Knights can, through XP, earn the chance to be promoted to a Chosen. This won't trigger until the turn after the game announces their promotion and will only happen when they are outside of their home province (for technical reasons). They then face the judgement of Khorne and may be either Chosen, Forsaken, or twisted into a Chaos Spawn.

Path of the Champion. Your military commanders can also earn promotion for a chance of a more powerful form. Unlike the troops it can trigger even in their home province. Aspiring Champions can become Exalted Heroes who can become Chaos Lords who can finally become a Daemon Prince. At each stage of judgement Khorne may turn them into a Chaos Spawn (killing them and giving you a Spawn as a troop), though the Spawn will tend to be more powerful than those you get from failed troop promotions. Additionally you may receive random rewards from Khorne, who is pleased by mortal ambition.

Red Harvest. Khorne rewards conquest with blood. Each province you conquer gives blood slaves proportionate to enemy dominion
#header 2 -- use the first line of the event as the header
#req_owncapital 1
#req_pregame 1 -- only happens before the first turn of the game
#req_fornation 170
#nation 170
#req_unique 1
#rarity 5
#end

---------------- STARTITEM INSURANCE -----------------

#newevent
#msg "give item [Mark of Rage]"
#notext
#nolog
#rarity 5
#req_targmnr 16229 -- ragesmith
#req_targnoitem 941 -- mark of rage
#addequip 9
#end

#newevent
#msg "give item [Mark of Rage]"
#notext
#nolog
#rarity 5
#req_targmnr 16229 -- ragesmith
#req_targnoitem 941 -- mark of rage
#addequip 9
#end


--------------- HERO EVENTS -----------------

-- Karanak


-- Arbaal the Undefeated

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Arbaal the Undefeated, known as the Destroyer of Khorne has joined your cause."
#req_owncapital 1
#req_fornation 170
#nation 170
#com 14837
#req_nomnr 14837
#req_varzero 299 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 299 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 2 -- 2% chance, he's pretty good
#req_turn 7
#header 2
#end


-- Harkon

-- Scylla Anfingrimm

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Scylla Anfingrimm the Bloodbeast of Khorne and mightiest Chaos Spawn in history has joined your cause."
#req_owncapital 1
#req_fornation 170
#nation 170
#com 16302
#req_nomnr 16302
#req_varzero 201 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 201 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 5 -- 5% chance, he's pretty good
#req_turn 10 -- too good to be early
#header 2
#end


-- Skarbrand

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Skarbrand the Exiled One, Greater Daemon of Khorne, and formerly the General of the Eight Hosts of Murder has joined your cause."
#req_owncapital 1
#req_fornation 170
#nation 170
#com 16252
#req_nomnr 16252
#req_varzero 202 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 202 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 5 -- 5% chance, he's pretty good
#req_turn 20 -- too good to be early
#header 2
#end

-- Skulltaker

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Skulltaker the Slayer of Kings, Champion of Khorne, and greatest of the Bloodletters has joined your cause."
#req_owncapital 1
#req_fornation 170
#nation 170
#com 16253
#req_nomnr 16253
#req_varzero 203 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 203 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 5 -- 5% chance, he's pretty good
#req_turn 10 -- too good to be early
#header 2
#end








---------------- RED HARVEST ---------------



---- REMOVE a generic 'Khorne' revealed site and then add it back, hidden. Hopefully this means people can't accidentally reveal them by searching H9

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_foundsite 1
#removesite 2000 -- remove Khorne site
#hiddensite 2000 -- add hidden Khorne site
#end


--This event puts the Khorne site that indicates this province was taken on a previous turn

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_nositenbr 2000 -- Khorne site must not be here
#hiddensite 2000 -- add Khorne site
#delay 0
#end

--These events give Khorne 2d6 roll worth of blood slaves per enemy dom candle

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_fornation 170 -- Khorne
#req_maxdominion -1
#nation 170
#force1d6vis 8
#delay 0
#end

#newevent
#msg "They do not worship the Blood God in ##landname##!

Khorne grants you a gift for righting this grievous wrong!"
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_fornation 170 -- Khorne
#nation 170
#delay 0
#header 2
#end

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_maxdominion -2
#nation 170
#force2d6vis 8
#delay 0
#end

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_maxdominion -3
#nation 170
#force2d6vis 8
#delay 0
#end

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_maxdominion -4
#nation 170
#force2d6vis 8
#delay 0
#end

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_maxdominion -5
#nation 170
#force2d6vis 8
#delay 0
#end

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_maxdominion -6
#nation 170
#force2d6vis 8
#delay 0
#end

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_maxdominion -7
#nation 170
#force3d6vis 8
#delay 0
#end

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_maxdominion -8
#nation 170
#force3d6vis 8
#delay 0
#end

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_maxdominion -9
#nation 170
#force3d6vis 8
#delay 0
#end

#newevent
#notext
#nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 170 -- Khorne
#req_maxdominion -10
#nation 170
#force4d6vis 8
#end





---------------- PROMOTION EVENTS ------------------ (these will be doubled up to handle 2 of the same in one prov)

--------- possible rewards



---- Promotion from Aspiring Champion -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring Champion in ##landname## twisted into a Spawn.

An Aspiring Champion who stood before the judgement of Khorne to seek Exaltation was found lacking and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1043 -- commander spawns montag
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, reward: Dominion increase
#newevent
#rarity 5
#req_rare 15
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#req_domowner 170 -- must have positive khorne dominion already
#nation 170
#msg "Aspiring Champion became Exalted in ##landname##.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero. An additional reward was also provided by the Blood God."
#transform 16237
#xp -99
---reward
#incdom 2
#force1d3vis 8
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, reward: magic item
#newevent
#rarity 5
#req_rare 18
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring became Exalted in ##landname##, with reward.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero. An additional reward was also provided by the Blood God."
#transform 16237
#xp -99
---reward
#magicitem 0
#force1d6vis 8
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, reward: blood slaves
#newevent
#rarity 5
#req_rare 22
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring became Exalted in ##landname##, with reward.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero. An additional reward was also provided by the Blood God."
#transform 16237
#xp -99
---reward
#force2d6vis 8
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, reward: some bloodletters
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring became Exalted in ##landname##, with reward.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero. An additional reward of Bloodletter servants was also provided by the Blood God."
#transform 16237
#xp -99
---reward
#1d3units 16255 -- bloodletters
#force1d6vis 8
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, backstop
#newevent
#rarity 5
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring Champion became Exalted in ##landname##.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero."
#transform 16237
#xp -99
#force1d3vis 8
#header 2
#end

---- Promotion from Aspiring Champion -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring Champion in ##landname## twisted into a Spawn.

An Aspiring Champion who stood before the judgement of Khorne to seek Exaltation was found lacking and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1043 -- commander spawns montag
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, reward: Dominion increase
#newevent
#rarity 5
#req_rare 15
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#req_domowner 170 -- must have positive khorne dominion already
#nation 170
#msg "Aspiring became Exalted in ##landname##, with reward.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero. An additional reward was also provided by the Blood God."
#transform 16237
#xp -99
---reward
#incdom 2
#force1d6vis 8
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, reward: magic item
#newevent
#rarity 5
#req_rare 18
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring became Exalted in ##landname##, with reward.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero. An additional reward was also provided by the Blood God."
#transform 16237
#xp -99
---reward
#magicitem 0
#force1d6vis 8
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, reward: blood slaves
#newevent
#rarity 5
#req_rare 22
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring became Exalted in ##landname##, with reward.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero. An additional reward was also provided by the Blood God."
#transform 16237
#xp -99
---reward
#force2d6vis 8
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, reward: some bloodletters
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring became Exalted in ##landname##, with reward.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero. An additional reward of Bloodletter servants was also provided by the Blood God."
#transform 16237
#xp -99
---reward
#1d3units 16255 -- bloodletters
#force1d6vis 8
#header 2
#end

---- Promotion from Aspiring Champion to Exalted Hero, successful, backstop
#newevent
#rarity 5
#req_pop0ok
#req_fornation 170
#req_monster 16224
#req_targmnr 16224
#nation 170
#msg "Aspiring Champion became Exalted in ##landname##.

Khorne has promoted an Aspiring Champion to the title of Exalted Hero."
#transform 16237
#xp -99
#force1d6vis 8
#header 2
#end





--------------- Exalted Hero Promotion events

---- Promotion from Exalted Hero -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted Hero in ##landname## twisted into a Spawn.

An Exalted Hero who stood before the judgement of Khorne to seek the title of Chaos Lord was found lacking and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1043 -- commander spawns montag
#header 2
#end

---- Promotion, reward: Dominion increase
#newevent
#rarity 5
#req_rare 15
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#req_domowner 170 -- must have positive khorne dominion already
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#incdom 3
#force1d6vis 8
#header 2
#end

---- Promotion, reward: magic item
#newevent
#rarity 5
#req_rare 18
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#magicitem 1
#force1d6vis 8
#header 2
#end

---- Promotion, reward: blood slaves
#newevent
#rarity 5
#req_rare 22
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#force2d6vis 8
#header 2
#end

---- Promotion, reward: some bloodletters
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward of Bloodletter servants was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#2d3units 16255 -- bloodletters
#force1d6vis 8
#header 2
#end

---- Promotion, reward: temple
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_temple 0
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#temple
#force1d6vis 8
#header 2
#end

---- Promotion, backstop
#newevent
#rarity 5
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted Hero became Chaos Lord in ##landname##.

Khorne has promoted an Exalted Hero to the title of Chaos Lord."
#transform 16267 -- chaos lord
#remount
#xp -99
#force1d6vis 8
#header 2
#end


---- Promotion from Exalted Hero -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted Hero in ##landname## twisted into a Spawn.

An Exalted Hero who stood before the judgement of Khorne to seek the title of Chaos Lord was found lacking and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1043 -- commander spawns montag
#header 2
#end

---- Promotion, reward: Dominion increase
#newevent
#rarity 5
#req_rare 15
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#req_domowner 170 -- must have positive khorne dominion already
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward of Bloodletter servants was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#incdom 3
#force1d6vis 8
#header 2
#end

---- Promotion, reward: magic item
#newevent
#rarity 5
#req_rare 18
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#magicitem 1
#force1d6vis 8
#header 2
#end

---- Promotion, reward: blood slaves
#newevent
#rarity 5
#req_rare 22
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#force2d6vis 8
#header 2
#end

---- Promotion, reward: some bloodletters
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward of Bloodletter servants was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#2d3units 16255 -- bloodletters
#force1d6vis 8
#header 2
#end

---- Promotion, reward: temple
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#req_temple 0
#nation 170
#msg "Exalted became Chaos Lord in ##landname##, with reward.

Khorne has promoted an Exalted Hero to the title of Chaos Lord. An additional reward was also provided by the Blood God."
#transform 16267 -- chaos lord
#remount
#xp -99
---reward
#temple
#force1d6vis 8
#header 2
#end

---- Promotion, backstop
#newevent
#rarity 5
#req_pop0ok
#req_fornation 170
#req_monster 16238 -- exalted hero
#req_targmnr 16238 -- exalted hero
#nation 170
#msg "Exalted Hero became Chaos Lord in ##landname##.

Khorne has promoted an Exalted Hero to the title of Chaos Lord."
#transform 16267 -- chaos lord
#remount
#xp -99
#force1d6vis 8
#header 2
#end








-------------------- CHAOS LORD PROMOTIONS (for non prophet)

---- Promotion from Chaos Lord -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord in ##landname## twisted into a Spawn.

A Chaos Lord who stood expectant of ascension to Daemonhood was punished at the last moment for his hubris and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1043 -- commander spawns montag
#header 2
#end

---- Promotion, reward: Dominion increase
#newevent
#rarity 5
#req_rare 15
#req_pop0ok
#req_fornation 170
#req_domowner 170 -- must have positive khorne dominion already
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#incdom 4
#force1d6vis 8
#header 2
#end

---- Promotion, reward: magic item
#newevent
#rarity 5
#req_rare 18
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#magicitem 2
#force1d6vis 8
#header 2
#end

---- Promotion, reward: blood slaves
#newevent
#rarity 5
#req_rare 22
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#force2d6vis 8
#header 2
#end

---- Promotion, reward: some bloodletters
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#3d3units 16255 -- bloodletters
#force1d6vis 8
#header 2
#end

---- Promotion, reward: temple
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#req_temple 0
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#temple
#force1d6vis 8
#header 2
#end

---- Promotion, backstop
#newevent
#rarity 5
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
#force1d6vis 8
#header 2
#end

---- Promotion from Chaos Lord -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord in ##landname## twisted into a Spawn.

A Chaos Lord who stood expectant of ascension to Daemonhood was punished at the last moment for his hubris and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1043 -- commander spawns montag
#header 2
#end

---- Promotion, reward: Dominion increase
#newevent
#rarity 5
#req_rare 15
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#req_domowner 170 -- must have positive khorne dominion already
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#incdom 4
#force1d6vis 8
#header 2
#end

---- Promotion, reward: magic item
#newevent
#rarity 5
#req_rare 18
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#magicitem 2
#force1d6vis 8
#header 2
#end

---- Promotion, reward: blood slaves
#newevent
#rarity 5
#req_rare 22
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#force2d6vis 8
#header 2
#end

---- Promotion, reward: some bloodletters
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#3d3units 16255 -- bloodletters
#force1d6vis 8
#header 2
#end

---- Promotion, reward: temple
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#req_temple 0
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
---reward
#temple
#force1d6vis 8
#header 2
#end

---- Promotion, backstop
#newevent
#rarity 5
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 0 -- must not be prophet
#nation 170
#msg "Chaos Lord achieved Daemonhood in ##landname##.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood."
#transform 16270 -- daemon prince
#xp -99
#pathboost 9 -- holy
#pathboost 9 -- holy
#force1d6vis 8
#header 2
#end


----- If the daemon prince is a prophet, there are these events that don't give extra holy

---- Promotion from Chaos Lord -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 10 -- prophet is less liekly to spawn out
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 1 -- must be prophet
#nation 170
#msg "Your Prophet in ##landname## was twisted into a Spawn!

A Chaos Lord who stood expectant of ascension to Daemonhood was punished at the last moment for his hubris and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1043 -- commander spawns montag
#header 2
#end

---- Promotion, reward: Dominion increase
#newevent
#rarity 5
#req_rare 15
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 1 -- must be prophet
#req_domowner 170 -- must have positive khorne dominion already
#nation 170
#msg "Your Prophet achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
---reward
#incdom 4
#force1d6vis 8
#header 2
#end

---- Promotion, reward: magic item
#newevent
#rarity 5
#req_rare 18
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 1 -- must be prophet
#nation 170
#msg "Your Prophet achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
---reward
#magicitem 2
#force1d6vis 8
#header 2
#end

---- Promotion, reward: blood slaves
#newevent
#rarity 5
#req_rare 22
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 1 -- must be prophet
#nation 170
#msg "Your Prophet achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
---reward
#force2d6vis 8
#header 2
#end

---- Promotion, reward: some bloodletters
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 1 -- must be prophet
#nation 170
#msg "Your Prophet achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
---reward
#3d3units 16255 -- bloodletters
#force1d6vis 8
#header 2
#end

---- Promotion, reward: temple
#newevent
#rarity 5
#req_rare 28
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 1 -- must be prophet
#req_temple 0
#nation 170
#msg "Your Prophet achieved Daemonhood in ##landname##, with reward.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood.  An additional reward was also provided by the Blood God."
#transform 16270 -- daemon prince
#xp -99
---reward
#temple
#force1d6vis 8
#header 2
#end

---- Promotion, backstop
#newevent
#rarity 5
#req_pop0ok
#req_fornation 170
#req_monster 16268 -- chaos lord
#req_targmnr 16268 -- chaos lord
#req_targprophet 1 -- must be prophet
#nation 170
#msg "Your Prophet achieved Daemonhood in ##landname##.

A Chaos Lord who stood before the judgement of Khorne has pleased their master and reached pinnacle of the Champion's Path and ascended to Daemonhood."
#transform 16270 -- daemon prince
#xp -99
#force1d6vis 8
#header 2
#end






-- Slaanesh

-------------- New Items

#selectitem 951
#spr "Warhammer_Slaanesh/Slaanesh_Item_Auric.tga"
#name "Auric Armour"
#descr "This armour was granted to Sigvald as a reward by the Dark Prince Slaanesh. It affords Sigvald excellent protection and regenerates any wounds he might sustain."
#type 5 -- body armour
#constlevel 11 -- can't be forged
#cursed -- can't be removed
#nofind -- can't be picked up
#armor 329 -- auric armour
#regeneration 10 -- same as troll
#spell "Slaaneshi Hypnotism"
#end

#selectitem 1012
#spr "Warhammer_Slaanesh/Mark of Slaanesh.tga"
#name "Mark of Slaanesh"
#descr "Keepers of Secrets are granted physical marks of their blessing from and devotion to their God. (Most often as a tramp stamp.) The mark is not merely cosmetic however, it emanates power and has a shard of Slaanesh's will distinct from the will of the Keeper. At the beginning of every battle it whispers to the enemy force. Tempting them to lay down their arms or turn them against their comrades."
#type 8
#constlevel 11
#cursed
#nofind
#autospell "Slaanesh's Presence"
#autospellrepeat 0
#end

--------------New Weapons

-- Pincer Claw (the non magical weaker version)

#newweapon 1084
#copyweapon 600 -- crab claw
#name "Pincer Claw"
#dmg 2
#len 0
#slash
#pierce
#end

-- Daemonette Claw

#newweapon 1127
#copyweapon 600 -- crab claw
#name "Wicked Claw"
#magic
#dmg 2 -- 4 less than the dark elf version because that version needs to be nerfed probably
#len 0
#slash
#pierce
#bonus
#end


-- Javelin Bundle used by Hunters

#newweapon 1085
#copyweapon 21 -- javelin
#name "Javelin Bundle"
#ammo 4 -- doubled
#end

-- Paralyzing Stinger

#newweapon 1092
#copyweapon 423 -- scorpion tail
#name "Paralyzing Stinger"
#secondaryeffect 54 -- paralyzing poison
#end

-- Warhorse Hoof

#newweapon 1093
#copyweapon 56 -- hoof
#name "Warhorse Hoof"
#att -2
#dmg 15
#end

-- Temptation (Slaaneshi Daemon Weapon)

#newweapon 2502
#copyweapon 189 -- Enslavement
#name "Temptation"
#hardmrneg
#att -3
#sizeresist
#mind
#undeadimmune
#inanimateimmune
#nratt -2
#bonus
#end

---- Troll Vomit

#newweapon 1094
--copyweapon 542 -- acid - don't need to copy, if I do it's magic which is bad
#name "Troll Vomit"
#dmg 10
#aoe 1
#nostr
#bonus
#rcost 0
#len 2
#acid
#armorpiercing
#norepel
#unrepel
#skip2 -- when used skips the next two weapons - this is buggy and doesn't work
#melee50 -- only used half the time
#att 0
#explspr 10221 -- brown burst?
--explspr 10039 -- green little puff
--explspr 10299 -- green and blackish smoke
#ammo 2 -- only twice per battle
#end

---- Spiked Mace

#newweapon 1095
#copyweapon 12 -- mace
#name "Spiked Mace"
#pierce
#end

---- Tentacles x2

#newweapon 1096
#copyweapon 85 -- tentacle
#name "Tentacles"
#nratt 2
#end

---- Small Tentacles x3

#newweapon 1097
#copyweapon 85 -- tentacle
#name "Small Tentacles"
#nratt 3
#dmg -8 -- -3
#end

---- Psychoactive Poisons

#newweapon 1098
#copyweapon 622 -- maddening rage (confusion effect)
#name "Psychoactive Poisons"
#hardmrneg -- mr negates with difficulty
#magic
#armornegating
#secondaryeffect 51 -- strong poison
#end


-- Steed's Tongue (nostr Chaos Lord version)

#newweapon 1131
#copyweapon 19 -- jade maiden mount bite
#name "Steed's Tongue"
#dmg 17 -- mount str damage
#att -3 -- much less skilled than rider
#sound 9 -- whip
#flail -- because the tongue is prehensile
#secondaryeffect 1098 -- psychoactive poisons
#bonus
#nostr
#len 5 -- longer than spear
#unrepel
#end

-- Hellscourge

#newweapon 1124
#copyweapon 757 -- bronze scimitar
#name "Hellscourge"
#dmg 3
#att 0
#def 0
#sound 9 -- whip
#flail -- because the hellscourge has a life of its own
#secondaryeffect 384 -- minor life drain
#len 5 -- longer than spear
#rcost 2
#magic
#end


-- Steed's Tongue (strength based one for the unmounted steed)

#newweapon 1125
#copyweapon 20 -- normal bite
#name "Poisonous Whiptongue"
#dmg 0
#att 0
#def 0
#sound 9 -- whip
#flail -- because the tongue is prehensile
#secondaryeffect 1098 -- psychoactive poisons
#bonus -- can't be chopped off
#len 5 -- longer than spear
#unrepel
#end


-- Long Sword used by the Exalted Hero

#newweapon 1126
#copyweapon 8 -- broad sword
#name "Long Sword"
#len 2
#pierce
#end

-- Silverslash used by Sigvald

#newweapon 1187
#copyweapon 8 -- broad sword
#name "Silverslash"
#dmg 8
#magic
#len 2
#pierce
#att 2
#def 3
#nratt 2
#end


-- Sensation Coma Posion

#newweapon 1129
#copyweapon 624 -- paralyzing poison
#name "Sensation Coma Poison"
#magic
#dmg 50
#end


-- Fiend Tail (coma inducing stinger)

#newweapon 1130
#copyweapon 423 -- scorpion tail
#name "Coma Inducing Stinger"
#secondaryeffect 1129 -- sensation coma poison
#armorpiercing
#dmg -3
#magic
#end


-- Bone Blade

#newweapon 1132
#copyweapon 236 -- claw
#name "Bone Blade"
#len 1
#dmg 6
#magic
#end


-- Chaos Glaive

#newweapon 1133
#copyweapon 202 -- magic sword
#name "Chaos Glaive"
#len 3 -- glaive
#dmg 10 -- glaive
#end




---------------New Armor

---- Chaos Plate

#newarmor 310
#copyarmor 215 -- full plate of ulm
#name "Full Chaos Plate"
#prot 21 -- -2, same as full plate mail
#rcost 15
#end

---- Auric Armour

#newarmor 329
#copyarmor 201 -- armor of knights
#name "Auric Armour"
#prot 23 -- +3
#end


---- Chaos Helm

#newarmor 311
#copyarmor 218 -- full helmet of ulm
#name "Chaos Helm"
#prot 21 -- -2
#rcost 4
#end

---- Chaos Headplate

#newarmor 305
#copyarmor 218 -- full helmet of ulm
#name "Chaos Headplate"
#prot 14 -- much less
#rcost 2
#def 0
#enc 0
#end

---- Chaos Plate Cuirass

#newarmor 312
#copyarmor 217 -- plate cuirass of ulm
#name "Chaos Plate Cuirass"
#rcost 10
#end


---- Chaos Ogre Gutplate -- identical to irongut plate

#newarmor 989
#copyarmor 9 -- plate cuirass
#name "Chaos Ogre Gutplate"
#prot 13 -- -1
#rcost 14 -- -1
#ironarmor
#end

---- Mirrored Shield

#newarmor 328
#copyarmor 164 -- anakite shield
#name "Mirrored Shield"
#end



------------------MAGIC ITEMS



-------------------MONSTERS



--------- Templates

---- Marauder Template

#newmonster 14200
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Axe.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Axe2.tga"
#name "Marauder"
#descr "descr."
#hp 12 --- big tough guys
#size 3 --- normal
#prot 2
#mor 12
#mr 9 --- normal
#enc 3 --- normal
#str 12
#att 11 --- WS4 I4
#def 12 --- WS4 I4 then +1 for being slaanesh marked
#prec 10
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 12
#rpcost 7 -- normal -2 because of turmoil incentives
#rcost 2
#ambidextrous 2
#coldres 5
#snow
#wastesurvival
#pillagebonus 1
#nametype 131 -- EA Ulm male
#ressize 2
#end

---- Warrior Template

#newmonster 14199
#spr1 "Warhammer_Slaanesh/Slaanesh_Warrior_Sword.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Warrior_Sword2.tga"
#name "Chaos Warrior"
#descr "descr."
#hp 15 --- chaos warrior base hp
#size 3 --- normal
#prot 2
#mor 15 -- 14 base for chaos warrior, +1 for slaanesh
#mr 12 --- 12 base for chaos warrior
#enc 2 --- -1
#str 13 -- +1
#att 12 --- WS5, 2 attacks
#def 13 --- WS5 and +1 for being slaanesh marked
#prec 10
#mapmove 18 -- tireless marchers
#ap 14 --- +2 over human
#gcost 30
#rpcost 16
#rcost 1
#ambidextrous 2
#coldres 5
#snow
#unsurr 1
#wastesurvival
#neednoteat
#nametype 198 -- slaanesh warrior names
#startage 60
#maxage 300
#end




--------- Recruits


---- Recruitable Chaos Warhound

#newmonster 14201
#spr1 "Warhammer_Slaanesh/Slaanesh_War_Hound.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_War_Hound2.tga"
#name "Chaos Warhound"
#descr "Marauder tribes make extensive use of large hounds to track and hunt beasts, warn them of dangers, or run down tired and fleeing foes. The largest and most ferocious of these are taken into battle to be unleashed on the enemy lines, a snarling wave of muscle, tooth, and claw. Chaos Warhounds often sport mutations and those that have been touched by the influence of Chaos tend to be even more dangerous, making them prized possessions for Marauder Chieftains.

[When recruited you may get a mutated Chaos Hound with some advantages over the basic version]
[Recruitment limited to 10 per month]"
#cleararmor
#clearweapons
#gcost 7
#hp 12
#size 3
#prot 4 -- tough!
#mor 9 -- aggresive
#mr 8
#enc 2
#str 13
#att 11
#def 12
#prec 7
#mapmove 22 -- same as wolf
#ap 20
#rpcost 2 -- same as war dog of Ulm
#rcost 1
#weapon 20 -- normal bite
#forestsurvival
#wastesurvival
#snow
#animal
#undisciplined
#reclimit 10 -- mainly to stop the ai going crazy building them
#coldres 5
#firstshape -1031 -- hound montag
#siegebonus -1
#end


---- Basic Chaos Warhound

#newmonster 14213
#spr1 "Warhammer_Slaanesh/Slaanesh_War_Hound.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_War_Hound2.tga"
#name "Chaos Warhound"
#descr "Marauder tribes make extensive use of large hounds to track and hunt beasts, warn them of dangers, or run down tired and fleeing foes. The largest and most ferocious of these are taken into battle to be unleashed on the enemy lines, a snarling wave of muscle, tooth, and claw. Chaos Warhounds often sport mutations and those that have been touched by the influence of Chaos tend to be even more dangerous, making them prized possessions for Marauder Chieftains.

[When recruited you may get a mutated Chaos Hound with some advantages over the basic version]
[Recruitment limited to 10 per month]"
#cleararmor
#clearweapons
#gcost 7
#hp 12
#size 3
#prot 4 -- tough!
#mor 9 -- aggresive
#mr 8
#enc 2
#str 13
#att 11
#def 12
#prec 7
#mapmove 22 -- same as wolf
#ap 20
#rpcost 2 -- same as war dog of Ulm
#rcost 1
#weapon 20 -- normal bite
#forestsurvival
#wastesurvival
#snow
#animal
#undisciplined
#reclimit 10 -- mainly to stop the ai going crazy building them
#coldres 5
#montag 1031 -- hound montag
#montagweight 6 -- so 6/9 dogs will be non mutated
#siegebonus -1
#end


---- Tentacle face Chaos Warhound

#newmonster 14211
#spr1 "Warhammer_Slaanesh/Slaanesh_War_Hound_Tentacle.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_War_Hound_Tentacle2.tga"
#name "Chaos Mutant Warhound"
#descr "Marauder tribes make extensive use of large hounds to track and hunt beasts, warn them of dangers, or run down tired and fleeing foes. The largest and most ferocious of these are taken into battle to be unleashed on the enemy lines, a snarling wave of muscle, tooth, and claw. Chaos Warhounds often sport mutations and those that have been touched by the influence of Chaos tend to be even more dangerous, making them prized possessions for Marauder Chieftains.

[When recruited you may get a mutated Chaos Hound with some advantages over the basic version]"
#cleararmor
#clearweapons
#gcost 7
#hp 14 -- +2
#size 3
#prot 5 -- +1
#mor 12 -- +3
#mr 9 -- +1
#enc 2
#str 14 -- +1
#att 11
#def 11
#prec 5 -- -2
#blind
#mapmove 22
#ap 20
#rpcost 2
#rcost 1
#weapon 1096 -- tentacles x2
#forestsurvival
#wastesurvival
#snow
#animal
#undisciplined
#unsurr 1
#coldres 5
#montag 1031 -- hound montag
#siegebonus -1
#end


---- Sting tail Chaos Warhound

#newmonster 14212
#spr1 "Warhammer_Slaanesh/Slaanesh_War_Hound_Tail.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_War_Hound_Tail2.tga"
#name "Chaos Mutant Warhound"
#descr "Marauder tribes make extensive use of large hounds to track and hunt beasts, warn them of dangers, or run down tired and fleeing foes. The largest and most ferocious of these are taken into battle to be unleashed on the enemy lines, a snarling wave of muscle, tooth, and claw. Chaos Warhounds often sport mutations and those that have been touched by the influence of Chaos tend to be even more dangerous, making them prized possessions for Marauder Chieftains.

[When recruited you may get a mutated Chaos Hound with some advantages over the basic version]"
#cleararmor
#clearweapons
#gcost 7
#hp 14 -- +2
#size 3
#prot 5 -- +1
#mor 11 -- +2
#mr 9 -- +1
#enc 2
#str 13
#att 11
#def 12 -- +1
#prec 7
#mapmove 22
#ap 20
#rpcost 2
#rcost 1
#weapon 20 -- normal bite
#weapon 1092 -- paralyzing stinger
#forestsurvival
#wastesurvival
#snow
#animal
#undisciplined
#unsurr 1
#coldres 5
#montag 1031 -- hound montag
#siegebonus -1
#end



---- Recruitable Marauder

#newmonster 14204
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Axe.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Axe2.tga"
#name "Marauder"
#descr "The tribes of humans who flock to join the banner of Chaos incursions are collectively known as Marauders and though they hail from many distinct cultures they all recognise and worship the Ruinous Powers. Typically Slaanesh is depicted as a great Serpent whose caress brings pleasure, pain, sorrow, and elation and so the tribal warriors who follow the Dark Prince are known as the Marauders of the Serpent. Marauders are to the warriors of other human realms as great wolves are to dogs; they are hardened by lives of struggle and violence and devoted to battle with no thought of retiring in comfort or returning home to farm or ply a trade. Marauders are physically larger and stronger than typical humans and some bear mutations brought about by proximity to the Chaos Wastes or the briefest flickers of attention from Slaanesh's wandering gaze.

[When recruited you will either get a marauder with axe and shield, morningstar and shield, axe and throwing axes, or occasionally a Forsaken Marauder]"
#weapon 17 -- axe
#armor 21 -- full helmet
#armor 11 -- ring mail hauberk
#armor 2 -- shield
#firstshape -1032 -- marauders
#end


---- Forsaken Marauder

#newmonster 14233
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Forsaken_Marauder.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Forsaken_Marauder2.tga"
#name "Forsaken Marauder"
#descr "While only Warriors, Sorcerers, and Champions of Chaos can truly hope to draw the eye of one of the Ruinous Powers, all manner of other men and beasts are subject to the warping taint of Chaos through proximity alone. Many of the men and women of the countless Marauder tribes are born with mutations, reminders of the constant presence of their Gods. These mutants are not ostracised or culled as they might be in the weak realms of civilised men but are instead treated with respect and honour. Those with the extreme mutations typically do not survive to adulthood but some join the marauders and unleash the blessing of their altered form upon the foe in a frenzied headlong rush. They are known as the Forsaken amongst the ranks of the Warriors, but to the Marauders they are a venerated elite that demonstrate the favour of the Gods."
#weapon 17 -- axe
#weapon 85 -- tentacle
#armor 11 -- ring mail hauberk
#hp 14 --- +2
#prot 2
#mor 13 -- +2
#mr 11 --- +1
#str 13 -- +1
#berserk 1
#ap 14 -- +2
#prec 9 -- -1
#unsurr 1
#montag 1032 -- marauders
#end


---- Marauder Hunter

#newmonster 14203
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Hunter.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Hunter2.tga"
#name "Marauder Hunter"
#descr "Not all of the Marauders who accompany Chaos raiding parties are strictly warriors, dedicated to slaughter and battle. Some are hunters who serve a vital function to their tribe in bringing down the beasts that roam the lands around the Chaos Wastes for food, trophies, or simply to ensure the safety of their people. These hunters accompany raiding parties to help provide supplies and to lend their impressive skill with javelins to the host. They are still Marauders are still capable fighters in melee, though they lack some of the fearsome resolve of their companions."
#prec 11 -- +1 for ranged focus
#weapon 1 -- spear
#weapon 1085 -- javelin bundle (x4 javs)
#armor 119 -- reinforced leather cap
#armor 6 -- ring mail cuirass
#supplybonus 1 -- they are hunters after all
#mor 11 -- -1
#end

---- Marauder (axe and shield)

#newmonster 14207
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Axe.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Axe2.tga"
#name "Marauder"
#descr "The tribes of humans who flock to join the banner of Chaos incursions are collectively known as Marauders and though they hail from many distinct cultures they all recognise and worship the Ruinous Powers. Typically Slaanesh is depicted as a great Serpent whose caress brings pleasure, pain, sorrow, and elation and so the tribal warriors who follow the Dark Prince are known as the Marauders of the Serpent. Marauders are to the warriors of other human realms as great wolves are to dogs; they are hardened by lives of struggle and violence and devoted to battle with no thought of retiring in comfort or returning home to farm or ply a trade. Marauders are physically larger and stronger than typical humans and some bear mutations brought about by proximity to the Chaos Wastes or the briefest flickers of attention from Slaanesh's wandering gaze."
#weapon 17 -- axe
#armor 21 -- full helmet
#armor 11 -- ring mail hauberk
#armor 2 -- shield
#montag 1032 -- marauders
#montagweight 2
#end

---- Marauder (morningstar)

#newmonster 14208
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Morningstar.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Morningstar2.tga"
#name "Marauder"
#descr "The tribes of humans who flock to join the banner of Chaos incursions are collectively known as Marauders and though they hail from many distinct cultures they all recognise and worship the Ruinous Powers. Typically Slaanesh is depicted as a great Serpent whose caress brings pleasure, pain, sorrow, and elation and so the tribal warriors who follow the Dark Prince are known as the Marauders of the Serpent. Marauders are to the warriors of other human realms as great wolves are to dogs; they are hardened by lives of struggle and violence and devoted to battle with no thought of retiring in comfort or returning home to farm or ply a trade. Marauders are physically larger and stronger than typical humans and some bear mutations brought about by proximity to the Chaos Wastes or the briefest flickers of attention from Slaanesh's wandering gaze."
#weapon 15 -- morningstar
#armor 118 -- half helmet
#armor 11 -- ring mail hauberk
#armor 2 -- shield
#montag 1032 -- marauders
#montagweight 2
#end

---- Marauder (throwing axes)

#newmonster 14209
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Axes.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Axes2.tga"
#name "Marauder"
#descr "The tribes of humans who flock to join the banner of Chaos incursions are collectively known as Marauders and though they hail from many distinct cultures they all recognise and worship the Ruinous Powers. Typically Slaanesh is depicted as a great Serpent whose caress brings pleasure, pain, sorrow, and elation and so the tribal warriors who follow the Dark Prince are known as the Marauders of the Serpent. Marauders are to the warriors of other human realms as great wolves are to dogs; they are hardened by lives of struggle and violence and devoted to battle with no thought of retiring in comfort or returning home to farm or ply a trade. Marauders are physically larger and stronger than typical humans and some bear mutations brought about by proximity to the Chaos Wastes or the briefest flickers of attention from Slaanesh's wandering gaze."
#weapon 17 -- axe
#weapon 260 -- throwing axe
#armor 118 -- half helmet
#armor 11 -- ring mail hauberk
#montag 1032 -- marauders
#montagweight 2
#end

---- Berserker

#newmonster 14210
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Berserker.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Berserker2.tga"
#name "Marauder Berserker"
#descr "Berserkers are elite infantry within the ranks of the Marauder tribes whose job is to shatter the enemy line or dispatch the strongest foes. Like all Marauders, they are unrelenting combatants who habitually take what their own lands cannot provide from lesser men, but are set apart by their heedless embrace of death in battle and ability to enter a frenzied killing trance. Berserkers favour the use of an axe in each hand and train extensively to build their physical strength to a level similar to that of the mighty Chaos Warriors."
#hp 14 --- +2
#prot 3
#mor 12 -- +1
#mr 11 --- +1
#str 14 -- +2
#gcost 18
#rpcost 11 --- +4
#weapon 17 -- axe
#weapon 17 -- axe
#armor 21 -- full helmet
#armor 11 -- ring mail hauberk
#att 10
#def 14
#berserk 1
#end


---- Marauder Horseman

#newmonster 14234
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Jav.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Jav2.tga"
#name "Marauder Light Horseman"
#descr "Marauder Horsemen are the outriders and scouts of Chaos Warhosts and smaller Marauder raids alike, ranging ahead to harass, pillage, and demoralise the enemy. Like all Marauders they are hardened fighters who place little value on the lives of those beyond their tribe and they have gained a fearsome reputation amongst the civilised realms of men as harbingers of terrible suffering and destruction. The steeds they ride are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos and paired with their skilled riders, many of whom have lived in the saddle virtually their entire lives, they make excellent light cavalry. The most common equipment used by Marauder Horsemen is a combination of light lance, shield, and javelins."
#weapon 357 -- light lance
#weapon 21 -- javelin
#armor 119 -- reinforced leather cap
#armor 6 -- ring mail cuirass
#armor 2 -- shield
#ressize 2
#gcost 15 -- (25)
#pillagebonus 2
#skilledrider 2
#mobilearcher 1
#mountmnr 14433
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Jav_Unmounted.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Jav_Unmounted2.tga"
#end

-----Marauder Horse (slaanesh, jav)

#newmonster 14433
#copystats 3574 -- armored steppe horse
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Jav_Mount.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Jav_Mount2.tga"
#name "Marauder Horse"
#descr "The horses ridden by Chaos Marauders are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos. Unlike most horses there is a chance they will continue to fight even if their rider is slain, such is their aggressive nature. Those ridden by the followers of Slaanesh in the guise of the serpent are particularly noted for their quality and aggression."
#gcost 10
#prot 4 -- +1 for hardiness
#armor 251 -- light leather barding
#armor 20 -- iron cap
#snow
#coldres 5
#mor 10 -- +2
#mr 7 -- +2
#hp 22 -- +2
#bravemount 35 -- +10 for slaanesh
#att 10 -- +1
#def 12 -- +1 -- extra for slaanesh
#wastesurvival
#end


---- Marauder Horseman (flail)

#newmonster 14235
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Flail.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Flail2.tga"
#name "Marauder Horseman"
#descr "Marauder Horsemen are the outriders and scouts of Chaos Warhosts and smaller Marauder raids alike, ranging ahead to harass, pillage, and demoralise the enemy. Like all Marauders they are hardened fighters who place little value on the lives of those beyond their tribe and they have gained a fearsome reputation amongst the civilised realms of men as harbingers of terrible suffering and destruction. The steeds they ride are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos and paired with their skilled riders, many of whom have lived in the saddle virtually their entire lives, they make excellent light cavalry. Amongst those tribes that follow Slaanesh in the guise of the Serpent the unconventional use of a two handed flail from horseback is not uncommon and these Horsemen are known to be particularly fearless and resilient in battle."
#weapon 16 -- flail
#armor 118 -- half helmet
#armor 11 -- ring mail hauberk
#ressize 2
#gcost 15 -- (25)
#mor 12 -- +1
#pillagebonus 2
#att 11 -- +1 to try and help that the flail sucks when mounted
#skilledrider 2
#mountmnr 14434
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Flail_Unmounted.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Flail_Unmounted2.tga"
#end

-----Marauder Horse (slaanesh, jav)

#newmonster 14434
#copystats 14433 -- slaanesh marauder horse
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Flail_Mount.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Horseman_Flail_Mount2.tga"
#name "Marauder Horse"
#descr "The horses ridden by Chaos Marauders are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos. Unlike most horses there is a chance they will continue to fight even if their rider is slain, such is their aggressive nature. Those ridden by the followers of Slaanesh in the guise of the serpent are particularly noted for their quality and aggression."
#end


---- Warrior of Slaanesh (recruitment)

#newmonster 14320
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Warrior_Sword.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Warrior_Sword2.tga"
#name "Chaos Warrior"
#descr "Chaos Warriors are fighters of near unmatched prowess, possessing superhuman strength and durability combined with skills honed in countless battles and arms and armour forged in infernal fire. When a man joins the marauders and pledges his soul to Chaos he chooses a lifetime of bloody struggle with the promise of earthly reward, yet those who embark on the path of the Chaos Warrior cast aside such pursuits to seek greater truths and perhaps the chance of true immortality as near tireless killing machines. Warriors dedicated to Slaanesh are known for their grace and skill in battle even beyond those of their peers in service to the rival Ruinous Powers. They are no less indifferent than any of their kind to the pleasures of sleep, wine, food, or carnal pursuits, but find great pleasure in the challenge of war and the infliction of pain. Those Warriors who acheive great deeds in battle will attract the attention of Slaanesh and may become Chosen in the eyes of the Prince of Pleasure, though Slaanesh is a capricious creature and may also curse them to become Forsaken or even Chaos Spawn.

[When recruited you will either get a Warrior with falchion and shield or with a glaive]
[When this unit is promoted it will lose all XP and transform into either a Chosen, Forsaken, or a Chaos Spawn.]"
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#xpshape 45
#firstshape -1029
#end


---- Warrior of Slaanesh (sword and shield)

#newmonster 14205
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Warrior_Sword.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Warrior_Sword2.tga"
#name "Chaos Warrior"
#descr "Chaos Warriors are fighters of near unmatched prowess, possessing superhuman strength and durability combined with skills honed in countless battles and arms and armour forged in infernal fire. When a man joins the marauders and pledges his soul to Chaos he chooses a lifetime of bloody struggle with the promise of earthly reward, yet those who embark on the path of the Chaos Warrior cast aside such pursuits to seek greater truths and perhaps the chance of true immortality as near tireless killing machines. Warriors dedicated to Slaanesh are known for their grace and skill in battle even beyond those of their peers in service to the rival Ruinous Powers. They are no less indifferent than any of their kind to the pleasures of sleep, wine, food, or carnal pursuits, but find great pleasure in the challenge of war and the infliction of pain. Those Warriors who acheive great deeds in battle will attract the attention of Slaanesh and may become Chosen in the eyes of the Prince of Pleasure, though Slaanesh is a capricious creature and may also curse them to become Forsaken or even Chaos Spawn.

[When this unit is promoted it will lose all XP and transform into either a Chosen, Forsaken, or a Chaos Spawn.]"
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#xpshape 45
#montag 1029
#xpshapeloss 100
#xpshapemon -1030 -- chosen or forsaken or spawn
#end


---- Chosen of Slaanesh

#newmonster 14217
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Chosen_Warrior.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Chosen_Warrior2.tga"
#name "Chosen Warrior"
#descr "There are those amognst the ranks of the Chaos Warriors who bear the clear favour of Slaanesh and have been elevated as the Chosen of the Prince of Pleasure and granted even greater physical prowess and skill. The Chosen are beautiful and terrible to behold, their armour spotless and shining as they scythe through the ranks of their foes with a cruel indifference. While the Warriors of Slaanesh are grimly focused on the task of butchery and pain, the Chosen are gifted heightened senses and a true passion for excess. They are known for to dance, sing, weep, laugh, cavort, even recite poetry or create art; indeed they will sometimes do all of these in the midst of a pitched battle. The Chosen have reached the end of their path, never destined to rise toward the ultimate goal of Daemonhood, but their souls will surely receive lavish attention from Slaanesh in death just as they have in life. The Chosen are sacred to the followers of the Dark Prince.

[Requires friendly Dominion strength of 4 in the province to recruit]"
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#mor 16 -- +1
#mr 13 -- +1
#str 14 -- +1
#att 12 --- +1
#def 14 --- +1
#gcost 55
#holy
#awe 1
#montag 1030 -- chosen and forsaken and spawn
#montagweight 20
#domrec 4
#ap 16 -- +2 so they are the same speed as the unshielded warriors, +4 over human
#heal
#unsurr 2
#startage 80
#maxage 400
#rpcost 20
#end

---- Forsaken Warrior of Slaanesh

#newmonster 14218
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Warrior_Forsaken.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Warrior_Forsaken2.tga"
#name "Forsaken Warrior"
#descr "The Ruinous Powers are as fickle as they are implacable and the whims of Slaanesh in particular change quickly and severely. In striving to prove themselves and draw the attention of the Dark Prince the Chaos Warriors of Slaanesh are always at risk of falling short in the eyes of their patron and failing to join the ranks of the Chosen, instead becoming either Forsaken or turned into a Chaos Spawn. The Forsaken are those unfortunates who have been twisted by the caress of Slaanesh and reduced in stature from proud Chaos Warriors to berserk mutants eager to find death in battle, for unlike Chaos Spawn they are entirely aware of their own fallen condition. Forsaken are not disciplined and well armoured heavy infantry or cavalry as they once were, instead they are whirling, malformed shock troops typically thrown to the frontlines to inflict as much damage as possible before they are cut down. To the Chaos Warriors they are a reminder of the risks of their path and the price of failure, but to the massed Marauders they are considered equals of the Warriors who simply bear the blessings of the Dark Prince in a different fashion."
#weapon 1084 -- pincer claw
#weapon 29 -- claw
#armor 9 -- plate cuirass
#hp 17 --- +2
#mor 17 -- +2
#mr 11 --- -1
#att 10 -- -2
#def 12 -- -2
#str 12 -- -1
#gcost 20
#ambidextrous 2
#coldres 5
#snow
#wastesurvival
#neednoteat
#berserk 1
#ap 16 -- +2
#unsurr 2
#montag 1030 -- chosen and forsaken and spawn
#montagweight 10
#end


---- Forsaken Warrior of Slaanesh

#newmonster 14240
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Warrior_Forsaken.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Warrior_Forsaken2.tga"
#name "Forsaken Warrior"
#descr "The Ruinous Powers are as fickle as they are implacable and the whims of Slaanesh in particular change quickly and severely. In striving to prove themselves and draw the attention of the Dark Prince the Chaos Warriors of Slaanesh are always at risk of falling short in the eyes of their patron and failing to join the ranks of the Chosen, instead becoming either Forsaken or turned into a Chaos Spawn. The Forsaken are those unfortunates who have been twisted by the caress of Slaanesh and reduced in stature from proud Chaos Warriors to berserk mutants eager to find death in battle, for unlike Chaos Spawn they are entirely aware of their own fallen condition. Forsaken are not disciplined and well armoured heavy infantry or cavalry as they once were, instead they are whirling, malformed shock troops typically thrown to the frontlines to inflict as much damage as possible before they are cut down. To the Chaos Warriors they are a reminder of the risks of their path and the price of failure, but to the massed Marauders they are considered equals of the Warriors who simply bear the blessings of the Dark Prince in a different fashion."
#weapon 1084 -- pincer claw
#weapon 29 -- claw
#armor 9 -- plate cuirass
#hp 17 --- +2
#mor 17 -- +2
#mr 11 --- -1
#att 10 -- -2
#def 12 -- -2
#str 12 -- -1
#gcost 20
#ambidextrous 2
#coldres 5
#snow
#wastesurvival
#neednoteat
#berserk 1
#ap 16 -- +2
#unsurr 2
#montag 1034 -- chosen knight, forsaken, spawns
#montagweight 10
#firstshape 14218 -- because then they have the same id for selecting
#end


---- Warrior of Slaanesh (glaive)

#newmonster 14225
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Warrior_Glaive.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Warrior_Glaive2.tga"
#name "Chaos Warrior"
#descr "Chaos Warriors are fighters of near unmatched prowess, possessing superhuman strength and durability combined with skills honed in countless battles and arms and armour forged in infernal fire. When a man joins the marauders and pledges his soul to Chaos he chooses a lifetime of bloody struggle with the promise of earthly reward, yet those who embark on the path of the Chaos Warrior cast aside such pursuits to seek greater truths and perhaps the chance of true immortality as near tireless killing machines. Warriors dedicated to Slaanesh are known for their grace and skill in battle even beyond those of their peers in service to the rival Ruinous Powers. They are no less indifferent than any of their kind to the pleasures of sleep, wine, food, or carnal pursuits, but find great pleasure in the challenge of war and the infliction of pain. Those Warriors who acheive great deeds in battle will attract the attention of Slaanesh and may become Chosen in the eyes of the Prince of Pleasure, though Slaanesh is a capricious creature and may also curse them to become Forsaken or even Chaos Spawn.

[When this unit is promoted it will lose all XP and transform into either a Chosen, Forsaken, or a Chaos Spawn.]"
#weapon 308 -- glaive
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#xpshape 45
#montag 1029
#xpshapeloss 100
#xpshapemon -1030 -- chosen or forsaken or spawn
#end


---- Knight of Slaanesh

#newmonster 14214
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Knight.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Knight2.tga"
#name "Chaos Knight"
#descr "Chaos Knights have a fearsome reputation as heralds of doom across the Old World, for the pairing of a mighty Chaos Warrior with a towering Chaos Steed makes for near unstoppable heavy cavalry. Chaos Steeds are to the warhorses of the realms of men what Chaos Warriors are to their soldiers; these beasts are larger, stronger, and more vicious than any normal horse. Chaos Knights are famously arrogant and tend to stay away from the rest of the warhost, considering even Chaos Warriors beneath them, though they are as eager to answer the call to do battle for the glory of their God as any follower of Slaanesh. Just like Warriors, the Knights have embarked on a path towards a fate as either a Chosen of Slaanesh, a Forsaken stripped of their steed and status, or a foul Chaos Spawn.

[When this unit is promoted it will lose all XP and transform into either a Chosen Knight, a Forsaken, or a Chaos Spawn.]"
#weapon 4 -- lance
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#ressize 2
#xpshape 45
#xpshapeloss 100
#xpshapemon -1034 -- chosen knight or forsaken or spawn
#gcost 55 -- (80)
#skilledrider 2
#mountmnr 14430
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Knight_Unmounted.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Knight_Unmounted2.tga"
#end


-----Chaos Steed (knight)

#newmonster 14430
#copystats 3897 -- destrier from marignon
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Slaanesh/Slaanesh_Knight_Mount.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Knight_Mount2.tga"
#name "Chaos Steed"
#descr "Chaos Steeds are to the warhorses of the realms of men what Chaos Warriors are to their soldiers; these beasts are larger, stronger, and more vicious than any normal horse. Unlike most horses there is a good chance they will continue to fight even if their rider is slain, such is their aggressive nature."
#gcost 25
#prot 5 -- +1 for hardiness
#armor 254 -- plate barding
#snow
#coldres 5
#mor 11
#mr 9 -- +4
#hp 25 -- +5
#bravemount 50
#att 11 -- +1
#str 16 -- +1
#def 13 -- +1
#maxage 50 -- +30
#ap 25 -- +2
#mapmove 22 -- +2
#unsurr 1
#wastesurvival
#end


---- Chosen Knight of Slaanesh

#newmonster 14239
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Chosen_Knight.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Chosen_Knight2.tga"
#name "Chosen Knight"
#descr "As with Warriors, Chaos Knights strive to gain the favour of their patron God and become Chosen, the pinnacle of the Path of the Warrior. Chosen Knights are perhaps the most deadly heavy cavalry in existence, marrying supernatural physical strength, speed, and endurance with incredible skill at arms. Already deeply arrogant, Knights of Slaanesh who gain the status of Chosen come to see themselves as living embodiments of their God's multitudinous perfection, flawless mirrors placed to reflect the splendour of the Prince of Pleasure. Being Chosen of Slaanesh they are sacred to the followers of the Dark Prince.

[Requires friendly Dominion strength of 6+ in the province to recruit]"
#weapon 4 -- lance
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#ressize 2
#rcost 1
#mor 17 -- +1
#mr 12
#str 14 -- +1
#att 12 --- +1
#def 14 --- +1
#gcost 80 -- (110)
#holy
#awe 1
#unsurr 2
#montag 1034 -- forsaken, chosen knight, spawns
#montagweight 20
#domrec 6
#heal
#skilledrider 3
#mountmnr 14432
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Chosen_Knight_Unmounted.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Chosen_Knight_Unmounted2.tga"
#startage 80
#maxage 400
#end


-----Chaos Steed (chosen knight)

#newmonster 14432
#copystats 3897 -- destrier from marignon
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Slaanesh/Slaanesh_Chosen_Knight_Mount.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Chosen_Knight_Mount2.tga"
#name "Chaos Steed"
#descr "Chaos Steeds are to the warhorses of the realms of men what Chaos Warriors are to their soldiers; these beasts are larger, stronger, and more vicious than any normal horse. The steeds of the Chosen are braver and more vicious than the Chaos Steeds of their lesser counterparts."
-- stats compared chaos steed
#gcost 30 -- +5
#prot 5
#armor 254 -- plate barding
#snow
#coldres 5
#mor 12
#mr 10 -- +1
#hp 25
#bravemount 100
#att 11
#str 17 -- +1
#def 12 -- +1
#maxage 250
#ap 25 -- +2
#mapmove 22 -- +2
#wastesurvival
#holy
#awe 1
#unsurr 2
#heal
#end


---- Chaos Ogre

#newmonster 14216
#spr1 "Warhammer_Slaanesh/Slaanesh_Chaos_Ogre.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Chaos_Ogre2.tga"
#name "Chaos Ogre"
#descr "Ogres are large humanoid creatures known for their gluttony, strength, and love of violence. While they are typically quite resistant to both the warping taint of Chaos and the tempting whispers of the Dark Prince, they are naturally drawn to promises of excess and violence and so can often be found in the forces of Slaanesh. Even fairly small Marauder forces can occasionally find themselves benefitting from the presence of a handful of Ogres because these creatures are natural opportunists and recognise that in a smaller force they can bully their way to getting a larger share of the loot. Chaos Ogres have, despite their natural resistances, been changed by their exposure to Chaos and the attentions of the Ruinous Powers and are even stronger and more ferocious fighters than their former fellows in the Ogre Kingdoms. The Ogres who dwell in Slaaneshi lands have gained an ephemeral quality. They emit an almost smoky enchanted air, making them difficult to strike."
#hp 30
#size 5
#prot 5
#mor 11
#mr 12 -- +1
#enc 3
#str 16 -- +1
#att 10 -- +1
#def 13 -- +1
#prec 8
#mapmove 18
#ap 16
#weapon 17 -- axe
#weapon 10 -- falchion
#armor 118 -- half helmet
#armor 989 -- plate cuirass
#gcost 35
#rpcost 13
#rcost 1
#maxage 60
#mountainsurvival
#wastesurvival
#snow -- added
#coldres 5
#appetite 3 -- one more severe
#ambidextrous 2
#pillagebonus 2
#darkvision 25
#unsurr 1
#glamour
#ressize 3 -- just to reduce rcost
#end


---- Chaos Troll

#newmonster 14220
#spr1 "Warhammer_Slaanesh/Slaanesh_Chaos_Troll.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Chaos_Troll2.tga"
#name "Chaos Troll"
#descr "Trollflesh is somewhat succeptible to the warping influence of Chaos but their natural ability to regenerate wages a constant battle with any mutation leading to the appearance of Chaos Trolls varying wildly and changing near constantly. Chaos Trolls are typically smarter, more aggressive, and more coordinated than the Trolls that find themselves goaded into battle by Greenskins but are still fundamentally brutish and prone to do whatever they please in a given moment; nonetheless Chaos warbands will entice them with a share of the loot and use them in battle. They are immensely strong and tough creatures famed for their regenerative prowess and are capable of vomiting a torrent of acidic bile on their opponents.

[Recruitment limited to 2 per month]"
#hp 37
#size 5
#prot 9
#mor 10
#mr 13 -- -1
#enc 3
#str 18
#att 10 -- +1
#def 13 -- +1
#prec 4
#mapmove 16
#ap 16
#gcost 50 -- increased from 45 because of extra bite
#rpcost 14
#rcost 1
#weapon 1094 -- troll vomit
#weapon 10 -- falchion
#weapon 1095 -- spiked mace
#weapon 20 -- bite
#mountainsurvival
#wastesurvival
#snow
#darkvision 50
#heal --- recuperation ability
#regeneration 15 -- half again as good as normal
#fireres -5
#acidres -5
#undisciplined
#reclimit 2
#appetite 2
#startage 100
#maxage 5000
#coldres 5
#ambidextrous 4
#unsurr 1
#end


---- Hellstrider (new mounted)

#newmonster 14231
#copystats 14200 -- slaaneshi marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Hellstrider.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Hellstrider2.tga"
#name "Marauder Hellstrider"
#descr "Hellstriders are devotees of torment, Marauders who hunt from the back of impossibly swift Daemonic Steeds of Slaanesh. These gifts from the Dark Prince come at a great price, for the Hellstrider is curse, or perhaps blessed, to feel the pain of every victim of his hunts and expected to revel in the sensations. The Steeds are said to be made from the guilty desires of living creatures and as such can never be outrun, for no being could possibly escape its own darkest yearnings; what is certainly true is that their agility and speed is far beyond that of a horse. Steeds constantly taste the air with their long, whiplike tongues, sampling the scents and flavours of souls carried by the ever present the Winds of Magic and they are capable of hunting down almost any quarry. In battle the Marauder lashes his foes with a life draining Hellscourge whip while the Steed's tongue whips out at lightning speed, delivering poisons both deadly and psychoactive. Should the Marauder be struck from his Steed the beast will fight on for the rest of the battle.

[Requires friendly Dominion strength of 5 in the province to recruit]"
#prec 11
#mr 11 -- +1 for mount
#mor 13 -- +1
#gcost 50 -- the mount doesn't cost any gold, so this is correct
#weapon 1124 -- hellscourge
#armor 118 -- half helmet
#armor 6 -- ring mail cuirass -- lighter armour because super fast cav
#armor 2 -- shield
#spiritsight
#pillagebonus 2 -- +1
#skilledrider 2
#mountmnr 14232 -- Steed of Slaanesh
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Hellstrider_Unmounted.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Hellstrider_Unmounted2.tga"
#domrec 5
#end

---- Steed of Slaanesh

#newmonster 14232
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Steed.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Steed2.tga"
#name "Steed of Slaanesh"
#descr "Steeds of Slaanesh are said to be made from the guilty desires of living creatures and as such can never be outrun, for no being could possibly escape its own darkest yearnings; what is certainly true is that their agility and speed is far beyond that of a horse. They constantly taste the air with their long, whiplike tongues, sampling the scents and flavours of souls carried by the ever present the Winds of Magic and they are capable of hunting down almost any quarry, particularly when driven on by a Daemonette eager to deliver a new plaything to Slaanesh's embrace. In battle the Steed carries a deadly weapon in the form of its impossibly dextrous tongue, constantly dripping poisons both deadly and psychoactive. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks."
#ap 32 -- fastest cav in the game, tied with centauride
#mapmove 28 -- same as a shade beast, tireless, fast
#hp 14 -- daemonette + 2
#prot 8
#size 4 -- smaller than horse
#str 12 -- S3, daemon
#enc 1 -- daemon
#att 10 -- WS3 I5
#def 13 -- WS3 I5
#prec 11
#mr 13
#mor 30
#gcost 0
#rcost 1
#rpcost 18 -- war horse +3
#weapon 1125 -- poisonous whiptongue (str based version)
#startage 20
#maxage 10000
#poisonres 10
#demon
#animal
#neednoteat
#unsurr 3
#spiritsight
#patrolbonus 5 -- sort of standard really good patrol bonus
#bird -- most similar shape
#coldres 5
#snow
#nametype 272 -- slaaneshi daemon
#smartmount 100
#bravemount 100
#heal
#end


---- Daemonette

#newmonster 14255
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Daemonette.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Daemonette2.tga"
#name "Daemonette"
#descr "Daemonettes are the most numerous of Slaanesh's servants. They are shrouded in a hypnotic glamour, seditious magics that bestow them a perverse beauty. Daemonettes surge across the battlefield on lithe legs, capering and dancing from foe to foe, claws slicing through flesh and armour with ease. When battle is done, Daemonettes stride amongst the fallen and bring their souls to Slaanesh's palace in the Realm of Chaos, to receive eternal pleasure or pain at the whim of their capricious master. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#ap 16 -- fast
#mapmove 22 -- tireless
#hp 12
#prot 10 -- T3, but some carapace
#size 3
#str 13 -- S3, daemon -- +1 over the dark elf version beause the claws are weaker
#enc 1 -- daemon
#att 12 -- WS5 I5, daemon
#def 14
#prec 11
#mr 13
#mor 30
#gcost 0
#rcost 1
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#startage 20
#maxage 10000
#poisonres 10
#demon
#neednoteat
#female
#glamour
#unsurr 2
#ambidextrous 2
#nametype 199 -- slaaneshi daemon
#notdomshape 14256
#heal --- recuperation ability
#coldres 5
#snow
#end


---- Daemonette (outside of dominion)

#newmonster 14256
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Daemonette.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Daemonette2.tga"
#name "Daemonette"
#descr "Daemonettes are the most numerous of Slaanesh's servants. They are shrouded in a hypnotic glamour, seditious magics that bestow them a perverse beauty. Daemonettes surge across the battlefield on lithe legs, capering and dancing from foe to foe, claws slicing through flesh and armour with ease. When battle is done, Daemonettes stride amongst the fallen and bring their souls to Slaanesh's palace in the Realm of Chaos, to receive eternal pleasure or pain at the whim of their capricious master. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God.

[This Daemonette is outside of friendly Dominion and has reduced stats]"
#ap 16 -- fast
#mapmove 22 -- tireless
#hp 10 -- -2
#prot 8 -- -1
#size 3
#str 12 -- -1
#enc 3 -- +2
#att 11 -- -1
#def 13 -- -1
#prec 10 -- -1
#mr 12 -- -1
#mor 30
#gcost 0
#rcost 1
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#startage 20
#maxage 10000
#poisonres 10
#demon
#neednoteat
#female
#unsurr 2
#ambidextrous 2
#nametype 199 -- slaaneshi daemon
#domshape 14255
#coldres 5
#snow
#end


---- Seeker of Slaanesh (new mounted)

#newmonster 14257
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Seeker.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Seeker2.tga"
#name "Seeker of Slaanesh"
#descr "Seekers of Slaanesh are the Dark Prince of Chaos' outriders, Daemonettes mounted on swift daemonic Steeds that can dart across a battlefield in a moment. It is said that the Steeds are made from the guilty desires of living creatures and as such can never be outrun, for no being could possibly escape its own darkest yearnings; what is certainly true is that their agility and speed is far beyond that of a horse. Steeds constantly taste the air with their long, whiplike tongues, sampling the scents and flavours of souls carried by the ever present the Winds of Magic and they are capable of hunting down almost any quarry, particularly when driven on by a Daemonette eager to deliver a new plaything to Slaanesh's embrace. In battle the claws of the Daemonette are the greatest threat presented by a Seeker, but the Steed itself carries a deadly weapon in the form of its impossibly dextrous tongue, constantly dripping poisons both deadly and psychoactive. Should the Daemonette be struck from her Steed the beast will fight on for the rest of the battle before returning to the Realm of Chaos. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#ap 16 -- fast
#mapmove 22 -- tireless
#hp 12 -- daemonette
#prot 10 -- T3, but some carapace, +1 for mount
#size 3
#str 13 -- S3, daemon
#enc 1 -- daemon
#att 12 -- WS5 I5, daemon
#def 13
#prec 11
#mr 14 -- +1 for mount
#mor 30
#gcost 0
#rcost 1
#weapon 2502 -- Temptation
#weapon 1127 -- wicked claw
#startage 20
#maxage 10000
#poisonres 10
#demon
#neednoteat
#female
#glamour
#unsurr 2
#spiritsight
#ambidextrous 2
#nametype 199 -- slaaneshi daemon
#patrolbonus 3 -- 2 less than seeker
#notdomshape 14258
#heal --- recuperation ability
#coldres 5
#snow
#skilledrider 2
#mountmnr 10009 -- Steed of Slaanesh
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Daemonette.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Daemonette2.tga"
#end


---- Seeker of Slaanesh (outside of dominion) (new mounted)

#newmonster 14258
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Seeker.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Seeker2.tga"
#name "Seeker of Slaanesh"
#descr "Seekers of Slaanesh are the Dark Prince of Chaos' outriders, Daemonettes mounted on swift daemonic Steeds that can dart across a battlefield in a moment. It is said that the Steeds are made from the guilty desires of living creatures and as such can never be outrun, for no being could possibly escape its own darkest yearnings; what is certainly true is that their agility and speed is far beyond that of a horse. Steeds constantly taste the air with their long, whiplike tongues, sampling the scents and flavours of souls carried by the ever present the Winds of Magic and they are capable of hunting down almost any quarry, particularly when driven on by a Daemonette eager to deliver a new plaything to Slaanesh's embrace. In battle the claws of the Daemonette are the greatest threat presented by a Seeker, but the Steed itself carries a deadly weapon in the form of its impossibly dextrous tongue, constantly dripping poisons both deadly and psychoactive. Should the Daemonette be struck from her Steed the beast will fight on for the rest of the battle before returning to the Realm of Chaos. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God.

[This Seeker is outside of friendly Dominion and has reduced stats]"
#ap 16 -- fast
#mapmove 22 -- tireless
#hp 10 -- -2
#prot 8 -- -1
#size 3
#str 12 -- -1
#enc 3 -- +1
#att 11 -- -1
#def 13 -- -1
#prec 10 -- -1
#mr 13 -- -1
#mor 30
#gcost 0
#rcost 1
#weapon 2502 -- Temptation
#weapon 1127 -- wicked claw
#startage 20
#maxage 10000
#poisonres 10
#demon
#neednoteat
#female
#spiritsight
#unsurr 2
#ambidextrous 2
#nametype 199 -- slaaneshi daemon
#patrolbonus 3 -- 2 less than seeker
#domshape 14257
#coldres 5
#snow
#skilledrider 2
#mountmnr 10010 -- Steed of Slaanesh
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Daemonette.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Daemonette2.tga"
#end

-- Steed of Slaanesh (Seeker mount, in dominion)

#newmonster 10009
#copystats 14232
#copyspr 14232
#name "Steed of Slaanesh"
#glamour
#notdomshape 10010
#end

-- Steed of Slaanesh (Seeker mount, out of dominion)

#newmonster 10010
#copystats 14232
#copyspr 14232
#name "Steed of Slaanesh"
#domshape 10009
#end


---- Fiend of Slaanesh

#newmonster 14265
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Fiend.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Fiend2.tga"
#name "Fiend of Slaanesh"
#descr "Fiends are hypnotically agile beasts of Slaanesh, hellish creatures which moves with incredible, disturbing speed on their four strangley-jointed legs. Fiends are rather more delicate and less physically powerful than the beasts of the other Ruinous Powers but their speed, reflexes, and armour shredding pincers make them formidable indeed, as does the poisonous stinger with which they can send their prey into a coma in which all sensation is greatly amplified. Fiends appear repulsive from a distance but when they come close they emit an intoxicating musk which renders their movements to appear so graceful that mortals have a hard time striking them. As with all Daemons of Chaos these scuttling horrors are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#ap 32 -- fastest cav in the game, tied with centauride
#mapmove 28 -- same as a shade beast, tireless, fast
#hp 26 -- W3 T4
#prot 11
#size 5
#str 15 -- S4 daemon
#enc 1 -- daemon
#att 12
#def 16
#prec 11
#mr 14
#mor 30
#gcost 0
#rcost 1
#weapon 1127 -- wicked claw
#weapon 1127 -- wicked claw
#weapon 1130 -- coma inducing stinger
#startage 44
#maxage 10000
#poisonres 25 -- immune to poison virtually
#demon
#neednoteat
#spiritsight
#glamour
#unsurr 4
#nametype 199 -- slaaneshi daemon
#patrolbonus 5 -- sort of standard really good patrol bonus
#notdomshape 14266 -- not dominion fiend
#heal --- recuperation ability
#coldres 5
#snow
--
#end


---- Fiend of Slaanesh (out of dominion)

#newmonster 14266
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Fiend.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Fiend2.tga"
#name "Fiend of Slaanesh"
#descr "Fiends are hypnotically agile beasts of Slaanesh, hellish creatures which moves with incredible, disturbing speed on their four strangley-jointed legs. Fiends are rather more delicate and less physically powerful than the beasts of the other Ruinous Powers but their speed, reflexes, and armour shredding pincers make them formidable indeed, as does the poisonous stinger with which they can send their prey into a coma in which all sensation is greatly amplified. Fiends appear repulsive from a distance but when they come close they emit a musk which renders their movements to appear so graceful that mortals have a hard time striking. As with all Daemons of Chaos these scuttling horrors are highly resistant to physical attacks but grow weaker outside the Dominion of their God.

[This Fiend is outside of friendly Dominion and has reduced stats]"
#ap 32 -- fastest cav in the game, tied with centauride
#mapmove 28 -- same as a shade beast, tireless, fast
#hp 20 -- -6
#prot 9 -- -2
#size 5
#str 13 -- -2
#enc 3 -- +2
#att 11 -- -1
#def 15 -- -1
#prec 10 -- 1
#mr 13 -- -1
#mor 30
#gcost 0
#rcost 1
#weapon 1127 -- wicked claw
#weapon 1127 -- wicked claw
#weapon 1130 -- coma inducing stinger
#startage 44
#maxage 10000
#poisonres 25 -- immune to poison virtually
#demon
#neednoteat
#spiritsight
#unsurr 4
#nametype 199 -- slaaneshi daemon
#domshape 14265 -- not dominion fiend
#coldres 5
#snow
--
#end


---------- SPAWNS

-- generic spawn with no montag, for the purposes of copystatting to all the montag sets

-- Size 3, eyeballs

#newmonster 14443
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Eyeballs.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Eyeballs2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 33
#size 5
#prot 7
#mor 30
#mr 13
#enc 1
#str 15
#att 10
#def 10
#prec 12 -- loads of eyes
#mapmove 18
#ap 16 -- the slowest of the spawn is still quite fast
#gcost 0
#weapon 1084 -- pincer claw
#weapon 236 -- claw
#weapon 20 -- bite
#darkvision 50
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 5
#coldres 5
#unsurr 1
#snow
#end

-- Size 3, sail, pincers, tongue

#newmonster 14444
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Sail_Pincers_Tongue.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Sail_Pincers_Tongue2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 33
#size 5
#prot 8 -- +1 from the sail
#mor 30
#mr 13
#enc 1
#str 15
#att 10
#def 10
#prec 8
#blind
#mapmove 18
#ap 18
#gcost 0
#weapon 1084 -- pincer claw
#weapon 1084 -- pincer claw
#weapon 1125 -- poisonous whiptongue (str based version)
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 0
#coldres 5
#unsurr 1
#snow
#end

-- Size 3, big eye, pincer, tentacles

#newmonster 14445
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Eye_Pincer_Tentacles.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Eye_Pincer_Tentacles2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 33
#size 5
#prot 7
#mor 30
#mr 15 -- +2 for the big eye
#enc 1
#str 15
#att 10
#def 10
#prec 12
#mapmove 18
#ap 18
#gcost 0
#weapon 1084 -- pincer claw
#weapon 85 -- tentacle
#weapon 1097 -- small tentacles
#spiritsight
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 1
#coldres 5
#unsurr 1
#snow
#end


-- Size 3, big eye, pincers

#newmonster 14446
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Eye_Pincers.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Eye_Pincers2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 33
#size 5
#prot 7
#mor 30
#mr 15 -- +2 for the big eye
#enc 1
#str 15
#att 10
#def 10
#prec 12
#mapmove 18
#ap 18
#gcost 0
#weapon 1084 -- pincer claw
#weapon 1084 -- pincer claw
#spiritsight
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 1
#coldres 5
#unsurr 1
#snow
#end


-- Size 3, pincers, tongue, tentacles

#newmonster 14447
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Tongue_Pincers_Tentacles.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Tongue_Pincers_Tentacles2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 33
#size 5
#prot 7
#mor 30
#mr 13
#enc 1
#str 15
#att 10
#def 10
#prec 8
#blind
#mapmove 18
#ap 18
#gcost 0
#weapon 1084 -- pincer claw
#weapon 1084 -- pincer claw
#weapon 1125 -- poisonous whiptongue (str based version)
#weapon 1097 -- small tentacles
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 0
#coldres 5
#unsurr 1
#snow
#end


-- Size 3, serpent, tentacles, pincers

#newmonster 14448
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Serpent_Tentacles_Pincers.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Serpent_Tentacles_Pincers2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 25
#size 5
#prot 7
#mor 30
#mr 13
#enc 1
#str 14
#att 11
#def 11
#prec 8
#blind
#mapmove 18
#ap 20
#gcost 0
#weapon 1084 -- pincer claw
#weapon 1084 -- pincer claw
#weapon 1097 -- small tentacles
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 0
#naga
#glamour
#unsurr 1
#coldres 5
#snow
#end


-- Size 3, serpent, tentacles, spit

#newmonster 14449
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Serpent_Tentacles_Spit.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_3_Serpent_Tentacles_Spit2.tga"
#name "Lesser Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 25
#size 5
#prot 6
#mor 30
#mr 13
#enc 1
#str 16
#att 10
#def 10
#prec 12
#blind
#mapmove 18
#ap 20
#gcost 0
#weapon 1097 -- small tentacles
#weapon 599 -- corrosive spit
#weapon 324 -- poison spit, same as bog beast
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 0
#naga
#unsurr 2
#coldres 5
#snow
#end



-- Size 4, pincers, tongue

#newmonster 14450
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_4_Tongue_Pincers.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_4_Tongue_Pincers2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 55
#size 6
#prot 9
#mor 30
#mr 14
#enc 1
#str 20
#att 10
#def 11
#prec 8
#blind
#mapmove 20
#ap 18
#gcost 0
#weapon 1084 -- pincer claw
#weapon 1084 -- pincer claw
#weapon 1125 -- poisonous whiptongue (str based version)
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 0
#fear 5
#unsurr 1
#coldres 5
#snow
#end


-- Size 4, serpent, bone, pincer

#newmonster 14451
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_4_Serpent_Bone_Pincer.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_4_Serpent_Bone_Pincer2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 55
#size 6
#prot 9
#mor 30
#mr 14
#enc 1
#str 20
#att 11
#def 11
#prec 8
#mapmove 20
#ap 20
#gcost 0
#weapon 1132 -- bone blade
#weapon 1084 -- pincer claw
#weapon 532 -- tail sweep
#armor 118 -- half helmet
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 2
#fear 5
#unsurr 3
#naga
#coldres 5
#snow
#end


-- Size 5, tail, bone

#newmonster 14452
#spr1 "Warhammer_Slaanesh/Slaanesh_Spawn_5_Tail_Bone.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Spawn_5_Tail_Bone2.tga"
#name "Greater Chaos Spawn"
#descr "Those who seek the attention of one of the Ruinous Powers and receive it but are found lacking may find their quest for greatness ends in the form of a gibbering Chaos Spawn, a creature warped beyond recognition by the power of Chaos. Chaos Spawn take a great many shapes and forms according to both the whims of the Chaos God in question and the qualities of the one changed into this monstrosity. The Chaos Spawn of Slaanesh tend to be slithering, writhing abominations that hurtle across the battlefield at great speed to tear the foe apart with probing tentacles and wickedly sharp claws."
#hp 70
#size 8
#prot 11
#mor 30
#mr 14
#enc 1
#str 23
#att 10
#def 10
#prec 8
#mapmove 20
#ap 20
#gcost 0
#weapon 1132 -- bone blade
#weapon 532 -- tail sweep
#armor 118 -- half helmet
#heal --- recuperation ability
#berserk 1
#startage 100
#maxage 5000
#eyes 2
#fear 5
#unsurr 2
#coldres 5
#snow
#end



-------- spawn pool for warrior promotions

-- Size 3, eyeballs

#newmonster 14219
#copystats 14443
#copyspr 14443
#firstshape 14443
#montag 1030 -- chosen, forsaken, spawns
#end

-- Size 3, sail, pincers, tongue

#newmonster 14244
#copystats 14444
#copyspr 14444
#firstshape 14444
#montag 1030 -- chosen, forsaken, spawns
#end

-- Size 3, big eye, pincer, tentacles

#newmonster 14247
#copystats 14445
#copyspr 14445
#firstshape 14445
#montag 1030 -- chosen, forsaken, spawns
#end


-- Size 3, big eye, pincers

#newmonster 14271
#copystats 14446
#copyspr 14446
#firstshape 14446
#montag 1030 -- chosen, forsaken, spawns
#end


-- Size 3, pincers, tongue, tentacles

#newmonster 14274
#copystats 14447
#copyspr 14447
#firstshape 14447
#montag 1030 -- chosen, forsaken, spawns
#end


-- Size 3, serpent, tentacles, pincers

#newmonster 14277
#copystats 14448
#copyspr 14448
#firstshape 14448
#montag 1030 -- chosen, forsaken, spawns
#end


-- Size 3, serpent, tentacles, spit

#newmonster 14280
#copystats 14449
#copyspr 14449
#firstshape 14449
#montag 1030 -- chosen, forsaken, spawns
#end



-- Size 4, pincers, tongue

#newmonster 14283
#copystats 14450
#copyspr 14450
#firstshape 14450
#montag 1030 -- chosen, forsaken, spawns
#end


-- Size 4, serpent, bone, pincer

#newmonster 14286
#copystats 14451
#copyspr 14451
#firstshape 14451
#montag 1030 -- chosen, forsaken, spawns
#end


-- Size 5, tail, bone

#newmonster 14289
#copystats 14452
#copyspr 14452
#firstshape 14452
#montag 1030 -- chosen, forsaken, spawns
#end




---- SPAWNS IN THE KNIGHT POOL

-- Size 3, eyeballs

#newmonster 14242
#copystats 14443
#copyspr 14443
#firstshape 14443
#montag 1034 -- forsaken, chosen knight, spawns
#end

-- Size 3, sail, pincers, tongue

#newmonster 14245
#copystats 14444
#copyspr 14444
#firstshape 14444
#montag 1034 -- forsaken, chosen knight, spawns
#end

-- Size 3, big eye, pincer, tentacles

#newmonster 14248
#copystats 14445
#copyspr 14445
#firstshape 14445
#montag 1034 -- forsaken, chosen knight, spawns
#end

-- Size 3, big eye, pincers

#newmonster 14272
#copystats 14446
#copyspr 14446
#firstshape 14446
#montag 1034 -- forsaken, chosen knight, spawns
#end

-- Size 3, tentacles, pincers, tongue

#newmonster 14275
#copystats 14447
#copyspr 14447
#firstshape 14447
#montag 1034 -- forsaken, chosen knight, spawns
#end

-- Size 3, serpent, tentacles, pincers

#newmonster 14278
#copystats 14448
#copyspr 14448
#firstshape 14448
#montag 1034 -- forsaken, chosen knight, spawns
#end

-- Size 3, serpent, tentacles, spit

#newmonster 14281
#copystats 14449
#copyspr 14449
#firstshape 14449
#montag 1034 -- forsaken, chosen knight, spawns
#end

-- Size 4, pincers, tongue

#newmonster 14284
#copystats 14450
#copyspr 14450
#firstshape 14450
#montag 1034 -- forsaken, chosen knight, spawns
#end

-- Size 4, serpent, bone, pincer

#newmonster 14287
#copystats 14451
#copyspr 14451
#firstshape 14451
#montag 1034 -- forsaken, chosen knight, spawns
#end

-- Size 5, tail, bone

#newmonster 14290
#copystats 14452
#copyspr 14452
#firstshape 14452
#montag 1034 -- forsaken, chosen knight, spawns
#end




---- SPAWNS THAT COMMANDERS CAN TURN INTO

-- Size 3, eyeballs

#newmonster 14309
#copystats 14443
#copyspr 14443
#firstshape 14443
#montag 1033 -- commander spawns
#end

-- Size 3, sail, pincers, tongue

#newmonster 14246
#copystats 14444
#copyspr 14444
#firstshape 14444
#montag 1033 -- commander spawns
#end

-- Size 3, big eye, pincer, tentacles

#newmonster 14249
#copystats 14445
#copyspr 14445
#firstshape 14445
#montag 1033 -- commander spawns
#end

-- Size 3, big eye, pincers

#newmonster 14273
#copystats 14446
#copyspr 14446
#firstshape 14446
#montag 1033 -- commander spawns
#end

-- Size 3, tentacles, pincers, tongue

#newmonster 14276
#copystats 14447
#copyspr 14447
#firstshape 14447
#montag 1033 -- commander spawns
#end

-- Size 3, serpent, tentacles, pincers

#newmonster 14279
#copystats 14448
#copyspr 14448
#firstshape 14448
#montag 1033 -- commander spawns
#end

-- Size 3, serpent, tentacles, spit

#newmonster 14282
#copystats 14449
#copyspr 14449
#firstshape 14449
#montag 1033 -- commander spawns
#end

-- Size 4, pincers, tongue

#newmonster 14285
#copystats 14450
#copyspr 14450
#firstshape 14450
#montag 1033 -- commander spawns
#montagweight 4
#end

-- Size 4, serpent, bone, pincer

#newmonster 14288
#copystats 14451
#copyspr 14451
#firstshape 14451
#montag 1033 -- commander spawns
#montagweight 4
#end

-- Size 5, tail, bone

#newmonster 14291
#copystats 14452
#copyspr 14452
#firstshape 14452
#montag 1033 -- commander spawns
#montagweight 4
#end





---- Generic Summon Spawns

-- Size 3, eyeballs

#newmonster 14292
#copystats 14443
#copyspr 14443
#firstshape 14443
#montag 1037 -- generic spawns
#end

-- Size 3, sail, pincers, tongue

#newmonster 14293
#copystats 14444
#copyspr 14444
#firstshape 14444
#montag 1037 -- generic spawns
#end

-- Size 3, big eye, pincer, tentacles

#newmonster 14294
#copystats 14445
#copyspr 14445
#firstshape 14445
#montag 1037 -- generic spawns
#end

-- Size 3, big eye, pincers

#newmonster 14295
#copystats 14446
#copyspr 14446
#firstshape 14446
#montag 1037 -- generic spawns
#end

-- Size 3, tentacles, pincers, tongue

#newmonster 14296
#copystats 14447
#copyspr 14447
#firstshape 14447
#montag 1037 -- generic spawns
#end

-- Size 3, serpent, tentacles, pincers

#newmonster 14297
#copystats 14448
#copyspr 14448
#firstshape 14448
#montag 1037 -- generic spawns
#end

-- Size 3, serpent, tentacles, spit

#newmonster 14298
#copystats 14449
#copyspr 14449
#firstshape 14449
#montag 1037 -- generic spawns
#end

-- Size 4, pincers, tongue

#newmonster 14299
#copystats 14450
#copyspr 14450
#firstshape 14450
#montag 1037 -- generic spawns
#end

-- Size 4, serpent, bone, pincer

#newmonster 14300
#copystats 14451
#copyspr 14451
#firstshape 14451
#montag 1037 -- generic spawns
#end

-- Size 5, tail, bone

#newmonster 14301
#copystats 14452
#copyspr 14452
#firstshape 14452
#montag 1037 -- generic spawns
#end



---------- COMMANDERS


---- Herald of Slaanesh

#newmonster 14260
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald2.tga"
#name "Herald of Slaanesh"
#descr "Foremost amongst the ranks of the Daemonettes are the Heralds of Slaanesh. It is their purpose not only to attend to Slaanesh's whimsical desires, but muster his armies, take care of military details which would bore the Dark Prince, and carry his creed to the mortal realm. Slaanesh is always hungry for morsels of courtly intrigue and such scraps can lead to the corrupting of a mortal ruler, a matter to which the Lord of Excess is always attentive. At times the Heralds carry their master's word to specific individuals singled out for divine notice. Not all such visitations are welcomed by those who receive them, for Slaanesh is nothing if not effusive in his tempers. In battle Heralds are powerful champions imbued with grace, might, and presence by their benefactor. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Heralds are messengers of Slaanesh's will an as such have priestly authority.

[This Herald of Slaanesh will transform into a form capable of seducing either males or females]"
#ap 16 -- fast
#mapmove 22 -- tireless
#hp 22 -- T3 W2, daemon
#prot 12 -- T3, but some carapace
#size 3
#str 15
#enc 1 -- daemon
#att 14 -- daemonette +2
#def 16
#prec 11
#mr 15 -- daemon + tier 2
#mor 30
#gcost 0
#rcost 1
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#startage 200
#maxage 10000
#poisonres 10
#demon
#neednoteat
#female
#glamour
#unsurr 3
#ambidextrous 2
#seduce 10 -- standard +1
--
#stealthy 20 -- same as a spy
#spy
#goodundeadleader
#goodleader
#command -40 -- so 40 left
#nametype 199 -- slaaneshi daemon
#firstshape -1036 -- either male or female
#itemslots 991232 -- no hands, 1 torso, feet, 2 misc, head, no bow
#heal --- recuperation ability
#holy
#magicskill 9 2
#coldres 5
#snow
#end


---- Herald of Slaanesh (female, in dominion)

#newmonster 14261
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald2.tga"
#name "Herald of Slaanesh"
#descr "Foremost amongst the ranks of the Daemonettes are the Heralds of Slaanesh. It is their purpose not only to attend to Slaanesh's whimsical desires, but muster his armies, take care of military details which would bore the Dark Prince, and carry his creed to the mortal realm. Slaanesh is always hungry for morsels of courtly intrigue and such scraps can lead to the corrupting of a mortal ruler, a matter to which the Lord of Excess is always attentive. At times the Heralds carry their master's word to specific individuals singled out for divine notice. Not all such visitations are welcomed by those who receive them, for Slaanesh is nothing if not effusive in his tempers. In battle Heralds are powerful champions imbued with grace, might, and presence by their benefactor. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Heralds are messengers of Slaanesh's will an as such have priestly authority.

[This Herald of Slaanesh has been tasked with the seduction and corruption of males and so is considered female for the purposes of the Seduction command]"
#ap 16 -- fast
#mapmove 22 -- tireless
#hp 22 -- T3 W2, daemon
#prot 12 -- T3, but some carapace
#size 3
#str 15
#enc 1 -- daemon
#att 14 -- daemonette +2
#def 16
#prec 11
#mr 15 -- daemon + tier 2
#mor 30
#gcost 0
#rcost 1
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#startage 200
#maxage 10000
#poisonres 10
#demon
#neednoteat
#female
#glamour
#unsurr 3
#ambidextrous 2
#seduce 10 -- standard +1
--
#stealthy 20 -- same as a spy
#spy
#goodundeadleader
#goodleader
#command -40 -- so 40 left
#nametype 199 -- slaaneshi daemon
#montag 1036 -- either male or female
#notdomshape 14262
#itemslots 991232 -- no hands, 1 torso, feet, 2 misc, head, no bow
#heal --- recuperation ability
#holy
#magicskill 9 2
#coldres 5
#snow
#end


---- Herald of Slaanesh (female, out of dominion)

#newmonster 14262
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald2.tga"
#name "Herald of Slaanesh"
#descr "Foremost amongst the ranks of the Daemonettes are the Heralds of Slaanesh. It is their purpose not only to attend to Slaanesh's whimsical desires, but muster his armies, take care of military details which would bore the Dark Prince, and carry his creed to the mortal realm. Slaanesh is always hungry for morsels of courtly intrigue and such scraps can lead to the corrupting of a mortal ruler, a matter to which the Lord of Excess is always attentive. At times the Heralds carry their master's word to specific individuals singled out for divine notice. Not all such visitations are welcomed by those who receive them, for Slaanesh is nothing if not effusive in his tempers. In battle Heralds are powerful champions imbued with grace, might, and presence by their benefactor. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Heralds are messengers of Slaanesh's will an as such have priestly authority.

[This Herald of Slaanesh has been tasked with the seduction and corruption of males and so is considered female for the purposes of the Seduction command]
[This Herald of Slaanesh is outside of friendly Dominion and has reduced stats]"
#ap 16 -- fast
#mapmove 22 -- tireless
#hp 18 -- -4
#prot 9 -- -1
#size 3
#str 13 -- -2
#enc 2 -- +2
#att 13 -- -1
#def 15 -- -1
#prec 10 -- -1
#mr 13 -- -2
#mor 30
#gcost 0
#rcost 1
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#startage 200
#maxage 10000
#poisonres 10
#demon
#neednoteat
#female
#unsurr 3
#ambidextrous 2
#seduce 9 -- -1
--
#stealthy 20 -- same as a spy
#spy
#goodundeadleader
#goodleader
#command -40 -- so 40 left
#nametype 199 -- slaaneshi daemon
#domshape 14261
#itemslots 991232 -- no hands, 1 torso, feet, 2 misc, head, no bow
#holy
#magicskill 9 2
#coldres 5
#snow
#end


---- Herald of Slaanesh (male, in dominion)

#newmonster 14263
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald_Male.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald_Male2.tga"
#name "Herald of Slaanesh"
#descr "Foremost amongst the ranks of the Daemonettes are the Heralds of Slaanesh. It is their purpose not only to attend to Slaanesh's whimsical desires, but muster his armies, take care of military details which would bore the Dark Prince, and carry his creed to the mortal realm. Slaanesh is always hungry for morsels of courtly intrigue and such scraps can lead to the corrupting of a mortal ruler, a matter to which the Lord of Excess is always attentive. At times the Heralds carry their master's word to specific individuals singled out for divine notice. Not all such visitations are welcomed by those who receive them, for Slaanesh is nothing if not effusive in his tempers. In battle Heralds are powerful champions imbued with grace, might, and presence by their benefactor. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Heralds are messengers of Slaanesh's will an as such have priestly authority.

[This Herald of Slaanesh has been tasked with the seduction and corruption of females and so is considered male for the purposes of the Seduction command]"
#ap 16 -- fast
#mapmove 22 -- tireless
#hp 22 -- T3 W2, daemon
#prot 12 -- T3, but some carapace
#size 3
#str 15
#enc 1 -- daemon
#att 14 -- daemonette +2
#def 16
#prec 11
#mr 15 -- daemon + tier 2
#mor 30
#gcost 0
#rcost 1
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#startage 200
#maxage 10000
#poisonres 10
#demon
#neednoteat
#glamour
#unsurr 3
#ambidextrous 2
#seduce 10 -- standard +1
--
#stealthy 20 -- same as a spy
#spy
#goodundeadleader
#goodleader
#command -40 -- so 40 left
#nametype 199 -- slaaneshi daemon
#montag 1036 -- either male or female
#notdomshape 14264
#itemslots 991232 -- no hands, 1 torso, feet, 2 misc, head, no bow
#heal --- recuperation ability
#holy
#magicskill 9 2
#coldres 5
#snow
#end


---- Herald of Slaanesh (male, out of dominion)

#newmonster 14264
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald_Male.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Herald_Male2.tga"
#name "Herald of Slaanesh"
#descr "Foremost amongst the ranks of the Daemonettes are the Heralds of Slaanesh. It is their purpose not only to attend to Slaanesh's whimsical desires, but muster his armies, take care of military details which would bore the Dark Prince, and carry his creed to the mortal realm. Slaanesh is always hungry for morsels of courtly intrigue and such scraps can lead to the corrupting of a mortal ruler, a matter to which the Lord of Excess is always attentive. At times the Heralds carry their master's word to specific individuals singled out for divine notice. Not all such visitations are welcomed by those who receive them, for Slaanesh is nothing if not effusive in his tempers. In battle Heralds are powerful champions imbued with grace, might, and presence by their benefactor. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God. Heralds are messengers of Slaanesh's will an as such have priestly authority.

[This Herald of Slaanesh has been tasked with the seduction and corruption of females and so is considered male for the purposes of the Seduction command]
[This Herald of Slaanesh is outside of friendly Dominion and has reduced stats]"
#ap 16 -- fast
#mapmove 22 -- tireless
#hp 18 -- -4
#prot 9 -- -1
#size 3
#str 13 -- -2
#enc 2 -- +2
#att 13 -- -1
#def 15 -- -1
#prec 10 -- -1
#mr 13 -- -2
#mor 30
#gcost 0
#rcost 1
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#startage 200
#maxage 10000
#poisonres 10
#demon
#neednoteat
#unsurr 3
#ambidextrous 2
#seduce 9 -- -1
--
#stealthy 20 -- same as a spy
#spy
#goodundeadleader
#goodleader
#command -40 -- so 40 left
#nametype 199 -- slaaneshi daemon
#domshape 14263
#itemslots 991232 -- no hands, 1 torso, feet, 2 misc, head, no bow
#holy
#magicskill 9 2
#coldres 5
#snow
#end


---- Marauder Scout

#newmonster 14236
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Hunter.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Hunter2.tga"
#name "Marauder Scout"
#descr "Marauder Scouts are Hunters who have shown an aptitude for travelling unseen through enemy lands and reporting back to their masters. It can be a difficult thing for a Marauder to resist the urge for battle and pillage and remain concealed but the position of Scout does hold some degree of honour, for the wiley Chieftains know that they cannot successfully commit raids without knowledge of their targets."
#prec 11 -- +1 for ranged focus
#weapon 1 -- spear
#weapon 1085 -- javelin bundle (x4 javs)
#armor 119 -- reinforced leather cap
#armor 6 -- ring mail cuirass
#supplybonus 1 -- they are hunters after all
#mor 10 -- -1
#stealthy 10 -- normal for scout
#noleader
#rpcost 1
#gcost 35
#end


---- Aspiring Champion

#newmonster 14223
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Aspiring_Champion.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Aspiring_Champion2.tga"
#name "Aspiring Champion"
#descr "Even amongst the elite Chaos Warriors there are those who stand out as having the potential for a greater destiny still, not on the Path of the Warrior but of the Champion. Just as Warriors seek the favour of one of the Ruinous Powers that they might join the rankgs of the Chosen, Aspiring Champions seek to become Exalted Heroes, Chaos Lords, perhaps even reach the zenith of Daemonic Princehood. These Champions are leaders of small bands of Warriors who travel seeking challenges worthy of their great skills and push on to commit greater and greater deeds in the name of their God. Though every Champion believes themselves destined for greatness and so eagerly attempts to draw the eye of their God it is the fate of some to be found wanting in such an event and turned into a foul Chaos Spawn. Champions of Slaanesh tend to be particularly skilled swordsmen and favour the use of two curved blades which they wield with shocking skill and to deadly effect.

[When this Champion is promoted it will transform to a form which will then be further transformed by an event, either becoming an Exalted Hero (and losing all its XP) or being turned into a Chaos Spawn]"
#hp 25
#mor 16 -- +1
#mr 14 -- +2 for tier 2
#str 14 -- +1
#att 13
#def 15
#prec 12
#gcost 105
#rcost 1
#rpcost 1
#goodleader
#command -80 -- so 20
#ambidextrous 3
--
#weapon 10 -- falchion
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#xpshape 45
#poorundeadleader
#end


---- Aspiring Champion (ready for event)

#newmonster 14224
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Aspiring_Champion_Judgement.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Aspiring_Champion_Judgement2.tga"
#name "Aspiring Champion"
#descr "Even amongst the elite Chaos Warriors there are those who stand out as having the potential for a greater destiny still, not on the Path of the Warrior but of the Champion. Just as Warriors seek the favour of one of the Ruinous Powers that they might join the rankgs of the Chosen, Aspiring Champions seek to become Exalted Heroes, Chaos Lords, perhaps even reach the zenith of Daemonic Princehood. These Champions are leaders of small bands of Warriors who travel seeking challenges worthy of their great skills and push on to commit greater and greater deeds in the name of their God. Though every Champion believes themselves destined for greatness and so eagerly attempts to draw the eye of their God it is the fate of some to be found wanting in such an event and turned into a foul Chaos Spawn. Champions of Slaanesh tend to be particularly skilled swordsmen and favour the use of two curved blades which they wield with shocking skill and to deadly effect.

[This Champion is awaiting the event that will transform them to either an Exalted Hero (and losing all its XP) or a Chaos Spawn]"
#hp 25
#mor 16 -- +1
#mr 14 -- +2 for tier 2
#str 14 -- +1
#att 13
#def 15
#prec 12
#gcost 105
#rcost 1
#rpcost 1
#goodleader
#command -80 -- so 20
#ambidextrous 3
--
#weapon 10 -- falchion
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#poorundeadleader
#end


---- Exalted Hero

#newmonster 14237
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Exalted_Hero.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Exalted_Hero2.tga"
#name "Exalted Hero"
#descr "Exalted Heroes stand as paragons on the Path of the Warrior and the Champion, for they are everything that every Chaos Warrior and Aspiring Champion strives to be. The Exalted are monstrously powerful combatants capable of commanding forces of the mightiest warriors in the world, blessed many times over by their patron God and with an iron will to pursue their ambitions and become immortal. They are to the Aspiring Champions as the Chosen are to the Warriors, but unlike the Chosen they do not accept they have reached the zenith of their journey, for the prize of becoming a Chaos Lord and eventually a Daemon Prince still lies ahead of them and the risk of being reduced to a gibbering Chaos Spawn is one they gladly accept. Exalted Heroes of Slaanesh are incredibly talented artists of sensation and passion both on and off the battlefield, as capable of bringing men to tears with their singing, poetry, and dance as they are tearing through a formation of soldiers as a bloody whirlwhind of steel. They are also supremely arrogant to the point that they will actively force their troops to make space for them to enact a fittingly beautiful performance in battle.

[Requires friendly Dominion strength of 7 in the province to recruit]
[When this Exalted Hero is promoted it will transform to a form which will then be further transformed by an event, either becoming a Chaos Lord (and losing all its XP) or being turned into a Chaos Spawn]"
#hp 35
#mor 17 -- +1 over aspiring champion
#mr 15 -- +1
#str 15 -- +1
#att 14 -- +1
#def 16 -- +1
#prec 13 -- +1
#gcost 220
#rcost 1
#rpcost 2
#goodleader
#ambidextrous 3
--
#weapon 1126 -- long sword
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#xpshape 55
#holy
#size 4
#awe 1
#unsurr 2
#formationfighter -3
#okundeadleader
#domrec 7
#ap 16 -- +4 over human
#heal
#startage 80
#maxage 400
#end


---- Exalted Hero (awaiting event)

#newmonster 14238
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Exalted_Hero_Judgement.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Exalted_Hero_Judgement2.tga"
#name "Exalted Hero"
#descr "Exalted Heroes stand as paragons on the Path of the Warrior and the Champion, for they are everything that every Chaos Warrior and Aspiring Champion strives to be. The Exalted are monstrously powerful combatants capable of commanding forces of the mightiest warriors in the world, blessed many times over by their patron God and with an iron will to pursue their ambitions and become immortal. They are to the Aspiring Champions as the Chosen are to the Warriors, but unlike the Chosen they do not accept they have reached the zenith of their journey, for the prize of becoming a Chaos Lord and eventually a Daemon Prince still lies ahead of them and the risk of being reduced to a gibbering Chaos Spawn is one they gladly accept. Exalted Heroes of Slaanesh are incredibly talented artists of sensation and passion both on and off the battlefield, as capable of bringing men to tears with their singing, poetry, and dance as they are tearing through a formation of soldiers as a bloody whirlwhind of steel. They are also supremely arrogant to the point that they will actively force their troops to make space for them to enact a fittingly beautiful performance in battle.

[This Exalted Hero is awaiting the event that will transform them to either a Chaos Lord (and losing all its XP) or a Chaos Spawn]"
#hp 35
#mor 17 -- +1 over aspiring champion
#mr 15 -- +1
#str 15 -- +1
#att 14 -- +1
#def 16 -- +1
#prec 13 -- +1
#gcost 220
#rcost 1
#rpcost 2
#goodleader
#ambidextrous 3
--
#weapon 1126 -- long sword
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#holy
#size 4
#awe 1
#unsurr 2
#formationfighter -3
#okundeadleader
#ap 16 -- +4 over human
#heal
#startage 80
#maxage 400
#end


---- Chaos Lord

#newmonster 14267
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Chaos_Lord.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Chaos_Lord2.tga"
#name "Chaos Lord"
#descr "At the zenith of the mortal forces of the Ruinous Powers stand the Chaos Lords, champions and paragons of their patron God whose mere command can see tribes annihilated, cities sacked, and nations brought to the brink of disaster. Only the mightiest and most favoured Exalted Hero will survive to become a Chaos Lord, having overcome their enemies, their rivals, attempted punishments by the Ruinous Powers they have chosen not to follow, and even the capricious whims of their own God. Chaos Lords are extremely skilled combatants and physically far beyond the potential of mortal men in addition to being experienced and innately talented commanders. They are granted Daemonic mounts to carry them into battle and emphasize their status; in the case of Slaanesh a serpentine creature of blinding speed with a deadly lashing tongue and skin which exudes a calming musk that lulls opponents into holding back their blows. Should the Chaos Lord be slain, this mount will fight on before returning to the Chaos Realm of Slaanesh. Aside from continuing to crush their enemies and bring glory to Slaanesh, all that remains for this Chaos Lord is to prove themselves so fully that they are elevated to immortality in the form of a Daemon Prince.

[When this Chaos Lord is promoted it will transform to a form which will then be further transformed by an event, either finally becoming a Daemon Prince (and losing all its XP) or being turned into a Chaos Spawn]"
--stats compared with exalted hero
#hp 45 -- +10
#mor 20 -- +2
#mr 16 -- +1
#str 16 -- +1
#att 15 -- +1
#def 17 -- +1
#prec 14 -- +1
#gcost 290
#rcost 1
#rpcost 2
#expertleader
#ambidextrous 3
--
#weapon 1126 -- long sword
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#xpshape 70
#holy
#size 4
#goodundeadleader
#awe 2
#unsurr 2
#prot 5 -- +1
#poisonres 10 -- from mount
#spiritsight -- from mount
#xploss 100
#skilledrider 3
#mountmnr 14269 -- mount of Slaanesh
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Chaos_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Chaos_Lord_Unmounted2.tga"
#heal
#startage 100
#maxage 500
#end


---- Chaos Lord (awaiting event)

#newmonster 14268
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Chaos_Lord_Judgement.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Chaos_Lord_Judgement2.tga"
#name "Chaos Lord"
#descr "At the zenith of the mortal forces of the Ruinous Powers stand the Chaos Lords, champions and paragons of their patron God whose mere command can see tribes annihilated, cities sacked, and nations brought to the brink of disaster. Only the mightiest and most favoured Exalted Hero will survive to become a Chaos Lord, having overcome their enemies, their rivals, attempted punishments by the Ruinous Powers they have chosen not to follow, and even the capricious whims of their own God. Chaos Lords are extremely skilled combatants and physically far beyond the potential of mortal men in addition to being experienced and innately talented commanders. They are granted Daemonic mounts to carry them into battle and emphasize their status; in the case of Slaanesh a serpentine creature of blinding speed with a deadly lashing tongue and skin which exudes a calming musk that lulls opponents into holding back their blows. Should the Chaos Lord be slain, this mount will fight on before returning to the Chaos Realm of Slaanesh. Aside from continuing to crush their enemies and bring glory to Slaanesh, all that remains for this Chaos Lord is to prove themselves so fully that they are elevated to immortality in the form of a Daemon Prince.

[This Chaos Lord is awaiting the event that will transform them to either a Daemon Prince (and losing all its XP) or a Chaos Spawn]"
--stats compared with exalted hero
#hp 45 -- +10
#mor 20 -- +2
#mr 16 -- +1
#str 16 -- +1
#att 15 -- +1
#def 17 -- +1
#prec 14 -- +1
#gcost 290
#rcost 1
#rpcost 2
#expertleader
#ambidextrous 3
--
#weapon 1126 -- long sword
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 3 -- kite shield
#holy
#size 4
#goodundeadleader
#awe 2
#unsurr 2
#prot 5 -- +1
#poisonres 10 -- from mount
#spiritsight -- from mount
#xploss 100
#heal
#skilledrider 3
#mountmnr 14269 -- mount of Slaanesh
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Chaos_Lord_Unmounted_Judgement.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Chaos_Lord_Unmounted_Judgement2.tga"
#startage 100
#maxage 500
#end


---- Mount of Slaanesh

#newmonster 14269
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Mount.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Mount2.tga"
#name "Mount of Slaanesh"
#descr "Mounts of Slaanesh are bizarre serpentine creatures gifted to Chaos Lords high in Slaanesh's favour. They are quicksilver fast and instinctively deadly fighters with lashing poisonous tongues and, now that their rider is slain, are able to smash through formations of troops with sweeps of their tails. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks."
#ap 32 -- fastest cav in the game, tied with centauride
#mapmove 28 -- same as a shade beast, tireless, fast
#hp 42 -- big!
#prot 10
#size 6
#str 18
#enc 1 -- daemon
#att 12
#def 14
#prec 11
#mr 14
#mor 30
#gcost 0
#rcost 1
#weapon 1125 -- poisonous whiptongue (str based version)
#weapon 532 -- tail sweep
#startage 20
#maxage 10000
#poisonres 10
#demon
#animal
#neednoteat
#spiritsight
#xploss 100
#snake
#coldres 5
#holy
#bravemount 100
#heal
#glamour
#unsurr 4
#end



---- Daemon Prince of Slaanesh

#newmonster 14270
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Prince.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Prince2.tga"
#name "Daemon Prince"
#descr "Daemon Princes were once mortals, Chaos Lords that so pleased their patron God that the ultimate prize of immortality was bestowed upon them, along with a new form embodying the essence of the Chaos God that elevated them. Unlike Daemons, even Greater Daemons, a part of the Daemon Prince is forever its own, distinct from the sprawling energy of the God that granted it such power, for the Ruinous Powers enjoy seeing the schemes and ambitions of their most favoured followers play out across eternity. Daemon Princes of Slaanesh tend to take on serpentine traits, grow new limbs ending in impossibly sharp pincer claws, and exude an aura of sensuality that can greatly heighten or almost entirely dull the senses of those unfortunate enough to stand before them. While Chaos Lords of Slaanesh rely on Sorcerers or Shamans, Daemon Princes have an innate talent for sorcery in addition to their considerable martial prowess and physical might. While they are Daemons in form their past in the mortal world grants Daemon Princes the benefit of not becoming weaker outside the Dominion of their God, though like Greater Daemons they can still only reform their bodies if slain in this Dominion."
--stats compared with Keeper of Secrets
#hp 55 -- -11
#size 8
#prot 14 -- -2
#mor 30
#mr 18
#enc 1
#str 20
#att 15
#def 18 -- -1
#prec 13
#mapmove 18 -- -6
#ap 16 -- -6
#gcost 0
#weapon 477 -- unholy sword
#weapon 10 -- falchion
#weapon 1127 -- wicked claw
#armor 311 -- chaos helm
#armor 312 -- chaos plate cuirass
#neednoteat
#poisonres 10 -- +10
#diseaseres 100 -- +100
#demon
#magicskill 7 2 -- G2
#magicskill 4 2 -- S2
#magicskill 8 2 -- B1
#magicskill 9 3 -- H2
#holy
#expertleader
#expertundeadleader
#fear 5 -- -3
--
#itemslots 860678 -- normal, no feet
#wastesurvival
#awe 3 -- -1
#unsurr 3
#snow
#ambidextrous 4
#domimmortal
#reformtime 3 -- takes 6 months to reform
#maxage 9999
#startage 6666
#nametype 198 -- slaanesh warrior names
#heal --- recuperation ability
#combatcaster
#coldres 5
#end



---- Daemon Prince (-1 holy)

#newmonster 14128
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Prince.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Prince2.tga"
#name "Daemon Prince"
#descr "Daemon Princes were once mortals, Chaos Lords that so pleased their patron God that the ultimate prize of immortality was bestowed upon them, along with a new form embodying the essence of the Chaos God that elevated them. Unlike Daemons, even Greater Daemons, a part of the Daemon Prince is forever its own, distinct from the sprawling energy of the God that granted it such power, for the Ruinous Powers enjoy seeing the schemes and ambitions of their most favoured followers play out across eternity. Daemon Princes of Slaanesh tend to take on serpentine traits, grow new limbs ending in impossibly sharp pincer claws, and exude an aura of sensuality that can greatly heighten or almost entirely dull the senses of those unfortunate enough to stand before them. While Chaos Lords of Slaanesh rely on Sorcerers or Shamans, Daemon Princes have an innate talent for sorcery in addition to their considerable martial prowess and physical might. While they are Daemons in form their past in the mortal world grants Daemon Princes the benefit of not becoming weaker outside the Dominion of their God, though like Greater Daemons they can still only reform their bodies if slain in this Dominion."
--stats compared with Keeper of Secrets
#hp 55 -- -11
#size 8
#prot 14 -- -2
#mor 30
#mr 18
#enc 1
#str 20
#att 15
#def 17 -- -1
#prec 13
#mapmove 18 -- -6
#ap 16 -- -6
#gcost 0
#weapon 477 -- unholy sword
#weapon 10 -- falchion
#weapon 1127 -- wicked claw
#armor 311 -- chaos helm
#armor 312 -- chaos plate cuirass
#neednoteat
#poisonres 10 -- +10
#diseaseres 100 -- +100
#demon
#magicskill 7 2 -- G2
#magicskill 4 2 -- S2
#magicskill 8 2 -- B1
#magicskill 9 2 -- H2
#magicboost 9 -1 -- -1 holy
#holy
#expertleader
#expertundeadleader
#fear 5 -- -3
--
#itemslots 860678 -- normal, no feet
#wastesurvival
#awe 2 -- -1
#unsurr 3
#snow
#ambidextrous 4
#domimmortal
#reformtime 3 -- takes 6 months to reform
#maxage 9999
#startage 6666
#nametype 198 -- slaanesh warrior names
#heal --- recuperation ability
#combatcaster
#coldres 5
#end


---- Marauder Shaman

#newmonster 14243
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Shaman.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Shaman2.tga"
#name "Marauder Shaman"
#descr "Most Marauder tribes will have one or two Shamans whose duty is to offer counsel to the Chieftain, interpret auguries to ensure successful raids, and lead the tribe in offering the proper observances to their patron God. Shamans tend to have only a little magical talent and rather than harnessing energy provided by the Ruinous Powers, they tap into the magic of their surroundings in the manner of hedge mages, witches, and other lesser mages. Shamans thus practice a different branch of magic from Sorcerers focused on veneration of the dead, the wilds, and the bitter cold of the polar lands. Shamans of Marauder tribes dedicated to Slaanesh in the guise of the Serpent carry staffs topped with snake skeletons and have some talent in the magic of the spheres and the minds of mortals.

[Recruitment does not require a lab]"
#gcost 125
#rpcost 2
#rcost 1
#holy
#magicskill 6 1 -- N1
#custommagic 10752 100 -- WSN
#holy
#mr 13
#att 9
#def 11
#poorleader
#weapon 7 -- staff
#armor 44 -- furs
#armor 120 -- leather cap
#researchbonus -2
#noreqlab
#end


---- Marauder Chieftain

#newmonster 14259
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Chieftain.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Chieftain2.tga"
#name "Marauder Chieftain"
#descr "While the largest Marauder warhosts are inevitably commanded by an Exalted Hero or Chaos Lord, the smaller tribes that make up the vast majority of human life in the lands surrounding the Chaos Wastes are ruled over by Chieftains. They are typically fierce and crafty warriors with years of experience raiding and doing battle, perhaps even having taken part in a full blown Chaos invasion during their lifetime. Although Marauders hold sheer martial prowess in considerable esteem it is unusual for a young Marauder, no matter how gifted, to ascend to the position of Chieftain, as they will typically embark of the Path of the Warrior or the Path of the Champion, assuming they don't fall in battle trying to prove themselves. Rather Marauder Chieftains are picked out by their Shamans and by former Chiefs to take the position, selected on the basis that they clearly have some favour from the Ruinous Powers, but have not attracted the potentially lethal full attention of their Patron God. The Marauder tribes are well known for their raids by sea and Marauder Chieftains can command fleets of cramped but efficient longboats to bear Marauders and Warriors to battle, though they aren't nearly large enough to transport cavalry."
#gcost 60
#hp 20
#str 13
#prot 3
#att 12
#def 14
#mor 12
#weapon 17 -- axe
#armor 21 -- full helmet
#armor 9 -- plate cuirass
#armor 2 -- shield
#rpcost 1
#rcost 1
#mr 11
#prec 11
#okleader
#command 20
--
#pillagebonus 5
#sailing 999 4
#swimming
#beastmaster 2
#taxcollector
#end

---- Marauder Horsemaster

#newmonster 14304
#copystats 14200 -- marauder template
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Horsemaster.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Horsemaster2.tga"
#name "Marauder Horsemaster"
#descr "While the largest Marauder warhosts are inevitably commanded by an Exalted Hero or Chaos Lord, the smaller tribes that make up the vast majority of human life in the lands surrounding the Chaos Wastes are ruled over by Chieftains. They are typically fierce and crafty warriors with years of experience raiding and doing battle, perhaps even having taken part in a full blown Chaos invasion during their lifetime. Although Marauders hold sheer martial prowess in considerable esteem it is unusual for a young Marauder, no matter how gifted, to ascend to the position of Chieftain, as they will typically embark of the Path of the Warrior or the Path of the Champion, assuming they don't fall in battle trying to prove themselves. Rather Marauder Chieftains are picked out by their Shamans and by former Chiefs to take the position, selected on the basis that they clearly have some favour from the Ruinous Powers, but have not attracted the potentially lethal full attention of their Patron God. Those Chieftains that rule over the primarily eastern Marauder tribes whose raiders are largely mounted go to battle on fine steeds and are known as Horsemasters. They are as versed in raiding tactics as any other Chieftain but tend to lead smaller groups and cannot call on fleets of longships to transport their raiders."
#weapon 357 -- light lance
#armor 21 -- full helmet
#armor 9 -- plate cuirass
#armor 2 -- shield
#gcost 50 -- (60)
#ressize 2
#hp 20
#str 13
#prot 3
#att 12
#def 15
#mor 12
#rpcost 1
#mr 11
#prec 11
#okleader
--
#pillagebonus 5
#beastmaster 2
#taxcollector
#skilledrider 3
#mobilearcher 1
#mountmnr 14431
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Horsemaster_Unmounted.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Horsemaster_Unmounted2.tga"
#end

-----Marauder Horse (horsemaster)

#newmonster 14431
#copystats 14433 -- marauder horse
#spr1 "Warhammer_Slaanesh/Slaanesh_Marauder_Horsemaster_Mount.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Marauder_Horsemaster_Mount2.tga"
#name "Marauder Horse"
#descr "The horses ridden by Chaos Marauders are large, fast, and aggressive beasts that show some traces of the warping influence of Chaos. Unlike most horses there is a chance they will continue to fight even if their rider is slain, such is their aggressive nature."
#end


---- Slaaneshi Cultist (male)

#newmonster 14227
#spr1 "Warhammer_Slaanesh/Slaanesh_Cultist_Male.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Cultist_Male2.tga"
#name "Slaaneshi Cultist"
#descr "Slaanesh is the most seductive and insidious of the Ruinous Powers, for the Dark Prince is able to offer mortals all the pleasures sensation can offer and on the same hand threaten all the torments it can bring. Nothing pleases Slaanesh more than the temptation and corruption of once innocent souls and the complex games of intrigue, blackmail, and seduction involved. As such Slaanesh has a great many adherents hidden in the mortal realms posing as courtiers, mages, merchants, politicians, priest, travellers, and entertainers while secretly furthering the plots of the Prince of Pleasure. Slaaneshi Cultists are expert sophists with a keen understanding of the human mind and can sway vulnerable souls to Slaanesh's side. Their physical beauty, enhanced by their God, is often enough to stay the blade of even a determined attacker.

[This cultist is male and can seduce females]"
#gcost 160
#rpcost 2
#rcost 1
#douse 1
#custommagic 18432 100 -- SG
#inquisitor
#magicskill 8 1 -- B1
#magicskill 9 1 -- level 1 priest
#holy
#str 11
#enc 3 -- normal
#hp 10
#mor 10
#mr 14 -- +2 for tier 2
#att 9
#def 11
#prec 10
#poorleader
#poorundeadleader
#command -5
#stealthy 10
#spy
#seduce 9
#armor 158 -- Robes
#weapon 9 -- Dagger
#glamour
#slothresearch 2
#coldres 5
#end


---- Slaaneshi Cultist (female)

#newmonster 14228
#spr1 "Warhammer_Slaanesh/Slaanesh_Cultist_Female.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Cultist_Female2.tga"
#name "Slaaneshi Cultist"
#descr "Slaanesh is the most seductive and insidious of the Ruinous Powers, for the Dark Prince is able to offer mortals all the pleasures sensation can offer and on the same hand threaten all the torments it can bring. Nothing pleases Slaanesh more than the temptation and corruption of once innocent souls and the complex games of intrigue, blackmail, and seduction involved. As such Slaanesh has a great many adherents hidden in the mortal realms posing as courtiers, mages, merchants, politicians, priest, travellers, and entertainers while secretly furthering the plots of the Prince of Pleasure. Slaaneshi Cultists are expert sophists with a keen understanding of the human mind and can sway vulnerable souls to Slaanesh's side. Their physical beauty, enhanced by their God, is often enough to stay the blade of even a determined attacker.

[This cultist is female and can seduce males]"
#gcost 140
#rpcost 2
#rcost 1
#custommagic 49152 100 -- BG
#inquisitor
#magicskill 8 1 -- B1
#magicskill 9 1 -- level 1 priest
#holy
#str 10
#enc 3 -- normal
#hp 10
#mor 9
#mr 14 -- +2 for tier 2
#att 10
#def 11
#prec 10
#poorleader
#poorundeadleader
#command -5
#stealthy 10
#spy
#seduce 9
#armor 158 -- Robes
#weapon 9 -- Dagger
#glamour
#slothresearch 2
#female
#coldres 5
#end


---- Slaaneshi Sorcerer

#newmonster 14229
#spr1 "Warhammer_Slaanesh/Slaanesh_Sorcerer.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Sorcerer2.tga"
#name "Slaaneshi Sorcerer"
#descr "Just as Chaos Warriors and Aspiring Champions seek to prove themselves to their patron God and gain glory and power by pursuing an extreme path, so to do Chaos Sorcerers. Sorcerers are magically talented individuals who, rather than researching the lore of a specific Wind of Magic as do the Wizards of the Imperial Colleges instead beseech a Ruinous Power for forbidden knowledge and power. Although in some ways Sorcerers thus take a shortcut to magical mastery, there can be no doubting the commitment of dedication of those who survive the arcane gits bestowed by their God, for simply retaining both their sanity and physical form requires an iron will. Sorcerers of Slaanesh are most talented in the use of magics of manipulation and deception, though they are capable of unleashing considerable devastation should they so choose. All Sorcerers bear the clear favour of their patron God and are thus sacred to their warhosts, but Slaaneshi Sorcerers in particular are known to act as evangelical orators able to move the hearts and minds of mortal men in writhing exultation of the Prince of Pleasure."
#gcost 330 -- the dastur is F1D1B1H2 with 100% FADB and costs 215 gold
#rpcost 2
#rcost 1
#magicskill 7 2 -- G1
#magicskill 4 1 -- S1
#magicskill 8 1 -- B1
#magicskill 9 1 -- level 2 priest
#custommagic 34816 100 -- SB
#custommagic 4224 50 -- DF
#inquisitor
#holy
#str 12
#enc 3 -- normal
#hp 12
#mor 13
#mr 16
#att 11
#def 13
#prec 11
#poorleader
#okundeadleader
#stealthy 10
#armor 158 -- Robes
#weapon 238 -- magic staff
#slothresearch 3
#maxage 2000
#startage 666
#wastesurvival
#snow
#coldres 5
#end


---- Slaaneshi Sorcerer Lord

#newmonster 14230
#spr1 "Warhammer_Slaanesh/Slaanesh_Sorcerer_Lord.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Sorcerer_Lord2.tga"
#name "Slaaneshi Sorcerer Lord"
#descr "Just as Chaos Warriors and Aspiring Champions seek to prove themselves to their patron God and gain glory and power by pursuing an extreme path, so to do Chaos Sorcerers. Sorcerers are magically talented individuals who, rather than researching the lore of a specific Wind of Magic as do the Wizards of the Imperial Colleges instead beseech a Ruinous Power for forbidden knowledge and power. Although in some ways Sorcerers thus take a shortcut to magical mastery, there can be no doubting the commitment of dedication of those who survive the arcane gits bestowed by their God, for simply retaining both their sanity and physical form requires an iron will. The most powerful Sorcerers are known as Sorcerer Lords and their magical prowess is considerable, though very few Sorcerers survive learning the soul-scouring secrets required. All Sorcerers bear the clear favour of their patron God and are thus sacred to their warhosts, but Slaaneshi Sorcerers in particular are known to act as evangelical orators able to move the hearts and minds of mortal men in writhing exultation of the Prince of Pleasure."
#prot 2
#gcost 470
#rpcost 4
#rcost 1
#magicskill 7 2 -- G2
#magicskill 4 2 -- S2
#magicskill 8 2 -- B2
#magicskill 9 2 -- level 2 priest
#custommagic 51200 100 -- SGB
#custommagic 4224 50 -- DF
#inquisitor
#holy
#str 13
#enc 3 -- normal
#hp 12
#mor 15
#mr 17
#att 11
#def 13
#prec 12
#okleader
#command -20
#okundeadleader
#stealthy 10
#armor 158 -- Robes
#weapon 238 -- magic staff
#slothresearch 4
#researchbonus 8
#maxage 2000
#startage 666
#wastesurvival
#snow
#coldres 5
#end


---- Keeper of Secrets (form that could be male or female)

#newmonster 14252
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper2.tga"
#name "Keeper of Secrets"
#descr "The Greater Daemons of Slaanesh are known as Keepers of Secrets, for they are the confidants and courtiers of Slaanesh, as well as the greatest generals and warriors of the Dark Prince. A Keeper of Secrets is a ruiner of purity, a despoiler of the faithful, and the harbinger of damnation. It draws strength from the corruption of others and above all feasts on upon mortal excess and rapture, particularly if it can deliver its target from the heights of one to the depths of another. Keepers are the . Each varies in appearance to some extent and each considers itself the true paragon of beauty, but they share in common certain bovine aspects to their appearance, four arms and two legs, and a visage which combines horror and sensuality in writhing union. Keepers are matchless in their grace and agility, even amongst other Greater Daemons, capable of dancing through ranks of elite enemies and tearing them apart with contemptuous ease. The Keeper's lethality is not limited to its physical prowess, however, for they are also talented and powerful magic users possessing a supernatural ability to travel undetected and strike at appropriate targets from the shadows. As with all Daemons they are more powerful within the Dominion of their God and as Greater Daemons they are capable of reforming their body should they be slain in this Dominion.

[This Keeper of Secrets will transform into a form capable of seducing either males or females]"
--stats compare with archdevil
#hp 66 -- +4
#size 8
#prot 16 -- -1
#mor 30
#mr 18
#enc 1
#str 20 -- +1
#att 16 -- +1 -- WS9 I10
#def 19 -- +3
#prec 13
#mapmove 24 -- -4 but he's not flying
#ap 22 -- +8
#gcost 0
#weapon 477 -- unholy sword
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#weapon 824 -- magic claw (not bonus)
#neednoteat
#poisonres 10 -- +10
#diseaseres 100 -- +100
#demon
#stealthy 30 -- assassin +5
#magicskill 7 2 -- G2
#magicskill 4 2 -- S2
#magicskill 8 3 -- B3
#magicskill 9 2 -- H3
#itemslots 17768966 -- crown only on head, but otherwise full slots
#wastesurvival
#female
#seduce 12 -- standard +3
#glamour
#damagerev 1
#unsurr 3
#fear 8 -- -2 from a dragon
--
#expertleader
#expertundeadleader
#holy
#snow
#ambidextrous 4
#domimmortal
#reformtime 3 -- takes 6 months to reform
#maxage 9999
#startage 6666
#nametype 199
#firstshape -1035 -- male or female form of keeper of secrets
#heal --- recuperation ability
#combatcaster
#coldres 5
#startitem 1012 -- Mark of Slaanesh
#end


---- Keeper of Secrets (female, in dominion)

#newmonster 14250
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper2.tga"
#name "Keeper of Secrets"
#descr "The Greater Daemons of Slaanesh are known as Keepers of Secrets, for they are the confidants and courtiers of Slaanesh, as well as the greatest generals and warriors of the Dark Prince. A Keeper of Secrets is a ruiner of purity, a despoiler of the faithful, and the harbinger of damnation. It draws strength from the corruption of others and above all feasts on upon mortal excess and rapture, particularly if it can deliver its target from the heights of one to the depths of another. Keepers are the . Each varies in appearance to some extent and each considers itself the true paragon of beauty, but they share in common certain bovine aspects to their appearance, four arms and two legs, and a visage which combines horror and sensuality in writhing union. Keepers are matchless in their grace and agility, even amongst other Greater Daemons, capable of dancing through ranks of elite enemies and tearing them apart with contemptuous ease. The Keeper's lethality is not limited to its physical prowess, however, for they are also talented and powerful magic users possessing a supernatural ability to travel undetected and strike at appropriate targets from the shadows. As with all Daemons they are more powerful within the Dominion of their God and, as Greater Daemons, they are capable of reforming their body should they be slain in this Dominion.

[This Keeper of Secrets has been tasked with the seduction and corruption of males and so is considered female for the purposes of the Seduction command]"
--stats compare with archdevil
#hp 66 -- +4
#size 8
#prot 16 -- -1
#mor 30
#mr 18
#enc 1
#str 20 -- +1
#att 16 -- +1 -- WS9 I10
#def 19 -- +3
#prec 13
#mapmove 24 -- -4 but he's not flying
#ap 22 -- +8
#gcost 0
#weapon 477 -- unholy sword
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#weapon 824 -- magic claw (not bonus)
#neednoteat
#poisonres 10 -- +10
#diseaseres 100 -- +100
#demon
#stealthy 30 -- assassin +5
#magicskill 7 2 -- G2
#magicskill 4 2 -- S2
#magicskill 8 3 -- B3
#magicskill 9 2 -- H3
#holy
#expertleader
#fear 6
--
#itemslots 17768966 -- crown only on head, but otherwise full slots
#wastesurvival
#female
#seduce 12 -- standard +3
#glamour
#damagerev 1
#unsurr 3
#fear 8 -- -2 from a dragon
#expertleader
#expertundeadleader
#holy
#snow
#ambidextrous 4
#domimmortal
#reformtime 3 -- takes 6 months to reform
#notdomshape 14251 -- the weakened form
#maxage 9999
#startage 6666
#nametype 199
#montag 1035 -- male or female
#heal --- recuperation ability
#combatcaster
#coldres 5
#startitem 1012 -- Mark of Slaanesh
#end


---- Keeper of Secrets (female, out of dominion)

#newmonster 14251
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper2.tga"
#name "Keeper of Secrets"
#descr "The Greater Daemons of Slaanesh are known as Keepers of Secrets, for they are the confidants and courtiers of Slaanesh, as well as the greatest generals and warriors of the Dark Prince. A Keeper of Secrets is a ruiner of purity, a despoiler of the faithful, and the harbinger of damnation. It draws strength from the corruption of others and above all feasts on upon mortal excess and rapture, particularly if it can deliver its target from the heights of one to the depths of another. Keepers are the . Each varies in appearance to some extent and each considers itself the true paragon of beauty, but they share in common certain bovine aspects to their appearance, four arms and two legs, and a visage which combines horror and sensuality in writhing union. Keepers are matchless in their grace and agility, even amongst other Greater Daemons, capable of dancing through ranks of elite enemies and tearing them apart with contemptuous ease. The Keeper's lethality is not limited to its physical prowess, however, for they are also talented and powerful magic users possessing a supernatural ability to travel undetected and strike at appropriate targets from the shadows. As with all Daemons they are more powerful within the Dominion of their God and as Greater Daemons they are capable of reforming their body should they be slain in this Dominion.

[This Keeper of Secrets has been tasked with the seduction and corruption of males and so is considered female for the purposes of the Seduction command]
[This Keeper of Secrets is outside of friendly Dominion and has reduced stats and magic]"
--stats compared with in dominion version
#hp 55 -- -11
#size 8
#prot 13
#mor 30
#mr 16 -- -2
#enc 3 -- +2 worse
#str 18 -- -2
#att 15 -- -1
#def 18 -- -1
#prec 12 -- -1
#mapmove 24
#ap 22
#gcost 0
#weapon 477 -- unholy sword
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#weapon 824 -- magic claw (not bonus)
#neednoteat
#poisonres 10
#diseaseres 100
#demon
#stealthy 20 -- -10
#magicskill 7 2 -- -1
#magicskill 4 2 -- -1
#magicskill 8 3 -- -1
#magicskill 9 2 -- -1
#magicboost 53 -1
#holy
#expertleader
#itemslots 17768966 -- crown only on head, but otherwise full slots
#wastesurvival
#female
#seduce 12 -- standard +3
#glamour
#unsurr 3
#fear 5 -- -3
--
#expertleader
#expertundeadleader
#holy
#snow
#ambidextrous 4
#domimmortal
#reformtime 3 -- takes 6 months to reform
#domshape 14250 -- turn back
#maxage 9999
#startage 6666
#nametype 199
#combatcaster
#coldres 5
#startitem 1012 -- Mark of Slaanesh
#end


---- Keeper of Secrets (male, in dominion)

#newmonster 14253
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper_Male.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper_Male2.tga"
#name "Keeper of Secrets"
#descr "The Greater Daemons of Slaanesh are known as Keepers of Secrets, for they are the confidants and courtiers of Slaanesh, as well as the greatest generals and warriors of the Dark Prince. A Keeper of Secrets is a ruiner of purity, a despoiler of the faithful, and the harbinger of damnation. It draws strength from the corruption of others and above all feasts on upon mortal excess and rapture, particularly if it can deliver its target from the heights of one to the depths of another. Keepers are the . Each varies in appearance to some extent and each considers itself the true paragon of beauty, but they share in common certain bovine aspects to their appearance, four arms and two legs, and a visage which combines horror and sensuality in writhing union. Keepers are matchless in their grace and agility, even amongst other Greater Daemons, capable of dancing through ranks of elite enemies and tearing them apart with contemptuous ease. The Keeper's lethality is not limited to its physical prowess, however, for they are also talented and powerful magic users possessing a supernatural ability to travel undetected and strike at appropriate targets from the shadows. As with all Daemons they are more powerful within the Dominion of their God and, as Greater Daemons, they are capable of reforming their body should they be slain in this Dominion.

[This Keeper of Secrets has been tasked with the seduction and corruption of females and so is considered male for the purposes of the Seduction command]"
--stats compare with archdevil
#hp 66 -- +4
#size 8
#prot 16 -- -1
#mor 30
#mr 18
#enc 1
#str 20 -- +1
#att 16 -- +1 -- WS9 I10
#def 19 -- +3
#prec 13
#mapmove 24 -- -4 but he's not flying
#ap 22 -- +8
#gcost 0
#weapon 477 -- unholy sword
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#weapon 824 -- magic claw (not bonus)
#neednoteat
#poisonres 10 -- +10
#diseaseres 100 -- +100
#demon
#stealthy 30 -- assassin +5
#magicskill 7 2 -- G2
#magicskill 4 2 -- S2
#magicskill 8 3 -- B3
#magicskill 9 2 -- H3
#holy
#expertleader
#itemslots 17768966 -- crown only on head, but otherwise full slots
#wastesurvival
#seduce 12 -- standard +3
#glamour
#damagerev 1
#unsurr 3
#fear 7
--
#expertleader
#expertundeadleader
#holy
#snow
#ambidextrous 4
#domimmortal
#reformtime 3 -- takes 6 months to reform
#notdomshape 14254 -- the weakened form
#maxage 9999
#startage 6666
#nametype 199
#montag 1035 -- male or female
#heal --- recuperation ability
#combatcaster
#coldres 5
#startitem 1012 -- Mark of Slaanesh
#end


---- Keeper of Secrets (male, out of dominion)

#newmonster 14254
#spr1 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper_Male.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Daemon_Keeper_Male2.tga"
#name "Keeper of Secrets"
#descr "The Greater Daemons of Slaanesh are known as Keepers of Secrets, for they are the confidants and courtiers of Slaanesh, as well as the greatest generals and warriors of the Dark Prince. A Keeper of Secrets is a ruiner of purity, a despoiler of the faithful, and the harbinger of damnation. It draws strength from the corruption of others and above all feasts on upon mortal excess and rapture, particularly if it can deliver its target from the heights of one to the depths of another. Keepers are the . Each varies in appearance to some extent and each considers itself the true paragon of beauty, but they share in common certain bovine aspects to their appearance, four arms and two legs, and a visage which combines horror and sensuality in writhing union. Keepers are matchless in their grace and agility, even amongst other Greater Daemons, capable of dancing through ranks of elite enemies and tearing them apart with contemptuous ease. The Keeper's lethality is not limited to its physical prowess, however, for they are also talented and powerful magic users possessing a supernatural ability to travel undetected and strike at appropriate targets from the shadows. As with all Daemons they are more powerful within the Dominion of their God and as Greater Daemons they are capable of reforming their body should they be slain in this Dominion.

[This Keeper of Secrets has been tasked with the seduction and corruption of females and so is considered male for the purposes of the Seduction command]
[This Keeper of Secrets is outside of friendly Dominion and has reduced stats and magic]"
--stats compared with in dominion version
#hp 55 -- -11
#size 8
#prot 13
#mor 30
#mr 16 -- -2
#enc 3 -- +2 worse
#str 18 -- -2
#att 15 -- -1
#def 18 -- -1
#prec 12 -- -1
#mapmove 24
#ap 22
#gcost 0
#weapon 477 -- unholy sword
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#weapon 824 -- magic claw (not bonus)
#neednoteat
#poisonres 10
#diseaseres 100
#demon
#stealthy 20 -- -10
#magicskill 7 2 -- -1
#magicskill 4 2 -- -1
#magicskill 8 3 -- -1
#magicskill 9 2 -- -1
#magicboost 53 -1
#holy
#expertleader
#itemslots 17768966 -- crown only on head, but otherwise full slots
#wastesurvival
#seduce 12 -- standard +3
#glamour
#unsurr 3
#fear 5 -- -3
--
#expertleader
#expertundeadleader
#holy
#snow
#ambidextrous 4
#domimmortal
#reformtime 3 -- takes 6 months to reform
#domshape 14253 -- turn back
#maxage 9999
#startage 6666
#nametype 199
#combatcaster
#coldres 5
#startitem 1012 -- Mark of Slaanesh
#end



---------- HEROES

---- Styrkaar

#newmonster 14302
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Hero_Styrkaar.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Hero_Styrkaar2.tga"
#name "Prince of the Sortsvinaer"
#descr "Styrkaar was born to a Chieftain of the Norscan tribe known as the Sortsvinaer and marked from birth as one destined for a special fate, as it became clear he was bound to a Daemonic entity, Sle'zuzu. Following the whisperings of the Daemon the young boy became a charming and successful princeling and led many successful raids on the coasts of the Old World. His father was eaten away by jealousy and insulted his son, who murdered him the midst of a great revelry in Styrkaar's honour. As he grew in status and embarked on the Path of the Champion Styrkaar's mind merged with that of the Daemon and he became truly favoured by Slaanesh, granted pale daemonic flesh, fine black armour, and his own Daemonic Mount. Styrkaar was one of the four Chaos Lords chosen by Archaon the Everchosen to head armies in support of his invasion of the Old World and it is clear that he is still destined for greater things."
--stats compared with Chaos Lord
#hp 50 -- +5
#mor 20
#mr 17 -- +1
#str 17 -- +1
#att 16 -- +1
#def 19 -- +1
#prec 15 -- +1
#gcost 0
#rcost 1
#rpcost 2
#expertleader
#ambidextrous 3
--
#weapon 1133 -- Chaos Glaive -- can be replaced, just a one handed magic glaive
#armor 311 -- chaos helm
#armor 310 -- chaos full plate
#armor 3 -- kite shield
#holy
#size 4
#goodundeadleader
#awe 2 -- +1
#unsurr 3
#prot 8
#poisonres 10
#spiritsight
#xploss 100
#heal
#fixedname "Styrkaar"
#skilledrider 4
#mountmnr 14303 -- mount of Styrkaar
#unmountedspr1 "Warhammer_Slaanesh/Slaanesh_Hero_Styrkaar_Unmounted.tga"
#unmountedspr2 "Warhammer_Slaanesh/Slaanesh_Hero_Styrkaar_Unmounted2.tga"
#heal
#startage 120
#maxage 500
#end


---- Mount of Slaanesh (styrkaar)

#newmonster 14303
#spr1 "Warhammer_Slaanesh/Slaanesh_Hero_Styrkaar_Mount.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Hero_Styrkaar_Mount2.tga"
#name "Mount of Slaanesh"
#descr "Mounts of Slaanesh are bizarre serpentine creatures gifted to Chaos Lords high in Slaanesh's favour. They are quicksilver fast and instinctively deadly fighters with lashing poisonous tongues and, now that their rider is slain, are able to smash through formations of troops with sweeps of their tails. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks."
#ap 32 -- fastest cav in the game, tied with centauride
#mapmove 28 -- same as a shade beast, tireless, fast
#hp 46 -- big!
#prot 10
#size 6
#str 18
#enc 1 -- daemon
#att 13
#def 16
#prec 11
#mr 14
#mor 30
#gcost 0
#rcost 1
#weapon 1125 -- poisonous whiptongue (str based version)
#weapon 532 -- tail sweep
#startage 20
#maxage 10000
#poisonres 10
#demon
#animal
#neednoteat
#spiritsight
#xploss 100
#snake
#coldres 5
#holy
#bravemount 100
#heal
#glamour
#unsurr 4
#end


---- Sigvald the Magnificent

#newmonster 14659
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Hero_Sigvald.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Hero_Sigvald2.tga"
#name "Scion of Slaanesh"
#descr "Though his appearance is that of a fresh faced youth, Sigvald has blighted the world of men for more than three hundred years, slaughtered countless foes in the name of Slaanesh, and practiced every form of depravity and excess to the point of tedium. The personnification of beauty on the outside, Sigvald's hauntingly perfect features are accented by a constant perfumed breeze that wafts through his golden hair and satin cloak and as he walks his feet float just above the ground: in all respects the Scion of Slaanesh has the appearance of a storybook hero or perhaps demigod, but his soul is one of absolute evil. Sigvald was the offspring of a powerful and depraved King of Norsca and was from birth clearly marked by Slaanesh to be a creature of perfection, his clothes forever pristine, his skin flawless and unblemished no matter whether he walked through a fierce blizzard or a gore and mud soaked battlefield. At first Sigvald was granted his every wish, but in time the princeling's desires grew too disturbing even for his sadistic father and he was banished, a decree which Sigvald heeded, though only after murdering his own father in his bed. Since that time Sigvald has become perhaps the favourite of all the Dark Prince's mortal champions and now leads a great legion of fanatically devoted followers, though in truth his arrogance, vanity, and carelessness make him a poor leader. Sigvald is protected in battle by the famed Auric Armour which grants him the ability to regenerate on the rare occasions his foes land a blow and lashes out with the feared Silverslash, a blade said to have been splintered from Slaanesh's own weapon. The Scion of Slaanesh carries a mirrored shield and wears mirrored pauldrons that he might gaze lovingly upon his own reflection even on the battlefield. Indeed Sigvald is often accompanied by a bodyguard of Chosen who carry similar shields so he may enjoy viewing his own perfect form from many angles at once."
--stats compared with Chaos Lord
#hp 45
#mor 20
#mr 18 -- +2
#str 16
#att 17
#def 18 -- +1
#prec 15 -- +1
#gcost 0
#rcost 1
#rpcost 2
#okleader
#command 60
#inspirational 3
#ambidextrous 3
--
#weapon 1187 -- Silverslash
#armor 212 -- magic crown
#armor 310 -- chaos plate armour -- replaced by auric armour
#armor 328 -- mirrored shield
#holy
#spreaddom 1
#size 4
#okundeadleader
#awe 4 -- incredibly pretty
#unsurr 3
#prot 3
#coldres 10 -- warm winds etc
#heal
--regeneration 10 -- given by armour
#float
#itemslots 17768454 -- normal but no bow, crown only on head
#startitem 951 -- auric armour
#startage 300
#maxage 1000
#fixedname "Sigvald the Magnificent"
#end


---- Mirror Guard

#newmonster 14663
#copystats 14199 -- warrior template
#spr1 "Warhammer_Slaanesh/Slaanesh_Hero_Mirror.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Hero_Mirror2.tga"
#name "Mirror Guard"
#descr "The Mirror Guard are Chosen Warriors of Slaanesh who form the elite bodyguard of the Scion of Slaanesh known as Sigvald the Magnificent. They carry mirrored shields into battle so that Sigvald might admire his form from every angle while on the battlefield. Their helms are faceless and plain so as to avoid any possibility they might distract from Sigvald's visage."
#weapon 10 -- falchion
#armor 311 -- chaos helm
#armor 310 -- chaos plate armour
#armor 328 -- mirrored shield
#mor 16
#mr 14
#str 14
#att 14
#def 16
#gcost 0
#holy
#ap 16
#heal
#bodyguard 2
#awe 2
#unsurr 2
#end



------ Azazel

#newmonster 14305
#spr1 "Warhammer_Slaanesh/Slaanesh_Hero_Azazel.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Hero_Azazel2.tga"
#name "Prince of Damnation"
#descr "Azazel is one of the foremost of Slaanesh's Daemon Princes and holds the official title of Prince of Damnation, his purview being souls who have damned themselves through acts of great betrayal of their rulers or loved ones. In his former mortal life Azazel was a warrior of the Unberogen tribe named Gerreon who swore vengeance against Sigmar Heldenhammer for the death of his brother under Sigmar's command. Gerreon infiltrated Sigmar's honour guard and became a trusted friend to the heroic ruler, in time finding his ruse of loyalty had become truth rather than fiction. Though Gerreon had come to love Sigmar he still chose to betray him, badly wounding him and murdering his betrothed, Gerreon's own sister. Following this great betrayal Gerreon fled to the Chaos Wastes and became a Chaos Lord greatly favoured by the young Chaos God Slaanesh, eventually rising to Daemon Princehood. As a Daemon Prince Azazel wields incredible physical and magical might but his greatest power is his ability to corrupt and dominate the minds of mortals, for the Prince of Damnation appears to his foes as stunningly beautiful and impossible eloquent, just, and convincing. In battle Azazel descends silently on his enemies on graceful white wings and serenely butchers them with his scything claw or unholy sword. While they are Daemons in form their past in the mortal world grants Daemon Princes the benefit of not becoming weaker outside the Dominion of their God, though like Greater Daemons they can still only reform their bodies if slain in this Dominion.

[Azazel is primarily concerned with the corruption and damnation of men and as such is considered female for the purposes of the Seduction command]"
#hp 58 -- keeper -8
#size 8
#prot 14
#mor 30
#mr 18
#enc 1
#str 18 -- -2 from keeper
#att 15 -- keeper -1
#def 20 
#prec 14 -- keeper +1
#mapmove 28
#flying
#ap 20 -- -2 compared to keeper
#gcost 0
#weapon 595 -- hypnotise
#weapon 1747 -- enslavement but bonus
#weapon 477 -- unholy sword
#weapon 1127 -- wicked claw
#neednoteat
#poisonres 10 -- +10
#diseaseres 100 -- +100
#demon
#stealthy 40 -- assassin +15
#magicskill 7 2 -- G2
#magicskill 4 2 -- S2
#magicskill 8 2 -- B2
#magicskill 9 3 -- H3
#wastesurvival
#female
#seduce 13 -- +1 over keeper of secrets
#awe 1
#glamour
#unsurr 4
#fear 5 -- -2 over keeper
--
#expertleader
#expertundeadleader
#holy
#snow
#ambidextrous 4
#domimmortal
#reformtime 3 -- takes 6 months to reform
#maxage 9999
#startage 2666
#fixedname "Azazel"
#heal --- recuperation ability
#combatcaster
#coldres 5
#itemslots 17768962 -- crown, body, 2 misc, feet, bow, 1 hand
#end



---- N'Kari (in dominion)

#newmonster 14306
#spr1 "Warhammer_Slaanesh/Slaanesh_Hero_Nkari.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Hero_Nkari2.tga"
#name "Ruination of Ulthuan"
#descr "N'Kari is one of the most powerful of Slaanesh's Greater Daemons and certainly the most infamous and feared amongst those in the mortal world unfortunate enough to know of its existence. N'Kari is remarkable amongst Daemons for their singular focus; the sadistic Keeper of Secrets seems to be almost entirely dedicated to the corruption and ruination of the land of Ulthuan, specifically any who carry the bloodline of the great elven hero Aenarion. During Ulthuan's darkest hour with the fate of the mortal world hanging in the balance Aenarion was beset by four Greater Daemons sent by the Ruinous Powers it was N'Kari that came closest to felling the elf, but ultimately was destroyed and banished back to the Realm of Slaanesh, promising vengeance on his people. N'Kari is as patient, intelligent, and skilled in subterfuge as any Keeper of Secrets but eschews the art of corruption in favour of slaughter, assassination, and pain. As with all Daemons N'Kari is more powerful within the Dominion of Slaanesh and, as a Greater Daemon, they are capable of reforming their body should they be slain in this Dominion."
--stats compared with regular KoS
#hp 70 -- +4
#size 8
#prot 17
#mor 30
#mr 18
#enc 1
#str 21 -- +1
#att 16 -- +1
#def 22 -- +1
#prec 15 -- +2
#mapmove 24 --
#ap 22 --
#gcost 0
#weapon 477 -- unholy sword
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#weapon 824 -- magic claw (not bonus)
#neednoteat
#poisonres 10 --
#diseaseres 100 --
#demon
#stealthy 30 --
#magicskill 7 3 -- G3
#magicskill 4 2 -- S2
#magicskill 8 3 -- B3
#magicskill 9 3 -- H3
#itemslots 17768966 -- crown only on head, but otherwise full slots
#wastesurvival
#glamour
#unsurr 6
#damagerev 2
#fear 10 -- +2
--
#assassin
#patience 3 -- +2 over standard, -2 from khainite assassin
#expertleader
#expertundeadleader
#holy
#snow
#ambidextrous 4
#domimmortal
#reformtime 2 -- 1 quicker
#notdomshape 14307 -- the weakened form
#maxage 9999
#startage 6666
#heal --- recuperation ability
#combatcaster
#coldres 5 -- +2
#fixedname "N'Kari"
#popkill 2 -- same as a kohen, 20 a month
#startitem 1012 -- Mark of Slaanesh
#end


---- N'Kari (out of dominion)
#newmonster 14307
#spr1 "Warhammer_Slaanesh/Slaanesh_Hero_Nkari.tga"
#spr2 "Warhammer_Slaanesh/Slaanesh_Hero_Nkari2.tga"
#name "Ruination of Ulthuan"
#descr "N'Kari is one of the most powerful of Slaanesh's Greater Daemons and certainly the most infamous and feared amongst those in the mortal world unfortunate enough to know of its existence. N'Kari is remarkable amongst Daemons for their singular focus; the sadistic Keeper of Secrets seems to be almost entirely dedicated to the corruption and ruination of the land of Ulthuan, specifically any who carry the bloodline of the great elven hero Aenarion. During Ulthuan's darkest hour with the fate of the mortal world hanging in the balance Aenarion was beset by four Greater Daemons sent by the Ruinous Powers it was N'Kari that came closest to felling the elf, but ultimately was destroyed and banished back to the Realm of Slaanesh, promising vengeance on his people. N'Kari is as patient, intelligent, and skilled in subterfuge as any Keeper of Secrets but eschews the art of corruption in favour of slaughter, assassination, and pain. As with all Daemons N'Kari is more powerful within the Dominion of Slaanesh and, as a Greater Daemon, they are capable of reforming their body should they be slain in this Dominion.

[N'Kari is outside of friendly Dominion and has reduced stats and magic]"
--stats compared with in dominion version
#hp 58 -- -12
#size 8
#prot 14
#mor 30
#mr 17 -- -1
#enc 3 -- +2 worse
#str 19 -- -2
#att 15 -- -1
#def 21 -- -1
#prec 14 -- -1
#mapmove 24
#ap 22
#gcost 0
#weapon 477 -- unholy sword
#weapon 1127 -- wicked claw
#weapon 2502 -- Temptation
#weapon 824 -- magic claw (not bonus)
#neednoteat
#poisonres 10
#diseaseres 100
#demon
#stealthy 20 -- -10
#magicskill 7 3 -- -1
#magicskill 4 2 -- -1
#magicskill 8 3 -- -1
#magicskill 9 3 -- -1
#magicboost 53 -1
#itemslots 17768966 -- crown only on head, but otherwise full slots
#wastesurvival
#glamour
#unsurr 4
#damagerev 1
#fear 7 -- -3
--
#assassin
#patience 2 -- -1
#expertleader
#expertundeadleader
#holy
#snow
#ambidextrous 4
#domimmortal
#reformtime 2
#domshape 14306 -- turn back
#maxage 9999
#startage 6666
#combatcaster
#coldres 5
#fixedname "N'Kari"
#popkill 2 -- same as a kohen, 20 a month
#startitem 1012 -- Mark of Slaanesh
#end



----------PRETENDERS


----------MONSTERS USED FOR EVENTS


---------- SPELLS


---- Such Sights to Show You

#newspell
#copyspell "Charm" -- checked
#name "Such Sights to Show You"
#descr "Extending a hand in a delicate gesture, the caster beckons an enemy with a vision of the sights, sensations, unimaginable terrors, and impossible pleasures that Slaanesh might offer them. Those who fail to resist will immediately join the forces of Slaanesh. The Prince of Pleasure delights in corrupting even those most righteous, wise, or protected from magic and only Pretenders or those with no mind at all are entirely safe from this spell. Though the caster smiles and laughs melodically as they unleash the vision, the spell is very tiring to cast."
#details "This is identical to the spell Charm, though with a higher fatigue cost and lower research level."
#path 0 7 -- glamour
#path 1 8 -- blood
#pathlevel 0 2
#pathlevel 1 2
#fatiguecost 50 -- 30 more than charm
#researchlevel 5 -- charm -1
#restricted 169
#end


---- Create Spawn

#newspell
#name "Create Chaos Spawn of Slaanesh"
#descr "Chaos Spawn are typically the result of one on the Path of the Champion displeasing or simply failing to sufficiently impress or amuse their patron God, but there are other ways by which they can be birthed from a magical laboratory to plague the world of mortals. This ritual creates a single Chaos Spawn, the form of which can vary greatly. Chaos Spawn of Slaanesh are fast moving by the standards of their kind and typically attack their foes with tentacles, tongues, and armour piercing pincer claws. Though they are truly creatures of Chaos they are not Daemons."
#path 0 8 -- blood
#pathlevel 0 1
#school 6 -- blood
#fatiguecost 200 -- 2 blood slaves
#damage -1037 -- generic spawn montag
#nreff 1
#effect 10001
#researchlevel 1
#restricted 169
#end


---- Summon Daemonette

#newspell
#name "Summon Daemonette"
#descr "This ritual calls forth a single Daemonette from the Realm of Slaanesh. Daemonettes are the least of the Dark Prince's creations but are still formidable indeed, with claws capable of tearing through steel, supernatural grace and quickness, and the resilience to mundane weapons common to all Daemons. Like all Daemons of Slaanesh they are considerably weaker outside the Dominion of their God."
#path 0 8 -- blood
#pathlevel 0 1
#school 6 -- blood
#fatiguecost 100 -- 1 blood slaves
#damage 14255 -- daemonette
#nreff 1
#effect 10001
#researchlevel 2
#restricted 169
#end


---- Summon Daemonette Troupe

#newspell
#name "Summon Daemonette Troupe"
#descr "This ritual calls forth a troupe of capering, singing Daemonettes from the Realm of Slaanesh. Daemonettes are the least of the Dark Prince's creations but are still formidable indeed, with claws capable of tearing through steel, supernatural grace and quickness, and the resilience to mundane weapons common to all Daemons. Like all Daemons of Slaanesh they are considerably weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 7 -- glamour
#pathlevel 0 2
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 600 -- 6 blood slaves
#damage 14255 -- daemonette
#nreff 7
#effect 10001
#researchlevel 4
#restricted 169
#end


---- Summon Seeker of Slaanesh

#newspell
#name "Summon Seeker of Slaanesh"
#descr "This ritual calls forth a single Seeker from the Realm of Slaanesh. They are the Dark Prince of Chaos' outriders, Daemonettes mounted on swift daemonic Steeds that can dart across a battlefield in a moment. In battle the claws of the Daemonette are the greatest threat presented by a Seeker, but the Steed itself carries a deadly weapon in the form of its impossibly dextrous tongue, constantly dripping poisons both deadly and psychoactive. As with all Daemons these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 7 -- glamour
#pathlevel 0 2
#pathlevel 1 2
#school 6 -- blood
#fatiguecost 300 -- 3 blood slaves
#damage 14257 -- seeker of slaanesh
#nreff 1
#effect 10001
#researchlevel 3
#restricted 169
#end


---- Summon Fiend of Slaanesh

#newspell
#name "Summon Fiend of Slaanesh"
#descr "This ritual calls forth a hypnotically agile Fiend of Slaanesh, a hellish creature which moves with incredible, disturbing speed on its four strangely-jointed legs. Fiends are rather more delicate and less physically powerful than the beasts of the other Ruinous Powers but their speed, reflexes, and armour shredding pincers make them formidable indeed, as does the poisonous stinger with which they send their prey into a coma. Like all Daemons they have an unnatrual reslience against mundane weapons but are considerably weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 7 -- glamour
#pathlevel 0 2
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 600 -- 6 blood slaves
#damage 14265 -- fiend
#nreff 1
#effect 10001
#researchlevel 4
#restricted 169
#end


---- Summon Skitter of Fiends

#newspell
#name "Summon Skitter of Fiends"
#descr "This ritual calls forth a skitter of four hypnotically agile Fiends of Slaanesh, hellish creatures which move with incredible, disturbing speed on four strangely-jointed legs. Fiends are rather more delicate and less physically powerful than the beasts of the other Ruinous Powers but their speed, reflexes, and armour shredding pincers make them formidable indeed, as does the poisonous stinger with which they send their prey into a coma. Like all Daemons they have an unnatrual reslience against mundane weapons but are considerably weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 7 -- glamour
#pathlevel 0 2
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 2100 -- premium of 4
#damage 14265 -- fiend
#nreff 4
#effect 10001
#researchlevel 6
#restricted 169
#end


---- Summon Seekers of Slaanesh

#newspell
#name "Summon Seeker Pack"
#descr "This ritual calls forth a hunting pack of Seekers from the Realm of Slaanesh. They are the Dark Prince of Chaos' outriders, Daemonettes mounted on swift daemonic Steeds that can dart across a battlefield in a moment. In battle the claws of the Daemonette are the greatest threat presented by a Seeker, but the Steed itself carries a deadly weapon in the form of its impossibly dextrous tongue, constantly dripping poisons both deadly and psychoactive. As with all Daemons these decadent creatures are highly resistant to physical attacks but grow weaker outside the Dominion of their God."
#path 0 8 -- blood
#path 1 7 -- glamour
#pathlevel 0 2
#pathlevel 1 2
#school 6 -- blood
#fatiguecost 1300 -- 13 blood slaves
#damage 14257 -- seeker of slaanesh
#nreff 5
#effect 10001
#researchlevel 6
#restricted 169
#end


---- Contact Herald of Slaanesh

#newspell
#name "Contact Herald of Slaanesh"
#descr "This ritual contacts one the Heralds of Slaanesh, favoured of the Dark Prince's servants. It is their purpose not only to attend to Slaanesh's whimsical desires, but muster his armies, take care of military details which would bore the Dark Prince, and carry his creed to the mortal realm, seducing and corrupting the highborn and virtuous. In battle Heralds are powerful champions imbued with grace, might, and presence by their benefactor. As with all Daemons of Chaos these decadent creatures are highly resistant to physical attacks but are considerably weaker outside of the Dominion of their God. The summoned Herald will have been tasked with the seduction and corruption of either males or females. Heralds are messengers of Slaanesh's will an as such have priestly authority."
#path 0 8 -- blood
#path 1 7 -- glamour
#pathlevel 0 2
#pathlevel 1 1
#school 6 -- blood
#fatiguecost 2100 -- 21 blood slaves
#damage -1036 -- Herald of Slaanesh -- male or female at random
#nreff 1
#effect 10021 -- summon commander
#researchlevel 5
#restricted 169
#end



---- Contact Daemon Prince

#newspell
#name "Contact Daemon Prince of Slaanesh"
#descr "This ritual contacts a Daemon Prince, a former Chaos Lord who has achieved the ultimate goal of immortality at the hand of their patron God. Daemon Princes of Slaanesh have left their humanity far behind, taking a towering new physical form that pleases Slaanesh and grants them even greater martial and physical prowess than they held as a Chaos Lord. Furthermore Daemon Princes are innately talented sorcerers and have all the benefits of Daemonhood, even including the ability to reform their body should they be slain within the Dominion of Slaanesh, but without the drawback of being weaker outside of this Dominion."
#path 0 8 -- blood
#path 1 7 -- glamour
#pathlevel 0 3
#pathlevel 1 2
#school 6 -- blood
#fatiguecost 7700 -- 77 blood slaves
#damage 14270 -- daemon prince
#nreff 1
#effect 10021 -- summon commander
#researchlevel 6
#restricted 169
#end


---- Contact Keeper of Secrets

#newspell
#name "Contact Keeper of Secrets"
#descr "This ritual contacts a Keeper of Secrets, one of the confidants, courtiers, and generals of Slaanesh. These towering Greater Daemons have four arms, two of which end in razor sharp pincers, and a horrifically alluring bovine countenance. They are capable of seducing even the purest souls and possess considerable physical and magical might. As a Greater Daemon the Keeper of Secrets is effectively immortal within the Dominion of Slaanesh, though it is also significantly weaker outside of it. The summoned Keeper will have been tasked with the seduction and corruption of either males or females."
#path 0 8 -- blood
#path 1 7 -- glamour
#pathlevel 0 3
#pathlevel 1 2
#school 6 -- blood
#fatiguecost 11100 -- 111 blood slaves
#damage -1035 -- male or female form of keeper of secrets
#nreff 1
#effect 10021 -- summon commander
#researchlevel 7
#restricted 169
#end


-- Rite of Beauty

#newspell
#copyspell "Aura of Bewilderment"
#name "Rite of Beauty"
#descr "The follower of Slaanesh performs the Rite of Beauty. Many bloodvirgins are deflowered (and de-alived.) Daemons of Slaanesh become even more difficult for mortals to harm."
#school 4
#researchlevel 7
#range 0
#aoe 666
#fatiguecost 500
#path 0 7
#path 1 8
#pathlevel 0 3
#pathlevel 1 2
#spec 13123720
#restricted 169
#explspr 10207
#end


-- Second Writhe (second wave of agony)

#newspell
#name "Second Writhing"
#school -1
#effect 11
#damage 8388608
#spec 554565760
#restricted 169
#end

-- First Writhe (first wave of agony)

#newspell
#name "First Writhing"
#school -1
#effect 11
#damage 16777216
#spec 554565760
#restricted 169
#nextspell "Second Writhing"
#end



-- Rite of Agony

#newspell
#copyspell "Bewitching Lights"
#name "Rite of Agony"
#descr "The follower of Slaanesh performs the Rite of Agony. Many bloodvirgins are deflowered (and de-alived.) Enemies are contorted in agony, some rise forever changed."
#school 6
#researchlevel 7
#range 0
#aoe 666
#fatiguecost 700
#path 0 8
#path 1 7
#pathlevel 0 3
#pathlevel 1 2
#spec 537792640
#nextspell "First Writhing"
#restricted 169
#explspr 10255
#end


-- Rite of Pleasure

#newspell
#name "Rite of Pleasure"
#descr "The follower of Slaanesh performs the Rite of Pleasure. Many bloodvirgins are deflowered (and de-alived.) Enemies are contorted in pleasure, some rise forever changed."
#effect 29
#damage 999
#school 6
#researchlevel 8
#range 0
#aoe 666
#fatiguecost 800
#path 0 8
#path 1 7
#pathlevel 0 4
#pathlevel 1 3
#spec 144119586676932736
#restricted 169
#explspr 10325
#end

-- Rite of Terror

#newspell
#copyspell "Nightmare Masks"
#name "Rite of Terror"
#descr "The follower of Slaanesh performs the Rite of Terror. It requires many Glamour gems, and is very tiring for the caster.

The forces of Slaanesh are glamoured as to be terrible to behold. Even moreso than they already were"
#school 4
#researchlevel 8
#range 0
#aoe 666
#fatiguecost 600
#path 0 7
#path 1 8
#pathlevel 0 4
#pathlevel 1 3
#restricted 169
#explspr 10305
#end


-- Slaaneshi Hypnotism (Sigvald Spell)

#newspell
#copyspell "Serenity"
#name "Slaaneshi Hypnotism"
#descr "The Slaaneshi Prince channels one of Slaanesh's rarest aspects. Bliss. Serenity. Catatonic homeostasis. Enemies find themselves sluggish and calm as they navigate the intricacies of the experience."
#school -1
#path 0 8
#path 1 -1
#pathlevel 0 1
#range 0
#aoe 666
#fatiguecost 300
#spec 546197504
#restricted 169
#end


-- Slaanesh's Presence

#newspell
#copyspell "Rite of Pleasure"
#name "Slaanesh's Presence"
#descr "Keeper of Secrets autospell"
#school -1
#range 100
#precision 100
#fatiguecost 50
#aoe 6
#restricted 169
#end


---------- NAMES

-- Slaaneshi Warrior names

#selectnametype 198
#addname "Slael Painfeast"
#addname "Skirael Painfeast"
#addname "Salaalek Painfeast"
#addname "Ashuz Painfeast"
#addname "Slash Painfeast"
#addname "Anglak Painfeast"
#addname "Relassek Painfeast"
#addname "Slithe Painfeast"
#addname "Sigfrid Painfeast"
#addname "Renkir Painfeast"
#addname "Svend Painfeast"
#addname "Bareth Painfeast"
#addname "Revna Painfeast"
#addname "Torde Painfeast"
#addname "Bodil Painfeast"
#addname "Signeth Painfeast"
#addname "Torsten Painfeast"
#addname "Rune Painfeast"
#addname "Skarde Painfeast"
#addname "Sigael Painfeast"
#addname "Gerrek Painfeast"
#addname "Lash Painfeast"
#addname "Torreg Painfeast"
#addname "Blesk Painfeast"
#addname "Artulf Painfeast"
#addname "Dechal Painfeast"
#addname "Tove Painfeast"
#addname "Splice Painfeast"
#addname "Aangard Painfeast"
#addname "Balath Painfeast"
#addname "Cael Painfeast"
#addname "Drowdr Painfeast"
#addname "Eathor Painfeast"
#addname "Flayl Painfeast"
#addname "Gleeth Painfeast"
#addname "Harkath Painfeast"
#addname "Idris Painfeast"
#addname "Jekreth Painfeast"
#addname "Killian Painfeast"
#addname "Malichor Painfeast"
#addname "Needle Painfeast"
#addname "Opallus Painfeast"
#addname "Pathyk Painfeast"
#addname "Rath Painfeast"
#addname "Greven Painfeast"
#addname "Slaanth Painfeast"
#addname "Tesker Painfeast"
#addname "Ulvaud Painfeast"
#addname "Vorth Painfeast"
#addname "Wrack Painfeast"
#addname "Slael Barbslice"
#addname "Skirael Barbslice"
#addname "Salaalek Barbslice"
#addname "Ashuz Barbslice"
#addname "Slash Barbslice"
#addname "Anglak Barbslice"
#addname "Relassek Barbslice"
#addname "Slithe Barbslice"
#addname "Sigfrid Barbslice"
#addname "Renkir Barbslice"
#addname "Svend Barbslice"
#addname "Bareth Barbslice"
#addname "Revna Barbslice"
#addname "Torde Barbslice"
#addname "Bodil Barbslice"
#addname "Signeth Barbslice"
#addname "Torsten Barbslice"
#addname "Rune Barbslice"
#addname "Skarde Barbslice"
#addname "Sigael Barbslice"
#addname "Gerrek Barbslice"
#addname "Lash Barbslice"
#addname "Torreg Barbslice"
#addname "Blesk Barbslice"
#addname "Artulf Barbslice"
#addname "Dechal Barbslice"
#addname "Tove Barbslice"
#addname "Splice Barbslice"
#addname "Aangard Barbslice"
#addname "Balath Barbslice"
#addname "Cael Barbslice"
#addname "Drowdr Barbslice"
#addname "Eathor Barbslice"
#addname "Flayl Barbslice"
#addname "Gleeth Barbslice"
#addname "Harkath Barbslice"
#addname "Idris Barbslice"
#addname "Jekreth Barbslice"
#addname "Killian Barbslice"
#addname "Malichor Barbslice"
#addname "Needle Barbslice"
#addname "Opallus Barbslice"
#addname "Pathyk Barbslice"
#addname "Rath Barbslice"
#addname "Greven Barbslice"
#addname "Slaanth Barbslice"
#addname "Tesker Barbslice"
#addname "Ulvaud Barbslice"
#addname "Vorth Barbslice"
#addname "Wrack Barbslice"
#addname "Slael Lashwhip"
#addname "Skirael Lashwhip"
#addname "Salaalek Lashwhip"
#addname "Ashuz Lashwhip"
#addname "Slash Lashwhip"
#addname "Anglak Lashwhip"
#addname "Relassek Lashwhip"
#addname "Slithe Lashwhip"
#addname "Sigfrid Lashwhip"
#addname "Renkir Lashwhip"
#addname "Svend Lashwhip"
#addname "Bareth Lashwhip"
#addname "Revna Lashwhip"
#addname "Torde Lashwhip"
#addname "Bodil Lashwhip"
#addname "Signeth Lashwhip"
#addname "Torsten Lashwhip"
#addname "Rune Lashwhip"
#addname "Skarde Lashwhip"
#addname "Sigael Lashwhip"
#addname "Gerrek Lashwhip"
#addname "Lash Lashwhip"
#addname "Torreg Lashwhip"
#addname "Blesk Lashwhip"
#addname "Artulf Lashwhip"
#addname "Dechal Lashwhip"
#addname "Tove Lashwhip"
#addname "Splice Lashwhip"
#addname "Aangard Lashwhip"
#addname "Balath Lashwhip"
#addname "Cael Lashwhip"
#addname "Drowdr Lashwhip"
#addname "Eathor Lashwhip"
#addname "Flayl Lashwhip"
#addname "Gleeth Lashwhip"
#addname "Harkath Lashwhip"
#addname "Idris Lashwhip"
#addname "Jekreth Lashwhip"
#addname "Killian Lashwhip"
#addname "Malichor Lashwhip"
#addname "Needle Lashwhip"
#addname "Opallus Lashwhip"
#addname "Pathyk Lashwhip"
#addname "Rath Lashwhip"
#addname "Greven Lashwhip"
#addname "Slaanth Lashwhip"
#addname "Tesker Lashwhip"
#addname "Ulvaud Lashwhip"
#addname "Vorth Lashwhip"
#addname "Wrack Lashwhip"
#addname "Slael Dreampincer"
#addname "Slael Soultaker"
#addname "Slael Warptouched"
#addname "Slael Hellflayer"
#addname "Slael the Obscene"
#addname "Slael Ripknife"
#addname "Slael Painheart"
#addname "Slael Screamsplitter"
#addname "Slael Slendertorn"
#addname "Slael Needlemask"
#addname "Slael Painlust"
#addname "Slael Fleshcarver"
#addname "Slael Mindwhip"
#addname "Slael the Agoniser"
#addname "Slael Bloodspiller"
#addname "Slael Snakespine"
#addname "Slael Thrillscream"
#addname "Skirael Dreampincer"
#addname "Skirael Soultaker"
#addname "Skirael Warptouched"
#addname "Skirael Hellflayer"
#addname "Skirael the Obscene"
#addname "Skirael Ripknife"
#addname "Skirael Painheart"
#addname "Skirael Screamsplitter"
#addname "Skirael Slendertorn"
#addname "Skirael Needlemask"
#addname "Skirael Painlust"
#addname "Skirael Fleshcarver"
#addname "Skirael Mindwhip"
#addname "Skirael the Agoniser"
#addname "Skirael Bloodspiller"
#addname "Skirael Snakespine"
#addname "Skirael Thrillscream"
#addname "Salaalek Dreampincer"
#addname "Salaalek Soultaker"
#addname "Salaalek Warptouched"
#addname "Salaalek Hellflayer"
#addname "Salaalek the Obscene"
#addname "Salaalek Ripknife"
#addname "Salaalek Painheart"
#addname "Salaalek Screamsplitter"
#addname "Salaalek Slendertorn"
#addname "Salaalek Needlemask"
#addname "Salaalek Painlust"
#addname "Salaalek Fleshcarver"
#addname "Salaalek Mindwhip"
#addname "Salaalek the Agoniser"
#addname "Salaalek Bloodspiller"
#addname "Salaalek Snakespine"
#addname "Salaalek Thrillscream"
#addname "Ashuz Dreampincer"
#addname "Ashuz Soultaker"
#addname "Ashuz Warptouched"
#addname "Ashuz Hellflayer"
#addname "Ashuz the Obscene"
#addname "Ashuz Ripknife"
#addname "Ashuz Painheart"
#addname "Ashuz Screamsplitter"
#addname "Ashuz Slendertorn"
#addname "Ashuz Needlemask"
#addname "Ashuz Painlust"
#addname "Ashuz Fleshcarver"
#addname "Ashuz Mindwhip"
#addname "Ashuz the Agoniser"
#addname "Ashuz Bloodspiller"
#addname "Ashuz Snakespine"
#addname "Ashuz Thrillscream"
#addname "Slash Dreampincer"
#addname "Slash Soultaker"
#addname "Slash Warptouched"
#addname "Slash Hellflayer"
#addname "Slash the Obscene"
#addname "Slash Ripknife"
#addname "Slash Painheart"
#addname "Slash Screamsplitter"
#addname "Slash Slendertorn"
#addname "Slash Needlemask"
#addname "Slash Painlust"
#addname "Slash Fleshcarver"
#addname "Slash Mindwhip"
#addname "Slash the Agoniser"
#addname "Slash Bloodspiller"
#addname "Slash Snakespine"
#addname "Slash Thrillscream"
#addname "Anglak Dreampincer"
#addname "Anglak Soultaker"
#addname "Anglak Warptouched"
#addname "Anglak Hellflayer"
#addname "Anglak the Obscene"
#addname "Anglak Ripknife"
#addname "Anglak Painheart"
#addname "Anglak Screamsplitter"
#addname "Anglak Slendertorn"
#addname "Anglak Needlemask"
#addname "Anglak Painlust"
#addname "Anglak Fleshcarver"
#addname "Anglak Mindwhip"
#addname "Anglak the Agoniser"
#addname "Anglak Bloodspiller"
#addname "Anglak Snakespine"
#addname "Anglak Thrillscream"
#addname "Relassek Dreampincer"
#addname "Relassek Soultaker"
#addname "Relassek Warptouched"
#addname "Relassek Hellflayer"
#addname "Relassek the Obscene"
#addname "Relassek Ripknife"
#addname "Relassek Painheart"
#addname "Relassek Screamsplitter"
#addname "Relassek Slendertorn"
#addname "Relassek Needlemask"
#addname "Relassek Painlust"
#addname "Relassek Fleshcarver"
#addname "Relassek Mindwhip"
#addname "Relassek the Agoniser"
#addname "Relassek Bloodspiller"
#addname "Relassek Snakespine"
#addname "Relassek Thrillscream"
#addname "Slithe Dreampincer"
#addname "Slithe Soultaker"
#addname "Slithe Warptouched"
#addname "Slithe Hellflayer"
#addname "Slithe the Obscene"
#addname "Slithe Ripknife"
#addname "Slithe Painheart"
#addname "Slithe Screamsplitter"
#addname "Slithe Slendertorn"
#addname "Slithe Needlemask"
#addname "Slithe Painlust"
#addname "Slithe Fleshcarver"
#addname "Slithe Mindwhip"
#addname "Slithe the Agoniser"
#addname "Slithe Bloodspiller"
#addname "Slithe Snakespine"
#addname "Slithe Thrillscream"
#addname "Sigfrid Dreampincer"
#addname "Sigfrid Soultaker"
#addname "Sigfrid Warptouched"
#addname "Sigfrid Hellflayer"
#addname "Sigfrid the Obscene"
#addname "Sigfrid Ripknife"
#addname "Sigfrid Painheart"
#addname "Sigfrid Screamsplitter"
#addname "Sigfrid Slendertorn"
#addname "Sigfrid Needlemask"
#addname "Sigfrid Painlust"
#addname "Sigfrid Fleshcarver"
#addname "Sigfrid Mindwhip"
#addname "Sigfrid the Agoniser"
#addname "Sigfrid Bloodspiller"
#addname "Sigfrid Snakespine"
#addname "Sigfrid Thrillscream"
#addname "Renkir Dreampincer"
#addname "Renkir Soultaker"
#addname "Renkir Warptouched"
#addname "Renkir Hellflayer"
#addname "Renkir the Obscene"
#addname "Renkir Ripknife"
#addname "Renkir Painheart"
#addname "Renkir Screamsplitter"
#addname "Renkir Slendertorn"
#addname "Renkir Needlemask"
#addname "Renkir Painlust"
#addname "Renkir Fleshcarver"
#addname "Renkir Mindwhip"
#addname "Renkir the Agoniser"
#addname "Renkir Bloodspiller"
#addname "Renkir Snakespine"
#addname "Renkir Thrillscream"
#addname "Svend Dreampincer"
#addname "Svend Soultaker"
#addname "Svend Warptouched"
#addname "Svend Hellflayer"
#addname "Svend the Obscene"
#addname "Svend Ripknife"
#addname "Svend Painheart"
#addname "Svend Screamsplitter"
#addname "Svend Slendertorn"
#addname "Svend Needlemask"
#addname "Svend Painlust"
#addname "Svend Fleshcarver"
#addname "Svend Mindwhip"
#addname "Svend the Agoniser"
#addname "Svend Bloodspiller"
#addname "Svend Snakespine"
#addname "Svend Thrillscream"
#addname "Bareth Dreampincer"
#addname "Bareth Soultaker"
#addname "Bareth Warptouched"
#addname "Bareth Hellflayer"
#addname "Bareth the Obscene"
#addname "Bareth Ripknife"
#addname "Bareth Painheart"
#addname "Bareth Screamsplitter"
#addname "Bareth Slendertorn"
#addname "Bareth Needlemask"
#addname "Bareth Painlust"
#addname "Bareth Fleshcarver"
#addname "Bareth Mindwhip"
#addname "Bareth the Agoniser"
#addname "Bareth Bloodspiller"
#addname "Bareth Snakespine"
#addname "Bareth Thrillscream"
#addname "Revna Dreampincer"
#addname "Revna Soultaker"
#addname "Revna Warptouched"
#addname "Revna Hellflayer"
#addname "Revna the Obscene"
#addname "Revna Ripknife"
#addname "Revna Painheart"
#addname "Revna Screamsplitter"
#addname "Revna Slendertorn"
#addname "Revna Needlemask"
#addname "Revna Painlust"
#addname "Revna Fleshcarver"
#addname "Revna Mindwhip"
#addname "Revna the Agoniser"
#addname "Revna Bloodspiller"
#addname "Revna Snakespine"
#addname "Revna Thrillscream"
#addname "Torde Dreampincer"
#addname "Torde Soultaker"
#addname "Torde Warptouched"
#addname "Torde Hellflayer"
#addname "Torde the Obscene"
#addname "Torde Ripknife"
#addname "Torde Painheart"
#addname "Torde Screamsplitter"
#addname "Torde Slendertorn"
#addname "Torde Needlemask"
#addname "Torde Painlust"
#addname "Torde Fleshcarver"
#addname "Torde Mindwhip"
#addname "Torde the Agoniser"
#addname "Torde Bloodspiller"
#addname "Torde Snakespine"
#addname "Torde Thrillscream"
#addname "Bodil Dreampincer"
#addname "Bodil Soultaker"
#addname "Bodil Warptouched"
#addname "Bodil Hellflayer"
#addname "Bodil the Obscene"
#addname "Bodil Ripknife"
#addname "Bodil Painheart"
#addname "Bodil Screamsplitter"
#addname "Bodil Slendertorn"
#addname "Bodil Needlemask"
#addname "Bodil Painlust"
#addname "Bodil Fleshcarver"
#addname "Bodil Mindwhip"
#addname "Bodil the Agoniser"
#addname "Bodil Bloodspiller"
#addname "Bodil Snakespine"
#addname "Bodil Thrillscream"
#addname "Signeth Dreampincer"
#addname "Signeth Soultaker"
#addname "Signeth Warptouched"
#addname "Signeth Hellflayer"
#addname "Signeth the Obscene"
#addname "Signeth Ripknife"
#addname "Signeth Painheart"
#addname "Signeth Screamsplitter"
#addname "Signeth Slendertorn"
#addname "Signeth Needlemask"
#addname "Signeth Painlust"
#addname "Signeth Fleshcarver"
#addname "Signeth Mindwhip"
#addname "Signeth the Agoniser"
#addname "Signeth Bloodspiller"
#addname "Signeth Snakespine"
#addname "Signeth Thrillscream"
#addname "Torsten Dreampincer"
#addname "Torsten Soultaker"
#addname "Torsten Warptouched"
#addname "Torsten Hellflayer"
#addname "Torsten the Obscene"
#addname "Torsten Ripknife"
#addname "Torsten Painheart"
#addname "Torsten Screamsplitter"
#addname "Torsten Slendertorn"
#addname "Torsten Needlemask"
#addname "Torsten Painlust"
#addname "Torsten Fleshcarver"
#addname "Torsten Mindwhip"
#addname "Torsten the Agoniser"
#addname "Torsten Bloodspiller"
#addname "Torsten Snakespine"
#addname "Torsten Thrillscream"
#addname "Rune Dreampincer"
#addname "Rune Soultaker"
#addname "Rune Warptouched"
#addname "Rune Hellflayer"
#addname "Rune the Obscene"
#addname "Rune Ripknife"
#addname "Rune Painheart"
#addname "Rune Screamsplitter"
#addname "Rune Slendertorn"
#addname "Rune Needlemask"
#addname "Rune Painlust"
#addname "Rune Fleshcarver"
#addname "Rune Mindwhip"
#addname "Rune the Agoniser"
#addname "Rune Bloodspiller"
#addname "Rune Snakespine"
#addname "Rune Thrillscream"
#addname "Skarde Dreampincer"
#addname "Skarde Soultaker"
#addname "Skarde Warptouched"
#addname "Skarde Hellflayer"
#addname "Skarde the Obscene"
#addname "Skarde Ripknife"
#addname "Skarde Painheart"
#addname "Skarde Screamsplitter"
#addname "Skarde Slendertorn"
#addname "Skarde Needlemask"
#addname "Skarde Painlust"
#addname "Skarde Fleshcarver"
#addname "Skarde Mindwhip"
#addname "Skarde the Agoniser"
#addname "Skarde Bloodspiller"
#addname "Skarde Snakespine"
#addname "Skarde Thrillscream"
#addname "Sigael Dreampincer"
#addname "Sigael Soultaker"
#addname "Sigael Warptouched"
#addname "Sigael Hellflayer"
#addname "Sigael the Obscene"
#addname "Sigael Ripknife"
#addname "Sigael Painheart"
#addname "Sigael Screamsplitter"
#addname "Sigael Slendertorn"
#addname "Sigael Needlemask"
#addname "Sigael Painlust"
#addname "Sigael Fleshcarver"
#addname "Sigael Mindwhip"
#addname "Sigael the Agoniser"
#addname "Sigael Bloodspiller"
#addname "Sigael Snakespine"
#addname "Sigael Thrillscream"
#addname "Gerrek Dreampincer"
#addname "Gerrek Soultaker"
#addname "Gerrek Warptouched"
#addname "Gerrek Hellflayer"
#addname "Gerrek the Obscene"
#addname "Gerrek Ripknife"
#addname "Gerrek Painheart"
#addname "Gerrek Screamsplitter"
#addname "Gerrek Slendertorn"
#addname "Gerrek Needlemask"
#addname "Gerrek Painlust"
#addname "Gerrek Fleshcarver"
#addname "Gerrek Mindwhip"
#addname "Gerrek the Agoniser"
#addname "Gerrek Bloodspiller"
#addname "Gerrek Snakespine"
#addname "Gerrek Thrillscream"
#addname "Lash Dreampincer"
#addname "Lash Soultaker"
#addname "Lash Warptouched"
#addname "Lash Hellflayer"
#addname "Lash the Obscene"
#addname "Lash Ripknife"
#addname "Lash Painheart"
#addname "Lash Screamsplitter"
#addname "Lash Slendertorn"
#addname "Lash Needlemask"
#addname "Lash Painlust"
#addname "Lash Fleshcarver"
#addname "Lash Mindwhip"
#addname "Lash the Agoniser"
#addname "Lash Bloodspiller"
#addname "Lash Snakespine"
#addname "Lash Thrillscream"
#addname "Torreg Dreampincer"
#addname "Torreg Soultaker"
#addname "Torreg Warptouched"
#addname "Torreg Hellflayer"
#addname "Torreg the Obscene"
#addname "Torreg Ripknife"
#addname "Torreg Painheart"
#addname "Torreg Screamsplitter"
#addname "Torreg Slendertorn"
#addname "Torreg Needlemask"
#addname "Torreg Painlust"
#addname "Torreg Fleshcarver"
#addname "Torreg Mindwhip"
#addname "Torreg the Agoniser"
#addname "Torreg Bloodspiller"
#addname "Torreg Snakespine"
#addname "Torreg Thrillscream"
#addname "Blesk Dreampincer"
#addname "Blesk Soultaker"
#addname "Blesk Warptouched"
#addname "Blesk Hellflayer"
#addname "Blesk the Obscene"
#addname "Blesk Ripknife"
#addname "Blesk Painheart"
#addname "Blesk Screamsplitter"
#addname "Blesk Slendertorn"
#addname "Blesk Needlemask"
#addname "Blesk Painlust"
#addname "Blesk Fleshcarver"
#addname "Blesk Mindwhip"
#addname "Blesk the Agoniser"
#addname "Blesk Bloodspiller"
#addname "Blesk Snakespine"
#addname "Blesk Thrillscream"
#addname "Artulf Dreampincer"
#addname "Artulf Soultaker"
#addname "Artulf Warptouched"
#addname "Artulf Hellflayer"
#addname "Artulf the Obscene"
#addname "Artulf Ripknife"
#addname "Artulf Painheart"
#addname "Artulf Screamsplitter"
#addname "Artulf Slendertorn"
#addname "Artulf Needlemask"
#addname "Artulf Painlust"
#addname "Artulf Fleshcarver"
#addname "Artulf Mindwhip"
#addname "Artulf the Agoniser"
#addname "Artulf Bloodspiller"
#addname "Artulf Snakespine"
#addname "Artulf Thrillscream"
#addname "Dechal Dreampincer"
#addname "Dechal Soultaker"
#addname "Dechal Warptouched"
#addname "Dechal Hellflayer"
#addname "Dechal the Obscene"
#addname "Dechal Ripknife"
#addname "Dechal Painheart"
#addname "Dechal Screamsplitter"
#addname "Dechal Slendertorn"
#addname "Dechal Needlemask"
#addname "Dechal Painlust"
#addname "Dechal Fleshcarver"
#addname "Dechal Mindwhip"
#addname "Dechal the Agoniser"
#addname "Dechal Bloodspiller"
#addname "Dechal Snakespine"
#addname "Dechal Thrillscream"
#addname "Tove Dreampincer"
#addname "Tove Soultaker"
#addname "Tove Warptouched"
#addname "Tove Hellflayer"
#addname "Tove the Obscene"
#addname "Tove Ripknife"
#addname "Tove Painheart"
#addname "Tove Screamsplitter"
#addname "Tove Slendertorn"
#addname "Tove Needlemask"
#addname "Tove Painlust"
#addname "Tove Fleshcarver"
#addname "Tove Mindwhip"
#addname "Tove the Agoniser"
#addname "Tove Bloodspiller"
#addname "Tove Snakespine"
#addname "Tove Thrillscream"
#addname "Splice Dreampincer"
#addname "Splice Soultaker"
#addname "Splice Warptouched"
#addname "Splice Hellflayer"
#addname "Splice the Obscene"
#addname "Splice Ripknife"
#addname "Splice Painheart"
#addname "Splice Screamsplitter"
#addname "Splice Slendertorn"
#addname "Splice Needlemask"
#addname "Splice Painlust"
#addname "Splice Fleshcarver"
#addname "Splice Mindwhip"
#addname "Splice the Agoniser"
#addname "Splice Bloodspiller"
#addname "Splice Snakespine"
#addname "Splice Thrillscream"
#addname "Aangard Dreampincer"
#addname "Aangard Soultaker"
#addname "Aangard Warptouched"
#addname "Aangard Hellflayer"
#addname "Aangard the Obscene"
#addname "Aangard Ripknife"
#addname "Aangard Painheart"
#addname "Aangard Screamsplitter"
#addname "Aangard Slendertorn"
#addname "Aangard Needlemask"
#addname "Aangard Painlust"
#addname "Aangard Fleshcarver"
#addname "Aangard Mindwhip"
#addname "Aangard the Agoniser"
#addname "Aangard Bloodspiller"
#addname "Aangard Snakespine"
#addname "Aangard Thrillscream"
#addname "Balath Dreampincer"
#addname "Balath Soultaker"
#addname "Balath Warptouched"
#addname "Balath Hellflayer"
#addname "Balath the Obscene"
#addname "Balath Ripknife"
#addname "Balath Painheart"
#addname "Balath Screamsplitter"
#addname "Balath Slendertorn"
#addname "Balath Needlemask"
#addname "Balath Painlust"
#addname "Balath Fleshcarver"
#addname "Balath Mindwhip"
#addname "Balath the Agoniser"
#addname "Balath Bloodspiller"
#addname "Balath Snakespine"
#addname "Balath Thrillscream"
#addname "Cael Dreampincer"
#addname "Cael Soultaker"
#addname "Cael Warptouched"
#addname "Cael Hellflayer"
#addname "Cael the Obscene"
#addname "Cael Ripknife"
#addname "Cael Painheart"
#addname "Cael Screamsplitter"
#addname "Cael Slendertorn"
#addname "Cael Needlemask"
#addname "Cael Painlust"
#addname "Cael Fleshcarver"
#addname "Cael Mindwhip"
#addname "Cael the Agoniser"
#addname "Cael Bloodspiller"
#addname "Cael Snakespine"
#addname "Cael Thrillscream"
#addname "Drowdr Dreampincer"
#addname "Drowdr Soultaker"
#addname "Drowdr Warptouched"
#addname "Drowdr Hellflayer"
#addname "Drowdr the Obscene"
#addname "Drowdr Ripknife"
#addname "Drowdr Painheart"
#addname "Drowdr Screamsplitter"
#addname "Drowdr Slendertorn"
#addname "Drowdr Needlemask"
#addname "Drowdr Painlust"
#addname "Drowdr Fleshcarver"
#addname "Drowdr Mindwhip"
#addname "Drowdr the Agoniser"
#addname "Drowdr Bloodspiller"
#addname "Drowdr Snakespine"
#addname "Drowdr Thrillscream"
#addname "Eathor Dreampincer"
#addname "Eathor Soultaker"
#addname "Eathor Warptouched"
#addname "Eathor Hellflayer"
#addname "Eathor the Obscene"
#addname "Eathor Ripknife"
#addname "Eathor Painheart"
#addname "Eathor Screamsplitter"
#addname "Eathor Slendertorn"
#addname "Eathor Needlemask"
#addname "Eathor Painlust"
#addname "Eathor Fleshcarver"
#addname "Eathor Mindwhip"
#addname "Eathor the Agoniser"
#addname "Eathor Bloodspiller"
#addname "Eathor Snakespine"
#addname "Eathor Thrillscream"
#addname "Flayl Dreampincer"
#addname "Flayl Soultaker"
#addname "Flayl Warptouched"
#addname "Flayl Hellflayer"
#addname "Flayl the Obscene"
#addname "Flayl Ripknife"
#addname "Flayl Painheart"
#addname "Flayl Screamsplitter"
#addname "Flayl Slendertorn"
#addname "Flayl Needlemask"
#addname "Flayl Painlust"
#addname "Flayl Fleshcarver"
#addname "Flayl Mindwhip"
#addname "Flayl the Agoniser"
#addname "Flayl Bloodspiller"
#addname "Flayl Snakespine"
#addname "Flayl Thrillscream"
#addname "Gleeth Dreampincer"
#addname "Gleeth Soultaker"
#addname "Gleeth Warptouched"
#addname "Gleeth Hellflayer"
#addname "Gleeth the Obscene"
#addname "Gleeth Ripknife"
#addname "Gleeth Painheart"
#addname "Gleeth Screamsplitter"
#addname "Gleeth Slendertorn"
#addname "Gleeth Needlemask"
#addname "Gleeth Painlust"
#addname "Gleeth Fleshcarver"
#addname "Gleeth Mindwhip"
#addname "Gleeth the Agoniser"
#addname "Gleeth Bloodspiller"
#addname "Gleeth Snakespine"
#addname "Gleeth Thrillscream"
#addname "Harkath Dreampincer"
#addname "Harkath Soultaker"
#addname "Harkath Warptouched"
#addname "Harkath Hellflayer"
#addname "Harkath the Obscene"
#addname "Harkath Ripknife"
#addname "Harkath Painheart"
#addname "Harkath Screamsplitter"
#addname "Harkath Slendertorn"
#addname "Harkath Needlemask"
#addname "Harkath Painlust"
#addname "Harkath Fleshcarver"
#addname "Harkath Mindwhip"
#addname "Harkath the Agoniser"
#addname "Harkath Bloodspiller"
#addname "Harkath Snakespine"
#addname "Harkath Thrillscream"
#addname "Idris Dreampincer"
#addname "Idris Soultaker"
#addname "Idris Warptouched"
#addname "Idris Hellflayer"
#addname "Idris the Obscene"
#addname "Idris Ripknife"
#addname "Idris Painheart"
#addname "Idris Screamsplitter"
#addname "Idris Slendertorn"
#addname "Idris Needlemask"
#addname "Idris Painlust"
#addname "Idris Fleshcarver"
#addname "Idris Mindwhip"
#addname "Idris the Agoniser"
#addname "Idris Bloodspiller"
#addname "Idris Snakespine"
#addname "Idris Thrillscream"
#addname "Jekreth Dreampincer"
#addname "Jekreth Soultaker"
#addname "Jekreth Warptouched"
#addname "Jekreth Hellflayer"
#addname "Jekreth the Obscene"
#addname "Jekreth Ripknife"
#addname "Jekreth Painheart"
#addname "Jekreth Screamsplitter"
#addname "Jekreth Slendertorn"
#addname "Jekreth Needlemask"
#addname "Jekreth Painlust"
#addname "Jekreth Fleshcarver"
#addname "Jekreth Mindwhip"
#addname "Jekreth the Agoniser"
#addname "Jekreth Bloodspiller"
#addname "Jekreth Snakespine"
#addname "Jekreth Thrillscream"
#addname "Killian Dreampincer"
#addname "Killian Soultaker"
#addname "Killian Warptouched"
#addname "Killian Hellflayer"
#addname "Killian the Obscene"
#addname "Killian Ripknife"
#addname "Killian Painheart"
#addname "Killian Screamsplitter"
#addname "Killian Slendertorn"
#addname "Killian Needlemask"
#addname "Killian Painlust"
#addname "Killian Fleshcarver"
#addname "Killian Mindwhip"
#addname "Killian the Agoniser"
#addname "Killian Bloodspiller"
#addname "Killian Snakespine"
#addname "Killian Thrillscream"
#addname "Malichor Dreampincer"
#addname "Malichor Soultaker"
#addname "Malichor Warptouched"
#addname "Malichor Hellflayer"
#addname "Malichor the Obscene"
#addname "Malichor Ripknife"
#addname "Malichor Painheart"
#addname "Malichor Screamsplitter"
#addname "Malichor Slendertorn"
#addname "Malichor Needlemask"
#addname "Malichor Painlust"
#addname "Malichor Fleshcarver"
#addname "Malichor Mindwhip"
#addname "Malichor the Agoniser"
#addname "Malichor Bloodspiller"
#addname "Malichor Snakespine"
#addname "Malichor Thrillscream"
#addname "Needle Dreampincer"
#addname "Needle Soultaker"
#addname "Needle Warptouched"
#addname "Needle Hellflayer"
#addname "Needle the Obscene"
#addname "Needle Ripknife"
#addname "Needle Painheart"
#addname "Needle Screamsplitter"
#addname "Needle Slendertorn"
#addname "Needle Needlemask"
#addname "Needle Painlust"
#addname "Needle Fleshcarver"
#addname "Needle Mindwhip"
#addname "Needle the Agoniser"
#addname "Needle Bloodspiller"
#addname "Needle Snakespine"
#addname "Needle Thrillscream"
#addname "Opallus Dreampincer"
#addname "Opallus Soultaker"
#addname "Opallus Warptouched"
#addname "Opallus Hellflayer"
#addname "Opallus the Obscene"
#addname "Opallus Ripknife"
#addname "Opallus Painheart"
#addname "Opallus Screamsplitter"
#addname "Opallus Slendertorn"
#addname "Opallus Needlemask"
#addname "Opallus Painlust"
#addname "Opallus Fleshcarver"
#addname "Opallus Mindwhip"
#addname "Opallus the Agoniser"
#addname "Opallus Bloodspiller"
#addname "Opallus Snakespine"
#addname "Opallus Thrillscream"
#addname "Pathyk Dreampincer"
#addname "Pathyk Soultaker"
#addname "Pathyk Warptouched"
#addname "Pathyk Hellflayer"
#addname "Pathyk the Obscene"
#addname "Pathyk Ripknife"
#addname "Pathyk Painheart"
#addname "Pathyk Screamsplitter"
#addname "Pathyk Slendertorn"
#addname "Pathyk Needlemask"
#addname "Pathyk Painlust"
#addname "Pathyk Fleshcarver"
#addname "Pathyk Mindwhip"
#addname "Pathyk the Agoniser"
#addname "Pathyk Bloodspiller"
#addname "Pathyk Snakespine"
#addname "Pathyk Thrillscream"
#addname "Rath Dreampincer"
#addname "Rath Soultaker"
#addname "Rath Warptouched"
#addname "Rath Hellflayer"
#addname "Rath the Obscene"
#addname "Rath Ripknife"
#addname "Rath Painheart"
#addname "Rath Screamsplitter"
#addname "Rath Slendertorn"
#addname "Rath Needlemask"
#addname "Rath Painlust"
#addname "Rath Fleshcarver"
#addname "Rath Mindwhip"
#addname "Rath the Agoniser"
#addname "Rath Bloodspiller"
#addname "Rath Snakespine"
#addname "Rath Thrillscream"
#addname "Greven Dreampincer"
#addname "Greven Soultaker"
#addname "Greven Warptouched"
#addname "Greven Hellflayer"
#addname "Greven the Obscene"
#addname "Greven Ripknife"
#addname "Greven Painheart"
#addname "Greven Screamsplitter"
#addname "Greven Slendertorn"
#addname "Greven Needlemask"
#addname "Greven Painlust"
#addname "Greven Fleshcarver"
#addname "Greven Mindwhip"
#addname "Greven the Agoniser"
#addname "Greven Bloodspiller"
#addname "Greven Snakespine"
#addname "Greven Thrillscream"
#addname "Slaanth Dreampincer"
#addname "Slaanth Soultaker"
#addname "Slaanth Warptouched"
#addname "Slaanth Hellflayer"
#addname "Slaanth the Obscene"
#addname "Slaanth Ripknife"
#addname "Slaanth Painheart"
#addname "Slaanth Screamsplitter"
#addname "Slaanth Slendertorn"
#addname "Slaanth Needlemask"
#addname "Slaanth Painlust"
#addname "Slaanth Fleshcarver"
#addname "Slaanth Mindwhip"
#addname "Slaanth the Agoniser"
#addname "Slaanth Bloodspiller"
#addname "Slaanth Snakespine"
#addname "Slaanth Thrillscream"
#addname "Tesker Dreampincer"
#addname "Tesker Soultaker"
#addname "Tesker Warptouched"
#addname "Tesker Hellflayer"
#addname "Tesker the Obscene"
#addname "Tesker Ripknife"
#addname "Tesker Painheart"
#addname "Tesker Screamsplitter"
#addname "Tesker Slendertorn"
#addname "Tesker Needlemask"
#addname "Tesker Painlust"
#addname "Tesker Fleshcarver"
#addname "Tesker Mindwhip"
#addname "Tesker the Agoniser"
#addname "Tesker Bloodspiller"
#addname "Tesker Snakespine"
#addname "Tesker Thrillscream"
#addname "Ulvaud Dreampincer"
#addname "Ulvaud Soultaker"
#addname "Ulvaud Warptouched"
#addname "Ulvaud Hellflayer"
#addname "Ulvaud the Obscene"
#addname "Ulvaud Ripknife"
#addname "Ulvaud Painheart"
#addname "Ulvaud Screamsplitter"
#addname "Ulvaud Slendertorn"
#addname "Ulvaud Needlemask"
#addname "Ulvaud Painlust"
#addname "Ulvaud Fleshcarver"
#addname "Ulvaud Mindwhip"
#addname "Ulvaud the Agoniser"
#addname "Ulvaud Bloodspiller"
#addname "Ulvaud Snakespine"
#addname "Ulvaud Thrillscream"
#addname "Vorth Dreampincer"
#addname "Vorth Soultaker"
#addname "Vorth Warptouched"
#addname "Vorth Hellflayer"
#addname "Vorth the Obscene"
#addname "Vorth Ripknife"
#addname "Vorth Painheart"
#addname "Vorth Screamsplitter"
#addname "Vorth Slendertorn"
#addname "Vorth Needlemask"
#addname "Vorth Painlust"
#addname "Vorth Fleshcarver"
#addname "Vorth Mindwhip"
#addname "Vorth the Agoniser"
#addname "Vorth Bloodspiller"
#addname "Vorth Snakespine"
#addname "Vorth Thrillscream"
#addname "Wrack Dreampincer"
#addname "Wrack Soultaker"
#addname "Wrack Warptouched"
#addname "Wrack Hellflayer"
#addname "Wrack the Obscene"
#addname "Wrack Ripknife"
#addname "Wrack Painheart"
#addname "Wrack Screamsplitter"
#addname "Wrack Slendertorn"
#addname "Wrack Needlemask"
#addname "Wrack Painlust"
#addname "Wrack Fleshcarver"
#addname "Wrack Mindwhip"
#addname "Wrack the Agoniser"
#addname "Wrack Bloodspiller"
#addname "Wrack Snakespine"
#addname "Wrack Thrillscream"
#addname "Scorpael Painfeast"
#addname "Skrirael Dreampincer"
#addname "Slael Barbhook"
#addname "Salaalek Warptouched"
#addname "Ashuz Slendertorn"
#addname "Harvolt Ripknife"
#addname "Harkon Lashwhip"
#addname "Shoras Barbsplice"
#addname "Skilas Needlemask"
#addname "Slashhook"
#addname "Relassek"
#addname "Ravacius Painlust"
#addname "Agonaalek"
#addname "Paincrawl"
#end


-- Slaaneshi Daemon names

#selectnametype 199
#addname "Pleasurespine"
#addname "Slenderspine"
#addname "Pleasureclaw"
#addname "Muskwhip"
#addname "Desecrator"
#addname "Violator"
#addname "Painwhip"
#addname "Painspike"
#addname "Slenderspike"
#addname "Thrillstab"
#addname "Thrillspine"
#addname "Skinlick"
#addname "Skinwhip"
#addname "Whiptouch"
#addname "Thrilltongue"
#addname "Sharpflesh"
#addname "Hookflesh"
#addname "Cenobite"
#addname "Sniptongue"
#addname "Snakespine"
#addname "Splitspine"
#addname "Dreamlash"
#addname "Dreamwhip"
#addname "Mindwhip"
#addname "Soultear"
#addname "Bloodlick"
#addname "Soulsnip"
#addname "Rendtouch"
#addname "Screamwhip"
#addname "Bloodcaper"
#addname "Soulsplice"
#addname "Whipsplice"
#addname "Spinesplice"
#addname "Bloodlash"
#addname "Serpentkin"
#addname "Serpentspine"
#addname "Fleshscream"
#addname "Warplash"
#addname "Warpspine"
#addname "Blooddancer"
#addname "Souldancer"
#addname "Screamhowl"
#addname "Hitherthirst"
#addname "Soulthirster"
#addname "Fleshthirster"
#addname "Fleshcarver"
#addname "Soulcarver"
#addname "The Delector"
#addname "Pulsefeaster"
#addname "Bloodlicker"
#addname "Spleendancer"
#addname "Painrapture"
#addname "The Writher"
#addname "Nkai"
#addname "Handsplicer"
#addname "Fleshwarp"
#addname "Hellwhip"
#addname "Painsmith"
#addname "Painsage"
#addname "Hellscream"
#addname "Pulsecutter"
#addname "Slashwrithe"
#addname "Stingwrithe"
#addname "Celebror"
#addname "Karith"
#addname "Violator"
#addname "Imperitrex"
#addname "Soulwormer"
#end


----------SITES


------ Palace of Pleasured Screams

#newsite 2086
#name "Palace of Pleasured Screams"
#path 9 -- holy
#level 0
#rarity 5
#gems 4 1 -- 1 astral
#gems 7 2 -- 2 glamour
#gems 8 4 -- 4 slaves
#homecom 14237 -- Exalted Hero
#homecom 14230 -- sorcerer lord
#homemon 14217 -- Chosen of Slaanesh
#homemon 14239 -- Chosen Knight of Slaanesh
#end

-----------FUTURESITES

#newsite 2059
#name "Slaanesh Summons"
#path 8 -- blood
#level 0
#rarity 5
#homemon 14255 -- Daemonette
#homemon 14257 -- Seeker
#homemon 14265 -- Fiend
#homecom 14260 -- herald of slaanesh -- could be male or female
#homecom 14270 -- daemon prince
#homecom 14252 -- keeper of secrets -- could be male or female
#end

#newsite 2070
#name "Slaanesh Commander Promotions"
#path 8 -- blood
#level 0
#rarity 5
#homecom 14224 -- Aspiring Champion
#homecom 14237 -- Exalted Hero
#homecom 14267 -- Chaos Lord
#homecom 14270 -- daemon prince
#end

#newsite 2077
#name "Slaanesh Troop Promotions"
#path 8 -- blood
#level 0
#rarity 5
#homemon 14205 -- Warrior of Slaanesh (sword and shield)
#homemon 14225 -- Warrior of Slaanesh (glaive)
#homemon 14217 -- Chosen of Slaanesh
#homemon 14214 -- Knight of Slaanesh
#homemon 14239 -- Chosen Knight of Slaanesh
#homemon 14218 -- Forsaken Warrior
#end

#newsite 2085
#name "Slaanesh Spawn"
#path 8 -- blood
#level 0
#rarity 5
#homemon 14219
#homemon 14244
#homemon 14247
#homemon 14271
#homemon 14274
#homemon 14277
#homemon 14280
#homemon 14283
#homemon 14286
#homemon 14289
#end

#newsite 2078
#name "Slaanesh Multiheroes"
#path 4 -- astral
#level 0
#rarity 5
#homecom 14267 -- Chaos Lord
#homecom 14230 -- sorcerer lord
#homecom 14260 -- herald of slaanesh -- could be male or female
#end

#newsite 2079
#name "Slaanesh Luck-independent Heroes"
#path 9 -- holy
#level 0
#rarity 5
#homecom 14302 -- styrkaar
#homecom 14305 -- Azazel
#homecom 14306 -- nkari in dominion
#homecom 14659 -- sigvald
#homemon 14663 -- mirror guard
#end


---------------- EVENTS --------------------


---------------- WELCOME TO SLAANESH -----------------

#newevent
#msg "Slaanesh special mechanics explainer:

Path of the Warrior. Your Chaos Warriors and Knights can, through XP, earn the chance to be promoted to a Chosen. This won't trigger until the turn after the game announces their promotion and will only happen when they are outside of their home province (for technical reasons). They then face the judgement of Slaanesh and may be either Chosen, Forsaken, or twisted into a Chaos Spawn.

Path of the Champion. Your military commanders can also earn promotion for a chance of a more powerful form. Unlike the troops it can trigger even in their home province. Aspiring Champions can become Exalted Heroes who can become Chaos Lords who can finally become a Daemon Prince. At each stage of judgement Slaanesh may turn them into a Chaos Spawn (killing them and giving you a Spawn as a troop), though the Spawn will tend to be more powerful than those from failed troop promotions.

Dominion of Sensation. Your dominion has increased importance because some recruitables are locked behind minimum levels, your Daemons are weaker outside your dominion, and your dominion decreases unrest for provinces you control and increases it if the enemy does, based on its strength."
#header 2 -- use the first line of the event as the header
#req_owncapital 1
#req_pregame 1 -- only happens before the first turn of the game
#req_fornation 169
#nation 169
#req_unique 1
#rarity 5
#end


--------------- HERO EVENTS -----------------

-- Sigvald the Magnificent

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Sigvald the Magnificent, Scion of Slaanesh and adopted son of the Dark Prince has joined your cause, flanked by bodyguards carrying mirrored shields so that he might admire his own form from many angles in battle."
#req_owncapital 1
#req_fornation 169
#nation 169
#com 14659
#req_nomnr 14659
#req_varzero 204 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 204 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 2 -- 2% chance, he's pretty good
#req_turn 8 -- too good to be early
#header 2
#2d3units 14663 -- mirror guard
#end

---- Spawn some more mirror guard for Sigvald

#newevent
#msg "A Mirror Guard has been selected by Sigvald.

Sigvald the Magnificent has found a warrior worthy of joining his Mirror Guard and inducted them into the ranks."
#req_fornation 169
#nation 169
#req_monster 14659
#req_mindef 1
#rarity 5
#req_rare 3
#req_land 1
#1unit 14663 -- mirror guard
#header 2
#end


-- Dechala the Denied One -- four arms rather than 6 I reckon

-- The Masque of Slaanesh -- special herald daemonette

-- Azazel

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Azazel the Prince of Damnation and foremost amongst the Daemon Princes of Slaanesh has joined your cause."
#req_owncapital 1
#req_fornation 169
#nation 169
#com 14305
#req_nomnr 14305
#req_varzero 205 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 205 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 2 -- 2% chance, he's pretty good
#req_turn 12 -- too good to be early
#header 2
#end

-- Styrkaar of the Sortsvinaer

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Styrkaar the Prince of the Sortsvinaer has joined your cause, bringing with him a small force of Marauders from his tribe."
#req_owncapital 1
#req_fornation 169
#nation 169
#com 14302
#req_nomnr 14302
#req_varzero 206 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 206 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 2 -- 2% chance, he's pretty good
#4d3units 14203 -- Marauder Hunter (javelins, spear)
#4d3units -1032 -- marauder montag
#req_turn 8 -- too good as an early expander
#header 2
#end

-- N'Kari

#newevent
#msg "A unique hero has joined your cause!

The mighty hero N'Kari the Ruination of Ulthuan and foremost amongst the Greater Daemons of Slaanesh has joined your cause."
#req_owncapital 1
#req_fornation 169
#nation 169
#com 14306
#req_nomnr 14036
#req_varzero 207 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 207 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 2 -- 2% chance, he's pretty good
#req_turn 14 -- too good to be early
#header 2
#end



---------------- GENERIC EVENTS ---------------

---------------- TURMOIL INCREASE FOR SLAANESH --------------

--newevent
--msg "adding turmoil"
--notext
--nolog
--req_pop0ok
--req_indepok 1 -- can happen in indy prov
--rarity 5
--req_domowner 169
--incscale 0 -- increase Turmoil by 1
--end

----- Decrease unrest in Slaanesh dominion when province is owned by slaanesh. Each point of dom decreases unrest by 1 each turn

#newevent
#msg "decrease unrest 1"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 1 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end

#newevent
#msg "decrease unrest 2"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 2 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end

#newevent
#msg "decrease unrest 3"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 3 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end

#newevent
#msg "decrease unrest 4"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 4 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end

#newevent
#msg "decrease unrest 5"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 5 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end

#newevent
#msg "decrease unrest 6"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 6 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end

#newevent
#msg "decrease unrest 7"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 7 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end

#newevent
#msg "decrease unrest 8"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 8 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end

#newevent
#msg "decrease unrest 9"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 9 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end

#newevent
#msg "decrease unrest 10"
#notext
#nolog
#req_pop0ok
#req_fornation 169
#req_dominion 10 -- province must have owner's dominion at this value or more
#rarity 5
#nation 169
#unrest -1
#end


------ Events to increase unrest in provinces with slaanesh dominion but not owned by slaanesh
-- I can't do this straightforwardly, so instead I'm having 10 events each of which gives 1% per slaanesh candle chance of making 1 unrest. So 1 candle = ten 10% chances of 1 unrest. 10 candles = ten 100% chances of 1 unrest.

#newevent
#msg "increase unrest 1"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end

#newevent
#msg "increase unrest 2"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end

#newevent
#msg "increase unrest 3"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end

#newevent
#msg "increase unrest 4"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end

#newevent
#msg "increase unrest 5"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end

#newevent
#msg "increase unrest 6"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end

#newevent
#msg "increase unrest 7"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end

#newevent
#msg "increase unrest 8"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end

#newevent
#msg "increase unrest 9"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end

#newevent
#msg "increase unrest 10"
#notext
#nolog
#req_notfornation 169 -- everyone other than slaanesh can have this event
#req_domowner 169 -- province must have slaanesh's dominion
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_domchance 10 -- 10% per candle
#unrest 1
#end




---------------- PROMOTION EVENTS ------------------ (these are doubled up to handle 2 of the same in one prov)

---- Promotion from Aspiring Champion -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 169
#req_monster 14224
#req_targmnr 14224
#nation 169
#msg "Aspiring Champion in ##landname## twisted into a Spawn.

An Aspiring Champion who dared to draw the gaze of Slaanesh and seek Exaltation was found lacking and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1033 -- commander spawns montag
#header 2
#end


---- Promotion from Aspiring Champion to Exalted Hero, successful
#newevent
#rarity 5
#req_pop0ok
#req_fornation 169
#req_monster 14224
#req_targmnr 14224
#nation 169
#msg "Aspiring Champion became Exalted in ##landname##.

An Aspiring Champion who dared to draw the gaze of Slaanesh and seek Exaltation was judged pleasing to the senses by Slaanesh and promoted to Exalted Hero"
#transform 14237
#xp -99
#header 2
#end

---- Promotion from Aspiring Champion -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 169
#req_monster 14224
#req_targmnr 14224
#nation 169
#msg "Aspiring Champion in ##landname## twisted into a Spawn.

An Aspiring Champion who dared to draw the gaze of Slaanesh and seek Exaltation was found lacking and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1033 -- commander spawns montag
#header 2
#end


---- Promotion from Aspiring Champion to Exalted Hero, successful
#newevent
#rarity 5
#req_pop0ok
#req_fornation 169
#req_monster 14224
#req_targmnr 14224
#nation 169
#msg "Aspiring Champion became Exalted in ##landname##.

An Aspiring Champion who dared to draw the gaze of Slaanesh and seek Exaltation was judged pleasing to the senses by Slaanesh and promoted to Exalted Hero"
#transform 14237
#xp -99
#header 2
#end


---- Promotion from Exalted Hero -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 169
#req_monster 14238 -- exalted hero
#req_targmnr 14238 -- exalted hero
#nation 169
#msg "Exalted Hero in ##landname## twisted into a Spawn.

An Exalted Hero who dared to draw the gaze of Slaanesh and seek the title of Chaos Lord was found lacking and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1033 -- commander spawns montag
#header 2
#end

---- Promotion from Exalted Hero to Chaos Lord, successful
#newevent
#rarity 5
#req_pop0ok
#req_fornation 169
#req_monster 14238 -- exalted hero
#req_targmnr 14238 -- exalted hero
#nation 169
#msg "Exalted Hero became a Chaos Lord in ##landname##.

An Exalted Hero who dared to draw the gaze of Slaanesh and seek the title of Chaos Lord was judged pleasing to the senses by Slaanesh and promoted to this highest of mortal titles."
#transform 14267 -- chaos lord
#remount
#xp -99
#header 2
#end


---- Promotion from Exalted Hero -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 169
#req_monster 14238 -- exalted hero
#req_targmnr 14238 -- exalted hero
#nation 169
#msg "Exalted Hero in ##landname## twisted into a Spawn.

An Exalted Hero who dared to draw the gaze of Slaanesh and seek the title of Chaos Lord was found lacking and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1033 -- commander spawns montag
#header 2
#end

---- Promotion from Exalted Hero to Chaos Lord, successful
#newevent
#rarity 5
#req_pop0ok
#req_fornation 169
#req_monster 14238 -- exalted hero
#req_targmnr 14238 -- exalted hero
#nation 169
#msg "Exalted Hero became a Chaos Lord in ##landname##.

An Exalted Hero who dared to draw the gaze of Slaanesh and seek the title of Chaos Lord was judged pleasing to the senses by Slaanesh and promoted to this highest of mortal titles."
#transform 14267 -- chaos lord
#remount
#xp -99
#header 2
#end


---- Promotion from Chaos Lord -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 169
#req_monster 14268 -- chaos lord
#req_targmnr 14268 -- chaos lord
#req_targprophet 0
#nation 169
#msg "Chaos Lord in ##landname## twisted into a Spawn.

A Chaos Lord who stood expectant of ascension to Daemonhood was punished at the last moment for his hubris and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1033 -- commander spawns montag
#header 2
#end

---- Promotion from Chaos Lord to Daemon Prince, successful
#newevent
#rarity 5
#req_pop0ok
#req_fornation 169
#req_monster 14268 -- chaos lord
#req_targmnr 14268 -- chaos lord
#req_targprophet 0
#nation 169
#msg "A new Daemon Prince emerges in ##landname##!

A Chaos Lord who stood expectant of ascension to Daemonhood was granted that perfect form and Daemonic immortality at the sensual whims of the Dark Prince, Slaanesh. This is the way of the new flesh!"
#transform 14270 -- daemon prince
#xp -99
#pathboost 7 -- glamour
#pathboost 7 -- glamour
#pathboost 4 -- astral
#pathboost 4 -- astral
#pathboost 8 -- blood
#pathboost 9 -- holy
#pathboost 9 -- holy
#header 2
#end


---- Promotion from Chaos Lord -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 15 -- this is a more sensible value
#req_fornation 169
#req_monster 14268 -- chaos lord
#req_targmnr 14268 -- chaos lord
#req_targprophet 0
#nation 169
#msg "Chaos Lord in ##landname## twisted into a Spawn.

A Chaos Lord who stood expectant of ascension to Daemonhood was punished at the last moment for his hubris and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1033 -- commander spawns montag
#header 2
#end

---- Promotion from Chaos Lord to Daemon Prince, successful
#newevent
#rarity 5
#req_pop0ok
#req_fornation 169
#req_monster 14268 -- chaos lord
#req_targmnr 14268 -- chaos lord
#req_targprophet 0
#nation 169
#msg "A new Daemon Prince emerges in ##landname##!

A Chaos Lord who stood expectant of ascension to Daemonhood was granted that perfect form and Daemonic immortality at the sensual whims of the Dark Prince, Slaanesh. This is the way of the new flesh!"
#transform 14270 -- daemon prince
#xp -99
#pathboost 7 -- glamour
#pathboost 7 -- glamour
#pathboost 4 -- astral
#pathboost 4 -- astral
#pathboost 8 -- blood
#pathboost 9 -- holy
#pathboost 9 -- holy
#header 2
#end


---- here are two events to transform a prophet into a daemon prince, which don't add the holy

---- Promotion from Chaos Lord -- FAILURE -- Spawn generated
#newevent
#rarity 5
#req_pop0ok
#req_rare 10 -- Prophets less likely to spawn out
#req_fornation 169
#req_monster 14268 -- chaos lord
#req_targmnr 14268 -- chaos lord
#req_targprophet 1 -- must be prophet
#nation 169
#msg "Chaos Lord in ##landname## twisted into a Spawn.

A Chaos Lord who stood expectant of ascension to Daemonhood was punished at the last moment for his hubris and twisted into a horrific, Chaos Spawn."
#killtarg
#1unit -1033 -- commander spawns montag
#header 2
#end

---- Promotion from Chaos Lord to Daemon Prince, successful
#newevent
#rarity 5
#req_pop0ok
#req_fornation 169
#req_monster 14268 -- chaos lord
#req_targmnr 14268 -- chaos lord
#req_targprophet 1 -- must be prophet
#nation 169
#msg "A new Daemon Prince emerges in ##landname##!

A Chaos Lord who stood expectant of ascension to Daemonhood was granted that perfect form and Daemonic immortality at the sensual whims of the Dark Prince, Slaanesh. This is the way of the new flesh!"
#transform 14270 -- daemon prince
#xp -99
#pathboost 7 -- glamour
#pathboost 7 -- glamour
#pathboost 4 -- astral
#pathboost 4 -- astral
#pathboost 8 -- blood
#header 2
#end



----------NATION

#selectnation 169
#name "Slaanesh"
#epithet "Servants of Sensation"
#bloodnation
#sacrificedom
#idealcold 2 -- they come from the polar lands
#color 0.8 0.2 0.7
#era 2
#brief "Slaanesh is one of the four Ruinous Powers, the Gods of Chaos that draw strength from the darkest mortal emotions and drives. Slaanesh is known as the Prince of Pleasure, for their domain is extreme sensation, fear, and lust. The followers of Slaanesh are many and varied, but all seek reward from their patron God."

#descr "Slaanesh is one of the four Ruinous Powers, the Gods of Chaos that draw strength from the darkest mortal emotions and drives. Slaanesh is known as the Prince of Pleasure, for their domain is extreme sensation, fear, and lust. Each of the Ruinous Powers seeks dominion over the realms of mortals and advantage over their siblings, for to them all life is but a game. Greatest in number of the followers of Slaanesh are the Marauders, hardened human warriors from the tribes that surround the Chaos Wastes and are sometimes joined by Ogres or Trolls drawn by the prospect of great reward. Above the Marauders in status are the Chaos Warriors, elite fighters blessed with martial prowess and physical strength, and the Chosen Warriors who show Slaanesh's direct favour. Commanding the followers of Slaanesh are Champions, Exalted Heroes, and Chaos Lords, each of which seeks to some day ascend to immortality in the form of a Daemon Prince, though most on this path will die in battle or displease Slaanesh and be twisted into a Chaos Spawn. Finally the Daemons of Slaanesh are the most direct and horrifying servants of the Dark Prince, for they are the essence of Slaanesh given form and unleashed upon the world."

#summary "Race: Hardened humans with cold resistance, beasts of Chaos. Prefer Cold +2
Military: Elite heavy infantry and cavalry, medium infantry, few ranged weapons. Some troops and commanders can earn promotion, or damnation
Magic: Strong blood, astral, glamour. Minor nature, death, water
Priests: Average. Inquisitors. May blood sacrifice. Dominion decreases unrest in your provinces and increases it in enemy provinces. Daemons weaken outside your dominion"
#flag "Warhammer_Slaanesh/Slaanesh_Flag.tga"
#startsite "Palace of Pleasured Screams"
#templepic 0
#fortera 2 -- normal for MA
#defchaos 2
#moreorder -2 -- so the minimum is 2, you can go to 3 for extra points, you get no extra points from 4 or 5
#defsloth 2
#moreprod -1
#moreheat -1
#disbless "Heroism"

#futuresite 2059 -- Slaanesh Summons
#futuresite 2070 -- Slaanesh Commander Promotions
#futuresite 2077 -- Slaanesh Troop Promotions
#futuresite 2085 -- Slaanesh Spawn
#futuresite 2078 -- Slaanesh Multiheroes
#futuresite 2079 -- Slaanesh Luck-independent Heroes

----------TROOPS

#addrecunit 14201 -- Chaos Warhound (recruitable montag)
#addrecunit 14204 -- Marauder (recruitable montag)
#addrecunit 14203 -- Marauder Hunter (javelins, spear)
#addrecunit 14210 -- Berserker (two axes)

#addrecunit 14234 -- Marauder Horseman (javelin, light lance, shield)
-- Marauder Horseman (axe and throwing axes)
#addrecunit 14235 -- Marauder Horseman (two handed flail)
#addrecunit 14231 -- hellstrider (dominion req 5)

#addrecunit 14320 -- Warrior of Slaanesh (recruitment)
#addrecunit 14214 -- Knight of Slaanesh
--addrecunit 14217 -- Chosen of Slaanesh
--addrecunit 14239 -- Chosen Knight of Slaanesh

#addrecunit 14216 -- Chaos Ogre
#addrecunit 14220 -- chaos troll
--addrecunit 14255 -- Daemonette
--addrecunit 14257 -- Seeker
--addrecunit 14265 -- Fiend
--addrecunit 14663 -- mirror guard

#addforeignunit 14204 -- Marauder (recruitable montag)
#addforeignunit 14203 -- Marauder Hunter (javelins, spear)
#addforeignunit 14234 -- Marauder Horseman (javelin, light lance, shield)

-- Chariot of Slaanesh
-- Gorebeast Chariot
-- Dragon Ogre
-- Giant

----------LEADERS

#addreccom 14236 -- marauder scout
#addreccom 14259 -- Marauder chieftain
#addreccom 14304 -- Marauder Horsemaster
#addreccom 14223 -- Aspiring Champion
--addreccom 14237 -- Exalted Hero maybe cap only? at least 2cp to recruit
#addreccom 14243 -- Marauder Shaman
#addreccom 14228 -- cultist female
#addreccom 14227 -- cultist male
#addreccom 14229 -- sorcerer
--addreccom 14305 -- Azazel
--addreccom 14230 -- sorcerer lord
--addreccom 14260 -- herald of slaanesh -- could be male or female
--addreccom 14252 -- keeper of secrets -- could be male or female
--addreccom 14302 -- styrkaar
--addreccom 14306 -- nkari
--addreccom 14659 -- sigvald

#addforeigncom 14236 -- marauder scout
#addforeigncom 14259 -- Marauder chieftain
#addforeigncom 14304 -- Marauder Horsemaster


-----------GODS

#addgod 109 -- dagon
#addgod 120 -- moloch
#addgod 138 -- gorgon
#addgod 157 -- mother of monsters
#addgod 216 -- red dragon
#addgod 265 -- blue dragon
#addgod 266 -- green dragon
#addgod 269 -- wyrm
#addgod 383 -- prince of death
#addgod 388 -- neter of chaos
#addgod 401 -- bitch queen
#addgod 485 -- great enchantress
#addgod 652 -- void lord
#addgod 653 -- serpent king
#addgod 656 -- fountain of blood
#addgod 657 -- monolith
#addgod 862 -- vampire queen
#addgod 874 -- divine emperor
#addgod 1231 -- drakaina
#addgod 1341 -- devi of darkness
#addgod 1343 -- titan of love
#addgod 1348 -- titan of serpents and medicine
#addgod 1590 -- ageless olm
#addgod 1897 -- feathered serpent
#addgod 1905 -- great sorceress
#addgod 2082 -- son of the fallen
#addgod 2138 -- sphinx
#addgod 2202 -- great siddha
#addgod 2434 -- teteo inan
#addgod 2435 -- annunaki of love and war
#addgod 2447 -- idol of men
#addgod 2449 -- idol of sorcery
#addgod 2461 -- statue of the blood mother
#addgod 2462 -- golden idol
#addgod 2466 -- kamadhenu
#addgod 2550 -- raksharani
#addgod 2608 -- azi
#addgod 2611 -- gannag menog
#addgod 2783 -- drakon
#addgod 2788 -- man eater
#addgod 2791 -- earth serpent
#addgod 2792 -- solar serpent
#addgod 2793 -- serpent of chaos
#addgod 2799 -- wadjet
#addgod 2800 -- ormr
#addgod 2801 -- linormr
#addgod 2849 -- father of monsters
#addgod 3054 -- firstborn of the stars
#addgod 3204 -- the grey ones
#addgod 3396 -- king in yellow
#addgod 3416 -- great archon
#addgod 3710 -- air dragon


-----------HEROES

#multihero1 14267 -- Chaos Lord
#multihero2 14230 -- sorcerer lord
#multihero3 14260 -- herald of slaanesh -- could be male or female

-----------PROVINCE DEFENSE (not yet done)

#defcom1 14259 -- Marauder chieftain
#defcom2 14243 -- Marauder Shaman

#defunit1 14207 -- marauder axe shield
#defunit1b 14203 -- marauder hunter
#defunit2 -1032 -- marauder montag
#defunit2b -1031 -- hound montag
#defmult1 12
#defmult1b 8
#defmult2 10
#defmult2b 15

#wallcom 14203 -- Marauder Hunter (javelins, spear)
#wallunit 14203 -- Marauder Hunter (javelins, spear)
#wallmult 7 -- 1 worse than khorne

#guardcom 14259 -- Marauder chieftain
#guardunit 14208 -- marauder morningstar
#guardmult 7
#guardunit 14213 -- hound
#guardmult 6

#startcom 14259 -- Marauder chieftain
#startunittype1 14207 -- axe and shield marauders
#startunitnbrs1 15
#startunittype2 14203 -- Marauder Hunter (javelins, spear)
#startunitnbrs2 15
#startscout 14236 -- marauder scout
#end



--  Bretonnia

------ ITEMS

-- Battle Reliquae

#selectitem 909
#spr "Warhammer_Bretonnia/Item_Reliquae.tga"
#name "Battle Reliquae"
#descr "The presence of the Battle Reliquae drives the fanatical Pilgrims that bear it into a zealous fury and grants them the blessing of the Lady."
#type 8
#constlevel 11 -- can't be forged
#bers -- holder is autoberserked
#autospell "Divine Blessing"
#autospellrepeat 0
#cursed -- can't be dropped
#nofind
#end

-- Crown of Bretonnia

#selectitem 910
#spr "Warhammer_Bretonnia/Item_Crown.tga"
#name "Crown of Bretonnia"
#descr "The Crown of Bretonnia holds the authority and blessing of the Lady of the Lake and inspires those under the command of its bearer to great deeds. As all Kings of Bretonnia are mighty warriors the Crown is incorporated into a helm suitable for battle."
#type 9 -- crown
#constlevel 11 -- can't be forged
#bless -- always blessed
#cursed -- can't be removed
#nofind -- can't be picked up
#armor 213 -- golden helmet
#autospell "King's Fire"
#autospellrepeat 0
#end

-- Chalice of Potions (Fay Enchantress Item)

#selectitem 1005
#spr "Warhammer_Bretonnia/Item_ChaliceofPotions.tga"
#name "Chalice of Potions"
#descr "A holy artifact kept by the Fay Enchantress. The ambrosius liquid within, offers incredible regenerative powers to those who accompany her. The tide of many a battle has turned on a draught from this cup."
#constlevel 11
#type 8 -- misc
#autospell "Army Regeneration"
#autospellrepeat 0
#nofind
#cursed
#end


-- Duchy of Brionne (Duke of Brionne Item)

#selectitem 1006
#spr "Warhammer_Bretonnia/Item_MarkoftheDuchy.tga"
#name "Duchy of Brionne"
#descr "The Duke of Brionne"
#bers
#constlevel 11
#type 8 -- misc
#autospell "Duke of Brionne"
#autospellrepeat 0
#nofind
#cursed
#end


-- Duchy of Artois (Duke of Artois Item)

#selectitem 1007
#spr "Warhammer_Bretonnia/Item_MarkoftheDuchy.tga"
#name "Duchy of Artois"
#descr "The Duke of Artois"
#constlevel 11
#type 8 -- misc
#autospell "Duke of Artois"
#autospellrepeat 0
#nofind
#cursed
#end



-- Duchy of Parravon (Duke of Parravon Item)

#selectitem 1008
#spr "Warhammer_Bretonnia/Item_MarkoftheDuchy.tga"
#name "Duchy of Parravon"
#descr "The Duke of Parravon"
#constlevel 11
#type 8 -- misc
#autospell "Duke of Parravon"
#autospellrepeat 0
#nofind
#cursed
#end


-- Duchy of Quenelles (Duke of Quenelles Item)

#selectitem 1009
#spr "Warhammer_Bretonnia/Item_MarkoftheDuchy.tga"
#name "Duchy of Quenelles"
#descr "The Duke of Quenelles"
#constlevel 11
#type 8 -- misc
#autospell "Duke of Quenelles"
#autospellrepeat 0
#nofind
#cursed
#end

-- Mark of Quenelles (Duke of Quenelles Item)

#selectitem 1010
#spr "Warhammer_Bretonnia/Item_MarkoftheDuchy.tga"
#name "Mark of Quenelles"
#descr "The Duke of Quenelles"
#constlevel 11
#type 8 -- misc
#autospell "Banishment"
#autospellrepeat 1
#nofind
#cursed
#end


-- Duchy of Gisoreux (Duke of Gisoreux Item)

#selectitem 1011
#spr "Warhammer_Bretonnia/Item_MarkoftheDuchy.tga"
#name "Duchy of Gisoreux"
#descr "The Duke of Gisoreux"
#constlevel 11
#type 8 -- misc
#autospell "Duke of Gisoreux"
#autospellrepeat 1
#nofind
#cursed
#end

-------- WEAPONS --------


-- Green Hoof

#newweapon 1020
#copyweapon 56 -- normal cav hoof, bonus nostr
#name "Green Hoof"
#dmg 15 -- +2
#magic
#end

-- Watery Hoof

#newweapon 2501
#copyweapon 56
#name "Watery Hoof"
#dmg 11
#magic
#end


-- Breton Heavy Lance

#newweapon 1021
#copyweapon 4 -- lance
#name "Breton Heavy Lance"
#dmg 8 -- +2
#end


-- Heroic Lance

#newweapon 1022
#copyweapon 4 -- lance
#name "Heroic Lance"
#dmg 8 -- +2
#magic
#secondaryeffect 1034 -- Slaying
#end


-- Heroic Blade

#newweapon 1023
#copyweapon 11 -- great sword
#name "Heroic Blade"
#def 1 -- -1
#secondaryeffect 1034 -- Slaying
#end

-- Heroic Blade (1h mounted)

#newweapon 1038
#copyweapon 8 -- broad sword
#name "Heroic Blade"
#dmg 10 -- +1 over normal greatsword
#att 1
#def 1 -- -1
#len 2
#secondaryeffect 1034 -- Slaying
#rcost 5
#end


-- Sword of Couronne

#newweapon 1025
#copyweapon 75 -- enchanted sword
#name "Sword of Couronne"
#end


-- Black Sword

#newweapon 1026
#copyweapon 75 -- enchanted sword
#name "Black Sword"
#att 2
#def 1
#len 1
#dmg 10
#secondaryeffectalways 2500 -- Black Blight
#end

-- Black Blight

#newweapon 2500
#name "Black Blight"
#dt_normal
#magic
#nostr
#sacredonly
#armornegating
#dmg 8
#att 2
#def 1
#len 0
#end

-- Axe of Brionne

#newweapon 1028
#copyweapon 728 -- double axe
#name "Axe of Brionne"
#magic
#att 5
#nratt 2
#charge
#len 2
#dmg 12
#secondaryeffectalways 440 -- lesser fear
#end


-- Lance of Artois

#newweapon 1030
#copyweapon 4 -- lance
#name "Lance of Artois"
#dmg 10 -- +4
#att 2 -- +1
#nratt 2 -- +1
#magic
#secondaryeffect 1034 -- Slaying
#end

-- Staff Sling

#newweapon 1031
#copyweapon 22 -- sling
#name "Staff Sling"
#rcost 2
#bonus
#range 35 -- +5
#att 0 -- +2
#dmg 8 -- +3
#end

-- Star of Quenelles

#newweapon 1032
#copyweapon 120 -- enchanted spear
#name "Star of Quenelles"
#att 3
#def 1
#len 1
#blunt
#dmg 10
#secondaryeffectalways 276 --small area holy fire
#end


--- Slaying

#newweapon 1034
#name "Slaying"
#dt_large
#dmg 6 -- therefore 18 + DRN vs prot + DRN vs size 3 and up
#nostr
#att 0
#def 0
#rcost 0
#len 1
#bonus
#slash
#end


-- Pegasus Hoof

#newweapon 1035
#copyweapon 56 -- normal cav hoof
#name "Pegasus Hoof"
#dmg 15 -- +2
#end


-- Sword of Lyonesse

#newweapon 1081
#copyweapon 75 -- enchanted sword
#name "Sword of Lyonesse"
#att 2
#def 2
#dmg 9
#end


-- Bohemond's Dragonbone Mace

#newweapon 1036
#copyweapon 12 -- mace
#name "Dragonbane Mace"
#magic
#dmg 9
#att 2
#def 1
#secondaryeffect 1034 -- slaying
#end


-- Trident of Manaan

#newweapon 1027
#copyweapon 120 -- enchanted spear
#name "Trident of Manaan"
#len 2 -- -1
#dmg 9 -- +2
#end


-- Horn (silvaron)

#newweapon 1033
#copyweapon 120 -- enchanted spear
#name "Horn"
#charge
#dmg 0
#len -1
#att 0
#def 0
#bonus
#end

-- Hoof (Silvaron)

#newweapon 1017
#copyweapon 55 -- hoof
#name "Hoof"
#dmg 0
#att 0
#def 0
#magic
#end

-- Sword of Heroes

#newweapon 1136
#copyweapon 75 -- enchanted sword
#name "Sword of Heroes"
#secondaryeffect 1034 -- slaying
#end

-- weapons for the grail reliquae crew

#newweapon 1116
#copyweapon 8 -- broad sword
#bonus
#end

#newweapon 1128
#copyweapon 28 -- long spear
#bonus
#end


-------- ARMOUR ---------

-- Feudal Shield

#newarmor 339
#copyarmor 2 -- shield
#name "Feudal Shield"
#type 4
#prot 15
#enc 2 -- 1 worse
#def 4 -- same
#end

-- Plate of Smearghus

#newarmor 337
#copyarmor 39 -- blacksteel plate, mapmove pen 2
#name "Plate of Smearghus"
#type 5
#prot 25
#enc 2
#def -1
#rcost 0
#end

-- Lion's Shield

#newarmor 336
#copyarmor 57 -- shield of valour
#name "Lion's Shield"
#def 6
#end


-------- UNITS ----------

-- Generic Human Bretonnian

#newmonster 14397
#spr1 "Warhammer_Bretonnia/Man_at_Arms_Shield_1.tga"
#spr2 "Warhammer_Bretonnia/Man_at_Arms_Shield_2.tga"
#name "Generic Template Human"
#descr "If you're seeing this, something has gone wrong with the mod. Please let Sombre know."
#hp 10
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#gcost 10
#rpcost 1
#rcost 1
#nametype 100
#end


-- Light Man at Arms

#newmonster 13662
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Man_at_Arms_Shield_1.tga"
#spr2 "Warhammer_Bretonnia/Man_at_Arms_Shield_2.tga"
#name "Light Man-at-Arms"
#descr "The life of a peasant in Bretonnia is one of service and duty. Taxes are high and the commonfolk have relatively few rights, toiling constantly to the benefit of the ruling nobility with little hope of social elevation. The nobility see the system as being justified by their reciprocal duty to defend the lands and maintain the honour of justice of the realm, but in reality peasants can expect very little reciprocation for their labour. That said, every member of the commonfolk is taught to idolise knights and the teachings of the Lady explicitly state they shall be rewarded for their fealty. Many families are keen to see their sons recruited as militia by the ruler of their fief, for service as a Man-at-Arms brings some small measure of status. In times of war mobs of poorly trained and equipped Men-at-Arms are used to overwhelm and tire foes or to bog down the enemy while the knights win the day in a single charge."
#weapon 1 --spear
#armor 120 -- Leather Cap
#armor 5 -- Leather Cuirass
#armor 339 -- Feudal Shield
#mor 4
#slave
#att 8
#def 8
#prec 9
#gcost 5
#rpcost 6
#nametype 100
#startage 25
#end


-- Medium Man at Arms

#newmonster 13663
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Man_at_Arms_Shield_3.tga"
#spr2 "Warhammer_Bretonnia/Man_at_Arms_Shield_4.tga"
#name "Man-at-Arms"
#descr "The life of a peasant in Bretonnia is one of service and duty. Taxes are high and the commonfolk have relatively few rights, toiling constantly to the benefit of the ruling nobility with little hope of social elevation. The nobility see the system as being justified by their reciprocal duty to defend the lands and maintain the honour of justice of the realm, but in reality peasants can expect very little reciprocation for their labour. That said, every member of the commonfolk is taught to idolise knights and the teachings of the Lady explicitly state they shall be rewarded for their fealty. Many families are keen to see their sons recruited as militia by the ruler of their fief, for service as a Man-at-Arms brings some small measure of status. In times of war mobs of poorly trained and equipped Men-at-Arms are used to overwhelm and tire foes or to bog down the enemy while the knights win the day in a single charge. Those men who receive slightly better armour than their typical fellows, usually due to an unusually wealthy or compassionate Lord, will have better morale."
#weapon 1 --spear
#armor 20 -- Iron Cap
#armor 6 -- Ring Mail Cuirass
#armor 339 -- Feudal Shield
#mor 5
#slave
#att 8
#def 8
#prec 8
#gcost 6
#rpcost 6
#startage 25
#end


-- Heavy Man at Arms

#newmonster 13664
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Man_at_Arms_Halberd_1.tga"
#spr2 "Warhammer_Bretonnia/Man_at_Arms_Halberd_2.tga"
#name "Heavy Man-at-Arms"
#descr "The life of a peasant in Bretonnia is one of service and duty. Taxes are high and the commonfolk have relatively few rights, toiling constantly to the benefit of the ruling nobility with little hope of social elevation. The nobility see the system as being justified by their reciprocal duty to defend the lands and maintain the honour of justice of the realm, but in reality peasants can expect very little reciprocation for their labour. That said, every member of the commonfolk is taught to idolise knights and the teachings of the Lady explicitly state they shall be rewarded for their fealty. Many families are keen to see their sons recruited as militia by the ruler of their fief, for service as a Man-at-Arms brings some small measure of status. In times of war mobs of poorly trained and equipped Men-at-Arms are used to overwhelm and tire foes or to bog down the enemy while the knights win the day in a single charge. The best equipped Men-at-Arms are those who have been lucky enough to be recruited into the guard of a minor fort or castle and trained by Yeoman soldiers. They are typically only gathered in significant numbers in the armies of powerful Lords, or perhaps even the Dukes."
#weapon 5 --Halberd
#armor 20 -- Iron Cap
#armor 8 -- Chain Mail Cuirass
#castledef 1
#mor 6
#slave
#att 9
#def 9
#prec 8
#gcost 7
#rpcost 8
#end


-- Peasant Bowman

#newmonster 13665
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Peasant_Bowman_1.tga"
#spr2 "Warhammer_Bretonnia/Peasant_Bowman_2.tga"
#name "Peasant Bowman"
#descr "Unlike Men-at-Arms the bow armed peasants often deployed in Bretonnian armies are not a standing militia and are given no equipment or uniform by the knights who muster them. Rather they are sommonfolk who simply seek to earn respite from the hard toil of their day to day lives and perhaps even a little extra coin or food by joining an army. Hunting and games of archery are both popular amongst the commonfolk of Bretonnia and the bow is a common weapon of community defence, as even simple weapons such as spears are forbidden to those who are not Men-at-Arms. Consequently mobs of bowmen are quick and easy to gather should a Lord require them, though they are such a disorganised and foolish rabble that no noble would even try to issue them orders on the battlefield."
#weapon 252 -- club
#weapon 23 -- Shortbow
#armor 120 -- Leather Cap
#armor 5 -- Leather Cuirass
#mor 5
#slave
#att 7
#def 7
#prec 9
#gcost 6
#rpcost 4
#startage 25
#undisciplined
#end


-- Yeoman

#newmonster 13666
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Yeoman_Footed_1.tga"
#spr2 "Warhammer_Bretonnia/Yeoman_Footed_2.tga"
#name "Yeoman"
#descr "Though Bretonnia is quite strictly divided between commoner and nobility, there are different degrees of social status within the masses of the commonfolk, just as there are amongst the aristocracy. The Yeomen are commoners who are permitted to own their homes and trusted to lead other peasants, having been marked out by the ruler of their fief as having served particularly faithfully. One of the most common routes to the status of Yeomen is brave service and experience in the Men-at-Arms, though this comes at considerable risk. Yeoman soldiers are better trained, better equipped, and more dedicated in battle than any Man-at-Arms and while they are by no means respected by the knights, they are trusted to give a good enough account of themselves. They are quite often used to guard forts and castles and are experienced in defending such structures."
#weapon 17 -- Axe
#armor 20 -- Iron Cap
#armor 8 -- Chain Mail Cuirass
#armor 339 -- Feudal Shield
#mor 6
#slave
#gcost 8
#rpcost 8
#startage 30
#castledef 1
#end


-- Yeoman (morningstar)

#newmonster 14076
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Yeoman_Morningstar.tga"
#spr2 "Warhammer_Bretonnia/Yeoman_Morningstar2.tga"
#name "Yeoman"
#descr "Though Bretonnia is quite strictly divided between commoner and nobility, there are different degrees of social status within the masses of the commonfolk, just as there are amongst the aristocracy. The Yeomen are commoners who are permitted to own their homes and trusted to lead other peasants, having been marked out by the ruler of their fief as having served particularly faithfully. One of the most common routes to the status of Yeomen is brave service and experience in the Men-at-Arms, though this comes at considerable risk. Yeoman soldiers are better trained, better equipped, and more dedicated in battle than any Man-at-Arms and while they are by no means respected by the knights, they are trusted to give a good enough account of themselves. They are quite often used to guard forts and castles and are experienced in defending such structures."
#weapon 15 -- Morningstar
#armor 20 -- Iron Cap
#armor 13 -- Chain Mail Hauberk
#armor 339 -- Feudal Shield
#mor 6
#slave
#gcost 8
#rpcost 8
#startage 30
#castledef 1
#end


-- Longbowman

#newmonster 13716
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Yeoman_Longbow.tga"
#spr2 "Warhammer_Bretonnia/Yeoman_Longbow2.tga"
#name "Longbowman"
#descr "As Yeoman infantry are to their unfortunate Man-at-Arms fellows, so are Longbowmen to Peasant Bowmen. Although Knights would never stoop to using such weapons, there is a rich tradition of archery in the lands of Bretonnia that goes beyond the basic needs of hunters and wardens. Longbowmen pick out new recruits to the Yeoman soldiery who and induct them into the use of the Longbow, a much more powerful bow than any a peasant would be allowed for hunting or the like. Longbow units tend to be quite well drilled, as they are given dispensation to practice as a group on a routine basis, setting aside the usual labour required of them. Consequently the position of Yeoman Longbowman is a coveted one, as it represents one of the best lots in life in which a commoner can find himself."
#weapon 252 -- Club
#weapon 24 -- long bow
#armor 20 -- Iron Cap
#armor 10 -- Leather Hauberk
#str 11
#mor 6
#slave
#att 9
#def 9
#prec 11
#gcost 9
#rpcost 11
#startage 30
#end


-- Mounted Yeoman

#newmonster 13667
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Yeoman_Mounted_1.tga"
#spr2 "Warhammer_Bretonnia/Yeoman_Mounted_2.tga"
#name "Mounted Yeoman"
#descr "While no commoner would ever be permitted to ride the purebreed Desteriers favoured by the nobility, it is not unheard of for Bretonnian Lords to field contingents of Yeoman Cavalry mounted on lesser breeds. These lighter, weaker horses are swift enough as they need not carry a heavily armed and armoured noble and can be useful for scouting, flanking, or even contending with foes scattered by the main charge of the Knights. The riders are armed with spears and javelins suited to their task and given some very basic armour."
#weapon 1 --Spear
#weapon 21 --Javelin
#armor 20 -- Iron Cap
#armor 10 -- Leather Hauberk
#armor 2 --Shield
#mor 6
#slave
#gcost 9
#rpcost 8
#poorleader
#startage 30
#skilledrider 1
#mountmnr 14400 -- riding horse
#unmountedspr1 "Warhammer_Bretonnia/Yeoman_Mounted_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Yeoman_Mounted_Unmounted2.tga"
#end

#newmonster 14400
#copystats 3513 -- riding horse
#spr1 "Warhammer_Bretonnia/Yeoman_Mounted_Mount.tga"
#spr2 "Warhammer_Bretonnia/Yeoman_Mounted_Mount2.tga"
#armor 251 -- leather barding - prot 5
#gcost 9 -- reduced price
#end


-- Knight Errant

#newmonster 13668
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Knight_Errant_Mounted_1.tga"
#spr2 "Warhammer_Bretonnia/Knight_Errant_Mounted_2.tga"
#name "Knight Errant"
#descr "All noble sons of Bretonnia are committed to the path of knighthood from the moment they are born, but while their noble blood ensures them a place amongst the aristocracy, a young noble will not be honoured until he has proven himself. Knights Errant are the youngest Knights with the most to prove, known for their brash arrogance, thirst for glory, and impetuous nature. They rarely listen to orders and indeed it is rather expected that they should not, for no knight should stand to be without honour and the surest way to earn it is in a headlong charge into the foe. Some Lords see the reckless charge of the Errants to be a necessary way of pruning the ranks, others simply a suitable outlet for the insecurity and enthusiasm of youth, but none would deny a young knight his chance at destiny. Bretonnian knights are provided with fine arms and armour by their family holdings, many passed down for generations, and as such put little burden for precious resources on the nation. They ride purebreed Destriers that are amongst the finest steeds in the world and selectively bred to easily support the weight of an armoured rider."
#weapon 1021 -- Breton Heavy Lance
#weapon 8 -- Broadsword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#hp 11 -- fit
#mor 13 -- vow + impetuous + 1 extra to make up for undisciplined
#att 11 -- impetuous
#gcost 10 -- 35 -- cheap but not that cheap
#rpcost 16
#ressize 2
#nametype 197 -- breton noble
#startage 20
#undisciplined
#skilledrider 2
#mountmnr 14399 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Knight_Errant_Mounted_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Knight_Errant_Mounted_Unmounted2.tga"
#end

#newmonster 14399
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Knight_Errant_Mounted_Mount.tga"
#spr2 "Warhammer_Bretonnia/Knight_Errant_Mounted_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 26
#gcost 25
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#bravemount 50
#ressize 2
#end


-- Foot Knight Errant

#newmonster 13669
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Knight_Errant_Footed_1.tga"
#spr2 "Warhammer_Bretonnia/Knight_Errant_Footed_2.tga"
#name "Foot Knight Errant"
#descr "It is unusual for a Bretonnian knight to take the field without a steed, but Destriers are highly expensive and the holdings of some noble families simply cannot afford one for every son, and no knight of Bretonnia would consider riding a lesser horse. Lacking a steed is particularly hard on impetuous young Knights Errant because it greatly curtails their ability to seek glory, and thus honour, in a headlong charge into battle. That said it is impressed on every knight that they are no lesser than their mounted fellows for fighting on foot and can and must seek their destiny in battle, so Knights Errant remain just as impetuous and uncontrollable even when fighting on foot. Bretonnian knights are provided with fine arms and armour by their family holdings, many passed down for generations, and as such put little burden for precious resources on the nation."
#weapon 8 --Broadsword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#hp 11
#mor 13
#att 11
#gcost 12
#rpcost 16
#mapmove 16
#ressize 2
#nametype 197 
#startage 20
#undisciplined
#end


-- Knight of the Realm

#newmonster 13670
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Knight_of_the_Realm_Mounted_1.tga"
#spr2 "Warhammer_Bretonnia/Knight_of_the_Realm_Mounted_2.tga"
#name "Knight of the Realm"
#descr "Once a knight has proven himself honourable and worthy he is confirmed as a Knight of the Realm. These knights make up the bulk of the nobility and command a great deal of respect both for their station and the deeds they must have performed to reach it. They are granted a small fief from within their family's holdings, or, in rare cases, from land personally controlled by a Lord or Duke. Just as the peasants living in the fief then owe their fealty to the knight, the knight owes his to his Lord. It is a common saying that the Knights of the Realm are the shield of Bretonnia, but in battle they act more like its armoured fist, punching directly through the enemy line and shattering their forces. Knights of the Realm are expected to personally deal with lesser threats to their fief and are well practiced at rooting out hidden foes or troublemakers. Bretonnian knights are provided with fine arms and armour by their family holdings, many passed down for generations, and as such put little burden for precious resources on the nation. They ride purebreed Destriers that are amongst the finest steeds in the world and selectively bred to easily support the weight of an armoured rider."
#str 11
#weapon 1021 -- Breton Heavy Lance
#weapon 8 --Broadsword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#patrolbonus 2
#hp 12
#mor 13 -- LD8 + vow
#mr 11
#att 11
#def 11
#gcost 16 -- 38
#rpcost 20
#ressize 2
#nametype 197 
#startage 30
#skilledrider 2
#mountmnr 14398 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Knight_of_the_Realm_Mounted_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Knight_of_the_Realm_Mounted_Unmounted2.tga"
#end

#newmonster 14398
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Knight_of_the_Realm_Mounted_Mount.tga"
#spr2 "Warhammer_Bretonnia/Knight_of_the_Realm_Mounted_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 32 -- +2
#bravemount 50
#ressize 2
#end


-- Foot Knight of the Realm

#newmonster 13671
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Knight_of_the_Realm_Footed_1.tga"
#spr2 "Warhammer_Bretonnia/Knight_of_the_Realm_Footed_2.tga"
#name "Foot Knight of the Realm"
#descr "It is unusual for a Bretonnian knight to take the field without a steed, but Destriers are highly expensive and the holdings of some noble families simply cannot afford one for every son, and no knight of Bretonnia would consider riding a lesser horse. Even Knights of the Realm, who command their own fief, can find themselves simply lacking the funds to ride into battle on a fitting mount, though this is less of a source of frustration to them than to their Errant fellows. It is also the case, of course, that none would ever impune the already proven honour of a Knight of the Realm by suggesting their lack of mount makes them any lesser the knight, for even the Grail Companions of old were known to fight on foot on occasion. Bretonnian knights are provided with fine arms and armour by their family holdings, many passed down for generations, and as such put little burden for precious resources on the nation. "
#str 11
#weapon 8 --Broadsword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#castledef 1
#patrolbonus 1
#hp 12
#mor 13
#mr 11
#att 11
#def 11
#gcost 15
#rpcost 20
#ressize 2
#nametype 197 
#startage 30
#end


-- Questing Knight

#newmonster 13684
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Questing_Knight_3.tga"
#spr2 "Warhammer_Bretonnia/Questing_Knight_4.tga"
#name "Questing Knight"
#descr "The greatest honour that any noble of Bretonnia can receive is to drink from the Grail and receive the blessing of the Lady. This honour calls out to a great many nobles and to resist the call, once it comes, is to invite an existence tortured by doubt and regret, to forever more ask 'what if?'. No matter how wealthy, influential, or powerful the noble there is only one way to receive a blessing from the Grail and that is to take the Questing Vow, leaving behind both lands and lance. Questing Knights roam the lands with very few possessions seeking out danger and adventure to prove themselves worthy of the Grail. Their quests are typically long and dangerous, often ending in failure and as nearly likely to end in the death of the noble. Questing Knights are well known for their thirst for glory and often seek to fell the largest beasts on the battlefield with great two handed swords designed explicitly to cut down large foes. Having given up the trappings of nobility their upkeep is less than that required by a Knight of the Realm."
#str 12
#weapon 1038 -- Heroic Blade
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#hp 13
#mor 14
#mr 13
#att 12 -- questing knights get +1
#def 11
#gcost 0
#ressize 2
#nametype 197 
#startage 25
#skilledrider 2
#mountmnr 14401 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Questing_Knight_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Questing_Knight_Unmounted2.tga"
#end

#newmonster 14401
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Questing_Knight_Mount.tga"
#spr2 "Warhammer_Bretonnia/Questing_Knight_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 32 -- +2
#bravemount 50
#ressize 2
#end


-- Pegasus Knight

#newmonster 13672
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Pegasus_Knight_1.tga"
#spr2 "Warhammer_Bretonnia/Pegasus_Knight_2.tga"
#name "Pegasus Knight"
#descr "Most Pegasus Knights hail from the region of Parravon on the slopes of the Grey Mountains where their noble steeds were first found, but there are small groups of them across the nation of Bretonnia. Their numbers are made of exclusively of Knights of the Realm, usually those from with particularly influential or wealthy fiefs, as a battle trained pegasus is a highly expensive and prestigious mount. That said, a pegasus is no mere status symbol, for they are stronger and faster than even the finest Destrier and their ability to take flight with a knight upon their back makes them incredibly useful in war. Bretonnian knights are provided with fine arms and armour by their family holdings, many passed down for generations, and as such put little burden for precious resources on the nation. Should the Pegasus Knight be slain in battle his loyal mount will fight on to avenge him before flying back to its ancestral mountain home."
#str 11
#weapon 1021 -- Breton Heavy Lance
#weapon 8 --Broadsword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#hp 12
#mor 13
#mr 12
#att 11
#def 11
#gcost 15
#rpcost 20
#reclimit 7
#goodleader
#ressize 2
#nametype 197
#startage 30
#mountainsurvival
#skilledrider 2
#mountmnr 13674 -- Pegasus
#unmountedspr1 "Warhammer_Bretonnia/Pegasus_Knight_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Pegasus_Knight_Unmounted2.tga"
#end


-- Pegasus

#newmonster 13674
#spr1 "Warhammer_Bretonnia/Pegasus_Heraldry_1.tga"
#spr2 "Warhammer_Bretonnia/Pegasus_Heraldry_2.tga"
#name "Bretonnian Pegasus"
#descr "Bretonnian Pegasi are known for their loyalty to their masters and will fight on to avenge them should they be slain, though they will depart after the battle."
#str 15
#prot 4
#weapon 55 -- Hoof
#animal
#flying
#armor 253 -- cataphract barding (prot 13)
#rpcost 34
#hp 20
#mor 11
#mr 11
#att 10
#def 10
#ap 24
#prec 10
#enc 2
#gcost 45
#rcost 1
#noleader
#mapmove 28
#size 6
--quadruped
#mountainsurvival
#animal
#maxage 200
#bravemount 100
#ressize 2
#end


-- Grail Knight

#newmonster 13673
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Grail_Knight_1.tga"
#spr2 "Warhammer_Bretonnia/Grail_Knight_2.tga"
#name "Grail Knight"
#descr "Only when a Questing Knight has proven his worth beyond doubt does he receive a vision of the Lady of the Lake and the chance to drink from the Grail. Few indeed reach this pinnacle of virtue and only those with a pure an unblemished soul survive the experience, with those with even the slightest blemish to their honour are merely granted peaceful death. From that moment on the knight takes up a new vow, to serve the Lady and the Grail, and becomes something more than a mortal man. Grail Knights are sworn to defend the sacred places of the Lady, be they chapels, lakes, or simple woodland groves, and they will only leave these sites to take up war when the wider realm is truly threatened. To the commonfolk of Bretonnia the Grail Knights form a pantheon of living deities, an impossibly perfect ideal which uplifts and gives purpose to their life simply by existing, and long after a Grail Knight falls in battle his name will be remembered by the peasantry and repeated like a prayer against evil. Bretonnian knights are provided with fine arms and armour by their family holdings, many passed down for generations, and as such put little burden for precious resources on the nation. They ride purebreed Destriers that are amongst the finest steeds in the world and selectively bred to easily support the weight of an armoured rider."
#str 13
#weapon 1022 -- Heroic Lance
#weapon 75 -- enchanted sword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#holy
#magicbeing
#hp 14
#mor 18
#mr 14
#att 12 -- WS5 I5, but I'm also giving them magical weapons
#def 12
#prec 10
#gcost 40
#ressize 2
#rpcost 26
#goodleader
#nametype 197 
#startage 40
#maxage 300
#woundfend 1
#skilledrider 3
#mountmnr 14421 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Grail_Knight_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Grail_Knight_Unmounted2.tga"
#end

#newmonster 14421
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Grail_Knight_Mount.tga"
#spr2 "Warhammer_Bretonnia/Grail_Knight_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 32 -- +2
#bravemount 50
#holy
#ressize 2
#end


-- Pilgrim

#newmonster 13686
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Bretonnian_Pilgrim_1.tga"
#spr2 "Warhammer_Bretonnia/Bretonnian_Pilgrim_2.tga"
#name "Pilgrim"
#descr "The commonfolk of Bretonnia have very few rights and many of the circumstances of their lives are dictated by what they are forbidden to do, as these acitvities are reserved as privileges of the nobility. Peasants may not wear bright colours, live in houses with more than two floors, or even travel freely beyond their village without explicit permission from the ruler of their fief. The exception to the law of travel comes in the case of a pilgrimage, as none can be denied the right to travel to a chapel or other sacred place of the Lady to seek her blessing. As such pilgrimages are popular even with less religious sorts, although almost inevitably many of those who engage in them find their faith greatly increased by both their company and the holy sites they witness. Occasionally pilgrims will be so taken with religious fervour that they seek the chance to take vengeance on the enemies of the Lady. They make poor fighters and because of the strict rules around pilgrimage are armed only with walking sticks and a handful of stones, but their fanaticism lends them courage in battle, though making them rather difficult to control. Pilgrims will gather at temples, particularly those within strong dominion, and await an army to join."
#slave
#weapon 7 -- Quarterstaff
#weapon 360 -- Sticks and Stones
#armor 158 -- Robes
#mor 9
#mr 11
#att 7
#def 7
#prec 9
#gcost 7
#addupkeep -6
#rpcost 6
#mapmove 18
#nametype 100 
#startage 30
#undisciplined
#holy
#end


-- Battle Pilgrim

#newmonster 13685
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Bretonnian_Battle_Pilgrim_1.tga"
#spr2 "Warhammer_Bretonnia/Bretonnian_Battle_Pilgrim_2.tga"
#name "Battle Pilgrim"
#descr "Battle Pilgrims are fanatically devout commoners who interpret the teachings of the Lady so fervently that they have made the sacrifice of abandoning their sacred duty as peasants to pursue calling of fighting the enemies of Bretonnia. They are aware that by doing so they risk the deserved wrath of the nobility, ostracision from their fellow commoners, and gruesome death on the field of battle, but so strong is their hatred of those who would dare stand against the Lady and harm the defenders of Bretonnia that they can see no other path. Some Battle Pilgrims were once pilgrims who found a taste for war, others are the survivors of villages destroyed by marauders, and others still are those who saw knights heroically fighting to defend the realm and were overcome by religious rapture. These men are usually the veterans of many battles, for those who are unworthy are quickly slain, and make surprisingly effective infantry. The knights of Bretonnia regard Battle Pilgrims with a mixture of scorn and revulsion, but it is clear that the Lady has some plan for them, for her advocates not only tolerate them to exist but are known to bless them as sacred warriors."
#str 11
#weapon 8 -- Broadsword
#armor 20 -- Iron Cap
#armor 32 -- Rusty Ring Mail Hauberk
#armor 2 --Shield
#hp 11
#mor 10
#mr 11
#ap 12
#gcost 15
#rpcost 8
#holy
#mapmove 16
#startage 30
#undisciplined
#slave
#end


------- COMMANDERS

-- Yeoman Outrider

#newmonster 13675
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Yeoman_Mounted_1.tga"
#spr2 "Warhammer_Bretonnia/Yeoman_Mounted_2.tga"
#name "Yeoman Outrider"
#descr "While no commoner would ever be permitted to ride the purebreed Desteriers favoured by the nobility, it is not unheard of for Bretonnian Lords to field contingents of Yeoman Cavalry mounted on lesser breeds. These lighter, weaker horses are swift enough as they need not carry a heavily armed and armoured noble and can be useful for scouting, flanking, or even contending with foes scattered by the main charge of the Knights. The riders are armed with spears and javelins suited to their task and given some very basic armour. Particularly trustworthy Yeoman riders with a talent for travelling undetected are used as scouts by the armies of Bretonnia."
#weapon 1 --Spear
#weapon 21 --Javelin
#armor 20 -- Iron Cap
#armor 10 -- Leather Hauberk
#armor 2 --Shield
#stealthy 10
#forestsurvival
#mor 9
#gcost 25 -- 35
#rpcost 1
#poorleader
#ressize 2
#nametype 102 
#startage 30
#mountmnr 14400
#unmountedspr1 "Warhammer_Bretonnia/Yeoman_Mounted_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Yeoman_Mounted_Unmounted2.tga"
#end


-- Courtier

#newmonster 13676
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Courtier_1.tga"
#spr2 "Warhammer_Bretonnia/Courtier_2.tga"
#name "Courtier"
#descr "While all Bretonnian nobles are knights and traditionally seek glory as a youth amongst the Knights Errant, there have always been those who either avoid ever taking to battle, or get their participation in a perfunctory battle out of the way quickly and immediately turn to using their station and influence in the realm of court. While knights are supposed to seek glory and demonstrate valour, they are also expected to be men of eloquence and refinement in high social circles, and it is in this realm that the Courtiers hold the most sway. These nobles are disdained by their martial brethren but feared for their influence and skill in politicking and talent for inflicting public humiliation on any noble who tries to shame them for their lack of battle honours. Truthfully while the King and his Dukes despise these expert Courtiers they also realise their value, as they make excellent spies."
#weapon 8 -- Broadsword
#armor 9 -- plate cuirass
#stealthy 10
#spy
#att 11
#def 11
#gcost 85
#rpcost 2
#poorleader
#nametype 102
#startage 30
#end


-- Paladin

#newmonster 13697
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Paladin.tga"
#spr2 "Warhammer_Bretonnia/Paladin2.tga"
#name "Paladin"
#descr "Paladins are knights of great renown and valour who have risen above their fellow Knights of the Realm to receive recognition from a Duke or even the King himself. They are freed from the obligation of administering to and defending a fief and instead given specific missions by their benefactor and considerable rewards for their service. Paladins are particularly skilled and nearly rival the mighty Lords of Bretonnia in battle but they are typically not expected to lead large forces and will rarely ever command commoners. As with other knights they provide their own arms and armour and ride upon purebreed Destriers that are easily able to convey a heavily armoured rider."
#str 12
#weapon 1021 -- Breton Heavy Lance
#weapon 8 --Broadsword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#hp 18
#prot 3
#mor 14
#mr 13
#att 12
#def 12
#gcost 45
#rpcost 1
#nametype 197
#startage 30
#ressize 2
#okleader
--
#skilledrider 2
#mountmnr 14420 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Paladin_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Paladin_Unmounted2.tga"
#end

#newmonster 14420
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Paladin_Mount.tga"
#spr2 "Warhammer_Bretonnia/Paladin_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#ressize 2
#end


-- Questing Paladin

#newmonster 13687
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Questing_Paladin.tga"
#spr2 "Warhammer_Bretonnia/Questing_Paladin2.tga"
#name "Questing Paladin"
#descr "Paladins have no fief to defend and administer but they still have a great many duties and are often given very specific missions by their Lords. Still, they are knights and as such have an unassailable right to set aside their lance and pursue their destiny by taking the Questing Vow. Questing Paladins are amongst the greatest warriors in the nation, capable of doing battle with both bands of vicious raiders and terrifying beasts, fearlessly charging into the thick of battle with their massive two handed blades. Questing Knights are expected to live on the road and forego most of the luxuries of nobility and as such require reduced upkeep."
#str 12
#weapon 1038 -- Heroic Blade
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#hp 19
#prot 3
#mor 14
#mr 14
#att 13
#def 12
#gcost 20
#rpcost 1
#nametype 197
#startage 30
#ressize 2
#okleader
#command -35
--
#skilledrider 2
#mountmnr 14402 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Questing_Paladin_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Questing_Paladin_Unmounted2.tga"
#end

#newmonster 14402
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Questing_Paladin_Mount.tga"
#spr2 "Warhammer_Bretonnia/Questing_Paladin_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#ressize 2
#end


-- Grail Paladin

#newmonster 13677
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Grail_Paladin.tga"
#spr2 "Warhammer_Bretonnia/Grail_Paladin2.tga"
#name "Grail Paladin"
#descr "Those Paladins who set aside their duties and take the Questing Vow usually end up either abandoning their Quest and retiring back to their former status, or more likely losing their lives in heroic battle against some violent evil, be it mundane or supernatural. Very few ever find the Grail and even then some do not survive drinking from it, but those that do are known as Grail Paladins and are amongst the greatest warriors mankind has ever produced. Like Grail Knights they swear the Grail Oath to service of the Lady rather than any Lord, Duke, or even the King, but in times of war when the nation is threatened they make for powerful assets in the armies of Bretonnia."
#str 13
#weapon 1021 -- Breton Heavy Lance
#weapon 75 -- Enchanted Sword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#hp 21 (+2)
#prot 3
#mor 18
#mr 16 (+3)
#att 13 (+1)
#def 13 (+1)
#holy
#magicbeing
#gcost 110
#rpcost 1
#nametype 197
#maxage 300
#ressize 2
#okleader
#poormagicleader
#inspirational 1
--
#woundfend 1
#skilledrider 2
#mountmnr 14404 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Grail_Paladin_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Grail_Paladin_Unmounted2.tga"
#end

#newmonster 14404
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Grail_Paladin_Mount.tga"
#spr2 "Warhammer_Bretonnia/Grail_Paladin_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#holy
#ressize 2
#end


-- Lord

#newmonster 13696
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Bretonnian_Lord_1.tga"
#spr2 "Warhammer_Bretonnia/Bretonnian_Lord_2.tga"
#name "Lord"
#descr "Lords are nobles who hold a high station in the social hierarchy of Bretonnia and as such command the fealty of many Knights of the Realm. While each knight is expected to tend to his own fief and Lords are no exception their personal fiefs are usually much larger and they also have the authority to oversee the fiefs of all the Knights of the Realm sworn to them. Because of the Bretonnian emphasis on martial greatness Lords tend to be superb warriors in their own right, often having reached their higher status through glorious deeds on the battlefield. They owe their fealty to Dukes, who are to Lords what Lords are to Knights of the Realm, though some Lords are sufficiently powerful that even their Duke would have to present their wishes as requests rather than commands. As with other knights they provide their own arms and armour and ride upon purebreed Destriers that are easily able to convey a heavily armoured rider."
#str 13
#weapon 1021 -- Breton Heavy Lance
#weapon 8 --Broadsword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#hp 27
#mor 15
#mr 14
#att 13
#def 13
#gcost 110
#rpcost 1
#goodleader
#ressize 2
#nametype 197 
#startage 30
#taskmaster 1
--
#prot 3
#skilledrider 3
#mountmnr 14405 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Bretonnian_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Bretonnian_Lord_Unmounted2.tga"
#end

#newmonster 14405
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Bretonnian_Lord_Mount.tga"
#spr2 "Warhammer_Bretonnia/Bretonnian_Lord_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#ressize 2
#end


-- Questing Lord

#newmonster 13679
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Questing_Lord.tga"
#spr2 "Warhammer_Bretonnia/Questing_Lord2.tga"
#name "Questing Lord"
#descr "All Bretonnian Lords bear a greater responsibility than the Knights of the Realm who swear fealty to them, for their holdings consist of many fiefs and the lives of other nobles, not just commonfolk, are in their hands. Even so they are knights themselves and no-one, not even the King, can deny a knight his destiny. So it is that some Lords, even rulers of many decades, may receive a vision from the Lady, set aside their duties, and take the Questing Vow. Questing Knights are expected to live on the road and forego most of the luxuries of nobility and as such require reduced upkeep."
#str 13
#weapon 1038 -- Heroic Blade
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#hp 30
#prot 3
#mor 16
#mr 15
#att 14
#def 13
#gcost 35
#okleader
#command -30
#taskmaster 1
#nametype 197
#startage 30
#inspirational 1
--
#skilledrider 3
#mountmnr 14403 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Questing_Lord_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Questing_Lord_Unmounted2.tga"
#end

#newmonster 14403
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Questing_Lord_Mount.tga"
#spr2 "Warhammer_Bretonnia/Questing_Lord_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#ressize 2
#end


-- Grail Lord

#newmonster 13698
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Bretonnian_Duke_1.tga"
#spr2 "Warhammer_Bretonnia/Bretonnian_Duke_2.tga"
#name "Grail Lord"
#descr "Though it is rare, some Lords take the Questing Vow, set aside their titles and holdings, pursue and eventually find the Grail and become a Grail Knight, then return to once more rule over their former holdings. Most who drink from the Grail and survive go on to defend a sacred site and only venture beyond its borders when their realm direly needs their aid, but Grail Lords continue to rule over mortal men, seeing this as the best way to serve the Lady and protect the places important to her. Grail Lords are amongst the greatest warriors of mankind, equalled in might only by servants of the Chaos gods. As with other knights they provide their own arms and armour and ride upon purebreed Destriers that are easily able to convey a heavily armoured rider."
#str 14
#weapon 1022 -- Heroic Lance
#weapon 75 -- Enchanted Sword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#holy
#magicbeing
#awe 1
#hp 32
#prot 3
#mor 18
#mr 16
#att 14
#def 14
#gcost 250
#rpcost 2
#inspirational 2
#goodleader
#okmagicleader
#ressize 2
#nametype 197
#startage 45
#maxage 300
--
#woundfend 1
#skilledrider 3
#mountmnr 14406 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Bretonnian_Duke_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Bretonnian_Duke_Unmounted2.tga"
#end

#newmonster 14406
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Bretonnian_Duke_Mount.tga"
#spr2 "Warhammer_Bretonnia/Bretonnian_Duke_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#holy
#ressize 2
#end


-- Grail Lord on Hippogryph (reviewed)

#newmonster 13693
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Grail_Lord_Hippogryph.tga"
#spr2 "Warhammer_Bretonnia/Grail_Lord_Hippogryph2.tga"
#name "Hippogryph Lord"
#descr "Hippogryph Lords are Grail Lords who have managed to make a mount of one of the notoriously territorial and savage Hippogryphs of the Grey Mountains. This is no easy feat, for even a Grail Knight will find their skill, determination, and courage put to the test by such a foul tempered and deadly beast. Hippogryphs are winged hybrid creatures very similar to Griffons but have the hindquarters of a horse rather than a predatory cat. They make truly excellent mounts as they are both terrifying and powerful, capable of hurtling down from above to tear through entire enemy regiments with ease."
#weapon 1022 -- Heroic Lance
#weapon 75 -- Enchanted Sword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#holy
#magicbeing
#awe 1
#str 14
#hp 32
#prot 3
#mor 18
#mr 16
#att 14
#def 14
#gcost 0
#goodleader
#okmagicleader
#maxage 300
#inspirational 2
--
#woundfend 1
#skilledrider 2
#mountmnr 13694 -- Hippogryph
#unmountedspr1 "Warhammer_Bretonnia/Grail_Lord_Hippogryph_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Grail_Lord_Hippogryph_Unmounted2.tga"
#end


-- Hippogryph

#newmonster 13694
#spr1 "Warhammer_Bretonnia/Hippogryph.tga"
#spr2 "Warhammer_Bretonnia/Hippogryph2.tga"
#name "Hippogryph"
#descr "Should its rider be slain this Hippogryph will fight on but after the battle will return to its home in the Grey Mountains."
#str 20
#prot 6
#weapon 20 -- Bite
#weapon 33 -- claws/talons
#animal
#mountainsurvival
--quadruped
#armor 254 -- plate barding
#fear 5 -- terror
#flying
#hp 55 -- W4 T5
#mor 14 -- L8, terror
#mr 13 -- same as vanilla gryphon
#att 11 -- WS4 I4
#def 11 -- WS4 I4
#ap 20 -- horselike
#prec 12 -- bird eyes
#enc 3
#gcost 0
#mapmove 28 -- same as vanilla gryphon
#size 8
#maxage 200
#bravemount 100
#ressize 4
#end



-- Lord on Pegasus

#newmonster 13680
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Bretonnian_Hero.tga"
#spr2 "Warhammer_Bretonnia/Bretonnian_Hero2.tga"
#name "Pegasus Lord"
#descr "Only the wealthiest or most influential Lords tend to have access to a Royal Pegasus, a flying mount as superior to a normal Pegasus as a Bretonnian Destrier is to a lesser breed of horse. A Royal Pegasus is stronger, more loyal, and more noble in character than its common counterpart and mounted atop its back a Pegasus Lord is a truly mighty presence on the battlefield. As with other knights they provide their own arms and armour and their steeds are easily able to convey a heavily armoured rider."
#str 13
#weapon 1021 -- Breton Heavy Lance
#weapon 8 -- broadsword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#mountainsurvival
#hp 30
#prot 3
#mor 15
#mr 15 -- (+1 for peg)
#att 13
#def 13
#gcost 190 -- 250
#rpcost 2
#goodleader
#taskmaster 1
#nametype 197
#startage 35
#ressize 2
--
#skilledrider 2
#mountmnr 13681 -- royal pegasus
#unmountedspr1 "Warhammer_Bretonnia/Bretonnian_Hero_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Bretonnian_Hero_Unmounted2.tga"
#end


-- Royal Pegasus

#newmonster 13681
#spr1 "Warhammer_Bretonnia/Royal_Pegasus_1.tga"
#spr2 "Warhammer_Bretonnia/Royal_Pegasus_2.tga"
#name "Bretonnian Noble Pegasus"
#descr "Bretonnian Pegasi are known for their loyalty to their masters and will fight on to avenge them. Royal Pegasi are a superior breed, both more loyal and powerful, though they too will depart to their mountain homeland once the battle is over."
#str 17 -- +2
#prot 5 -- +2
#weapon 55 -- Hoof
#weapon 55 -- Hoof
#animal
#flying
#gcost 60
#armor 253 -- cataphract barding (prot 13)
#hp 30 -- +10
#mor 13 -- +2
#mr 12 -- +1
#att 11 -- +1
#def 11 -- +1
#ap 24
#enc 2
#mapmove 28
#size 6
#nametype 100 
--quadruped
#maxage 250
#bravemount 100
#ressize 2
#end


-- Entreat Duke

#newmonster 13678
#spr1 "Warhammer_Bretonnia/Duke_Icon.tga"
#name "Entreat Duke"
#descr "The Dukes of Bretonnia are the rulers of the twelve great Dukedoms that make up that nation, each divided into holdings ruled over by Lords which are in turn divided into fiefs ruled by Knights of the Realm. Just as the knights swear fealty to their Lord, the Lords swear fealty to their Duke, and the Dukes swear fealty to the King, the one among them picked to rule over all of Bretonnia at the behest of the Lady. Each of the Dukes is a mighty hero, having ascended to their position not only by birthright but by countless great and honourable deeds, and many of them have successfully completed the Questing Vow and become Grail Lords, taking back their title to protect all of the sacred sites within their Dukedom. By honouring their acheivements with a tournament, great hunt, feast day, or other ritual, one of the Dukes will be entreated to join your cause along with some troops.

[When you hire this commander you will receive, at the end of the turn, a randomly selected one of 12 unique Dukes which vary in power but are all stronger than a Lord commander. You will also receive assorted troops depending on which Duke you get. If you have already had all 12 Dukes, you'll get a Grail Lord and some troops instead. This can only happen if you still control the province in which the Duke was recruited, so if you are put under siege the Entreat Duke icon will remain until the province is back under your control, at which point you will get a Duke and troops as normal]"
#hp 40
#size 9
#mor 50
#mr 12
#enc 0
#str 1
#att 1
#def 1
#prec 1
#mapmove 0
#immobile
#ap 2
#gcost 1000
#addupkeep -1000
#rpcost 4
#rcost 40
#maxage 4000
#startage 1
#noleader
#inanimate
#neednoteat
#poisonres 75
#blind
#nametype 188
#itemslots 0
#unique
#fixedname "Entreat Duke"
#end


------------- DUKES

-- Duke Taubert of L'Anguille

#newmonster 13699
#copystats 13696 -- Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Lanquille_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Lanquille_2.tga"
#name "Duke of L'Anquille"
#fixedname "Taubert"
#descr "Taubert is the Duke of L'Anguille, a small Dukedom that is best known for its thriving sea ports and plentiful crops. Dukes of L'Anquille follow the Virtue of the Penitent after Duchess Theralind, the wife of the first Duke of L'Anguille, was transfigured into a monstrosity by a vile witch. The Virtue grants them superb resistance against hostile magic, though they are naturally wary of using magical items themselves. Tabuert was once an enthusiastic sailor but some years ago he abruptly stopped and has since barely gone near the ocean. Some say he sighted poor Theralind at sea and was heartbroken to see her fate."
#shockres 10
#poisonres 10
#fireres 10
#coldres 10
#supplybonus 30
#noriverpass
#mr 18
#att 14 (WS7)
#def 14
#expertleader
#taskmaster 0
#inspirational 1
#itemslots 204806 -- normal, no misc, no bow
--all Dukes have the following
#gcost 0
#rcost 0
#gold 75
#insane 10
#mountmnr 14416 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Lanquille_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Lanquille_Unmounted2.tga"
#end

#newmonster 14416
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Lanquille_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Lanquille_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#end


-- Duke Hagen of Gisoreux (medium)

#newmonster 13700
#copystats 13698 -- Grail Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Gisoreux_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Gisoreux_2.tga"
#name "Duke of Gisoreux"
#fixedname "Hagen"
#descr "Hagen is the Duke of Gisoreux, a Dukedom known for its rich history of diverse geography, customs, and cultures. Dukes of Gisoreux follow the Virtue of Knightly Temper which allows them to tirelessly strike with blinding speed. Hagen is a known as a particularly strict ruler who takes a man's word as a Vow and as such has a reputation for particularly harsh justice to those who shirk their duties or break the law. He is known for his personal loyalty to King Louen, though having taken the Grail Vow his ultimate service will always be to the Lady."
#clearweapons
#cleararmor
#incunrest -20
#weapon 1021 -- Breton Heavy Lance
#weapon 106 -- sword of swiftness
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#reinvigoration 2
#inspirational 1
#itemslots 991238 --full, no bow
#forestsurvival
#mountainsurvival
#expertleader
--all Dukes have the following
#gcost 0
#rcost 0
#gold 50
#insane 0
#startitem 1011
#mountmnr 14415 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Gisoreux_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Gisoreux_Unmounted2.tga"
#end

#newmonster 14415
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Gisoreux_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Gisoreux_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#holy
#end


-- Duke Bohemond of Bastonne (strong)

#newmonster 13701
#copystats 13698 -- Grail Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Bastonne_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Bastonne_2.tga"
#name "Duke of Bastonne"
#fixedname "Bohemond"
#descr "Bohemond is the Duke of Bastonne, the founding Dukedom originally ruled by Gilles le Breton, the first King of Bretonnia. The Dukes of Bastonne follow the Virtue of Heroism and are quick to take the Questing Vow and seek the Grail. Bohemond took the Questing Vow at a shockingly young age, became a famed across the land as 'Bohemond Beastslayer', then drank from the Grail in record time. Bohemond's fame is hard to overstate: he is worshipped by the peasantry as a living god and held up as an ideal of the Questing Vow by almost every knight in the Kingdom. His greatest acheivement, for which he was granted the prize of the Grail, was the slaying of the dragon Smearghus, from whose bones he crafted his signature mace and whose scales were used to forge his armour. Bohemond, for all his martial prowess, has never been much of a leader of men, though his fame certainly inspires great deeds from those under his command."
#clearweapons
#cleararmor
#awe 2
#weapon 1022 -- Heroic Lance
#weapon 1036 -- Dragonbone Mace
#armor 21 -- Full Helmet
#armor 337 -- Plate of Smearghus
#armor 57 -- Shield of Valor
#itemslots 991238 --full, no bow
#fireres 15
#inspirational 2
#taskmaster 3
#att 15 (+1)
#def 15 (+1)
#okleader
--all Dukes have the following
#gcost 0
#rcost 0
#gold 50
#insane 10
#mountmnr 14409 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Bastonne_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Bastonne_Unmounted2.tga"
#end

#newmonster 14409
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Bastonne_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Bastonne_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#holy
#end


-- Duke Huebald of Carcassonne (weak)

#newmonster 13702
#copystats 13696 -- Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Carcassone_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Carcassone_2.tga"
#name "Duke of Carcassonne"
#fixedname "Huebald"
#descr "Huebald is the Duke of Carcassonne, a heavily militarised Dukedom which expects great feats of courage and arms from even the lowly peasant Men-at-Arms in its service. Dukes of Carcassonne follow the Virtue of Stoicism and are known for not only their personal fearlessness, but the bravery they inspire in those who march under their banner. Huebald is both small and slight by the standards of knights and has had to work extremely diligently to prove himself as a warrior, living a rather spartan life of training both his sword arm and his mind to better lead his Dukedom to military victory. Unlike some other Dukes Huebald never felt the call of the Questing Vow, for he was always too busy preparing for Carcassonne's next campaign against greenskins, Beastmen and the like. He is known as a superb leader of men particularly favoured by the peasantry, for while he shows them no more compassion than most, he recognises their utility on the battlefield and is loathe to misuse any tactical asset. Huebald is brutally honest about his own strengths and weaknesses and eschews the use of a lance, as he does not regard his best place as being at the head of a charging formation of knights."
#clearweapons
#weapon 8 --Broadsword
#str 10 (-2)
#hp 24
#taskmaster 3 -- very good with peasants
#superiorleader -- genius military leader
#mor 30 -- incredibly brave
#att 14 (+1)
#def 14 (+1)
#mountainsurvival
#itemslots 991238 --full, no bow
--all Dukes have the following
#gcost 0
#rcost 0
#gold 50
#insane 10
#undisleader 1
#mountmnr 14414 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Carcassone_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Carcassone_Unmounted2.tga"
#end

#newmonster 14414
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Carcassone_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Carcassone_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#end


-- Duke Theodoric of Brionne (medium)

#newmonster 13703
#copystats 13696 -- Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Brionne_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Brionne_2.tga"
#name "Duke of Brionne"
#fixedname "Theodoric"
#descr "Theodoric is the Duke of Brionne, a peaceful Dukedom of great beauty, culture, and art that is known to contribute disproportionate numbers of young Knights Errant looking to prove themselves the equal of those from more perilous Dukedoms. Dukes of Brionne follow the Virtue of the Impetuous Knight and are known for their headlong charges into the foe, firmly believing that any enemy of Bretonnia can be smashed by a knightly charge of sufficient honour and numbers. Theodoric is known away from the field of battle as a patron and lover of the arts and a competent enough minstrel himself. Being a fairly young Duke from a peaceful land who has not taken the Questing Vow, Theodoric is as eager to demonstrate his honour as the Knights Errant he often commands, and is known for his reckless almost bloodthirsty behaviour on the battlefield. In fact he almost becomes a different person when in combat, mercilessly hacking down foes with his great two handed axe and striking fear in the enemy."
#str 14 (+1)
#berserk 2
#clearweapons
#weapon 1028 -- Axe of Brionne
#hp 30
#att 14 (+1)
#def 14 (+1)
#itemslots 991238 --full, no bow
--all Dukes have the following
#gcost 0
#rcost 0
#gold 50
#taskmaster 0
#inspirational 2
#incunrest -10
#insane 15
#startitem 1006
#mountmnr 14413 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Brionne_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Brionne_Unmounted2.tga"
#end

#newmonster 14413
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Brionne_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Brionne_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#end


-- Cassayon the Duke of Parravon

#newmonster 13704
#copystats 13698 -- Grail Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Parravon_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Parravon_2.tga"
#name "Duke of Parravon"
#fixedname "Cassayon"
#descr "Cassayon is the Duke of Parravon, a Dukedom that lies in the Grey Mountains and has relatively little arable land. Dukes of Parravon follow the Virtue of Audacity and are blessed with an unnatural luck. Parravon is known for its use of Pegasus Knights and of course Cassayon rides on one of the greatest Royal Pegasi to ever live, a creature of incomparable nobility known as 'Chrysar'. Much like his rival Bohemond, Cassayon was one of the youngest knights to ever complete his Questing Vow and drink from the Grail. He is known to leave the management of Parravon to stewards and spends much of his time hunting monsters and glory at the borders of his realm."
#clearweapons
#taskmaster 0
#inspirational 2
#weapon 1022 -- Heroic Lance
#weapon 75 -- Enchanted Sword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#nametype 197
#ressize 2
#patrolbonus 15
#mountainsurvival
#hp 30
#itemslots 991238 --full, no bow
--all Dukes have the following
#gcost 0
#rcost 0
#gold 25
#insane 10
#command -30
#skilledrider 4
#startitem 1008
#mountmnr 13695 -- Chrysar the royal pegasus
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Brionne_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Brionne_Unmounted2.tga"
#end


-- Chrysar the royal pegasus

#newmonster 13695
#spr1 "Warhammer_Bretonnia/Hero_Chrysar.tga"
#spr2 "Warhammer_Bretonnia/Hero_Chrysar2.tga"
#name "Chrysar"
#descr "Chrysar is Cassayon's exceptional Royal Pegasus mount. Should the Duke be slain Chrysar will fight on to avenge him before returning to his mountain home at the end of the battle."
#str 19 -- +4
#prot 7 -- +4
#weapon 55 -- Hoof
#weapon 55 -- Hoof
#animal
#flying
#hp 35 -- +15
#mor 15 -- +4
#mr 13 -- +2
#att 12 -- +2
#def 12 -- +2
#ap 24
#enc 3
#mapmove 28
#size 6
#nametype 100 
--quadruped
#bravemount 100
#maxage 500
#holy
#end


-- Adalhard the Duke of Lyonesse 

#newmonster 13705
#copystats 13696 -- Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Lyonesse_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Lyonesse_2.tga"
#name "Duke of Lyonesse"
#fixedname "Adalhard"
#descr "Adalhard is the Duke of Lyonesse, a Dukedom known for its near constant state of conflict between its own rival Lords and the quality and proliferation of its defensive fortifications. Dukes of Lyonesse follow the Virtue of Duty and while they will frequently clash with other Dukes, are known for their loyalty to the King. Adalhard is known as a simple man with simple tastes, enjoying battle, feasts, and fulfilling his duty. He never saw the need to undertake the Questing Vow, regarding his duties to crown and realm as far more important, and is well known for raising large forces to support national causes. Having risen to prominence in the highly fortified and fractious lands of Lyonesse he is quite adept at both taking and defending fortifications. He rides into battle armed with magical morningstar capable of tearing apart mundane armour."
#clearweapons
#weapon 173 -- Star of Heroes
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#siegebonus 40
#castledef 100
#expertleader
#taskmaster 2
#itemslots 991238 --full, no bow
--all Dukes have the following
#gcost 0
#rcost 0
#summon5 13666
#summon4 13716
#summon2 13667
#gold 50
#mountmnr 14417 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Lyonesse_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Lyonesse_Unmounted2.tga"
#end

#newmonster 14417
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Lyonesse_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Lyonesse_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#end


-- Chilfroy the Duke of Artois

#newmonster 13706
#copystats 13696 -- Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Artois_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Artois_2.tga"
#name "Duke of Artois"
#fixedname "Chilfroy"
#descr "Chilfroy is the Duke of Artois, a heartland Dukedom known for its thick forests and constant warfare with Beastmen and other foul creatures that inhabit the depths of the woodland. Dukes of Artois follow the Virtue of the Joust and are incomparable lancers known for both winning tournaments and leading their knights from the tip of a charging formation. Chilfroy is notoriously strong and physically fit, having dominated quite handily in all manner of athletic disputes as a child before becoming a deadly warrior as he reached adulthood. Truthfully he likes little more than to fight and isn't known to be a particularly effective ruler, nor has he shown much interest in taking the Questing Vow, preferring to continue hunting the beasts of Artois from his current position. As a warrior, though, there are few who can match the thickly muscled Duke of Artois. Should the enemy survive his initial charge, Chilfroy will lay waste to the survivors with a deadly magical axe he reclaimed from a Beastlord he slew singlehanded."
#str 15 (+2)
#clearweapons
#weapon 1030 -- Lance of Artois
#weapon 245 -- Axe of Sharpness
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#forestsurvival
#hp 35 (+5)
#att 15 (+2)
#def 15 (+2)
#gold 25
#patrolbonus 25
#inspirational 2
#taskmaster 0
#insane 10
#itemslots 991238 --full, no bow
--all Dukes have the following
#gcost 0
#rcost 0
#resources 80
#startitem 1007
#mountmnr 14410 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Artois_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Artois_Unmounted2.tga"
#end

#newmonster 14410
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Artois_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Artois_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#end


-- Armand the Duke of Aquitaine (Strong - due to onebattlespell)

#newmonster 13707
#copystats 13698 -- Grail Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Aquitane_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Aquitane_2.tga"
#name "Duke of Aquitaine"
#fixedname "Armand"
#descr "Armand is the Duke of Aquitaine, a Dukedom known equally for its beautiful scenery and its generations of bloody internal feuds between families, be they commonfolk or nobles. Dukes of Aquitaine follow the Virtue of Noble Disdain and are noted for their contempt of those who fight at range rather than face-to-face. Armand is a rather enigmatic ruler who chose to take the Questing Vow and completed it entirely in disguise, so even the most knowledgeable bard does not know exactly what deeds to assign to him. What is known is that when he returned he won the great Tournament of Couronne and as his prize claimed the honour of carrying the sacred Banner of Bretonnia. This banner contains magic which protects the entire allied force from cowardly missile fire in battle.

[Casts arrow fend on battle start]"
#cleararmor
#inspirational 3
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#onebattlespell "Arrow Fend"
#itemslots 991238 --full, no bow
--all Dukes have the following
#gcost 0
#rcost 0
#gold 50
insane 10
#mountmnr 14411 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Aquitane_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Aquitane_Unmounted2.tga"
#end

#newmonster 14411
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Aquitane_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Aquitane_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#holy
#end


-- Alberic the Duke of Bordeleaux (medium)

#newmonster 13708
#copystats 13696 -- Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Bordeaux_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Bordeaux_2.tga"
#name "Duke of Bordeleaux"
#fixedname "Alberic"
#descr "Alberic is the Duke of Bordeleaux, a powerful Dukedom famed for its wine, craftsmen, and large sea-ports. Dukes of Bordeleaux follow the Virtue of Discipline and are known to be sharp-minded and pragmatic rulers, often closely advising the King himself. Alberic is a highly capable commander and particularly well known for both the quality of his Knights of the Realm and his clever use of Yeoman soldiers, drawing on the comparatively better off commonfolk of his wealthy Dukedom. He believes strongly in the cause of Bretonnia and will donate gold from his personal coffers each month to support the war effort. In battle the Duke wields the magical Trident of Manann, which grants both him and a small force of troops the ability to travel underwater."
#clearweapons
#inspirational 1
#taskmaster 1
#weapon 1027 -- Trident of Manaan
#amphibian
#giftofwater 80
#itemslots 991238 --full, no bow
#att 14 (+1)
#def 14 (+1)
#expertleader
--all Dukes have the following
#gcost 0
#rcost 0
#resources 40
#gold 100
#insane 10
#mountmnr 14412 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Bordeaux_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Bordeaux_Unmounted2.tga"
#end

#newmonster 14412
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Bordeaux_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Bordeaux_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#end


-- Folcard the Duke of Montfort (medium)

#newmonster 13709
#copystats 13696 -- Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Montfort_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Montfort_2.tga"
#name "Duke of Montfort"
#fixedname "Folcard"
#descr "Folcard is the Duke of Montfort, a mountainous Dukedom that lies in the border with the Empire and is often embroiled in war and greenskin incursions. Dukes of Montfort follow the Virtue of Empathy, championing the commonfolk and receiving their loyalty and adoration in return. Folcard is perhaps the most beloved ruler in Bretonnia, at least amongst his own subjects, for he takes the practice of knightly compassion and empathy for lessers far more seriously than most of his fellow nobles. He cares deeply about the plight of his people and has even set up a system of signal beacons such that knights can quickly respond to threats to even remote villages. Folcard is well known for his ability to quickly organise provincial defences and the loyalty and comparative bravery displayed by commoners under his command."
#incprovdef 10
#taskmaster 3
#expertleader
#incunrest -20
#mountainsurvival
#itemslots 991238 --full, no bow
--all Dukes have the following
#gcost 0
#rcost 0
#gold 50
#insane 10
#mountmnr 14418 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Montfort_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Montfort_Unmounted2.tga"
#end

#newmonster 14418
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Montfort_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Montfort_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#end


-- Tancred II the Duke of Quenelles (strong)

#newmonster 13710
#copystats 13698 -- Grail Lord
#spr1 "Warhammer_Bretonnia/Duke_of_Quenelles_1.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Quenelles_2.tga"
#name "Duke of Quenelles"
#fixedname "Tancred II"
#descr "Tancred II is the Duke of Quenelles, the largest of the Dukedoms and amongst the most powerful, a land known for its unending hatred of greenskins and campaigns against them. Dukes of Quenelles follow the Virtue of Purity and are known for their honour and steadfast efforts to destroy the enemies of mankind. Tancred II is the son of one of the most revered Dukes and Grail Knights in Bretonnian history who lost his life at the hands of Heinrich Kemmler, the Lichemaster. Seeking to honour his father Tancred II swore to drive both the undead and greenskin blights from all Bretonnian lands and has led many campaigns to that goal. A highly skilled and honourable warrior in his own right, Tancred II followed in his father's footsteps by seeking and drinking from the Grail and also recovered the mighty magic weapon the Star of Quenelles, with which he smites evil from the world."
#clearweapons
#weapon 1032 -- Star of Quenelles
#itemslots 991238 --full, no bow
#taskmaster 0
#heal
#woundfend 2
#awe 2
#forestsurvival
--all Dukes have the following
#gcost 0
#rcost 0
#gold 100
#startitem 1009
#startitem 1010
#insane 10
#mountmnr 14419 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Duke_of_Quenelles_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Duke_of_Quenelles_Unmounted2.tga"
#end

#newmonster 14419
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Duke_of_Quenelles_Mount.tga"
#spr2 "Warhammer_Bretonnia/Duke_of_Quenelles_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#holy
#end


-- Shepherdess Commander (non summoning form)

#newmonster 13713
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Shepardess_Commander_1.tga"
#spr2 "Warhammer_Bretonnia/Shepardess_Commander_2.tga"
#name "Shepherdess Commander"
#descr "Bretonnia is a land which places a heavy slate of duties, restrictions, and laws upon its people, especially commonfolk and women. However there is one occupation that is, due to unusual laws of unknown origin but clear legal authority, almost entirely outside these restrictions: that of the Shepherdess. Women who tend to sheep may, so long as they are actively doing their job, travel, own armour, earn and keep money, and even take part in battles. Consequently some women who seek freedom and find they have a talent for war effectively become mercenaries, though they must maintain the charade that they are merely tending to sheep. This suits the nobility rather well as while they are forbidden from hiring mercenaries, they are quite within their rights to hire Shepherdesses to escort a single sheep right to the site of a battle and through enemy lines. When a Shepherdess Commander is recruited she will bring fifteen of her Shepherdess 'assistants' with her. They are disciplined fighters, well armoured under their rustic smocks, and armed with staff slings which they use to great effect at range and in melee."
#weapon 7 -- quarterstaff
#weapon 1031 -- Staff Sling
#armor 20 -- Iron Cap
#armor 8 -- chain mail cuirass
#hp 11
#mor 12
#mr 11
#att 11
#def 11
#prec 11
#female
#gcost 55
#rcost 1
#mountainsurvival
#forestsurvival
#okleader
#nametype 103 --Man Female 
#startage 30
--
#end


-- Shepherdess Commander (summoning form)

#newmonster 13711
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Shepardess_Commander_1.tga"
#spr2 "Warhammer_Bretonnia/Shepardess_Commander_2.tga"
#name "Shepherdess Commander"
#descr "Bretonnia is a land which places a heavy slate of duties, restrictions, and laws upon its people, especially commonfolk and women. However there is one occupation that is, due to unusual laws of unknown origin but clear legal authority, almost entirely outside these restrictions: that of the Shepherdess. Women who tend to sheep may, so long as they are actively doing their job, travel, own armour, earn and keep money, and even take part in battles. Consequently some women who seek freedom and find they have a talent for war effectively become mercenaries, though they must maintain the charade that they are merely tending to sheep. This suits the nobility rather well as while they are forbidden from hiring mercenaries, they are quite within their rights to hire Shepherdesses to escort a single sheep right to the site of a battle and through enemy lines. When a Shepherdess Commander is recruited she will bring fifteen of her Shepherdess 'assistants' with her. They are disciplined fighters, well armoured under their rustic smocks, and armed with staff slings which they use to great effect at range and in melee.

[When purchased will arrive in command of 15 Shepherdess troops. Does not summon any additional troops each month]"
#weapon 7 -- quarterstaff
#weapon 1031 -- Staff Sling
#armor 20 -- Iron Cap
#armor 8 -- chain mail cuirass
#summon1 13712 --Shepardess
#summon2 13712 --Shepardess
#summon3 13712 --Shepardess
#summon4 13712 --Shepardess
#summon5 13712 --Shepardess
#firstshape 13713 --Shepardess commander without summons
#hp 11
#mor 12
#mr 11
#att 11
#def 11
#prec 11
#female
#gcost 240
#rpcost 1
#rcost 1
#mountainsurvival
#forestsurvival
#okleader
#nametype 103 --Man Female 
#startage 30
--
#end


-- Shepherdess

#newmonster 13712
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Shepardess_1.tga"
#spr2 "Warhammer_Bretonnia/Shepardess_2.tga"
#name "Shepherdess"
#descr "Bretonnia is a land which places a heavy slate of duties, restrictions, and laws upon its people, especially commonfolk and women. However there is one occupation that is, due to unusual laws of unknown origin but clear legal authority, almost entirely outside these restrictions: that of the Shepherdess. Women who tend to sheep may, so long as they are actively doing their job, travel, own armour, earn and keep money, and even take part in battles. Consequently some women who seek freedom and find they have a talent for war effectively become mercenaries, though they must maintain the charade that they are merely tending to sheep. This suits the nobility rather well as while they are forbidden from hiring mercenaries, they are quite within their rights to hire Shepherdesses to escort a single sheep right to the site of a battle and through enemy lines. They are disciplined fighters, well armoured under their rustic smocks, and armed with staff slings which they use to great effect at range and in melee."
#weapon 7 -- quarterstaff
#weapon 1031 -- Staff Sling
#armor 20 -- Iron Cap
#armor 8 -- chain mail cuirass
#mor 11
#ap 12
#prec 11
#female
#gcost 10
#mountainsurvival
#forestsurvival
#goodleader
#nametype 103 --Man Female 
#startage 30
#end


-- Grail Reliquae

#newmonster 13717 -- Reliquae shape with 7 crew
#spr1 "Warhammer_Bretonnia/Battle_Reliquary_Form1_1.tga"
#spr2 "Warhammer_Bretonnia/Battle_Reliquary_Form1_2.tga"
#name "Battle Reliquae"
#descr "To some peasants Grail Knights are effectively living gods whose every act is one of divine heroism and every word is scripture, thus it is unsurpising that there is a particular set of Pilgrims who dedicate their lives to following Grail Knights and, should they meet their end, rushing to secure holy 'relics'. If a Grail Knight is unlucky to be felled in a remote place and this news reaches these fanatics before any members of the nobility, it is quite possible the remains of both knight and steed will be stolen away and turned into a Battle Reliquae. Battle Reliquaes are effectively the skeletal remains of a Grail Knight and his trusty steed dressed up and held together by bindings and staves in a parody of life. They are carried into battle by devout bands of Pilgrims who are driven into a frenzy by visions of their fallen hero-god looking over their actions and approving. Inevitably the presence of a Reliquae causes unrest in the population of a province as commoners argue over the wishes and possession of the remains. The nobility, especially those who have taken the Grail Vow, regard Reliquaes with disgust bordering on horror, but the emissaries of the Lady have let it be known that they are to be allowed to accompany armies into battle and the nobility have no choice but to accept their presence with gritted teeth.

[Berserks self and summons 2d6 Battle Pilgrims and 7d6 Pilgrims on battle start]"
#str 11
#ambidextrous 10
#berserk 3
#weapon 1116
#weapon 1116
#weapon 1128
#weapon 1128
#weapon 1128
#armor 118 -- half Helmet
#armor 7 -- scale mail cuirass
#armor 2 --Shield
#itemslots 270336 -- 1 misc, head
#batstartsum2d6 13685 --Battle Pilgrim
#batstartsum7d6 13686 -- Pilgrim
#holy
#heal
#eyes 14
#woundfend 99
#hp 96
#shrinkhp 84
#incunrest 80 --8 per month
#mor 30
#mr 13
#att 12
#def 12
#ap 12
#prec 10
#enc 2
#gcost 300
#rcost 15
#rpcost 2
#poorleader
#taskmaster 4
#mapmove 14
#size 10
#nametype 197
#ressize 2
#startitem 909 -- reliquae
#end


#newmonster 13718 -- Reliquae shape with 6 crew
#spr1 "Warhammer_Bretonnia/Battle_Reliquary_Form2_1.tga"
#spr2 "Warhammer_Bretonnia/Battle_Reliquary_Form2_2.tga"
#name "Battle Reliquae"
#descr "One of the guards has fallen but the Pilgrims will stand firm."
#str 11
#ambidextrous 10
#berserk 3
#weapon 1116
#weapon 1116
#weapon 1128
#weapon 1128
#armor 118 -- half Helmet
#armor 7 -- scale mail cuirass
#armor 2 --Shield
#itemslots 262144 -- 1 misc
#holy
#heal
#hp 96
#growhp 85
#shrinkhp 72
#mor 30
#eyes 12
#woundfend 99
#mr 13
#att 12
#def 12
#ap 12
#enc 2
#poorleader
#taskmaster 4
#mapmove 14
#size 9
#itemslots 270336 -- 1 misc, head
#end


#newmonster 13719 -- Reliquae shape with 5 crew
#spr1 "Warhammer_Bretonnia/Battle_Reliquary_Form3_1.tga"
#spr2 "Warhammer_Bretonnia/Battle_Reliquary_Form3_2.tga"
#name "Battle Reliquae"
#descr "Only one guard now remains to protect the carriers."
#str 11
#ambidextrous 10
#berserk 3
#weapon 1116
#weapon 1116
#weapon 1128
#armor 118 -- half Helmet
#armor 7 -- scale mail cuirass
#armor 2 --Shield
#itemslots 262144 -- 1 misc
#holy
#hp 96
#growhp 73
#shrinkhp 60
#mor 30
#mr 13
#att 12
#def 12
#ap 12
#eyes 10
#woundfend 99
#enc 3
#poorleader
#taskmaster 4
#mapmove 14
#size 8
#itemslots 270336 -- 1 misc, head
#end


#newmonster 13720 -- Reliquae shape with 4 crew
#spr1 "Warhammer_Bretonnia/Battle_Reliquary_Form4_1.tga"
#spr2 "Warhammer_Bretonnia/Battle_Reliquary_Form4_2.tga"
#name "Battle Reliquae"
#descr "The guards have fallen but the carriers will not leave their sacred task."
#str 11
#ambidextrous 10
#berserk 3
#weapon 1116
#weapon 1116
#armor 118 -- half Helmet
#armor 7 -- scale mail cuirass
#itemslots 262144 -- 1 misc
#holy
#hp 96
#growhp 61
#shrinkhp 48
#mor 30
#eyes 8
#woundfend 99
#mr 13
#att 12
#def 12
#ap 10
#enc 3
#poorleader
#taskmaster 4
#mapmove 14
#size 8
#itemslots 270336 -- 1 misc, head
#end


#newmonster 13721 -- Reliquae shape with 3 crew
#spr1 "Warhammer_Bretonnia/Battle_Reliquary_Form5_1.tga"
#spr2 "Warhammer_Bretonnia/Battle_Reliquary_Form5_2.tga"
#name "Battle Reliquae"
#descr "One of the Carriers has now fallen and the Reliquae is stuck in place. The carriers have picked up the weapons of their fallen brothers and stand to defend the relic."
#str 11
#ambidextrous 10
#berserk 3
#weapon 1116
#weapon 1116
#armor 118 -- half Helmet
#armor 7 -- scale mail cuirass
#armor 2 --Shield
#itemslots 262144 -- 1 misc
#holy
#immobile
#hp 96
#growhp 49
#shrinkhp 36
#mor 30
#mr 13
#att 12
#def 12
#eyes 6
#woundfend 99
#ap 1
#prec 10
#enc 4
#poorleader
#taskmaster 4
#mapmove 14
#size 7
#itemslots 270336 -- 1 misc, head
#end


#newmonster 13722 -- Reliquae shape with 2 crew
#spr1 "Warhammer_Bretonnia/Battle_Reliquary_Form6_1.tga"
#spr2 "Warhammer_Bretonnia/Battle_Reliquary_Form6_2.tga"
#name "Battle Reliquae"
#descr "Two of the Carriers has now fallen and the Reliquae is stuck in place. The bearers have picked up the weapons of their fallen brothers and stand to defend the relic."
#str 11
#ambidextrous 10
#berserk 3
#weapon 1116
#armor 118 -- half Helmet
#armor 7 -- scale mail cuirass
#armor 2 --Shield
#itemslots 262144 -- 1 misc
#holy
#immobile
#hp 96
#growhp 37
#shrinkhp 24
#mor 30
#mr 13
#att 12
#def 12
#eyes 4
#woundfend 99
#ap 1
#enc 4
#poorleader
#taskmaster 4
#mapmove 14
#size 7
#itemslots 270336 -- 1 misc, head
#end


#newmonster 13723 -- Reliquae shape with 1 crew
#spr1 "Warhammer_Bretonnia/Battle_Reliquary_Form7_1.tga"
#spr2 "Warhammer_Bretonnia/Battle_Reliquary_Form7_2.tga"
#name "Battle Reliquae"
#descr "The last bearer now makes a desperate last stand defence of the holy knight."
#str 11
#ambidextrous 10
#berserk 3
#weapon 1128
#armor 118 -- half Helmet
#armor 7 -- scale mail cuirass
#armor 2 --Shield
#itemslots 262144 -- 1 misc
#holy
#immobile
#hp 96
#growhp 25
#shrinkhp 12
#mor 30
#mr 13
#woundfend 99
#att 12
#def 12
#ap 1
#enc 5
#poorleader
#taskmaster 4
#mapmove 14
#size 6
#itemslots 270336 -- 1 misc, head
#end


#newmonster 13724 -- Reliquae shape with 0 crew
#spr1 "Warhammer_Bretonnia/Battle_Reliquary_Form8_1.tga"
#spr2 "Warhammer_Bretonnia/Battle_Reliquary_Form8_1.tga"
#name "Battle Reliquae"
#descr "Now all the Pilgrims are dead and the grail knight stands quietly surrounded by corpses of the battle, sometimes slightly swinging in the wind. It is a eerie sight."
#str 10
#ambidextrous 10
#berserk 3
#noweapon
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#itemslots 262144 -- 1 misc
#fear 5
#holy
#heal
#woundfend 99
#immobile
#inanimate
#poisonres 25
#coldres 25
#hp 96
#growhp 13
#pierceres
#mor 30
#mr 13
#att 12
#def 0
#ap 0
#prec 10
#enc 6
#poorleader
#taskmaster 4
#mapmove 14
#size 6
#itemslots 270336 -- 1 misc, head
#end


-- Grail Maiden

#newmonster 13728
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Grail_Maiden_1.tga"
#spr2 "Warhammer_Bretonnia/Grail_Maiden_2.tga"
#name "Grail Maiden"
#descr "Maidens are the most common emmisaries of the will of the Lady, serving their superiors the Damsels with unearthly grace and beauty. Unlike Damsels or Prophetesses who are taken to the Lady as infants, Maidens are selected by Damsels shortly before they come of age. This is likely because they do not show such clear signs of magical talent or the touch of the Fae, as it is certainly the case that Maidens are considerably less gifted in the sorcerous arts than their superiors. It is not unheard of for even peasant girls to be selected as Maidens, a fact which somewhat salves the displeasure a farmer or labourer will feel at the news his newborn child is not a son."
#str 8
#weapon 9 -- dagger
#hp 8
#mor 12
#mr 15
#holy
#att 8
#def 8
#custommagic 24576 100 -- NG
#magicskill 9 1
#magicskill 2 1 -- W
#female
#gcost 140
#rpcost 2
#nametype 103 
#startage 20
#maxage 80
#poorleader
#end


-- Grail Damsel

#newmonster 13682
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Grail_Damsel_1.tga"
#spr2 "Warhammer_Bretonnia/Grail_Damsel_2.tga"
#name "Grail Damsel"
#descr "Damsels are emissaries and agents of the will of the Lady. They were once mortal women, daughters of aristocrats who were born with some element of the mystical of touch of the Fae about them, taken by the Fay Enchantress to the mysterious Otherworld. When they return years, decades, even centuries later, they appear as women of astonishing beauty and presence with powerful magic at their disposal. Damsels specialise in enhancing the power of knights, particularly the Grail Knights that serve them, on the field of battle, but they also wield considerable political power, as no Lord would ignore their counsel. They carry simulacrums of the Grail itself and can use them to cure disease."
#weapon 75 -- Enchanted Sword
#mor 11
#mr 17
#holy
#autodishealer 1
#magicskill 7 1 -- G1
#magicskill 2 1 -- W1
#magicskill 6 1 -- N1
#custommagic 27136 100 -- WSNG
#magicskill 9 2
#female
#awe 1
#gcost 280
#rpcost 2
#nametype 103 
#startage 20
#maxage 200
#okleader
#magicbeing
#guardspiritbonus 10
#end


-- Grail Prophetess

#newmonster 13683
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Grail_Prophetess.tga"
#spr2 "Warhammer_Bretonnia/Grail_Prophetess2.tga"
#name "Grail Prophetess"
#descr "Prophetesses are the most powerful of the emissaries of the Lady, standing only slightly below the station of the Fay Enchantress. All of the mystical might, divine authority, and otherworldly beauty possessed by Damsels is magnified in the form of the Prophetess, for in the Otherworld they learned at the feet of the Lady of the Lake herself. In addition to being able to heal diseases Prophetesses can heal virtually any wound and have the ability to see the future in the surface of water and mirrors."
#weapon 238 -- magic staff
#hp 11
#mor 12
#mr 19
#holy
#magicbeing
#awe 3
#nobadevents 10
#autodishealer 1
#autohealer 1
#magicskill 7 2
#magicskill 2 2
#magicskill 6 2
#custommagic 27136 100 -- WSNG
#magicskill 9 3
#female
#gcost 560
#rpcost 4
#okleader
#nametype 103 
#startage 40
#maxage 400
#guardspiritbonus 20
#end



------------- HEROES


-- Green Knight

#newmonster 13725
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Green_Knight_1.tga"
#spr2 "Warhammer_Bretonnia/Green_Knight_2.tga"
#name "Green Knight"
#descr "The Green Knight is the sacred protector of Bretonnia, and his spirit-essence is intertwined with the land and the Lady of the Lake. As the Champion of the Lady he has tested many Questing Knights, facing them in duels to assess their worth to sip from the Grail, sometimes even slaying those who are truly unworthy of this final test. Amongst evil creatures like Beastmen and Greenskins the Green Knight is greatly feared, for he is a merciless and relentless slayer of such filth, capable of bursting forth from the bole of ancient trees, springing from still lakes, or galloping out from behind waterfalls to wreak his terrible vengeance against interlopers to the realm of the Lady. Bretonnians dare not ascribe a name to this figure but in the foul tongue of the Beastmen he is known as 'Shaabhekh', or Soul Killer. Weapons have little effect on the Green Knight. Some say that blades and arrows pass straight through him as though he were as insubstantial as morning mist, while in other stories, even the most grievous of wounds inflicted upon him have virtually no effect. In one epic tale, a Questing Knight cut the Green Knight's head clean from his shoulders, but the fey being simply picked up his head and rode away. What the Green Knight actually is has been much debated, and no one in Bretonnia, save perhaps the Fay Enchantress, knows the truth. Some believe that he is the spirit of Bretonnia given physical form, while others whisper that he is Gilles le Breton himself, having devoted himself completely to the land and the Lady after he was taken from this world. Many times the Green Knight has disappeared, often after falling in battle, only to reappear some time later, for as long as Bretonnia stands she will have her protector.

[The Green Knight and his mount are a single spiritual entity and use the old mounted system intentionally]"
#str 15
#weapon 1022 -- Heroic Lance
#weapon 1020 -- Destrier Hoof
#weapon 75 -- Enchanted Sword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 57 -- Shield of Valor
#heal
#regeneration 10
#ethereal
#poisonres 25
#neednoteat
#mounted
#awe 1 -- reduced by 1
#fear 5 -- normal
#holy
#magicbeing
#hp 30
#mor 30
#mr 16 -- so he has a bit of a vulnerability
#att 15
#def 15
#ap 26
#patrolbonus 20
#enc 1
#prot 3
#woundfend 2
#gcost 0
#noleader
#mapmove 28 -- grail lord +2
#size 5
#startage 500
#maxage 8000
#float
#fixedname "Shaabhekh"
#nomovepen
--
#immortal
#reformtime 3 -- so takes 6 months
#reform 15 -- 15% chance to reform in battle if killed
#end



-- Fay Echantress

#newmonster 13688
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Fay_Enchantress_1.tga"
#spr2 "Warhammer_Bretonnia/Fay_Enchantress_2.tga"
#name "Fay Enchantress"
#descr "A figure of awe and inspiration, the Fay Enchantress is the personal representative of the Lady of the Lake and as such is the most influential figure in Bretonnia. All Grail Knights are sworn to her service and even Kings must bow to her commands. The Fay Enchantress personally takes the noble daughters who become Damsels and Prophetesses and in cases where there is no clear successor, will select the new monarch. The current Enchantress is known as Morgiana and while there have been Enchantresses before her, in truth there is but a single spirit reincarnated in a different body the moment her previous form perishes. The Enchantress is a being of incredible magical ability, stunning beauty, and sudden spite, making her one of the most terrifyingly powerful beings in the known world. On the relatively rare occasions she takes to the battlefield she does so atop a mighty Unicorn 'Silvaron', perhaps the noblest of its kind outside of Athel Loren. The Enchantress carries the fabled Chalice of Potions which allows her to cast spells at a faster rate than mortal mages, wears the Girdle of Gold which protects her from harm, and is accompanied by a magical toad from which she can draw arcane power, said to be a former noble who greatly displeased her."
#str 9
#weapon 75 -- Enchanted Sword
#hp 20
#mor 15
#mr 20
#holy
#magicbeing
#awe 5
#invulnerable 25 -- from the girdle of gold
#nobadevents 100
#autohealer 2
#att 11
#def 11
#magicskill 7 4
#magicskill 2 3
#magicskill 6 2
#magicskill 4 2
#magicskill 9 4
#airshield 80
#spreaddom 1
#female
#heal
#forestsurvival
#prec 12
#gcost 0
#okleader
#okmagicleader
#startage 200
#maxage 1000
#fear 5
#fixedname "Morgiana"
#tmpwatergems 1
#tmpnaturegems 1
#tmpairgems 1
#inspirational 3
#damagerev 1 -- this is her spiteful nature
#guardspiritbonus 100
#skilledrider 2
#mountmnr 13661 -- silvaron
#unmountedspr1 "Warhammer_Bretonnia/Fay_Enchantress_Unmounted2.tga"
#unmountedspr2 "Warhammer_Bretonnia/Fay_Enchantress_Unmounted2.tga"
#startitem 1005
#end


-- Silvaron

#newmonster 13661
#spr1 "Warhammer_Bretonnia/Hero_Silvaron.tga"
#spr2 "Warhammer_Bretonnia/Hero_Silvaron2.tga"
#name "Silvaron"
#descr "Silvaron is the mount of the Fay Enchantress. Should she be struck down Silvaron will fight on before returning to the deep woods when the battle ends."
#str 15
#weapon 1033 -- Horn
#weapon 1017 -- Hoof
#hp 35
#animal
#mor 14
#mr 16
#holy
#magicbeing
#awe 1
#att 12
#def 12
#heal
#forestsurvival
#ap 30
#prec 8
#enc 3
#mapmove 30
#maxage 2000
#size 5
--quadruped
#magicboost 53 -5
#bravemount 100
#end


-- King Louen Leoncoeur (reviewed)

#newmonster 13690
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Hero_Leoncour.tga"
#spr2 "Warhammer_Bretonnia/Hero_Leoncour2.tga"
#name "King"
#descr "The King of Bretonnia is the highest authority within the feudal order, a position accountable only to the highest emissaries of the Lady, such as the Fay Enchantress. Kings are almost always selected from amongst the ranks of the Dukes or the direct male heir of the former King, though it is not unknown for a particularly heroic noble to be chosen by the Fay Enchantress, whose word is absolute. The current King of Bretonnia is Louen Leoncoeur, also Duke of Couronne, a heroic leader regarded as the greatest since Gilles the Uniter himself. Louen's bravery, honour, and talent for diplomacy are famed across the Old World and it is whispered that he not only drank from the Grail but was granted a kiss by the Lady of the Lake. Certainly he seems to benefit from blessings even greater than those of other Grail Lords, as he is able to heal from nearly any wound and is surrounded by an even more powerful aura of splendor. Louen rides into battle atop his ferocious Hippogryph 'Beaquis', an especially loyal and powerful example of its kind, and is armed with the ancestral Sword of Couronne and the Lion's Shield, which grants him incredible resistance to hostile magic. On his brow rests the Crown of Bretonnia, worn by every King since Gilles the Uniter, which inspires those under his command to great deeds."
#weapon 1022 -- Heroic Lance
#weapon 1025 -- Sword of Couronne
#armor 14 -- Plate Hauberk
#armor 336 -- Lion's Shield
#holy
#magicbeing
#awe 3
#str 17 -- sword take him to str 5
#hp 32 -- rider
#prot 3
#mor 18
#mr 18
#att 14
#def 14
#prec 12
#gcost 0
#superiorleader
#goodmagicleader
#startage 90
#maxage 300
#inspirational 2
#fixedname "Louen Leoncoeur"
--
#startitem 910 -- Crown of Bretonnia -- to avoid the headslot issue
#itemslots 991238 -- no bow, otherwise normal
#regeneration 5 -- half of vanilla troll
#heal
#woundfend 1
#skilledrider 3
#mountmnr 13691 -- beaquis
#unmountedspr1 "Warhammer_Bretonnia/Hero_Leoncour_Unmounted2.tga"
#unmountedspr2 "Warhammer_Bretonnia/Hero_Leoncour_Unmounted2.tga"
#end


-- Beaquis (reviewed)

#newmonster 13691
#spr1 "Warhammer_Bretonnia/Royal_Griffon_3.tga"
#spr2 "Warhammer_Bretonnia/Royal_Griffon_4.tga"
#name "Royal Hippogryph"
#descr "Beaquis is Louen's loyal Hyppogryph. She will fight on until departing at the end of battle should the King be slain."
#str 22 -- +2
#prot 7
#weapon 20 -- Bite
#weapon 33 -- claws/talons
#armor 254 -- plate barding
#animal
#mountainsurvival
--quadruped
#fear 8 -- even more terrifying
#flying
#hp 60 -- +5
#mor 16 -- +2
#mr 14 -- +1
#att 12 -- +1
#def 13 -- +2
#ap 20 -- horselike
#prec 12 -- bird eyes
#enc 4
#gcost 0
#mapmove 28 -- same as vanilla gryphon
#size 8
--
#maxage 500
#bravemount 100
#end


-- Repanse de Lyonesse

#newmonster 13714
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Hero_Repanse.tga"
#spr2 "Warhammer_Bretonnia/Hero_Repanse2.tga"
#name "Damsel of War"
#descr "Repanse de Lyonesse was once a humble shepherdess, though one of notably devout faith in the Lady. Her village was attacked and laid waste by Chaos raiders split off from a great horde besieging Couronne and when Repanse returned from the pastures she found nothing but ruin and death. At this dark moment she received a vision from the Lady telling her to take up arms and rid her land of these interlopers so she donned the armour from a fallen knight, took an ancient blade from the reliquary of the wrecked Grail Chapel, and fastened a tapestry bearing the Fleur de Lys to a lance. When the wounded and scattered knights saw a single Damsel setting out to fight the forces of Chaos they felt shamed and honour bound to follow her to death or glory. Since that time Repanse has become one of the greatest heroes of Bretonnia and has consistently shown the favour of the Lady. She is surrounded in battle by an dazzling aura of light and both her sword and makeshift banner offer protection from hostile magic to her and any who follow.

[Casts Antimagic on battle start]"
#str 11
#weapon 1081 -- Sword of Lyonesse
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#hp 22
#mor 17
#mr 18
#att 12
#def 12
#gcost 0
#goodleader
#inspirational 1
#taskmaster 3
#ressize 2
#startage 20
--
#fixedname "Repanse de Lyonesse"
#onebattlespell "antimagic"
#awe 2
#holy
#itemslots 991238 -- full, no bow
#skilledrider 2
#mountmnr 14409 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Hero_Repanse_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Hero_Repanse_Unmounted2.tga"
#end

#newmonster 14409
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Hero_Repanse_Mount.tga"
#spr2 "Warhammer_Bretonnia/Hero_Repanse_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#holy
#end


-- Henri le Massif

#newmonster 13715
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Hero_Henri.tga"
#spr2 "Warhammer_Bretonnia/Hero_Henri2.tga"
#name "Champion of the Damsel"
#descr "Hailing from northern Bretonnia, Henri le Massif is as much a mountain as a man, a towering symbol of Bretonnian noble might. Like the other knights of Repanse's army, he placed himself in her service in recognition of her strong association with the Lady of the Lake. Having received the blessing of the Grail the already mighty knight augmented his great physical strength with supernatural prowess and in service of the Damsel of War Repanse de Lyonesse he has proved himself to be one of the greatest warriors the world has ever seen. Henri wields a magical sword enchanted to slay great beasts, protects himself with a shield blessed to repel cowardly projectile attacks, and wears thick plate armour. Henri is an imposing figure and an inspiration to others, but has little interest in military leadership, leaving this to Repanse and her advisors."
#str 17 -- +3 compared to grail lord
#weapon 1021 -- Breton Heavy Lance
#weapon 1136 -- Sword of Heroes
#armor 21 -- Full Helmet
#armor 19 -- Full Plate Mail
#armor 57 -- Shield of Valor
#holy
#magicbeing
#awe 1
#hp 36
#prot 4 -- +1
#mor 18
#mr 16
#att 14
#def 14
#gcost 0
#rpcost 2
#okleader
#command -20
#okmagicleader
#ressize 2
#fixedname "Sir Henri le Massif"
#startage 40
#maxage 300
--
#woundfend 1
#airshield 80
#itemslots 991238 -- full, no bow
#skilledrider 3
#mountmnr 14407 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Hero_Henri_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Hero_Henri_Unmounted2.tga"
#end

#newmonster 14407
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Hero_Henri_Mount.tga"
#spr2 "Warhammer_Bretonnia/Hero_Henri_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#holy
#end


-- Mallobaude

#newmonster 13692
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Hero_Mallobaude.tga"
#spr2 "Warhammer_Bretonnia/Hero_Mallobaude2.tga"
#name "Black Knight"
#descr "Mallobaude, often called the Black Knight, is the first Bretonnian in generations to present a serious chance of returning the lost and cursed Dukedom of Mousillon to proper rule. Mallobaude's career as a knight thusfar has been spectacular; as a Knight Errant he won glory leading a group in the Border Princes, swiftly became a Knight of the Realm and immediately took the Questing Vow. Despite many victories over foul creatures and countless heroic deeds, Mallobaude did not receive a vision of the Grail and began to despair that he had somehow lost his way. He realised he had been pursuing greatness for its own sake and, as penance, rode alone to Mousillon to face the suicidal task of cleansing that land. What happened there is unclear, but after many battles Mallobaude emerged carrying the banner of Mousillon and announced he would soon be known as its Duke, drawing many knights to support him in this crusade. While Mallobaude is a highly impressive, his association with Mousillon, unusual outcome of his Questing Vow, and rumours that he is the illegitimate son of King Louen have cast something of a shadow over his status. Indeed it is whispered amongst the peasantry that even the emissaries of the Lady are not keen to meet his piercing gaze, though no nobles would publicly countenance such nonsense."
#str 15
#weapon 1021 -- Breton Heavy Lance
#weapon 1026 -- Black Sword
#armor 40 -- BlackSteel Helmet
#armor 14 -- Plate Hauberk
#armor 3 -- Kite Shield
#fear 5
#hp 34
#prot 10
#mor 18
#mr 16
#att 14
#def 14
#gcost 0
#gold -50
#incunrest 20
#okleader
#command 50
#okundeadleader
#inspirational -2
#startage 25
#maxage 500
#fixedname "Mallobaude"
--
#itemslots 991238 -- full, no bow
#heal
#neednoteat
#skilledrider 4
#insane 20
#mountmnr 14408 -- bretonnian destrier
#unmountedspr1 "Warhammer_Bretonnia/Hero_Mallobaude_Unmounted.tga"
#unmountedspr2 "Warhammer_Bretonnia/Hero_Mallobaude_Unmounted2.tga"
#end

#newmonster 14408
#copystats 3517 -- man destrier
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Bretonnia/Hero_Mallobaude_Mount.tga"
#spr2 "Warhammer_Bretonnia/Hero_Mallobaude_Mount2.tga"
#name "Bretonnian Destrier"
#descr "Bretonnian Destriers are purebreed mounts which are the finest warhorses in the Old World. They are well trained for battle and sometimes fight on even without their rider."
#rpcost 28
#str 16 -- +1
#hp 24 -- +2
#mor 12 -- +1
#ap 25 -- +2
#mapmove 24 -- +4
#def 11 -- +1
#gcost 30
#bravemount 50
#end


-------- SUMMONS

-- Guardian Spirit Knight

#newmonster 13689
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/Spirit_Knight_1.tga"
#spr2 "Warhammer_Bretonnia/Spirit_Knight_2.tga"
#name "Guardian Spirit Knight"
#descr "Such is the devotion of Grail Knights to the Lady and her emissaries that their spirits will often return to protect a Maiden, Damsel, or Prophetess that is in dire straights. These guardian spirits are very hard to destroy due to their ethereal nature."
#str 12
#weapon 1023 -- Great Sword
#armor 14 -- Plate Hauberk
#armor 21 -- Full Helmet
#magicbeing
#holy
#float
#ethereal
#hp 15
#mor 30
#mr 13
#att 12
#def 12
#ap 14
#enc 0
#gcost 0
#rcost 1
#noleader
#mapmove 12
#startage 200
#maxage 2000
#poisonres 25
#coldres 10
#spiritform
#end


-- Son of Bretonnia

#newmonster 10008
#copystats 14397 -- generic human
#spr1 "Warhammer_Bretonnia/SonofBretonnia_1.tga"
#spr2 "Warhammer_Bretonnia/SonofBretonnia_2.tga"
#name "Son of Bretonnia"
#descr "One of the lost Sons of Bretonnia. Taken in his youth by the Lady of the Lake and reared in her domain, to be her undying servant. They are fearsome ephemeral warriors who ride on watery fae steeds. They emerge only in the most dire of circumstances at the behest of the Lady of the Lake.

[Slightly worse Green Knights with liquid body manually cast on them.]"
#str 11
#weapon 1022 -- Heroic Lance
#weapon 2501 -- Watery Hoof
#weapon 75 -- Enchanted Sword
#armor 21 -- Full Helmet
#armor 14 -- Plate Hauberk
#armor 57 -- Shield of Valor
#heal
#regeneration 5
#ethereal
#illusion
#poisonres 25
#coldres -5
#neednoteat
#mounted
#awe 1 -- reduced by 1
#holy
#magicbeing
#hp 28
#mor 30
#mr 14 -- so he has a bit of a vulnerability
#att 14
#def 14
#ap 20
#enc 1
#prot 2
#woundfend 3
#gcost 0
#mapmove 28
#size 5
#startage 500
#maxage 8000
#float
#nomovepen
#bluntres
#pierceres
#slashres
#end

-------- SPELLS

-- Duke of Brionne (autospell for the Duke of Brionne)

#newspell
#name "Duke of Brionne"
#descr "The Duke of Brionne leads the most terrifying knights in the realm."
#effect 23
#damage 16
#school -1
#path 0 9
#pathlevel 0 9
#range 0
#fatiguecost 50
#aoe 25
#spec 2251808407814144
#restricted 156
#end


-- Duke of Artois (autospell for the Duke of Artois)

#newspell
#copyspell "Quickness"
#name "Duke of Artois"
#descr "The Duke of Artois exhorts his knights to a heroic speed."
#school -1
#path 0 9
#pathlevel 0 9
#range 0
#fatiguecost 50
#aoe 25
#spec 2251808407814144
#restricted 156
#end


-- Duke of Parravon (autospell for the Duke of Parravon)

#newspell
#copyspell "Luck"
#name "Duke of Parravon"
#descr "The Duke of Parravon and his men are known to have some rather extraordinary luck."
#school -1
#path 0 9
#pathlevel 0 9
#range 0
#fatiguecost 50
#aoe 25
#spec 8594128896
#restricted 156
#end

-- Duke of Quenelles (autospell for the Duke of Quenelles)

#newspell
#copyspell "Serenity"
#name "Duke of Quenelles"
#descr "The Duke of Quenelles' reputation preceds him. The enemy is rattled. Greenskins are particularly affected"
#school -1
#path 0 9
#pathlevel 0 9
#range 0
#fatiguecost 50
#aoe 666
#spec 144132781076529152
#restricted 156
#end


-- Duke of Gisoreux (autospell for the Duke of Gisoreux)

#newspell
#name "Duke of Gisoreux"
#descr "The Duke of Gisoreux manages his soldiers in an exceptionally efficient manner. Lending to their incredible longevity in battle"
#effect 8
#damage 1
#school -1
#path 0 9
#pathlevel 0 9
#range 0
#aoe 25
#spec 8594132992
#restricted 156
#end


-- King's Fire

#newspell
#copyspell "Fire Shield"
#name "King's Fire"
#descr "Louen Leoncoeur's knights are engulfed in holy fire that burns enemies who dare strike them."
#school -1
#path 0 9
#pathlevel 0 9
#range 0
#fatiguecost 50
#aoe 25
#spec 8594128896
#restricted 156
#end

-- Blessing of the Lady

#newspell
#copyspell "Gift of Splendor"
#name "Blessing of the Lady"
#descr "The Lady of the Lake's emissary extends her blessing to the brave warriors on the field. For a battle and a day they will be honorarily made grail knights and enemies will hesitate to strike them."
#school 7
#researchlevel 0
#path 0 9
#path 1 -1
#range 0
#pathlevel 0 5
#fatiguecost 99
#casttime 200
#aoe 666
#spec 12599424
#restricted 156
#end


-- Beseech the Lady's Aid

#newspell
#name "Beseech the Lady's Aid"
#descr "The Lady's emissary asks that she intervene in this battle."
#school 0
#researchlevel 5
#effect 43
#damage 10008
#range 0
#nreff 5
#fatiguecost 200
#path 0 7
#path 1 6
#pathlevel 0 2
#pathlevel 1 1
#aoe 5
#restricted 156
#flightspr -1
#explspr 10231
#end

-- Host of the Lady

#newspell
#copyspell "Beseech the Lady's Aid"
#name "Host of the Lady"
#descr "In a time of dire need the Lady commends her knight retainers to the cause of mortal Bretonnians."
#researchlevel 8
#nreff 25
#aoe 25
#fatiguecost 300
#pathlevel 0 4
#pathlevel 1 2
#end

---------------- EVENTS


#newevent
#msg "Bretonnia special mechanics explainer:

Noble Vows. Your Paladins and Lords have a chance each turn to take up the Questing Vow, becoming a Questing Paladin/Lord. Questing Paladins/Lords then have a chance each turn to find the Grail and become a much more powerful Grail Paladin/Lord.

Questing Knights. The smallfolk of Bretonnia are often beset by raiders and fouls beasts, but many Questing Knights travel your lands. Each turn an unforted province you control within your dominion may lose some tax income that turn and gain some unrest, but in return you get one or more Questing Knights.

Pilgrims of the Lady. Each of your temples represents a Grail Chapel dedicated to worship of the Lady. Pilgrims to these locations are common and occasionally they will be inspired to join your forces. The stronger your dominion in the province the more likely it is that a group of Pilgrims or Battle Pilgrims will spawn. Pilgrims are quite weak but numerous, while the less commmon Battle Pilgrims are sacred and of higher quality. This will happen silently, without triggering any message."
#header 2 -- use the first line of the event as the header
#req_owncapital 1
#req_pregame 1 -- only happens before the first turn of the game
#req_fornation 156
#nation 156
#req_unique 1
#rarity 5
#end


---------------- STARTITEM INSURANCE -----------------

#newevent
#msg "give item [Battle Reliquae]"
#notext
#nolog
#rarity 5
#req_targmnr 13717 -- reliquae
#req_targnoitem 909 -- reliquae
#addequip 9
#end

#newevent
#msg "give item [Battle Reliquae]"
#notext
#nolog
#rarity 5
#req_targmnr 13717 -- reliquae
#req_targnoitem 909 -- reliquae
#addequip 9
#end


---- Spawn 1d6 pilgrims at a temple according to dominion *7%

#newevent
#msg "pilgrim event 1"
#notext
#nolog
#req_fullowner 156
#req_domchance 7 -- 7 percent chance per candle
#req_temple 1
#req_fornation 156 -- Bretonnia
#rarity 5
#req_land 1
#nation 156 -- Bretonnia
#1d6units 13686 -- pilgrim
#end

---- Spawn 2d6 pilgrims at a temple according to dominion *3%

#newevent
#msg "pilgrim event 2"
#notext
#nolog
#req_fullowner 156
#req_domchance 3 -- 3 percent chance per candle
#req_temple 1
#req_fornation 156 -- Bretonnia
#rarity 5
#req_land 1
#nation 156 -- Bretonnia
#2d6units 13686 -- pilgrim
#end


---- Spawn 1d3 battle pilgrims at a temple according to dominion *2%

#newevent
#msg "pilgrim event 3"
#notext
#nolog
#req_fullowner 156
#req_domchance 2 -- 2 percent chance per candle
#req_temple 1
#req_fornation 156 -- Bretonnia
#rarity 5
#req_land 1
#nation 156 -- Bretonnia
#1d3units 13685 -- battle pilgrim
#end


---- Spawn 1d3 questing knights who gathered to fight some raiders

#newevent
#msg "A foul rabble of raiders has been causing havoc in this province, preying on the commonfolk and distracting them from their duties. Were they Greenskins, Beastmen, or cowardly brigands? It matters not, as a group of Questing Knights have put them to the sword and now the survivors of that brave band have pledged themselves to your cause."
#req_fullowner 156
#req_fornation 156 -- Bretonnia
#rarity 5
#req_rare 4
#req_nomonster 13684 -- can't happen if there's already a questing knight here
#req_land 1
#req_fort 0
#nation 156 -- Bretonnia
#1d3units 13684 -- q knight
#taxboost -25
#unrest 25
#end


---- Spawn 2d3 questing knights who gathered to fight a beastie

#newevent
#msg "A loathsome beast has emerged from the wilderness and terrorised the peasantry, significantly hampering the collection of taxes. News of its presence quickly drew Questing Knights from the surrounding area and they showed it the valour and might of Bretonnia. The survivors of the terrible battle between man and monster have now pledged themselves to your cause."
#req_fullowner 156
#req_fornation 156 -- Bretonnia
#rarity 5
#req_rare 2
#req_nomonster 13684 -- can't happen if there's already a questing knight here
#req_land 1
#req_fort 0 -- doesn't happen in forted places
#nation 156 -- Bretonnia
#2d3units 13684 -- q knight
#taxboost -50
#unrest 40
#end


---- Spawn 2d3 questing knights and a questing paladin who gathered at a temple following a rumour of the grail

#newevent
#msg "Rumours of an appearance of the Grail have drawn Questing Knights and a Questing Paladin from far and wide to the Grail Chapel in this province. Here they were granted a vision from the Lady instructing them to join your cause and punish the vile enemies of Bretonnia. Rumours of the event spread and have caused the local peasantry to flock to the site in a state of religious fervour, neglecting their duties and causing commotion."
#req_fullowner 156
#req_fornation 156 -- Bretonnia
#rarity 5
#req_rare 1
#req_temple 1
#req_nomonster 13684 -- can't happen if there's already a questing knight here
#req_land 1
#req_owncapital 0 -- can't happen in own capital
#nation 156 -- Bretonnia
#com 13687 -- questing paladin
#2d3units 13684 -- questing knight
#taxboost -25
#unrest 25
#incdom 2
#end


---- Convert a Lord into a Questing Lord

#newevent
#msg "One of your Lords has chosen to take the Questing Vow, setting aside his lordship to pursue the Grail. He is joined in this endeavour by a small group of knights from his wider family who have shared in a vision from the Lady that they may seek the Grail through war against the enemies of Bretonnia."
#req_fullowner 156
#req_fornation 156 -- Bretonnia
#req_targmnr 13696 -- Bretonnian Lord
#rarity 5
#req_rare 4
#req_land 1
#nation 156 -- Bretonnia
#transform 13679 -- Questing Lord
#remount
#2d3units 13684 -- q knight
#req_turn 6
#end


---- Convert a Questing Lord into a Grail Lord

#newevent
#msg "One of your Questing Lords has found the Grail and survived drinking from it. He is now a Grail Lord, a holy warrior and leader amongst the mightiest ever produced by mankind."
#req_fullowner 156
#req_fornation 156 -- Bretonnia
#req_targmnr 13679 -- Questing Lord
#rarity 5
#req_rare 5
#req_land 1
#nation 156 -- Bretonnia
#transform 13698 -- Grail Lord
#remount
#end


---- Convert a Paladin into a Questing Paladin

#newevent
#msg "One of your Paladins has chosen to take the Questing Vow, setting aside his lance and duties to pursue the Grail. He is joined in this endeavour by a small group of knights from his wider family who have shared in a vision from the Lady that they may seek the Grail through war against the enemies of Bretonnia."
#req_fullowner 156
#req_fornation 156 -- Bretonnia
#req_targmnr 13697 -- Paladin
#rarity 5
#req_rare 5
#req_land 1
#nation 156 -- Bretonnia
#transform 13687 -- Questing Paladin
#remount
#2d3units 13684 -- q knight
#req_turn 6
#end


---- Convert a Questing Paladin into a Grail Paladin

#newevent
#msg "One of your Questing Paladins has found the Grail and survived drinking from it. He is now a Grail Paladin, a sacred hero of great power."
#req_fullowner 156
#req_fornation 156 -- Bretonnia
#req_targmnr 13687 -- Questing Paladin
#rarity 5
#req_rare 6
#req_land 1
#nation 156 -- Bretonnia
#transform 13677 -- Grail Paladin
#remount
#end




------------------- DUKE SPAWNING EVENT SETS


-- DUKES - 1000 gold each

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of L'Anquille to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13699 -- Taubert, Duke of L'Anquille
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--weak duke
#3d3units 13670 -- Mounted Knight of the Realm -- avg 6
#5d6units 13666 -- Yeoman -- avg 18
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Gisoreux to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13700 -- Hagen, Duke of Gisoreux
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
-- medium duke
#4d6units 13716 -- Longbowman
#3d3units 13670 -- Mounted Knight of the Realm -- avg 6
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Bastonne to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13701 -- Bohemond, Duke of Bastonne
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--strong duke
#1unit 13673 -- Grail Knight
#1d3units 13673 -- Grail Knight
#2d3units 13684 -- Questing Knight
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Carcassone to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13702 -- Huebald, Duke of Carcassone
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--weak duke
#3d6units 13716 -- Longbowman
#3d6units 13666 -- Yeoman
#4d6units 13663 -- Men-at-Arms (chain)
#4d6units 13664 -- Men-at-Arms (halberd)
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Brionne to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13703 -- Theoderic, Duke of Brionne
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--medium duke
#3d6units 13668 -- Mounted Knight Errant
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Parravon to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13704 -- Cassayon, Duke of Parravon
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--strong duke
#1unit 13672 -- Pegasus Knights
#3d3units 13672 -- Pegasus Knights
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Lyonesse to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13705 -- Adalhard, Duke of Lyonesse
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--weak duke
#2d6units 13716 -- Longbowman
#4d6units 13664 -- Men-at-Arms (halberd)
#4d6units 13671 -- Footed Knight of the Realm
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Artois to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13706 -- Chilfroy, Duke of Artois
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--medium duke
#4d3units 13670 -- Mounted Knight of the Realm
#2d3units 13668 -- Mounted Knight Errant
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Aquitaine to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13707 -- Armand, Duke of Aquitaine
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--strong duke
#4d3units 13670 -- Mounted Knight of the Realm
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Bordelaux to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13708 -- Alberic, Duke of Bordeleaux
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--medium duke
#4d3units 13670 -- Mounted Knight of the Realm
#3d6units 13666 -- Yeoman
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Montfort to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13709 -- Folcard, Duke of Montfort
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--medium duke
#3d6units 13671 -- Footed Knight of the Realm
#4d6units 13663 -- Men-at-Arms (chain)
#5d6units 13665 -- Peasant Bowman
#end

#newevent
#nation 156 -- Bretonnia
#msg "You have successfully entreated the Duke of Quenelles to your cause!"
#rarity 0
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13710 -- Tancred II, Duke of Quenelles
#killcom 13678 -- Entreat Duke
#req_unique 1 -- can only ever happen once
--strong duke
#1unit 13673 -- Grail Knight
#1d3units 13673 -- Grail Knight
#2d3units 13668 -- Mounted Knight Errant
#end


-- DUKES ALL SPAWNED, GRAIL LORD

#newevent
#nation 156 -- Bretonnia
#msg "As all twelve Dukes have already been entreated, your call is answered by a Grail Lord and some of his companions."
#rarity 5
#req_fornation 156
#req_monster 13678 -- Entreat Duke
#com 13698 -- Grail Lord
#killcom 13678 -- Entreat Duke
--about the same as a weak/medium duke
#1unit 13673 -- Grail Knight
#2d3units 13673 -- Grail Knight
#end



--------- HERO EVENTS


-- Spawn King Louen Leoncoeur

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Louen Leoncouer the King of Bretonnia and Duke of Couronne has joined your cause, mounted atop his terrifying Hippogryph 'Beaquis'."
#req_owncapital 1
#req_fornation 156
#nation 156
#com 13690 -- Louen Leoncoeur
#req_nomnr 13690
#req_varzero 208 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 208 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 3
#req_turn 9 -- can't happen for the first 8 turns since he's very strong
#header 2
#end


-- Spawn Mallobaude

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Mallobaude the Black Knight, claimant the the Dukedom of Mousillon has joined your cause. He is accompanied by a small band of Knights Errant stirred by his words."
#req_owncapital 1
#req_fornation 156
#nation 156
#com 13692 -- Mallobaude
#req_nomnr 13692
#4d3units 13668 -- Mounted Knight Errant
#req_varzero 209 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 209 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 3
#req_turn 4
#header 2
#end


-- Spawn Fay Enchantress

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Morgiana the Fay Enchantress has joined your cause."
#req_owncapital 1
#req_fornation 156
#nation 156
#com 13688 -- Fay Enchantress
#req_nomnr 13688
#req_varzero 210 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 210 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 2 -- extremely powerful hero
#req_turn 15
#header 2
#end


-- Spawn Repanse de Lyonesse and Henri le Massif

#newevent
#msg "A pair of unique heroes have joined your cause!

The mighty hero Repanse de Lyonesse the Damsel of War and her faithful champion Henri le Massif have joined your cause, accompanied by a brave and glory-hungry force of Knights Errant."
#req_owncapital 1
#req_fornation 156
#nation 156
#com 13714 -- Repanse de Lyonesse
#req_nomnr 13714
#4d3units 13668 -- Mounted Knight Errant
#com 13715 -- Henri le Massif
#req_unique 1
#rarity 5
#req_rare 3
#req_turn 10 -- she gives you a lot of troops and Henri
#header 2
#end


-- Spawn Green Knight

#newevent
#msg "The immortal Green Knight, known with fear as 'Shaabhekh' in the Beastman tongue, protector of Bretonnia and Champion of the Lady has joined your cause, ready to deliver justice to the filth that besets his fair nation."
#req_owncapital 1
#req_fornation 156
#nation 156
#com 13725
#req_nomnr 13725
#req_unique 1
#rarity 5
#req_rare 2
#req_turn 11 -- not in the first year
#end


------- NAMETYPES

#selectnametype 197
#clear
#addname "Sir Momon"
#addname "Sir Teur de Beaquis"
#addname "Sir Pan de Neux"
#addname "Sir Sinnemon"
#addname "Sir Pappelion"
#addname "Sir Mortecai"
#addname "Sir Alfonse"
#addname "Sir Allebrande"
#addname "Sir Geralt"
#addname "Sir Jaskier"
#addname "Sir Dandelion"
#addname "Sir Robin the Bold"
#addname "Sir Clader"
#addname "Sir Robyn"
#addname "Sir Orwell"
#addname "Sir Chelon"
#addname "Sir Laudon"
#addname "Sir Neune"
#addname "Sir Senne"
#addname "Sir Tetebon"
#addname "Sir Tauberk"
#addname "Sir Derrevin D'algen"
#addname "Sir Artois"
#addname "Sir Larret"
#addname "Sir Darrepin the Brave"
#addname "Sir Chilfroy"
#addname "Sir Bastonne"
#addname "Sir Alberic the Strong"
#addname "Sir Thopas"
#addname "Sir Savaric"
#addname "Sir Thiemar"
#addname "Sir Huebald the Pure"
#addname "Sir Ronsald"
#addname "Sir Hagen of Gisorin"
#addname "Sir Gisoreu"
#addname "Sir Leobas III"
#addname "Sir Gaston"
#addname "Sir Folcard the Fast"
#addname "Sir Folcan"
#addname "Sir Thrallavil"
#addname "Sir Emmerin"
#addname "Sir Cassyon of D'anquin"
#addname "Sir Este"
#addname "Sir Tancred II"
#addname "Sir Renart"
#addname "Sir Notker"
#addname "Sir Cuile II"
#addname "Sir Aiden"
#addname "Sir Aigulf"
#addname "Sir Bertelis of Anquilles"
#addname "Sir Carloman"
#addname "Sir Chrode"
#addname "Sir Chromus the Spoiled"
#addname "Sir Ferragus of Montfort"
#addname "Sir Hrodbert"
#addname "Sir Jacen III"
#addname "Sir Louis IV"
#addname "Sir Merovech"
#addname "Sir Meron"
#addname "Sir Odon the Swift"
#addname "Sir Orderic"
#addname "Sir Panteleon"
#addname "Sir Piers the Furious"
#addname "Sir Redemund"
#addname "Sir Roland"
#addname "Sir Suidbert"
#addname "Sir Theudis II"
#addname "Sir Waldon"
#addname "Sir Chamignon of Brien"
#addname "Sir Bastond"
#addname "Sir Farabus"
#addname "Sir Balduin the Enduring"
#addname "Sir Landuin"
#addname "Sir Thierulf"
#addname "Sir Marcus the Clean"
#addname "Sir Lambard"
#addname "Sir Agilgar"
#addname "Sir Martrud the Sixth"
#addname "Sir Beren"
#addname "Sir Corduin"
#addname "Sir Florin the Courteous"
#addname "Sir Virun the Eager"
#addname "Sir Baren the Long"
#addname "Sir Thaven"
#addname "Sir Melien the Courageous"
#addname "Sir Belir"
#addname "Sir Lynar the Short"
#addname "Sir Arthar"
#addname "Sir Medriq"
#addname "Sir Adalman the Softsword"
#addname "Sir Bertman"
#addname "Sir Baldger the Foolish"
#addname "Sir Amalmund"
#addname "Sir Theudmund the Emphatic"
#addname "Sir Sigiger the Lancer"
#addname "Sir Baldmund"
#addname "Sir Faustman the Double-Minded"
#addname "Sir Amger"
#addname "Sir Chlodmund III"
#addname "Sir Amric of D'anquille"
#addname "Sir Ageric"
#addname "Sir Arnold the Raging"
#addname "Sir Baudry"
#addname "Sir Beroic"
#addname "Sir Childeric"
#addname "Sir Durand the Wise"
#addname "Sir Egide"
#addname "Sir Euric" -- 90
#addname "Sir Griffon the Wild"
#addname "Sir Otto"
#addname "Sir Reginar"
#addname "Sir Tassilo"
#addname "Sir Lambert"
#addname "Sir Hartmut"
#addname "Sir Sichar"
#addname "Sir Sigefroy"
#addname "Sir Waleran"
#addname "Sir Wulfhard" --100 names
#addname "Sir Bresom the Great"
#addname "Sir Trum of A'nator"
#addname "Sir Stavis"
#addname "Sir Rond of R'donj"
#addname "Sir Ardio the Star"
#addname "Sir Calchet the Artistic"
#addname "Sir Lamal the Beast"
#addname "Sir Leonz the Helpful"
#addname "Sir Arariq the Skilled"
#addname "Sir Stamp the Linquistic"
#addname "Sir Ronald"
#addname "Sir Percival of Lyonnesse"
#addname "Sir Balgar of Carcassonne"
#addname "Sir Fracasse Langoustine"
#addname "Sir Beliguf Fearnought"
#addname "Sir Agilulf of Montfort"
#addname "Sir Gurdilloue of Bordeleaux"
#addname "Sir Fredemund of Quenelles" --118 names
#addname "Sir Malfleur the Cruel"
#addname "Sir Louis of Arduix"
#addname "Sir Landuin of Parravon"
#addname "Sir Thieruf of Gisoreux"
#addname "Sir Guillaume of Artois"
#addname "Sir Henri of Aquitaine"
#addname "Sir Baudoin of L'anquille"
#addname "Sir Melmon of Brionne"
#addname "Sir Jules of Bastonne"
#addname "Sir Philippe of Couronne"
#addname "Sir Ricard of Lyonesse"
#addname "Sir Charlen" --130 names
#addname "Sir Butte of Bot"
#addname "Sir Flame the Bold"
#addname "Sir Mooq the Vigilant"
#addname "Sir Anglie the Ant King"
#addname "Sir Mu of the Ruby"
#addname "Sir Lucide the Tactician"
#addname "Sir Maerlande the Goat"
#end




------ SITES

#newsite 2051
#name "The Sacred Lake"
#path 2
#level 0
#rarity 5
#gems 2 1
#gems 1 1
#gems 6 1
#gems 7 1
#homecom 13683 -- Grail Prophetess
#end

#newsite 2052
#name "The Cathedral of the Grail"
#path 9
#level 0
#rarity 5
#gems 4 1
#homecom 13678 -- Entreat Duke
#homemon 13673 -- Grail Knight
#end

--- Future sites to preview stuff

#newsite 2106
#name "Bretonnian Dukes"
#path 9 -- holy
#level 0
#rarity 5
#homecom 13699 -- Duke Taubert of L'Anguille
#homecom 13700 -- Duke Hagen of Gisoreux (medium)
#homecom 13701 -- Duke Bohemond of Bastonne (strong)
#homecom 13702 -- Duke Huebald of Carcassonne (weak)
#homecom 13703 -- Duke Theodoric of Brionne (medium)
#homecom 13704 -- Cassayon the Duke of Parravon
#homecom 13705 -- Adalhard the Duke of Lyonesse (weak)
#homecom 13706 -- Chilfroy the Duke of Artois (medium)
#homecom 13707 -- Armand the Duke of Aquitaine (Strong - due to onebattlespell)
#homecom 13708 -- Alberic the Duke of Bordeleaux (medium)
#homecom 13709 -- Folcard the Duke of Montfort (medium)
#homecom 13710 -- Tancred II the Duke of Quenelles (strong)
#homecom 13698 -- Grail Lord
#end

#newsite 2107
#name "Paladin and Lord Upgrades"
#path 9 -- holy
#level 0
#rarity 5
#homecom 13687 -- questing paladin
#homecom 13677 -- grail paladin
#homecom 13679 -- Questing Lord
#homecom 13698 -- Grail Lord
#end

#newsite 2108
#name "Bretonnian Summons and Freespawn"
#path 9 -- holy
#level 0
#rarity 5
#homemon 13712 -- Shepherdess
#homemon 13686 -- pilgrim
#homemon 13685 -- battle pilgrim
#homemon 13684 -- questing knight
#homemon 13689 -- guardian spirit
#homemon 10008 -- Son of Bretonnia
#end

#newsite 2109
#name "Bretonnian Multiheroes"
#path 4 -- astral
#level 0
#rarity 5
#homecom 13693 -- grail lord on hippogryph
#homecom 13683 -- Grail Prophetess
#end

#newsite 2110
#name "Bretonnian Luck-independent Heroes"
#path 1 -- air
#level 0
#rarity 5
#homecom 13690 -- Louen Leoncoeur
#homecom 13692 -- Mallobaude
#homecom 13688 -- Fay Enchantress
#homecom 13714 -- Repanse de Lyonesse
#homecom 13715 -- Henri Le Massif
#homecom 13725 -- green knight
#end


--------- NATION

#selectnation 156
#name "Bretonnia"
#epithet "Knights of the Grail"
#era 2
#idealcold 0
#brief "Bretonnia is a feudal kingdom of peasants ruled over by a warrior class of knights at the behest of mysterious and magically powerful Grail Damsels."
#descr "Bretonnia, like the Empire, was once a land where primitive human tribes fought over resources and lived in fear of Greenskins and monsters. This changed when the Bretonni tribe were blessed by the attentions of the mysterious Lady of the Lake who granted guiding visions the power of a holy Grail to a noble by the name of Gilles. Gilles gathered a group of knights known as the Grail Companions at his side and together they united the humans east of the Grey Mountains and forged a nation, defeating countless enemies of man. With the help of emissaries of the Lady the nation of Bretonnia established a strict social hierarchy of peasants sworn to obey a warrior class of peerless knights who in turn swore fealty to Lords, who served Dukes, who served the King. Bretonnia is a superstitious land with largely illiterate commonfolk and is somewhat mistrustful of outsiders, but produces excellent mounted warriors and can rely on both a devout population and the assistance of magically powerful Grail Damsels who serve the Lady."
#summary "Race: Humans
Military: Expendable peasants, powerful heavy cavalry including flying pegasus knights and sacred Grail Knights. Cannot recruit mercenaries
Magic: Nature, Water, and Glamour with minor Astral
Priests: Powerful, may be protected by Guardian Spirits
Mechanics: Pilgrims gather at temples according to dominion strength"
#flag "Warhammer_Bretonnia/Bretonnia_Flag.tga"
#templepic 10 -- forest
#labcost 800 -- +200
#templecost 500 -- -100
#color 0.5 0.8 0.3
#moreprod -1
#moreorder 1

#guardspirit 13689 -- Guardian Spirit Knight

---- PRETENDER SETTINGS

#addgod 138 -- gorgon
#addgod 157 --Mother of Monsters
#addgod 158 -- oracle
#addgod 216 -- red dragon
#addgod 265 -- blue dragon
#addgod 266 -- green dragon
#addgod 249 --Crone
#addgod 215 --Virtue
#addgod 401 --Bitch Queen
#addgod 472 -- statue of order
#addgod 485 --Great Enchantress
#addgod 600 --Titan of War and Wisdom
#addgod 608 -- phoenix
#addgod 606 --Great Mother
#addgod 657 -- monolith
#addgod 862 --Vampire Queen
#addgod 1098 --Asynja (warrior)
#addgod 1231 --Draikana
#addgod 1342 --Titan of Rivers
#addgod 1343 --Titan of Love
#addgod 1370 --Volla of the Beautiful Forest
#addgod 1374 --Annunaki of the Morning Star
#addgod 1905 --Great Sorceress
#addgod 2138 --Sphinx
#addgod 2239 --Asynja
#addgod 2435 --Annunaki of Love and War
#addgod 2785 -- solar eagle
#addgod 2786 -- celestial gryphon
#addgod 2797 -- hieracosphinx
#addgod 2851 -- titan of winds and waves
#addgod 2922 -- morgen high queen
#addgod 3076 -- morrigna (trinity)
#addgod 3082 -- matrona of the healing spring
#addgod 3086 -- deives of the sun
#addgod 3203 -- titan of the hunt
#addgod 3204 -- the grey one
#addgod 3205 -- titan of the crossroads
#addgod 3208 -- titan of the spring
#addgod 3209 -- titan of growth
#addgod 3369 -- ilhat of fate
#addgod 3370 -- ilhat of might
#addgod 3641 -- earth dragon
#addgod 3710 -- air dragon


---- RECRUITS

#addrecunit 13664 -- Men-at-Arms (halberd)
#addrecunit 13666 -- Yeoman
#addrecunit 14076 -- yeoman morningstar
#addrecunit 13716 -- Longbowman
#addrecunit 13667 -- Mounted Yeoman
#addrecunit 13685 -- Battle Pilgrim
#addrecunit 13669 -- Footed Knight Errant
#addrecunit 13671 -- Footed Knight of the Realm
#addrecunit 13668 -- Mounted Knight Errant
#addrecunit 13670 -- Mounted Knight of the Realm
#addrecunit 13672 -- Pegasus Knights
--addrecunit 13684 -- questing knight
--addrecunit 13673 -- Grail Knight


---- LEADERS

#addreccom 13675 -- Yeoman Outrider
#addreccom 13676 -- Courtier
#addreccom 13697 -- Paladin
#addreccom 13696 -- Lord
#addreccom 13680 -- Lord on Pegasus
#addreccom 13728 -- Grail Maiden
#addreccom 13682 -- Grail Damsel
--addreccom 13692 -- Mallobaude
--addreccom 13690 -- King Louen
--addreccom 13688 -- Fay Enchantress
--addreccom 13714 -- Repanse de Lyonesse

#addforeignunit 13662 -- Men-at-Arms (leather)
#addforeignunit 13663 -- Men-at-Arms (chain)
#addforeignunit 13665 -- Peasant Bowman
#addforeignunit 13666 -- Yeoman
#addforeignunit 13667 -- Mounted Yeoman
#addforeigncom 13675 -- Yeoman Outrider
#addforeigncom 13711 -- Shepherdess commander
#addforeigncom 13728 -- Grail Maiden
#addforeigncom 13717 -- Reliquae shape with 7 crew

----- HEROES

#multihero1 13693 -- grail lord on hippogryph
#multihero2 13683 -- Grail Prophetess

----- STARTSITES

#startsite "The Sacred Lake"
#startsite "The Cathedral of the Grail"

------ FUTURESITES

#futuresite 2106 -- Bretonnian Dukes
#futuresite 2107 -- Paladin and Lord Upgrades
#futuresite 2108 -- Bretonnian Freespawn
#futuresite 2109 -- Bretonnian Multiheroes
#futuresite 2110 -- Bretonnian Luck-independent Heroes



----- FORTS

#fortera 2

----- Mercs

#merccost 999


------- PROVINCE DEFENCE

--Sets the units to be used in province defense.

#defcom1 13670 -- Mounted Knight of the Realm
#defcom2 13696 -- Lord

#defunit1 13662 -- Men-at-Arms (leather)
#defunit1b 13665 -- Peasant Bowman
#defunit1c 13663 -- Men-at-Arms (chain)
#defunit2 13671 -- Footed Knight of the Realm
#defunit2b 13670 -- Mounted Knight of the Realm

--Sets how many of the units to appear per 10 points.

#defmult1 10
#defmult1b 20
#defmult1c 20
#defmult2 15
#defmult2b 10

-------- Wall defenders

#wallcom 13666 -- Yeomen infantry -- just a guy to be the commander
#wallunit 13716 -- Longbowman
#wallmult 10 -- standard

#guardcom 13696 -- Lord
#guardunit 13663 -- Men-at-Arms (chain)
#guardmult 10



------- STARTING UNITS

#startcom 13696 -- Lord
#startscout 13675 -- Yeoman Outrider
#startunittype1 13668 -- Mounted Knight Errant
#startunitnbrs1 10
#startunittype2 13666 -- Yeomen infantry
#startunitnbrs2 15
#end


--  Chaos Dwarfs


----------------- ITEMS


---- Mask of the Executioner

#selectitem 913
#name "Mask of the Executioner"
#descr "Shar'Tor's mask is ambued with malign spirits which he unleashes upon his foes in battle, slaying them with a single utterance."
#spr "Warhammer_Chaos_Dwarfs/Item_Mask.tga"
#type 6
#cursed
#nofind
#armor 994
#end


----------------- EQUIPMENT

-------- New Weapons


-- Varies for montags

#newweapon 1954
#name "Varies"
#dmg 6
#len 1
#rcost 0
#slash
#pierce
#blunt
#end


--- Flung scrap -- same as Ogre Kingdoms one

#newweapon 1936
#name "Flung Scrap"
#dmg -3
#att -2
#ammo 30
#range -1
#nratt 1
#flyspr 111 1
#rcost 0
#pierce
#slash
#ironweapon
#end

--- Ogre smash -- same as Ogre Kingdoms one

#newweapon 1937
#name "Ogre Smash"
#dmg -1
#att -1
#def -1
#len 0
#rcost 0
#bonus
#charge
#blunt
#end

--- Mechanical Hammer

#newweapon 1938
#copyweapon 115 -- dwarven hammer
#att 1 -- +1
#def 1 -- +2
#nratt 2 -- fast due to mech
#end

--- Will of Hashut

#newweapon 1901
#name "Will of Hashut"
#magic
#norepel
#unrepel
#aoe 4
#bonus
#internal
#friendlyimmune
#inanimateimmune
#undeadimmune
#mind
#mrnegates
#nostr
#armornegating
#dmg 10
#end

--- Darktide Axe

#newweapon 1902
#copyweapon 259 -- executioners axe
#name "Darktide Axe"
#magic
#dmg 14 -- +4
#att 3 -- +2
#def 1 -- +1
#len 3 -- +1
#end

--- Forge Hammer

#newweapon 1903
#copyweapon 648 -- Enchanted hammer
#name "Forge Hammer"
#rcost 9
#secondaryeffect 221 -- magic fire like flambeau
#end

-- Slaver whip

#newweapon 1904
#name "Slaver Whip"
#dmg -1
#att 1
#def 0
#len 4
#rcost 1
#sound 9 -- whip
#nratt 1
#end

--- Flames of Hashut

#newweapon 1905
#copyweapon 383 -- throw flames
#name "Flames of Hashut"
#dmg -2
#nratt 2
#range 30
#ammo 8
#end

--- Chaos Dwarf Axe

#newweapon 1906
#copyweapon 17 -- Axe
#name "Quality Axe"
#rcost 3 -- triple normal
#att 1 -- +1
#def 0 -- +1
#end

--- Chaos Dwarf Battleaxe

#newweapon 1978
#copyweapon 18 -- Battleaxe
#name "Quality Battleaxe"
#rcost 7 -- double normal and +1
#att 2 -- +1
#def 1 -- +1
#end

--- Mastercrafted Axe

#newweapon 1907
#copyweapon 17 -- Axe
#name "Mastercrafted Axe"
#rcost 5 -- 5x normal normal
#dmg 9 -- +1
#att 1 -- +2
#def 0 -- +1
#end

--- Wolf Bite

#newweapon 1908
#copyweapon 19 -- bite
#name "Wolf Bite"
#dmg 12
#end

--- Blunderbuss

#newweapon 1910
#name "Blunderbuss"
--ammo 5
#ammo 1
#att 0
#armorpiercing
#dmg 6
#flyspr 109 1
#nostr
#nratt 12
#range 7
#rcost 9
#sound 25
#flyspr 111 1
#pierce
#ironweapon
#end

--- Chaos Dwarf Steel Crossbow

#newweapon 1911
#copyweapon 463 -- Agarthan Steel Crossbow
#name "Quality Crossbow"
#ammo 12 -- same
#att 3 -- +1
#armorpiercing -- same
#dmg 10 -- same
#bowstr -- same
#nratt -2 -- same
#range 40 -- same
#rcost 7 -- same
#end

--- Fireglaive

#newweapon 1912
#copyweapon 308 -- Glaive
#name "Fireglaive"
#rcost 7
#secondaryeffectalways 1913 -- Fireglaive Gout
#def 0 -- usually 1
#dmg 8 -- -2
#end

--- Fireglaive Gout

#newweapon 1913
#copyweapon 171 -- small area fire
#name "Fireglaive Gout"
#aoe 2 -- usually 1
#dmg 5 -- otherwise it's 14
#end

--- Forge Axe

#newweapon 1914
#copyweapon 17 -- Axe
#name "Forge Axe"
#rcost 9
#magic -- clearly
#secondaryeffect 221 -- magic fire like flambeau
#end

--- Hobgoblin gitknife

#newweapon 1915
#copyweapon 126 -- poison dagger
#name "Gitknife"
#secondaryeffect 50 -- weak poison
#dmg 0 -- -2
#armorpiercing
#end



-------- Borrowed Armour


--- Ogre gutplate -- copied over from Ogre Kingdoms

#newarmor 998
#copyarmor 9 -- plate cuirass
#name "Gutplate"
#type 5
#prot 9
#def 0
#enc 0
#rcost 7
#end


-------- New Armour

--- Dwarf Full Scale Mail

#newarmor 995
#copyarmor 17 -- full scale mail
#name "Quality Full Scale Mail"
#def -1 -- better by 1
#enc 3 -- same
#prot 16 -- +1
#rcost 16 -- +4
#end

--- Dwarf Scale Mail Hauberk

#newarmor 996
#copyarmor 12 -- scale mail hauberk
#name "Quality Scale Mail Hauberk"
#def 0 -- better by 1
#enc 2 -- same
#prot 14 -- +1
#rcost 12 -- +3
#end

--- Dwarf Scale Mail Cuirass

#newarmor 997
#copyarmor 7 -- scale mail cuirass
#name "Quality Scale Mail Cuirass"
#def 0 -- better by 1
#enc 1 -- same
#prot 11 -- +1
#rcost 9 -- +3
#end

--- Infernal Full Plate

#newarmor 990
#copyarmor 215 -- Full Plate of Ulm
#name "Infernal Full Plate"
#rcost 34 -- +6
#magicarmor
#end

--- Ogre slaves iron muzzle

#newarmor 991
#copyarmor 20 -- Iron cap
#name "Iron Muzzle"
#prot 10
#end

--- Golden Immortal Plate

#newarmor 992
#copyarmor 19 -- Full Plate Mail
#name "Golden Immortal Plate"
#enc 4
#rcost 34 -- it's very overwrought
#magicarmor
#end

--- Daemonsmith Scale Mail

#newarmor 993
#copyarmor 215 -- Full Plate of Ulm
#name "Daemonsmith Scale Mail"
#rcost 26
#def -2
#enc 3
#prot 19
#magicarmor
#end

--- Mask of the Executioner

#newarmor 994
#copyarmor 40 -- blacksteel helmet
#name "Mask of the Executioner"
#end



----------------- MONSTERS


-------- Recruits


---- Chaos Dwarf Warrior

#newmonster 18100
#spr1 "Warhammer_Chaos_Dwarfs/Warrior.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Warrior2.tga"
#name "Chaos Dwarf Warrior"
#descr "Chaos Dwarf society is strictly heirarchical with many tiers of ascending power and diminishing size, mirroring the mighty ziggurats that dominate their homeland. Amongst Chaos Dwarfs the Warrior caste is a position of middling importance, holding status above craftsmen and civilians, but well below smiths or inductees into cult of Hashut. Still, Warriors are invaluable as it is they who venture forth to conquer and enslave, feeding the endless hunger of their society for disposable labour. Like all Dwarfs they are hardy and resolute fighters unlikely to suffer the dishonour of fleeing, and very well armed and armoured. Chaos Dwarfs are resistant to magic, but not to the extent of their Western cousins, though they are equally disciplined and tireless marchers."
#hp 13 --- toughness 4
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 11 --- they have very slightly better magic res than normal, but they aren't like regular dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 11 --- slightly stronger than human
#att 11 --- weaponskill 4, but initiative 2
#def 10 --- weaponskill 4, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 10 --- set to get combat speed to 6
#gcost 15
#rpcost 21 --- They need to have order scales
#rcost 1
#armor 118 -- Half Helmet
#armor 995 -- dwarf full scale mail
#armor 2 -- basic shield
#weapon 1906 -- chaos dwarf axe
#maxage 500
#startage 150
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#neednoteat
#appetite 1
#magicboost 9 -5
#magicboost 53 -5
#end


---- Chaos Dwarf Blunderbuss

#newmonster 18101
#spr1 "Warhammer_Chaos_Dwarfs/Blunderbuss.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Blunderbuss2.tga"
#name "Chaos Dwarf Blunderbuss"
#descr "The Chaos Dwarfs have created a great many weapons of war, with most being as cruel and dangerous as their makers. The best known of these and most widely used amongst their kind is the blunderbuss, a vicious device capable of belching forth a hail of stone or metal shards. The exact alchemical formula used to create the explosive black tar used to propel this flesh-shredding shrapnel is a closely guarded secret, though the Chaos Dwarfs have been known to sell barrels of it to ogre warbands in exchange for slaves. The blunderbuss is best used against packed formations of lesser enemies, particularly those that lack shields or decent armour, as it is neither accurate nor long ranged. Unlike the archers of weaker nations, the Chaos Dwarfs entrusted with these weapons are well armoured and capable melee fighters. Each blunderbuss may only be fired once. Chaos Dwarfs are resistant to magic, but not to the extent of their Western cousins, though they are equally disciplined and tireless marchers."
#hp 13 --- toughness 4
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 11 --- they have very slightly better magic res than normal, but they aren't like regular dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 11 --- slightly stronger than human
#att 11 --- weaponskill 4, but initiative 2
#def 10 --- weaponskill 4, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 9 --- set to get combat speed to 6
#gcost 18
#rpcost 28 --- They need to have order scales
#rcost 1
#armor 995 -- dwarf full scale mail
#armor 118 -- Half Helmet
#weapon 253 -- hatchet
#weapon 1910 -- blunderbuss
#maxage 500
#startage 150
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#neednoteat
#appetite 1
#end


---- Chaos Dwarf Crossbow

#newmonster 18102
#spr1 "Warhammer_Chaos_Dwarfs/Crossbow.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Crossbow2.tga"
#name "Chaos Dwarf Crossbowman"
#descr "The crossbow is a traditional weapon of war for all dwarfs, and the Chaos Dwarfs are no exception in this regard. No matter what hideously destructive devices the Daemonsmiths, metalworkers, or alchemists create in the hellish forges of Zharr Naggrund, none will ever truly replace the crossbow. Much like their cousins to the west the children of Hashut regard the crossbows made by lesser races with contempt, for theirs are of considerably better craftsmanship and can propel heavier bolts just as far. Chaos Dwarf crossbowmen wear slightly lighter armour than their comrades and favour traditional hats with more fabric and less iron, as they are more likely to have to stand watch over slaves for prolonged periods and as such do make certain concessions to comfort. Chaos Dwarfs are resistant to magic, but not to the extent of their Western cousins, though they are equally disciplined and tireless marchers."
#hp 13 --- toughness 4
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 11 --- they have very slightly better magic res than normal, but they aren't like regular dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 11 --- slightly stronger than human
#att 11 --- weaponskill 4, but initiative 2
#def 10 --- weaponskill 4, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 8 --- set to get combat speed to 6
--gold 1 --- this is to make upkeep much lower which then makes dwarf lives more precious
#gcost 16
#rpcost 21 --- They need to have order scales
#rcost 1
#armor 996 -- dwarf scale mail hauberk
#armor 20 -- Iron Cap
#weapon 253 -- hatchet
#weapon 1911 -- chaos dwarf crossbow
#maxage 500
#startage 150
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#neednoteat
#appetite 1
#end


---- Infernal Guard

#newmonster 18103
#spr1 "Warhammer_Chaos_Dwarfs/Infernal_Guard.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Infernal_Guard2.tga"
#name "Infernal Guard"
#descr "So strict is Chaos Dwarf society that to deviate even fractionally from the established norms is to invite condemnation and censure of the most brutal kind. Even happening to serve under a Sorcerer Lord whose relentless ambition has caused him to fall out of favour with his peers may be enough to condemn a warrior to a fate worse than death. Chaos Dwarfs who are dishonoured are stripped of their identity and banished to the ranks of the Infernal Guard. From here on they have no status and are mourned as if dead by their clan, their names struck from all record, and their faces sealed behind faceless helms, heated until glowing red before being seared directly to flesh. The Infernal Guard have no lives save battle and no hope but to somehow lessen the shame they have brought to their clan through near suicidal bravery in war. These heavy infantry wear armour forged by the Daemonsmiths to provide extreme protection and enchanted to resist fire. Even amongst the Chaos Dwarfs they are known to be particularly resistant to magic. Members of the Infernal Guard can only be recruited when a Daemonsmith is present.

[Requires a Daemonsmith present to recruit]"
#hp 14 --- toughness 4, description makes them sound even tougher
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 18 --- leadership 10 and immune to psychology
#mr 12 --- better mr than most chaos dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 12 --- str 4
#att 11 --- weaponskill 4, but initiative 2
#def 10 --- weaponskill 4, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 11 --- set to get combat speed to 6
#gcost 25
#rpcost 21 --- They need to have order scales
#rcost 1
#armor 990 -- infernal full plate
#armor 21 -- Full Helmet
#armor 2 -- Shield
#weapon 1906 -- chaos dwarf axe
#maxage 500
#startage 150
#mountainsurvival
#wastesurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#fireres 5
#monpresentrec 18133 -- Daemonsmith
#neednoteat
#appetite 1
#end


---- Infernal Fireglaive

#newmonster 18104
#spr1 "Warhammer_Chaos_Dwarfs/Infernal_Fireglaive.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Infernal_Fireglaive2.tga"
#name "Infernal Fireglaive"
#descr "So strict is Chaos Dwarf society that to deviate even fractionally from the established norms is to invite condemnation and censure of the most brutal kind. Even happening to serve under a Sorcerer Lord whose relentless ambition has caused him to fall out of favour with his peers may be enough to condemn a warrior to a fate worse than death. Chaos Dwarfs who are dishonoured are stripped of their identity and banished to the ranks of the Infernal Guard. From here on they have no status and are mourned as if dead by their clan, their names struck from all record, and their faces sealed behind faceless helms, heated until glowing red before being seared directly to flesh. The Infernal Guard have no lives save battle and no hope but to somehow lessen the shame they have brought to their clan through near suicidal bravery in war. These heavy infantry wear armour forged by the Daemonsmiths to provide extreme protection and enchanted to resist fire. Even amongst the Chaos Dwarfs they are known to be particularly resistant to magic. The Fireglaive is a hellish weapon used exclusively by the Infernal Guard; a hollow-tubed polearm which issues forth gouts of flame at the twist of a handle. Members of the Infernal Guard can only be recruited when a Daemonsmith is present.

[Requires a Daemonsmith present to recruit]
[Recruitment limited to 3 per month]"
#hp 14 --- toughness 4, description makes them sound even tougher
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 18 --- leadership 10 and immune to psychology
#mr 12 --- better mr than most chaos dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 12 --- str 4
#att 11 --- weaponskill 4, but initiative 2
#def 10 --- weaponskill 4, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 10 --- set to get combat speed to 6
#gcost 40
#rpcost 21 --- They need to have order scales
#rcost 1
#armor 990 -- infernal full plate
#armor 21 -- Full Helmet
#weapon 1912 -- fireglaive
#maxage 500
#startage 150
#mountainsurvival
#wastesurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#fireres 5
#monpresentrec 18133 -- Daemonsmith
#neednoteat
#appetite 1
#reclimit 3
#end


---- Infernal Guard Chosen

#newmonster 18105
#spr1 "Warhammer_Chaos_Dwarfs/Infernal_Chosen.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Infernal_Chosen2.tga"
#name "Infernal Chosen"
#descr "While the vast majority of the Infernal Guard were condemned to service by their peers for public dishonour or a dramatic fall in the fortunes of their master, there are a rare few who join of their own volition. These are Dwarfs who cannot stand some secret shame, some stain to their honour which they can neither repair nor abide, even if it is known only to them. For these Dwarfs there is no choice but to join, for in Chaos Dwarf society even death is no escape from true dishonour, unless of course that death is found in the anonymous ranks of the Infernal Guard. The Chosen are stripped of their identity and sealed in their armour just like the condemned, but unlike their fellows their sacrifice is honoured by the Horns of Hashut on their helms, and they are armed with a pair of glowing forge axes fashioned by the Daemonsmiths to sear the foe with every slash. Members of the Infernal Guard can only be recruited when a Daemonsmith is present. While the Chosen are merely respected for their commitment to ending their dishonor rather than being sacred, their upkeep is halved by contributions from the priesthood.

[Requires a Daemonsmith present to recruit. Halved gold upkeep]
[Recruitment limited to 1 per month]"
#hp 14 --- toughness 4, description makes them sound even tougher
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 18 --- leadership 10 and immune to psychology
#mr 12 --- better mr than most chaos dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 12 --- str 4
#att 11 --- weaponskill 4, but initiative 2
#def 10 --- weaponskill 4, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 10 --- set to get combat speed to 6
#gcost 50
#addupkeep -25
#rpcost 21 --- They need to have order scales
#rcost 1
#armor 990 -- infernal full plate
#armor 21 -- Full Helmet
#weapon 1914 -- forge axe
#weapon 1914 -- forge axe
#ambidextrous 2
#maxage 500
#startage 150
#mountainsurvival
#wastesurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#fireres 5
#reclimit 1 -- they are very rare
#monpresentrec 18133 -- Daemonsmith
#neednoteat
#appetite 1
#end


---- Bull Centaur

#newmonster 18106
#spr1 "Warhammer_Chaos_Dwarfs/Bull_Centaur.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Bull_Centaur2.tga"
#name "Bull Centaur"
#descr "Bull Centaurs are creatures with the upper torso of a Chaos Dwarf but the body of a ferocious bull. Many centuries ago, when their kind was first twisted by Chaos, some Chaos Dwarfs were transformed into Bull Centaurs, creating a revered subrace of fast moving warriors. Since those days the Bull Centaurs have guarded the great temples of Hashut and the central Tower of Zharr-Naggrund. They are as keen witted as any of their cousins and completely devoted to service of Hashut, Father of Darkness. The Bull Centaurs are trusted by the Sorcerer caste to remain loyal at all times to Zharr-Naggrund and above the schemes of the many ambitious rivals vying for power. As temple guardians and beings clearly touched by Hashut the Bull Centaurs are considered sacred to the Chaos Dwarfs."
#hp 27 --- toughness 4, wounds 2, size 3
#size 5 --- cavalry sized
#prot 4 --- toughness 4, size 3
#mor 14 --- leadership 9, mention of how loyal they are
#mr 12 --- slightly better magic res than normal CD
#enc 2 --- Dwarfs are known for their stamina
#str 14 --- same as white centaur
#att 11 --- weaponskill 4, initiative 3
#def 11 --- weaponskill 4, initiative 3
#prec 10 --- ballistic skill 3
#mapmove 22 -- same as centaurs because, though they're slower, they're better marchers
#ap 26 --- move 8, but stubby legs (normal centaur has 30)
#gcost 65 -- (white centaur is 55)
#rpcost 33 --- pretty rare dudes (white centaur is 29)
#rcost 1
#armor 118 -- Half Helmet
#armor 996 -- dwarf scale mail hauberk
#weapon 1978 -- two handed dwarf battleaxe
#weapon 55 -- hoof ala centaurs
#maxage 1000 -- double the age of chaos dwarfs
#startage 350
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#neednoteat
#appetite 2
#holy
#mountedhumanoid -- the value to use for centaurs
#end


---- Hobgoblin Archer

#newmonster 18107
#spr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Archer.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Archer2.tga"
#name "Hobgoblin Archer"
#descr "Hobgoblins are a subrace of greenskins closely related to the more widespread orcs and goblins. Though not nearly so strong, tough, or aggressive as orcs, they are larger and stronger than goblins and make better fighters. In terms of mindset they are far closer to goblins than orcs, though arguably even sneakier and less trustworthy. Centuries ago the Chaos Dwarfs faced the largest slave uprising in their history and stood on the brink of defeat at the hands of a massive greenskin force which had taken most of Zharr-Naggrund, but at the last moment the hobgoblins, fearing the cruelty of the Chaos Dwarfs more than the brutality of the orcs, switched sides. Since that time the Hobgoblins have been cast out of greenskin society and, while they have risen from the position of slaves to menial servants, they are almost entirely reliant on the protection of their masters. Hobgoblins favour a cautious fighting style, using spears or bows to keep their foe at bay, or launching sneak attacks when their target isn't looking."
#hp 8 --- toughness 3, but smaller than human
#size 3 --- they aren't goblins
#prot 0 --- toughness 3, size 2
#mor 8 --- leadership 6, mention of how cowardly they are
#mr 10 --- normal
#enc 3 --- normal
#str 8 --- smaller than humans, str 3
#att 10 --- weaponskill 3, initiative 2
#def 9 --- weaponskill 3, initiative 2
#prec 10 --- ballistic skill 3
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 7
#rpcost 6 --- reduced
#rcost 1
#weapon 23 -- normal short bow
#weapon 9 -- dagger
#armor 120 -- leather cap
#armor 10 -- leather hauberk
#mountainsurvival
#stealthy 10
#darkvision 50
#end


---- Hobgoblin Spearman

#newmonster 18108
#spr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Spear.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Spear2.tga"
#name "Hobgoblin Spearman"
#descr "Hobgoblins are a subrace of greenskins closely related to the more widespread orcs and goblins. Though not nearly so strong, tough, or aggressive as orcs, they are larger and stronger than goblins and make better fighters. In terms of mindset they are far closer to goblins than orcs, though arguably even sneakier and less trustworthy. Centuries ago the Chaos Dwarfs faced the largest slave uprising in their history and stood on the brink of defeat at the hands of a massive greenskin force which had taken most of Zharr-Naggrund, but at the last moment the hobgoblins, fearing the cruelty of the Chaos Dwarfs more than the brutality of the orcs, switched sides. Since that time the Hobgoblins have been cast out of greenskin society and, while they have risen from the position of slaves to menial servants, they are almost entirely reliant on the protection of their masters. Hobgoblins favour a cautious fighting style, using spears or bows to keep their foe at bay, or launching sneak attacks when their target isn't looking."
#hp 8 --- toughness 3, but smaller than human
#size 3 --- they aren't goblins
#prot 0 --- toughness 3, size 2
#mor 8 --- leadership 6, mention of how cowardly they are
#mr 10 --- normal
#enc 3 --- normal
#str 8 --- smaller than humans, str 3
#att 10 --- weaponskill 3, initiative 2
#def 9 --- weaponskill 3, initiative 2
#prec 10 --- ballistic skill 3
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 6
#rpcost 6 --- reduced
#rcost 1
#weapon 1 -- spear
#armor 119 -- reinforced leather cap
#armor 10 -- leather hauberk
#armor 2 -- basic shield
#mountainsurvival
#stealthy 10
#darkvision 50
#end


---- Hobgoblin Sneaks

#newmonster 18109
#spr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Sneak.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Sneak2.tga"
#name "Hobgoblin Sneak"
#descr "Hobgoblins are such an utterly evil and treacherous race that it is hard to imagine a tribe of hobgoblins whose double dealing and backstabbing is renowned even amongst their own fickle kind, yet it exists. This tribe, known as the Sneaky Gits, lives to the east of Zharr-Naggrund. The warriors of this tribe fight in battle with two long curving knives treated with all manner of poisons and ideally suited to their back stabbing methods. Sneaks are experts at striking weak, soft, or particularly painful gaps in the opponents armour."
#hp 8 --- toughness 3, but smaller than human
#size 3 --- they aren't goblins
#prot 0 --- toughness 3, size 2
#mor 8 --- leadership 6, mention of how cowardly they are
#mr 10 --- normal
#enc 3 --- normal
#str 8 --- smaller than humans, str 3
#att 10 --- weaponskill 3, initiative 3
#def 10 --- weaponskill 3, initiative 3
#prec 10 --- ballistic skill 3
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 10
#rpcost 12 --- reduced
#rcost 1
#weapon 1915 -- gitknife
#weapon 1915 -- gitknife
#ambidextrous 2
#armor 119 -- reinforced leather cap
#armor 10 -- leather hauberk
#mountainsurvival
#stealthy 20
#darkvision 50
#end


---- Hobgoblin Wolf rider

#newmonster 18110
#spr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Wolfrider.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Wolfrider2.tga"
#name "Hobgoblin Wolf Rider"
#descr "Not all hobgoblins live within the territory of the Chaos Dwarfs. To the East there are large tribes who are typically allied to the masters of Zharr-Naggrund, but live a nomadic life, raiding other greenskins and sometimes ranging into the lands of menfolk. These hobgoblins travel and fight on wolfback, having long ago formed a beneficial relationship with the large and intelligent wolves of the region. They favour hit and run tactics with both bow and spear and are experienced raiders."
#hp 9 --- little tougher than normal
#size 3 --- they aren't goblins
#prot 0 --- toughness 3
#mor 8 --- leadership 6, mention of how cowardly they are
#mr 10 --- normal
#enc 3
#str 8 --- smaller than humans, str 3
#att 10 --- weaponskill 3, initiative 2
#def 10 --- weaponskill 3, initiative 2, +1 for agility
#prec 11 --- ballistic skill 3 -- but good archers
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 10 -- 18
#rpcost 10 --- 18
#rcost 1
#weapon 357 -- light lance
#weapon 23 -- normal short bow
#armor 119 -- reinforced leather cap
#armor 10 -- leather hauberk
#armor 2 -- basic shield
#mountainsurvival
#stealthy 10
#pillagebonus 1
#darkvision 50
#skilledrider 3
#mobilearcher 1
#mountmnr 14466 -- hobgoblin steppe wolf
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Wolfrider_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Wolfrider_Unmounted2.tga"
#end


---- Hobgoblin Steppe Wolf

#newmonster 14466
#copystats 284 -- regular wolf
#drawsize 0 -- because some things I copystat secretly have a draw size modifier, e.g horses
#spr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Wolfrider_Mount.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Wolfrider_Mount2.tga"
#name "Steppe Wolf"
#descr "The wolves ridden by the Hobgoblins of the Great Steppe are particularly large and vicious."
--stats compared with wolf
#hp 11 -- +3
#size 3
#prot 4 -- +2
#mr 6 -- +1
#str 12 -- +3
#att 12 -- +1
#def 11 -- +1
#prec 7
#weapon 20 -- Bite
#armor 251 -- leather barding
#mapmove 24 -- +2
#ap 28 --- +2
#gcost 8
#rpcost 8
#stealthy 10
#bravemount 25 -- rarely fight
#transformation 0
#end


---- Goblin Slave - spiked club

#newmonster 18111
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Goblin.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Goblin2.tga"
#name "Goblin Slave"
#descr "Most numerous of all the slaves held by the Chaos Dwarfs are the goblins. Vast numbers are taken from the tribes of the Darklands each year, and once captured there is little hope of escape. Goblins are amongst the smallest of the greenskin subraces and by far the most common. They possess devious minds though they are both cowardly and easily distracted in addition to being physically quite weak, especially compared with orcs. This slave is armed with a simple club, though such is the nature of goblins that he will inevitably have managed to scrounge up some bits of metal to enhance its effectiveness."
#hp 7 --- toughness 3, but smaller than human
#size 2 --- goblins are size 2
#prot 0 --- toughness 3, size 2
#mor 6 --- leadership 5, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 7 --- smaller than humans, str 3, slaves
#att 8 --- weaponskill 2, initiative 2
#def 8 --- weaponskill 2, initiative 2
#prec 9 --- ballistic skill 3, slave
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 593 -- spiked club
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#montag 1023
#patrolbonus -1
#end


---- Goblin Slave - spiked club (buckler)

#newmonster 18138
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Goblin_Buckler.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Goblin_Buckler2.tga"
#name "Goblin Slave"
#descr "Most numerous of all the slaves held by the Chaos Dwarfs are the goblins. Vast numbers are taken from the tribes of the Darklands each year, and once captured there is little hope of escape. Goblins are amongst the smallest of the greenskin subraces and by far the most common. They possess devious minds though they are both cowardly and easily distracted in addition to being physically quite weak, especially compared with orcs. This slave is armed with a simple club, though such is the nature of goblins that he will inevitably have managed to scrounge up some bits of metal to enhance its effectiveness."
#hp 7 --- toughness 3, but smaller than human
#size 2 --- goblins are size 2
#prot 0 --- toughness 3, size 2
#mor 6 --- leadership 5, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 7 --- smaller than humans, str 3, slaves
#att 8 --- weaponskill 2, initiative 2
#def 8 --- weaponskill 2, initiative 2
#prec 9 --- ballistic skill 3, slave
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 593 -- spiked club
#armor 1 -- buckler
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#montag 1023
#patrolbonus -1
#end



---- Goblin Slave - spear

#newmonster 18112
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Goblin_Spear.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Goblin_Spear2.tga"
#name "Goblin Slave"
#descr "Most numerous of all the slaves held by the Chaos Dwarfs are the goblins. Vast numbers are taken from the tribes of the Darklands each year, and once captured there is little hope of escape. Goblins are amongst the smallest of the greenskin subraces and by far the most common. They possess devious minds though they are both cowardly and easily distracted in addition to being physically quite weak, especially compared with orcs. This slave is armed with an improvised spear made from some discarded tool of length of scrap."
#hp 7 --- toughness 3, but smaller than human
#size 2 --- goblins are size 2
#prot 0 --- toughness 3, size 2
#mor 6 --- leadership 5, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 7 --- smaller than humans, str 3, slaves
#att 8 --- weaponskill 2, initiative 2
#def 8 --- weaponskill 2, initiative 2
#prec 9 --- ballistic skill 3, slave
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 1 -- spear
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#montag 1023
#patrolbonus -1
#end


---- Goblin War Slave

#newmonster 18113
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Goblin_War.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Goblin_War2.tga"
#name "Goblin Warslave"
#descr "Most numerous of all the slaves held by the Chaos Dwarfs are the goblins. Vast numbers are taken from the tribes of the Darklands each year, and once captured there is little hope of escape. Goblins are amongst the smallest of the greenskin subraces and by far the most common. They possess devious minds though they are both cowardly and easily distracted in addition to being physically quite weak, especially compared with orcs. Some slaves are taken and equipped specifically for use in the military rather than being hastily pressed from the countless numbers toiling in the mines. They are given rudimentary arms and armour, though nothing that would present much danger to the Chaos Dwarf legions."
#hp 7 --- toughness 3, but smaller than human
#size 2 --- goblins are size 2
#prot 0 --- toughness 3, size 2
#mor 6 --- leadership 5, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 7 --- smaller than humans, str 3, slaves
#att 9
#def 8
#prec 9 --- ballistic skill 3, slave
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 6 -- short sword
#armor 120 -- leather cap
#armor 10 -- leather hauberk
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#montag 1023
#patrolbonus -1
#end


---- Goblin War Slave (buckler)

#newmonster 18139
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Goblin_War_Buckler.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Goblin_War_Buckler2.tga"
#name "Goblin Warslave"
#descr "Most numerous of all the slaves held by the Chaos Dwarfs are the goblins. Vast numbers are taken from the tribes of the Darklands each year, and once captured there is little hope of escape. Goblins are amongst the smallest of the greenskin subraces and by far the most common. They possess devious minds though they are both cowardly and easily distracted in addition to being physically quite weak, especially compared with orcs. Some slaves are taken and equipped specifically for use in the military rather than being hastily pressed from the countless numbers toiling in the mines. They are given rudimentary arms and armour, though nothing that would present much danger to the Chaos Dwarf legions."
#hp 7 --- toughness 3, but smaller than human
#size 2 --- goblins are size 2
#prot 0 --- toughness 3, size 2
#mor 6 --- leadership 5, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 7 --- smaller than humans, str 3, slaves
#att 9
#def 8
#prec 9 --- ballistic skill 3, slave
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 6 -- short sword
#armor 120 -- leather cap
#armor 10 -- leather hauberk
#armor 1 -- buckler
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#montag 1023
#patrolbonus -1
#end



---- Orc Slave - club

#newmonster 18114
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Orc.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Orc2.tga"
#name "Orc Slave"
#descr "Orcs bought or enslaved from tribes across the Darklands and surrounding mountains are used as slaves throughout the Chaos Dwarf empire. Their brute strength, toughness, and recuperative abilities make them equally excellent labour in the pits and slave warriors on the battlefield. Orcs are heavily muscled creatures with thick bones and small brains who respect nothing more than power and like little more than to fight, even with each other. Even having been enslaved, orcs are still willing combatants, much preferring to meet their end in combat rather than in some mining accident. Orc physiology is unusual in that over time they can recover from almost any wound, even growing back missing limbs. This orc slave has recently been taken from the mines and is equipped with nothing more than a simple club, with which he will enthusiastically attack his foes."
#hp 14 --- toughness 4
#size 3 --- normal
#prot 3 --- toughness 4
#mor 9 --- leadership 7, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 11 --- str 3, slightly bigger than human
#att 10 --- weaponskill 3, initiative 2
#def 9 --- weaponskill 3, initiative 2
#prec 8 --- ballistic skill 2
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 252 -- club
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#heal -- recuperation ability
#montag 1023
#patrolbonus -1
#end


---- Orc War Slave

#newmonster 18115
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Orc_War.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Orc_War2.tga"
#name "Orc Warslave"
#descr "Orcs bought or enslaved from tribes across the Darklands and surrounding mountains are used as slaves throughout the Chaos Dwarf empire. Their brute strength, toughness, and recuperative abilities make them equally excellent labour in the pits and slave warriors on the battlefield. Orcs are heavily muscled creatures with thick bones and small brains who respect nothing more than power and like little more than to fight, even with each other. Even having been enslaved, orcs are still willing combatants, much preferring to meet their end in combat rather than in some mining accident. Orc physiology is unusual in that over time they can recover from almost any wound, even growing back missing limbs. Some slaves are taken and equipped specifically for use in the military rather than being hastily pressed from the countless numbers toiling in the mines. They are given rudimentary arms and armour, though nothing that would present much danger to the Chaos Dwarf legions."
#hp 14 --- toughness 4
#size 3 --- normal
#prot 3 --- toughness 4
#mor 9 --- leadership 7, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 11 --- str 3, slightly bigger than human
#att 10 --- weaponskill 3, initiative 2
#def 9 --- weaponskill 3, initiative 2
#prec 8 --- ballistic skill 2
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 1086 -- choppa
#armor 119 -- reinforced leather cap
#armor 11 -- ring mail hauberk
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#heal -- recuperation ability
#montag 1023
#patrolbonus -1
#end



---- Orc War Slave

#newmonster 18140
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Orc_War_Shield.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Orc_War_Shield2.tga"
#name "Orc Warslave"
#descr "Orcs bought or enslaved from tribes across the Darklands and surrounding mountains are used as slaves throughout the Chaos Dwarf empire. Their brute strength, toughness, and recuperative abilities make them equally excellent labour in the pits and slave warriors on the battlefield. Orcs are heavily muscled creatures with thick bones and small brains who respect nothing more than power and like little more than to fight, even with each other. Even having been enslaved, orcs are still willing combatants, much preferring to meet their end in combat rather than in some mining accident. Orc physiology is unusual in that over time they can recover from almost any wound, even growing back missing limbs. Some slaves are taken and equipped specifically for use in the military rather than being hastily pressed from the countless numbers toiling in the mines. They are given rudimentary arms and armour, though nothing that would present much danger to the Chaos Dwarf legions."
#hp 14 --- toughness 4
#size 3 --- normal
#prot 3 --- toughness 4
#mor 9 --- leadership 7, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 11 --- str 3, slightly bigger than human
#att 10 --- weaponskill 3, initiative 2
#def 9 --- weaponskill 3, initiative 2
#prec 8 --- ballistic skill 2
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 1086 -- choppa
#armor 119 -- reinforced leather cap
#armor 11 -- ring mail hauberk
#armor 2 -- shield
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#heal -- recuperation ability
#montag 1023
#patrolbonus -1
#end



---- Human Slave

#newmonster 18116
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Human.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Human2.tga"
#name "Human Slave"
#descr "Human slaves are considerably more valued by the Chaos Dwarfs than their common greenskins property. Although they are nowhere near so durable and don't last long at all in the mines, they are much more useful for menial work requiring some degree of intelligence, especially in roles where a goblin simply could not be trusted. Because humans can be manipulated by threatening their comrades and respond more readily to the looming spectre of being tortured or sent to the mines they are particular favoured by traders, scribes, and other civilians who lack the strength or resources to keep greenskins in line. They are also regarded by the Cult of Hashut as making for superior sacrifices in certain rituals. As such it is only truly miserable humans that are sent to die in battle; those that are lame, incapable, or too troublesome to manage. These wretches are given crude spears and simply shoved forward amongst the greenskin rabble to die."
#hp 8 --- toughness 3, bad condition slave
#size 3 --- normal
#prot 0 --- normal
#mor 7 --- leadership 7, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 9 --- str 3, slaves in bad condition
#att 9 --- weaponskill 3, initiative 3, bad condition
#def 9 --- weaponskill 3, initiative 3, bad condition
#prec 9 --- ballistic skill 3, bad condition
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 1 -- spear
#slave
#patrolbonus -1
#montag 1023
#montagweight 2
#startaff 80 -- they are in terrible condition
#end

---- Ogre Forgeslave - hammer, some armour

#newmonster 18117
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Ogre.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Ogre2.tga"
#name "Ogre Forgeslave"
#descr "Ogres make for valuable slaves to the Chaos Dwarfs because of their great size and strength. Their sheer muscle makes them extremely useful when moving heavy equipment and the Daemonsmiths in particular prize them above all other slaves. If they could only be broken in or controlled in the same way as greenskins or humans, they would be truly invaluable in the forges of Zharr-Naggrund, but the sad truth is that most ogres are simply too proud, aggressive, and hungry to be properly controlled. The few ogres that the Daemonsmiths manage to keep need to be muzzled at all times to avoid them eating the other slaves and almost all eventually become too violent and uncooperative to be useful in the smiths' careful work. At this point they are perfect to hand over to the legions, however, where their fury can be unleashed upon the enemy until they are felled."
#hp 34 --- toughness 3, bad condition slave
#size 5 --- normal
#prot 4 --- normal
#mor 9 --- leadership 7, slaves, fear
#mr 10 --- normal
#enc 3 --- normal
#str 15 --- str 4, size 3
#att 10 --- weaponskill 3, initiative 2
#def 9 --- weaponskill 3, initiative 2
#prec 7 --- ballistic skill 2, bad condition
#mapmove 16 -- quick ogres
#ap 14 --- slower than normal ogre
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#slave
#patrolbonus -1
#montag 1023
#armor 991 -- Muzzle
#armor 998 -- Gutplate
#weapon 13 -- one handed hammer
#weapon 1937 -- ogre smash
#maxage 60
#mountainsurvival
#wastesurvival
#coldres 5
#appetite 2
#darkvision 25
#end


----- Slave contract

#newmonster 18118
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Icon.tga"
#name "Purchase Slave"
#descr "The Chaos Dwarf empire is built almost entirely on slaves both economically and socially. It is slaves who toil in the deadly mines and inhospitable pits of the Darklands, it is slaves who do much of the menial work, and often it is slaves who are fated to die on distant battlefields for the benefit of Zharr-Naggrund. The military can requisition slaves at any time, purchasing them from civilian owners or even Sorcerer Lords for a relatively low price, though the quality will be quite mixed. Humans, Gnoblars, Goblins, Orcs, and even the occasional Ogre can be purchased in this way, and some of them may even be slaves equipped specifically for war rather than plucked directly from a stripmine. The biggest cost associated with doing so is simply that it removes part of the workforce, though inevitably they are replaced, for Zharr-Naggrund always seeks more slaves. Purchasing slaves within a province with a fort does not require the presence of a Slaver.

[Turns into a random slave once recruited]"
#hp 1
#size 3 --- normal
#mor 1
#mr 1
#enc 1
#str 1
#att 1
#def 1
#prec 1
#mapmove 14 -- standard human move
#ap 12
#gcost 3
#rpcost 9 --- doesn't matter
#rcost 8
#slave
#weapon 1954 -- varies
#firstshape -1023
#startage 15
#end

----- Slave contract -- not at fort

#newmonster 18137
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Orc.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Orc2.tga"
#name "Purchase Slave"
#descr "The Chaos Dwarf empire is built almost entirely on slaves both economically and socially. It is slaves who toil in the deadly mines and inhospitable pits of the Darklands, it is slaves who do much of the menial work, and often it is slaves who are fated to die on distant battlefields for the benefit of Zharr-Naggrund. The military can requisition slaves at any time, purchasing them from civilian owners or even Sorcerer Lords for a relatively low price, though the quality will be quite mixed. Humans, Gnoblars, Goblins, Orcs, and even the occasional Ogre can be purchased in this way, and some of them may even be slaves equipped specifically for war rather than plucked directly from a stripmine. The biggest cost associated with doing so is simply that it removes part of the workforce, though inevitably they are replaced, for Zharr-Naggrund always seeks more slaves. Purchasing slaves in provinces without a fort requires the presence of a Slaver.

[Turns into a random slave once recruited. If the province is attacked before they get a chance to turn into a random slave, you get this orc slave for the duration of that battle]"
#hp 14 --- toughness 4
#size 3 --- normal
#prot 3 --- toughness 4
#mor 9 --- leadership 7, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 11 --- str 3, slightly bigger than human
#att 10 --- weaponskill 3, initiative 2
#def 9 --- weaponskill 3, initiative 2
#prec 8 --- ballistic skill 2
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#weapon 252 -- club
#mountainsurvival
#undisciplined
#darkvision 50
#heal -- recuperation ability
#patrolbonus -1
#gcost 3
#rpcost 9 --- doesn't matter
#rcost 8
#slave
#firstshape -1023
#monpresentrec 18128 -- chaos dwarf slaver
#startage 15
#end


----- Gnoblar Slave

#newmonster 18119
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Gnoblar.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Gnoblar2.tga"
#name "Gnoblar Slave"
#descr "Gnoblars are a subrace of greenskins that infest the Mountains of Mourn and are kept by ogres as pets, servants, and occasionally snacks. They are closely related to goblins, though quite a bit less sneaky and arguably even more malicious. Even compared with goblins they are physically weak, though they do boast better reactions and are even more capable of somehow smuggling sharp objects on their person; indeed their owners rarely even bother taking these away, as Gnoblars will always find or make another shank. They also have a nasty habit of collecting and hurling small pieces of sharp scrap and rocks with a reasonable degree of accuracy. Gnoblars don't make particularly good labourers, but a slave is a slave, and ogre tribes will usually trade them over in exchange for relatively little of value to the Chaos Dwarfs."
#hp 7
#size 2
#prot 0
#mor 5
#mr 9
#enc 3
#str 7
#att 8
#def 9
#prec 9
#mapmove 14 -- standard human move
#ap 12
#gcost 1
#rpcost 1
#rcost 1
#weapon 9 -- dagger
#weapon 1936 -- flung scrap
#maxage 20
#darkvision 50
#mountainsurvival
#undisciplined
#slave
#montag 1023
#patrolbonus -1
#end


----- Goblin slave -- pick axe

#newmonster 18120
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Goblin_Pick.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Goblin_Pick2.tga"
#name "Goblin Slave"
#descr "Most numerous of all the slaves held by the Chaos Dwarfs are the goblins. Vast numbers are taken from the tribes of the Darklands each year, and once captured there is little hope of escape. Goblins are amongst the smallest of the greenskin subraces and by far the most common. They possess devious minds though they are both cowardly and easily distracted in addition to being physically quite weak, especially compared with orcs. This slave has come fresh from the mines and is armed with a pick axe."
#hp 7 --- toughness 3, but smaller than human
#size 2 --- goblins are size 2
#prot 0 --- toughness 3, size 2
#mor 6 --- leadership 5, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 7 --- smaller than humans, str 3, slaves
#att 8 --- weaponskill 2, initiative 2
#def 8 --- weaponskill 2, initiative 2
#prec 9 --- ballistic skill 3, slave
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 267 -- pick axe
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#montag 1023
#montagweight 2
#patrolbonus -1
#siegebonus 1
#end


----- Orc slave -- pick axe

#newmonster 18121
#spr1 "Warhammer_Chaos_Dwarfs/Slave_Orc_Pick.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slave_Orc_Pick2.tga"
#name "Orc Slave"
#descr "Orcs bought or enslaved from tribes across the Darklands and surrounding mountains are used as slaves throughout the Chaos Dwarf empire. Their brute strength, toughness, and recuperative abilities make them equally excellent labour in the pits and slave warriors on the battlefield. Orcs are heavily muscled creatures with thick bones and small brains who respect nothing more than power and like little more than to fight, even with each other. Even having been enslaved, orcs are still willing combatants, much preferring to meet their end in combat rather than in some mining accident. Orc physiology is unusual in that over time they can recover from almost any wound, even growing back missing limbs. This orc slave is fresh from the mines and still carries a pickaxe which makes a reasonable improvised weapon."
#hp 14 --- toughness 4
#size 3 --- normal
#prot 3 --- toughness 4
#mor 9 --- leadership 7, slaves
#mr 10 --- normal
#enc 3 --- normal
#str 11 --- str 3, slightly bigger than human
#att 10 --- weaponskill 3, initiative 2
#def 9 --- weaponskill 3, initiative 2
#prec 8 --- ballistic skill 2
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 1
#rpcost 1 --- doesn't matter
#rcost 1
#weapon 267 -- pick axe
#mountainsurvival
#slave
#undisciplined
#darkvision 50
#heal -- recuperation ability
#montag 1023
#montagweight 2
#patrolbonus -1
#siegebonus 1
#end


---- Immortal

#newmonster 18122
#spr1 "Warhammer_Chaos_Dwarfs/Immortal.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Immortal2.tga"
#name "Immortal"
#descr "The Immortals are an elite military formation amongst the Chaos Dwarfs. They are drawn from the warrior caste but do not serve any particular Sorcerer Lord. Instead especially skilled warriors are sent by their Overlords to serve in the Immortals for a period of seven years, usually in exchange for political favour. The Immortals receive extensive additional training and are outfitted with incredibly ornate gold and black steel plate armour, thick shields, and superbly smithed weaponry. So prepared, they act as an elite guard to the Sorcerer Lords, assigned according to a vote by the conclave of the Great Temple of Hashut, typically to Sorcerer Lords who have recently done great service to the Cult, or hold particular power at the time. The Immortals are forbidden to show fear to the enemy and the faces of their helms are handcrafted as placid golden visages of the Dwarf beneath, calmly regarding the carnage of the battlefield at all times. The Immortals are partially funded by a tithe taken from all Sorcerer Lords and has such have decreased upkeep.

[Gold upkeep is halved]"
#hp 15 --- toughness 4, description makes them sound even tougher
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 14 --- leadership 9 + stubborn
#mr 12 --- better mr than most chaos dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 12 --- str 4
#att 12 --- weaponskill 5, but initiative 2
#def 11 --- weaponskill 5, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 12 --- set to get combat speed to 6
#gcost 35
#addupkeep -17
#rpcost 35 --- They need to have order scales
#rcost 1
#armor 992 -- immortal gold plate
#armor 213 -- golden helmet
#armor 3 -- kite shield
#weapon 1907 -- mastercrafted axe
#maxage 500
#startage 250
#mountainsurvival
#wastesurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#bodyguard 2
#neednoteat
#appetite 1
#end


---- Acolyte of Hashut

#newmonster 18123
#spr1 "Warhammer_Chaos_Dwarfs/Acolyte.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Acolyte2.tga"
#name "Acolyte of Hashut"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those who never develop in sorcerous skill beyond the lowest levels are trained as Acolytes and serve as holy warriors of cult, hurling rudimentary and unfocused fire evocations at the foe. The Acolytes are skilled enough with their glaives but lack the heavy armour typical amongst the legions and are best protected from prolonged melee. Being holy warriors of the god of Darkness, Acolytes are expected to be able to fight in near pitch black conditions, for they are tasked with protecting summoning circles during the most dire of the rituals performed by the Cult. The mild sorcerous talent of the Acolytes grants them additional resistance to enemy magics."
#hp 13 --- toughness 4
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 12 --- they have very slightly better magic res than normal, but they aren't like regular dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 11 --- slightly stronger than human
#att 11 --- weaponskill 4, but initiative 2
#def 10 --- weaponskill 4, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 16 -- dwarfs are really strong marchers, but these guys are less military minded
#ap 8 --- move 3
#gcost 35
#rpcost 28 --- They need to have order scales
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 308 -- glaive
#weapon 1905 -- flames of hashut
#maxage 600
#startage 150
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 75
#fireres 5
#nametype 192
#holy
#neednoteat
#appetite 1
#end


---- Slave giant - (this is the recruitment version with the smaller sprite)

#newmonster 18145
#spr1 "Warhammer_Chaos_Dwarfs/Slavegiant_small.tga"
#name "Slave Giant"
#descr "Giants are common in the Dark Lands as they wander down from their ancestral home in the Mountains of Mourn. Frequently these hapless, ungaingly creatures are fleeing the attentions of tribes of ogres, but unfortunately for them the Dark Lands represent an even more dangerous threat, for the Chaos Dwarfs have many uses for their kind. Though slow and stupid, giants are immensely strong and make invaluable slaves whether toiling in the pits, tearing up trees, or on the field of battle. Slavegiants are goaded into battle, but usually it doesn't take much goading, as the Giant is all too willing to take out the humiliation of being enslaved on any creature smaller than himself. In battle Slave Giants attack by stomping, whipping heavy chains about and generally causing utter chaos and carnage. The Chaos Dwarfs are particularly talented in the art of breaking their slaves and have managed to render even the notoriously stupid and stubborn Giants obedient enough to follow simple commands.

[This troop uses a smaller sprite on the recruitment screen for ease of use]
[Recruitment limited to 1 per month]"
#hp 115
#size 10
#prot 9
#mor 14
#mr 10
#enc 4
#str 25
#att 10
#def 9
#prec 4
#mapmove 18 -- big strides
#ap 16
#gcost 210
#rpcost 60
#rcost 10
#armor 21 -- Full Helmet
#weapon 1952 -- Chain Strike
#weapon 1168 -- Giant Stomp
#maxage 140
#mountainsurvival
#coldres 10
#appetite 1
#ambidextrous 3
#fear 5
#nametype 193
#noleader
#siegebonus 5
#reclimit 1
#slave
#firstshape 18124 -- slave giant
#end


---- Slave giant - like ogre one, more armour and weapons

#newmonster 18124
#spr1 "Warhammer_Chaos_Dwarfs/Slavegiant.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slavegiant2.tga"
#name "Slave Giant"
#descr "Giants are common in the Dark Lands as they wander down from their ancestral home in the Mountains of Mourn. Frequently these hapless, ungaingly creatures are fleeing the attentions of tribes of ogres, but unfortunately for them the Dark Lands represent an even more dangerous threat, for the Chaos Dwarfs have many uses for their kind. Though slow and stupid, giants are immensely strong and make invaluable slaves whether toiling in the pits, tearing up trees, or on the field of battle. Slavegiants are goaded into battle, but usually it doesn't take much goading, as the Giant is all too willing to take out the humiliation of being enslaved on any creature smaller than himself. In battle Slave Giants attack by stomping, whipping heavy chains about and generally causing utter chaos and carnage. The Chaos Dwarfs are particularly talented in the art of breaking their slaves and have managed to render even the notoriously stupid and stubborn Giants obedient enough to follow simple commands."
#hp 115
#size 10
#prot 9
#mor 14
#mr 10
#enc 4
#str 25
#att 10
#def 9
#prec 4
#mapmove 18 -- big strides
#ap 16
#gcost 210
#rpcost 60
#rcost 10
#armor 21 -- Full Helmet
#weapon 1952 -- Chain Strike
#weapon 1168 -- Giant Stomp
#maxage 140
#mountainsurvival
#coldres 10
#appetite 1
#ambidextrous 3
#fear 5
#nametype 193
#noleader
#siegebonus 5
#reclimit 1
#slave
#end


---- Kdaai Fireborn

#newmonster 18143
#spr1 "Warhammer_Chaos_Dwarfs/Kdaai_Fireborn.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Kdaai_Fireborn2.tga"
#name "Kdaai Fireborn"
#descr "The Kdaai Zharr, or Scions of Fire, were born from the constant efforts of the Sorcerer Lords to gain power and increase the size of the Chaos Dwarf realms. They are in essence a fusion of Daemonic matter, ensorcelled armour, and unstable magmatic blood. Unlike the Daemons of Chaos the Kdaai have no desire beyond destruction and are nearly mindless weapons of war to be used exactly as their commanding Sorcerer sees fit. Aside from the difficulty in creating any large number of these fiery beings their only true drawback is how quickly their energy is expended in battle: it is not uncommon to see Kdaai slowing and beginning to sputter out before the foe is entirely destroyed."
#hp 28 --- toughness 4, wounds 2, large
#size 5 --- little bigger than an ogre
#prot 4 --- toughness 4, size 3
#mor 30 --- same as devil
#mr 16 --- 1 less than a devil
#enc 1 --- daemon
#str 18 --- str 5, big
#att 12 --- weaponskill 4, initiative 4
#def 12 --- weaponskill 4, initiative 4
#prec 8 --- ballistic skill 2
#mapmove 20
#ap 18 --- move 6
#gcost 0 -- summon
#rpcost 0 --- normal
#rcost 0
#weapon 1914 -- forge axe
#weapon 1914 -- forge axe
#armor 101 -- bronze hauberk
#armor 21 -- full helmet
#mountainsurvival
#reinvigoration -3 -- they slowly burn out
#ethereal
#fireres 30 -- +5 over devils
#coldres -5 -- like devils
#float
#heat 5
#fireshield 12
#spiritsight
#neednoteat
#deathfire 9
#maxage 1000
#wastesurvival
#mountainsurvival
#magicbeing
#end




-------- Commanders


---- Hobgoblin scout

#newmonster 18125
#spr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Archer.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Archer2.tga"
#name "Hobgoblin Scout"
#descr "Hobgoblins are a subrace of greenskins closely related to the more widespread orcs and goblins. Though not nearly so strong, tough, or aggressive as orcs, they are larger and stronger than goblins and make better fighters. In terms of mindset they are far closer to goblins than orcs, though arguably even sneakier and less trustworthy. Centuries ago the Chaos Dwarfs faced the largest slave uprising in their history and stood on the brink of defeat at the hands of a massive greenskin force which had taken most of Zharr-Naggrund, but at the last moment the hobgoblins, fearing the cruelty of the Chaos Dwarfs more than the brutality of the orcs, switched sides. Since that time the Hobgoblins have been cast out of greenskin society and, while they have risen from the position of slaves to menial servants, they are almost entirely reliant on the protection of their masters. A naturally sneaky race, Hobgoblins make fine scouts."
#hp 8 --- toughness 3, but smaller than human
#size 3 --- they aren't goblins
#prot 0 --- toughness 3, size 2
#mor 8 --- leadership 6, mention of how cowardly they are
#mr 10 --- normal
#enc 3 --- normal
#str 8 --- smaller than humans, str 3
#att 10 --- weaponskill 3, initiative 2
#def 9 --- weaponskill 3, initiative 2
#prec 10 --- ballistic skill 3
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 35
#rpcost 1 --- normal
#rcost 1
#weapon 23 -- normal short bow
#weapon 9 -- dagger
#armor 120 -- leather cap
#armor 10 -- leather hauberk
#mountainsurvival
#stealthy 10
#darkvision 50
#noleader
#end

---- Hobgoblin Khan

#newmonster 18126
#spr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Khan.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Khan2.tga"
#name "Hobgoblin Khan"
#descr "Not all hobgoblins live within the territory of the Chaos Dwarfs. To the East there are large tribes who are typically allied to the masters of Zharr-Naggrund, but live a nomadic life, raiding other greenskins and sometimes ranging into the lands of menfolk. These hobgoblins travel and fight on wolfback, having long ago formed a beneficial relationship with the large and intelligent wolves of the region. They are ruled over by Khans, Hobgoblins sufficiently paranoid and treacherous to rise to the top of a tribe and survive enough betrayals to solidify power, at least for now. All Khans wear crowns of iron and in theory serve the Great Hobgobla Khan, ruler of all their kind and the only chieftain permitted to wear a crown of gold. In reality each Khan is of course only loyal to their own interests and many choose to serve under the Chaos Dwarfs for protection and to gain influence."
#hp 17 --- 2 wounds, toughness 4, but a hobgoblin
#size 3
#prot 2 --- toughness 4, but still a hobgob
#mor 10 --- leadership 7
#mr 11 --- combat commander tier 1
--
#enc 3
#str 11 --- smaller than humans, str 4
#att 12 --- weaponskill 5, initiative 3
#def 12 --- weaponskill 5, initiative 3
#prec 11 --- ballistic skill 3 -- but good archers
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 85 --- 90
#rpcost 1 --- basic military commander
#rcost 1
#weapon 10 -- falchion
#weapon 23 -- normal short bow
#armor 20 -- iron cap
#armor 11 -- ring mail hauberk
#armor 2 -- basic shield
#mountainsurvival
#stealthy 10
#pillagebonus 1
#darkvision 50
#okleader
#skilledrider 4
#mobilearcher 1
#mountmnr 14466 -- hobgoblin steppe wolf
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Khan_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Khan_Unmounted2.tga"
#end


---- Hobgoblin assassin

#newmonster 18127
#spr1 "Warhammer_Chaos_Dwarfs/Hobgoblin_Gutstabba.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hobgoblin_Gutstabba2.tga"
#name "Hobgoblin Gutstabber"
#descr "Hobgoblins are such an utterly evil and treacherous race that it is hard to imagine a tribe of hobgoblins whose double dealing and backstabbing is renowned even amongst their own fickle kind, yet it exists. This tribe, known as the Sneaky Gits, lives to the east of Zharr-Naggrund. The warriors of this tribe fight in battle with two long curving knives treated with all manner of poisons and ideally suited to their back stabbing methods. The gutstabbers, as the very sneakiest assassins of this tribe are known, are duplicitous and cruel even by the standards of their fellows. Any Sneaky Git will happily place a dagger in the back of a foe or rival, but the gutstabbers are so sly that they're prone to stab a perceived enemy in the front, right in the gut! The Chaos Dwarfs use these murderous greenskins as assassins, sending them out against tribal leaders, or letting them pick their targets and kill seemingly at random just to put fear into their own slaves. They aren't nearly so skilled as the assassins of other races and far less dedicated to any cause, but are still exceptionally sneaky."
#hp 10 --- slightly improved over basic sneak
#size 3 --- they aren't goblins
#prot 0 --- toughness 3, size 2
#mor 8 --- leadership 6, mention of how cowardly they are
#mr 10 --- normal
#enc 3 --- normal
#str 9 --- slightly improved over basic sneak
#att 11 --- slightly improved over basic sneak
#def 11 --- slightly improved over basic sneak
#prec 10 --- ballistic skill 3
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 100
#rpcost 1 --- normal
#rcost 1
#weapon 1915 -- gitknife
#weapon 1915 -- gitknife
#ambidextrous 2
#armor 119 -- reinforced leather cap
#armor 10 -- leather hauberk
#mountainsurvival
#stealthy 20
#darkvision 50
#assassin
#patience 1 -- standard value
#poorleader
#end


---- Slaver

#newmonster 18128
#spr1 "Warhammer_Chaos_Dwarfs/Slaver.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Slaver2.tga"
#name "Slaver"
#descr "Without slaves the empire of the Chaos Dwarfs could not function; they are used extensively in every strata of society for every purpose imaginable, from ritual sacrifice, to administration, to labour, to military fodder. Yet despite this reliance on slaves, those who perform the role of buying, selling, and breaking slaves are considered to be uncivilised and are exempt from many of the social circles and rites so important to the clans. Though there is no slaver caste, slavers tend to live rather alienated lives and their offspring are unlikely to become more than slavers themselves. Typically they are not true citizens of Zharr-Naggrund, but were born and raised in one of the many lesser outposts maintained by the empire. Wearing masked helms made from the skulls of ogres and with bone fetishes in their beards, they are a greatly feared sight to any slave, for their eyes and ears are as sharp as the spines on their whips and they are always seeking to punish the slightest sign of dissent. Slavers contribute to the productivity of any fort in the province and allow the purchase of slave contracts outside forts. The presence of a Slaver in any province will undoubtedly also result in particularly unruly slaves being handed over for free to die in battle.

[Each month each province with more than 2000 population, less than 20 unrest, and with a Slaver present will generate 1d3 slave troops. Stacking Slavers does not increase the number of slaves]"
#hp 13 --- toughness 4
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 12 --- leadership 9, but not warriors
#mr 11 --- they have very slightly better magic res than normal, but they aren't like regular dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 10 --- regular
#att 10 --- weaponskill 3, but initiative 2
#def 9 --- weaponskill 3, but initiative 2
#prec 12 --- ballistic skill 4
#mapmove 18 -- dwarfs are really strong marchers, this guy is well travelled though not military minded
#ap 8 --- move 3
#gcost 100
#rpcost 1 --- normal for non-mage
#rcost 1
#armor 150 -- bone helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 1904 -- slaver whip
#maxage 500
#startage 200
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#resources 10
#patrolbonus 5
#nametype 192
#taskmaster 3
#poorleader
#command 40 -- 60 leadership total
#neednoteat
#appetite 1
#undisleader 1
#end


---- Castellan

#newmonster 18129
#spr1 "Warhammer_Chaos_Dwarfs/Castellan.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Castellan2.tga"
#name "Castellan"
#descr "Chaos Dwarf society is strictly heirarchical with many tiers of ascending power and diminishing size, mirroring the mighty ziggurats that dominate their homeland. Amongst Chaos Dwarfs the Warrior caste is a position of middling importance, holding status above craftsmen and civilians, but well below smiths or inductees into cult of Hashut. Castellans are members of the Warrior caste who have distinguished themselves over and over again in battle under the watchful eye of an Overlord, who in turn serves a Sorcerer Lord. The day to day running of the Sorcerer Lord's legion is left to the Castellans, who are adept in leading small forces, raiding for slaves, commanding garrisons or drilling the troops. Each Castellan will have served a significant time in the legion and many have even completed at least one seven year term in the Immortals."
#hp 22 --- toughness 5, wounds 2
#size 3 --- yep, they aren't that small
#prot 4
#mor 14 --- leadership 10
#mr 12 --- combat commander tier 1
--
#enc 2 --- Dwarfs are known for their stamina
#str 13 --- strength 4, dwarfs
#att 13 --- weaponskill 6, initiative 3
#def 12 --- weaponskill 6, initiative 3
#prec 12 --- ballistic skill 4
#mapmove 18 -- dwarfs are really strong marchers
#ap 10 --- set to get combat speed to 6
#gcost 100
#rpcost 1
#rcost 1
#armor 118 -- Half Helmet
#armor 995 -- dwarf full scale mail
#armor 347 -- quality shield
#weapon 10 -- falchion
#maxage 500
#startage 300
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#goodleader
#neednoteat
#appetite 1
#end


---- Overlord

#newmonster 18130
#spr1 "Warhammer_Chaos_Dwarfs/Overlord.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Overlord2.tga"
#name "Overlord"
#descr "While Chaos Dwarf society is ultimately ruled over by the Sorcerer Lords, it is the Overlords which command the legions of warriors. Each Sorcerer Lord may appoint exactly one Overlord, picked from the most ruthless and talented of the Castellan ranks. This is the apex to which all in the Warrior caste aspite, the zenith of all they can acheieve in life, and Overlords are utterly dedicated to their work. Without the distraction of social climbing and intrigue they are focused entirely on the art of war and the elevation of their own Sorcerer Lord to even greater power, for their fortunes are truly tied to those of their master. Each Overlord will have served many decades, perhaps even centuries as a Warrior and Castellan, almost inevitably also having spent time in the ranks of the Immortals to prove his worth. They are superb tacticians and individual combatants and are armed with some of the best available equipment, including a forge axe and magical golden scale mail. Overlords are expected to be able to command throngs of worthless slaves or elite Immortals with equal confidence and authority."
#hp 28 --- toughness 5, wounds 3
#size 3 --- yep, they aren't that small
#prot 5
#mor 15 --- leadership 10
#mr 14 --- combat commander tier 3
--
#enc 2 --- Dwarfs are known for their stamina
#str 13 --- strength 4, dwarfs
#att 14
#def 13
#prec 12 --- ballistic skill 4
#mapmove 18 -- dwarfs are really strong marchers
#ap 8 --- move 3
#gcost 190
#rpcost 2 --- Extraordinarly good leader, 2 cp makes sense
#rcost 12 -- golden scale mail doesn't have an rcost
#armor 20 -- Golden Helmet
#armor 196 -- golden scale mail
#armor 347 -- quality shield
#weapon 1914 -- forge axe
#maxage 500
#startage 400
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#taskmaster 1
#expertleader
#neednoteat
#appetite 1
#end

---- Infernal guard deathmask

#newmonster 18131
#spr1 "Warhammer_Chaos_Dwarfs/Infernal_Deathmask.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Infernal_Deathmask2.tga"
#name "Infernal Deathmask"
#descr "Deathmasks are members of the Infernal Guard who have, through suicidal bravery in combat, earned the right to have their helm removed. The process of removing the helm is nearly as painful as the process of sealing the dishonoured dwarf in his armour, for his flesh is usually fused with the metal. Many do not survive, but for the Infernal Guard this is their only hope. Upon being unsealed they are given a new identity and while they can never leave the Infernal Guard or undo their dishonour entirely, they are recognised once more as having a status equivalent to that of a member of the lowest caste of Chaos Dwarf. Deathmasks lead their fellows into battle, utilising their considerable tactical experience and seeking to inspire them with the hope of going through the unsealing process and becoming dwarfs once more. In normal life, or what passes for it amongst the Infernal Guard, the Deathmasks proudly display their scarred faces, while in battle they once more don their full helmet. Members of the Infernal Guard can only be recruited when a Daemonsmith is present.

[Requires a Daemonsmith present to recruit]"
#hp 23 --- toughness 5, 2 wounds
#size 3 --- yep, they aren't that small
#prot 5
#mor 18 --- leadership 10 and immune to psychology
#mr 13 --- combat commander tier 1 + CD + Infernal
--
#enc 2 --- Dwarfs are known for their stamina
#str 13 --- str 4, dwarfs
#att 13 --- weaponskill 6, but initiative 2
#def 12 --- weaponskill 6, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 11 --- set to get combat speed to 6
#gcost 100
#rpcost 1 --- normal for military commander
#rcost 1
#armor 990 -- infernal full plate
#armor 21 -- Full Helmet
#armor 347 -- quality shield
#weapon 1906 -- chaos dwarf axe
#maxage 500
#startage 300
#mountainsurvival
#wastesurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#fireres 5
#goodleader
#command -60 -- so 20 command
#monpresentrec 18133 -- Daemonsmith
#neednoteat
#appetite 1
#end


---- Bull Centaur Ancient

#newmonster 18132
#spr1 "Warhammer_Chaos_Dwarfs/Bull_Centaur_Ancient.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Bull_Centaur_Ancient2.tga"
#name "Bull Centaur Ancient"
#descr "Bull Centaurs are creatures with the upper torso of a Chaos Dwarf but the body of a ferocious bull. Many centuries ago, when their kind was first twisted by Chaos, some Chaos Dwarfs were transformed into Bull Centaurs, creating a revered subrace of fast moving warriors. Since those days the Bull Centaurs have guarded the great temples of Hashut and the central Tower of Zharr-Naggrund. The eldest of the Bull Centaurs, known as Ancients, have been blessed with a lifespan beyond those of their fellows and are marked as the chosen of Hashut, his will made manifest. They consider themselves executioners of sorts and proudly display trophy skulls of slave revolt leaders, dangerous ogres, or disloyal Chaos Dwarfs. Even beneath their finely crafted armour their hide is extremely tough, and they have been gifted considerable resistance to fire through their zealous worship of Hashut. Though they could easily trample smaller foes underhoof they instead prefer to strike with their huge crescent axes and have even been known to grab foes and impale them on their prodigious tusks or horns."
#hp 70 --- toughness 5, wounds 4, size 5
#size 8 --- as much mass as a melqart
#prot 8 --- toughness 5, size 5, scaly skin 6+
#mor 16 --- leadership 9, mention of how loyal they are, immune to psych
#mr 14 --- combat commander tier 2
--
#enc 3 --- big monster
#str 25 --- str 6 size 5
#att 14
#def 13
#prec 10 --- ballistic skill 3
#mapmove 22 -- same as centaurs because, though they're slower, they're better marchers
#ap 28 --- (normal centaur has 30)
#gcost 310
#rpcost 3 --- rare thug commanders
#rcost 1
#armor 118 -- Half Helmet
#armor 995 -- dwarf full scale mail
#weapon 259 -- two handed executioners axe
#weapon 55 -- hoof ala centaurs
#weapon 399 -- gore
#maxage 1500 -- double the age of chaos dwarfs
#startage 1000
#mountainsurvival
#castledef 2
#darkvision 50
#nametype 192
#holy
#mountedhumanoid -- the value to use for centaurs
#fireres 5
#neednoteat
#appetite 4
#latehero 4
#end


---- Daemonsmith

#newmonster 18133
#spr1 "Warhammer_Chaos_Dwarfs/Daemonsmith.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Daemonsmith2.tga"
#name "Daemonsmith"
#descr "Daemonsmiths are members of the Cult of Hashut who showed talent for binding and controlling demonic essence at an early age. These young dwarfs are taken out of the training which results in Acolytes, Pyrophants, and members of the Sorcerous caste, and instead sent to learn in the secret forges deep below Zharr-Naggrund. The order of Daemonsmiths guard their techniques jealously even from the Sorcerers, and their talents are integral to the advancement of the Chaos Dwarf race. It is the Daemonsmiths who create and maintain the great daemonic machinery which delivers steam power across the capital, it is they who oversee the forging of arms and armour, and it is they alone who can create, apply, and enchant Infernal armour. Indeed, without them there would be no Infernal Guard at all. Daemonsmiths are excellent at forging magical items but are inefficient researchers or battle mages and while members of the Cult of Hashut they have received no priestly training. Each Daemonsmith increases the resources available when present at a fort and allows the recruitment of Infernal Guard."
#hp 13 --- toughness 4, mage so wounds don't add
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 15 --- not a great mage, but has special armour and is basically an infernal
#enc 2 --- Dwarfs are known for their stamina
#str 11 --- slightly stronger than human
#att 11 --- weaponskill 4, but initiative 2
#def 10 --- weaponskill 4, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 16 -- dwarfs are really strong marchers, but these guys are less militarily minded
#ap 8 --- move 3
#gcost 320
#rpcost 2 --- They are mages
#rcost 1
#armor 118 -- Half Helmet
#armor 995 -- dwarf full scale mail
#weapon 1903 -- forge hammer
#maxage 500
#startage 300
#mountainsurvival
#siegebonus 20
#castledef 2
#darkvision 50
#nametype 192
#poorleader
#holy
#fixforgebonus 1
#mastersmith 1
#resources 10
#magicskill 3 1 -- earth 1
#magicskill 0 1 -- fire 1
#custommagic 38016 100 -- 100% DBEF
#neednoteat
#appetite 1
#end

---- Pyrophant

#newmonster 18134
#spr1 "Warhammer_Chaos_Dwarfs/Pyrophant.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Pyrophant2.tga"
#name "Pyrophant"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. The lowest level of ordained priest within the Cult is the Pyrophant, and these dwarfs make up the majority of the priesthood. They are tasked with making the routine observances to Hashut, delivering his blessings to the warrior acolytes, performing various tasks considered beneath sorcerers, and most importantly conducting research into the arts of fire and darkness. Sorcerers and Sorcerer Lords, though far more skilled in magic, rarely wish to devote their time to research, for their primary focus at all times must be manoeuvring to maintain or extend their grasp of power. Particularly skilled Pyrophants may also be deployed to support the legions with lesser evocations, though they cannot be expected to match the destructive arcane power of true Sorcerers. They carry bull headed scepters which signify their position as chosen children of Hashut."
#hp 12 --- toughness 4, mage so wounds don't add
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 14 --- basic mage, but a dwarf
#enc 2 --- Dwarfs are known for their stamina
#str 10 --- mage
#att 10 --- weaponskill 3, but initiative 2
#def 9 --- weaponskill 3, but initiative 2
#prec 11 --- ballistic skill 3, but specialist in fire evocations
#mapmove 16 -- dwarfs are really strong marchers, but these guys are less militarily minded
#ap 8 --- move 3
#gcost 150
#rpcost 2 --- They are mages
#rcost 1
#armor 20 -- Iron Cap
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 500
#startage 250
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 1 -- holy 1
#magicskill 0 1 -- fire 1
#custommagic 38016 100 -- FEDB
#neednoteat
#appetite 1
#end



---- Sorcerer (the form that is the bad result of a montag and will be turned into a stonecursed sorcerer)

#newmonster 18150
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer2.tga"
#name "Sorcerer"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Each Sorcerer is, in addition to his considerable magical prowess in the arts of shadow, fire, magma, ash, and blood, also invested with considerable priestly authority and political power, though they leave the leadership of the Legions to the Castellans and the Overlords that serve the most powerful of their caste. Unique amongst Chaos Dwarfs, the Sorcerer Caste is one of absolute mobility, where each individual is expected and encouraged to vie for his own personal power and expanded influence. Tragically it is the fate of all Sorcerers to one day succumb to the Stone Curse, an affliction caused by their use of magic which slowly saps their vitality and, eventually, turns them to stone. Such is the price they must pay, for it is the will of Hashut.

[Each turn this mage has a chance to be afflicted by the Stone Curse, changing to a form carried by guards, gaining encumberance, and losing their foot slot]"
#hp 12 -- toughness 4, mage so wounds don't add
#size 3 -- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 16 --- middle mage dwarf
#enc 2 --- Dwarfs are known for their stamina
#str 10 --- mage
#att 10 --- weaponskill 3, but initiative 2
#def 9 --- weaponskill 3, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 16 -- dwarfs are really strong marchers, but these guys are less militarily minded
#ap 8 --- move 3
#gcost 340
#rpcost 3 --- keep their rarity a bit, keep them more of a cap thing
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 500
#startage 250
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 2 -- holy 2
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 1 -- earth 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#montag 1027
#montagweight 1 -- 1 vs 35
#end


---- Sorcerer (the form that is the result of a montag and shrinks into the other one)

#newmonster 18159
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer2.tga"
#name "Sorcerer"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Each Sorcerer is, in addition to his considerable magical prowess in the arts of shadow, fire, magma, ash, and blood, also invested with considerable priestly authority and political power, though they leave the leadership of the Legions to the Castellans and the Overlords that serve the most powerful of their caste. Unique amongst Chaos Dwarfs, the Sorcerer Caste is one of absolute mobility, where each individual is expected and encouraged to vie for his own personal power and expanded influence. Tragically it is the fate of all Sorcerers to one day succumb to the Stone Curse, an affliction caused by their use of magic which slowly saps their vitality and, eventually, turns them to stone. Such is the price they must pay, for it is the will of Hashut.

[Each turn this mage has a chance to be afflicted by the Stone Curse, changing to a form carried by guards, gaining encumberance, and losing their foot slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 16 --- middle mage dwarf
#enc 2 --- Dwarfs are known for their stamina
#str 10 --- mage
#att 10 --- weaponskill 3, but initiative 2
#def 9 --- weaponskill 3, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 16 -- dwarfs are really strong marchers, but these guys are less militarily minded
#ap 8 --- move 3
#gcost 340
#rpcost 3 --- keep their rarity a bit, keep them more of a cap thing
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 500
#startage 250
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 2 -- holy 2
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 1 -- earth 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#shrinkhp 999
#montag 1027
#montagweight 35 -- 35 vs 1
#end


---- Sorcerer

#newmonster 18160
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer2.tga"
#name "Sorcerer"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Each Sorcerer is, in addition to his considerable magical prowess in the arts of shadow, fire, magma, ash, and blood, also invested with considerable priestly authority and political power, though they leave the leadership of the Legions to the Castellans and the Overlords that serve the most powerful of their caste. Unique amongst Chaos Dwarfs, the Sorcerer Caste is one of absolute mobility, where each individual is expected and encouraged to vie for his own personal power and expanded influence. Tragically it is the fate of all Sorcerers to one day succumb to the Stone Curse, an affliction caused by their use of magic which slowly saps their vitality and, eventually, turns them to stone. Such is the price they must pay, for it is the will of Hashut.

[Each turn this mage has a chance to be afflicted by the Stone Curse, changing to a form carried by guards, gaining encumberance, and losing their foot slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 16 --- middle mage dwarf
#enc 2 --- Dwarfs are known for their stamina
#str 10 --- mage
#att 10 --- weaponskill 3, but initiative 2
#def 9 --- weaponskill 3, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 16 -- dwarfs are really strong marchers, but these guys are less militarily minded
#ap 8 --- move 3
#gcost 340
#rpcost 3 --- keep their rarity a bit, keep them more of a cap thing
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 500
#startage 250
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 2 -- holy 2
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 1 -- earth 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#end



---- Stonecursed Sorcerer (this is the bad montag result that is turned into a stonewracked sorcerer)

#newmonster 18158
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA2.tga"
#name "Stonecursed Sorcerer"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Each Sorcerer is, in addition to his considerable magical prowess in the arts of shadow, fire, magma, ash, and blood, also invested with considerable priestly authority and political power, though they leave the leadership of the Legions to the Castellans and the Overlords that serve the most powerful of their caste. This Sorcerer has begun to fully succumb to the inevitable ravages of the Stone Curse; his lower limbs have turned to stone and his thoughts and movements have begun to slow, though he has not yet lost any magical prowess. He is now carried everywhere by a pair of Warrior guards who will serve and protect him until he evenentually turns entirely to stone. Should the mage be slain his guards will carry away the body before ending their lives in shame.

[Each turn there is a chance to Stone Curse will progress, reducing all non-earth magic paths by 1, further encumbering the mage, and removing his chest slot and one hand slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#prot 5 --- +2 for the stone curse
#mor 13 --- leadership 9
#mr 16 --- middle mage dwarf
#enc 10 --- Sorcerer's curse is now causing problems
#str 10 --- mage
#att 9 --- curse slows them down
#def 8 --- curse slows them down
#prec 9 --- curse
#gcost 340
#rpcost 3 --- keep their rarity a bit, keep them more of a cap thing
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 500
#startage 250
#mountainsurvival
#siegebonus 2
#castledef 4
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 2 -- holy 2
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 1 -- earth 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#itemslots 860678 -- no feet, otherwise normal
#montag 1026 -- stonecursed sorc montag
#montagweight 2 -- 2/20 -- other one is 18 weight -- so this is 10%
#size 3
#mapmove 0
#ap 8
#immobile
#mountmnr 14467 -- warrior bearer
#nofmounts 2 -- sets the mounts as 2 bearers
#regainmount 1 -- will regain any lost mounts immediately after battle
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA_Unmounted2.tga"
#nofalldmg -- bearers will drop gently even with their dying action
#regainmount 1
#end


---- Chaos Dwarf Warrior Bearer

#newmonster 14467
#spr1 "Warhammer_Chaos_Dwarfs/Bearer_Warrior.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Bearer_Warrior2.tga"
#name "Chaos Dwarf Bearer"
#descr "This Chaos Dwarf Warrior has the sacred task of carrying a Stonecursed Sorcerer. Should the Sorcerer ever lose his bearers they will immediately be replaced."
#hp 13 --- toughness 4
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 11 --- they have very slightly better magic res than normal, but they aren't like regular dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 11 --- slightly stronger than human
#att 11 --- weaponskill 4, but initiative 2
#def 10 --- weaponskill 4, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 10 --- set to get combat speed to 6
#gcost 15
#rpcost 21 --- They need to have order scales
#rcost 1
#armor 118 -- Half Helmet
#armor 995 -- dwarf full scale mail
#weapon 1906 -- chaos dwarf axe
#maxage 500
#startage 150
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#neednoteat
#appetite 1
#holy
#nobarding
#bravemount 100
#end


---- Stonecursed Sorcerer (this is the montag result that just turns back into the normal stonecursed sorcerer)

#newmonster 18152
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA2.tga"
#name "Stonecursed Sorcerer"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Each Sorcerer is, in addition to his considerable magical prowess in the arts of shadow, fire, magma, ash, and blood, also invested with considerable priestly authority and political power, though they leave the leadership of the Legions to the Castellans and the Overlords that serve the most powerful of their caste. This Sorcerer has begun to fully succumb to the inevitable ravages of the Stone Curse; his lower limbs have turned to stone and his thoughts and movements have begun to slow, though he has not yet lost any magical prowess. He is now carried everywhere by a pair of Warrior guards who will serve and protect him until he evenentually turns entirely to stone. Should the mage be slain his guards will carry away the body before ending their lives in shame.

[Each turn there is a chance to Stone Curse will progress, reducing all non-earth magic paths by 1, further encumbering the mage, and removing his chest slot and one hand slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#prot 5 --- +2 for the stone curse
#mor 13 --- leadership 9
#mr 16 --- middle mage dwarf
#enc 10 --- Sorcerer's curse is now causing problems
#str 10 --- mage
#att 9 --- curse slows them down
#def 8 --- curse slows them down
#prec 9 --- curse
#gcost 340
#rpcost 3 --- keep their rarity a bit, keep them more of a cap thing
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 500
#startage 250
#mountainsurvival
#siegebonus 2
#castledef 4
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 2 -- holy 2
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 1 -- earth 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#itemslots 860678 -- no feet, otherwise normal
#montag 1026 -- stonecursed sorc montag
#montagweight 18 -- 18/20 -- other one is 2 weight -- so this is 90%
#shrinkhp 999
#size 3
#mapmove 0
#ap 8
#immobile
#mountmnr 14467 -- warrior bearer
#nofmounts 2 -- sets the mounts as 2 bearers
#regainmount 1 -- will regain any lost mounts immediately after battle
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA_Unmounted2.tga"
#nofalldmg -- bearers will drop gently even with their dying action
#end


---- Stonecursed Sorcerer (stone curse level 1)

#newmonster 18153
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA2.tga"
#name "Stonecursed Sorcerer"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Each Sorcerer is, in addition to his considerable magical prowess in the arts of shadow, fire, magma, ash, and blood, also invested with considerable priestly authority and political power, though they leave the leadership of the Legions to the Castellans and the Overlords that serve the most powerful of their caste. This Sorcerer has begun to fully succumb to the inevitable ravages of the Stone Curse; his lower limbs have turned to stone and his thoughts and movements have begun to slow, though he has not yet lost any magical prowess. He is now carried everywhere by a pair of Warrior guards who will serve and protect him until he evenentually turns entirely to stone. Should the mage be slain his guards will carry away the body before ending their lives in shame.

[Each turn there is a chance to Stone Curse will progress, reducing all non-earth magic paths by 1, further encumbering the mage, and removing his chest slot and one hand slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#prot 5 --- +2 for the stone curse
#mor 13 --- leadership 9
#mr 16 --- middle mage dwarf
#enc 10 --- Sorcerer's curse is now causing problems
#str 10 --- mage
#att 9 --- curse slows them down
#def 8 --- curse slows them down
#prec 9 --- curse
#gcost 340
#rpcost 3 --- keep their rarity a bit, keep them more of a cap thing
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 500
#startage 250
#mountainsurvival
#siegebonus 2
#castledef 4
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 2 -- holy 2
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 1 -- earth 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#itemslots 860678 -- no feet, otherwise normal
#size 3
#mapmove 0
#ap 8
#immobile
#mountmnr 14467 -- warrior bearer
#nofmounts 2 -- sets the mounts as 2 bearers
#regainmount 1 -- will regain any lost mounts immediately after battle
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneA_Unmounted2.tga"
#nofalldmg -- her bearers will drop her gently even with their dying action
#end


---- Stonewracked Sorcerer (stone curse level 2)

#newmonster 18151
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneB.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneB2.tga"
#name "Stonewracked Sorcerer"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Each Sorcerer is, in addition to his considerable magical prowess in the arts of shadow, fire, magma, ash, and blood, also invested with considerable priestly authority and political power, though they leave the leadership of the Legions to the Castellans and the Overlords that serve the most powerful of their caste. This Sorcerer has almost entirely succumbed to the Stone Curse, losing all but one of his limbs to the spreading stone and seeing his magical powers quickly decline. The Stone Curse is known for its rapid acceleration, so it will not be long before this mage joins his ancestors as a lifeless statue. Should the mage be slain his guards will carry away the body before ending their lives in shame.

[Each turn there is a chance the Stone Curse will finally claim this mage, slaying him]"
#hp 12 --- toughness 4, mage so wounds don't add
#prot 7 --- +4 for the stone curse
#mor 13 --- leadership 9
#mr 16 --- middle mage dwarf
#enc 15 --- curse is worse
#str 10 --- mage
#att 9 --- curse slows them down
#def 8 --- curse slows them down
#prec 8 --- curse
#gcost 340
#rpcost 3 --- keep their rarity a bit, keep them more of a cap thing
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 500
#startage 250
#mountainsurvival
#siegebonus 2
#castledef 4
#darkvision 50
#nametype 192
#poorleader
#holy
#magicboost 0 -1
#magicboost 5 -1
#magicboost 8 -1
#magicskill 9 2 -- holy 2
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 1 -- earth 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#itemslots 795138 -- no feet, no body, only one hand, otherwise normal
#size 3
#mapmove 0
#ap 8
#immobile
#mountmnr 14467 -- warrior bearer
#nofmounts 2 -- sets the mounts as 2 bearers
#regainmount 1 -- will regain any lost mounts immediately after battle
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneB_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Sorcerer_stoneB_Unmounted2.tga"
#nofalldmg -- bearers will drop gently even with their dying action
#end


---- Sorcerer Lord (recruitment form)

#newmonster 18136
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord2.tga"
#name "Sorcerer Lord"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Sorcerer Lords are the most powerful members of their caste and wield both terrifying magic and almost absolute priestly and political authority. Every Sorcerer Lord must play a constant game of political manoeuvre with his peers, seeking the favour of Hashut and prestige amongst the cult as well as material wealth and military power. Their greed and ambition is virtually limitless, though they have begun to feel the mildest effects of the Stone Curse and have lost much of the passion and energy of their earlier life. Each Sorcerer Lord is served by his own personal Overlord to whom he delegates all military matters.

[When you recruit this commander you will also receive a free Overlord commander. This is factored into the recruitment cost. The Sorcerer Lord's upkeep is accordingly decreased]
[Each turn this mage has a chance to be afflicted by the Stone Curse, changing to a form carried by guards, gaining encumberance, and losing their foot slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 17 --- top mage dwarf
#enc 3 --- Dwarfs are known for their stamina, but sorcerers curse is hurting them
#str 10 --- mage
#att 10 --- weaponskill 3, but initiative 2
#def 9 --- weaponskill 3, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 12 -- dwarfs are really strong marchers, but these guys are very much not militarily minded
#ap 8 --- move 3
#gcost 600 -- +190 for the Overlord
#addupkeep -190 -- to offset the above
#rpcost 6 --- slow cap only mages with a free dude
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 600
#startage 400
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 3 -- holy 3
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 2 -- earth 2
#magicskill 8 1 -- blood 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#end



---- Sorcerer Lord (a bad montag result which then turns into the stonecursed form via event)

#newmonster 18154
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord2.tga"
#name "Sorcerer Lord"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Sorcerer Lords are the most powerful members of their caste and wield both terrifying magic and almost absolute priestly and political authority. Every Sorcerer Lord must play a constant game of political manoeuvre with his peers, seeking the favour of Hashut and prestige amongst the cult as well as material wealth and military power. Their greed and ambition is virtually limitless, though they have begun to feel the mildest effects of the Stone Curse and have lost much of the passion and energy of their earlier life. Each Sorcerer Lord is served by his own personal Overlord to whom he delegates all military matters.

[Each turn this mage has a chance to be afflicted by the Stone Curse, changing to a form carried by guards, gaining encumberance, and losing their foot slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 17 --- top mage dwarf
#enc 3 --- Dwarfs are known for their stamina, but sorcerers curse is hurting them
#str 10 --- mage
#att 10 --- weaponskill 3, but initiative 2
#def 9 --- weaponskill 3, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 12 -- dwarfs are really strong marchers, but these guys are very much not militarily minded
#ap 8 --- move 3
#gcost 600 -- +190 for the Overlord
#addupkeep -190 -- to offset the above
#rpcost 4 --- They are mages
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 600
#startage 400
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 3 -- holy 3
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 2 -- earth 2
#magicskill 8 1 -- blood 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#montag 1024 -- sorc lord good and bad forms
#montagweight 1 -- 5% chance to get this one
#end




---- Sorcerer Lord (this form is the montag target that then turns into the regular form)

#newmonster 18155
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord2.tga"
#name "Sorcerer Lord"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Sorcerer Lords are the most powerful members of their caste and wield both terrifying magic and almost absolute priestly and political authority. Every Sorcerer Lord must play a constant game of political manoeuvre with his peers, seeking the favour of Hashut and prestige amongst the cult as well as material wealth and military power. Their greed and ambition is virtually limitless, though they have begun to feel the mildest effects of the Stone Curse and have lost much of the passion and energy of their earlier life. Each Sorcerer Lord is served by his own personal Overlord to whom he delegates all military matters.

[Each turn this mage has a chance to be afflicted by the Stone Curse, changing to a form carried by guards, gaining encumberance, and losing their foot slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 17 --- top mage dwarf
#enc 3 --- Dwarfs are known for their stamina, but sorcerers curse is hurting them
#str 10 --- mage
#att 10 --- weaponskill 3, but initiative 2
#def 9 --- weaponskill 3, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 12 -- dwarfs are really strong marchers, but these guys are very much not militarily minded
#ap 8 --- move 3
#gcost 600 -- +190 for the Overlord
#addupkeep -190 -- to offset the above
#rpcost 4 --- They are mages
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 600
#startage 400
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 3 -- holy 3
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 2 -- earth 2
#magicskill 8 1 -- blood 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#shrinkhp 999 -- turn into the normal form immediately
#montag 1024 -- sorc lord good and bad forms
#montagweight 23 -- (23/24)
#end



---- Sorcerer Lord (this form is the one that now has an overlord)

#newmonster 18156
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord2.tga"
#name "Sorcerer Lord"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Sorcerer Lords are the most powerful members of their caste and wield both terrifying magic and almost absolute priestly and political authority. Every Sorcerer Lord must play a constant game of political manoeuvre with his peers, seeking the favour of Hashut and prestige amongst the cult as well as material wealth and military power. Their greed and ambition is virtually limitless, though they have begun to feel the mildest effects of the Stone Curse and have lost much of the passion and energy of their earlier life. Each Sorcerer Lord is served by his own personal Overlord to whom he delegates all military matters.

[Each turn this mage has a chance to be afflicted by the Stone Curse, changing to a form carried by guards, gaining encumberance, and losing their foot slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 13 --- leadership 9
#mr 17 --- top mage dwarf
#enc 3 --- Dwarfs are known for their stamina, but sorcerers curse is hurting them
#str 10 --- mage
#att 10 --- weaponskill 3, but initiative 2
#def 9 --- weaponskill 3, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 12 -- dwarfs are really strong marchers, but these guys are very much not militarily minded
#ap 8 --- move 3
#gcost 600 -- +190 for the Overlord
#addupkeep -190 -- to offset the above
#rpcost 4 --- They are mages
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 600
#startage 400
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 3 -- holy 3
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 2 -- earth 2
#magicskill 8 1 -- blood 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#end


---- Stonecursed Sorcerer Lord (this is the good montag result that shrinkhps into the normal form)

#newmonster 18146
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA2.tga"
#name "Stonecursed Sorcerer Lord"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Sorcerer Lords are the most powerful members of their caste and wield both terrifying magic and almost absolute priestly and political authority. Every Sorcerer Lord must play a constant game of political manoeuvre with his peers, seeking the favour of Hashut and prestige amongst the cult as well as material wealth and military power. This Sorcerer Lord has begun to fully succumb to the inevitable ravages of the Stone Curse; his lower limbs have turned to stone and his thoughts and movements have begun to slow, though he has not yet lost any magical prowess. He is now carried everywhere by a pair of Immortals who will serve and protect him even after he turns entirely to stone. Should the mage be slain his guards will carry away the body before ending their lives in shame.

[Each turn there is a chance the Stone Curse will progress, reducing all non-earth magic paths by 1, further encumbering the mage, and removing his chest slot and one hand slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#prot 5 --- +2 for the stone curse
#mor 13 --- leadership 9
#mr 17 --- top mage dwarf
#enc 10 --- Sorcerer's curse is now causing problems
#str 10 --- mage
#att 9 --- curse slows them down
#def 8 --- curse slows them down
#prec 9 --- curse
#gcost 600 -- +190 for the Overlord
#addupkeep -190 -- to offset the above
#rpcost 4 --- They are mages
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 600
#startage 400
#mountainsurvival
#siegebonus 2
#castledef 4
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 3 -- holy 3
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 2 -- earth 2
#magicskill 8 1 -- blood 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#itemslots 860678 -- no feet, otherwise normal
#montag 1025 -- stonecursed sorc lord montag
#montagweight 18 -- (18/20, the other one has weight of 2) -- so 90%
#shrinkhp 999
#size 3
#mapmove 0
#ap 8
#immobile
#mountmnr 14468 -- immortal
#nofmounts 2 -- sets the mounts as 2 bearers
#regainmount 1 -- will regain any lost mounts immediately after battle
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA_Unmounted2.tga"
#nofalldmg -- bearers will drop gently even with their dying action
#end


---- Immortal Bearer

#newmonster 14468
#spr1 "Warhammer_Chaos_Dwarfs/Bearer_Immortal.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Bearer_Immortal2.tga"
#name "Immortal Bearer"
#descr "This Immortal has the sacred duty of carrying a Stonecursed Sorcerer Lord. Should the Sorcerer Lord ever lose his bearers they will immediately be replaced."
#hp 15 --- toughness 4, description makes them sound even tougher
#size 3 --- yep, they aren't that small
#prot 3 --- toughness 4
#mor 14 --- leadership 9 + stubborn
#mr 12 --- better mr than most chaos dwarfs
#enc 2 --- Dwarfs are known for their stamina
#str 12 --- str 4
#att 12 --- weaponskill 5, but initiative 2
#def 11 --- weaponskill 5, but initiative 2
#prec 10 --- ballistic skill 3
#mapmove 18 -- dwarfs are really strong marchers
#ap 12 --- set to get combat speed to 6
#gcost 35
#addupkeep -17
#rpcost 35 --- They need to have order scales
#rcost 1
#armor 992 -- immortal gold plate
#armor 213 -- golden helmet
#weapon 1907 -- mastercrafted axe
#maxage 500
#startage 250
#mountainsurvival
#wastesurvival
#siegebonus 1
#castledef 2
#darkvision 50
#nametype 192
#bodyguard 2
#neednoteat
#appetite 1
#holy
#nobarding
#bravemount 100
#end


---- Stonecursed Sorcerer Lord (this is the bad montag result that shrinkhps into the stonewracked form)

#newmonster 18157
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA2.tga"
#name "Stonecursed Sorcerer Lord"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Sorcerer Lords are the most powerful members of their caste and wield both terrifying magic and almost absolute priestly and political authority. Every Sorcerer Lord must play a constant game of political manoeuvre with his peers, seeking the favour of Hashut and prestige amongst the cult as well as material wealth and military power. This Sorcerer Lord has begun to fully succumb to the inevitable ravages of the Stone Curse; his lower limbs have turned to stone and his thoughts and movements have begun to slow, though he has not yet lost any magical prowess. He is now carried everywhere by a pair of Immortals who will serve and protect him even after he turns entirely to stone. Should the mage be slain his guards will carry away the body before ending their lives in shame.

[Each turn there is a chance the Stone Curse will progress, reducing all non-earth magic paths by 1, further encumbering the mage, and removing his chest slot and one hand slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#prot 5 --- +2 for the stone curse
#mor 13 --- leadership 9
#mr 17 --- top mage dwarf
#enc 10 --- Sorcerer's curse is now causing problems
#str 10 --- mage
#att 9 --- curse slows them down
#def 8 --- curse slows them down
#prec 9 --- curse
#gcost 600 -- +190 for the Overlord
#addupkeep -190 -- to offset the above
#rpcost 4 --- They are mages
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 600
#startage 400
#mountainsurvival
#siegebonus 2
#castledef 4
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 3 -- holy 3
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 2 -- earth 2
#magicskill 8 1 -- blood 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#itemslots 860678 -- no feet, otherwise normal
#montag 1025 -- stonecursed sorc lord montag
#montagweight 2 -- (2/20, the other one has weight of 18) -- so 10%
#size 3
#mapmove 0
#ap 8
#immobile
#mountmnr 14468 -- immortal
#nofmounts 2 -- sets the mounts as 2 bearers
#regainmount 1 -- will regain any lost mounts immediately after battle
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA_Unmounted2.tga"
#nofalldmg -- bearers will drop gently even with their dying action
#end



---- Stonecursed Sorcerer Lord (tier 1 of stone curse)

#newmonster 18147
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA2.tga"
#name "Stonecursed Sorcerer Lord"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Sorcerer Lords are the most powerful members of their caste and wield both terrifying magic and almost absolute priestly and political authority. Every Sorcerer Lord must play a constant game of political manoeuvre with his peers, seeking the favour of Hashut and prestige amongst the cult as well as material wealth and military power. This Sorcerer Lord has begun to fully succumb to the inevitable ravages of the Stone Curse; his lower limbs have turned to stone and his thoughts and movements have begun to slow, though he has not yet lost any magical prowess. He is now carried everywhere by a pair of Immortals who will serve and protect him even after he turns entirely to stone. Should the mage be slain his guards will carry away the body before ending their lives in shame.

[Each turn there is a chance the Stone Curse will progress, reducing all non-earth magic paths by 1, further encumbering the mage, and removing his chest slot and one hand slot]"
#hp 12 --- toughness 4, mage so wounds don't add
#prot 5 --- +2 for the stone curse
#mor 13 --- leadership 9
#mr 17 --- top mage dwarf
#enc 10 --- Sorcerer's curse is now causing problems
#str 10 --- mage
#att 9 --- curse slows them down
#def 8 --- curse slows them down
#prec 9 --- curse
#gcost 600 -- +190 for the Overlord
#addupkeep -190 -- to offset the above
#rpcost 4 --- They are mages
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 600
#startage 400
#mountainsurvival
#siegebonus 2
#castledef 4
#darkvision 50
#nametype 192
#poorleader
#holy
#magicskill 9 3 -- holy 3
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 2 -- earth 2
#magicskill 8 1 -- blood 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#itemslots 860678 -- no feet, otherwise normal
#size 3
#mapmove 0
#ap 8
#immobile
#mountmnr 14468 -- immortal
#nofmounts 2 -- sets the mounts as 2 bearers
#regainmount 1 -- will regain any lost mounts immediately after battle
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneA_Unmounted2.tga"
#nofalldmg -- bearers will drop gently even with their dying action
#end


---- Stonewracked Sorcerer Lord (tier 2 of stone curse)

#newmonster 18148
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneB.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneB2.tga"
#name "Stonewracked Sorcerer Lord"
#descr "Any Chaos Dwarf that shows aptitude for magic, however weak, is taken from his clan and inducted into the Cult of Hashut. Those rare Dwarfs whose magical abilities quickly outstrip those of their fellows eventually form the upper echelon of the Cult; they are the Sorcerers, and it is their place to rule all of Chaos Dwarf society. Sorcerer Lords are the most powerful members of their caste and wield both terrifying magic and almost absolute priestly and political authority. Every Sorcerer Lord must play a constant game of political manoeuvre with his peers, seeking the favour of Hashut and prestige amongst the cult as well as material wealth and military power. This Sorcerer Lord has almost entirely succumbed to the Stone Curse, losing all but one of his limbs to the spreading stone and seeing his magical powers quickly decline. The Stone Curse is known for its rapid acceleration, so it will not be long before this mage joins his ancestors as a lifeless statue. Should the mage be slain his guards will carry away the body before ending their lives in shame.

[Each turn there is a chance the Stone Curse will finally claim this mage, removing all magic paths except holy and removing all but 2 misc item slots. The Immortal guards will continue to carry the mage, even as a statue]"
#hp 12 --- toughness 4, mage so wounds don't add
#prot 7 --- +4 for the stone curse
#mor 13 --- leadership 9
#mr 17 --- top mage dwarf
#enc 15 --- curse is worse
#str 10 --- mage
#att 9 --- curse slows them down
#def 8 --- curse slows them down
#prec 8 --- curse
#gcost 600 -- +190 for the Overlord
#addupkeep -260 -- to offset the above, less upkeep as the mage gets worse with stone curse
#rpcost 4 --- They are mages
#rcost 1
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 172 -- magic sceptre
#maxage 600
#startage 400
#mountainsurvival
#siegebonus 2
#castledef 4
#darkvision 50
#nametype 192
#poorleader
#holy
#magicboost 0 -1
#magicboost 5 -1
#magicboost 8 -1
#magicskill 9 3 -- holy 3
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 2 -- earth 2
#magicskill 8 1 -- blood 1
#custommagic 38016 100 -- 100% EFDB
#neednoteat
#appetite 1
#itemslots 795138 -- no feet, no body, only one hand, otherwise normal
#size 3
#mapmove 0
#ap 8
#immobile
#mountmnr 14468 -- immortal
#nofmounts 2 -- sets the mounts as 2 bearers
#regainmount 1 -- will regain any lost mounts immediately after battle
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneB_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneB_Unmounted2.tga"
#nofalldmg -- bearers will drop gently even with their dying action
#end


---- Sorcerer Lord Statue (tier 3 of stone curse)

#newmonster 18149
#spr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneC.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneC2.tga"
#name "Sorcerer Lord Statue"
#descr "This Sorcerer Lord has entirely succumbed to the Stone Curse and is now a lifeless statue, though still carried into battle by his Immortal guards as a sacred symbol of his people. The statue is still inhabited by some remnant of the spirit of the Sorcerer Lord and has as much divine authority as ever, but no ability to use non-holy magic of any kind."
#hp 16
#prot 17
#mor 30
#mr 18
#enc 4
#str 10
#att 1
#def 1
#prec 10
#gcost 600 -- +190 for the Overlord
#addupkeep -290 -- to offset the above, less upkeep as the mage gets worse with stone curse
#rpcost 4 --- They are mages
#rcost 1
#noweapon
#maxage 600
#startage 400
#mountainsurvival
#darkvision 50
#nametype 192
#poorleader
#holy
#stonebeing
#magicskill 9 3 -- holy 3
#magicboost 0 -5
#magicboost 1 -5
#magicboost 2 -5
#magicboost 3 -5
#magicboost 4 -5
#magicboost 5 -5
#magicboost 6 -5
#magicboost 8 -5
#neednoteat
#itemslots 786432 -- just 2 misc, nothing else
#bonusspells 1 -- innate spellcaster
#size 3
#mapmove 0
#ap 8
#immobile
#mountmnr 14468 -- immortal
#nofmounts 2 -- sets the mounts as 2 bearers
#regainmount 1 -- will regain any lost mounts immediately after battle
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneC_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Sorcerer_Lord_stoneC_Unmounted2.tga"
#nofalldmg -- bearers will drop gently even with their dying action
#end



-------- PRETENDERS


-------- NATIONAL HEROES


---- Shar'Tor the Executioner

#newmonster 18141
#spr1 "Warhammer_Chaos_Dwarfs/Hero_Shartor.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hero_Shartor2.tga"
#name "Executioner of Hashut"
#descr "Perhaps the greatest amongst the Bull Centaur Ancients, Shar'Tor is known as the Executioner, for he is the favoured headsman of Hashut. It is said that he has never failed to bring judgement to a marked foe of the Chaos Dwarfs dark god and his mere presence spreads the dominion of Hashut, though he preaches not a single word. Indeed Shar'Tor lets not a single syllable pass from gilded mask that hides his visage until he is in battle with the foe, at which point he calls out the will of Hashut with such force that the weak of heart simply drop dead in front of him. Shar'Tor wields the Darktide Axe, a cruel weapon steeped in untold years of slaughter upon which burn runes of hate and malice."
#hp 90 --- +20 over the regular ancient
#size 8 --- as much mass as a melqart
#prot 9 --- +1 over ancient
#mor 18 --- +2 over ancient
#mr 16 --- combat commander tier 4, racial bonuses
--
#enc 3 --- big monster
#str 28 --- +3 over ancient
#att 15 --- +1 over ancient
#def 14 --- +1 over ancient
#prec 10 --- ballistic skill 3
#mapmove 24 -- centaurs +2 because, though they're slower, they're better marchers
#ap 28 --- (normal centaur has 30)
#gcost 0 -- hero
#armor 994 -- Mask of the Executioner
#armor 14 -- plate hauberk
#weapon 1902 -- darktide axe
#weapon 55 -- hoof ala centaurs
#weapon 399 -- gore
#weapon 1901 -- will of hashut
#maxage 2000 -- +500 over ancient
#startage 1600 -- +400 over ancient
#mountainsurvival
#castledef 2
#darkvision 50
#holy
#mountedhumanoid -- the value to use for centaurs
#fireres 5
#neednoteat
#appetite 4
#fear 8
#fixedname "Shar'Tor"
#spreaddom 1
#startitem 913 -- Mask of the Executioner
#end


---- Gorduz Backstabba

#newmonster 18142
#spr1 "Warhammer_Chaos_Dwarfs/Hero_Gorduz.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hero_Gorduz2.tga"
#name "Hobgoblin Chieftain"
#descr "All Hobgoblins are sneaky, conniving, cowardly, and treacherous, and Gorduz Backstabba is perhaps the most self-serving of the lot. Gorduz embodies all the vices and virtues that make Hobgoblins what they are and as such has been extremely succesful, rising to the position of the most powerful Chieftain within the realm of the Chaos Dwarfs. Unlike the Khans of the East who have a more independent spirit, Gorduz has lived his life under the harsh rule of Chaos Dwarfs and has been careful to not only avoid their wrath but cleverly and strategically displace it onto others of his kind. In addition to his considerable and ruthless cunning it must be noted that Gorduz has proven, for whatever reason, almost impossible to kill. In fact numerous times he has been reported slain, usually having been betrayed by one or more other Hobgoblins, only to re-appear some time later to enact bloody revenge."
#hp 24 --- +7 over khan
#size 3
#prot 3 --- +1 over khan
#mor 10 --- leadership 7
#mr 13 --- combat commander tier 3
--
#enc 3
#str 11 --- smaller than humans, str 4
#att 13 --- +1 over khan
#def 14 --- +2 over khan
#prec 13 --- +2 over khan
#mapmove 14 -- standard human move
#ap 12 --- normal, move 4
#gcost 0 --- hero
#rpcost 1 --- basic military commander
#rcost 1
#weapon 17 -- axe
#armor 20 -- iron cap
#armor 12 -- regular scale mail hauberk
#armor 2 -- basic shield
#mountainsurvival
#stealthy 20
#pillagebonus 10
#darkvision 50
#goodleader
#fixedname "Gorduz Backstabba"
#immortal
#onebattlespell "Personal Luck"
#skilledrider 4
#mobilearcher 1
#mountmnr 14466 -- hobgoblin steppe wolf
#unmountedspr1 "Warhammer_Chaos_Dwarfs/Hero_Gorduz_Unmounted.tga"
#unmountedspr2 "Warhammer_Chaos_Dwarfs/Hero_Gorduz_Unmounted2.tga"
#end


---- Astragoth

#newmonster 18144
#spr1 "Warhammer_Chaos_Dwarfs/Hero_Astragoth.tga"
#spr2 "Warhammer_Chaos_Dwarfs/Hero_Astragoth2.tga"
#name "High Priest of Hashut"
#descr "Astragoth is the oldest living Chaos Dwarf Sorcerer and the current High Priest of Hashut, placing him squarely at the top of the pyramid that is Chaos Dwarf society. At the height of his powers he was the most potent sorcerer to walk the Plain of Zharr in a thousand years, feared by his foes and respected by all. In recent decades his powers have waned and the Stone Curse has begun to wreak its terrible damage, turning all of his limbs to stone. Though none would openly admit it this was cause for joy amongst his many rivals, especially those with a chance to ascend to the position of High Priest, but to their dismay Astragoth has, seemingly through sheer will, temporarily halted his petrification. Seemingly to spite those predicting his immiment downfall, the High Priest has fashioned magical machinery to replace the function of his limbs and taken to the field with renewed vigour. His mechanical limbs grant him great strength, durability, and mobility."
#hp 34 --- tough (W4 T5) and mech suit. He's a wizard, but this is ignored for warhammer hero hp
#prot 9 --- mech suit + just a tough old dwarf + turning to stone!
#mor 15
#mr 18
#enc 5 --- mech suit offsets the stone curse somewhat, but it's pretty advanced on him
#str 17
#att 11
#def 10
#prec 10 --- ballistic skill 3
#mapmove 22 -- mech suit, equal to best marchers + 2
#ap 14 --- mech legs
#gcost 0
#armor 118 -- Half Helmet
#armor 997 -- dwarf scale mail cuirass
#weapon 1938 -- mechanical hammer
#maxage 1000 -- he's extended his life somehow, the cheeky old goat
#startage 700 -- +200 over regular SLs
#mountainsurvival
#siegebonus 1
#castledef 2
#darkvision 50
#fixedname "Astragoth Ironhand"
#poorleader
#holy
#magicskill 9 4 -- holy 4
#magicskill 0 2 -- fire 2
#magicskill 5 1 -- death 1
#magicskill 3 2 -- earth 3
#magicskill 8 1 -- blood 1
#neednoteat
#appetite 1
#itemslots 795142 -- 2 hands, 1 head, torso, 2 misc, bow
#end

---- Zhatan the Black







------------- FLAG MONSTERS FOR EVENTS


----- FLAG monster to indicate that this province was at some point conquered by the Chaos Dwarfs (6kA version)

#newmonster 18165
#copyspr 18 -- militia
#name "Conquered by dark elves 6kA"
#descr "If you see this then it's a bug, please report to the maker of this mod."
#nowish
#stealthy 999
#itemslots 139264 -- 1 feet
#hp 500
#size 9
#prot 40
#mr 50
#mor 50
#str 50
#att 50
#def 50
#prec 50
#enc 0
#mapmove 0
#invisible
#immobile
#unteleportable
#ap 0
#maxage 10000
#amphibian
#gcost 0
#woundfend 1000
#inanimate
#landdamage 100 -- dies on land at end of turn
#uwdamage 100 -- dies uw at end of turn
#nohof
#heal
#float
#end

----- FLAG monster to indicate that this province was at some point conquered by the Chaos Dwarfs (4kA version)

#newmonster 18166
#copystats 18165 -- first flag monster
#copyspr 18 -- militia
#name "Conquered by dark elves 4kA"
#descr "If you see this then it's a bug, please report to the maker of this mod."
#end

----- FLAG monster to indicate that this province was at some point conquered by the Chaos Dwarfs (2kA version)

#newmonster 18167
#copystats 18165 -- first flag monster
#copyspr 18 -- militia
#name "Conquered by dark elves 2kA"
#descr "If you see this then it's a bug, please report to the maker of this mod."
#end

----- FLAG monster to indicate that this province was at some point conquered by the Chaos Dwarfs (6kB version)

#newmonster 18168
#copystats 18165 -- first flag monster
#copyspr 18 -- militia
#name "Conquered by dark elves 6kB"
#descr "If you see this then it's a bug, please report to the maker of this mod."
#end

----- FLAG monster to indicate that this province was at some point conquered by the Chaos Dwarfs (4kB version)

#newmonster 18169
#copystats 18165 -- first flag monster
#copyspr 18 -- militia
#name "Conquered by dark elves 4kB"
#descr "If you see this then it's a bug, please report to the maker of this mod."
#end

----- FLAG monster to indicate that this province was at some point conquered by the Chaos Dwarfs (2kB version)

#newmonster 18170
#copystats 18165 -- first flag monster
#copyspr 18 -- militia
#name "Conquered by dark elves 2kB"
#descr "If you see this then it's a bug, please report to the maker of this mod."
#end

----- FLAG monster to indicate that this province was at some point conquered by the Chaos Dwarfs (6kC version)

#newmonster 18171
#copystats 18165 -- first flag monster
#copyspr 18 -- militia
#name "Conquered by dark elves 6kC"
#descr "If you see this then it's a bug, please report to the maker of this mod."
#end

----- FLAG monster to indicate that this province was at some point conquered by the Chaos Dwarfs (4kC version)

#newmonster 18172
#copystats 18165 -- first flag monster
#copyspr 18 -- militia
#name "Conquered by dark elves 4kC"
#descr "If you see this then it's a bug, please report to the maker of this mod."
#end

----- FLAG monster to indicate that this province was at some point conquered by the Chaos Dwarfs (2kC version)

#newmonster 18173
#copystats 18165 -- first flag monster
#copyspr 18 -- militia
#name "Conquered by dark elves 2kC"
#descr "If you see this then it's a bug, please report to the maker of this mod."
#end








-------- SPELLS



---- Forge Kdaai

#newspell
#name "Forge Kdaai Fireborn"
#descr "Kdaai Fireborn are a fusion of ensorcelled armour, Daemonic matter, and magmatic blood. These near mindless living weapons of fire and bronze are perhaps the ultimate tools of Chaos Dwarf power, though in battle they will slowly consume themselves and sputter out, perhaps before the foe can be entirely crushed. Working with Daemonsmiths to forge and empower two suits of bronze armour dipped in the blood of sacrifices to Hashut, the Sorcerer can then channel both lava and otherworldy Daemonic matter into the vessel to create a pair of Kdaai Fireborn" 
--details "Summons 2 Kdaai Fireborn."
#researchlevel 4
#school 3 -- construction
#path 0 0 -- fire
#path 1 8 -- blood
#pathlevel 0 3 -- F3
#pathlevel 1 1 -- B1
#fatiguecost 800
#damage 18143 -- kdaai fireborn
#effect 10001 -- summon troop
#nreff 2
#restricted 164 -- chaos dwarfs
#end


---- Fund Sorcerer

#newspell
#name "Fund Sorcerer"
#descr "Chaos Dwarf Sorcerers are notoriously ambitious mages always keen to increase their personal status and power. By offering significant funding in fire gems, a precious resource to their kind, a middling member of the Cult of Hashut can be attracted to serve."
#researchlevel 0
#school 3 -- construction
#path 0 0 -- fire
#pathlevel 0 3 -- F3
#fatiguecost 2000
#damage 18160 -- sorcerer
#effect 10021 -- summon commander
#nreff 1
#restricted 164 -- chaos dwarfs
#end


-- Soul of Hashut

#newspell
#copyspell "Phoenix Pyre"
#name "Soul of Hashut"
#descr "Hashut is a vile God. A vile God with many facets and forms. But his essence, his soul is that of fire. Dirty, soot-producing fire. And brimstone. One of his most devout priests imbues the spirit of that soul into a small group of his followers. They become as an undying and uncontrolled fire."
#aoe 1
#range 15
#researchlevel 5
#path 1 9
#pathlevel 0 4
#pathlevel 1 3
#fatiguecost 250
#precision 100
#restricted 164
#end

-- Spread the Stonecurse

#newspell
#copyspell "Curse of Stones"
#name "Spread the Stonecurse"
#descr "Chaos Dwarves were, as their name implies, once dwarves. And though they have been warped and changed by the powers of chaos and the worship of Hashut, at heart dwarves they remain. Dwarves were never intended to manipulate the winds of magic, their wont was to craft runes and imbue them with magics passed down from their ancestors. Though chaos has allowed them access to the winds, is comes at great cost. Yet even this, by the sheer ingenuity of their race, has been turned to some advantage. An enterprising and devious Chaos Sorceror Lord discovered a way to spread the stone curse to his enemies. Even non-Chaos Dwarf ones. Eventually the secret was discovered by others and now it is deployed effectively in battle."
#aoe 1
#range 10015
#fatiguecost 50
#casttime 100
#pathlevel 0 2
#path 1 9
#pathlevel 1 1
#researchlevel 2
#precision 100
#spec 536891520
#restricted 164
#aispellmod 40
#end


-- Weight of Brimstone (Secondary effect of Army of Brimstone)

#newspell
#copyspell "Slow"
#name "Weight of Brimstone"
#path 0 3
#school -1
#aoe 0
#spec 12582916
#restricted 164
#end

-- Army of Brimstone

#newspell
#copyspell "Marble Army"
#name "Army of Brimstone"
#descr "A great Chaos Dwarf Sorceror invokes Hashut and imbues his nature into the forms of his allies. Though there is some cost."
#details "[The entire army gains Stoneskin, +5 fire resistance, piercing and slashing resistance, as well as the negative effects of Slow]"
#damage 343597450240
#path 1 0
#pathlevel 1 3
#researchlevel 7
#restricted 164
#nextspell "Weight of Brimstone"
#end


-------- SITES

--- Temple of Hashut

#newsite 2023
#name "Temple of Hashut"
#path 9
#level 0
#rarity 5
#gems 5 1 -- 1 death
#homemon 18123 -- Acolyte
#homemon 18106 -- Bull Centaur
#homecom 18132 -- Bull Centaur Ancient
#end

--- Tower of Zharr

#newsite 2024
#name "Tower of Zharr"
#path 9
#level 0
#rarity 5
#homemon 18122 -- Immortal
#homecom 18130 -- Overlord
#homecom 18136 -- Sorcerer Lord
#end

--- Forges in the Deep

#newsite 2025
#name "Forges in the Deep"
#path 0
#level 0
#rarity 5
#gems 0 2 -- 2 fire
#gems 3 2 -- 2 earth
#homecom 18133 -- Daemonsmith
#homemon 18145 -- Slavegiant
#end

--- Infernal Outpost

#newsite 1863 -- infernal outpost
#name "Infernal Outpost"
#path 8 -- blood
#level 0
#rarity 5
#nat 164 -- chaos dwarfs
#natmon 18103 -- Infernal Guard
#natmon 18104 -- Infernal Fireglaive
#natmon 18105 -- Infernal Guard Chosen
#natcom 18131 -- Infernal Deathmask
#end



------- Chaos Dwarfs (a site used to indicate that chaos dwarfs control this province, because it can help determine whether they did the turn previous)

#newsite 2034
#name "Chaos Dwarfs"
#path 9 -- holy, to help it hide
#level 9 -- to make it found less often
#rarity 5
#end


--- Futuresite luck-independent Heroes

#newsite 2080
#name "Chaos Dwarf Luck-independent Heroes"
#clear
#path 0 -- fire
#level 0
#rarity 5
#homecom 18141 -- Shar'Tor the Executioner
#homecom 18142 -- Gorduz
#homecom 18144 -- Astragoth (hero)
#end

--- Futuresite multiheroes

#newsite 2081
#name "Chaos Dwarf Multiheroes"
#clear
#path 4 -- astral
#level 0
#rarity 5
#homecom 18136 -- Sorcerer Lord
#homecom 18132 -- Bull Centaur Ancient
#end

--- Futuresite Summons

#newsite 2082
#name "Chaos Dwarf Summons"
#path 0 -- fire
#level 0
#rarity 5
#homemon 18143 -- Fireborn
#homecom 18160 -- Sorcerer
#end

--- Futuresite Slaves

#newsite 2083
#name "Chaos Dwarf Slaves"
#path 5 -- death
#level 0
#rarity 5
#homemon 18119
#homemon 18120
#homemon 18111
#homemon 18138
#homemon 18112
#homemon 18113
#homemon 18121
#homemon 18139
#homemon 18114
#homemon 18115
#homemon 18140
#homemon 18116
#homemon 18117
#end

--- Futuresite Stone Curse

#newsite 2084
#name "Stone Curse Progression"
#path 3 -- earth
#level 0
#rarity 5
#homecom 18153 -- sorcerer stone curse 1
#homecom 18151 -- sorcerer stone curse 2
#homecom 18147 -- sorcerer lord stone curse 1
#homecom 18148 -- sorcerer lord stone curse 2
#homecom 18149 -- sorcerer lord stone curse 3
#end



-------- ITEMS


-------- NAMETYPES

--- Chaos Dwarf -- from here: http://chaosdwarfng.weebly.com/

#selectnametype 192
#clear
#addname "Hashgoth Orechain"
#addname "Undalkhar Goldeye"
#addname "Bharkur Sternwalker"
#addname "Ishgrakka Irongrinder"
#addname "Zyhutti Siegecleaver"
#addname "Yashkhar Stonecurse"
#addname "Idinzhakh Fellkeeper"
#addname "Uhutti Harshscribe"
#addname "Tagoth Hardnail"
#addname "Darnezharr Greymouth"
#addname "Dagoth Hellbull"
#addname "Barimbul Hellwalker"
#addname "Helkad Siegestep"
#addname "Thavrock Banehelm"
#addname "Tharth Goldforge"
#addname "Fhardhak Brassfist"
#addname "Marzherak Flamechain"
#addname "Sindelund Ashsmith"
#addname "Yashgir Demonscourge"
#addname "Bzaabaknul Coalarm"
#addname "Bhaharr Bloodnail"
#addname "Gothnakar Doomspeaker"
#addname "Zakkh Firecleaver"
#addname "Taanuk Fellbrow"
#addname "Bhazhinsar Sternforge"
#addname "Tharzhakh Chaosbinder"
#addname "Karram Blackbarrel"
#addname "Lamakhorth Flinthat"
#addname "Zhazhakh Slavebinder"
#addname "Lamaroth Sootshaper"
#addname "Bharharr Shadowtooth"
#addname "Magoth Redfinger"
#addname "Gorlund Spitehat"
#addname "Hazhhoth Fellmaker"
#addname "Htharahki Chaoswatcher"
#addname "Haorth Skullarm"
#addname "Uhoth Cinderhelm"
#addname "Kororh Helllasher"
#addname "Gorkh Bullkiln"
#addname "Bharekar Goreseer"
#addname "Halzharr Skullstep"
#addname "Thadohz Blooddeed"
#addname "Bhalbaknul Chaosfurnace"
#addname "Azhgon Bloodnail"
#addname "Hothkhorth Felltusk"
#addname "Hashrh Dreadbrow"
#addname "Fharzharr Bloodwalker"
#addname "Ashdrakk Sternseer"
#addname "Ashzhikul Hellhelm"
#addname "Asurudohz Forgekiln"
#addname "Pazhanuk Firewatcher"
#addname "Glazlhad Banearm"
#addname "Wargrakka Flintfist"
#addname "Marroth Siegechanter"
#addname "Uharr Skullbinder"
#addname "Tharhak Goldback"
#addname "Idinkezhar Banebinder"
#addname "Thagrund Brasscutter"
#addname "Pazhlhad Heavykeeper"
#addname "Gothetar Scarglair"
#addname "Bhalrahki Chaosglair"
#addname "Thargrakh Goreshackler"
#addname "Nabhak Bronzetooth"
#addname "Helram Flintwhip"
#addname "Thaekar Sootaxe"
#addname "Yashtan Forgeshaper"
#addname "Undalrh Hellgrinder"
#addname "Morrahki Thunderspeaker"
#addname "Gharetar Fellside"
#addname "Thargoth Hellfuse"
#addname "Undalkezhar Brassflayer"
#addname "Lamazhinsar Spitecutter"
#addname "Rartor Goldsmelter"
#addname "Ghauram Redshackler"
#addname "Korolund Steeldeed"
#addname "Zhirgrakh Sternwalker"
#addname "Wargrakka Ashcaller"
#addname "Idinlhad Greychest"
#addname "Zoltan Ashcloud"
#addname "Baal Smeltflayer"
#addname "Tagahrn Ashtusk"
#end


--- Hobgoblin Names

#selectnametype 191
#clear
#addname "Zuvtik Backstabber"
#addname "Zorgram Guthooker"
#addname "Bulban Darkstab"
#addname "Duvtuk Spitehook"
#addname "Noltot Killtoof"
#addname "Raldrud Hamstringer"
#addname "Heghong the Crippler"
#addname "Muthag Ribpoker"
#addname "Drelding Spleenbiter"
#addname "Settag Cravenfang"
#addname "Uvlang Fastfoot"
#addname "Halger Longknife"
#addname "Nildit Spinestabber"
#addname "Kigtom Backblade"
#addname "Sarkug Throatstabber"
#addname "Mattut Throatblade"
#addname "Pratrug Slitmouth"
#addname "Drardrur Goldtoof"
#addname "Reldrid Goldnabber"
#addname "Pravlut Toofstealer"
#addname "Takruk Sly Git"
#addname "Ullok Gutstikka"
#addname "Urtar Bowelhack"
#addname "Elgir Earbiter"
#addname "Nalug Neckstabber"
#addname "Sulbrak Lootsnatcha"
#addname "Orlem Toofsnatcha"
#addname "Zuldrag Bigrunt"
#addname "Nulot Orcslicer"
#addname "Sorlod Traitorknife"
#addname "Takruk Gutstealer"
#addname "Ullok Toofstealer"
#addname "Urtar Goldstealer"
#addname "Elgir Cheatgrin"
#addname "Nalug Toofblade"
#addname "Sulbrak Sharpknife"
#addname "Orlem Knifestab"
#addname "Zuldrag Darkgrin"
#addname "Nulot Shiftyslicer"
#addname "Sorlod Creepstabba"
#addname "Sirdeg Toofnicka"
#addname "Prutrat Smilesnatcha"
#addname "Erdig Grubnicka"
#addname "Prekhet Grubstabber"
#addname "Iktum Cardcheat"
#addname "Hethuk Backstabber"
#addname "Kuru Guthooker"
#addname "Fevrok Darkstab"
#addname "Fergrot Spitehook"
#addname "Gavluk Killtoof"
#addname "Prokte Hamstringer"
#addname "Nultid the Crippler"
#addname "Delud Ribpoker"
#addname "Atrok Spleenbiter"
#addname "Terlod Cravenfang"
#addname "Orgek Fastfoot"
#addname "Prigtong Longknife"
#addname "Zokrung Spinestabber"
#addname "Meldu Backblade"
#addname "Krerlan Throatstabber"
#addname "Pavror Throatblade"
#addname "Highok Slitmouth"
#addname "Ugtek Goldtoof"
#addname "Sithing Goldnabber"
#addname "Tidrang Toofstealer"
#addname "Zettik Sly Git"
#addname "Gorgrag Gutstikka"
#addname "Urgon Bowelhack"
#addname "Nigtak Earbiter"
#addname "Rekted Neckstabber"
#addname "Follat Lootsnatcha"
#addname "Kilbrud Toofsnatcha"
#addname "Ilgek Bigrunt"
#addname "Hitrak Orcslicer"
#addname "Krovlar Traitorknife"
#addname "Gektum Gutstealer"
#addname "Huglak Toofstealer"
#addname "Okled Goldstealer"
#addname "Ortim Cheatgrin"
#addname "Gogtut Toofblade"
#addname "Grirgruk Sharpknife"
#addname "Zaklok Knifestab"
#addname "Erdug Darkgrin"
#addname "Helbot Shiftyslicer"
#addname "Sette Creepstabba"
#addname "Grirdeg Toofnicka"
#addname "Faglur Smilesnatcha"
#addname "Rudro Grubnicka"
#addname "Bakhok Grubstabber"
#addname "Markung Cardcheat"
#addname "Hallud Guttickler"
#addname "Eghim Spleentickler"
#addname "Grogra Smee"
#addname "Huldrag Bowelslicer"
#addname "Kurdung Bloodstabber"
#addname "Fulding Bloodknife"
#addname "Elbom Bloodfangs"
#addname "Pirgod Longlegs"
#addname "Gevrir Longlegs"
#addname "Grirdeg Arrowbiter"
#end



------------------------------------------ EVENTS

---------------- WELCOME TO CHAOS DWARFS -----------------

#newevent
#msg "Chaos Dwarf special mechanics explainer:

Enslavement. When you conquer a province with a commander and 15+ troops and the province population is > 3000, some of the population are enslaved and sent to one of your forts, granting resources, gold, population, blood and battle slaves. With 20+ troops there is an event for population > 6000 and with 25+ an event for population > 8000. Each size of event can trigger 3 times each turn, for a total of 9 possible Enslavement events.

Stone Curse. Each Sorcerer and Sorcerer Lord has chance each turn (3% and 5% respectively) to become afflicted with the Curse. It starts by turning their legs to stone, removing their foot slot. They will be carried by guards and won't be immobile, but each turn there's 15% chance the curse worsens, removing the body slot and a hand slot. Then each turn there's 33% chance it turns them entirely to stone, killing Sorcerers and turning Sorcerer Lords into a H3 priest with no magic.

Slavers. Each province with population above 2000 and unrest below 20 will produce 1d3 slaves if a Slaver is present. Stacking Slavers does not make more slaves.

Fort Pollution. You pollute any province where you own or are sieging a fort, pushing local Death scale towards 1 if the province has neutral or better Growth.

Infernal Outposts. The shunned Infernal Guard may only be recruited in forts outside your capital."
#header 2 -- use the first line of the event as the header
#req_owncapital 1
#req_pregame 1 -- only happens before the first turn of the game
#req_fornation 164 -- chaos dwarfs
#nation 164 -- owned by chaos dwarfs
#req_unique 1
#rarity 5
#end





------------ ENSLAVEMENT EVENTS (modified from Dark Elves)

-------- Slaver is present so passive slave generation

-- Slaves if unrest is low enough and enough people present
#newevent
#msg "Your Slaver in this province has acquired some slaves to be pushed into battle as fodder."
#notext
#nolog
#req_fornation 164
#nation 164
#req_commander 1 -- there must be a non sneaking commander
#req_monster 18128 -- chaos dwarf slaver
#rarity 5
#req_land 1 -- must be on land
#1d3units -1023 -- slave montag
#req_minpop 200 -- must be at least 2000 people in the province
#req_maxunrest 20 -- must be less than 20 unrest
#end


---------------- SLAVING EVENTS ----------------------

--- an alternative solution to this is using PD. Give everyone an event that always grants 1 PD to all 0 PD provinces. Then check which province has 0 PD. That will tell you it was just conquered.


----- The basic idea here is that when a province is conquered by Chaos Dwarfs if it is above 2k, 4k, or 6k in pop and the Chaos Dwarf force meets some basic criteria it gets a corresponding flag. There can only be 3 flags for each size, per month. Any more conquering than that doesn't trigger the slaving events.
----- Each turn three of these flags for each type (pop size) are processed, sending a reward to the chaos dwarf capital (and ONLY the capital). These events have to be delay 0, because they need to definitely fire after flags are placed.

----- ADD A FLAG MONSTER signifying that Chaos Dwarfs conquered this province if it is owned by Chaos Dwarfs and does not contain a 'Chaos Dwarfs' site if it has over a certain population
------- ALSO kill a chunk of population, commensurate with size
------- plus adds the 'Chaos Dwarfs' site
------- REQUIRES at least 20 friendly troops to be present AND requires a non sneaking commander

------ 6kA conquest
#newevent
#msg "A large number of slaves taken in ##landname##.

Having conquered this province your forces have taken a large number of slaves and sent them back to labour in the capital.

(You conquered a province with more than 8000 population and had a commander and at least 25 troops present. Only three of this size of conquest event can trigger each turn.)"
--notext
--nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_minpop 800 -- the province must have a population of at least 8000 for this event
#req_mintroops 25 -- requires at least 25 friendly troops
#req_commander 1 -- requires a non sneaking friendly commander present
#req_permonth 1 -- once per month only
#req_fort 0 -- can't happen if there's a fort here
#stealthcom 18165 -- the flag monster that indicates Chaos Dwarfs conquered this 6k province is added, hidden, defaults to indies
#killpop 80 -- kills about 800 of the population
#header 2
#end
------ 4kA pop conquest
#newevent
#msg "A decent number of slaves taken in ##landname##.

Having conquered this province your forces have taken a good number of slaves and sent them back to labour in the capital.

(You conquered a province with more than 6000 population and had a commander and at least 20 troops present. Only three of this size of conquest event can trigger each turn.)"
--notext
--nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_minpop 600 -- the province must have a population of at least 6000 for this event
#req_mintroops 20 -- requires at least 20 friendly troops
#req_commander 1 -- requires a non sneaking friendly commander present
#req_permonth 1 -- once per month only
#req_fort 0 -- can't happen if there's a fort here
#stealthcom 18166 -- the flag monster that indicates Chaos Dwarfs conquered this 4k province is added, hidden, defaults to indies
#killpop 60 -- kills about 600 of the population
#header 2
#end
------ 2kA pop conquest
#newevent
#msg "A small number of slaves taken in ##landname##.

Having conquered this province your forces have taken a small number of slaves and sent them back to labour in the capital.

(You conquered a province with more than 3000 population and had a commander and at least 15 troops present. Only three of this size of conquest event can trigger each turn.)"
--notext
--nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_minpop 300 -- the province must have a population of at least 3000 for this event
#req_mintroops 15 -- requires at least 15 friendly troops
#req_commander 1 -- requires a non sneaking friendly commander present
#req_permonth 1 -- once per month only
#req_fort 0 -- can't happen if there's a fort here
#stealthcom 18167 -- the flag monster that indicates Chaos Dwarfs conquered this 2k province is added, hidden, defaults to indies
#killpop 30 -- kills about 300 of the population
#header 2
#end


------ 6kB conquest
#newevent
#msg "A large number of slaves taken in ##landname##.

Having conquered this province your forces have taken a large number of slaves and sent them back to labour in the capital.

(You conquered a province with more than 8000 population and had a commander and at least 25 troops present. Only three of this size of conquest event can trigger each turn.)"
--notext
--nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_minpop 800 -- the province must have a population of at least 8000 for this event
#req_mintroops 25 -- requires at least 25 friendly troops
#req_commander 1 -- requires a non sneaking friendly commander present
#req_permonth 1 -- once per month only
#req_fort 0 -- can't happen if there's a fort here
#stealthcom 18168 -- the flag monster that indicates Chaos Dwarfs conquered this 6k province is added, hidden, defaults to indies
#killpop 80 -- kills about 800 of the population
#header 2
#end
------ 4kB pop conquest
#newevent
#msg "A decent number of slaves taken in ##landname##.

Having conquered this province your forces have taken a good number of slaves and sent them back to labour in the capital.

(You conquered a province with more than 6000 population and had a commander and at least 20 troops present. Only three of this size of conquest event can trigger each turn.)"
--notext
--nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_minpop 600 -- the province must have a population of at least 6000 for this event
#req_mintroops 20 -- requires at least 20 friendly troops
#req_commander 1 -- requires a non sneaking friendly commander present
#req_permonth 1 -- once per month only
#req_fort 0 -- can't happen if there's a fort here
#stealthcom 18169 -- the flag monster that indicates Chaos Dwarfs conquered this 4k province is added, hidden, defaults to indies
#killpop 60 -- kills about 600 of the population
#header 2
#end
------ 2kB pop conquest
#newevent
#msg "A small number of slaves taken in ##landname##.

Having conquered this province your forces have taken a small number of slaves and sent them back to labour in the capital.

(You conquered a province with more than 3000 population and had a commander and at least 15 troops present. Only three of this size of conquest event can trigger each turn.)"
--notext
--nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_minpop 300 -- the province must have a population of at least 3000 for this event
#req_mintroops 15 -- requires at least 15 friendly troops
#req_commander 1 -- requires a non sneaking friendly commander present
#req_permonth 1 -- once per month only
#req_fort 0 -- can't happen if there's a fort here
#stealthcom 18170 -- the flag monster that indicates Chaos Dwarfs conquered this 2k province is added, hidden, defaults to indies
#killpop 30 -- kills about 300 of the population
#header 2
#end


------ 6kC conquest
#newevent
#msg "A large number of slaves taken in ##landname##.

Having conquered this province your forces have taken a large number of slaves and sent them back to labour in the capital.

(You conquered a province with more than 8000 population and had a commander and at least 25 troops present. Only three of this size of conquest event can trigger each turn.)"
--notext
--nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_minpop 800 -- the province must have a population of at least 8000 for this event
#req_mintroops 25 -- requires at least 25 friendly troops
#req_commander 1 -- requires a non sneaking friendly commander present
#req_permonth 1 -- once per month only
#req_fort 0 -- can't happen if there's a fort here
#stealthcom 18171 -- the flag monster that indicates Chaos Dwarfs conquered this 6k province is added, hidden, defaults to indies
#killpop 80 -- kills about 800 of the population
#header 2
#end
------ 4kC pop conquest
#newevent
#msg "A decent number of slaves taken in ##landname##.

Having conquered this province your forces have taken a good number of slaves and sent them back to labour in the capital.

(You conquered a province with more than 6000 population and had a commander and at least 20 troops present. Only three of this size of conquest event can trigger each turn.)"
--notext
--nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_minpop 600 -- the province must have a population of at least 6000 for this event
#req_mintroops 20 -- requires at least 20 friendly troops
#req_commander 1 -- requires a non sneaking friendly commander present
#req_permonth 1 -- once per month only
#req_fort 0 -- can't happen if there's a fort here
#stealthcom 18172 -- the flag monster that indicates Chaos Dwarfs conquered this 4k province is added, hidden, defaults to indies
#killpop 60 -- kills about 600 of the population
#header 2
#end
------ 2kC pop conquest
#newevent
#msg "A small number of slaves taken in ##landname##.

Having conquered this province your forces have taken a small number of slaves and sent them back to labour in the capital.

(You conquered a province with more than 2000 population and had a commander and at least 15 troops present. Only three of this size of conquest event can trigger each turn.)"
--notext
--nolog
#rarity 5 -- always no limit
#req_land 1
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_minpop 300 -- the province must have a population of at least 3000 for this event
#req_mintroops 15 -- requires at least 15 friendly troops
#req_commander 1 -- requires a non sneaking friendly commander present
#req_permonth 1 -- once per month only
#req_fort 0 -- can't happen if there's a fort here
#stealthcom 18173 -- the flag monster that indicates Chaos Dwarfs conquered this 2k province is added, hidden, defaults to indies
#killpop 30 -- kills about 300 of the population
#header 2
#end


------ Then if none of those trigger and the Chaos Dwarfs site isn't present in a chaos dwarf province, add it

#newevent
#msg "adding the Chaos Dwarfs site."
#notext
#nolog
#rarity 5 -- always no limit
#nation 164
#req_freesites 1
#req_fornation 164 -- chaos dwarfs
#req_nositenbr 2034 -- Chaos Dwarfs site must not be here
#hiddensite 2034 -- add Chaos Dwarfs site
#req_land 1
#end

------ REMOVE the Chaos Dwarfs ownership site from any province which is not owned by the chaos dwarfs, if it contains the site

#newevent
#msg "removing the Chaos Dwarfs site. [Chaos Dwarfs]"
#notext
#nolog
#rarity 5 -- always no limit
#req_notfornation 164 -- chaos dwarfs
#req_site 1 -- only if the site is present
#removesite 2034 -- remove Chaos Dwarfs site
#req_land 1
#end


---- REMOVE a generic 'Chaos Dwarfs' revealed site and then add it back, hidden. Hopefully this means people can't accidentally reveal them by searching H9

#newevent
#msg "Chaos Dwarfs site removed and added back in, hidden. [Chaos Dwarfs]"
#notext
#nolog
#rarity 5 -- always no limit
#req_foundsite 1
#removesite 2034 -- remove Chaos Dwarfs site
#hiddensite 2034 -- add hidden Chaos Dwarfs site
#end



------ Then here are the reward events, set up to be on a delay

------ 6kA
--basic delay event at Chaos Dwarf Capital
#newevent
#msg "delay event to set up 6kA reward"
#notext
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_fornation 164 -- chaos dwarfs
#req_fort 1 -- requires fort to be present
#req_permonth 1  -- can only happen once per month
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#delay 0
#end
------ reward
#newevent
#msg "A large number of slaves have arrived.

A large number of slaves taken from a recently conquered province have arrived in the capital. Some have been sold, some set to work, and some armed to be used as fodder in battle.
(Gain 5d6 random slave troops)"
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_mnr 18165 -- 6kA somewhere in world
#req_permonth 1
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#forcegold 70
#incpop 60 -- gain around 600 pop
#landprod 25 -- increase resources by 25 permanently
#7d6units -1023 -- slave montag
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#header 2
#end

------ 4kA
--basic delay event at Chaos Dwarf Capital
#newevent
#msg "delay event to set up 4ka reward"
#notext
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_fornation 164 -- chaos dwarfs
#req_fort 1 -- requires fort to be present
#req_permonth 1  -- can only happen once per month
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#delay 0
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#end
------ reward
#newevent
#msg "A decent number of slaves have arrived.

A decent number of slaves taken from a recently conquered province have arrived in the capital. Some have been sold, some set to work, and some armed to be used as fodder in battle.
(Gain 3d6 random slave troops)"
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_mnr 18166
#req_permonth 1
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#forcegold 45
#incpop 30 -- gain around 300 pop
#landprod 12 -- increase resources by 12 permanently
#5d6units -1023 -- slave montag
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#header
#end

------ 2kA
--basic delay event at Chaos Dwarf Capital
#newevent
#msg "delay event to set up 2ka reward"
#notext
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_fornation 164 -- chaos dwarfs
#req_fort 1 -- requires fort to be present
#req_permonth 1  -- can only happen once per month
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#delay 0
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#end
------ reward
#newevent
#msg "A small number of slaves have arrived.

A small number of slaves taken from a recently conquered province have arrived in the capital. Some have been sold, some set to work, and some armed to be used as fodder in battle.
(Gain 3d3 random slave troops)"
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_mnr 18167
#req_permonth 1
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#forcegold 28
#incpop 10 -- gain around 100 pop
#landprod 5 -- increase resources by 5 permanently
#3d6units -1023 -- slave montagpen in the chaos dwarf capitaln in the chaos dwarf capital
#header 2
#end



------ 6kB
--basic delay event at Chaos Dwarf Capital
#newevent
#msg "delay event to set up 6kb reward"
#notext
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_fornation 164 -- chaos dwarfs
#req_fort 1 -- requires fort to be present
#req_permonth 1  -- can only happen once per month
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#delay 0
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#end
------ reward
#newevent
#msg "A large number of slaves have arrived.

A large number of slaves taken from a recently conquered province have arrived in the capital. Some have been sold, some set to work, and some armed to be used as fodder in battle.
(Gain 5d6 random slave troops)"
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_mnr 18168
#req_permonth 1
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#forcegold 70
#incpop 60 -- gain around 600 pop
#landprod 25 -- increase resources by 25 permanently
#7d6units -1023 -- slave montag
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#header 2
#end
------ 4kB
--basic delay event at Chaos Dwarf Capital
#newevent
#msg "delay event to set up 4kb reward"
#notext
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_fornation 164 -- chaos dwarfs
#req_fort 1 -- requires fort to be present
#req_permonth 1  -- can only happen once per month
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#delay 0
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#end
------ reward
#newevent
#msg "A decent number of slaves have arrived.

A decent number of slaves taken from a recently conquered province have arrived in the capital. Some have been sold, some set to work, and some armed to be used as fodder in battle.
(Gain 3d6 random slave troops)"
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_mnr 18169
#req_permonth 1
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#forcegold 48
#incpop 30 -- gain around 300 pop
#landprod 12 -- increase resources by 12 permanently
#5d6units -1023 -- slave montag
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#header 2
#end
------ 2kB
--basic delay event at Chaos Dwarf Capital
#newevent
#msg "delay event to set up 2kb reward"
#notext
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_fornation 164 -- chaos dwarfs
#req_fort 1 -- requires fort to be present
#req_permonth 1  -- can only happen once per month
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#delay 0
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#end
------ reward
#newevent
#msg "A small number of slaves have arrived.

A small number of slaves taken from a recently conquered province have arrived in the capital. Some have been sold, some set to work, and some armed to be used as fodder in battle.
(Gain 3d3 random slave troops)"
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_mnr 18170
#req_permonth 1
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#forcegold 28
#incpop 10 -- gain around 100 pop
#landprod 5 -- increase resources by 5 permanently
#3d6units -1023 -- slave montagpen in the chaos dwarf capital
#header 2
#end




------ 6kC
--basic delay event at Chaos Dwarf Capital
#newevent
#msg "delay event to set up 6kc reward"
#notext
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_fornation 164 -- chaos dwarfs
#req_fort 1 -- requires fort to be present
#req_permonth 1  -- can only happen once per month
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#delay 0
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#end
------ reward
#newevent
#msg "A large number of slaves have arrived.

A large number of slaves taken from a recently conquered province have arrived in the capital. Some have been sold, some set to work, and some armed to be used as fodder in battle.
(Gain 5d6 random slave troops)"
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_mnr 18171
#req_permonth 1
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#forcegold 70
#incpop 60 -- gain around 600 pop
#landprod 25 -- increase resources by 25 permanently
#7d6units -1023 -- slave montag
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#header 2
#end
------ 4kC
--basic delay event at Chaos Dwarf Capital
#newevent
#msg "delay event to set up 4kc reward"
#notext
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_fornation 164 -- chaos dwarfs
#req_fort 1 -- requires fort to be present
#req_permonth 1  -- can only happen once per month
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#delay 0
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#end
------ reward
#newevent
#msg "A decent number of slaves have arrived.

A decent number of slaves taken from a recently conquered province have arrived in the capital. Some have been sold, some set to work, and some armed to be used as fodder in battle.
(Gain 3d6 random slave troops)"
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_mnr 18172
#req_permonth 1
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#forcegold 48
#incpop 30 -- gain around 300 pop
#landprod 12 -- increase resources by 12 permanently
#5d6units -1023 -- slave montag
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#header 2
#end
------ 2kC
--basic delay event at Chaos Dwarf Capital
#newevent
#msg "delay event to set up 2kc reward"
#notext
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_fornation 164 -- chaos dwarfs
#req_fort 1 -- requires fort to be present
#req_permonth 1  -- can only happen once per month
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#delay 0
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#end
------ reward
#newevent
#msg "A small number of slaves have arrived.

A small number of slaves taken from a recently conquered province have arrived in the capital. Some have been sold, some set to work, and some armed to be used as fodder in battle.
(Gain 3d3 random slave troops)"
#nolog
#rarity 5 -- always no limit
#nation 164 -- chaos dwarfs
#req_mnr 18173
#req_permonth 1
#req_mindef 1 -- requires a minimum of 1 PD, because this stops it happening in provinces where Chaos Dwarfs are sieging their own capital
#forcegold 28
#incpop 10 -- gain around 100 pop
#landprod 5 -- increase resources by 5 permanently
#3d6units -1023 -- slave montag
#req_owncapital 1 -- can only happen in the chaos dwarf capital
#header 2
#end




------- NATION EVENTS


--- Fort pollution

#newevent
#msg "fort pollution"
#notext
#nolog
#req_fornation 164 -- chaos dwarfs
#nation 164 -- owned by chaos dwarfs
#req_pop0ok -- can fire in provinces with low pop
#rarity 5
#req_growth 0 -- can happen at anything above death 1
#req_fort 1
#req_rare 33
#incscale 3 -- increases death
#end



--- Spawn an Overlord when you recruit a Sorcerer Lord

#newevent
#msg "you've recruited a sorcerer lord, so you get an overlord for free"
#notext
#nolog
#req_owncapital 1
#req_fornation 164 -- chaos dwarfs
#nation 164 -- owned by chaos dwarfs
#req_targmnr 18136 -- recruited sorcerer lord
#transform 18156 -- sorcerer lord with overlord form
#com 18130 -- spawns an overlord
#rarity 5
#end


----- STONE CURSE EVENTS

--- Sorcerer Stone Curse 3 (I am duplicating this and then halving the probability so it can handle two per prov but is realistically made to deal with 1 per prov)

#newevent
#msg "One of your Stonewracked Sorcerers has finally succumbed to the Stone Curse and is now little more than a particularly realistic statue. Were he a Sorcerer Lord his final form would be venerated and carried to battle as a holy symbol, but as a Sorcerer of middling rank his fate is to be left discarded or perhaps taken as a decorative ornament by one of his political rivals."
#req_targmnr 18151 -- stonewracked sorcerer
#rarity 5
--req_rare 33
#req_rare 17
#req_pop0ok
#killtarg
#end

#newevent
#msg "One of your Stonewracked Sorcerers has finally succumbed to the Stone Curse and is now little more than a particularly realistic statue. Were he a Sorcerer Lord his final form would be venerated and carried to battle as a holy symbol, but as a Sorcerer of middling rank his fate is to be left discarded or perhaps taken as a decorative ornament by one of his political rivals."
#req_targmnr 18151 -- stonewracked sorcerer
#rarity 5
--req_rare 33
#req_rare 17
#req_pop0ok
#killtarg
#end


--- Sorcerer Stone Curse 2 trigger (this is repeated 5 times so it can handle 5 of these per prov per month. It turns the stonecursed sorc into the montag that has a chance to then turn into stonewracked sorc)

#newevent
#msg "sorc montag 2"
#notext
#nolog
#req_targmnr 18153 -- stonecursed sorcerer basic
#transform -1026 -- stonecursed sorcerer montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 2"
#notext
#nolog
#req_targmnr 18153 -- stonecursed sorcerer basic
#transform -1026 -- stonecursed sorcerer montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 2"
#notext
#nolog
#req_targmnr 18153 -- stonecursed sorcerer basic
#transform -1026 -- stonecursed sorcerer montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 2"
#notext
#nolog
#req_targmnr 18153 -- stonecursed sorcerer basic
#transform -1026 -- stonecursed sorcerer montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 2"
#notext
#nolog
#req_targmnr 18153 -- stonecursed sorcerer basic
#transform -1026 -- stonecursed sorcerer montag
#rarity 5
#req_pop0ok
#remount
#end


--- Sorcerer Stone Curse 2 result (this turns the bad montag result from the triggers into a stonewracked basic sorc - realistically only need one of these per prov per month)

#newevent
#msg "One of your Stonecursed Sorcerers has now almost entirely succumbed to the Stone Curse. Only one limb and his head are free of the spreading stone and his magical powers have declined considerably. He surely does not have long to live."
#req_targmnr 18158 -- stonecursed sorcerer bad montag result
#transform 18151 -- stonewracked sorcerer
#rarity 5
#req_pop0ok
#remount
#end


--- Sorcerer Stone Curse 1 trigger (repeated 20 times so it can handle 20 per prov per month)

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc montag 1"
#notext
#nolog
#req_targmnr 18160 -- sorcerer
#transform -1027 -- sorcerer basic montag
#rarity 5
#req_pop0ok
#remount
#end


--- Sorcerer Stone Curse 1 result (repeated two times so that it can get two per prov per month if needed)

#newevent
#msg "One of your Sorcerers has been afflicted by the Stone Curse. His lower limbs have turned to stone and he must now be carried everywhere by a pair of Warrior guards. The curse will progress fairly rapidly from this point until he is entirely petrified."
#req_targmnr 18150 -- sorcerer bad montag result
#transform 18153 -- stonecursed sorcerer
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "One of your Sorcerers has been afflicted by the Stone Curse. His lower limbs have turned to stone and he must now be carried everywhere by a pair of Warrior guards. The curse will progress fairly rapidly from this point until he is entirely petrified."
#req_targmnr 18150 -- sorcerer bad montag result
#transform 18153 -- stonecursed sorcerer
#rarity 5
#req_pop0ok
#remount
#end



--- Sorcerer Lord Stone Curse 3 (I'm keeping this to just one per prov, but I'm doubling it and cutting the percentage in half because I think that's all that's needed)

#newevent
#msg "One of your Stonewracked Sorcerer Lords has finally succumbed to the Stone Curse and has turned entirely to stone. Such is the power and status of his former position that his statue will still be carried into battle by Immortal guards and is still invested with divine authority, though it no longer has any magical power."
#req_targmnr 18148 -- stonewracked sorcerer lord
#transform 18149 -- sorcerer lord statue
#rarity 5
--req_rare 33
#req_rare 17
#req_pop0ok
#remount
#end

#newevent
#msg "One of your Stonewracked Sorcerer Lords has finally succumbed to the Stone Curse and has turned entirely to stone. Such is the power and status of his former position that his statue will still be carried into battle by Immortal guards and is still invested with divine authority, though it no longer has any magical power."
#req_targmnr 18148 -- stonewracked sorcerer lord
#transform 18149 -- sorcerer lord statue
#rarity 5
--req_rare 33
#req_rare 17
#req_pop0ok
#remount
#end

--- Sorcerer Lord Stone Curse 2 trigger (repeated 5 times to handle 5 per prov per month)

#newevent
#msg "sorc lord montag 2"
#notext
#nolog
#req_targmnr 18147 -- stonecursed sorcerer lord normal
#transform -1025
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 2"
#notext
#nolog
#req_targmnr 18147 -- stonecursed sorcerer lord normal
#transform -1025
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 2"
#notext
#nolog
#req_targmnr 18147 -- stonecursed sorcerer lord normal
#transform -1025
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 2"
#notext
#nolog
#req_targmnr 18147 -- stonecursed sorcerer lord normal
#transform -1025
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 2"
#notext
#nolog
#req_targmnr 18147 -- stonecursed sorcerer lord normal
#transform -1025
#rarity 5
#req_pop0ok
#remount
#end


--- Sorcerer Lord Stone Curse 2 result (only need 1 of these per prov per month realistically)

#newevent
#msg "One of your Stonecursed Sorcerer Lords has now almost entirely succumbed to the Stone Curse. Only one limb and his head are free of the spreading stone and his magical powers have declined considerably. It will not be long before he has entirely turned to stone."
#req_targmnr 18157 -- stonecursed sorcerer lord that is ready to turn into stonewracked
#transform 18148 -- stonewracked sorcerer lord
#rarity 5
#req_pop0ok
#remount
#end


--- Sorcerer Lord Stone Curse 1 trigger event (repeated 15 times so it can handle 15 of the same commander per province)

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "sorc lord montag 1"
#notext
#nolog
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end

--- Sorcerer Lord Stone Curse 1 result event (repeated twice so it can handle 2 stonecursed results per prov per month - if more than 2 per prov per month they just wait for the next turn etc until they transform)

#newevent
#msg "One of your Sorcerer Lords has been afflicted by the Stone Curse. His lower limbs have turned to stone and he must now be carried everywhere by a pair of Immortal guards. The curse will progress fairly rapidly from this point until he is entirely petrified."
#req_targmnr 18154 -- sorcerer lord ready for stonecursing
#transform 18147 -- stonecursed sorc lord
#rarity 5
#req_pop0ok
#remount
#end

#newevent
#msg "One of your Sorcerer Lords has been afflicted by the Stone Curse. His lower limbs have turned to stone and he must now be carried everywhere by a pair of Immortal guards. The curse will progress fairly rapidly from this point until he is entirely petrified."
#req_targmnr 18156 -- sorcerer lord
#transform -1024 -- sorcerer lord montag, 5% chance to get a thing that then turns into the stonecursed form
#rarity 5
#req_pop0ok
#remount
#end


----- HERO EVENTS


--- Spawn hero Astragoth

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Astragoth Ironhand the High Priest of Hashut has joined your cause, accompanied by his personal Overlord."
#req_owncapital 1
#req_fornation 164 -- chaos dwarfs
#nation 164 -- owned by chaos dwarfs
#com 18144 -- astragoth
#com 18130 -- overlord
#req_nomnr 18144
#req_varzero 211 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 211 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 2 -- a pretty great hero so less common
#req_turn 12 -- he's a really good hero, so not in first year
#header 2
#end


--- Spawn hero Shar'Tor

#newevent
#msg "A unique hero has joined your cause!

The mighty hero Shar'Tor the Executioner has joined your cause, as is the will of Hashut."
#req_owncapital 1
#req_fornation 164 -- chaos dwarfs
#nation 164 -- owned by chaos dwarfs
#com 18141
#req_nomnr 18141
#req_varzero 212 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 212 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 3
#req_turn 10 -- can't spawn as early
#header 2
#end


--- Spawn hero Gorduz

#newevent
#msg "A unique hero has joined your cause!

The cunning hero Gorduz Backstabba the Hobgoblin Chieftain has joined your cause, bringing with him a sizeable force of his shifty kin."
#req_owncapital 1
#req_fornation 164 -- chaos dwarfs
#nation 164 -- owned by chaos dwarfs
#com 18142
#req_nomnr 18142
#req_varzero 213 -- this is so the event can only ever fire once, even if IDs move because events are added/removed, and also so I can track when this has happened for other events
#incvar 213 -- increments the event variable to 1, which stops this event ever firing again
#rarity 5
#req_rare 3
#4d6units 18107 -- Hobgoblin Archers
#4d6units 18108 -- Hobgoblin Spears
#4d6units 18109 -- Sneaky Gits
#req_turn 4
#header 2
#end


------ INFERNAL OUTPOST EVENTS

--- this event gives an infernal guard outpost to any chaos dwarf fort that isn't their cap

#newevent
#msg "Infernal Outpost established in ##landname##.

Now that you control the fort in this province outside your capital an Infernal Outpost has been established, from which the shunned Infernal Guard may be recruited. Should the fort fall into enemy hands the Outpost will of course be abandoned."
#rarity 5 -- always, unlimited
#req_fornation 164
#req_owncapital 0 -- can't fire in your own cap
#req_rare 100 -- always fires
#nation 164 -- chaos dwarfs own this event
#req_freesites 1
#req_fort 1
#req_nositenbr 1863 -- infernal outpost mustn't already be here
#req_mindef 1 -- needs 1 PD here, so not sieging or sieged
#addsite 1863 -- Infernal Outpost
#header 2
#end


----- Event to remove infernal outpost if not in chaos dwarf territory

#newevent
#rarity 5
#req_notfornation 164 -- someone other than chaos Dwarfs
#msg "need a sitename in here. [Infernal Outpost]"
#notext
#nolog
#req_site 1
#removesite 1863
#req_mindef 1 -- only happens when there is 1 PD, so not when sieging a fort
#end



-------- NATION


#selectnation 164
#clearnation
#clearsites
#name "Zharr-Naggrund"
#epithet "Children of Hashut"
#era 2
#brief "Long ago before the Time of Chaos the golden empire of the Dwarfs spread far to the East. As the tides of Chaos swallowed the world the Dwarfs assumed their Eastern brothers slain, but they were not. Abandoned by their brothers and their gods, they survived, but changed. Greed was amplified, pride became arrogance, tradition was replaced with dogma, loyalty turned to zealotry, and stoicism changed to cruelty. So were the Chaos Dwarfs birthed, a harsh people in a harsh land."
#descr "Long ago before the Time of Chaos the golden empire of the Dwarfs spread far to the East. As the tides of Chaos swallowed the world the Dwarfs assumed their Eastern brothers slain, but they were not. Abandoned by their brothers and their gods, they survived, but changed. Greed was amplified, pride became arrogance, tradition was r