﻿#modname "MA Malazan Empire (current version)"
#description "Adds the Malazan Empire to the Middle Age. The nation is inspired by the Malazan Empire from the Malazan Book of the Fallen fantasy series by Steven Erikson, set during the empire under Empress Laseen with some anachronisms here and there."
#version 1.02
#icon "icon.tga"

-- SLOTS USED

-- Monsters 	- 5921-5982
-- Weapons  	- 1867-1884
-- Armor    	- 1500-1502
-- Items	    - 1200
-- Sites    	- 1887-1889
-- Nametypes	- 170-172
-- Nations	    - 201
-- Spells       - 2000-2013

-- Version history
-- Original mod for Dominions 3 & 4 (up to Version 0.854) by Deathjester http://dominionsmods.com/index.php?showtopic=2878
-- Version 0.9 onwards by Tozapeloda77

-- Version 1.1
--  - Removed Mott Irregulars.
--  - Replaced the recruitable infantry sergeant with xpshapes for skirmisher, medium infantry, heavy infantry, and crossbowmen.
--  - Replaced Lorn with Tavore.
--  - Moved Laseen to Dominion 1.
--  - Updated infantry sprites, replacing javelin/sword medium infantry with pikemen.
--  - Added Moranth Soldiers, Munitionists, and Commanders, which can be summoned with the "Moranth Regiment" spell.

-- Version 1.02
--  - Changed unit costs across the board.
--  - Balance changes.
--  - Added combatcaster to cadre mage, high mage, cadre healer and claw.
--  - Removed fear from red blades.
--  - Updated crossbow range from 30 to 40.

-- Version 1.01
--  - Removed duplicate hoof attack

-- Version 1
--  - Dominions 5 to Dominions 6 conversion
--  - Removed forest recruit from Mott Irregulars (swamp recruit only)
--  - Updated several sprites
--  - Reworked magic paths on mages (adding glamour as well) 

-- Version 0.91
--  - Gave High Marshalls a research penalty of -6.
--  - Removed the command penalties for fists and high fists.

-- Version 0.9
--  - Dom4 to Dom5 conversion (mapmove, rec pts, id numbers).
--  - Added potential water magic path access to Cadre & High Mages to represent Ruse Warren.
--  - Reduced Wickan Cattle-Dog (freespawn) attacks, reduced stats.
--  - Edited Empress sprite for a blue skin colour (she is from Napan).
--  - Added Mott Irregular and High Marshalls as swamp/forest recruit, made Red Blades waste recruit instead of summoned by a spell.
--  - Changed maxage of every human to 70 (100 for high mages) due to Malazan longevity.
--  - Improved name lists.
--  - Improved unit descriptions.
--  - Added T'lan Imass Warrior and T'lan Imass Bonecaster summoning.
--  - Updated flag.

-- New weapons

#newweapon 1867
#name "Sharper Munition"
#ammo 2
#aoe 2
#att -2
#armorpiercing
#bonus
#def 0
#dmg 25
#explspr 10118
#flyspr 99
#nostr
#nratt -3
#range -1
#rcost 10
#sound 15
#secondaryeffect 60		-- small area fear
#end

#newweapon 1868
#name "Otataral Blade"
#att 2
#armorpiercing
#magic
#dt_magic
#dt_holy
#def 2
#dmg 9
#nratt 2
#len 2
#slash
#pierce
#end

#newweapon 1869
#name "Wrist Crossbows"
#att 4
#def 0
#dmg 8
#range 20
#bonus
#ammo 2
#rcost 2
#sound 13
#dt_normal
#pierce
#nostr
#secondaryeffect 51
#flyspr 109
#end

#newweapon 1870
#name "Cusser Munition"
#ammo 1
#aoe 9
#att -5
#armorpiercing
#bonus
#def 0
#dmg 35
#dt_normal
#explspr 10119
#flyspr 99
#nostr
#nratt 1
#range -2
#rcost 0
#sound 89
#secondaryeffectalways 255 -- large area fear
#end

#newweapon 1871
#name "Cusser Launcher"
#ammo 1
#aoe 9
#att -5
#armorpiercing
#bonus
#def 0
#dmg 31
#dt_normal
#explspr 10119
#flyspr 109
#nostr
#nratt 1
#range 20
#rcost 0
#sound 13
#secondaryeffectalways 255
#end

#newweapon 1872
#name "Malazan Crossbow"
#dmg 12
#armorpiercing
#nratt -2
#att 3
#range 40
#ammo 12
#sound 13
#flyspr 109 1
#rcost 4
#nostr
#pierce
#end

#newweapon 1873
#name "Claw Long Dagger"
#att 2
#def 1
#dmg 4
#pierce
#len 1
#rcost 1
#secondaryeffect 51	-- strong poison
#end

#newweapon 1874
#name "Kalam's Bare Hands, Elbows and Knees"
#att 0
#def 0
#dmg -1
#blunt
#len 0
#bonus
#nratt 1
#end

#newweapon 1875
#name "Pig Sticker"
#att 1
#def 0
#dmg 0
#pierce
#len 0
#rcost 1
#armorpiercing
#end

#newweapon 1876
#name "Razor Claws"
#att 1
#def 0
#dmg 3
#slash
#len 1
#rcost 0
#end

#newweapon 1877
#name "Tulwar"
#att 0
#def 0
#dmg 8
#slash
#len 2
#rcost 5
#end

#newweapon 1878
#name "Ghostly Sword"
#att 1
#def 1
#dmg 6
#len 2
#rcost 0
#secondaryeffect 160 -- cold
#armorpiercing
#end

#newweapon 1879
#name "Area Fire"
#armornegating
#fire
#aoe 5
#explspr 10131
#dt_cap
#magic
#sound 16
#end

#newweapon 1880
#name "Burner Munition"
#aoe 2
#ammo 2
#dmg 12
#nostr
#fire
#flyspr 111
#explspr 10113 -- 10114
#sound 89 -- 15
#secondaryeffectalways 879 -- Area fire
#range -1
#end

#newweapon 1881
#name "Korvalah Wrath"
#att 0
#def 0
#dmg 3
#len 3
#bonus
#nratt 2
#end

#newweapon 1882
#name "Tool's Flint Sword"
#att 2
#def 2
#dmg 9
#slash
#pierce
#len 4
#rcost 0
#nratt 3
#armorpiercing
#magic
#end

#newweapon 1883
#name "Moranth Pike"
#dmg 2
#def -1
#len 4
#nratt 1
#ironweapon
#pierce
#secondaryeffect 690
#end

#newweapon 1884
#name "Moranth Sword"
#dmg 5
#def 2
#len 1
#nratt 1
#ironweapon
#slash
#secondaryeffect 690
#end

-- ARMOR

#newarmor 1500
#name "Moranth Armor"
#type 5
#prot 23
#def -3
#enc 2
#end

#newarmor 1501
#name "Moranth Helmet"
#type 6
#prot 23
#def -1
#enc 0
#end

#newarmor 1502
#name "Moranth Shield"
#type 4
#prot 19
#def 7
#enc 2
#end

-- ITEMS

#newitem 1200
#name "Otataral Blade"
#copyspr 18
#descr "Otataral Blade"
#constlevel 6
#mainpath 4
#mainlevel 4
#secondarypath 3
#secondarylevel 2
#type 1
#weapon 1868
#magicboost 53 -10
#researchbonus -10
#coldres 25
#fireres 25
#acidres 25
#shockres 25
#poisonres 25
#mr 20
#regeneration 5
#recuperation
#restricted 201
#noforgebonus
#end

-- PRETENDERS

#newmonster 5954 -- Empress Laseen
#spr1 "./pretender/empress_idle.tga"
#spr2 "./pretender/empress_attack.tga"
#name "Empress"
#descr "The Empress is a ruler and assassin of great cunning. Cast out in her youth, she allied with powerful people, reconquered her homeland, and stood at the cradle of the Malazan Empire.  When the time was right, she struck and assassinated the old Emperor. Now, calling herself a pretender, she seeks to conquer not just an empire, but all of creation."
#startage 52
#att 14
#def 16
#ambidextrous 2
#female
#stealthy 20
#spy
#assassin
#patience 5
#scalewalls
#prec 16
#mapmove 18
#hp 15
#mr 18
#enc 2
#mor 15
#size 3
#weapon 1873 -- Claw Long Dagger
#weapon 500
#armor 5
#gcost 10020
#okleader
#okmagicleader
#poorundeadleader
#magicskill 4 2
#magicskill 7 1
#pathcost 20
#startdom 1
#moreorder -1
#moreluck -1
#end

#newmonster 5955 -- Emperor Kellanved
#spr1 "./pretender/emperor_idle.tga"
#spr2 "./pretender/emperor_attack.tga"
#name "Emperor"
#descr "The Emperor is an astute mage and a clever schemer, using every trick in the book to claim power. As quickly as he founded his empire, he left it to its own devices so he could pursue greater ambitions. While the official story may be that he was assassinated, reality could not be further from the truth. Returning with even greater magical power, the Emperor has cast off his mortal yoke and seeks to ascend to godhood."
#startage 112
#stealthy 50
#att 14
#def 16
#spy
#prec 13
#mapmove 16
#hp 18
#mr 18
#enc 3
#mor 15
#size 3
#weapon 9
#armor 5
#gcost 10020
#expertleader
#okmagicleader
#goodundeadleader
#magicskill 4 1
#magicskill 7 2
#pathcost 20
#inspirational 3
#startdom 1
#moreluck 1
#end

-- MOUNTS

#newmonster 5973
#copystats 3573
#copyspr 3573
#name "Wickan Steed"
#descr "Wickan horses are regarded highly by those knowledgeable about horses and the saying goes that the blood of Wickan steeds smells of iron."
#end

#newmonster 5974
#copystats 3579
#spr1 "./mount/wickansteedbrown_idle.tga"
#spr2 "./mount/wickansteedbrown_attack.tga"
#name "Wickan Steed"
#descr "Wickan horses are regarded highly by those knowledgeable about horses and the saying goes that the blood of Wickan steeds smells of iron."
#clearspec
#animal
#end

#newmonster 5975
#copystats 3579
#spr1 "./mount/wickansteedblack_idle.tga"
#spr2 "./mount/wickansteedblack_attack.tga"
#name "Wickan Steed"
#descr "Wickan horses are regarded highly by those knowledgeable about horses and the saying goes that the blood of Wickan steeds smells of iron."
#clearspec
#animal
#end

#newmonster 5976
#copystats 3515
#spr1 "./mount/wickansteedbrown_idle.tga"
#spr2 "./mount/wickansteedbrown_attack.tga"
#end

-- COMMANDERS

#newmonster 5921 -- Marine Sergeant summoning form 1
#spr1 "./commander/marine_sergeant_idle.tga"
#spr2 "./commander/marine_sergeant_attack.tga"
#name "Marine Sergeant"
#descr "Marine Sergeants are the hardy leaders of the Malazan Marines. While officially they are only common soldiers, sergeants are rugged veterans who can lead small forces on their own, often deep inside enemy territory. Marine Sergeants are also good at landing on foreign shores, crossing river and sea provinces together with their squads. When recruited, Marine Sergeants also bring a number of Marines with them based on the strength of your dominion."
#startage 33
#maxage 70
#sailing 999 2
#hp 13
#size 3
#mor 14
#att 13
#def 13
#prec 12
#str 11
#enc 3
#stealthy 10
#mapmove 18
#forestsurvival
#mountainsurvival
#armor 8
#armor 118
#armor 2
#weapon 1872
#weapon 8
#ambidextrous 2
#inspirational 2
#poorleader
#command 10
#firstshape 5922
#domsummon 5958
#gcost 135
#rpcost 2
#end

#newmonster 5922 -- Marine Sergeant
#spr1 "./commander/marine_sergeant_idle.tga"
#spr2 "./commander/marine_sergeant_attack.tga"
#name "Marine Sergeant"
#descr "Marine Sergeants are the hardy leaders of the Malazan Marines. While officially they are only common soldiers, sergeants are rugged veterans who can lead small forces on their own, often deep inside enemy territory. Marine Sergeants are also good at landing on foreign shores, crossing river and sea provinces together with their squads."
#startage 33
#maxage 70
#nametype 170
#sailing 100 2
#hp 13
#size 3
#mor 15
#att 13
#def 13
#prec 12
#str 11
#ap 14
#enc 3
#stealthy 10
#mapmove 18
#forestsurvival
#mountainsurvival
#gcost 10015
#rpcost 2
#armor 8
#armor 118
#armor 2
#weapon 1872
#weapon 8
#ambidextrous 2
#inspirational 2
#poorleader
#command 10
#end

#newmonster 5923 -- Fist summoning form
#spr1 "./commander/fist_idle.tga"
#spr2 "./commander/fist_attack.tga"
#name "Fist"
#descr "Fists are the commanders of the Malazan Empire. They command legions and are largely autonomous, even though they are often put under the command of a High Fist if an army is assembled for a military campaign. The Fists are key to the disciplined and organized Malazan military. They are equipped much like ordinary soldiers, but wear a bronzed plate cuirass with greaves instead of scale armor. When recruited, they bring a squad of medium infantry with them."
#startage 38
#maxage 70
#weapon 8
#armor 2
#armor 14
#armor 118
#hp 12
#mor 13
#size 3
#att 12
#def 13
#prec 11
#str 10
#enc 3
#ap 12
#mr 10
#mapmove 18
#goodleader
#gcost 130
#rpcost 1
#rcost 1
#firstshape 5924
#domsummon 5939
#end

#newmonster 5924 -- Fist
#spr1 "./commander/fist_idle.tga"
#spr2 "./commander/fist_attack.tga"
#name "Fist"
#descr "Fists are the commanders of the Malazan Empire. They command legions and are largely autonomous, even though they are often put under the command of a High Fist if an army is assembled for a military campaign. The Fists are key to the adaptable and organized Malazan military. They are equipped much like ordinary soldiers, but wear a bronzed plate cuirass with greaves instead of scale armor."
#startage 38
#maxage 70
#nametype 170
#weapon 8
#armor 2
#armor 14
#armor 118
#hp 12
#mor 13
#size 3
#att 12
#def 13
#prec 11
#str 10
#enc 3
#ap 12
#mr 10
#mapmove 18
#goodleader
#gcost 130
#rpcost 1
#rcost 1
#end

#newmonster 5925 -- High Fist summoning form
#spr1 "./commander/high_fist_idle.tga"
#spr2 "./commander/high_fist_attack.tga"
#name "High Fist"
#startage 45
#maxage 70
#descr "High Fists are the highest commanders of the Malazan Empire. They are able to lead massive armies and inspire their soldiers to fight on even when things look grim. A High Fist answers only to the empress or emperor. High Fists can requisition ships to carry their men across water provinces. When recruited, a high fist brings several squads of infantry with them based on the strength of your dominion."
#weapon 8
#armor 2
#armor 14
#armor 118
#hp 13
#size 3
#mor 14
#att 12
#def 13
#prec 11
#str 10
#enc 3
#ap 12
#mr 11
#mapmove 18
#sailing 999 3
#siegebonus 20
#expertleader
#gcost 300
#rpcost 2
#firstshape 5926
#domsummon 5945
#domsummon 5939
#domsummon 5943
#domsummon 5947
#end

#newmonster 5926 -- High Fist
#spr1 "./commander/high_fist_idle.tga"
#spr2 "./commander/high_fist_attack.tga"
#name "High Fist"
#descr "High Fists are the highest commanders of the Malazan Empire. They are able to lead massive armies and inspire their soldiers to fight on even when things look grim. A High Fist answers only to the empress or emperor. High Fists can requisition ships to carry their men across water provinces."
#nametype 170
#startage 45
#maxage 70
#weapon 8
#armor 2
#armor 14
#armor 118
#hp 13
#size 3
#mor 14
#att 12
#def 13
#prec 11
#str 10
#enc 3
#ap 12
#mr 11
#mapmove 18
#sailing 999 3
#siegebonus 20
#expertleader
#gcost 10010
#rpcost 2
#end

#newmonster 5927 -- Cadre Mage
#spr1 "./commander/cadre_mage_idle.tga"
#spr2 "./commander/cadre_mage_attack.tga"
#name "Cadre Mage"
#descr "Cadre Mages are treated much like common soldiers in the Malazan armies. Often starting out as raw recruits with little formal training, any soldier with magical talent is elevated to the rank of Cadre Mage. As such, they are equipped and trained like normal soldiers. Cadre Mages vary wildly in power and skill, but this diversity is considered a strength in the Malazan Empire. Despite Malazan views on the priesthood, some Cadre Mages do dabble in holy magic, or even death magic, as it is easy to get away with such things, hidden in the ranks."
#nametype 170
#startage 27
#maxage 80
#hp 12
#size 3
#mor 12
#att 10
#def 11
#prec 11
#str 10
#enc 3
#ap 12
#mr 15
#mapmove 18
#weapon 8
#armor 2
#armor 7
#armor 118
#custommagic 32640 200 -- 2 in everything but blood or priest
#custommagic 3968 80 -- 80% for 1in elemental or astral
#custommagic 110592 20 -- 20% for 1 in nature, death, blood, or priest
#poorleader
#stealthy 0
#combatcaster
#gcost 180
#rpcost 2
#end

#newmonster 5928 -- High Mage
#spr1 "./commander/high_mage_idle.tga"
#spr2 "./commander/high_mage_attack.tga"
#name "High Mage"
#descr "High Mages are usually Cadre Mages who have earned their position through a combination of loyalty and mastery of one or more magic paths. Given a lot of freedom to act on their own, High Mages are often important political players in the Malazan Empire. On their own, High Mages can win battles, but their cost and variety of magic paths makes them harder to rely on."
#nametype 170
#startage 40
#maxage 100
#hp 17
#size 3
#mor 16
#att 10
#def 11
#prec 11
#str 10
#enc 3
#ap 12
#mr 17
#mapmove 14
#weapon 8
#armor 2
#armor 7
#armor 118
#enc 2
#okleader
#magicskill 4 2 -- 2 in astral
#custommagic 18304 300 -- 3 in everything but astral, nature, blood or priest
#custommagic 2048 50 -- 80% chance of astral
#custommagic 45056 10 -- 10% chance of death, nature, or blood
#custommagic 45056 10 -- 10% chance of death, nature, or blood
#gcost 330
#rpcost 4
#stealthy 0
#combatcaster
#end


#newmonster 5932 -- High Mage Denul - Nature/Healing
#spr1 "./commander/high_healer_idle.tga"
#spr2 "./commander/high_healer_attack.tga"
#name "High Mage of Denul"
#descr "High Mages are usually Cadre Mages who have earned their position through a combination of loyalty and mastery of one or more magic paths. Masters of Denul, the Path of Healing, are mages who have distinguished themselves with their superior healing abilities. While not as useful in a battle, any soldier, mage or fist is grateful for the support of an able healer."
#nametype 170
#startage 40
#maxage 110
#hp 16
#size 3
#mor 16
#att 10
#def 10
#prec 11
#str 10
#enc 3
#ap 12
#mr 17
#mapmove 14
#weapon 9
#armor 5
#okleader
#magicskill 4 2 -- 2 in astral
#magicskill 6 1 -- 1 in nature
#custommagic 45056 50 -- 50% chance of death, nature, or blood
#custommagic 45056 50 -- 50% chance of death, nature, or blood
#gcost 340
#rpcost 4
#autohealer 2
#autodishealer 1
#regeneration 25
#supplybonus 25
#end

#newmonster 5933 -- Cadre healer
#spr1 "./commander/cadre_healer_idle.tga"
#spr2 "./commander/cadre_healer_attack.tga"
#name "Cadre Healer"
#descr "Cadre Mages are treated much like common soldiers in the Malazan armies. Often starting out as raw recruits with little formal training, any soldier with magical talent is elevated to the rank of Cadre Mage. As such, they are equipped and trained like normal soldiers. This mage is specialised in Denul, the Path of Healing. Integral to the Malazan endurance, keeping common soldiers in fighting shape, any soldier, mage or fist is grateful for the support of an able healer."
#nametype 170
#startage 35
#maxage 70
#hp 12
#size 3
#mor 13
#att 10
#def 10
#prec 11
#str 10
#enc 3
#ap 12
#mr 15
#mapmove 18
#nametype 170
#weapon 6
#armor 7
#armor 2
#armor 118
#poorleader
#magicskill 6 1 -- Nature
#custommagic 45056 20 -- 20% chance of death, nature, or blood
#gcost 130
#rpcost 2
#autohealer 1
#supplybonus 10
#combatcaster
#end

#newmonster 5934 -- Priest
#spr1 "./commander/priest_idle.tga"
#spr2 "./commander/priest_attack.tga"
#name "Priest"
#descr "Priests are relatively uncommon in the Malazan Empire. The priesthood and the cults were culled during the rise of the empire. The remaining priests are allowed only a small measure of influence, and are part of various cults, but must recognize the empress or emperor as the one true ruler. Many have a background in worshipping different gods and many exhibit some limited magical ability, but now they serve the Malazan Empire and its pretender."
#startage 40
#maxage 70
#nametype 170
#weapon 9
#noleader
#holy
#magicskill 9 1
#custommagic 102400 20
#hp 10
#size 3
#mor 9
#att 9
#def 9
#prec 10
#str 10
#enc 3
#ap 12
#mr 13
#mapmove 14
#gcost 10010
#rpcost 1
#end

#newmonster 5935 -- Claw assassin
#spr1 "./commander/claw_idle.tga"
#spr2 "./commander/claw_attack.tga"
#name "Claw"
#descr "Claw Assassins are part of an organization of assassin mages. They perform covert operations against enemies inside as well as outside the Malazan Empire. They protect, gather intelligence, and perform darker, more unsavory tasks. Claws often infiltrate enemy lands before invasions to take out key commanders and mages. They are trained since early childhood in night fighting, illusions and inner discipline. There is nothing pleasant or proud in being a Claw. Only fear and efficiency matter."
#nametype 170
#startage 30
#maxage 70
#noleader
#mor 15
#size 3
#hp 16
#def 14
#att 14
#prec 14
#mr 16
#mapmove 18
#ap 14
#weapon 1869
#weapon 1873
#weapon 1873
#armor 13
#researchbonus -4
#magicskill 4 2 -- astral 2
#magicskill 7 1 -- glamour 1
#holy
#assassin
#darkvision 50
#stealthy 20
#spy
#ambidextrous 3
#patience 3
#scalewalls
#combatcaster
#gcost 290
#rpcost 2
#end

#newmonster 5936 -- Wickan Commander
#spr1 "./commander/wickan_commander_idle.tga"
#spr2 "./commander/wickan_commander_attack.tga"
#mountmnr 5974
#unmountedsprite1 "./commander/wickan_commander_dis_idle.tga"
#unmountedsprite2 "./commander/wickan_commander_dis_attack.tga"
#name "Wickan Commander"
#descr "Wickan Commanders lead the Wickans, a mounted peoples who lived together in clans on the Wickan Plains before they were conquered by the Malazan Empire. The Malazans, who did not use cavalry, eagerly employed the Wickans whom they respected as auxiliary cavalry. Wickans often train large cattle-dogs for droving their herds, but they also bring them to battle."
#startage 37
#maxage 70
#nametype 172
#ap 25
#hp 16
#size 3
#str 12
#enc 4
#att 13
#def 13
#prec 11
#mr 10
#mor 15
#mapmove 20
#weapon 4
#weapon 10
#weapon 264
#armor 12
#armor 118
#armor 2
#gcost 10010
#rpcost 1
#rcost 1
#ressize 2
#mapmove 20
#wastesurvival
#skilledrider 2
#makemonsters2 5961
#end

#newmonster 5962 -- Scout
#spr1 "./commander/scout_idle.tga"
#spr2 "./commander/scout_attack.tga"
#name "Malazan Scout"
#descr "Scouts are trained to pass unseen through enemy territory. Their reports on enemy army movements and the resources in enemy lands are invaluable to the imperial war machine."
#maxage 70
#startage 20
#nametype 170
#size 3
#mor 11
#stealthy 10
#def 11
#prec 11
#ap 12
#mapmove 18
#weapon 8
#armor 5
#forestsurvival
#mountainsurvival
#gcost 40
#rpcost 1
#end

#newmonster 5959 -- Red Blade Commander
#spr1 "./commander/red_blade_commander_idle.tga"
#spr2 "./commander/red_blade_commander_attack.tga"
#mountmnr 5976
#unmountedspr1 "./commander/red_blade_commander_dis_idle.tga"
#unmountedspr2 "./commander/red_blade_commander_dis_attack.tga"
#name "Red Blade Commander"
#descr "Red Blade Commanders command the Red Blades recruited from the desert-rich Seven Cities continent. The Malazan Empire would not be as succesful as it was if it did not make use of local allies. Red Blades are people who have betrayed their own kin to serve the Malazans, convinced that imperial rule will bring good things. Ran almost like a cult, Red Blades are brutal pragmatists and quick to deal with any dissenting kin. They bristle with weapons, fighting with lances, bows and huge falchions called tulwars. At home in the desert heat, Red Blade Commanders are skilled warriors who lead by example."
#nametype 171
#ressize 2
#goodleader
#ap 12
#hp 15
#prot 0	
#size 3
#str 12
#enc 5
#att 14
#def 12
#prec 11
#mr 10
#mor 15
#weapon 1877 -- tulwar
#weapon 264
#armor 13
#armor 118
#armor 2
#mapmove 20
#wastesurvival
#fireres 3
#firepower 1
#patrolbonus 5
#startage 35
#maxage 70
#rcost 1
#gcost 95
#rpcost 2
#end

-- UNITS

#newmonster 5937 -- Skirmisher
#spr1 "./unit/skirmisher_idle.tga"
#spr2 "./unit/skirmisher_attack.tga"
#name "Malazan Skirmisher"
#descr "Skirmishers are light infantry used by the Malazan Empire. The Malazans rely in part on superior training, weapons, and tactics, but most importantly on the fact that soldiers are allowed to think and act for themselves. Skirmishers are used to disrupt formation, protect mages, and guard the flanks. They are lightly armoured, using javelins to harass enemies."
#startage 19
#maxage 70
#nametype 170
#ap 14
#hp 10
#prot 0
#size 3
#str 9
#enc 3
#att 10
#def 11
#prec 11
#mr 10
#mor 11
#mapmove 18
#weapon 6
#weapon 21
#armor 15
#armor 20
#armor 1
#gcost 10010
#rcost 1
#rpcost 10000
#xpshape 50
#end

#newmonster 5938 -- Skirmisher Sergeant
#spr1 "./unit/skirmisher_idle.tga"
#spr2 "./unit/skirmisher_attack.tga"
#name "Skirmisher Sergeant"
#descr "Sergeants are the most experienced Malazan soldiers. While training, tactics, and equipment are important, the core of the Malazan soldier is that they are allowed to think and act for themselves. Sergeants are low-ranking officers who direct their own squad and inspire common soldiers. They are often the difference between soldiers routing or holding the line. Sergeants are promoted from hardened veterans who have survived many battles, and in doing so proven themselves tough, stubborn, lucky, and not dumb: the essential qualities of a good sergeant."
#startage 24
#maxage 70
#nametype 170
#ap 14
#hp 11
#prot 0
#size 3
#str 9
#enc 3
#att 10
#def 11
#prec 11
#mr 10
#mor 13
#mapmove 18
#weapon 6
#weapon 21
#armor 15
#armor 20
#armor 1
#gcost 10010
#rcost 1
#rpcost 10000
#standard 1
#end

#newmonster 5939 -- Medium Infantry
#spr1 "./unit/medium_sword_idle.tga"
#spr2 "./unit/medium_sword_attack.tga"
#name "Malazan Medium Infantry"
#descr "Medium Infantry are the mainstay soldiers of the Malazan Empire. The Malazans rely in part on superior training, weapons, and tactics, but most importantly on the fact that soldiers are allowed to think and act for themselves. The core of their legions consists of Medium Infantry fighting with tower shields, bronzed scale armour and a combination of swords, spears and javelins."
#startage 21
#maxage 70
#nametype 170
#size 3
#hp 10
#mor 11
#att 11
#def 11
#prec 11
#ap 12
#enc 3
#prot 0
#mapmove 18
#weapon 8
#armor 4
#armor 12
#armor 118
#gcost 10010
#rcost 1
#rpcost 10000
#xpshape 50
#end

#newmonster 5940 -- Infantry Sergeant
#spr1 "./unit/medium_sword_idle.tga"
#spr2 "./unit/medium_sword_attack.tga"
#name "Infantry Sergeant"
#descr "Sergeants are the most experienced Malazan soldiers. While training, tactics, and equipment are important, the core of the Malazan soldier is that they are allowed to think and act for themselves. Sergeants are low-ranking officers who direct their own squad and inspire common soldiers. They are often the difference between soldiers routing or holding the line. Sergeants are promoted from hardened veterans who have survived many battles, and in doing so proven themselves tough, stubborn, lucky, and not dumb: the essential qualities of a good sergeant."
#startage 26
#maxage 70
#nametype 170
#hp 11
#size 3
#mor 13
#att 11
#def 11
#prec 11
#ap 12
#enc 3
#prot 0
#mapmove 18
#weapon 8
#armor 4
#armor 12
#armor 118
#gcost 10010
#rcost 1
#rpcost 10000
#standard 1
#end

#newmonster 5941 -- Medium Infantry w/ pikes
#spr1 "./unit/medium_pike_idle.tga"
#spr2 "./unit/medium_pike_attack.tga"
#name "Malazan Medium Infantry"
#descr "Medium Infantry are the mainstay soldiers of the Malazan Empire. The Malazans rely in part on superior training, weapons, and tactics, but most importantly on the fact that soldiers are allowed to think and act for themselves. The core of their legions consists of Medium Infantry fighting with swords, spears and javelins, but they are able to fight with pikes if necessary."
#startage 21
#maxage 70
#nametype 170
#size 3
#hp 10
#mor 11
#att 11
#def 11
#prec 11
#ap 12
#enc 3
#prot 0
#mapmove 18
#weapon 2
#armor 1
#armor 12
#armor 118
#gcost 10010
#rcost 1
#rpcost 10000
#xpshape 50
#end

#newmonster 5942 -- Medium Infantry w/ pikes Sergeant
#spr1 "./unit/medium_pike_idle.tga"
#spr2 "./unit/medium_pike_attack.tga"
#name "Infantry Sergeant"
#descr "Sergeants are the most experienced Malazan soldiers. While training, tactics, and equipment are important, the core of the Malazan soldier is that they are allowed to think and act for themselves. Sergeants are low-ranking officers who direct their own squad and inspire common soldiers. They are often the difference between soldiers routing or holding the line. Sergeants are promoted from hardened veterans who have survived many battles, and in doing so proven themselves tough, stubborn, lucky, and not dumb: the essential qualities of a good sergeant."
#startage 26
#maxage 70
#nametype 170
#size 3
#hp 11
#mor 13
#att 11
#def 11
#prec 11
#ap 12
#enc 3
#prot 0
#mapmove 18
#weapon 2
#armor 1
#armor 12
#armor 118
#gcost 10010
#rcost 1
#rpcost 10000
#standard 1
#end

#newmonster 5943 -- Medium Infantry w/ spears
#spr1 "./unit/medium_spear_idle.tga"
#spr2 "./unit/medium_spear_attack.tga"
#name "Malazan Medium Infantry"
#descr "Medium Infantry are the mainstay soldiers of the Malazan Empire. The Malazans rely in part on superior training, weapons, and tactics, but most importantly on the fact that soldiers are allowed to think and act for themselves. The core of their legions consists of Medium Infantry fighting with tower shields, bronzed scale armour and a combination of swords, spears and javelins."
#startage 21
#maxage 70
#nametype 170
#size 3
#hp 10
#mor 11
#att 11
#def 11
#prec 11
#ap 12
#prot 0
#enc 3
#ap 12
#mapmove 18
#weapon 1
#weapon 21
#armor 4
#armor 12
#armor 118
#gcost 10010
#rcost 1
#rpcost 10000
#xpshape 50
#end

#newmonster 5944 -- Medium Infantry w/ Spears Sergeant
#spr1 "./unit/medium_spear_idle.tga"
#spr2 "./unit/medium_spear_attack.tga"
#name "Infantry Sergeant"
#descr "Sergeants are the most experienced Malazan soldiers. While training, tactics, and equipment are important, the core of the Malazan soldier is that they are allowed to think and act for themselves. Sergeants are low-ranking officers who direct their own squad and inspire common soldiers. They are often the difference between soldiers routing or holding the line. Sergeants are promoted from hardened veterans who have survived many battles, and in doing so proven themselves tough, stubborn, lucky, and not dumb: the essential qualities of a good sergeant."
#startage 26
#maxage 70
#nametype 170
#size 3
#hp 11
#mor 13
#att 11
#def 11
#prec 11
#ap 12
#prot 0
#enc 3
#ap 12
#mapmove 18
#weapon 1
#weapon 21
#armor 4
#armor 12
#armor 118
#gcost 10010
#rcost 1
#rpcost 10000
#standard 1
#end

#newmonster 5945 -- Heavy Infantry
#spr1 "./unit/heavy_idle.tga"
#spr2 "./unit/heavy_attack.tga"
#name "Malazan Heavy Infantry"
#descr "Heavy Infantry are the shock troops of the Malazan Empire. The Malazans rely in part on superior training, weapons, and tactics, but most importantly on the fact that soldiers are allowed to think and act for themselves. Heavies are often the butt of jokes made by other soldiers for their supposed stupidity, but what they lack in wits they make up for in sturdiness, morale and strength. Heavy Infantry wear heavier bronzed scale armour than the standard Malazan soldier, and carry bigger shields."
#startage 20
#maxage 70
#nametype 170
#size 3
#mor 13
#att 12
#def 10
#hp 13
#str 13
#mr 9
#prot 0
#enc 3
#ap 11
#prec 10
#mapmove 18
#weapon 8
#armor 17
#armor 21
#armor 3
#gcost 10013
#rcost 1
#rpcost 10000
#xpshape 50
#end

#newmonster 5946 -- Heavy Infantry Sergeant
#spr1 "./unit/heavy_idle.tga"
#spr2 "./unit/heavy_attack.tga"
#name "Heavy Infantry Sergeant"
#descr "Sergeants are the most experienced Malazan soldiers. While training, tactics, and equipment are important, the core of the Malazan soldier is that they are allowed to think and act for themselves. Sergeants are low-ranking officers who direct their own squad and inspire common soldiers. They are often the difference between soldiers routing or holding the line. Sergeants are promoted from hardened veterans who have survived many battles, and in doing so proven themselves tough, stubborn, lucky, and not dumb: the essential qualities of a good sergeant."
#startage 25
#maxage 70
#nametype 170
#size 3
#mor 15
#att 12
#def 10
#hp 14
#str 13
#mr 9
#prot 0
#enc 3
#ap 11
#prec 10
#mapmove 18
#weapon 8
#armor 17
#armor 21
#armor 3
#gcost 10013
#rcost 1
#rpcost 10000
#standard 1
#end

#newmonster 5947 -- Crossbowman
#spr1 "./unit/crossbow_idle.tga"
#spr2 "./unit/crossbow_attack.tga"
#name "Malazan Crossbowman"
#descr "Malazan Crossbowmen carry a fearsome Malazan crossbow. The Malazans rely in part on superior training, weapons, and tactics, but most importantly on the fact that soldiers are allowed to think and act for themselves. Crossbowmen are used to weaken enemy forces before engaging in melee. They are trained and armoured like regular soldiers and can survive in close combat, but their crossbow packs a bigger punch than most, so they are best kept at range."
#startage 21
#maxage 70
#nametype 170
#ap 12
#hp 10
#size 3
#prot 0
#size 3
#str 10
#enc 3
#att 10
#def 11
#prec 11
#mr 10
#mor 10
#mapmove 18
#weapon 1872
#weapon 6
#armor 12
#armor 118
#armor 1
#gcost 10010
#rcost 1
#rpcost 10000
#xpshape 50
#end

#newmonster 5948 -- Crossbowman sergeant
#spr1 "./unit/crossbow_idle.tga"
#spr2 "./unit/crossbow_attack.tga"
#name "Crossbowman Sergeant"
#descr "Sergeants are the most experienced Malazan soldiers. While training, tactics, and equipment are important, the core of the Malazan soldier is that they are allowed to think and act for themselves. Sergeants are low-ranking officers who direct their own squad and inspire common soldiers. They are often the difference between soldiers routing or holding the line. Sergeants are promoted from hardened veterans who have survived many battles, and in doing so proven themselves tough, stubborn, lucky, and not dumb: the essential qualities of a good sergeant."
#startage 26
#maxage 70
#nametype 170
#ap 12
#hp 11
#size 3
#prot 0
#size 3
#str 10
#enc 3
#att 10
#def 11
#prec 11
#mr 10
#mor 12
#mapmove 18
#weapon 1872
#weapon 6
#armor 12
#armor 118
#armor 1
#gcost 10010
#rcost 1
#rpcost 10000
#standard 1
#end

#newmonster 5958 -- Marines
#spr1 "./unit/marine_idle.tga"
#spr2 "./unit/marine_attack.tga"
#name "Malazan Marine"
#startage 22
#maxage 70
#descr "Marines are a staple of the Malazan forces as versatile, independent shock troops. Marines are often used to infiltrate enemy lands before an invasion, capturing undefended provinces, destroying infrastructure or joining up with other squads for a full-scale assault. Marines are stealthy, and do well both at range and in melee combat. They are renowned for their resilience and endurance throughout long campaigns. They wear blackened chain mail and are equipped with the heavy Malazan crossbow. They also carry swords and pigstickers, which are armour-piercing daggers."
#nametype 170
#hp 12
#size 3
#mor 13
#att 12
#def 12
#str 11
#prec 12
#enc 3
#stealthy 5
#mapmove 18
#ap 14
#forestsurvival
#mountainsurvival
#gcost 14
#rcost 1
#rpcost 10000
#armor 8
#armor 118
#weapon 6
#weapon 1875 -- Pigstickers
#weapon 1872 -- Malazan crossbow
#ambidextrous 2
#end

#newmonster 5969 -- Sapper
#spr1 "./unit/sapper_idle.tga"
#spr2 "./unit/sapper_attack.tga"
#name "Malazan Sapper"
#descr "Sappers have always been part of the Malazan Empire, but when the empire forged an agreement with the reclusive Moranth, they became most fearsome. Moranth munitions are dangerous weapons that can devastate enemy formations. Sappers are either really brave or really foolish, given the volatility of their weapons and their lack of range. They work well with Marines, but are best kept out of melee combat. Sappers and their munitions are also always in short supply. Every one of them is nostalgic about a time when there used to be more munitions, and they are incredibly protective of their own stocks."
#startage 25
#maxage 70
#nametype 170
#size 3
#mor 9
#mr 10
#prec 10
#str 10
#ap 12
#prot 0
#hp 12
#att 10
#def 7
#enc 3
#armor 8
#armor 118
#weapon 6
#weapon 1867 -- sharper
#siegebonus 8
#fireres 1
#stealthy 0
#mapmove 18
#gcost 10014
#rcost 1
#rpcost 10000
#reclimit 3
#end

#newmonster 5970 -- Wickan Lancers
#spr1 "./unit/wickan_lancer_idle.tga"
#spr2 "./unit/wickan_lancer_attack.tga"
#mountmnr 5974
#unmountedspr1 "./unit/wickan_lancer_dis_idle.tga"
#unmountedspr2 "./unit/wickan_lancer_dis_attack.tga"
#name "Wickan Lancer"
#descr "Wickan Lancers are Wickans, a mounted peoples who lived together in clans on the Wickan Plains before they were conquered by the Malazan Empire. The Malazans, who did not use cavalry, eagerly employed the Wickans whom they respected as auxiliary cavalry. Wickans are excellent horsemen, wearing scale armour and carrying lances into battle. The Crow Clan, most numerous and loyal of the Wickans, traditionally wear crow feathers in their hair."
#startage 21
#maxage 70
#nametype 172
#ap 12
#hp 13
#size 3
#str 12
#enc 4
#att 12
#def 12
#prec 11
#mr 10
#mor 13
#weapon 4
#weapon 10
#armor 17
#armor 118
#armor 2
#gcost 10025
#rcost 1
#rpcost 10000
#ressize 2
#mapmove 22
#wastesurvival
#skilledrider 2
#end

#newmonster 5977 -- Wickan Raiders
#spr1 "./unit/wickan_raider_idle.tga"
#spr2 "./unit/wickan_raider_attack.tga"
#mountmnr 5973
#unmountedspr1 "./unit/wickan_raider_dis_idle.tga"
#unmountedspr1 "./unit/wickan_raider_dis_attack.tga"
#name "Wickan Raider"
#descr "Wickan Raiders are Wickans, a mounted peoples who lived together in clans on the Wickan Plains before they were conquered by the Malazan Empire. The Malazans, who did not use cavalry, eagerly employed the Wickans whom they respected as auxiliary cavalry. Wickan Raiders are excellent horsemen, wearing leather armour and carrying both bows and lances into battle. They are also good raiders. The Crow Clan, most numerous and loyal of the Wickans, traditionally wear crow feathers in their hair."
#startage 20
#maxage 70
#nametype 172
#hp 12
#str 11
#att 12
#def 12
#prec 11
#size 3
#mr 10
#mor 12
#enc 4
#mapmove 22
#ap 12
#weapon 357
#weapon 264
#armor 15
#armor 118
#armor 2
#gcost 10025
#rcost 1
#rpcost 10000
#ressize 2
#wastesurvival
#skilledrider 2
#pillagebonus 1
#end

#newmonster 5960 -- Red Blade
#spr1 "./unit/red_blade_idle.tga"
#spr2 "./unit/red_blade_attack.tga"
#mountmnr 5976
#unmountedspr1 "./unit/red_blade_dis_idle.tga"
#unmountedspr2 "./unit/red_blade_dis_attack.tga"
#name "Red Blade"
#descr "Red Blades are auxiliaries of the Malazan Empire recruited from the desert-rich Seven Cities continent. The Malazan Empire would not be as succesful as it was if it did not make use of local allies. Red Blades are people who have betrayed their own kin to serve the Malazans, convinced that imperial rule will bring good things. Ran almost like a cult, Red Blades are brutal pragmatists and quick to deal with any dissenting kin. They bristle with weapons, fighting with lances, bows and huge falchions called tulwars. At home in the desert heat, Red Blades are terrifying opponents."
#nametype 171
#ap 12
#hp 12
#size 3
#prot 0	
#str 11
#enc 5
#att 12
#def 11
#prec 10
#mr 10
#mor 14
#weapon 1877 -- tulwar
#weapon 4
#weapon 264
#armor 13
#armor 118
#armor 2
#rcost 15
#gcost 10025
#rpcost 10000
#ressize 2
#mapmove 20
#wastesurvival
#fireres 3
#firepower 1
#patrolbonus 3
#startage 25
#maxage 70
#end

-- SUMMONS

#newmonster 5978 -- Cusser sapper
#spr1 "./summons/sapper_cusser_idle.tga"
#spr2 "./summons/sapper_cusser_attack.tga"
#name "Cusser Sapper"
#descr "Sappers have always been part of the Malazan Empire, but when the empire forged an agreement with the reclusive Moranth, they became most fearsome. Moranth munitions are dangerous weapons that can devastate enemy formations. Sappers are either really brave or really foolish, given the volatility of their weapons and their lack of range. They work well with Marines, but are best kept out of melee combat. Sappers and their munitions are also always in short supply. Every one of them is nostalgic about a time when there used to be more munitions, and they are incredibly protective of their own stocks. This Sapper is equipped with cusser munitions and should thus be kept well away from your own soldiers."
#startage 28
#maxage 70
#nametype 170
#size 3
#mor 9
#mr 10
#prec 10
#str 10
#ap 12
#prot 0
#hp 12
#att 10
#def 7
#enc 3
#armor 8
#armor 118
#weapon 6
#weapon 1870 -- cusser
#siegebonus 16
#fireres 1
#stealthy 0
#mapmove 18
#gcost 10010
#rcost 1
#rpcost 10000
#end

#newmonster 5964 -- Burner Sapper
#spr1 "./summons/sapper_cusser_idle.tga"
#spr2 "./summons/sapper_cusser_attack.tga"
#name "Burner Sapper"
#descr "Sappers have always been part of the Malazan Empire, but when the empire forged an agreement with the reclusive Moranth, they became most fearsome. Moranth munitions are dangerous weapons that can devastate enemy formations. Sappers are either really brave or really foolish, given the volatility of their weapons and their lack of range. They work well with Marines, but are best kept out of melee combat. Sappers and their munitions are also always in short supply. Every one of them is nostalgic about a time when there used to be more munitions, and they are incredibly protective of their own stocks. This Sapper is equipped with burner munitions and should thus be kept well away from your own soldiers."
#startage 28
#maxage 70
#nametype 170
#size 3
#mor 9
#mr 10
#prec 10
#str 10
#ap 12
#prot 0
#hp 12
#att 10
#def 7
#enc 3
#armor 8
#armor 118
#weapon 6
#weapon 1880 -- Burner
#siegebonus 8
#fireres 1
#stealthy 0
#mapmove 18
#gcost 10010
#rcost 1
#rpcost 10000
#end

#newmonster 5956 -- Kenryll'ah Demon
#spr1 "./summons/kenryllah_idle.tga"
#spr2 "./summons/kenryllah_attack.tga"
#name "Kenryll'ah"
#descr "Kenryll’ah are fearsome demons from another realm. Summoned by the Malazan High Mages, they are called imperial demons, but they only begrudgingly fight for the empire, bound in service to whoever summoned them. The Kenryll'ah are tall and boney creatures, who surprise their foes with a strength and agility belying their frames. Their flesh has a remarkable ability to regrow and repair itself. They are also rather intelligent, and are able to use weapons apart from their dagger-sharp talons if their master wishes it. In their realm they are accomplished seafarers and some of them are even mages of Ruse."
#nametype 140
#ap 18
#hp 54
#prot 10	
#size 8
#str 23
#enc 2 
#att 13
#def 13
#prec 10
#mr 16
#regeneration 15
#heal
#mor 30
#weapon 1876
#weapon 1876
#weapon 397
#custommagic 512 30 -- Water
#custommagic 512 30 -- Water
#mapmove 20
#demon
#swampsurvival
#coldres 10
#startage 70
#maxage 300
#neednoteat
#okleader
#okundeadleader
#fear 5
#gcost 0
#rcost 0
#end

#newmonster 5957 -- Kenryllah Demon Prince
#spr1 "./summons/kenryllah_prince_idle.tga"
#spr2 "./summons/kenryllah_prince_attack.tga"
#name "Kenryll'ah Demon Prince"
#descr "Kenryll’ah are fearsome demons from another realm. Summoned by the Malazan High Mages, they are called imperial demons, but they only begrudgingly fight for the empire, bound in service to whoever summoned them. The Kenryll'ah are tall and boney creatures, who surprise their foes with a strength and agility belying their frames. Their flesh has a remarkable ability to regrow and repair itself. They are also rather intelligent, and are able to use weapons apart from their dagger-sharp talons if their master wishes it. In their realm they are accomplished seafarers and some of them are even mages of Ruse. Demon Princes are the undisputed masters of the Kenryll'ah and wield tulwars."
#nametype 140
#ap 18
#hp 70
#prot 11	
#size 8
#str 25
#enc 2 
#att 15
#def 15
#prec 11
#mr 18
#regeneration 15
#heal
#mor 30
#weapon 1877 -- Tulwar
#weapon 1876
#weapon 397
#armor 12
#magicskill 2 2
#custommagic 4608 100 -- Water and Death
#mapmove 20
#demon
#sailing 999 8
#swampsurvival
#coldres 10
#startage 150
#maxage 300
#neednoteat
#goodleader
#goodundeadleader
#fear 10
#gcost 0
#rcost 0
#end

#newmonster 5961 -- Wickan Cattle Dog
#spr1 "./summons/cattledog_idle.tga"
#spr2 "./summons/cattledog_attack.tga"
#name "Wickan Cattle Dog"
#descr "Wickan Cattle Dogs are born and bred on the Wickan plains. They follow the Wickans and serve as cattle dogs as well as beasts of battle. An exquisite match of dog to master, the Wickan cattle-dog is a vicious, unpredictable breed, compact yet powerful, though by far its most notable characteristic is its stubborn will."
#startage 3
#maxage 15
#ap 25
#hp 8
#prot 3	
#size 2
#str 7
#enc 2
#att 12
#def 11
#prec 5
#mr 5
#mor 15
#weapon 322 -- bite
#mapmove 20
#wastesurvival
#stealthy 0
#animal
#noitem
#gcost 0
#end

#newmonster 5963 -- Bridgeburner Ghost
#spr1 "./summons/bridgeburner_idle.tga"
#spr2 "./summons/bridgeburner_attack.tga"
#name "Bridgeburner Ghost"
#descr "Bridgeburner Ghosts are the spirits of the Bridgeburners, a legendary company of marines who were instrumental in many of the early campaigns of the Malazan Empire. Most of the Bridgeburners died in service to Malaz, but their fame, will and some older magic conspired to give the Bridgeburners no easy rest. In times of need, the ghosts of the Bridgeburners come to aid their living comrades."
#nametype 170
#ap 12	
#hp 20
#size 3
#prot 0		
#size 3
#str 12
#enc 0
#att 15
#def 15
#prec 14
#mr 16
#mor 30
#weapon 1878
#armor 2
#gcost 0
#rcost 0
#mapmove 18
#pooramphibian
#coldres 25
#poisonres 25
#undead
#swampsurvival
#neednoteat
#ethereal
#startage 70
#maxage 1000
#fear 5
#end

#newmonster 5965 -- Korvalah 3rd form
#spr1 "./summons/korvalah_3_idle.tga"
#spr2 "./summons/korvalah_3_attack.tga"
#name "Korvalah"
#descr "This Korvalah is furious and will unleash his full physical and magical strength to destroy his foes!"
#nametype 100
#ap 22		
#hp 60		
#prot 10		
#size 9
#str 24		
#enc 2
#att 18
#def 21
#prec 14
#mor 30
#mr 18
#demon
#sailing 999 5
#poisonres 25
#shockres 25
#startage 155
#weapon 33
#weapon 1881
#ambidextrous 4
#maxage 1000
#neednoteat
#ethereal
#fear 12
#pillagebonus 100
#itemslots 786438
#magicskill 1 2	-- air
#magicskill 5 1	-- death
#magicskill 2 1	-- water
#magicboost 53 4
#firstshape 5967
#heal
#regeneration 2
#trample
#end

#newmonster 5966 -- Korvalah 2nd form
#spr1 "./summons/korvalah_2_idle.tga"
#spr2 "./summons/korvalah_2_attack.tga"
#name "Korvalah"
#descr "This Korvalah no longer feels pity for his foes, but is not furious in truth. If challenged much further, the Korvalah's wrath will be great indeed."
#nametype 100
#ap 22		
#hp 40		
#prot 10		
#size 7
#str 21		
#enc 2
#att 17
#def 21
#prec 14
#mor 30
#mr 18
#demon
#sailing 999 5
#poisonres 25
#shockres 25
#startage 155
#weapon 33
#maxage 1000
#neednoteat
#ethereal
#fear 8
#pillagebonus 100
#itemslots 786438
#magicskill 1 2	-- air
#magicskill 5 1	-- death
#magicskill 2 1	-- water
#magicboost 53 2
#secondshape 5965
#firstshape 5967
#heal
#regeneration 3
#trample
#end

#newmonster 5967 -- Korvalah 1st form
#spr1 "./summons/korvalah_1_idle.tga"
#spr2 "./summons/korvalah_1_attack.tga"
#name "Korvalah"
#descr "The Korvalah is one of the demons that have been bound by the High Mages of the Malazan Empire. A terrible creature hailing from a realm of water and winds, the demon's shape is almost insubstantial made of smoke, stretching like threads in places, curling like wool in others. All that is visible within are its eyes: two black slits. They are able to solidify their bodies at need, and can form claws or hold items. The Korvalah pity weaker foes, which makes them reluctant to fight. However, the more resistance they meet, the more their pity makes way for fury and strength. Furious Korvalahrai can level cities if they so choose. The local people do not appreciate having one of them in their midst."
#nametype 100
#ap 22		
#hp 20		
#prot 10		
#size 5
#str 18		
#enc 2
#att 16
#def 20
#prec 14
#mor 30
#mr 18
#demon
#sailing 999 5
#poisonres 25
#shockres 25
#startage 155
#weapon 33
#maxage 1000
#neednoteat
#ethereal
#fear 5
#stealthy 0
#incunrest 10
#popkill 5
#pillagebonus 100
#itemslots 786438
#magicskill 1 2	-- air
#magicskill 5 1	-- death
#magicskill 2 1	-- water
#secondshape 5966
#noleader
#okmagicleader
#goodundeadleader
#gcost 0
#heal
#regeneration 5
#trample
#end

#newmonster 5971 -- T'lan Imass Warrior
#spr1 "./summons/tlan_imass_idle.tga"
#spr2 "./summons/tlan_imass_attack.tga"
#startage 20000
#maxage 30000
#name "T'lan Imass Warrior"
#descr "T'lan Imass Warriors are undead members of the Imass, a precursor to Humanity, transformed by the Ritual of Tellann, the Elder Warren of Fire. They underwent this ritual to more effectively pursue their war against the Jaghut Tyrants. However, after the Emperor of Malaz claimed the First Throne of the T'lan Imass, they answered to him. The Malazans can still call upon their aid. Armed with flint swords, T'lan Imass are robust warriors who are able to turn to dust and instantly reappear across the battlefield."
#nametype 100
#ap 8
#hp 28
#size 3
#str 16	
#enc 0
#att 12
#def 12
#prec 10
#mor 18
#mr 16
#weapon 374
#armor 44
#armor 119
#undead
#blink
#stealthy 50
#darkvision 50
#coldres 25
#poisonres 25
#noheal
#mapmove 20
#wastesurvival
#pooramphibian
#end


#newmonster 5972 -- T'lan Imass Bonecaster
#spr1 "./summons/bonecaster_idle.tga"
#spr2 "./summons/bonecaster_attack.tga"
#startage 20000
#maxage 30000
#name "T'lan Imass Bonecaster"
#descr "T'lan Imass Bonecasters are the shamans of the T'lan Imass. T'lan Imass are undead members of the Imass, a precursor to Humanity, transformed by the Ritual of Tellann, the Elder Warren of Fire. They underwent this ritual to more effectively pursue their war against the Jaghut Tyrants. However, after the first Emperor of Malaz claimed the First Throne of the T'lan Imass, the clans answered to him. The Malazans can still call upon their aid. Bonecasters are fearsome mages with potential access to fire and death magic."
#nametype 100
#ap 8
#hp 28
#size 3
#str 16	
#enc 0
#att 12
#def 12
#prec 10
#mor 18
#mr 16
#weapon 7
#armor 44
#armor 119
#holy
#undead
#stealthy 50
#darkvision 50
#coldres 25
#poisonres 25
#onebattlespell 773
#magicskill 0 2 -- fire
#magicskill 5 1 -- death
#magicskill 9 1 -- priest
#custommagic 4224 50 -- Fire and Death
#custommagic 4224 50 -- Fire and Death
#custommagic 1024 50 -- Earth
#custommagic 1024 50 -- Earth
#poorleader
#goodundeadleader
#mapmove 20
#wastesurvival
#pooramphibian
#end

#newmonster 5980 -- Black Moranth Soldier
#spr1 "./summons/moranth_soldier_idle.tga"
#spr2 "./summons/moranth_soldier_attack.tga"
#name "Black Moranth Soldier"
#descr "Moranth are a highly regimented people. At all times covered in chitinous armor, their society is mysterious to outsiders. The Moranth have made an alliance with the Malazan Empire, providing logistic and military support. The black moranth are a caste of infantry soldiers. The common soldier carries a massive shield and a serrated pike that leaves its foes bleeding."
#startage 20
#maxage 70
#ap 8
#hp 12
#size 3
#str 11	
#enc 10
#att 10
#def 10
#prec 10
#mor 10
#mr 10
#weapon 1883
#armor 1500
#armor 1501
#armor 1502
#formationfighter 2
#forestsurvival
#end

#newmonster 5981 -- Black Moranth Munitionist
#spr1 "./summons/moranth_munitionist_idle.tga"
#spr2 "./summons/moranth_munitionist_attack.tga"
#name "Black Moranth Munitionist"
#descr "Moranth are a highly regimented people. At all times covered in chitinous armor, their society is mysterious to outsiders. The Moranth have made an alliance with the Malazan Empire, providing logistic and military support. The black moranth are a caste of infantry soldiers. The munitionist carries what Malazans call sharpers."
#startage 20
#maxage 70
#ap 8
#hp 12
#size 3
#str 11	
#enc 10
#att 10
#def 10
#prec 10
#mor 10
#mr 10
#weapon 1867
#weapon 6
#armor 1500
#armor 1501
#armor 1502
#forestsurvival
#end

#newmonster 5982 -- Black Moranth Commander
#spr1 "./summons/moranth_commander_idle.tga"
#spr2 "./summons/moranth_commander_attack.tga"
#name "Black Moranth Commander"
#descr "Moranth are a highly regimented people. At all times covered in chitinous armor, their society is mysterious to outsiders. The Moranth have made an alliance with the Malazan Empire, providing logistic and military support. The black moranth are a caste of infantry soldiers. The commander carries a serrated scimitar that leaves its foes bleeding."
#nametype 100
#startage 30
#maxage 70
#ap 8
#hp 12
#size 3
#str 11	
#enc 10
#att 10
#def 10
#prec 10
#mor 12
#mr 10
#weapon 1884
#armor 1500
#armor 1501
#armor 1502
#goodleader
#forestsurvival
#end

-- HEROES

#newmonster 5979 -- Tayschrenn
#spr1 "./hero/tayschrenn_idle.tga"
#spr2 "./hero/tayschrenn_attack.tga"
#fixedname "Tayschrenn"
#name "High Mage of the Empire"
#unique
#descr "Tayschrenn is the foremost High Mage of the Malazan Empire. He wields massive power arcane and political, and stood by the side of the Emperor before his fall. He is a mage of High Telas, but he also commands powers of Aral Gamelon, Denul, Thyr, Mockra and the Imperial Warren - and likely others as well. The strange sorceror is legendary for moving unseen and acting behind the scenes to ensure the health of the empire, whatever the costs."
#maxage 500
#startage 190
#magicskill 0 4	-- Fire
#magicskill 1 1	-- Air
#magicskill 4 3	-- Astral
#mor 17
#hp 22
#size 3
#prec 14
#mr 19
#healer 100
#stealthy 20
#researchbonus 2
#gcost 0
#mapmove 14
#onebattlespell 938
#end

#newmonster 5949 -- Adjunct Tavore
#spr1 "./hero/tavore_idle.tga"
#spr2 "./hero/tavore_attack.tga"
#name "Adjunct"
#fixedname "Tavore Paran"
#unique
#descr "Tavore of House Paran is the adjunct to the imperial seat and has the authority to command any and all forces of the Empire: she speaks with the voice of the Empress herself. Tavore is a superior tactician and commander, as well as a skilled swordsman. She wields a sword made of Otataral, a mysterious rust-colored mineral that negates magic. From long contact with the blade, Tavore is impervious to most magical effects and seems to recover from wounds very quickly. A more unfortunate side effect is that she can never utilize magic herself."
#weapon 1868
#armor 2
#armor 118
#armor 8
#itemslots 2
#startage 29
#maxage 70
#holy
#magicskill 9 3
#att 13
#def 15
#hp 12
#size 3
#ap 15
#mr 40
#superiorleader
#nomagicleader
#noundeadleader
#magicboost 53 -10
#researchbonus -10
#coldres 25
#fireres 25
#acidres 25
#shockres 25
#poisonres 25
#mr 20
#regeneration 5
#heal
#gcost 0
#mapmove 18
#end

#newmonster 5968 -- Tool
#copyspr 1201
#name "First Sword"
#fixedname "Tool"
#unique
#descr "Tool is a T'lan Imass, an ancient race of undead humanoids. He is the First Sword, foremost warrior and champion of the Imass. The Imass became immortal as a result of the Ritual of Tellan, which gave them eternal unlife so they could fulfill their purpose of killing all Jaghut Tyrants, who had once oppressed the Imass. However, the emperor of Malaz found and conquered the First Throne, thus gaining control over the T’lan Imass. Ever since, they have more or less done as the Emperor commanded, even supporting Malaz after he was supposedly assassinated. Tool has not breathed for hundreds of millenia and can disolve into dust when he wants to, giving up his eternal unlife."
#startage 20403
#maxage 30000
#att 18
#def 18
#hp 50
#size 3
#ap 14
#mr 18
#str 18
#prot 7
#mor 30
#enc 0
#stealthy 256
#darkvision 50
#coldres 25
#poisonres 25
#onebattlespell 773
#goodundeadleader
#heal
#regeneration 10
#gcost 0
#mapmove 20
#wastesurvival
#pooramphibian
#weapon 1882
#armor 44
#armor 150
#end

#newmonster 5950 -- Fiddler
#spr1 "./hero/fiddler_idle.tga"
#spr2 "./hero/fiddler_attack.tga"
#unique
#fixedname "Fiddler"
#name "Bridgeburner Veteran"
#descr "Fiddler was a member of the legendary Bridgeburner company, which was instrumental in the early campaigns of the Empire. Fiddler was loyal - or foolish - enough to re-enlist after the Bridgeburner's dissolvement. He is an exceptional sapper and carries a custom built crossbow to launch heavy munitions. As an unwilling expert reader of the Deck of Dragons, he has a knack of knowing what is about to happen, and will often have a bad feeling allowing him to prevent a negative event. This gives him the uncanny ability to always get out of trouble."
#startage 36
#maxage 70
#size 3
#mor 15
#att 12
#def 16
#hp 15
#prec 14
#str 12
#weapon 6
#weapon 1867 -- sharper
#weapon 1871 -- cusser
#armor 8
#armor 118
#nobadevents 25
#siegebonus 50
#stealthy 20
#mapmove 18
#gcost 0
#onebattlespell 1271
#end

#newmonster 5951 -- Coltaine
#unique
#spr1 "./hero/coltaine_idle.tga"
#spr2 "./hero/coltaine_attack.tga"
#mountmnr 5975
#unmountedspr1 "./hero/coltaine_dis_idle.tga"
#unmountedspr2 "./hero/coltaine_dis_attack.tga"
#name "Wickan High Fist"
#fixedname "Coltaine"
#descr "Coltaine is the greatest Warlord the Wickan clans have ever seen. After the Malazans conquered his homeland, he became a High Fist of the Malazan Empire. He inspires considerable loyalty in his followers, whether they are Wickan or not. Coltaine’s fame and renown is near that of a demigod. His sheer presence inspires his warriors to fight on even in the face of near impossible odds. As a leader and as a warrior, his name has become a curse upon the lips of enemy generals. Coltaine wears a mantle made of Crow feathers."
#weapon 4
#weapon 10
#armor 17
#armor 118
#armor 2
#size 3
#mor 18
#ap 12
#mapmove 22
#hp 22
#str 14
#enc 3
#att 16
#def 16
#prec 13
#mr 15
#skilledrider 4
#superiorleader
#startage 40
#maxage 70
#ambidextrous 3
#inspirational 3
#onebattlespell 242
#awe 4
#gcost 0
#wastesurvival
#makemonsters4 5961
#summon1 5977
#end

#newmonster 5952 -- Quick Ben
#spr1 "./hero/quick_ben_idle.tga"
#spr2 "./hero/quick_ben_attack.tga"
#name "Shadow Magus"
#fixedname "Quick Ben"
#unique
#descr "Ben Adeaphon Delat – Quick Ben - was an enemy to the Malazan Empire and a before the young empire conquered his homeland. He was eventually hunted down by the the legendary Bridgeburner company. During this strifeful flight, the member of his mage cabal surrendered their souls to Quick Ben in order to help his flight. When he despite all of this was caught, he unexpectedly joined the Bridgeburners, along with his deadly friend, Kalam Mekhar. As a result of his soulshifting, Quick Ben has absorbed the souls of twelve members of a mage cabal, giving him access to many paths of magic and a mind keener than most in this realm."
#maxage 500
#startage 43
#magicskill 0 2	-- Fire
#magicskill 1 2	-- Air
#magicskill 3 2	-- Earth
#magicskill 4 2	-- Astral
#magicskill 5 2	-- Death
#magicskill 7 2 -- Glamour
#hp 15
#size 3
#stealthy 20
#mr 18
#enc 3
#healer 25
#gcost 0
#darkvision 50
#darkpower 2
#wastesurvival
#mapmove 18
#armor 10
#armor 121
#weapon 9
#end

#newmonster 5953 -- Kalam
#spr1 "./hero/kalam_idle.tga"
#spr2 "./hero/kalam_attack.tga"
#name "Master Assassin"
#unique
#fixedname "Kalam Mekhar"
#descr "Kalam Mekhar was an enemy assassin before joining the Malazans, convinced that their imperial cause was worthy. He joined them alongside the strange sorceror Quick Ben and quickly rose in ranks amongst the Claw assassins. He is a beast of a man, but still incredibly agile and quick for his size, and few are his match as assassins or warriors. Unlike other claws, his magical abilities are subconcious and innate rather than directly channeled. His endurance and ability to heal are nigh on magical."
#maxage 70
#startage 35
#hp 22
#size 3
#stealthy 25
#weapon 1869
#weapon 1874
#weapon 1873
#weapon 1873
#ambidextrous 5
#noleader
#mor 17
#hp 20
#str 16
#prot 4
#def 15
#att 15
#prec 15
#mr 17
#mapmove 18
#ap 13
#assassin
#holy
#onebattlespell 773
#enc 2
#reinvigoration 4
#regeneration 5
#wastesurvival
#darkvision 50
#patience 4
#scalewalls
#armor 8
#armor 121
#end


-- New spells

#newspell 2000 -- Imperial Warren
#copyspell "Cloud Trapeze"
#name "Travel the Imperial Warren"
#descr "Few know how or why, but agents of the Malazan Empire have access to a magical warren that lets them travel long distances in a very short time. Some rumour that the Imperial Warren is a world that was destroyed and left in lifeless ruin. Casting this spell moves the caster to any province in the world, instantly."
#school 0
#researchlevel 2
#path 0 4
#pathlevel 0 2
#restricted 201
#end

#newspell 2001 -- Cussers
#name "Commission Cusser"
#descr "The Moranth, reclusive allies of the Malazan Empire, have developed powerful munitions. Cussers are the heaviest munitions used by sappers. Moranth do not come cheap, however, and require a certain skill and finesse to trade with. A skilled mage exchanges a few precious gems in exchange for the Moranth’s services."
#effect 10001
#damage 5978
#fatiguecost 1200
#researchlevel 2
#nreff 3
#school 3
#path 0 0
#pathlevel 0 1
#restricted 201
#end

#newspell 2002 -- Burner munitions
#name "Commission Burner"
#descr "The Moranth, reclusive allies of the Malazan Empire, have developed powerful munitions. Burners are a scary, fiery munition used by sappers. Moranth do not come cheap, however, and require a certain skill and finesse to trade with. A skilled mage exchanges a few precious gems in exchange for the Moranth’s services."
#effect 10001
#damage 5964
#fatiguecost 600
#researchlevel 3
#nreff 3
#school 3
#path 0 0
#pathlevel 0 1
#restricted 201
#end

#newspell 2003 -- Moranth Raid
#copyspell "Fires from Afar"
#name "Moranth Raid"
#descr "The Moranth, reclusive allies of the Malazan Empire, have developed terrifying munitions and domesticated huge flying insects known as quorls. While they do not allow others to own and raise these beasts, their services can be bought. They can be convinced to raid an enemy province, bombing it with their munitions. Moranth do not come cheap, however, and require a certain skill and finess to trade with. A skilled mage exchanges a few precious gems in exchange for the Moranth’s services."
#school 0
#researchlevel 5
#path 0 0
#path 1 4
#pathlevel 0 2
#pathlevel 1 2
#fatiguecost 1000
#nreff 12
#restricted 201
#end


#newspell 2004 -- Kenryll'ah Demon (troop)
#name "Bind Kenryll'ah"
#descr "The mage summons and binds an imperial demon. This demon is a Kenryll'ah, a race of intelligent but fierce demons who inhabit a shard of Kurald Emuhrlan. They are tall, thin and bony with clawed hands capable of tearing smaller beings apart. Each summoning binds one Kenryll'ah, who needs to be commanded by a mage."
#effect 10001
#damage 5956
#fatiguecost 500
#researchlevel 4
#nreff 1
#school 0
#path 0 2 -- Water
#path 1 4 -- Astral
#pathlevel 0 1
#pathlevel 1 2
#restricted 201
#end

#newspell 2005 -- Kenryll'ah Demon Prince
#name "Bind Kenryll'ah Demon Prince"
#descr "The mage summons and binds an Imperial Demon. This demon is a Kenryll'ah Tyrant, a race of intelligent but fierce demons who inhabit a shard of Kurald Emuhrlan. They are tall, thin and bony with clawed hands capable of tearing smaller beings apart. Each summoning binds one Kenryll'ah Tyrant, the terrible masters of the Kenryll'ah."
#effect 10021
#damage 5957
#fatiguecost 2000
#researchlevel 7
#nreff 1
#school 0
#path 0 2 -- Water
#path 1 4 -- Astral
#pathlevel 0 2
#pathlevel 1 3
#restricted 201
#end

#newspell 2006 -- Moranth Riders
#copyspell "Gateway"
#name "Moranth Riders"
#descr "The Moranth, reclusive allies of the Malazan Empire, have domesticated huge flying insects known as quorls. While they do not allow others to own and raise these beasts, their services can be bought. They can be convinced to transport a mage and their troops from one province to any other friendly province prepared for Moranth visits. Moranth do not come cheap, however, and require a certain skill and finess to trade with. A skilled mage exchanges a few precious gems in exchange for the Moranth’s services."
#school 0
#researchlevel 6
#path 0 1
#path 1 4
#pathlevel 0 3
#pathlevel 1 1
#fatiguecost 1000
#restricted 201
#end

#newspell 2007 -- Moranth Assault
#copyspell "Astral Travel"
#name "Moranth Assault"
#descr "The Moranth, reclusive allies of the Malazan Empire, have domesticated huge flying insects known as quorls. While they do not allow others to own and raise these beasts, their services can be bought. They can be convinced to transport a mage and their troops from one province to any other province, even enemy ones, but putting their quorls at risk means that they will demand a higher premium. Moranth do not come cheap and require a certain skill and finess to trade with. A skilled mage exchanges a few precious gems in exchange for the Moranth’s services."
#school 0
#researchlevel 8
#path 0 1
#path 1 4
#pathlevel 0 3
#pathlevel 1 2
#fatiguecost 2500
#restricted 201
#end

#newspell 2008 -- Bridgeburner Ghosts
#name "Bridgeburner Ghosts"
#descr "The vengeful spirits of dead heroes return to aid their friends in battle. This spell will summon spirit forms of the legendary Bridgeburner company, attacking the enemy from all sides."
#school 4
#damage 5963
#nreff 7
#effect 43 -- border summon
#researchlevel 6
#restricted 201
#path 0 5
#path 1 4
#pathlevel 0 2
#pathlevel 1 1
#fatiguecost 200
#end

#newspell 2009 -- Bind Korvalah
#name "Bind Korvalah"
#descr "The mage summons and binds an imperial demon. The demon is a Korvalah, a terrible creature hailing from a realm of water and winds known as Aral Gamelon. It can unleash great destruction if let free in the world."
#school 0
#damage 5967
#nreff 1
#effect 10021
#researchlevel 7
#restricted 201
#path 0 1 -- Air
#path 1 4 -- Astral
#pathlevel 0 2	
#pathlevel 1 4
#fatiguecost 3000
#end

#newspell 2010 -- Call T'lan Imass
#name "Call T'lan Imass"
#descr "The caster summons two T'lan Imass to the battlefield. The T'lan Imass are ruthless warriors, able to instantly move across the battlefield by turning to dust and reappearing where want to be."
#school 0
#researchlevel 4
#path 0 0
#path 1 3
#pathlevel 0 2 -- fire
#pathlevel 1 1 -- earth
#fatiguecost 100
#damage 5971
#effect 1
#nreff 3
#restricted 201
#end

#newspell 2011 -- Contact Bonecaster
#name "Contact Bonecaster"
#descr "The caster summons one of the T'lan Imass Bonecasters. These old shamans are masters of Tellan, the Elder Warren of Fire, but also knowledge of death magic."
#school 0
#researchlevel 5
#path 0 0
#path 1 3
#pathlevel 0 3 -- fire
#pathlevel 1 1 -- earth
#fatiguecost 2600
#damage 5972
#effect 10021
#nreff 1
#restricted 201
#end

#newspell 2012 -- T'lan Imass Warriors for T'lan Imass Legion
#name "T'lan Imass Warriors"
#descr "description"
#path 0 0
#path 1 5
#pathlevel 0 3
#pathlevel 1 1
#fatiguecost 0
#school -1
#effect 10001
#damage 5971
#nreff 50
#end

#newspell 2013 -- T'lan Imass Legion
#name "T'lan Imass Legion"
#descr "The caster summons an army of T'lan Imass led by a Bonecaster shaman. The T'lan Imass are ruthless warriors, able to instantly move across the battlefield by turning to dust and reappearing where want to be."
#school 0
#researchlevel 6
#path 0 0
#path 1 5
#pathlevel 0 3
#pathlevel 1 1
#effect 10021
#damage 5972
#nreff 1
#fatiguecost 6500
#nextspell "T'lan Imass Warriors"
#restricted 201
#end

#newspell 2014 -- Moranth Soldiers for Moranth Legion
#name "Moranth Soldiers"
#descr "Summons Moranth Soldiers"
#path 0 4
#pathlevel 0 1
#fatiguecost 0
#school -1
#effect 10001
#damage 5980
#nreff 24
#end

#newspell 2015 -- Moranth Munitionists for Moranth Legion
#name "Moranth Munitionists"
#descr "Summons Moranth Munitionists"
#path 0 4
#pathlevel 0 1
#fatiguecost 0
#school -1
#effect 10001
#damage 5981
#nreff 2
#nextspell "Moranth Soldiers"
#end

#newspell 2016 -- Moranth Legion
#name "Moranth Regiment"
#descr "The caster hires a regiment of Black Moranth, including a commander and a pair of munitionists."
#path 0 4
#pathlevel 0 1
#fatiguecost 1600
#school 0
#researchlevel 0
#effect 10021
#damage 5982
#nreff 1
#nextspell "Moranth Munitionists"
#restricted 201
#end

-- Nametypes

#selectnametype 170 -- Soldier names
#clear
#addname "A'Karonys"
#addname "Able"
#addname "Aimless"
#addname "Amby"
#addname "Amiss"
#addname "Antsy"
#addname "Anyx Fro"
#addname "Apsalar"
#addname "Ash"
#addname "Badan Gruk"
#addname "Bala Jesselt"
#addname "Balk"
#addname "Banaschar"
#addname "Banter"
#addname "Barack"
#addname "Baudin"
#addname "Bavedict"
#addname "Beak"
#addname "Bell"
#addname "Bellam Nom"
#addname "Bellig Harn"
#addname "Bellurdan"
#addname "Benger"
#addname "Blanket"
#addname "Blend"
#addname "Bliss Rolly"
#addname "Blistig"
#addname "Bluepearl"
#addname "Bottle"
#addname "Bowl"
#addname "Braven Tooth"
#addname "Brethless"
#addname "Brow"
#addname "Bucklund"
#addname "Bulge"
#addname "Burnt"
#addname "Burnt Rope"
#addname "Calot"
#addname "Chase"
#addname "Chenned"
#addname "Chopper"
#addname "Clasp"
#addname "Clay Plate"
#addname "Cold"
#addname "Corabb Bhilan Thenu'alas"
#addname "Cord"
#addname "Corinn"
#addname "Cracker"
#addname "Crank"
#addname "Crease"
#addname "Cripple"
#addname "Croak"
#addname "Crow"
#addname "Crump"
#addname "Cuttle"
#addname "Daint"
#addname "Daisy Broke"
#addname "Deader"
#addname "Deadsmell"
#addname "Detoran"
#addname "Dirk"
#addname "Drawfirst"
#addname "Drillbent"
#addname "Dristan"
#addname "Duiker"
#addname "Dujek"
#addname "Ebron"
#addname "Faradan Sort"
#addname "Fast"
#addname "Ferrule"
#addname "Flashwit"
#addname "Flown"
#addname "Folibore"
#addname "Footfirst"
#addname "Futhgar"
#addname "Galt"
#addname "Gaunt-Eye"
#addname "Gesler"
#addname "Given Loud"
#addname "Goblin"
#addname "Goodnight"
#addname "Grin"
#addname "Gruff"
#addname "Gullstream"
#addname "Gund Yellow"
#addname "Hair"
#addname "Hammer"
#addname "Hanno"
#addname "Hareb"
#addname "Hattar"
#addname "Havva Gulen"
#addname "Hayfire"
#addname "Hedge"
#addname "Hefty"
#addname "Hellian"
#addname "Hinge"
#addname "Honey"
#addname "Hopper"
#addname "Horser"
#addname "Hover"
#addname "Hummer"
#addname "Hunt"
#addname "Hunt"
#addname "Hurlochel"
#addname "Hurry"
#addname "Ibb"
#addname "Ipshank"
#addname "Jibb"
#addname "Job"
#addname "Jula"
#addname "Kamist Reloe"
#addname "Keneb"
#addname "Kindly"
#addname "Kiska"
#addname "Kisswhere"
#addname "Knuckles"
#addname "Korbolo Dom"
#addname "Koryk"
#addname "Kulp"
#addname "Lap Twirl"
#addname "Limp"
#addname "Lip"
#addname "List"
#addname "List"
#addname "Lobe"
#addname "Lookback"
#addname "Lope"
#addname "Lull"
#addname "Lutes"
#addname "Madan'tul Rada"
#addname "Mallet"
#addname "Masan Gilani"
#addname "Maybe"
#addname "Mayfly"
#addname "Mincer"
#addname "Moak"
#addname "Moak"
#addname "Monk"
#addname "Monkrat"
#addname "Morrut"
#addname "Mosel"
#addname "Mudslinger"
#addname "Mulch"
#addname "Mulvan Dreader"
#addname "Nast Forn"
#addname "Neller"
#addname "Nep Furrow"
#addname "Nightchill"
#addname "Nok"
#addname "Nose Stream"
#addname "Noto Boil"
#addname "Oams"
#addname "Olit Fas"
#addname "Paltry Skint"
#addname "Pearl"
#addname "Pella"
#addname "Pestle"
#addname "Picker"
#addname "Pores"
#addname "Pormqual"
#addname "Possum"
#addname "Pravalak Rim"
#addname "Primly"
#addname "Raband"
#addname "Ramp"
#addname "Ranal"
#addname "Reem"
#addname "Reliko"
#addname "Rellock"
#addname "Rib"
#addname "Ruffle"
#addname "Rumjugs"
#addname "Runter"
#addname "Ruthan Gudd"
#addname "Rythe Bude"
#addname "Sad"
#addname "Salk Elan"
#addname "Saltlick"
#addname "Sands"
#addname "Sawark"
#addname "Say No"
#addname "Scant"
#addname "Scrawl"
#addname "Seal"
#addname "Sevitt"
#addname "Shank"
#addname "Shard"
#addname "Shoaly"
#addname "Shortnose"
#addname "Shrake"
#addname "Singer"
#addname "Sinn"
#addname "Sinter"
#addname "Skanarow"
#addname "Skim"
#addname "Skulldeath"
#addname "Smiles"
#addname "Smirk"
#addname "Snack"
#addname "So Bleak"
#addname "Sorrow"
#addname "Spindle"
#addname "Squint"
#addname "Stacker"
#addname "Stillwater"
#addname "Stormy"
#addname "Storp"
#addname "Strap Mull"
#addname "Straw"
#addname "Stump"
#addname "Sty"
#addname "Sulban"
#addname "Sulmar"
#addname "Sunrise"
#addname "Sweetcreek"
#addname "Sweetlard"
#addname "Tarr"
#addname "Tattersail"
#addname "Tavos Pond"
#addname "Temper"
#addname "Thom Tissy"
#addname "Throatslitter"
#addname "Toc"
#addname "Toes"
#addname "Torc"
#addname "Touchy"
#addname "Trand"
#addname "Trotts"
#addname "Truth"
#addname "Tugg"
#addname "Tulip"
#addname "Turner"
#addname "Twist"
#addname "Under"
#addname "Undercart"
#addname "Untilly Rum"
#addname "Urb"
#addname "Uru Hela"
#addname "Vastly Blank"
#addname "Wheeze"
#addname "Widdershins"
#addname "Wimble Thrup"
#addname "Windy"
#addname "Wink"
#end

#selectnametype 171 -- Red Blade names
#clear
#addname "Aralt"
#addname "Arapar"
#addname "Arpat"
#addname "Asriam"
#addname "Barathol"
#addname "Baria"
#addname "Beltere"
#addname "Beralta"
#addname "Bostane"
#addname "Dabir"
#addname "Erathol"
#addname "Ghalra"
#addname "Ghara"
#addname "Ghestela"
#addname "Ghiyatha"
#addname "Jafaram"
#addname "Karam"
#addname "Karia"
#addname "Kazim"
#addname "Larpan"
#addname "Lastere"
#addname "Lostara"
#addname "Mekhar"
#addname "Merathol"
#addname "Meriam"
#addname "Mesker"
#addname "Nasri"
#addname "Salam"
#addname "Saram"
#addname "Taria"
#addname "Tene"
#addname "Wachem"
#addname "Zerem"
#end

#selectnametype 172 -- Wickan names
#clear
#addname "Ai'neth"
#addname "Airmo"
#addname "Aither"
#addname "Benan"
#addname "Bersil"
#addname "Besul"
#addname "Bult"
#addname "Clearwater"
#addname "Colt Su'dath"
#addname "Cu"
#addname "Duthaine"
#addname "Medaip"
#addname "Mult"
#addname "Nadup"
#addname "Naithe"
#addname "Nether"
#addname "Nil"
#addname "Norrep"
#addname "Nuth"
#addname "Other"
#addname "Rethaine"
#addname "Rith Rith'ep"
#addname "Sedul"
#addname "Sernath"
#addname "Seth"
#addname "Sormo E'nath"
#addname "Su"
#addname "Ta'elt"
#addname "Temoth"
#addname "Temul"
#addname "Tenith"
#addname "Udep"
#addname "Ermo"
#addname "Ether"
#addname "Esul"
#end

-- New sites

#newsite 1887
#name "The Deadhouse"
#path 6
#level 0
#rarity 5
#gems 0 1		--Fire
#gems 1 1		--Air
#gems 4 3		--Astral
#end

#newsite 1888
#name "Malaz City"
#homemon 5958	--Marines
#homecom 5925	--High Fist
#homecom 5935	--Claw
#path 5
#level 0
#rarity 5
#end

#newsite 1889
#name "Mock's Hold"
#homecom 5928	--High mages ->
#homecom 5932
#path 7
#level 0
#rarity 5
#end


-- Nation specifics

#selectnation 201
#name "Malaz"
#epithet "Empire of the Fallen"
#era 2
#descr "The Malazan Empire arose out of nowhere in the midst of struggles between other realms. Established by an elusive cabal of mages and assassins, the leader of the mage cabal took the throne as Emperor. The Malazans relied on diverse mages and good, common soldiers rather than faith. Pragmatic and expansionistic, they soon began conquering foreign lands and incorporating them into a rich, multicultural empire. While they ruthlessly suppressed any opposition, supported by a covert organisation of assassins known as the Claw, loyal citizens had much to gain under the Malazan Empire. Religions and cults were not so lucky, as the Malazans decimated and purged many of the priests and cults dedicated to various gods. Their versatile infantry is reliable and features several specialised roles, such as marines and sappers, and supported by auxiliary cavalry made up of conquered peoples. Malazan mages are diverse, often part of the army, but Malaz distinguishes itself with its access to reliable healing magic, keeping commanders, mages and normal soldiers alive for much longer."
#summary "Race: Humans
Military: Strong infantry, crossbowmen, and sappers. Great commanders. Limited cavalry and no sacreds.
Magic: Superior healing and magical longevity (for humans). Access to all magic paths, but highly random.
Priests: Weak. Priests are shunned and proscribed in Malaz."
#brief "Malaz is a warlike, expansionistic empire of humans with a strong emphasis on verstatile infantry and magic. Cults and priests have been culled, but a combination of subterfuge, stealthy units, and powerful shock infantry make up for the lack of holy power."
#color 0.43 0.22 0.45
#secondarycolor 0.25 0.25 0.25
#flag "flag.tga"
#startsite "The Deadhouse"
#startsite "Malaz City"
#startsite "Mock's Hold"
#idealcold 0

-- Forts, labs and temples

#fortera 2
#labcost 500
#templecost 600
#templepic 6

-- Starting Units
#startcom 5924		-- non summoning fist
#startunittype1 5939 	-- medium infantry
#startunitnbrs1 15
#startunittype2 5947 	-- crossbowmen
#startunitnbrs2 15
#startscout 5962

-- Province defence

#defcom1 5924	-- Fist
#defcom2 5927	-- Cadre mage
#defunit1 5937	-- Skirmishers
#defunit1b 5947	-- Crossbowmen
#defunit2 5941	-- medium w/ javelins
#defunit2b 5945	-- heavy infantry

#defmult1 15
#defmult1b 10
#defmult2 10
#defmult2b 10

-- Gods
#homerealm 3
#homerealm 10
#addgod 2784 -- Fener
#addgod 5954
#cheapgod40 5954
#addgod 5955
#cheapgod40 5955

-- Units

#addrecunit 5937 -- Skirmisher
#addrecunit 5939 -- Medium Infantry
#addrecunit 5941 -- Medium Infantry w/ javelins
#addrecunit 5943 -- Medium Infantry w/ spears
#addrecunit 5945 -- Heavy Infantry
#addrecunit 5947 -- Crossbowmen
#addrecunit 5969 -- Sappers
#addrecunit 5977 -- Wickan Raiders
#addrecunit 5970 -- Wickan Lancer
#wasterec 5960 -- Red Blade

-- Commanders

#addreccom 5962 -- Malazan Scout
#addreccom 5923 -- Fist summoning form
#addreccom 5921 -- Marine Sergeant summoning form
#addreccom 5934 -- Priest
#addreccom 5927 -- Cadre Mage
#addreccom 5933 -- Denul healer
#addreccom 5936 -- Wickan Commander
#wastecom 5959 -- Red Blade Commander			

--  Hero Settings

#hero1 5949 -- Lorn
#hero2 5950 -- Fiddler
#hero3 5951 -- Coltaine
#hero4 5979 -- Tayschrenn
#hero5 5952 -- Quick Ben
#hero6 5953 -- Kalam 
#hero7 5968 -- Tool

#end