#modname "Ginnungaheim v1"
#description "A nation of celestial builders."
#icon "./Ginnungaheim/Logo.tga"
#version 1.1


---NAMES
#selectnametype 224 --male icelandic
#addname "Stjarna" --star
#addname "Vetrarbraut" --galaxy
#addname "Tungl" --moon
#addname "Sól" --sun
#addname "Sólarljós" --sunlight
#addname "Halastjarna" --comet
#addname "Loftsteinn" --meteor
#addname "Gervihnött" --satellite
#addname "Sólsetur" --sunset
#addname "Reikistjarna" --planetarium
#addname "Smástirni" --asteroid
#addname "Myrkvi" --eclipse
#addname "Dulstirni" --quasar
#addname "Uppsöfnunardiskur" --accretion disk
#addname "áfall" --appulse
#addname "Himneskur" --celestial
#addname "Andrúmsloft" --atmosphere
#addname "Litninga" --chromosphere
#addname "Stjörnumerki" --constellation
#addname "Kóróna" --corona
#addname "Kosmískt" --cosmic
#addname "Geimgeisli" --cosmic ray
#addname "Heimsmynd" --cosmogeny
#addname "Dvergreikistjörnu" --dwarf planet
#addname "Sólmyrkvi" --ecliptic
#addname "Skammlífur" --ephemeris
#addname "Miðbaug" --equator
#addname "Sunna" --sun
#addname "Jafndaegur" --equinox
#addname "Fjarreikistjörnu" --exoplanet
#addname "Deild" --facula
#addname "Gasrisi" --gas giant
#addname "Thyngdarafl" --gravity
#addname "Millistjörnur" --interstellar
#addname "Freksun" --libration
#addname "Ljósár" --light year
#addname "Birtustig" --luminosity
#addname "Tungl" --lunar
#addname "Segulhvolf" --magnetosphere
#addname "Tunglslitur" --moonlet
#addname "Fjölvers" --multiverse
#addname "Thoka" --nebula
#addname "Nifteind" --neutron
#addname "Naering" --nutation
#addname "Dulspeki" --occultation
#addname "Sporbraut" --orbit
#addname "Geimnum" --outer space
#addname "Tindrandi" --scintillation
#addname "Himinn" --sky
#addname "Sólblossi" --solar flare
#addname "Sólstormur" --solar storm
#addname "Ofurthyrping" --supercluster
#addname "Sprengistjarna" --supernova
#addname "Sjávarfalla" --tidal
#addname "Rökkrinu" --twilight
#addname "Alheimsins" --universe
#addname "Hápunkti" --zenith
#addname "Brú" --bridge
#addname "Regnboga" --rainbow
#addname "Virki" --fortress
#addname "Stjörnuljós" --starlight
#addname "Grunnur" --foundation
#addname "Árvakr" --early riser
#addname "Myr" --million years measurement
#addname "Kyr" --thousand years measurement
#addname "Kirkjuþing" --synodic
#end

---WEAPONS
#newweapon 
#copyweapon 8
#name "Muspel Sword"
#dmg 7
#magic
#secondaryeffect 221 --fire from flambeau
#end

#newweapon 
#copyweapon 1
#name "Muspel Spear"
#dmg 4
#magic
#secondaryeffect 221 --fire from flambeau
#end

#newweapon 
#copyweapon 11
#name "Muspel Great Sword"
#dmg 10
#magic
#secondaryeffect 221 --fire from flambeau or 684 for Flames?
#end

#newweapon 
#copyweapon 27 --boulder
#name "Throwing Star"
#norepel
#range -1
#dmg 7
#secondaryeffectalways 171 --small area fire
#ammo 1007
#explspr 10113
#flyspr 10280
#end

#newweapon 
#copyweapon 14 --maul
#name "Burning Hammer"
#dmg 10
#magic
#secondaryeffectalways 171 --small area fire
#end

#newweapon 
#copyweapon 331 --gore
#name "Fiery Gore"
#secondaryeffectalways 171 --small area fire
#end

---ARMOR
#newarmor
#copyarmor 2
#name "Mirror Shield"
#rcost 3
#magicarmor
#end

#newarmor 
#copyarmor 225 --ice aegis
#name "Svalinn Shard"
#end

---MONSTERS
#newmonster 8050
#spr1 "./Ginnungaheim/WarriorSword1.tga"
#spr2 "./Ginnungaheim/WarriorSword2.tga"
#name "Ljostursar Warrior"
#descr "A warrior armed with a flaming sword of Muspel."
#gcost 10060
#rpcost 25
#hp 70
#size 9
#prot 11
#mr 15
#mor 14
#str 26
#att 12
#def 12
#prec 11
#enc 2
#ap 16
#mapmove 22
#weapon "Muspel Sword" --sword
#armor 196 --golden scale mail
#armor 2 --shield
#blind
#fireres 25
#poisonres 15
#heat 13
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 2
#startage 300
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#end

#newmonster 8051
#spr1 "./Ginnungaheim/WarriorSpear1.tga"
#spr2 "./Ginnungaheim/WarriorSpear2.tga"
#name "Ljostursar Warrior"
#descr "A warrior armed with a flaming spear of Muspel."
#gcost 10060
#rpcost 25
#hp 70
#size 9
#prot 11
#mr 15
#mor 14
#str 26
#att 12
#def 12
#prec 11
#enc 2
#ap 16
#mapmove 22
#weapon "Muspel Spear" --spear
#armor 196 --golden scale mail
#armor 2 --shield
#blind
#fireres 25
#poisonres 15
#heat 13
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 2
#startage 300
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#end

#newmonster 8052
#spr1 "./Ginnungaheim/Gatekeeper1.tga"
#spr2 "./Ginnungaheim/Gatekeeper2.tga"
#name "Keeper of the Gate"
#descr "A Ljostursar dedicated to guarding a fortress. They're outfitted with great flaming swords. Expected to be ever vigilant in their watch."
#gcost 10110
#rpcost 10000
#hp 76
#size 9
#prot 11
#mr 15
#mor 15
#str 27
#att 13
#def 12
#prec 11
#enc 2
#ap 16
#mapmove 22
#weapon "Muspel Great Sword" --surtr sword
#armor 196 --golden scale mail
#blind
#fireres 25
#poisonres 15
#heat 13
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 2
#patrolbonus 5
#castledef 5
#startage 500
#holy
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#end

#newmonster 8053
#spr1 "./Ginnungaheim/Sowilo1.tga"
#spr2 "./Ginnungaheim/Sowilo2.tga"
#name "Star Thrower"
#descr "It takes a Ljostursar many centuries to master the art of creation a star. True masters can create small stars and sling them at the enemy. They're not meant to be in the frontline with their kin and wear no armor. The sheer brilliance of their projectiles protects them somewhat from enemy attacks."
#gcost 10080
#rpcost 27
#hp 70
#size 9
#prot 11
#mr 15
#mor 14
#str 27
#att 11
#def 11
#prec 11
#enc 2
#ap 15
#mapmove 21
#weapon "Throwing Star" --throw star
#weapon 320 --flaming fist
#blind
#fireres 25
#poisonres 15
#heat 15
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 2
#siegebonus 1
#awe 2
#localsun
#startage 200
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#end

#newmonster 8054
#spr1 "./Ginnungaheim/Solveig1.tga"
#spr2 "./Ginnungaheim/Solveig2.tga"
#name "Solveig"
#descr "Working the forge of creation is hard work. Many Ljostursar swing great hammers all day for the designs of the architects. But not all that are exceptionally strong follow that calling, some become warriors on the frontline instead. Armed with great hammers they crush all who stand before Ginnungaheim."
#gcost 10115
#rpcost 30
#hp 74
#size 9
#prot 11
#mr 15
#mor 14
#str 28
#att 12
#def 12
#prec 11
#enc 2
#ap 16
#mapmove 22
#weapon "Burning Hammer" --flaming hammer
#armor 196 --golden scale mail
#blind
#fireres 25
#poisonres 15
#heat 14
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 3
#sunawe 1
#startage 450
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#end

#newmonster 8055
#spr1 "./Ginnungaheim/Mani4.tga"
#spr2 "./Ginnungaheim/Mani5.tga"
#name "Mani Guard"
#descr "Mani are a creation of Mundilfari, the great priest. He created them as servants to the Ljostursar, to aid and protect them. They're significantly smaller and lack the burning spark of Muspel.

For their protective duty the Mani are outfitted with a shining shield that reflects the light of the sun and spells of magic alike."
#gcost 10030
#rpcost 20
#hp 35
#size 6
#prot 11
#mr 15
#mor 13
#str 22
#att 11
#def 13
#prec 11
#enc 2
#ap 16
#mapmove 18
#weapon 1 --spear
#armor 196 --golden scale mail
#armor 213 --golden helmet
#armor "Mirror Shield" --mirror shield
#blind
#fireres 15
#poisonres 15
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 1
#bodyguard 2
#sunawe 1
#startage 100
#maxage 2000
#deathfire 1
#nametype 224 --Icelandic celestial names?
#end





---COMMANDERS
#newmonster 8056
#spr1 "./Ginnungaheim/HighVala1.tga"
#spr2 "./Ginnungaheim/HighVala2.tga"
#name "Sólbjartr"
#descr "A vala of tremendous power, the sólbjartr are the high priestesses of the Ljostursar. All of them are vala of great power who mastered the creation of stars."
#gcost 10100
#rpcost 4
#hp 68
#size 9
#prot 11
#mr 17
#mor 14
#str 26
#att 11
#def 10
#prec 11
#enc 2
#ap 16
#mapmove 22
#weapon "Throwing Star" --throw star
#weapon 320 --flaming fist
#blind
#fireres 25
#poisonres 15
#heat 15
#siegebonus 1
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 2
#awe 5
#localsun
#female
#holy
#startage 800
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#magicskill 9 2
#magicskill 0 2
#magicskill 4 1
#custommagic 2176 100
#custommagic 2176 100 --SF1
#poorleader
#poormagicleader
#magiccommand 10
#end

#newmonster 8057
#spr1 "./Ginnungaheim/Vala1.tga"
#spr2 "./Ginnungaheim/Vala2.tga"
#name "Vala"
#descr "The vala are the priestesses of the Ljostursar. They serve under a Sólbjartr in the temples. They're far less skilled then their mistress but hope to learn from her. The most talented will eventually be elevated to the office of Sólbjartr. Their sheer radiance blinds most mortals, making it hard to strike them."
#gcost 10070
#rpcost 2
#hp 66
#size 9
#prot 11
#mr 16
#mor 14
#str 24
#att 10
#def 10
#prec 11
#enc 2
#ap 16
#mapmove 22
#weapon 92 --fist
#blind
#fireres 25
#poisonres 15
#heat 13
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 2
#awe 3
#localsun
#female
#holy
#startage 300
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#magicskill 9 1
#magicskill 0 1
#custommagic 128 50
#custommagic 2048 10
#poorleader
#poormagicleader
#end

#newmonster 8058
#spr1 "./Ginnungaheim/Architect1.tga"
#spr2 "./Ginnungaheim/Architect2.tga"
#name "Stellar Architect"
#descr "When the Pantokrator tasked the Ljostursar with building his rainbow bridge and starlit sky it fell to the Architects to actually design functional plans. They're experts in construction and thus destruction of anything building."
#gcost 10090
#rpcost 2
#hp 70
#size 9
#prot 11
#mr 16
#mor 14
#str 27
#att 10
#def 10
#prec 11
#enc 2
#ap 16
#mapmove 21
#weapon 27 --throw boulder
#weapon 637 --tool
#blind
#fireres 25
#poisonres 15
#heat 13
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 2
#siegebonus 30
#resources 20
#mastersmith 1
#startage 700
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#magicskill 1 1
#magicskill 3 1
#magicskill 4 2
#custommagic 512 20
#poorleader
#poormagicleader
#magiccommand 10
#end

#newmonster 8059 --jarl
#spr1 "./Ginnungaheim/Jarl1.tga"
#spr2 "./Ginnungaheim/Jarl2.tga"
#name "Ljostursar Jarl"
#descr "Jarls are the greatest Ljostursar, towering even over their kin. They're their war leaders, leading their warriors from the front. They can harness their inner heat to unleash a torrent of flames upon their enemies."
#gcost 10200
#rpcost 2
#hp 78
#size 10
#prot 11
#mr 15
#mor 16
#str 27
#att 13
#def 13
#prec 11
#enc 2
#ap 16
#mapmove 22
#weapon "Muspel Sword" --sword
#weapon 710 --flaming breath
#armor 196 --golden scale mail
#armor 2 --shield
#blind
#fireres 25
#poisonres 15
#heat 14
#magicbeing
#voidsanity 15
#voidret 10
#neednoteat
#appetite 3
#startage 1000
#maxage 4000
#deathfire 6
#nametype 224 --Icelandic celestial names?
#okleader
#goodmagicleader
#end

#newmonster 8060
#spr1 "./Ginnungaheim/Scout1.tga"
#spr2 "./Ginnungaheim/Scout1.tga"
#name "Wandalaz"
#descr "Ljostursar don't make great scouts, they're huge and smouldering. But the word of Ginnungaheim must be spread. So these men wander the world spreading the good word."
#gcost 10050
#rpcost 2
#hp 71
#size 9
#prot 11
#mr 15
#mor 14
#str 26
#att 12
#def 12
#prec 11
#enc 2
#ap 16
#mapmove 24
#weapon "Muspel Spear" --flaming spear
#armor 196 --golden scale mail
#armor 2 --shield
#blind
#fireres 25
#poisonres 15
#heat 13
#magicbeing
#voidsanity 15
#voidret 15
#neednoteat
#appetite 2
#startage 300
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#magicskill 9 1
#holy
#noleader
#end



---SUMMONS
#newmonster 8061
#spr1 "./Ginnungaheim/CelestialBovine1.tga"
#spr2 "./Ginnungaheim/CelestialBovine2.tga"
#name "Celestial Bull"
#descr "At the start of creation celestial cattle roamed the void. When the Ljostursar were tasked with building the world they tamed these animals to use them as beasts of burden."
#gcost 0
#hp 85
#size 9
#prot 12
#mr 12
#mor 11
#str 28
#att 12
#def 11
#prec 5
#enc 2
#ap 20
#mapmove 22
#weapon 55 --hoof
#weapon "Fiery Gore" --star burst gore
#trample
#resources 15
#siegebonus 5
#animal
#coldres 3
#fireres 25
#heat 14
#voidsanity 20
#voidret 15
#startage 100
#maxage 1000
#deathfire 3
#nametype 224 --Icelandic celestial names?
#end

#newmonster 8062
#spr1 "./Ginnungaheim/ManiA1.tga"
#spr2 "./Ginnungaheim/ManiA2.tga"
#name "Mani Attendant"
#descr "Mani are a creation of Mundilfari, the great priest. He created them as servants to the Ljostursar, to aid and protect them. They're significantly smaller, lack the burning spark of Muspel.

Attendants serve the architects directly, carrying equipment and aiding in their designs"
#gcost 0
#hp 33
#size 6
#prot 11
#mr 15
#mor 13
#str 21
#att 10
#def 10
#prec 11
#enc 2
#ap 16
#mapmove 18
#weapon 14 --maul
#armor 213 --golden helmet
#blind
#fireres 15
#poisonres 15
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 1
#fixforgebonus 1
#researchbonus 2
#startage 400
#maxage 2000
#deathfire 1
#nametype 224 --Icelandic celestial names?
#magicskill 4 1 --S1
#end

#newmonster 8063
#copyspr 1025
#name "Delay Dummy"
#descr "You shouldn't be able to see this monster. If you did, please report it to Mormacil."
#nowish
#stealthy 959
#hp 500
#size 9
#prot 30
#mr 22
#mor 50
#str 30
#att 30
#def 30
#prec 30
#enc 0
#mapmove 0
#invisible
#immobile
#unteleportable
#ap 0
#maxage 10000
#amphibian
#gcost 0
#woundfend 99
#landdamage 40
#uwdamage 40
#inanimate
#nohof
#heal
#end

#newmonster 8064
#copyspr 1025
#name "Delay Dummy"
#descr "You shouldn't be able to see this monster. If you did, please report it to Mormacil."
#nowish
#stealthy 959
#hp 500
#size 9
#prot 30
#mr 22
#mor 50
#str 30
#att 30
#def 30
#prec 30
#enc 0
#mapmove 0
#invisible
#immobile
#unteleportable
#ap 0
#maxage 10000
#amphibian
#gcost 0
#woundfend 99
#landdamage 40
#uwdamage 40
#inanimate
#nohof
#heal
#end

#newmonster 8066
#spr1 "./Ginnungaheim/Stjarna1.tga"
#spr2 "./Ginnungaheim/Stjarna2.tga"
#name "Stjarna"
#descr "The Ljostursar are celestial architect, among their creations are the stars themselves that dot the heavenly sphere at night. This is a proto-star having being fit to a wheel-like frame as it grows and stabilizes. It creates a tremendous heat no mortal can withstand but it is instable. Should it be sufficiently damaged it will explode.

They're often flanked by a pair of Solgarmr, doglike fire spirits trained by the Ljostursar as guardians."
#gcost 0
#hp 66
#size 10
#prot 1
#mr 18
#mor 50
#str 20
#att 5
#def 5
#prec 5
#enc 2
#ap 4
#mapmove 2
#weapon 547 --buff
#trample
#blind
#localsun
#ethereal
#coldres 5
#fireres 45
#heat 17
#voidsanity 20
#startage 0
#maxage 9999
#deathfire 7
#batstartsum2 8067
#onebattlespell "Heat from Hell"
#nametype 224 --Icelandic celestial names?
#end

#newmonster 8067
#spr1 "./Ginnungaheim/Solgarmr6.tga"
#spr2 "./Ginnungaheim/Solgarmr7.tga"
#name "Solgarmr"
#descr "Solgarmr are fire spirits with doglike qualities domesticated by the Ljostursar as guard dogs. They're often tasked with protecting incubating young stars but are also known to flank the great priestesses as they travel the heavens."
#gcost 0
#hp 22
#size 5
#prot 0
#mr 15
#mor 18
#str 14
#att 12
#def 12
#prec 5
#enc 0
#ap 15
#mapmove 16
#weapon 229 --flame strike
#animal
#float
#ethereal
#coldres 3
#fireres 65
#heat 14
#voidsanity 10
#voidret 5
#startage 100
#maxage 1000
#nametype 224 --Icelandic celestial names?
#end

#newmonster 8070
#copyspr 1025
#name "Crater Dummy"
#descr "You shouldn't be able to see this monster. If you did, please report it to Mormacil."
#nowish
#stealthy 959
#hp 500
#size 10
#prot 30
#mr 22
#mor 50
#str 30
#att 30
#def 30
#prec 30
#enc 0
#mapmove 0
#invisible
#immobile
#unteleportable
#ap 0
#maxage 10000
#amphibian
#gcost 0
#woundfend 99
#landdamage 90
#uwdamage 90
#inanimate
#nohof
#heal
#end

#newmonster 8073 --jarl for remote attack
#spr1 "./Ginnungaheim/Jarl1.tga"
#spr2 "./Ginnungaheim/Jarl2.tga"
#name "Ljostursar Jarl"
#descr "Jarls are the greatest Ljostursar, towering even over their kin. They're their war leaders, leading their warriors from the front. They can harness their inner heat to unleash a torrent of flames upon their enemies."
#gcost 10200
#rpcost 2
#hp 78
#size 10
#prot 11
#mr 15
#mor 16
#str 27
#att 13
#def 13
#prec 11
#enc 2
#ap 16
#mapmove 22
#weapon "Muspel Sword" --sword
#weapon 710 --flaming breath
#armor 196 --golden scale mail
#armor 2 --shield
#blind
#fireres 25
#poisonres 15
#heat 14
#magicbeing
#voidsanity 15
#voidret 10
#neednoteat
#appetite 3
#startage 1000
#maxage 4000
#deathfire 6
#nametype 224 --Icelandic celestial names?
#okleader
#goodmagicleader
#end


---HEROES
#newmonster 8065 --Glenr
#spr1 "./Ginnungaheim/HeroGlenr1.tga"
#spr2 "./Ginnungaheim/HeroGlenr1.tga"
#name "Husband"
#descr "Glenr is a great jarl married to the high priestess of the Vala. He serves as the head of the temple guard, leading the greatest giants in battle. He's a towering over even regular Ljostursar, exceeding ever other Jarls in height.

Like his fellow Jarls he's armed with a flaming Muspel sword and can unleash his inner sun as a wave of flames upon his enemies."
#gcost 0
#rpcost 2
#hp 82
#size 10
#prot 11
#mr 16
#mor 16
#str 27
#att 13
#def 13
#prec 11
#enc 2
#ap 16
#mapmove 22
#weapon "Muspel Sword" --sword
#weapon 710 --flaming breath
#armor 196 --golden scale mail
#blind
#fireres 25
#poisonres 15
#heat 15
#magicbeing
#voidsanity 15
#voidret 10
#neednoteat
#appetite 3
#startage 1000
#maxage 4000
#deathfire 6
#magicskill 9 2
#magicskill 0 1 --F1?
#fixedname "Glenr"
#localsun
#okleader
#goodmagicleader
#end

#newmonster 8068
#spr1 "./Ginnungaheim/HeroHalogi1.tga"
#spr2 "./Ginnungaheim/HeroHalogi1.tga"
#name "Blademaster"
#descr "Halogi was the first Celestial Architect to forge a Muspel Blade. His creation armed the soldiers of Ginnungaheim ever since. He still hammers new blades to this day and occasionally will create one of superb qualities worthy of a god. One of his hands has been damaged over the millenia, the thinner layer of celestial material struggles to shield his internal heat. He has turned this to his benefit as it allows him to merely grip a blade to heat the metal."
#gcost 0
#rpcost 2
#hp 70
#size 9
#prot 11
#mr 18
#mor 14
#str 28
#att 10
#def 10
#prec 11
#enc 2
#ap 16
#mapmove 21
#weapon "Burning Hammer" --flaming hammer
#weapon 320 --flaming fist
#blind
#fireres 25
#poisonres 15
#heat 14
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 2
#siegebonus 30
#resources 20
#mastersmith 2
#startage 1700
#maxage 4000
#deathfire 5
#nametype 224 --Icelandic celestial names?
#magicskill 1 2
#magicskill 3 2
#magicskill 4 3
#poorleader
#poormagicleader
#magiccommand 20
#holy
#fixedname "Halogi"
#latehero 12
#end

#newmonster 8069
#spr1 "./Ginnungaheim/HeroMundilfari1.tga"
#spr2 "./Ginnungaheim/HeroMundilfari1.tga"
#name "Father"
#descr "Mundilfari was the first priest among the Ljostursar before the Vala priestesses were founded. As they gained power his waned, instead he focused his time on creating a servile race. The result of that quest was the Mani, small beings in suits of similar matter but without the divine spark inside them. As their creator he's always flanked by a pair of them, they consider this the most honorable position in the entire realm.

He's also mastered the skill of creating suns and easily throws proto-stars to whomever threathens him."
#gcost 0
#rpcost 27
#hp 70
#size 9
#prot 11
#mr 18
#mor 15
#str 27
#att 11
#def 11
#prec 11
#enc 2
#ap 15
#mapmove 21
#weapon "Throwing Star" --throw star
#weapon 320 --flaming fist
#blind
#fireres 25
#poisonres 15
#heat 15
#magicbeing
#voidsanity 15
#voidret 5
#neednoteat
#appetite 2
#siegebonus 2
#awe 3
#localsun
#startage 3100
#maxage 4000
#deathfire 5
#batstartsum2 8055 --mani guard
#magicskill 1 2
#magicskill 9 2
#magicskill 4 3
#latehero 10
#okleader
#okmagicleader
#fixedname "Mundilfari"
#end




---PRETENDERS
#newmonster 8071
#copystats 2449 --idol sorcery
#spr1 "./Ginnungaheim/SunnaIdol1.tga"
#spr2 "./Ginnungaheim/SunnaIdol2.tga"
#name "Idol of the Sun"
#descr "This idol is cut from a black stone and dedicated to the power of the sun. It was a site frequent dedicated to worship and offerings piled up every season. With each passing generation it grew in power till it eventually awoke with a mind of it's own. With the disappearance of the Pantokrator the idol felt the chance to put the world under a strong dominion and become the True God."
#clearmagic
#clearspec
#miscshape
#poisonres 25
#bonusspells 1
#homerealm 1
#plant 1
#immobile
#pierceres
#slashres
#inanimate
#amphibian
#neednoteat
#spiritsight
#magicskill 0 2
#magicskill 4 1
#startdom 4
#pathcost 40
#end

#newmonster 8072 --greater jarl
#spr1 "./Ginnungaheim/GreaterJarl1.tga"
#spr2 "./Ginnungaheim/Jarl2.tga"
#name "Son of Muspel"
#descr "Jarls are the greatest Ljostursar, towering even over their kin. They're their war leaders, leading their warriors from the front. They can harness their inner heat to unleash a torrent of flames upon their enemies. Among them the Son of Muspel is the greatest, his power is so great he claims himself a god. He leads his people into a quest to achieve true godhood."
#gcost 10000
#rpcost 2
#hp 88
#size 10
#prot 11
#mr 18
#mor 30
#str 28
#att 14
#def 14
#prec 12
#enc 2
#ap 16
#mapmove 22
#weapon "Muspel Sword" --sword
#weapon 710 --flaming breath
#armor 196 --golden scale mail
#armor 2 --shield
#blind
#fireres 25
#poisonres 15
#heat 16
#magicbeing
#voidsanity 20
#voidret 15
#neednoteat
#appetite 4
#startage 2000
#maxage 5000
#deathfire 9
#nametype 224 --Icelandic celestial names?
#okleader
#goodmagicleader
#startdom 3
#pathcost 60
#magicskill 0 2
#magicskill 4 1
#end


---SPELLS
#newspell
#copyspell 1303 --teleport
#name "Bifrost Travel"
#descr "With this spell the mage calls upon the Bifrost to launch themselves across the realms to any province."
#provrange 7
#restricted "Ginnungaheim"
#onlyatsite "Bifrost" --rainbow bridge
#end

#newspell
#copyspell 1361 --astral travel
#name "Rainbow Road"
#descr "The caster creates a bridge in the fabric of space using the Bifrost, allowing them to step through with all troops under their command and enter a distant province."
#researchlevel 7
#pathlevel 4
#restricted "Ginnungaheim"
#onlyatsite "Bifrost" --rainbow bridge
#end

#newspell 
#name "Summon Fort"
#descr "Summon Fort"
#school -1 -- this means the spell is unresearchable and won't show up in unit lists
#researchlevel 0 -- this should be zero 
#path 0 2
#pathlevel 0 4
#effect 10082
#nreff 1
#damage 600 -- THIS IS THE IMPORTANT PART!!! THIS IS THE ENCHANTMENT ID NUMBER, IT NEEDS TO BE CLAIMED ON THE 4A CLAIM SHEET AND DIFFERENT FROM ALL OTHERS IN THE MOD
#fatiguecost 3000 -- the fatigue cost must be the same as the main spell. path and path level should be the same as well just to be safe, though I don't know if that actually effects anything
#restricted 191
#end

#newspell 
#copyspell 106 -- Record of Creation
#name "Ljostursar Fortress"
#descr "This spell starts the construction of a trading outpost along the coast. Allowing access to foreign technology. The outpost has an upkeep but should run a profit at the end of the year."
#school 0
#researchlevel 1
#path 0 4
#pathlevel 0 2 --S1
#provrange 7
#damage -1
#effect 10083
#fatiguecost 3000
#nreff 1
#restricted 191
#onlyatsite "Bifrost" --rainbow bridge
#details "This spell will fail if a fort is already present. The bindings will fail and the pearls will be wasted."
#nextspell "Summon Fort"
#end

#newspell
#name "Call Down Commander"
#descr "."
#school -1
#researchlevel 0
#path 0 4
#pathlevel 0 4 --S4
#provrange 5
#effect 10119 --far ind com sum
#damage 8059 --jarl
#nreff 1
#restricted 191
#end

#newspell
#name "Call Down Strike Force"
#descr "The caster calls down a strike force of six Ljostursar giants to attack an enemy position. They will wreck havoc upon a province of the caster's choice but not remain after the battle."
#school 0
#researchlevel 9
#path 0 4
#pathlevel 0 4 --S4
#fatiguecost 1000
#provrange 5
#effect 10038 --far ind sum
#damage 8050 --basic warrior sword
#nreff 5
#farsumcom 8059 --jarl
#restricted 191
#end

#newspell 
#name "Ice Crater"
#descr "Create the crash site of the Svalinn shield"
#school -1 -- this means the spell is unresearchable and won't show up in unit lists
#researchlevel 0 -- this should be zero 
#path 0 0
#pathlevel 0 6 --F6
#effect 10082
#nreff 1
#damage 601 -- THIS IS THE IMPORTANT PART!!! THIS IS THE ENCHANTMENT ID NUMBER, IT NEEDS TO BE CLAIMED ON THE 4A CLAIM SHEET AND DIFFERENT FROM ALL OTHERS IN THE MOD
#fatiguecost 7000 -- the fatigue cost must be the same as the main spell. path and path level should be the same as well just to be safe, though I don't know if that actually effects anything
#restricted 191
#end

#newspell 
#copyspell 106 -- Record of Creation
#name "Sunder Svalinn"
#descr "With this spell the caster attempts to shatter the ice shield that protects the world from the heat of the sun. As magical ice will rain down from the heavens the temperature of the world will steadily climb as the full power of the sun is unleashed."
#school 2
#researchlevel 1 --7
#path 0 0
#pathlevel 0 2 --F6
#damage -1
#effect 10083
#fatiguecost 7000 --7000
#nreff 1
#restricted 191
#details "Without the sun there can be no heat."
#nextspell "Ice Crater"
#end


#newspell 
#name "Repair Svalinn"
#descr "The caster attempts to mend the remnants pf the great ice shield to protect the world from the full power of the sun."
#school 3
#researchlevel 4 -- this should be zero 
#path 0 2
#pathlevel 0 6 --W6
#effect 10081
#nreff 1
#damage 602 -- THIS IS THE IMPORTANT PART!!! THIS IS THE ENCHANTMENT ID NUMBER, IT NEEDS TO BE CLAIMED ON THE 4A CLAIM SHEET AND DIFFERENT FROM ALL OTHERS IN THE MOD
#fatiguecost 4000 -- the fatigue cost must be the same as the main spell. path and path level should be the same as well just to be safe, though I don't know if that actually effects anything
#details "This spell has no effect unless Svalinn has been sundered by Ginnungaheim. It will cancel out the rise in temperature but remove the source of water gems that fall fown from the wreckage."
#end


#newspell
#name "Create Star"
#descr "The caster begins the creation of a young star. This volatile structure can then be moved into a more permanent position as it matures."
#school 3
#researchlevel 6
#path 0 0
#pathlevel 0 2 --F2
#path 1 4
#pathlevel 1 2 --S2
#fatiguecost 2000
#effect 10021 --com sum 
#damage 8066 --stjarna
#nreff 1
#restricted 191
#end

#newspell
#copyspell 1002
#name "Summon Sun Dogs"
#descr "The caster calls and binds five Solgarmr. The Solgarmr are fire spirits with doglike qualities domesticated by the Ljostursar as guard dogs." --check amount
#path 0 0
#pathlevel 0 3 --F3
#fatiguecost 600
#effect 10001 --sum 
#damage 8067 --sun dog
#restricted 191
#end


---ITEMS
#newitem
#copyitem 412 --ring returning
#constlevel 6
#spr "./Ginnungaheim/BifrostRune.tga"
#type 8
#name "Bifrost Rune"
#descr "This rune is a beacon for the Bifrost. It allows it's wearer to use call upon it to travel the realm. Should they be harmed it will instinctively remove the wearer from harm's way."
#spell "Teleport"
#restricted 191
#noimmobile
#end

#newitem
#copyitem 29
#spr "./Ginnungaheim/StarHammer.tga"
#name "Star Hammer"
#descr "This is the hammer of a Stellar Architect"
#mainpath 3
#mainlevel 1
#secondarypath 4
#secondarylevel 1
#restricted 191
#end

#newitem
#constlevel 4
#spr "./Ginnungaheim/SvalinnShield.tga"
#type 4
#name "Svalinn Shield"
#descr "This shield is made of enchanted ice from the Svalinn sun shell. It's enchanted to protect the wearer from the heat of the sun. It will struggle against severe heat and lose some of it's potency but never stop protecting it's wielder."
#armor "Svalinn Shard"
#fireres 10
#iceprot 3
#mainpath 2 --W
#mainlevel 2
#restricted 191
#end




---SITES
#newsite 
#name "Bifrost" --rainbow bridge
#path 4
#level 0
#rarity 5
#gems 4 3
#homemon 8052 --keeper
#homecom 8056 --high vala
#end

#newsite 
#name "Forge of Creation" --summon Gluts?
#path 0
#level 0
#rarity 5
#gems 0 2
#gems 3 1
#constcost 20
#end

#newsite 
#name "Capital of Bronze and Crystal"
#path 4
#level 0
#rarity 5
#homemon 8050 --sword warrior
#homemon 8051 --spear warrior
#homemon 8053 --str thrower
#homemon 8054 --solveig
#homecom 8059 --Jarl
#homecom 8058 --architect
#homecom 8057 --vala
#end

#newsite 1700
#name "Fortress of Bronze and Crystal"
#path 4
#level 0
#rarity 5
#mon 8050 --sword warrior
#mon 8051 --spear warrior
#mon 8053 --str thrower
#mon 8054 --solveig
#com 8059 --Jarl
#com 8058 --architect
#com 8057 --vala
#end

#newsite 
#name "Ljostursar Fortress recruitment"
#path 4
#level 0
#rarity 5
#homemon 8050 --sword warrior
#homemon 8051 --spear warrior
#homemon 8053 --str thrower
#homemon 8054 --solveig
#homecom 8059 --Jarl
#homecom 8058 --architect
#homecom 8057 --vala
#end

#newsite
#name "Closed Portal"
#path 4
#level 0
#rarity 5
#scry
#end

#newsite
#name "Svalinn Crater"
#path 2
#level 0
#rarity 5
#gems 2 1
#incscale 2 --increase cold
#end

---EVENTS
#newevent
#rarity 5 -- Rarity 5 is required, or the spell may fail if it conflicts with another rarity always event
#req_ench 600 -- THIS IS CALLING THE ENCHANTMENT ID, AND MUST BE THE SAME AS IN THE NEXT SPELL
#req_nositenbr 1700 -- Unless you want it to be possible to place multiple of the same sites in the province, this is important
#req_freesites 1 -- I think not adding this has the potential to crash the game. 
#req_fort 0
#msg "A great fortress has been pulled from beyond into this realm."
#addsite 1700 --Fortress of Bronze and Crystal
#fort 8
#end

#newevent
#rarity 5
#req_notfornation 191
#req_site 1
#msg "While capturing the fort the Ljostursar close their portal, yet a mage with Astral magic might use the remains to glimps into the beyond.[Fortress of Bronze and Crystal]"
#removesite -1
#delay 0
#end
#newevent
#rarity 5
#msg "Close portal.[Closed Portal]"
#addsite -1
#nolog
#notext
#end

#newevent
#rarity 5
#req_fornation 191
#req_site 1
#req_fort 1
#req_mindef 1
#msg "With regaining control of the fortress the portal has been reopened.[Closed Portal]"
#removesite -1
#delay 0
#end
#newevent
#rarity 5
#msg "Close portal.[Fortress of Bronze and Crystal]"
#addsite -1
#nolog
#notext
#end

#newevent
#rarity 5 -- Rarity 5 is required, or the spell may fail if it conflicts with another rarity always event
#req_ench 601 -- THIS IS CALLING THE ENCHANTMENT ID, AND MUST BE THE SAME AS IN THE NEXT SPELL
#req_unique 1
#req_indepok 1
#stealthcom 8070 --dummy crater event
#notext
#nolog
#end

#newevent
#rarity 5 -- Rarity 5 is required, or the spell may fail if it conflicts with another rarity always event
#req_mnr 8070 --crater dummy
#req_freesites 1 -- I think not adding this has the potential to crash the game. 
#req_capital 0
#req_unique 1
#req_indepok 1
#msg "As the great ice shield of Svalinn shatters large chunks rain down from the sky. The largest of these has landed in the province killing a significant portion of the population. Perhaps the magical ice can be harvested to offset the loss of tax revenue. [Svalinn Crater] "
#addsite -1
#2d6vis 2 --2d6 W gems
#kill 30
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#2d4vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#2d4vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d6vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d6vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d6vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d3vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d3vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d3vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d3vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d3vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d3vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#delay 1
#end
#newevent
#rarity 5
#req_land 1
#1d3vis 2 --W gems
#msg "The wreckage of the great ice shield in the sky still rains down debris. Some of it turned out to be magical gems that have been handed over to the treasury."
#end


#newevent
#rarity 5
#req_noench 602 --fixed Svalinn
#req_nomnr 8063 --dummy that dies in three months
#req_site 1
#req_indepok 1
#msg "[Svalinn Crater]"
#notext
#nolog
#worlddecscale 2 --H +1
#stealthcom 8063
#end

#newevent
#rarity 5
#req_noench 602 --fixed Svalinn
#req_nomnr 8064 --dummy that dies in six months
#req_site 1
#req_indepok 1
#msg "[Svalinn Crater]"
#notext
#nolog
#worldincscale 3 --D +1
#stealthcom 8064
#end



---NATION
#selectnation 191
#name "Ginnungaheim"
#epithet "Architects of the Rainbow Bridge"
#era 1
#descr "The Ljostursar existed before the first living being was born and the world was made. Born from the sparks of the Muspelheim, home of the forge of creation, they served the first Pantokrator For him they designed the night sky, the planets, the stars and the bridge between them all. The Bifrost was their greatest creation, a shimmering road between the realms.

After their creation they fashioned themselves bodies so they could move between realms themselves. This enraged the Pantokrator for he had not intended them to leave their home. He imprisoned them with their new bodies but they've felt their bonds weaken. The strongest have now freed themselves. They can now travel the realms to reshape the world in their own design."

#summary "Race: Stellar giants who do not require food and can shine as bright as the sun.
Military: Flaming weapons, magical armor. 
Magic: Astral, Earth and Fire.
Priests: Average, powerful casters with awe."

#brief "Giants who mastered star crafting based on Germanic myths."
#color 0.93 0.32 0.05
#secondarycolor 0.80 0.80 0.80
#idealcold 0
#flag "./Ginnungaheim/Flag.tga"

#startsite "Bifrost"
#startsite "Forge of Creation"
#startsite "Capital of Bronze and Crystal"
#futuresite "Ljostursar Fortress recruitment"

#fortera 1
#templepic 17

#buildfort 15 --giant forts
#homefort 8 --castle of bronze and crystal

#aifirenation
#aiastralnation

#likespop 106 --nexus



-- Gods
#homerealm 1
#homerealm 10


#addgod 2980 --uttervast
#addgod 8071 --idol sun
#addgod 8072 --greater jarl
#cheapgod20 8072



-- Heroes
#hero1 8068 --Halogi
#hero2 8065 --Glenr
#hero3 8069 --Mundilfari


-- Commanders






-- Troops 

#addrecunit 8055 --mane



-- Starting Units

#startcom 8059 --Jarl
#startunittype1 8050
#startunitnbrs1  3
#startunittype2 8051
#startunitnbrs2  3
#startscout 8060 --wandilaz

-- PD 

#defcom1 8059 --Jarl
#defcom2 8057 --vala
#defunit1 8050
#defunit1b 8051
#defunit2 8053 --star thrower


#wallcom 8057 --vala
#wallunit 8053
#wallmult 1
#guardcom 8059 --jarl
#guardunit 8052 --gatekeeper
#guardmult 1

#end

#end 

#end


